/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ButtonBarLayout
extends LinearLayout
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int PEEK_BUTTON_DP = 16;
    private boolean mAllowStacking;
    private int mLastWidthSize;
    private int mMinimumHeight;

    private void $$robo$$com_android_internal_widget_ButtonBarLayout$__constructor__(Context context, AttributeSet attrs) {
        this.mLastWidthSize = -1;
        this.mMinimumHeight = 0;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ButtonBarLayout);
        this.mAllowStacking = ta.getBoolean(0, true);
        ta.recycle();
    }

    private final void $$robo$$com_android_internal_widget_ButtonBarLayout$setAllowStacking(boolean allowStacking) {
        if (this.mAllowStacking != allowStacking) {
            this.mAllowStacking = allowStacking;
            if (!this.mAllowStacking && this.getOrientation() == 1) {
                this.setStacked(false);
            }
            this.requestLayout();
        }
    }

    private final void $$robo$$com_android_internal_widget_ButtonBarLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth;
        int measuredWidthState;
        int initialWidthMeasureSpec;
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        if (this.mAllowStacking) {
            if (widthSize > this.mLastWidthSize && this.isStacked()) {
                this.setStacked(false);
            }
            this.mLastWidthSize = widthSize;
        }
        boolean needsRemeasure = false;
        if (!this.isStacked() && View.MeasureSpec.getMode(widthMeasureSpec) == 0x40000000) {
            initialWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(widthSize, Integer.MIN_VALUE);
            needsRemeasure = true;
        } else {
            initialWidthMeasureSpec = widthMeasureSpec;
        }
        super.onMeasure(initialWidthMeasureSpec, heightMeasureSpec);
        if (this.mAllowStacking && !this.isStacked() && (measuredWidthState = (measuredWidth = this.getMeasuredWidthAndState()) & 0xFF000000) == 0x1000000) {
            this.setStacked(true);
            needsRemeasure = true;
        }
        if (needsRemeasure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
        int minHeight = 0;
        int firstVisible = this.getNextVisibleChildIndex(0);
        if (firstVisible >= 0) {
            View firstButton = this.getChildAt(firstVisible);
            LinearLayout.LayoutParams firstParams = (LinearLayout.LayoutParams)firstButton.getLayoutParams();
            minHeight += this.getPaddingTop() + firstButton.getMeasuredHeight() + firstParams.topMargin + firstParams.bottomMargin;
            if (this.isStacked()) {
                int secondVisible = this.getNextVisibleChildIndex(firstVisible + 1);
                if (secondVisible >= 0) {
                    minHeight = (int)((float)minHeight + ((float)this.getChildAt(secondVisible).getPaddingTop() + 16.0f * this.getResources().getDisplayMetrics().density));
                }
            } else {
                minHeight += this.getPaddingBottom();
            }
        }
        if (this.getMinimumHeight() != minHeight) {
            this.setMinimumHeight(minHeight);
        }
    }

    private final int $$robo$$com_android_internal_widget_ButtonBarLayout$getNextVisibleChildIndex(int index) {
        int count = this.getChildCount();
        for (int i = index; i < count; ++i) {
            if (this.getChildAt(i).getVisibility() != 0) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$com_android_internal_widget_ButtonBarLayout$getMinimumHeight() {
        return Math.max(this.mMinimumHeight, super.getMinimumHeight());
    }

    private final void $$robo$$com_android_internal_widget_ButtonBarLayout$setStacked(boolean stacked) {
        this.setOrientation(stacked ? 1 : 0);
        this.setGravity(stacked ? 0x800005 : 80);
        Object spacer = this.findViewById(16909328);
        if (spacer != null) {
            ((View)spacer).setVisibility(stacked ? 8 : 4);
        }
        int childCount = this.getChildCount();
        for (int i = childCount - 2; i >= 0; --i) {
            this.bringChildToFront(this.getChildAt(i));
        }
    }

    private final boolean $$robo$$com_android_internal_widget_ButtonBarLayout$isStacked() {
        return this.getOrientation() == 1;
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_ButtonBarLayout$__constructor__(context, attributeSet);
    }

    public ButtonBarLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ButtonBarLayout$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    public void setAllowStacking(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowStacking", $$robo$$com_android_internal_widget_ButtonBarLayout$setAllowStacking(boolean ), this, bl);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_ButtonBarLayout$onMeasure(int int ), this, n, n2);
    }

    private int getNextVisibleChildIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getNextVisibleChildIndex", $$robo$$com_android_internal_widget_ButtonBarLayout$getNextVisibleChildIndex(int ), this, n);
    }

    @Override
    public int getMinimumHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumHeight", $$robo$$com_android_internal_widget_ButtonBarLayout$getMinimumHeight(), this);
    }

    private void setStacked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStacked", $$robo$$com_android_internal_widget_ButtonBarLayout$setStacked(boolean ), this, bl);
    }

    private boolean isStacked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStacked", $$robo$$com_android_internal_widget_ButtonBarLayout$isStacked(), this);
    }

    public /* synthetic */ ButtonBarLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ButtonBarLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

