/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Size;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.ArrayAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class FloatingToolbar
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String FLOATING_TOOLBAR_TAG = "floating_toolbar";
    private static MenuItem.OnMenuItemClickListener NO_OP_MENUITEM_CLICK_LISTENER;
    private Context mContext;
    private Window mWindow;
    private FloatingToolbarPopup mPopup;
    private Rect mContentRect;
    private Rect mPreviousContentRect;
    private Menu mMenu;
    private List<MenuItem> mShowingMenuItems;
    private MenuItem.OnMenuItemClickListener mMenuItemClickListener;
    private int mSuggestedWidth;
    private boolean mWidthChanged;
    private View.OnLayoutChangeListener mOrientationChangeHandler;
    private Comparator<MenuItem> mMenuItemComparator;

    private void $$robo$$com_android_internal_widget_FloatingToolbar$__constructor__(Window window) {
        this.mContentRect = new Rect();
        this.mPreviousContentRect = new Rect();
        this.mShowingMenuItems = new ArrayList<MenuItem>();
        this.mMenuItemClickListener = NO_OP_MENUITEM_CLICK_LISTENER;
        this.mWidthChanged = true;
        this.mOrientationChangeHandler = new View.OnLayoutChangeListener(this){
            public /* synthetic */ Object __robo_data__;
            private Rect mNewRect;
            private Rect mOldRect;
            /* synthetic */ FloatingToolbar this$0;

            private void $$robo$$com_android_internal_widget_FloatingToolbar_1$__constructor__(FloatingToolbar this$0) {
                this.this$0 = this$0;
                this.mNewRect = new Rect();
                this.mOldRect = new Rect();
            }

            private final void $$robo$$com_android_internal_widget_FloatingToolbar_1$onLayoutChange(View view, int newLeft, int newRight, int newTop, int newBottom, int oldLeft, int oldRight, int oldTop, int oldBottom) {
                this.mNewRect.set(newLeft, newRight, newTop, newBottom);
                this.mOldRect.set(oldLeft, oldRight, oldTop, oldBottom);
                if (this.this$0.mPopup.isShowing() && !this.mNewRect.equals(this.mOldRect)) {
                    this.this$0.mWidthChanged = true;
                    this.this$0.updateLayout();
                }
            }

            private void __constructor__(FloatingToolbar floatingToolbar) {
                this.$$robo$$com_android_internal_widget_FloatingToolbar_1$__constructor__(floatingToolbar);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_1$__constructor__(com.android.internal.widget.FloatingToolbar ), this, floatingToolbar);
            }

            @Override
            public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                InvokeDynamicSupport.bootstrap("onLayoutChange", $$robo$$com_android_internal_widget_FloatingToolbar_1$onLayoutChange(android.view.View int int int int int int int int ), this, view, n, n2, n3, n4, n5, n6, n7, n8);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mMenuItemComparator = (menuItem1, menuItem2) -> {
            if (menuItem1.getItemId() == 16908353) {
                return menuItem2.getItemId() == 16908353 ? 0 : -1;
            }
            if (menuItem2.getItemId() == 16908353) {
                return 1;
            }
            if (menuItem1.requiresActionButton()) {
                return menuItem2.requiresActionButton() ? 0 : -1;
            }
            if (menuItem2.requiresActionButton()) {
                return 1;
            }
            if (menuItem1.requiresOverflow()) {
                return menuItem2.requiresOverflow() ? 0 : 1;
            }
            if (menuItem2.requiresOverflow()) {
                return -1;
            }
            return menuItem1.getOrder() - menuItem2.getOrder();
        };
        this.mContext = FloatingToolbar.applyDefaultTheme(window.getContext());
        this.mWindow = Preconditions.checkNotNull(window);
        this.mPopup = new FloatingToolbarPopup(this.mContext, window.getDecorView());
    }

    private final FloatingToolbar $$robo$$com_android_internal_widget_FloatingToolbar$setMenu(Menu menu2) {
        this.mMenu = Preconditions.checkNotNull(menu2);
        return this;
    }

    private final FloatingToolbar $$robo$$com_android_internal_widget_FloatingToolbar$setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener menuItemClickListener) {
        this.mMenuItemClickListener = menuItemClickListener != null ? menuItemClickListener : NO_OP_MENUITEM_CLICK_LISTENER;
        return this;
    }

    private final FloatingToolbar $$robo$$com_android_internal_widget_FloatingToolbar$setContentRect(Rect rect) {
        this.mContentRect.set(Preconditions.checkNotNull(rect));
        return this;
    }

    private final FloatingToolbar $$robo$$com_android_internal_widget_FloatingToolbar$setSuggestedWidth(int suggestedWidth) {
        int difference = Math.abs(suggestedWidth - this.mSuggestedWidth);
        this.mWidthChanged = (double)difference > (double)this.mSuggestedWidth * 0.2;
        this.mSuggestedWidth = suggestedWidth;
        return this;
    }

    private final FloatingToolbar $$robo$$com_android_internal_widget_FloatingToolbar$show() {
        this.registerOrientationHandler();
        this.doShow();
        return this;
    }

    private final FloatingToolbar $$robo$$com_android_internal_widget_FloatingToolbar$updateLayout() {
        if (this.mPopup.isShowing()) {
            this.doShow();
        }
        return this;
    }

    private final void $$robo$$com_android_internal_widget_FloatingToolbar$dismiss() {
        this.unregisterOrientationHandler();
        this.mPopup.dismiss();
    }

    private final void $$robo$$com_android_internal_widget_FloatingToolbar$hide() {
        this.mPopup.hide();
    }

    private final boolean $$robo$$com_android_internal_widget_FloatingToolbar$isShowing() {
        return this.mPopup.isShowing();
    }

    private final boolean $$robo$$com_android_internal_widget_FloatingToolbar$isHidden() {
        return this.mPopup.isHidden();
    }

    private final void $$robo$$com_android_internal_widget_FloatingToolbar$setOutsideTouchable(boolean outsideTouchable, PopupWindow.OnDismissListener onDismiss) {
        if (this.mPopup.setOutsideTouchable(outsideTouchable, onDismiss) && this.isShowing()) {
            this.dismiss();
            this.doShow();
        }
    }

    private final void $$robo$$com_android_internal_widget_FloatingToolbar$doShow() {
        List<MenuItem> menuItems = this.getVisibleAndEnabledMenuItems(this.mMenu);
        menuItems.sort(this.mMenuItemComparator);
        if (!this.isCurrentlyShowing(menuItems) || this.mWidthChanged) {
            this.mPopup.dismiss();
            this.mPopup.layoutMenuItems(menuItems, this.mMenuItemClickListener, this.mSuggestedWidth);
            this.mShowingMenuItems = menuItems;
        }
        if (!this.mPopup.isShowing()) {
            this.mPopup.show(this.mContentRect);
        } else if (!this.mPreviousContentRect.equals(this.mContentRect)) {
            this.mPopup.updateCoordinates(this.mContentRect);
        }
        this.mWidthChanged = false;
        this.mPreviousContentRect.set(this.mContentRect);
    }

    private final boolean $$robo$$com_android_internal_widget_FloatingToolbar$isCurrentlyShowing(List<MenuItem> menuItems) {
        if (this.mShowingMenuItems == null || menuItems.size() != this.mShowingMenuItems.size()) {
            return false;
        }
        int size = menuItems.size();
        for (int i = 0; i < size; ++i) {
            MenuItem menuItem = menuItems.get(i);
            MenuItem showingItem = this.mShowingMenuItems.get(i);
            if (menuItem.getItemId() == showingItem.getItemId() && TextUtils.equals(menuItem.getTitle(), showingItem.getTitle()) && Objects.equals(menuItem.getIcon(), showingItem.getIcon()) && menuItem.getGroupId() == showingItem.getGroupId()) continue;
            return false;
        }
        return true;
    }

    private final List<MenuItem> $$robo$$com_android_internal_widget_FloatingToolbar$getVisibleAndEnabledMenuItems(Menu menu2) {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        for (int i = 0; menu2 != null && i < menu2.size(); ++i) {
            MenuItem menuItem = menu2.getItem(i);
            if (!menuItem.isVisible() || !menuItem.isEnabled()) continue;
            SubMenu subMenu = menuItem.getSubMenu();
            if (subMenu != null) {
                menuItems.addAll(this.getVisibleAndEnabledMenuItems(subMenu));
                continue;
            }
            menuItems.add(menuItem);
        }
        return menuItems;
    }

    private final void $$robo$$com_android_internal_widget_FloatingToolbar$registerOrientationHandler() {
        this.unregisterOrientationHandler();
        this.mWindow.getDecorView().addOnLayoutChangeListener(this.mOrientationChangeHandler);
    }

    private final void $$robo$$com_android_internal_widget_FloatingToolbar$unregisterOrientationHandler() {
        this.mWindow.getDecorView().removeOnLayoutChangeListener(this.mOrientationChangeHandler);
    }

    private static final View $$robo$$com_android_internal_widget_FloatingToolbar$createMenuItemButton(Context context, MenuItem menuItem, int iconTextSpacing, boolean showIcon) {
        View menuItemButton = LayoutInflater.from(context).inflate(17367140, null);
        if (menuItem != null) {
            FloatingToolbar.updateMenuItemButton(menuItemButton, menuItem, iconTextSpacing, showIcon);
        }
        return menuItemButton;
    }

    private static final void $$robo$$com_android_internal_widget_FloatingToolbar$updateMenuItemButton(View menuItemButton, MenuItem menuItem, int iconTextSpacing, boolean showIcon) {
        CharSequence contentDescription;
        TextView buttonText = (TextView)menuItemButton.findViewById(16908916);
        buttonText.setEllipsize(null);
        if (TextUtils.isEmpty(menuItem.getTitle())) {
            buttonText.setVisibility(8);
        } else {
            buttonText.setVisibility(0);
            buttonText.setText(menuItem.getTitle());
        }
        ImageView buttonIcon = (ImageView)menuItemButton.findViewById(16908914);
        if (menuItem.getIcon() == null || !showIcon) {
            buttonIcon.setVisibility(8);
            if (buttonText != null) {
                buttonText.setPaddingRelative(0, 0, 0, 0);
            }
        } else {
            buttonIcon.setVisibility(0);
            buttonIcon.setImageDrawable(menuItem.getIcon());
            if (buttonText != null) {
                buttonText.setPaddingRelative(iconTextSpacing, 0, 0, 0);
            }
        }
        if (TextUtils.isEmpty(contentDescription = menuItem.getContentDescription())) {
            menuItemButton.setContentDescription(menuItem.getTitle());
        } else {
            menuItemButton.setContentDescription(contentDescription);
        }
    }

    private static final ViewGroup $$robo$$com_android_internal_widget_FloatingToolbar$createContentContainer(Context context) {
        ViewGroup contentContainer = (ViewGroup)LayoutInflater.from(context).inflate(17367139, null);
        contentContainer.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        contentContainer.setTag("floating_toolbar");
        contentContainer.setClipToOutline(true);
        return contentContainer;
    }

    private static final PopupWindow $$robo$$com_android_internal_widget_FloatingToolbar$createPopupWindow(ViewGroup content) {
        LinearLayout popupContentHolder = new LinearLayout(content.getContext());
        PopupWindow popupWindow = new PopupWindow(popupContentHolder);
        popupWindow.setClippingEnabled(false);
        popupWindow.setWindowLayoutType(1005);
        popupWindow.setAnimationStyle(0);
        popupWindow.setBackgroundDrawable(new ColorDrawable(0));
        content.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        popupContentHolder.addView(content);
        return popupWindow;
    }

    private static final AnimatorSet $$robo$$com_android_internal_widget_FloatingToolbar$createEnterAnimation(View view) {
        AnimatorSet animation = new AnimatorSet();
        animation.playTogether(ObjectAnimator.ofFloat(view, View.ALPHA, 0.0f, 1.0f).setDuration(150L));
        return animation;
    }

    private static final AnimatorSet $$robo$$com_android_internal_widget_FloatingToolbar$createExitAnimation(View view, int startDelay, Animator.AnimatorListener listener) {
        AnimatorSet animation = new AnimatorSet();
        animation.playTogether(ObjectAnimator.ofFloat(view, View.ALPHA, 1.0f, 0.0f).setDuration(100L));
        animation.setStartDelay(startDelay);
        animation.addListener(listener);
        return animation;
    }

    private static final Context $$robo$$com_android_internal_widget_FloatingToolbar$applyDefaultTheme(Context originalContext) {
        TypedArray a = originalContext.obtainStyledAttributes(new int[]{17891412});
        boolean isLightTheme = a.getBoolean(0, true);
        int themeId = isLightTheme ? 16974123 : 16974120;
        a.recycle();
        return new ContextThemeWrapper(originalContext, themeId);
    }

    static void __staticInitializer__() {
        NO_OP_MENUITEM_CLICK_LISTENER = item -> false;
    }

    private void __constructor__(Window window) {
        this.$$robo$$com_android_internal_widget_FloatingToolbar$__constructor__(window);
    }

    public FloatingToolbar(Window window) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar$__constructor__(android.view.Window ), this, window);
    }

    public FloatingToolbar setMenu(Menu menu2) {
        return InvokeDynamicSupport.bootstrap("setMenu", $$robo$$com_android_internal_widget_FloatingToolbar$setMenu(android.view.Menu ), this, menu2);
    }

    public FloatingToolbar setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        return InvokeDynamicSupport.bootstrap("setOnMenuItemClickListener", $$robo$$com_android_internal_widget_FloatingToolbar$setOnMenuItemClickListener(android.view.MenuItem$OnMenuItemClickListener ), this, onMenuItemClickListener);
    }

    public FloatingToolbar setContentRect(Rect rect) {
        return InvokeDynamicSupport.bootstrap("setContentRect", $$robo$$com_android_internal_widget_FloatingToolbar$setContentRect(android.graphics.Rect ), this, rect);
    }

    public FloatingToolbar setSuggestedWidth(int n) {
        return InvokeDynamicSupport.bootstrap("setSuggestedWidth", $$robo$$com_android_internal_widget_FloatingToolbar$setSuggestedWidth(int ), this, n);
    }

    public FloatingToolbar show() {
        return InvokeDynamicSupport.bootstrap("show", $$robo$$com_android_internal_widget_FloatingToolbar$show(), this);
    }

    public FloatingToolbar updateLayout() {
        return InvokeDynamicSupport.bootstrap("updateLayout", $$robo$$com_android_internal_widget_FloatingToolbar$updateLayout(), this);
    }

    public void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$com_android_internal_widget_FloatingToolbar$dismiss(), this);
    }

    public void hide() {
        InvokeDynamicSupport.bootstrap("hide", $$robo$$com_android_internal_widget_FloatingToolbar$hide(), this);
    }

    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$com_android_internal_widget_FloatingToolbar$isShowing(), this);
    }

    public boolean isHidden() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHidden", $$robo$$com_android_internal_widget_FloatingToolbar$isHidden(), this);
    }

    public void setOutsideTouchable(boolean bl, PopupWindow.OnDismissListener onDismissListener) {
        InvokeDynamicSupport.bootstrap("setOutsideTouchable", $$robo$$com_android_internal_widget_FloatingToolbar$setOutsideTouchable(boolean android.widget.PopupWindow$OnDismissListener ), this, bl, onDismissListener);
    }

    private void doShow() {
        InvokeDynamicSupport.bootstrap("doShow", $$robo$$com_android_internal_widget_FloatingToolbar$doShow(), this);
    }

    private boolean isCurrentlyShowing(List<MenuItem> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCurrentlyShowing", $$robo$$com_android_internal_widget_FloatingToolbar$isCurrentlyShowing(java.util.List<android.view.MenuItem> ), this, list);
    }

    private List<MenuItem> getVisibleAndEnabledMenuItems(Menu menu2) {
        return InvokeDynamicSupport.bootstrap("getVisibleAndEnabledMenuItems", $$robo$$com_android_internal_widget_FloatingToolbar$getVisibleAndEnabledMenuItems(android.view.Menu ), this, menu2);
    }

    private void registerOrientationHandler() {
        InvokeDynamicSupport.bootstrap("registerOrientationHandler", $$robo$$com_android_internal_widget_FloatingToolbar$registerOrientationHandler(), this);
    }

    private void unregisterOrientationHandler() {
        InvokeDynamicSupport.bootstrap("unregisterOrientationHandler", $$robo$$com_android_internal_widget_FloatingToolbar$unregisterOrientationHandler(), this);
    }

    private static View createMenuItemButton(Context context, MenuItem menuItem, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createMenuItemButton", $$robo$$com_android_internal_widget_FloatingToolbar$createMenuItemButton(android.content.Context android.view.MenuItem int boolean ), (Context)context, (MenuItem)menuItem, (int)n, (boolean)bl);
    }

    private static void updateMenuItemButton(View view, MenuItem menuItem, int n, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("updateMenuItemButton", $$robo$$com_android_internal_widget_FloatingToolbar$updateMenuItemButton(android.view.View android.view.MenuItem int boolean ), (View)view, (MenuItem)menuItem, (int)n, (boolean)bl);
    }

    private static ViewGroup createContentContainer(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("createContentContainer", $$robo$$com_android_internal_widget_FloatingToolbar$createContentContainer(android.content.Context ), (Context)context);
    }

    private static PopupWindow createPopupWindow(ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrapStatic("createPopupWindow", $$robo$$com_android_internal_widget_FloatingToolbar$createPopupWindow(android.view.ViewGroup ), (ViewGroup)viewGroup);
    }

    private static AnimatorSet createEnterAnimation(View view) {
        return InvokeDynamicSupport.bootstrapStatic("createEnterAnimation", $$robo$$com_android_internal_widget_FloatingToolbar$createEnterAnimation(android.view.View ), (View)view);
    }

    private static AnimatorSet createExitAnimation(View view, int n, Animator.AnimatorListener animatorListener) {
        return InvokeDynamicSupport.bootstrapStatic("createExitAnimation", $$robo$$com_android_internal_widget_FloatingToolbar$createExitAnimation(android.view.View int android.animation.Animator$AnimatorListener ), (View)view, (int)n, (Animator.AnimatorListener)animatorListener);
    }

    private static Context applyDefaultTheme(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("applyDefaultTheme", $$robo$$com_android_internal_widget_FloatingToolbar$applyDefaultTheme(android.content.Context ), (Context)context);
    }

    static {
        RobolectricInternals.classInitializing(FloatingToolbar.class);
    }

    public /* synthetic */ FloatingToolbar() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FloatingToolbar)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class FloatingToolbarPopup
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int MIN_OVERFLOW_SIZE = 2;
        private static int MAX_OVERFLOW_SIZE = 4;
        private Context mContext;
        private View mParent;
        private PopupWindow mPopupWindow;
        private int mMarginHorizontal;
        private int mMarginVertical;
        private ViewGroup mContentContainer;
        private ViewGroup mMainPanel;
        private OverflowPanel mOverflowPanel;
        private ImageButton mOverflowButton;
        private Drawable mArrow;
        private Drawable mOverflow;
        private AnimatedVectorDrawable mToArrow;
        private AnimatedVectorDrawable mToOverflow;
        private OverflowPanelViewHelper mOverflowPanelViewHelper;
        private Interpolator mLogAccelerateInterpolator;
        private Interpolator mFastOutSlowInInterpolator;
        private Interpolator mLinearOutSlowInInterpolator;
        private Interpolator mFastOutLinearInInterpolator;
        private AnimatorSet mShowAnimation;
        private AnimatorSet mDismissAnimation;
        private AnimatorSet mHideAnimation;
        private AnimationSet mOpenOverflowAnimation;
        private AnimationSet mCloseOverflowAnimation;
        private Animation.AnimationListener mOverflowAnimationListener;
        private Rect mViewPortOnScreen;
        private Point mCoordsOnWindow;
        private int[] mTmpCoords;
        private Region mTouchableRegion;
        private ViewTreeObserver.OnComputeInternalInsetsListener mInsetsComputer;
        private int mLineHeight;
        private int mIconTextSpacing;
        private Runnable mPreparePopupContentRTLHelper;
        private boolean mDismissed;
        private boolean mHidden;
        private Size mOverflowButtonSize;
        private Size mOverflowPanelSize;
        private Size mMainPanelSize;
        private MenuItem.OnMenuItemClickListener mOnMenuItemClickListener;
        private View.OnClickListener mMenuItemButtonOnClickListener;
        private boolean mOpenOverflowUpwards;
        private boolean mIsOverflowOpen;
        private int mTransitionDurationScale;

        private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$__constructor__(Context context, View parent) {
            this.mViewPortOnScreen = new Rect();
            this.mCoordsOnWindow = new Point();
            this.mTmpCoords = new int[2];
            this.mTouchableRegion = new Region();
            this.mInsetsComputer = info -> {
                info.contentInsets.setEmpty();
                info.visibleInsets.setEmpty();
                info.touchableRegion.set(this.mTouchableRegion);
                info.setTouchableInsets(3);
            };
            this.mPreparePopupContentRTLHelper = new Runnable(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_1$__constructor__(FloatingToolbarPopup this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_1$run() {
                    this.this$0.setPanelsStatesAtRestingPosition();
                    this.this$0.setContentAreaAsTouchableSurface();
                    this.this$0.mContentContainer.setAlpha(1.0f);
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_1$__constructor__(floatingToolbarPopup);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_1$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup ), this, floatingToolbarPopup);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_1$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mDismissed = true;
            this.mMenuItemButtonOnClickListener = new View.OnClickListener(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_2$__constructor__(FloatingToolbarPopup this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_2$onClick(View v) {
                    if (v.getTag() instanceof MenuItem && this.this$0.mOnMenuItemClickListener != null) {
                        this.this$0.mOnMenuItemClickListener.onMenuItemClick((MenuItem)v.getTag());
                    }
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_2$__constructor__(floatingToolbarPopup);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_2$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup ), this, floatingToolbarPopup);
                }

                @Override
                public void onClick(View view) {
                    InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_2$onClick(android.view.View ), this, view);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mParent = Preconditions.checkNotNull(parent);
            this.mContext = Preconditions.checkNotNull(context);
            this.mContentContainer = FloatingToolbar.createContentContainer(context);
            this.mPopupWindow = FloatingToolbar.createPopupWindow(this.mContentContainer);
            this.mMarginHorizontal = parent.getResources().getDimensionPixelSize(17105046);
            this.mMarginVertical = parent.getResources().getDimensionPixelSize(17105059);
            this.mLineHeight = context.getResources().getDimensionPixelSize(17105045);
            this.mIconTextSpacing = context.getResources().getDimensionPixelSize(17105047);
            this.mLogAccelerateInterpolator = new LogAccelerateInterpolator(null);
            this.mFastOutSlowInInterpolator = AnimationUtils.loadInterpolator(this.mContext, 17563661);
            this.mLinearOutSlowInInterpolator = AnimationUtils.loadInterpolator(this.mContext, 17563662);
            this.mFastOutLinearInInterpolator = AnimationUtils.loadInterpolator(this.mContext, 17563663);
            this.mArrow = this.mContext.getResources().getDrawable(17302234, this.mContext.getTheme());
            this.mArrow.setAutoMirrored(true);
            this.mOverflow = this.mContext.getResources().getDrawable(17302232, this.mContext.getTheme());
            this.mOverflow.setAutoMirrored(true);
            this.mToArrow = (AnimatedVectorDrawable)this.mContext.getResources().getDrawable(17302233, this.mContext.getTheme());
            this.mToArrow.setAutoMirrored(true);
            this.mToOverflow = (AnimatedVectorDrawable)this.mContext.getResources().getDrawable(17302235, this.mContext.getTheme());
            this.mToOverflow.setAutoMirrored(true);
            this.mOverflowButton = this.createOverflowButton();
            this.mOverflowButtonSize = FloatingToolbarPopup.measure(this.mOverflowButton);
            this.mMainPanel = this.createMainPanel();
            this.mOverflowPanelViewHelper = new OverflowPanelViewHelper(this.mContext, this.mIconTextSpacing);
            this.mOverflowPanel = this.createOverflowPanel();
            this.mOverflowAnimationListener = this.createOverflowAnimationListener();
            this.mOpenOverflowAnimation = new AnimationSet(true);
            this.mOpenOverflowAnimation.setAnimationListener(this.mOverflowAnimationListener);
            this.mCloseOverflowAnimation = new AnimationSet(true);
            this.mCloseOverflowAnimation.setAnimationListener(this.mOverflowAnimationListener);
            this.mShowAnimation = FloatingToolbar.createEnterAnimation(this.mContentContainer);
            this.mDismissAnimation = FloatingToolbar.createExitAnimation(this.mContentContainer, 150, (Animator.AnimatorListener)new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_3$__constructor__(FloatingToolbarPopup this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_3$onAnimationEnd(Animator animation) {
                    this.this$0.mPopupWindow.dismiss();
                    this.this$0.mContentContainer.removeAllViews();
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_3$__constructor__(floatingToolbarPopup);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_3$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup ), this, floatingToolbarPopup);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_3$onAnimationEnd(android.animation.Animator ), this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mHideAnimation = FloatingToolbar.createExitAnimation(this.mContentContainer, 0, (Animator.AnimatorListener)new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_4$__constructor__(FloatingToolbarPopup this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_4$onAnimationEnd(Animator animation) {
                    this.this$0.mPopupWindow.dismiss();
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_4$__constructor__(floatingToolbarPopup);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_4$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup ), this, floatingToolbarPopup);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_4$onAnimationEnd(android.animation.Animator ), this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final boolean $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setOutsideTouchable(boolean outsideTouchable, PopupWindow.OnDismissListener onDismiss) {
            boolean ret = false;
            if (this.mPopupWindow.isOutsideTouchable() ^ outsideTouchable) {
                this.mPopupWindow.setOutsideTouchable(outsideTouchable);
                this.mPopupWindow.setFocusable(!outsideTouchable);
                ret = true;
            }
            this.mPopupWindow.setOnDismissListener(onDismiss);
            return ret;
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$layoutMenuItems(List<MenuItem> menuItems, MenuItem.OnMenuItemClickListener menuItemClickListener, int suggestedWidth) {
            this.mOnMenuItemClickListener = menuItemClickListener;
            this.cancelOverflowAnimations();
            this.clearPanels();
            menuItems = this.layoutMainPanelItems(menuItems, this.getAdjustedToolbarWidth(suggestedWidth));
            if (!menuItems.isEmpty()) {
                this.layoutOverflowPanelItems(menuItems);
            }
            this.updatePopupSize();
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$show(Rect contentRectOnScreen) {
            Preconditions.checkNotNull(contentRectOnScreen);
            if (this.isShowing()) {
                return;
            }
            this.mHidden = false;
            this.mDismissed = false;
            this.cancelDismissAndHideAnimations();
            this.cancelOverflowAnimations();
            this.refreshCoordinatesAndOverflowDirection(contentRectOnScreen);
            this.preparePopupContent();
            this.mPopupWindow.showAtLocation(this.mParent, 0, this.mCoordsOnWindow.x, this.mCoordsOnWindow.y);
            this.setTouchableSurfaceInsetsComputer();
            this.runShowAnimation();
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$dismiss() {
            if (this.mDismissed) {
                return;
            }
            this.mHidden = false;
            this.mDismissed = true;
            this.mHideAnimation.cancel();
            this.runDismissAnimation();
            this.setZeroTouchableSurface();
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$hide() {
            if (!this.isShowing()) {
                return;
            }
            this.mHidden = true;
            this.runHideAnimation();
            this.setZeroTouchableSurface();
        }

        private final boolean $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$isShowing() {
            return !this.mDismissed && !this.mHidden;
        }

        private final boolean $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$isHidden() {
            return this.mHidden;
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$updateCoordinates(Rect contentRectOnScreen) {
            Preconditions.checkNotNull(contentRectOnScreen);
            if (!this.isShowing() || !this.mPopupWindow.isShowing()) {
                return;
            }
            this.cancelOverflowAnimations();
            this.refreshCoordinatesAndOverflowDirection(contentRectOnScreen);
            this.preparePopupContent();
            this.mPopupWindow.update(this.mCoordsOnWindow.x, this.mCoordsOnWindow.y, this.mPopupWindow.getWidth(), this.mPopupWindow.getHeight());
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$refreshCoordinatesAndOverflowDirection(Rect contentRectOnScreen) {
            int y;
            this.refreshViewPort();
            int x = Math.min(contentRectOnScreen.centerX() - this.mPopupWindow.getWidth() / 2, this.mViewPortOnScreen.right - this.mPopupWindow.getWidth());
            int availableHeightAboveContent = contentRectOnScreen.top - this.mViewPortOnScreen.top;
            int availableHeightBelowContent = this.mViewPortOnScreen.bottom - contentRectOnScreen.bottom;
            int margin = 2 * this.mMarginVertical;
            int toolbarHeightWithVerticalMargin = this.mLineHeight + margin;
            if (!this.hasOverflow()) {
                y = availableHeightAboveContent >= toolbarHeightWithVerticalMargin ? contentRectOnScreen.top - toolbarHeightWithVerticalMargin : (availableHeightBelowContent >= toolbarHeightWithVerticalMargin ? contentRectOnScreen.bottom : (availableHeightBelowContent >= this.mLineHeight ? contentRectOnScreen.bottom - this.mMarginVertical : Math.max(this.mViewPortOnScreen.top, contentRectOnScreen.top - toolbarHeightWithVerticalMargin)));
            } else {
                int minimumOverflowHeightWithMargin = this.calculateOverflowHeight(2) + margin;
                int availableHeightThroughContentDown = this.mViewPortOnScreen.bottom - contentRectOnScreen.top + toolbarHeightWithVerticalMargin;
                int availableHeightThroughContentUp = contentRectOnScreen.bottom - this.mViewPortOnScreen.top + toolbarHeightWithVerticalMargin;
                if (availableHeightAboveContent >= minimumOverflowHeightWithMargin) {
                    this.updateOverflowHeight(availableHeightAboveContent - margin);
                    y = contentRectOnScreen.top - this.mPopupWindow.getHeight();
                    this.mOpenOverflowUpwards = true;
                } else if (availableHeightAboveContent >= toolbarHeightWithVerticalMargin && availableHeightThroughContentDown >= minimumOverflowHeightWithMargin) {
                    this.updateOverflowHeight(availableHeightThroughContentDown - margin);
                    y = contentRectOnScreen.top - toolbarHeightWithVerticalMargin;
                    this.mOpenOverflowUpwards = false;
                } else if (availableHeightBelowContent >= minimumOverflowHeightWithMargin) {
                    this.updateOverflowHeight(availableHeightBelowContent - margin);
                    y = contentRectOnScreen.bottom;
                    this.mOpenOverflowUpwards = false;
                } else if (availableHeightBelowContent >= toolbarHeightWithVerticalMargin && this.mViewPortOnScreen.height() >= minimumOverflowHeightWithMargin) {
                    this.updateOverflowHeight(availableHeightThroughContentUp - margin);
                    y = contentRectOnScreen.bottom + toolbarHeightWithVerticalMargin - this.mPopupWindow.getHeight();
                    this.mOpenOverflowUpwards = true;
                } else {
                    this.updateOverflowHeight(this.mViewPortOnScreen.height() - margin);
                    y = this.mViewPortOnScreen.top;
                    this.mOpenOverflowUpwards = false;
                }
            }
            this.mParent.getRootView().getLocationOnScreen(this.mTmpCoords);
            int rootViewLeftOnScreen = this.mTmpCoords[0];
            int rootViewTopOnScreen = this.mTmpCoords[1];
            this.mParent.getRootView().getLocationInWindow(this.mTmpCoords);
            int rootViewLeftOnWindow = this.mTmpCoords[0];
            int rootViewTopOnWindow = this.mTmpCoords[1];
            int windowLeftOnScreen = rootViewLeftOnScreen - rootViewLeftOnWindow;
            int windowTopOnScreen = rootViewTopOnScreen - rootViewTopOnWindow;
            this.mCoordsOnWindow.set(Math.max(0, x - windowLeftOnScreen), Math.max(0, y - windowTopOnScreen));
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$runShowAnimation() {
            this.mShowAnimation.start();
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$runDismissAnimation() {
            this.mDismissAnimation.start();
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$runHideAnimation() {
            this.mHideAnimation.start();
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$cancelDismissAndHideAnimations() {
            this.mDismissAnimation.cancel();
            this.mHideAnimation.cancel();
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$cancelOverflowAnimations() {
            this.mContentContainer.clearAnimation();
            this.mMainPanel.animate().cancel();
            this.mOverflowPanel.animate().cancel();
            this.mToArrow.stop();
            this.mToOverflow.stop();
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$openOverflow() {
            int targetWidth = this.mOverflowPanelSize.getWidth();
            int targetHeight = this.mOverflowPanelSize.getHeight();
            int startWidth = this.mContentContainer.getWidth();
            int startHeight = this.mContentContainer.getHeight();
            float startY = this.mContentContainer.getY();
            float left = this.mContentContainer.getX();
            float right = left + (float)this.mContentContainer.getWidth();
            ShadowedObject widthAnimation = new ShadowedObject(this, targetWidth, startWidth, left, right){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$targetWidth;
                /* synthetic */ int val$startWidth;
                /* synthetic */ float val$left;
                /* synthetic */ float val$right;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_5$__constructor__(FloatingToolbarPopup this$0, int n, int n2, float f, float f2) {
                    this.this$0 = this$0;
                    this.val$targetWidth = n;
                    this.val$startWidth = n2;
                    this.val$left = f;
                    this.val$right = f2;
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_5$applyTransformation(float interpolatedTime, Transformation t) {
                    int deltaWidth = (int)(interpolatedTime * (float)(this.val$targetWidth - this.val$startWidth));
                    FloatingToolbarPopup.setWidth(this.this$0.mContentContainer, this.val$startWidth + deltaWidth);
                    if (this.this$0.isInRTLMode()) {
                        this.this$0.mContentContainer.setX(this.val$left);
                        this.this$0.mMainPanel.setX(0.0f);
                        this.this$0.mOverflowPanel.setX(0.0f);
                    } else {
                        this.this$0.mContentContainer.setX(this.val$right - (float)this.this$0.mContentContainer.getWidth());
                        this.this$0.mMainPanel.setX(this.this$0.mContentContainer.getWidth() - this.val$startWidth);
                        this.this$0.mOverflowPanel.setX(this.this$0.mContentContainer.getWidth() - this.val$targetWidth);
                    }
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup, int n, int n2, float f, float f2) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_5$__constructor__(floatingToolbarPopup, n, n2, f, f2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_5$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup int int float float ), this, floatingToolbarPopup, n, n2, f, f2);
                }

                @Override
                protected void applyTransformation(float f, Transformation transformation) {
                    InvokeDynamicSupport.bootstrap("applyTransformation", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_5$applyTransformation(float android.view.animation.Transformation ), this, f, transformation);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            ShadowedObject heightAnimation = new ShadowedObject(this, targetHeight, startHeight, startY){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$targetHeight;
                /* synthetic */ int val$startHeight;
                /* synthetic */ float val$startY;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_6$__constructor__(FloatingToolbarPopup this$0, int n, int n2, float f) {
                    this.this$0 = this$0;
                    this.val$targetHeight = n;
                    this.val$startHeight = n2;
                    this.val$startY = f;
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_6$applyTransformation(float interpolatedTime, Transformation t) {
                    int deltaHeight = (int)(interpolatedTime * (float)(this.val$targetHeight - this.val$startHeight));
                    FloatingToolbarPopup.setHeight(this.this$0.mContentContainer, this.val$startHeight + deltaHeight);
                    if (this.this$0.mOpenOverflowUpwards) {
                        this.this$0.mContentContainer.setY(this.val$startY - (float)(this.this$0.mContentContainer.getHeight() - this.val$startHeight));
                        this.this$0.positionContentYCoordinatesIfOpeningOverflowUpwards();
                    }
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup, int n, int n2, float f) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_6$__constructor__(floatingToolbarPopup, n, n2, f);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_6$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup int int float ), this, floatingToolbarPopup, n, n2, f);
                }

                @Override
                protected void applyTransformation(float f, Transformation transformation) {
                    InvokeDynamicSupport.bootstrap("applyTransformation", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_6$applyTransformation(float android.view.animation.Transformation ), this, f, transformation);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            float overflowButtonStartX = this.mOverflowButton.getX();
            float overflowButtonTargetX = this.isInRTLMode() ? overflowButtonStartX + (float)targetWidth - (float)this.mOverflowButton.getWidth() : overflowButtonStartX - (float)targetWidth + (float)this.mOverflowButton.getWidth();
            ShadowedObject overflowButtonAnimation = new ShadowedObject(this, overflowButtonStartX, overflowButtonTargetX, startWidth){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ float val$overflowButtonStartX;
                /* synthetic */ float val$overflowButtonTargetX;
                /* synthetic */ int val$startWidth;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_7$__constructor__(FloatingToolbarPopup this$0, float f, float f2, int n) {
                    this.this$0 = this$0;
                    this.val$overflowButtonStartX = f;
                    this.val$overflowButtonTargetX = f2;
                    this.val$startWidth = n;
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_7$applyTransformation(float interpolatedTime, Transformation t) {
                    float overflowButtonX = this.val$overflowButtonStartX + interpolatedTime * (this.val$overflowButtonTargetX - this.val$overflowButtonStartX);
                    float deltaContainerWidth = this.this$0.isInRTLMode() ? 0.0f : (float)(this.this$0.mContentContainer.getWidth() - this.val$startWidth);
                    float actualOverflowButtonX = overflowButtonX + deltaContainerWidth;
                    this.this$0.mOverflowButton.setX(actualOverflowButtonX);
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup, float f, float f2, int n) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_7$__constructor__(floatingToolbarPopup, f, f2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_7$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup float float int ), this, floatingToolbarPopup, f, f2, n);
                }

                @Override
                protected void applyTransformation(float f, Transformation transformation) {
                    InvokeDynamicSupport.bootstrap("applyTransformation", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_7$applyTransformation(float android.view.animation.Transformation ), this, f, transformation);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            widthAnimation.setInterpolator(this.mLogAccelerateInterpolator);
            widthAnimation.setDuration(this.getAdjustedDuration(250));
            heightAnimation.setInterpolator(this.mFastOutSlowInInterpolator);
            heightAnimation.setDuration(this.getAdjustedDuration(250));
            overflowButtonAnimation.setInterpolator(this.mFastOutSlowInInterpolator);
            overflowButtonAnimation.setDuration(this.getAdjustedDuration(250));
            this.mOpenOverflowAnimation.getAnimations().clear();
            this.mOpenOverflowAnimation.getAnimations().clear();
            this.mOpenOverflowAnimation.addAnimation((Animation)widthAnimation);
            this.mOpenOverflowAnimation.addAnimation((Animation)heightAnimation);
            this.mOpenOverflowAnimation.addAnimation((Animation)overflowButtonAnimation);
            this.mContentContainer.startAnimation(this.mOpenOverflowAnimation);
            this.mIsOverflowOpen = true;
            this.mMainPanel.animate().alpha(0.0f).withLayer().setInterpolator(this.mLinearOutSlowInInterpolator).setDuration(250L).start();
            this.mOverflowPanel.setAlpha(1.0f);
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$closeOverflow() {
            int targetWidth = this.mMainPanelSize.getWidth();
            int startWidth = this.mContentContainer.getWidth();
            float left = this.mContentContainer.getX();
            float right = left + (float)this.mContentContainer.getWidth();
            ShadowedObject widthAnimation = new ShadowedObject(this, targetWidth, startWidth, left, right){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$targetWidth;
                /* synthetic */ int val$startWidth;
                /* synthetic */ float val$left;
                /* synthetic */ float val$right;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_8$__constructor__(FloatingToolbarPopup this$0, int n, int n2, float f, float f2) {
                    this.this$0 = this$0;
                    this.val$targetWidth = n;
                    this.val$startWidth = n2;
                    this.val$left = f;
                    this.val$right = f2;
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_8$applyTransformation(float interpolatedTime, Transformation t) {
                    int deltaWidth = (int)(interpolatedTime * (float)(this.val$targetWidth - this.val$startWidth));
                    FloatingToolbarPopup.setWidth(this.this$0.mContentContainer, this.val$startWidth + deltaWidth);
                    if (this.this$0.isInRTLMode()) {
                        this.this$0.mContentContainer.setX(this.val$left);
                        this.this$0.mMainPanel.setX(0.0f);
                        this.this$0.mOverflowPanel.setX(0.0f);
                    } else {
                        this.this$0.mContentContainer.setX(this.val$right - (float)this.this$0.mContentContainer.getWidth());
                        this.this$0.mMainPanel.setX(this.this$0.mContentContainer.getWidth() - this.val$targetWidth);
                        this.this$0.mOverflowPanel.setX(this.this$0.mContentContainer.getWidth() - this.val$startWidth);
                    }
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup, int n, int n2, float f, float f2) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_8$__constructor__(floatingToolbarPopup, n, n2, f, f2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_8$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup int int float float ), this, floatingToolbarPopup, n, n2, f, f2);
                }

                @Override
                protected void applyTransformation(float f, Transformation transformation) {
                    InvokeDynamicSupport.bootstrap("applyTransformation", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_8$applyTransformation(float android.view.animation.Transformation ), this, f, transformation);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            int targetHeight = this.mMainPanelSize.getHeight();
            int startHeight = this.mContentContainer.getHeight();
            float bottom = this.mContentContainer.getY() + (float)this.mContentContainer.getHeight();
            ShadowedObject heightAnimation = new ShadowedObject(this, targetHeight, startHeight, bottom){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$targetHeight;
                /* synthetic */ int val$startHeight;
                /* synthetic */ float val$bottom;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_9$__constructor__(FloatingToolbarPopup this$0, int n, int n2, float f) {
                    this.this$0 = this$0;
                    this.val$targetHeight = n;
                    this.val$startHeight = n2;
                    this.val$bottom = f;
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_9$applyTransformation(float interpolatedTime, Transformation t) {
                    int deltaHeight = (int)(interpolatedTime * (float)(this.val$targetHeight - this.val$startHeight));
                    FloatingToolbarPopup.setHeight(this.this$0.mContentContainer, this.val$startHeight + deltaHeight);
                    if (this.this$0.mOpenOverflowUpwards) {
                        this.this$0.mContentContainer.setY(this.val$bottom - (float)this.this$0.mContentContainer.getHeight());
                        this.this$0.positionContentYCoordinatesIfOpeningOverflowUpwards();
                    }
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup, int n, int n2, float f) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_9$__constructor__(floatingToolbarPopup, n, n2, f);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_9$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup int int float ), this, floatingToolbarPopup, n, n2, f);
                }

                @Override
                protected void applyTransformation(float f, Transformation transformation) {
                    InvokeDynamicSupport.bootstrap("applyTransformation", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_9$applyTransformation(float android.view.animation.Transformation ), this, f, transformation);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            float overflowButtonStartX = this.mOverflowButton.getX();
            float overflowButtonTargetX = this.isInRTLMode() ? overflowButtonStartX - (float)startWidth + (float)this.mOverflowButton.getWidth() : overflowButtonStartX + (float)startWidth - (float)this.mOverflowButton.getWidth();
            ShadowedObject overflowButtonAnimation = new ShadowedObject(this, overflowButtonStartX, overflowButtonTargetX, startWidth){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ float val$overflowButtonStartX;
                /* synthetic */ float val$overflowButtonTargetX;
                /* synthetic */ int val$startWidth;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_10$__constructor__(FloatingToolbarPopup this$0, float f, float f2, int n) {
                    this.this$0 = this$0;
                    this.val$overflowButtonStartX = f;
                    this.val$overflowButtonTargetX = f2;
                    this.val$startWidth = n;
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_10$applyTransformation(float interpolatedTime, Transformation t) {
                    float overflowButtonX = this.val$overflowButtonStartX + interpolatedTime * (this.val$overflowButtonTargetX - this.val$overflowButtonStartX);
                    float deltaContainerWidth = this.this$0.isInRTLMode() ? 0.0f : (float)(this.this$0.mContentContainer.getWidth() - this.val$startWidth);
                    float actualOverflowButtonX = overflowButtonX + deltaContainerWidth;
                    this.this$0.mOverflowButton.setX(actualOverflowButtonX);
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup, float f, float f2, int n) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_10$__constructor__(floatingToolbarPopup, f, f2, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_10$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup float float int ), this, floatingToolbarPopup, f, f2, n);
                }

                @Override
                protected void applyTransformation(float f, Transformation transformation) {
                    InvokeDynamicSupport.bootstrap("applyTransformation", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_10$applyTransformation(float android.view.animation.Transformation ), this, f, transformation);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            widthAnimation.setInterpolator(this.mFastOutSlowInInterpolator);
            widthAnimation.setDuration(this.getAdjustedDuration(250));
            heightAnimation.setInterpolator(this.mLogAccelerateInterpolator);
            heightAnimation.setDuration(this.getAdjustedDuration(250));
            overflowButtonAnimation.setInterpolator(this.mFastOutSlowInInterpolator);
            overflowButtonAnimation.setDuration(this.getAdjustedDuration(250));
            this.mCloseOverflowAnimation.getAnimations().clear();
            this.mCloseOverflowAnimation.addAnimation((Animation)widthAnimation);
            this.mCloseOverflowAnimation.addAnimation((Animation)heightAnimation);
            this.mCloseOverflowAnimation.addAnimation((Animation)overflowButtonAnimation);
            this.mContentContainer.startAnimation(this.mCloseOverflowAnimation);
            this.mIsOverflowOpen = false;
            this.mMainPanel.animate().alpha(1.0f).withLayer().setInterpolator(this.mFastOutLinearInInterpolator).setDuration(100L).start();
            this.mOverflowPanel.animate().alpha(0.0f).withLayer().setInterpolator(this.mLinearOutSlowInInterpolator).setDuration(150L).start();
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setPanelsStatesAtRestingPosition() {
            this.mOverflowButton.setEnabled(true);
            this.mOverflowPanel.awakenScrollBars();
            if (this.mIsOverflowOpen) {
                Size containerSize = this.mOverflowPanelSize;
                FloatingToolbarPopup.setSize(this.mContentContainer, containerSize);
                this.mMainPanel.setAlpha(0.0f);
                this.mMainPanel.setVisibility(4);
                this.mOverflowPanel.setAlpha(1.0f);
                this.mOverflowPanel.setVisibility(0);
                this.mOverflowButton.setImageDrawable(this.mArrow);
                this.mOverflowButton.setContentDescription(this.mContext.getString(17039918));
                if (this.isInRTLMode()) {
                    this.mContentContainer.setX(this.mMarginHorizontal);
                    this.mMainPanel.setX(0.0f);
                    this.mOverflowButton.setX(containerSize.getWidth() - this.mOverflowButtonSize.getWidth());
                    this.mOverflowPanel.setX(0.0f);
                } else {
                    this.mContentContainer.setX(this.mPopupWindow.getWidth() - containerSize.getWidth() - this.mMarginHorizontal);
                    this.mMainPanel.setX(-this.mContentContainer.getX());
                    this.mOverflowButton.setX(0.0f);
                    this.mOverflowPanel.setX(0.0f);
                }
                if (this.mOpenOverflowUpwards) {
                    this.mContentContainer.setY(this.mMarginVertical);
                    this.mMainPanel.setY(containerSize.getHeight() - this.mContentContainer.getHeight());
                    this.mOverflowButton.setY(containerSize.getHeight() - this.mOverflowButtonSize.getHeight());
                    this.mOverflowPanel.setY(0.0f);
                } else {
                    this.mContentContainer.setY(this.mMarginVertical);
                    this.mMainPanel.setY(0.0f);
                    this.mOverflowButton.setY(0.0f);
                    this.mOverflowPanel.setY(this.mOverflowButtonSize.getHeight());
                }
            } else {
                Size containerSize = this.mMainPanelSize;
                FloatingToolbarPopup.setSize(this.mContentContainer, containerSize);
                this.mMainPanel.setAlpha(1.0f);
                this.mMainPanel.setVisibility(0);
                this.mOverflowPanel.setAlpha(0.0f);
                this.mOverflowPanel.setVisibility(4);
                this.mOverflowButton.setImageDrawable(this.mOverflow);
                this.mOverflowButton.setContentDescription(this.mContext.getString(17039919));
                if (this.hasOverflow()) {
                    if (this.isInRTLMode()) {
                        this.mContentContainer.setX(this.mMarginHorizontal);
                        this.mMainPanel.setX(0.0f);
                        this.mOverflowButton.setX(0.0f);
                        this.mOverflowPanel.setX(0.0f);
                    } else {
                        this.mContentContainer.setX(this.mPopupWindow.getWidth() - containerSize.getWidth() - this.mMarginHorizontal);
                        this.mMainPanel.setX(0.0f);
                        this.mOverflowButton.setX(containerSize.getWidth() - this.mOverflowButtonSize.getWidth());
                        this.mOverflowPanel.setX(containerSize.getWidth() - this.mOverflowPanelSize.getWidth());
                    }
                    if (this.mOpenOverflowUpwards) {
                        this.mContentContainer.setY(this.mMarginVertical + this.mOverflowPanelSize.getHeight() - containerSize.getHeight());
                        this.mMainPanel.setY(0.0f);
                        this.mOverflowButton.setY(0.0f);
                        this.mOverflowPanel.setY(containerSize.getHeight() - this.mOverflowPanelSize.getHeight());
                    } else {
                        this.mContentContainer.setY(this.mMarginVertical);
                        this.mMainPanel.setY(0.0f);
                        this.mOverflowButton.setY(0.0f);
                        this.mOverflowPanel.setY(this.mOverflowButtonSize.getHeight());
                    }
                } else {
                    this.mContentContainer.setX(this.mMarginHorizontal);
                    this.mContentContainer.setY(this.mMarginVertical);
                    this.mMainPanel.setX(0.0f);
                    this.mMainPanel.setY(0.0f);
                }
            }
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$updateOverflowHeight(int suggestedHeight) {
            if (this.hasOverflow()) {
                int maxItemSize = (suggestedHeight - this.mOverflowButtonSize.getHeight()) / this.mLineHeight;
                int newHeight = this.calculateOverflowHeight(maxItemSize);
                if (this.mOverflowPanelSize.getHeight() != newHeight) {
                    this.mOverflowPanelSize = new Size(this.mOverflowPanelSize.getWidth(), newHeight);
                }
                FloatingToolbarPopup.setSize(this.mOverflowPanel, this.mOverflowPanelSize);
                if (this.mIsOverflowOpen) {
                    FloatingToolbarPopup.setSize(this.mContentContainer, this.mOverflowPanelSize);
                    if (this.mOpenOverflowUpwards) {
                        int deltaHeight = this.mOverflowPanelSize.getHeight() - newHeight;
                        this.mContentContainer.setY(this.mContentContainer.getY() + (float)deltaHeight);
                        this.mOverflowButton.setY(this.mOverflowButton.getY() - (float)deltaHeight);
                    }
                } else {
                    FloatingToolbarPopup.setSize(this.mContentContainer, this.mMainPanelSize);
                }
                this.updatePopupSize();
            }
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$updatePopupSize() {
            int width = 0;
            int height = 0;
            if (this.mMainPanelSize != null) {
                width = Math.max(width, this.mMainPanelSize.getWidth());
                height = Math.max(height, this.mMainPanelSize.getHeight());
            }
            if (this.mOverflowPanelSize != null) {
                width = Math.max(width, this.mOverflowPanelSize.getWidth());
                height = Math.max(height, this.mOverflowPanelSize.getHeight());
            }
            this.mPopupWindow.setWidth(width + this.mMarginHorizontal * 2);
            this.mPopupWindow.setHeight(height + this.mMarginVertical * 2);
            this.maybeComputeTransitionDurationScale();
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$refreshViewPort() {
            this.mParent.getWindowVisibleDisplayFrame(this.mViewPortOnScreen);
        }

        private final int $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$getAdjustedToolbarWidth(int suggestedWidth) {
            int width = suggestedWidth;
            this.refreshViewPort();
            int maximumWidth = this.mViewPortOnScreen.width() - 2 * this.mParent.getResources().getDimensionPixelSize(17105046);
            if (width <= 0) {
                width = this.mParent.getResources().getDimensionPixelSize(17105057);
            }
            return Math.min(width, maximumWidth);
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setZeroTouchableSurface() {
            this.mTouchableRegion.setEmpty();
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setContentAreaAsTouchableSurface() {
            int height;
            int width;
            Preconditions.checkNotNull(this.mMainPanelSize);
            if (this.mIsOverflowOpen) {
                Preconditions.checkNotNull(this.mOverflowPanelSize);
                width = this.mOverflowPanelSize.getWidth();
                height = this.mOverflowPanelSize.getHeight();
            } else {
                width = this.mMainPanelSize.getWidth();
                height = this.mMainPanelSize.getHeight();
            }
            this.mTouchableRegion.set((int)this.mContentContainer.getX(), (int)this.mContentContainer.getY(), (int)this.mContentContainer.getX() + width, (int)this.mContentContainer.getY() + height);
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setTouchableSurfaceInsetsComputer() {
            ViewTreeObserver viewTreeObserver = this.mPopupWindow.getContentView().getRootView().getViewTreeObserver();
            viewTreeObserver.removeOnComputeInternalInsetsListener(this.mInsetsComputer);
            viewTreeObserver.addOnComputeInternalInsetsListener(this.mInsetsComputer);
        }

        private final boolean $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$isInRTLMode() {
            return this.mContext.getApplicationInfo().hasRtlSupport() && this.mContext.getResources().getConfiguration().getLayoutDirection() == 1;
        }

        private final boolean $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$hasOverflow() {
            return this.mOverflowPanelSize != null;
        }

        private final List<MenuItem> $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$layoutMainPanelItems(List<MenuItem> menuItems, int toolbarWidth) {
            Preconditions.checkNotNull(menuItems);
            int availableWidth = toolbarWidth;
            LinkedList<MenuItem> remainingMenuItems = new LinkedList<MenuItem>();
            LinkedList<MenuItem> overflowMenuItems = new LinkedList<MenuItem>();
            for (MenuItem menuItem : menuItems) {
                if (menuItem.getItemId() != 16908353 && menuItem.requiresOverflow()) {
                    overflowMenuItems.add(menuItem);
                    continue;
                }
                remainingMenuItems.add(menuItem);
            }
            remainingMenuItems.addAll(overflowMenuItems);
            this.mMainPanel.removeAllViews();
            this.mMainPanel.setPaddingRelative(0, 0, 0, 0);
            int lastGroupId = -1;
            boolean isFirstItem = true;
            while (!remainingMenuItems.isEmpty()) {
                boolean canFitNoOverflow;
                boolean isLastItem;
                MenuItem menuItem = (MenuItem)remainingMenuItems.peek();
                if (!isFirstItem && menuItem.requiresOverflow()) break;
                boolean showIcon = isFirstItem && menuItem.getItemId() == 16908353;
                View menuItemButton = FloatingToolbar.createMenuItemButton(this.mContext, menuItem, this.mIconTextSpacing, showIcon);
                if (!showIcon && menuItemButton instanceof LinearLayout) {
                    ((LinearLayout)menuItemButton).setGravity(17);
                }
                if (isFirstItem) {
                    menuItemButton.setPaddingRelative((int)(1.5 * (double)menuItemButton.getPaddingStart()), menuItemButton.getPaddingTop(), menuItemButton.getPaddingEnd(), menuItemButton.getPaddingBottom());
                }
                boolean bl = isLastItem = remainingMenuItems.size() == 1;
                if (isLastItem) {
                    menuItemButton.setPaddingRelative(menuItemButton.getPaddingStart(), menuItemButton.getPaddingTop(), (int)(1.5 * (double)menuItemButton.getPaddingEnd()), menuItemButton.getPaddingBottom());
                }
                menuItemButton.measure(0, 0);
                int menuItemButtonWidth = Math.min(menuItemButton.getMeasuredWidth(), toolbarWidth);
                boolean canFitWithOverflow = menuItemButtonWidth <= availableWidth - this.mOverflowButtonSize.getWidth();
                boolean bl2 = canFitNoOverflow = isLastItem && menuItemButtonWidth <= availableWidth;
                if (!canFitWithOverflow && !canFitNoOverflow) break;
                this.setButtonTagAndClickListener(menuItemButton, menuItem);
                menuItemButton.setTooltipText(menuItem.getTooltipText());
                this.mMainPanel.addView(menuItemButton);
                ViewGroup.LayoutParams params = menuItemButton.getLayoutParams();
                params.width = menuItemButtonWidth;
                menuItemButton.setLayoutParams(params);
                availableWidth -= menuItemButtonWidth;
                remainingMenuItems.pop();
                lastGroupId = menuItem.getGroupId();
                isFirstItem = false;
            }
            if (!remainingMenuItems.isEmpty()) {
                this.mMainPanel.setPaddingRelative(0, 0, this.mOverflowButtonSize.getWidth(), 0);
            }
            this.mMainPanelSize = FloatingToolbarPopup.measure(this.mMainPanel);
            return remainingMenuItems;
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$layoutOverflowPanelItems(List<MenuItem> menuItems) {
            ArrayAdapter overflowPanelAdapter = (ArrayAdapter)this.mOverflowPanel.getAdapter();
            overflowPanelAdapter.clear();
            int size = menuItems.size();
            for (int i = 0; i < size; ++i) {
                overflowPanelAdapter.add(menuItems.get(i));
            }
            this.mOverflowPanel.setAdapter(overflowPanelAdapter);
            if (this.mOpenOverflowUpwards) {
                this.mOverflowPanel.setY(0.0f);
            } else {
                this.mOverflowPanel.setY(this.mOverflowButtonSize.getHeight());
            }
            int width = Math.max(this.getOverflowWidth(), this.mOverflowButtonSize.getWidth());
            int height = this.calculateOverflowHeight(4);
            this.mOverflowPanelSize = new Size(width, height);
            FloatingToolbarPopup.setSize(this.mOverflowPanel, this.mOverflowPanelSize);
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$preparePopupContent() {
            this.mContentContainer.removeAllViews();
            if (this.hasOverflow()) {
                this.mContentContainer.addView(this.mOverflowPanel);
            }
            this.mContentContainer.addView(this.mMainPanel);
            if (this.hasOverflow()) {
                this.mContentContainer.addView(this.mOverflowButton);
            }
            this.setPanelsStatesAtRestingPosition();
            this.setContentAreaAsTouchableSurface();
            if (this.isInRTLMode()) {
                this.mContentContainer.setAlpha(0.0f);
                this.mContentContainer.post(this.mPreparePopupContentRTLHelper);
            }
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$clearPanels() {
            this.mOverflowPanelSize = null;
            this.mMainPanelSize = null;
            this.mIsOverflowOpen = false;
            this.mMainPanel.removeAllViews();
            ArrayAdapter overflowPanelAdapter = (ArrayAdapter)this.mOverflowPanel.getAdapter();
            overflowPanelAdapter.clear();
            this.mOverflowPanel.setAdapter(overflowPanelAdapter);
            this.mContentContainer.removeAllViews();
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$positionContentYCoordinatesIfOpeningOverflowUpwards() {
            if (this.mOpenOverflowUpwards) {
                this.mMainPanel.setY(this.mContentContainer.getHeight() - this.mMainPanelSize.getHeight());
                this.mOverflowButton.setY(this.mContentContainer.getHeight() - this.mOverflowButton.getHeight());
                this.mOverflowPanel.setY(this.mContentContainer.getHeight() - this.mOverflowPanelSize.getHeight());
            }
        }

        private final int $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$getOverflowWidth() {
            int overflowWidth = 0;
            int count = this.mOverflowPanel.getAdapter().getCount();
            for (int i = 0; i < count; ++i) {
                MenuItem menuItem = (MenuItem)this.mOverflowPanel.getAdapter().getItem(i);
                overflowWidth = Math.max(this.mOverflowPanelViewHelper.calculateWidth(menuItem), overflowWidth);
            }
            return overflowWidth;
        }

        private final int $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$calculateOverflowHeight(int maxItemSize) {
            int actualSize = Math.min(4, Math.min(Math.max(2, maxItemSize), this.mOverflowPanel.getCount()));
            int extension = 0;
            if (actualSize < this.mOverflowPanel.getCount()) {
                extension = (int)((float)this.mLineHeight * 0.5f);
            }
            return actualSize * this.mLineHeight + this.mOverflowButtonSize.getHeight() + extension;
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setButtonTagAndClickListener(View menuItemButton, MenuItem menuItem) {
            menuItemButton.setTag(menuItem);
            menuItemButton.setOnClickListener(this.mMenuItemButtonOnClickListener);
        }

        private final int $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$getAdjustedDuration(int originalDuration) {
            if (this.mTransitionDurationScale < 150) {
                return Math.max(originalDuration - 50, 0);
            }
            if (this.mTransitionDurationScale > 300) {
                return originalDuration + 50;
            }
            return (int)((float)originalDuration * ValueAnimator.getDurationScale());
        }

        private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$maybeComputeTransitionDurationScale() {
            if (this.mMainPanelSize != null && this.mOverflowPanelSize != null) {
                int w = this.mMainPanelSize.getWidth() - this.mOverflowPanelSize.getWidth();
                int h = this.mOverflowPanelSize.getHeight() - this.mMainPanelSize.getHeight();
                this.mTransitionDurationScale = (int)(Math.sqrt(w * w + h * h) / (double)this.mContentContainer.getContext().getResources().getDisplayMetrics().density);
            }
        }

        private final ViewGroup $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$createMainPanel() {
            ShadowedObject mainPanel = new ShadowedObject(this, this.mContext){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_11$__constructor__(FloatingToolbarPopup this$0, Context x0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_11$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                    if (this.this$0.isOverflowAnimating()) {
                        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.this$0.mMainPanelSize.getWidth(), 0x40000000);
                    }
                    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                }

                private final boolean $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_11$onInterceptTouchEvent(MotionEvent ev) {
                    return this.this$0.isOverflowAnimating();
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup, Context context) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_11$__constructor__(floatingToolbarPopup, context);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_11$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup android.content.Context ), this, floatingToolbarPopup, context);
                }

                @Override
                protected void onMeasure(int n, int n2) {
                    InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_11$onMeasure(int int ), this, n, n2);
                }

                @Override
                public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
                    return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_11$onInterceptTouchEvent(android.view.MotionEvent ), this, motionEvent);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            return mainPanel;
        }

        private final ImageButton $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$createOverflowButton() {
            ImageButton overflowButton = (ImageButton)LayoutInflater.from(this.mContext).inflate(17367142, null);
            overflowButton.setImageDrawable(this.mOverflow);
            overflowButton.setOnClickListener(v -> {
                if (this.mIsOverflowOpen) {
                    overflowButton.setImageDrawable(this.mToOverflow);
                    this.mToOverflow.start();
                    this.closeOverflow();
                } else {
                    overflowButton.setImageDrawable(this.mToArrow);
                    this.mToArrow.start();
                    this.openOverflow();
                }
            });
            return overflowButton;
        }

        private final OverflowPanel $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$createOverflowPanel() {
            OverflowPanel overflowPanel = new OverflowPanel(this);
            overflowPanel.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            overflowPanel.setDivider(null);
            overflowPanel.setDividerHeight(0);
            ArrayAdapter<MenuItem> adapter = new ArrayAdapter<MenuItem>(this, this.mContext, 0){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_12$__constructor__(FloatingToolbarPopup this$0, Context x0, int x1) {
                    this.this$0 = this$0;
                }

                private final View $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_12$getView(int position, View convertView, ViewGroup parent) {
                    return this.this$0.mOverflowPanelViewHelper.getView((MenuItem)this.getItem(position), this.this$0.mOverflowPanelSize.getWidth(), convertView);
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup, Context context, int n) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_12$__constructor__(floatingToolbarPopup, context, n);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_12$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup android.content.Context int ), this, floatingToolbarPopup, context, n);
                }

                @Override
                public View getView(int n, View view, ViewGroup viewGroup) {
                    return InvokeDynamicSupport.bootstrap("getView", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_12$getView(int android.view.View android.view.ViewGroup ), this, n, view, viewGroup);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            overflowPanel.setAdapter(adapter);
            overflowPanel.setOnItemClickListener((parent, view, position, id2) -> {
                MenuItem menuItem = (MenuItem)overflowPanel.getAdapter().getItem(position);
                if (this.mOnMenuItemClickListener != null) {
                    this.mOnMenuItemClickListener.onMenuItemClick(menuItem);
                }
            });
            return overflowPanel;
        }

        private final boolean $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$isOverflowAnimating() {
            boolean overflowOpening = this.mOpenOverflowAnimation.hasStarted() && !this.mOpenOverflowAnimation.hasEnded();
            boolean overflowClosing = this.mCloseOverflowAnimation.hasStarted() && !this.mCloseOverflowAnimation.hasEnded();
            return overflowOpening || overflowClosing;
        }

        private final Animation.AnimationListener $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$createOverflowAnimationListener() {
            Animation.AnimationListener listener = new Animation.AnimationListener(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ FloatingToolbarPopup this$0;

                private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_13$__constructor__(FloatingToolbarPopup this$0) {
                    this.this$0 = this$0;
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_13$onAnimationStart(Animation animation) {
                    this.this$0.mOverflowButton.setEnabled(false);
                    this.this$0.mMainPanel.setVisibility(0);
                    this.this$0.mOverflowPanel.setVisibility(0);
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_13$onAnimationEnd(Animation animation) {
                    this.this$0.mContentContainer.post(() -> {
                        this.this$0.setPanelsStatesAtRestingPosition();
                        this.this$0.setContentAreaAsTouchableSurface();
                    });
                }

                private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_13$onAnimationRepeat(Animation animation) {
                }

                private void __constructor__(FloatingToolbarPopup floatingToolbarPopup) {
                    this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_13$__constructor__(floatingToolbarPopup);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_13$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup ), this, floatingToolbarPopup);
                }

                @Override
                public void onAnimationStart(Animation animation) {
                    InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_13$onAnimationStart(android.view.animation.Animation ), this, animation);
                }

                @Override
                public void onAnimationEnd(Animation animation) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_13$onAnimationEnd(android.view.animation.Animation ), this, animation);
                }

                @Override
                public void onAnimationRepeat(Animation animation) {
                    InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_13$onAnimationRepeat(android.view.animation.Animation ), this, animation);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            return listener;
        }

        private static final Size $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$measure(View view) {
            Preconditions.checkState(view.getParent() == null);
            view.measure(0, 0);
            return new Size(view.getMeasuredWidth(), view.getMeasuredHeight());
        }

        private static final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setSize(View view, int width, int height) {
            view.setMinimumWidth(width);
            view.setMinimumHeight(height);
            ViewGroup.LayoutParams params = view.getLayoutParams();
            params = params == null ? new ViewGroup.LayoutParams(0, 0) : params;
            params.width = width;
            params.height = height;
            view.setLayoutParams(params);
        }

        private static final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setSize(View view, Size size) {
            FloatingToolbarPopup.setSize(view, size.getWidth(), size.getHeight());
        }

        private static final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setWidth(View view, int width) {
            ViewGroup.LayoutParams params = view.getLayoutParams();
            FloatingToolbarPopup.setSize(view, width, params.height);
        }

        private static final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setHeight(View view, int height) {
            ViewGroup.LayoutParams params = view.getLayoutParams();
            FloatingToolbarPopup.setSize(view, params.width, height);
        }

        private void __constructor__(Context context, View view) {
            this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$__constructor__(context, view);
        }

        public FloatingToolbarPopup(Context context, View view) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$__constructor__(android.content.Context android.view.View ), this, context, view);
        }

        public boolean setOutsideTouchable(boolean bl, PopupWindow.OnDismissListener onDismissListener) {
            return (boolean)InvokeDynamicSupport.bootstrap("setOutsideTouchable", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setOutsideTouchable(boolean android.widget.PopupWindow$OnDismissListener ), this, bl, onDismissListener);
        }

        public void layoutMenuItems(List<MenuItem> list, MenuItem.OnMenuItemClickListener onMenuItemClickListener, int n) {
            InvokeDynamicSupport.bootstrap("layoutMenuItems", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$layoutMenuItems(java.util.List<android.view.MenuItem> android.view.MenuItem$OnMenuItemClickListener int ), this, list, onMenuItemClickListener, n);
        }

        public void show(Rect rect) {
            InvokeDynamicSupport.bootstrap("show", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$show(android.graphics.Rect ), this, rect);
        }

        public void dismiss() {
            InvokeDynamicSupport.bootstrap("dismiss", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$dismiss(), this);
        }

        public void hide() {
            InvokeDynamicSupport.bootstrap("hide", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$hide(), this);
        }

        public boolean isShowing() {
            return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$isShowing(), this);
        }

        public boolean isHidden() {
            return (boolean)InvokeDynamicSupport.bootstrap("isHidden", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$isHidden(), this);
        }

        public void updateCoordinates(Rect rect) {
            InvokeDynamicSupport.bootstrap("updateCoordinates", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$updateCoordinates(android.graphics.Rect ), this, rect);
        }

        private void refreshCoordinatesAndOverflowDirection(Rect rect) {
            InvokeDynamicSupport.bootstrap("refreshCoordinatesAndOverflowDirection", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$refreshCoordinatesAndOverflowDirection(android.graphics.Rect ), this, rect);
        }

        private void runShowAnimation() {
            InvokeDynamicSupport.bootstrap("runShowAnimation", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$runShowAnimation(), this);
        }

        private void runDismissAnimation() {
            InvokeDynamicSupport.bootstrap("runDismissAnimation", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$runDismissAnimation(), this);
        }

        private void runHideAnimation() {
            InvokeDynamicSupport.bootstrap("runHideAnimation", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$runHideAnimation(), this);
        }

        private void cancelDismissAndHideAnimations() {
            InvokeDynamicSupport.bootstrap("cancelDismissAndHideAnimations", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$cancelDismissAndHideAnimations(), this);
        }

        private void cancelOverflowAnimations() {
            InvokeDynamicSupport.bootstrap("cancelOverflowAnimations", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$cancelOverflowAnimations(), this);
        }

        private void openOverflow() {
            InvokeDynamicSupport.bootstrap("openOverflow", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$openOverflow(), this);
        }

        private void closeOverflow() {
            InvokeDynamicSupport.bootstrap("closeOverflow", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$closeOverflow(), this);
        }

        private void setPanelsStatesAtRestingPosition() {
            InvokeDynamicSupport.bootstrap("setPanelsStatesAtRestingPosition", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setPanelsStatesAtRestingPosition(), this);
        }

        private void updateOverflowHeight(int n) {
            InvokeDynamicSupport.bootstrap("updateOverflowHeight", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$updateOverflowHeight(int ), this, n);
        }

        private void updatePopupSize() {
            InvokeDynamicSupport.bootstrap("updatePopupSize", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$updatePopupSize(), this);
        }

        private void refreshViewPort() {
            InvokeDynamicSupport.bootstrap("refreshViewPort", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$refreshViewPort(), this);
        }

        private int getAdjustedToolbarWidth(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getAdjustedToolbarWidth", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$getAdjustedToolbarWidth(int ), this, n);
        }

        private void setZeroTouchableSurface() {
            InvokeDynamicSupport.bootstrap("setZeroTouchableSurface", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setZeroTouchableSurface(), this);
        }

        private void setContentAreaAsTouchableSurface() {
            InvokeDynamicSupport.bootstrap("setContentAreaAsTouchableSurface", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setContentAreaAsTouchableSurface(), this);
        }

        private void setTouchableSurfaceInsetsComputer() {
            InvokeDynamicSupport.bootstrap("setTouchableSurfaceInsetsComputer", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setTouchableSurfaceInsetsComputer(), this);
        }

        private boolean isInRTLMode() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInRTLMode", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$isInRTLMode(), this);
        }

        private boolean hasOverflow() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasOverflow", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$hasOverflow(), this);
        }

        public List<MenuItem> layoutMainPanelItems(List<MenuItem> list, int n) {
            return InvokeDynamicSupport.bootstrap("layoutMainPanelItems", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$layoutMainPanelItems(java.util.List<android.view.MenuItem> int ), this, list, n);
        }

        private void layoutOverflowPanelItems(List<MenuItem> list) {
            InvokeDynamicSupport.bootstrap("layoutOverflowPanelItems", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$layoutOverflowPanelItems(java.util.List<android.view.MenuItem> ), this, list);
        }

        private void preparePopupContent() {
            InvokeDynamicSupport.bootstrap("preparePopupContent", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$preparePopupContent(), this);
        }

        private void clearPanels() {
            InvokeDynamicSupport.bootstrap("clearPanels", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$clearPanels(), this);
        }

        private void positionContentYCoordinatesIfOpeningOverflowUpwards() {
            InvokeDynamicSupport.bootstrap("positionContentYCoordinatesIfOpeningOverflowUpwards", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$positionContentYCoordinatesIfOpeningOverflowUpwards(), this);
        }

        private int getOverflowWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getOverflowWidth", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$getOverflowWidth(), this);
        }

        private int calculateOverflowHeight(int n) {
            return (int)InvokeDynamicSupport.bootstrap("calculateOverflowHeight", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$calculateOverflowHeight(int ), this, n);
        }

        private void setButtonTagAndClickListener(View view, MenuItem menuItem) {
            InvokeDynamicSupport.bootstrap("setButtonTagAndClickListener", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setButtonTagAndClickListener(android.view.View android.view.MenuItem ), this, view, menuItem);
        }

        private int getAdjustedDuration(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getAdjustedDuration", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$getAdjustedDuration(int ), this, n);
        }

        private void maybeComputeTransitionDurationScale() {
            InvokeDynamicSupport.bootstrap("maybeComputeTransitionDurationScale", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$maybeComputeTransitionDurationScale(), this);
        }

        private ViewGroup createMainPanel() {
            return InvokeDynamicSupport.bootstrap("createMainPanel", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$createMainPanel(), this);
        }

        private ImageButton createOverflowButton() {
            return InvokeDynamicSupport.bootstrap("createOverflowButton", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$createOverflowButton(), this);
        }

        private OverflowPanel createOverflowPanel() {
            return InvokeDynamicSupport.bootstrap("createOverflowPanel", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$createOverflowPanel(), this);
        }

        private boolean isOverflowAnimating() {
            return (boolean)InvokeDynamicSupport.bootstrap("isOverflowAnimating", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$isOverflowAnimating(), this);
        }

        private Animation.AnimationListener createOverflowAnimationListener() {
            return InvokeDynamicSupport.bootstrap("createOverflowAnimationListener", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$createOverflowAnimationListener(), this);
        }

        private static Size measure(View view) {
            return InvokeDynamicSupport.bootstrapStatic("measure", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$measure(android.view.View ), (View)view);
        }

        private static void setSize(View view, int n, int n2) {
            InvokeDynamicSupport.bootstrapStatic("setSize", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setSize(android.view.View int int ), (View)view, (int)n, (int)n2);
        }

        private static void setSize(View view, Size size) {
            InvokeDynamicSupport.bootstrapStatic("setSize", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setSize(android.view.View android.util.Size ), (View)view, (Size)size);
        }

        private static void setWidth(View view, int n) {
            InvokeDynamicSupport.bootstrapStatic("setWidth", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setWidth(android.view.View int ), (View)view, (int)n);
        }

        private static void setHeight(View view, int n) {
            InvokeDynamicSupport.bootstrapStatic("setHeight", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup$setHeight(android.view.View int ), (View)view, (int)n);
        }

        public /* synthetic */ FloatingToolbarPopup() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FloatingToolbarPopup)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private static final class OverflowPanelViewHelper
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private View mCalculator;
            private int mIconTextSpacing;
            private int mSidePadding;
            private Context mContext;

            private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanelViewHelper$__constructor__(Context context, int iconTextSpacing) {
                this.mContext = Preconditions.checkNotNull(context);
                this.mIconTextSpacing = iconTextSpacing;
                this.mSidePadding = context.getResources().getDimensionPixelSize(17105056);
                this.mCalculator = this.createMenuButton(null);
            }

            private final View $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanelViewHelper$getView(MenuItem menuItem, int minimumWidth, View convertView) {
                Preconditions.checkNotNull(menuItem);
                if (convertView != null) {
                    FloatingToolbar.updateMenuItemButton(convertView, menuItem, this.mIconTextSpacing, this.shouldShowIcon(menuItem));
                } else {
                    convertView = this.createMenuButton(menuItem);
                }
                convertView.setMinimumWidth(minimumWidth);
                return convertView;
            }

            private final int $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanelViewHelper$calculateWidth(MenuItem menuItem) {
                FloatingToolbar.updateMenuItemButton(this.mCalculator, menuItem, this.mIconTextSpacing, this.shouldShowIcon(menuItem));
                this.mCalculator.measure(0, 0);
                return this.mCalculator.getMeasuredWidth();
            }

            private final View $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanelViewHelper$createMenuButton(MenuItem menuItem) {
                View button = FloatingToolbar.createMenuItemButton(this.mContext, menuItem, this.mIconTextSpacing, this.shouldShowIcon(menuItem));
                button.setPadding(this.mSidePadding, 0, this.mSidePadding, 0);
                return button;
            }

            private final boolean $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanelViewHelper$shouldShowIcon(MenuItem menuItem) {
                if (menuItem != null) {
                    return menuItem.getGroupId() == 16908353;
                }
                return false;
            }

            private void __constructor__(Context context, int n) {
                this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanelViewHelper$__constructor__(context, n);
            }

            public OverflowPanelViewHelper(Context context, int n) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanelViewHelper$__constructor__(android.content.Context int ), this, context, n);
            }

            public View getView(MenuItem menuItem, int n, View view) {
                return InvokeDynamicSupport.bootstrap("getView", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanelViewHelper$getView(android.view.MenuItem int android.view.View ), this, menuItem, n, view);
            }

            public int calculateWidth(MenuItem menuItem) {
                return (int)InvokeDynamicSupport.bootstrap("calculateWidth", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanelViewHelper$calculateWidth(android.view.MenuItem ), this, menuItem);
            }

            private View createMenuButton(MenuItem menuItem) {
                return InvokeDynamicSupport.bootstrap("createMenuButton", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanelViewHelper$createMenuButton(android.view.MenuItem ), this, menuItem);
            }

            private boolean shouldShowIcon(MenuItem menuItem) {
                return (boolean)InvokeDynamicSupport.bootstrap("shouldShowIcon", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanelViewHelper$shouldShowIcon(android.view.MenuItem ), this, menuItem);
            }

            public /* synthetic */ OverflowPanelViewHelper() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OverflowPanelViewHelper)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private static final class LogAccelerateInterpolator
        implements Interpolator,
        ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private static int BASE = 100;
            private static float LOGS_SCALE;

            private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_LogAccelerateInterpolator$__constructor__() {
            }

            private static final float $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_LogAccelerateInterpolator$computeLog(float t, int base) {
                return (float)(1.0 - Math.pow(base, -t));
            }

            private final float $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_LogAccelerateInterpolator$getInterpolation(float t) {
                return 1.0f - LogAccelerateInterpolator.computeLog(1.0f - t, 100) * LOGS_SCALE;
            }

            private /* synthetic */ void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_LogAccelerateInterpolator$__constructor__(1 x0) {
            }

            static void __staticInitializer__() {
                LOGS_SCALE = 1.0f / LogAccelerateInterpolator.computeLog(1.0f, 100);
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_LogAccelerateInterpolator$__constructor__();
            }

            public LogAccelerateInterpolator() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_LogAccelerateInterpolator$__constructor__(), this);
            }

            private static float computeLog(float f, int n) {
                return (float)InvokeDynamicSupport.bootstrapStatic("computeLog", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_LogAccelerateInterpolator$computeLog(float int ), (float)f, (int)n);
            }

            @Override
            public float getInterpolation(float f) {
                return (float)InvokeDynamicSupport.bootstrap("getInterpolation", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_LogAccelerateInterpolator$getInterpolation(float ), this, f);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_LogAccelerateInterpolator$__constructor__(var1_1);
            }

            public /* synthetic */ LogAccelerateInterpolator(1 var1_1) {
                this();
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_LogAccelerateInterpolator$__constructor__(com.android.internal.widget.FloatingToolbar$1 ), this, var1_1);
            }

            static {
                RobolectricInternals.classInitializing(LogAccelerateInterpolator.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LogAccelerateInterpolator)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private static final class OverflowPanel
        extends ListView
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private FloatingToolbarPopup mPopup;

            private void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanel$__constructor__(FloatingToolbarPopup popup) {
                this.mPopup = popup;
                this.setScrollBarDefaultDelayBeforeFade(ViewConfiguration.getScrollDefaultDelay() * 3);
                this.setScrollIndicators(3);
            }

            private final void $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanel$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                int height = this.mPopup.mOverflowPanelSize.getHeight() - this.mPopup.mOverflowButtonSize.getHeight();
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }

            private final boolean $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanel$dispatchTouchEvent(MotionEvent ev) {
                if (this.mPopup.isOverflowAnimating()) {
                    return true;
                }
                return super.dispatchTouchEvent(ev);
            }

            private final boolean $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanel$awakenScrollBars() {
                return super.awakenScrollBars();
            }

            private void __constructor__(FloatingToolbarPopup floatingToolbarPopup) {
                this.$$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanel$__constructor__(floatingToolbarPopup);
            }

            public OverflowPanel(FloatingToolbarPopup floatingToolbarPopup) {
                super(Preconditions.checkNotNull(floatingToolbarPopup).mContext);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanel$__constructor__(com.android.internal.widget.FloatingToolbar$FloatingToolbarPopup ), this, floatingToolbarPopup);
            }

            @Override
            protected void onMeasure(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanel$onMeasure(int int ), this, n, n2);
            }

            @Override
            public boolean dispatchTouchEvent(MotionEvent motionEvent) {
                return (boolean)InvokeDynamicSupport.bootstrap("dispatchTouchEvent", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanel$dispatchTouchEvent(android.view.MotionEvent ), this, motionEvent);
            }

            @Override
            protected boolean awakenScrollBars() {
                return (boolean)InvokeDynamicSupport.bootstrap("awakenScrollBars", $$robo$$com_android_internal_widget_FloatingToolbar_FloatingToolbarPopup_OverflowPanel$awakenScrollBars(), this);
            }

            public /* synthetic */ OverflowPanel() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OverflowPanel)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

