/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.AppOpsManagerInternal;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManagerInternal;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.KeyValueListParser;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IAppOpsActiveCallback;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.LocalServices;
import com.android.server.LockGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AppOpsService
extends IAppOpsService.Stub {
    static final String TAG = "AppOps";
    static final boolean DEBUG = false;
    private static final int NO_VERSION = -1;
    private static final int CURRENT_VERSION = 1;
    static final long WRITE_DELAY = 1800000L;
    private static final int UID_ANY = -2;
    private static final int[] PROCESS_STATE_TO_UID_STATE = new int[]{0, 0, 1, 2, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    static final String[] UID_STATE_NAMES = new String[]{"pers ", "top  ", "fgsvc", "fg   ", "bg   ", "cch  "};
    static final String[] UID_STATE_TIME_ATTRS = new String[]{"tp", "tt", "tfs", "tf", "tb", "tc"};
    static final String[] UID_STATE_REJECT_ATTRS = new String[]{"rp", "rt", "rfs", "rf", "rb", "rc"};
    Context mContext;
    final AtomicFile mFile;
    final Handler mHandler;
    private final AppOpsManagerInternalImpl mAppOpsManagerInternal = new AppOpsManagerInternalImpl();
    boolean mWriteScheduled;
    boolean mFastWriteScheduled;
    final Runnable mWriteRunner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AppOpsService appOpsService = AppOpsService.this;
            synchronized (appOpsService) {
                AppOpsService.this.mWriteScheduled = false;
                AppOpsService.this.mFastWriteScheduled = false;
                AsyncTask<Void, Void, Void> task = new AsyncTask<Void, Void, Void>(){

                    protected Void doInBackground(Void ... params) {
                        AppOpsService.this.writeState();
                        return null;
                    }
                };
                task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
            }
        }
    };
    @VisibleForTesting
    final SparseArray<UidState> mUidStates = new SparseArray();
    long mLastUptime;
    private final ArrayMap<IBinder, ClientRestrictionState> mOpUserRestrictions = new ArrayMap();
    SparseIntArray mProfileOwners;
    private final Constants mConstants;
    final SparseArray<ArraySet<ModeCallback>> mOpModeWatchers = new SparseArray();
    final ArrayMap<String, ArraySet<ModeCallback>> mPackageModeWatchers = new ArrayMap();
    final ArrayMap<IBinder, ModeCallback> mModeWatchers = new ArrayMap();
    final ArrayMap<IBinder, SparseArray<ActiveCallback>> mActiveWatchers = new ArrayMap();
    final SparseArray<SparseArray<Restriction>> mAudioRestrictions = new SparseArray();
    final ArrayMap<IBinder, ClientState> mClients = new ArrayMap();

    public AppOpsService(File storagePath, Handler handler) {
        LockGuard.installLock((Object)this, 0);
        this.mFile = new AtomicFile(storagePath, "appops");
        this.mHandler = handler;
        this.mConstants = new Constants(this.mHandler);
        this.readState();
    }

    public void publish(Context context) {
        this.mContext = context;
        ServiceManager.addService("appops", this.asBinder());
        LocalServices.addService(AppOpsManagerInternal.class, this.mAppOpsManagerInternal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        this.mConstants.startMonitoring(this.mContext.getContentResolver());
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            boolean changed = false;
            for (int i = this.mUidStates.size() - 1; i >= 0; --i) {
                UidState uidState = this.mUidStates.valueAt(i);
                String[] packageNames = AppOpsService.getPackagesForUid(uidState.uid);
                if (ArrayUtils.isEmpty(packageNames)) {
                    uidState.clear();
                    this.mUidStates.removeAt(i);
                    changed = true;
                    continue;
                }
                ArrayMap<String, Ops> pkgs = uidState.pkgOps;
                if (pkgs == null) continue;
                Iterator<Ops> it = pkgs.values().iterator();
                while (it.hasNext()) {
                    Ops ops = it.next();
                    int curUid = -1;
                    try {
                        curUid = AppGlobals.getPackageManager().getPackageUid(ops.packageName, 8192, UserHandle.getUserId(ops.uidState.uid));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (curUid == ops.uidState.uid) continue;
                    Slog.i(TAG, "Pruning old package " + ops.packageName + "/" + ops.uidState + ": new uid=" + curUid);
                    it.remove();
                    changed = true;
                }
                if (!uidState.isDefault()) continue;
                this.mUidStates.removeAt(i);
            }
            if (changed) {
                this.scheduleFastWriteLocked();
            }
        }
        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        packageManagerInternal.setExternalSourcesPolicy(new PackageManagerInternal.ExternalSourcesPolicy(){

            @Override
            public int getPackageTrustedToInstallApps(String packageName, int uid) {
                int appOpMode = AppOpsService.this.checkOperation(66, uid, packageName);
                switch (appOpMode) {
                    case 0: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                }
                return 2;
            }
        });
        StorageManagerInternal storageManagerInternal = LocalServices.getService(StorageManagerInternal.class);
        storageManagerInternal.addExternalStoragePolicy(new StorageManagerInternal.ExternalStorageMountPolicy(){

            @Override
            public int getMountMode(int uid, String packageName) {
                if (Process.isIsolated(uid)) {
                    return 0;
                }
                if (AppOpsService.this.noteOperation(59, uid, packageName) != 0) {
                    return 0;
                }
                if (AppOpsService.this.noteOperation(60, uid, packageName) != 0) {
                    return 2;
                }
                return 3;
            }

            @Override
            public boolean hasExternalStorage(int uid, String packageName) {
                int mountMode = this.getMountMode(uid, packageName);
                return mountMode == 2 || mountMode == 3;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packageRemoved(int uid, String packageName) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            UidState uidState = this.mUidStates.get(uid);
            if (uidState == null) {
                return;
            }
            Ops ops = null;
            if (uidState.pkgOps != null) {
                ops = uidState.pkgOps.remove(packageName);
            }
            if (ops != null && uidState.pkgOps.isEmpty() && AppOpsService.getPackagesForUid(uid).length <= 0) {
                this.mUidStates.remove(uid);
            }
            int clientCount = this.mClients.size();
            for (int i = 0; i < clientCount; ++i) {
                ClientState client = this.mClients.valueAt(i);
                if (client.mStartedOps == null) continue;
                int opCount = client.mStartedOps.size();
                for (int j = opCount - 1; j >= 0; --j) {
                    Op op = client.mStartedOps.get(j);
                    if (uid != op.uid || !packageName.equals(op.packageName)) continue;
                    this.finishOperationLocked(op, true);
                    client.mStartedOps.remove(j);
                    if (op.startNesting > 0) continue;
                    this.scheduleOpActiveChangedIfNeededLocked(op.op, uid, packageName, false);
                }
            }
            if (ops != null) {
                this.scheduleFastWriteLocked();
                int opCount = ops.size();
                for (int i = 0; i < opCount; ++i) {
                    Op op = (Op)ops.valueAt(i);
                    if (op.duration != -1) continue;
                    this.scheduleOpActiveChangedIfNeededLocked(op.op, op.uid, op.packageName, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uidRemoved(int uid) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            if (this.mUidStates.indexOfKey(uid) >= 0) {
                this.mUidStates.remove(uid);
                this.scheduleFastWriteLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUidProcState(int uid, int procState) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            UidState uidState = this.getUidStateLocked(uid, true);
            int newState = PROCESS_STATE_TO_UID_STATE[procState];
            if (uidState != null && uidState.pendingState != newState) {
                int oldPendingState = uidState.pendingState;
                uidState.pendingState = newState;
                if (newState < uidState.state || newState <= 2) {
                    this.commitUidPendingStateLocked(uidState);
                } else if (uidState.pendingStateCommitTime == 0L) {
                    long settleTime = uidState.state <= 1 ? this.mConstants.TOP_STATE_SETTLE_TIME : (uidState.state <= 2 ? this.mConstants.FG_SERVICE_STATE_SETTLE_TIME : this.mConstants.BG_STATE_SETTLE_TIME);
                    uidState.pendingStateCommitTime = SystemClock.uptimeMillis() + settleTime;
                }
                if (uidState.startNesting != 0) {
                    long now = System.currentTimeMillis();
                    for (int i = uidState.pkgOps.size() - 1; i >= 0; --i) {
                        Ops ops = uidState.pkgOps.valueAt(i);
                        for (int j = ops.size() - 1; j >= 0; --j) {
                            Op op = (Op)ops.valueAt(j);
                            if (op.startNesting <= 0) continue;
                            op.time[oldPendingState] = now;
                            op.time[newState] = now;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Slog.w(TAG, "Writing app ops before shutdown...");
        boolean doWrite = false;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            if (this.mWriteScheduled) {
                this.mWriteScheduled = false;
                doWrite = true;
            }
        }
        if (doWrite) {
            this.writeState();
        }
    }

    private ArrayList<AppOpsManager.OpEntry> collectOps(Ops pkgOps, int[] ops) {
        ArrayList<AppOpsManager.OpEntry> resOps = null;
        long elapsedNow = SystemClock.elapsedRealtime();
        if (ops == null) {
            resOps = new ArrayList<AppOpsManager.OpEntry>();
            for (int j = 0; j < pkgOps.size(); ++j) {
                Op curOp = (Op)pkgOps.valueAt(j);
                boolean running = curOp.duration == -1;
                long duration = running ? elapsedNow - curOp.startRealtime : (long)curOp.duration;
                resOps.add(new AppOpsManager.OpEntry(curOp.op, curOp.mode, curOp.time, curOp.rejectTime, (int)duration, running, curOp.proxyUid, curOp.proxyPackageName));
            }
        } else {
            for (int j = 0; j < ops.length; ++j) {
                Op curOp = (Op)pkgOps.get(ops[j]);
                if (curOp == null) continue;
                if (resOps == null) {
                    resOps = new ArrayList();
                }
                boolean running = curOp.duration == -1;
                long duration = running ? elapsedNow - curOp.startRealtime : (long)curOp.duration;
                resOps.add(new AppOpsManager.OpEntry(curOp.op, curOp.mode, curOp.time, curOp.rejectTime, (int)duration, running, curOp.proxyUid, curOp.proxyPackageName));
            }
        }
        return resOps;
    }

    private ArrayList<AppOpsManager.OpEntry> collectOps(SparseIntArray uidOps, int[] ops) {
        ArrayList<AppOpsManager.OpEntry> resOps = null;
        if (ops == null) {
            resOps = new ArrayList<AppOpsManager.OpEntry>();
            for (int j = 0; j < uidOps.size(); ++j) {
                resOps.add(new AppOpsManager.OpEntry(uidOps.keyAt(j), uidOps.valueAt(j), 0L, 0L, 0, -1, null));
            }
        } else {
            for (int j = 0; j < ops.length; ++j) {
                int index = uidOps.indexOfKey(ops[j]);
                if (index < 0) continue;
                if (resOps == null) {
                    resOps = new ArrayList();
                }
                resOps.add(new AppOpsManager.OpEntry(uidOps.keyAt(index), uidOps.valueAt(index), 0L, 0L, 0, -1, null));
            }
        }
        return resOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AppOpsManager.PackageOps> getPackagesForOps(int[] ops) {
        this.mContext.enforcePermission("android.permission.GET_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        ArrayList<AppOpsManager.PackageOps> res = null;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            int uidStateCount = this.mUidStates.size();
            for (int i = 0; i < uidStateCount; ++i) {
                UidState uidState = this.mUidStates.valueAt(i);
                if (uidState.pkgOps == null || uidState.pkgOps.isEmpty()) continue;
                ArrayMap<String, Ops> packages = uidState.pkgOps;
                int packageCount = packages.size();
                for (int j = 0; j < packageCount; ++j) {
                    Ops pkgOps = packages.valueAt(j);
                    ArrayList<AppOpsManager.OpEntry> resOps = this.collectOps(pkgOps, ops);
                    if (resOps == null) continue;
                    if (res == null) {
                        res = new ArrayList<AppOpsManager.PackageOps>();
                    }
                    AppOpsManager.PackageOps resPackage = new AppOpsManager.PackageOps(pkgOps.packageName, pkgOps.uidState.uid, resOps);
                    res.add(resPackage);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AppOpsManager.PackageOps> getOpsForPackage(int uid, String packageName, int[] ops) {
        this.mContext.enforcePermission("android.permission.GET_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        String resolvedPackageName = AppOpsService.resolvePackageName(uid, packageName);
        if (resolvedPackageName == null) {
            return Collections.emptyList();
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Ops pkgOps = this.getOpsRawLocked(uid, resolvedPackageName, false, false);
            if (pkgOps == null) {
                return null;
            }
            ArrayList<AppOpsManager.OpEntry> resOps = this.collectOps(pkgOps, ops);
            if (resOps == null) {
                return null;
            }
            ArrayList<AppOpsManager.PackageOps> res = new ArrayList<AppOpsManager.PackageOps>();
            AppOpsManager.PackageOps resPackage = new AppOpsManager.PackageOps(pkgOps.packageName, pkgOps.uidState.uid, resOps);
            res.add(resPackage);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AppOpsManager.PackageOps> getUidOps(int uid, int[] ops) {
        this.mContext.enforcePermission("android.permission.GET_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            UidState uidState = this.getUidStateLocked(uid, false);
            if (uidState == null) {
                return null;
            }
            ArrayList<AppOpsManager.OpEntry> resOps = this.collectOps(uidState.opModes, ops);
            if (resOps == null) {
                return null;
            }
            ArrayList<AppOpsManager.PackageOps> res = new ArrayList<AppOpsManager.PackageOps>();
            AppOpsManager.PackageOps resPackage = new AppOpsManager.PackageOps(null, uidState.uid, resOps);
            res.add(resPackage);
            return res;
        }
    }

    private void pruneOp(Op op, int uid, String packageName) {
        Ops ops;
        if (!op.hasAnyTime() && (ops = this.getOpsRawLocked(uid, packageName, false, false)) != null) {
            ops.remove(op.op);
            if (ops.size() <= 0) {
                UidState uidState = ops.uidState;
                ArrayMap<String, Ops> pkgOps = uidState.pkgOps;
                if (pkgOps != null) {
                    pkgOps.remove(ops.packageName);
                    if (pkgOps.isEmpty()) {
                        uidState.pkgOps = null;
                    }
                    if (uidState.isDefault()) {
                        this.mUidStates.remove(uid);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enforceManageAppOpsModes(int callingPid, int callingUid, int targetUid) {
        if (callingPid == Process.myPid()) {
            return;
        }
        int callingUser = UserHandle.getUserId(callingUid);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            if (this.mProfileOwners != null && this.mProfileOwners.get(callingUser, -1) == callingUid && targetUid >= 0 && callingUser == UserHandle.getUserId(targetUid)) {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var5_5
            this.mContext.enforcePermission("android.permission.MANAGE_APP_OPS_MODES", Binder.getCallingPid(), Binder.getCallingUid(), null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUidMode(int code, int uid, int mode) {
        Object uidState;
        this.enforceManageAppOpsModes(Binder.getCallingPid(), Binder.getCallingUid(), uid);
        this.verifyIncomingOp(code);
        code = AppOpsManager.opToSwitch(code);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            int defaultMode = AppOpsManager.opToDefaultMode(code);
            uidState = this.getUidStateLocked(uid, false);
            if (uidState == null) {
                if (mode == defaultMode) {
                    return;
                }
                uidState = new UidState(uid);
                ((UidState)uidState).opModes = new SparseIntArray();
                ((UidState)uidState).opModes.put(code, mode);
                this.mUidStates.put(uid, (UidState)uidState);
                this.scheduleWriteLocked();
            } else if (((UidState)uidState).opModes == null) {
                if (mode != defaultMode) {
                    ((UidState)uidState).opModes = new SparseIntArray();
                    ((UidState)uidState).opModes.put(code, mode);
                    this.scheduleWriteLocked();
                }
            } else {
                if (((UidState)uidState).opModes.get(code) == mode) {
                    return;
                }
                if (mode == defaultMode) {
                    ((UidState)uidState).opModes.delete(code);
                    if (((UidState)uidState).opModes.size() <= 0) {
                        ((UidState)uidState).opModes = null;
                    }
                } else {
                    ((UidState)uidState).opModes.put(code, mode);
                }
                this.scheduleWriteLocked();
            }
        }
        String[] uidPackageNames = AppOpsService.getPackagesForUid(uid);
        ArrayMap callbackSpecs = null;
        uidState = this;
        synchronized (uidState) {
            ArraySet<ModeCallback> callbacks = this.mOpModeWatchers.get(code);
            if (callbacks != null) {
                int callbackCount = callbacks.size();
                for (int i = 0; i < callbackCount; ++i) {
                    ModeCallback callback = callbacks.valueAt(i);
                    ArraySet changedPackages = new ArraySet();
                    Collections.addAll(changedPackages, uidPackageNames);
                    if (callbackSpecs == null) {
                        callbackSpecs = new ArrayMap();
                    }
                    callbackSpecs.put(callback, changedPackages);
                }
            }
            for (String uidPackageName : uidPackageNames) {
                callbacks = this.mPackageModeWatchers.get(uidPackageName);
                if (callbacks == null) continue;
                if (callbackSpecs == null) {
                    callbackSpecs = new ArrayMap();
                }
                int callbackCount = callbacks.size();
                for (int i = 0; i < callbackCount; ++i) {
                    ModeCallback callback = callbacks.valueAt(i);
                    ArraySet<String> changedPackages = (ArraySet<String>)callbackSpecs.get(callback);
                    if (changedPackages == null) {
                        changedPackages = new ArraySet<String>();
                        callbackSpecs.put(callback, changedPackages);
                    }
                    changedPackages.add(uidPackageName);
                }
            }
        }
        if (callbackSpecs == null) {
            return;
        }
        for (int i = 0; i < callbackSpecs.size(); ++i) {
            ModeCallback callback = (ModeCallback)callbackSpecs.keyAt(i);
            ArraySet reportedPackageNames = (ArraySet)callbackSpecs.valueAt(i);
            if (reportedPackageNames == null) {
                this.mHandler.sendMessage(PooledLambda.obtainMessage(AppOpsService::notifyOpChanged, this, callback, code, uid, null));
                continue;
            }
            int reportedPackageCount = reportedPackageNames.size();
            for (int j = 0; j < reportedPackageCount; ++j) {
                String reportedPackageName = (String)reportedPackageNames.valueAt(j);
                this.mHandler.sendMessage(PooledLambda.obtainMessage(AppOpsService::notifyOpChanged, this, callback, code, uid, reportedPackageName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMode(int code, int uid, String packageName, int mode) {
        this.enforceManageAppOpsModes(Binder.getCallingPid(), Binder.getCallingUid(), uid);
        this.verifyIncomingOp(code);
        ArraySet<ModeCallback> repCbs = null;
        code = AppOpsManager.opToSwitch(code);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            UidState uidState = this.getUidStateLocked(uid, false);
            Op op = this.getOpLocked(code, uid, packageName, true);
            if (op != null && op.mode != mode) {
                ArraySet<ModeCallback> cbs;
                op.mode = mode;
                if (uidState != null) {
                    uidState.evalForegroundOps(this.mOpModeWatchers);
                }
                if ((cbs = this.mOpModeWatchers.get(code)) != null) {
                    if (repCbs == null) {
                        repCbs = new ArraySet<ModeCallback>();
                    }
                    repCbs.addAll(cbs);
                }
                if ((cbs = this.mPackageModeWatchers.get(packageName)) != null) {
                    if (repCbs == null) {
                        repCbs = new ArraySet();
                    }
                    repCbs.addAll(cbs);
                }
                if (mode == AppOpsManager.opToDefaultMode(op.op)) {
                    this.pruneOp(op, uid, packageName);
                }
                this.scheduleFastWriteLocked();
            }
        }
        if (repCbs != null) {
            this.mHandler.sendMessage(PooledLambda.obtainMessage(AppOpsService::notifyOpChanged, this, repCbs, code, uid, packageName));
        }
    }

    private void notifyOpChanged(ArraySet<ModeCallback> callbacks, int code, int uid, String packageName) {
        for (int i = 0; i < callbacks.size(); ++i) {
            ModeCallback callback = callbacks.valueAt(i);
            this.notifyOpChanged(callback, code, uid, packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOpChanged(ModeCallback callback, int code, int uid, String packageName) {
        if (uid != -2 && callback.mWatchingUid >= 0 && callback.mWatchingUid != uid) {
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            callback.mCallback.opChanged(code, uid, packageName);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private static HashMap<ModeCallback, ArrayList<ChangeRec>> addCallbacks(HashMap<ModeCallback, ArrayList<ChangeRec>> callbacks, int op, int uid, String packageName, ArraySet<ModeCallback> cbs) {
        if (cbs == null) {
            return callbacks;
        }
        if (callbacks == null) {
            callbacks = new HashMap();
        }
        boolean duplicate = false;
        int N = cbs.size();
        for (int i = 0; i < N; ++i) {
            ModeCallback cb = cbs.valueAt(i);
            ArrayList<ChangeRec> reports = callbacks.get(cb);
            if (reports == null) {
                reports = new ArrayList();
                callbacks.put(cb, reports);
            } else {
                int reportCount = reports.size();
                for (int j = 0; j < reportCount; ++j) {
                    ChangeRec report = reports.get(j);
                    if (report.op != op || !report.pkg.equals(packageName)) continue;
                    duplicate = true;
                    break;
                }
            }
            if (duplicate) continue;
            reports.add(new ChangeRec(op, uid, packageName));
        }
        return callbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAllModes(int reqUserId, String reqPackageName) {
        int callingPid = Binder.getCallingPid();
        int callingUid = Binder.getCallingUid();
        reqUserId = ActivityManager.handleIncomingUser(callingPid, callingUid, reqUserId, true, true, "resetAllModes", null);
        int reqUid = -1;
        if (reqPackageName != null) {
            try {
                reqUid = AppGlobals.getPackageManager().getPackageUid(reqPackageName, 8192, reqUserId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.enforceManageAppOpsModes(callingPid, callingUid, reqUid);
        HashMap<ModeCallback, ArrayList<ChangeRec>> callbacks = null;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            boolean bl;
            boolean bl2 = false;
            for (int i = this.mUidStates.size() - 1; i >= 0; --i) {
                UidState uidState = this.mUidStates.valueAt(i);
                SparseIntArray opModes = uidState.opModes;
                if (opModes != null && (uidState.uid == reqUid || reqUid == -1)) {
                    int uidOpCount = opModes.size();
                    for (int j = uidOpCount - 1; j >= 0; --j) {
                        int code = opModes.keyAt(j);
                        if (!AppOpsManager.opAllowsReset(code)) continue;
                        opModes.removeAt(j);
                        if (opModes.size() <= 0) {
                            uidState.opModes = null;
                        }
                        for (String packageName : AppOpsService.getPackagesForUid(uidState.uid)) {
                            callbacks = AppOpsService.addCallbacks(callbacks, code, uidState.uid, packageName, this.mOpModeWatchers.get(code));
                            callbacks = AppOpsService.addCallbacks(callbacks, code, uidState.uid, packageName, this.mPackageModeWatchers.get(packageName));
                        }
                    }
                }
                if (uidState.pkgOps == null || reqUserId != -1 && reqUserId != UserHandle.getUserId(uidState.uid)) continue;
                ArrayMap<String, Ops> packages = uidState.pkgOps;
                Iterator it = packages.entrySet().iterator();
                boolean uidChanged = false;
                while (it.hasNext()) {
                    Map.Entry ent = it.next();
                    String packageName = (String)ent.getKey();
                    if (reqPackageName != null && !reqPackageName.equals(packageName)) continue;
                    Ops pkgOps = (Ops)ent.getValue();
                    for (int j = pkgOps.size() - 1; j >= 0; --j) {
                        Op curOp = (Op)pkgOps.valueAt(j);
                        if (!AppOpsManager.opAllowsReset(curOp.op) || curOp.mode == AppOpsManager.opToDefaultMode(curOp.op)) continue;
                        curOp.mode = AppOpsManager.opToDefaultMode(curOp.op);
                        bl = true;
                        uidChanged = true;
                        callbacks = AppOpsService.addCallbacks(callbacks, curOp.op, curOp.uid, packageName, this.mOpModeWatchers.get(curOp.op));
                        callbacks = AppOpsService.addCallbacks(callbacks, curOp.op, curOp.uid, packageName, this.mPackageModeWatchers.get(packageName));
                        if (curOp.hasAnyTime()) continue;
                        pkgOps.removeAt(j);
                    }
                    if (pkgOps.size() != 0) continue;
                    it.remove();
                }
                if (uidState.isDefault()) {
                    this.mUidStates.remove(uidState.uid);
                }
                if (!uidChanged) continue;
                uidState.evalForegroundOps(this.mOpModeWatchers);
            }
            if (bl) {
                this.scheduleFastWriteLocked();
            }
        }
        if (callbacks != null) {
            for (Map.Entry entry : callbacks.entrySet()) {
                ModeCallback cb = (ModeCallback)entry.getKey();
                ArrayList reports = (ArrayList)entry.getValue();
                for (int i = 0; i < reports.size(); ++i) {
                    ChangeRec rep = (ChangeRec)reports.get(i);
                    this.mHandler.sendMessage(PooledLambda.obtainMessage(AppOpsService::notifyOpChanged, this, cb, rep.op, rep.uid, rep.pkg));
                }
            }
        }
    }

    private void evalAllForegroundOpsLocked() {
        for (int uidi = this.mUidStates.size() - 1; uidi >= 0; --uidi) {
            UidState uidState = this.mUidStates.valueAt(uidi);
            if (uidState.foregroundOps == null) continue;
            uidState.evalForegroundOps(this.mOpModeWatchers);
        }
    }

    @Override
    public void startWatchingMode(int op, String packageName, IAppOpsCallback callback) {
        this.startWatchingModeWithFlags(op, packageName, 0, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startWatchingModeWithFlags(int op, String packageName, int flags, IAppOpsCallback callback) {
        int watchedUid = -1;
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        Preconditions.checkArgumentInRange(op, -1, 77, "Invalid op code: " + op);
        if (callback == null) {
            return;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            ArraySet<ModeCallback> cbs;
            op = op != -1 ? AppOpsManager.opToSwitch(op) : op;
            ModeCallback cb = this.mModeWatchers.get(callback.asBinder());
            if (cb == null) {
                cb = new ModeCallback(callback, watchedUid, flags, callingUid, callingPid);
                this.mModeWatchers.put(callback.asBinder(), cb);
            }
            if (op != -1) {
                cbs = this.mOpModeWatchers.get(op);
                if (cbs == null) {
                    cbs = new ArraySet();
                    this.mOpModeWatchers.put(op, cbs);
                }
                cbs.add(cb);
            }
            if (packageName != null) {
                cbs = this.mPackageModeWatchers.get(packageName);
                if (cbs == null) {
                    cbs = new ArraySet();
                    this.mPackageModeWatchers.put(packageName, cbs);
                }
                cbs.add(cb);
            }
            this.evalAllForegroundOpsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWatchingMode(IAppOpsCallback callback) {
        if (callback == null) {
            return;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            ModeCallback cb = this.mModeWatchers.remove(callback.asBinder());
            if (cb != null) {
                ArraySet<ModeCallback> cbs;
                int i;
                cb.unlinkToDeath();
                for (i = this.mOpModeWatchers.size() - 1; i >= 0; --i) {
                    cbs = this.mOpModeWatchers.valueAt(i);
                    cbs.remove(cb);
                    if (cbs.size() > 0) continue;
                    this.mOpModeWatchers.removeAt(i);
                }
                for (i = this.mPackageModeWatchers.size() - 1; i >= 0; --i) {
                    cbs = this.mPackageModeWatchers.valueAt(i);
                    cbs.remove(cb);
                    if (cbs.size() > 0) continue;
                    this.mPackageModeWatchers.removeAt(i);
                }
            }
            this.evalAllForegroundOpsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder getToken(IBinder clientToken) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            ClientState cs = this.mClients.get(clientToken);
            if (cs == null) {
                cs = new ClientState(clientToken);
                this.mClients.put(clientToken, cs);
            }
            return cs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkOperation(int code, int uid, String packageName) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        String resolvedPackageName = AppOpsService.resolvePackageName(uid, packageName);
        if (resolvedPackageName == null) {
            return 1;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            if (this.isOpRestrictedLocked(uid, code, resolvedPackageName)) {
                return 1;
            }
            code = AppOpsManager.opToSwitch(code);
            UidState uidState = this.getUidStateLocked(uid, false);
            if (uidState != null && uidState.opModes != null && uidState.opModes.indexOfKey(code) >= 0) {
                return uidState.opModes.get(code);
            }
            Op op = this.getOpLocked(code, uid, resolvedPackageName, false);
            if (op == null) {
                return AppOpsManager.opToDefaultMode(code);
            }
            return op.mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkAudioOperation(int code, int usage, int uid, String packageName) {
        boolean suspended;
        try {
            suspended = this.isPackageSuspendedForUser(packageName, uid);
        }
        catch (IllegalArgumentException ex) {
            suspended = false;
        }
        if (suspended) {
            Slog.i(TAG, "Audio disabled for suspended package=" + packageName + " for uid=" + uid);
            return 1;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            int mode = this.checkRestrictionLocked(code, usage, uid, packageName);
            if (mode != 0) {
                return mode;
            }
            return this.checkOperation(code, uid, packageName);
        }
    }

    private boolean isPackageSuspendedForUser(String pkg, int uid) {
        try {
            return AppGlobals.getPackageManager().isPackageSuspendedForUser(pkg, UserHandle.getUserId(uid));
        }
        catch (RemoteException re) {
            throw new SecurityException("Could not talk to package manager service");
        }
    }

    private int checkRestrictionLocked(int code, int usage, int uid, String packageName) {
        Restriction r;
        SparseArray<Restriction> usageRestrictions = this.mAudioRestrictions.get(code);
        if (usageRestrictions != null && (r = usageRestrictions.get(usage)) != null && !r.exceptionPackages.contains(packageName)) {
            return r.mode;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAudioRestriction(int code, int usage, int uid, int mode, String[] exceptionPackages) {
        this.enforceManageAppOpsModes(Binder.getCallingPid(), Binder.getCallingUid(), uid);
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            SparseArray<Restriction> usageRestrictions = this.mAudioRestrictions.get(code);
            if (usageRestrictions == null) {
                usageRestrictions = new SparseArray();
                this.mAudioRestrictions.put(code, usageRestrictions);
            }
            usageRestrictions.remove(usage);
            if (mode != 0) {
                Restriction r = new Restriction();
                r.mode = mode;
                if (exceptionPackages != null) {
                    int N = exceptionPackages.length;
                    r.exceptionPackages = new ArraySet(N);
                    for (int i = 0; i < N; ++i) {
                        String pkg = exceptionPackages[i];
                        if (pkg == null) continue;
                        r.exceptionPackages.add(pkg.trim());
                    }
                }
                usageRestrictions.put(usage, r);
            }
        }
        this.mHandler.sendMessage(PooledLambda.obtainMessage(AppOpsService::notifyWatchersOfChange, this, code, -2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkPackage(int uid, String packageName) {
        Preconditions.checkNotNull(packageName);
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Ops ops = this.getOpsRawLocked(uid, packageName, true, true);
            if (ops != null) {
                return 0;
            }
            return 2;
        }
    }

    @Override
    public int noteProxyOperation(int code, String proxyPackageName, int proxiedUid, String proxiedPackageName) {
        this.verifyIncomingOp(code);
        int proxyUid = Binder.getCallingUid();
        String resolveProxyPackageName = AppOpsService.resolvePackageName(proxyUid, proxyPackageName);
        if (resolveProxyPackageName == null) {
            return 1;
        }
        int proxyMode = this.noteOperationUnchecked(code, proxyUid, resolveProxyPackageName, -1, null);
        if (proxyMode != 0 || Binder.getCallingUid() == proxiedUid) {
            return proxyMode;
        }
        String resolveProxiedPackageName = AppOpsService.resolvePackageName(proxiedUid, proxiedPackageName);
        if (resolveProxiedPackageName == null) {
            return 1;
        }
        return this.noteOperationUnchecked(code, proxiedUid, resolveProxiedPackageName, proxyMode, resolveProxyPackageName);
    }

    @Override
    public int noteOperation(int code, int uid, String packageName) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        String resolvedPackageName = AppOpsService.resolvePackageName(uid, packageName);
        if (resolvedPackageName == null) {
            return 1;
        }
        return this.noteOperationUnchecked(code, uid, resolvedPackageName, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int noteOperationUnchecked(int code, int uid, String packageName, int proxyUid, String proxyPackageName) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Ops ops = this.getOpsRawLocked(uid, packageName, true, false);
            if (ops == null) {
                return 2;
            }
            Op op = this.getOpLocked(ops, code, true);
            if (this.isOpRestrictedLocked(uid, code, packageName)) {
                return 1;
            }
            UidState uidState = ops.uidState;
            if (op.duration == -1) {
                Slog.w(TAG, "Noting op not finished: uid " + uid + " pkg " + packageName + " code " + code + " time=" + op.time[uidState.state] + " duration=" + op.duration);
            }
            op.duration = 0;
            int switchCode = AppOpsManager.opToSwitch(code);
            if (uidState.opModes != null && uidState.opModes.indexOfKey(switchCode) >= 0) {
                int uidMode = uidState.evalMode(uidState.opModes.get(switchCode));
                if (uidMode != 0) {
                    op.rejectTime[uidState.state] = System.currentTimeMillis();
                    return uidMode;
                }
            } else {
                Op switchOp = switchCode != code ? this.getOpLocked(ops, switchCode, true) : op;
                int mode = switchOp.getMode();
                if (mode != 0) {
                    op.rejectTime[uidState.state] = System.currentTimeMillis();
                    return mode;
                }
            }
            op.time[uidState.state] = System.currentTimeMillis();
            op.rejectTime[uidState.state] = 0L;
            op.proxyUid = proxyUid;
            op.proxyPackageName = proxyPackageName;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startWatchingActive(int[] ops, IAppOpsActiveCallback callback) {
        int watchedUid = -1;
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WATCH_APPOPS") != 0) {
            watchedUid = callingUid;
        }
        if (ops != null) {
            Preconditions.checkArrayElementsInRange(ops, 0, 77, "Invalid op code in: " + Arrays.toString(ops));
        }
        if (callback == null) {
            return;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            SparseArray<ActiveCallback> callbacks = this.mActiveWatchers.get(callback.asBinder());
            if (callbacks == null) {
                callbacks = new SparseArray();
                this.mActiveWatchers.put(callback.asBinder(), callbacks);
            }
            ActiveCallback activeCallback = new ActiveCallback(callback, watchedUid, callingUid, callingPid);
            for (int op : ops) {
                callbacks.put(op, activeCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWatchingActive(IAppOpsActiveCallback callback) {
        if (callback == null) {
            return;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            SparseArray<ActiveCallback> activeCallbacks = this.mActiveWatchers.remove(callback.asBinder());
            if (activeCallbacks == null) {
                return;
            }
            int callbackCount = activeCallbacks.size();
            for (int i = 0; i < callbackCount; ++i) {
                if (i != 0) continue;
                activeCallbacks.valueAt(i).destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int startOperation(IBinder token, int code, int uid, String packageName, boolean startIfModeDefault) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        String resolvedPackageName = AppOpsService.resolvePackageName(uid, packageName);
        if (resolvedPackageName == null) {
            return 1;
        }
        ClientState client = (ClientState)token;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Ops ops = this.getOpsRawLocked(uid, resolvedPackageName, true, false);
            if (ops == null) {
                return 2;
            }
            Op op = this.getOpLocked(ops, code, true);
            if (this.isOpRestrictedLocked(uid, code, resolvedPackageName)) {
                return 1;
            }
            int switchCode = AppOpsManager.opToSwitch(code);
            UidState uidState = ops.uidState;
            if (uidState.opModes != null && uidState.opModes.indexOfKey(switchCode) >= 0) {
                int uidMode = uidState.evalMode(uidState.opModes.get(switchCode));
                if (!(uidMode == 0 || startIfModeDefault && uidMode == 3)) {
                    op.rejectTime[uidState.state] = System.currentTimeMillis();
                    return uidMode;
                }
            } else {
                Op switchOp = switchCode != code ? this.getOpLocked(ops, switchCode, true) : op;
                int mode = switchOp.getMode();
                if (!(mode == 0 || startIfModeDefault && mode == 3)) {
                    op.rejectTime[uidState.state] = System.currentTimeMillis();
                    return mode;
                }
            }
            if (op.startNesting == 0) {
                op.startRealtime = SystemClock.elapsedRealtime();
                op.time[uidState.state] = System.currentTimeMillis();
                op.rejectTime[uidState.state] = 0L;
                op.duration = -1;
                this.scheduleOpActiveChangedIfNeededLocked(code, uid, packageName, true);
            }
            ++op.startNesting;
            ++uidState.startNesting;
            if (client.mStartedOps == null) return 0;
            client.mStartedOps.add(op);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishOperation(IBinder token, int code, int uid, String packageName) {
        this.verifyIncomingUid(uid);
        this.verifyIncomingOp(code);
        String resolvedPackageName = AppOpsService.resolvePackageName(uid, packageName);
        if (resolvedPackageName == null) {
            return;
        }
        if (!(token instanceof ClientState)) {
            return;
        }
        ClientState client = (ClientState)token;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            Op op = this.getOpLocked(code, uid, resolvedPackageName, true);
            if (op == null) {
                return;
            }
            if (!client.mStartedOps.remove(op)) {
                long identity = Binder.clearCallingIdentity();
                try {
                    if (LocalServices.getService(PackageManagerInternal.class).getPackageUid(resolvedPackageName, 0, UserHandle.getUserId(uid)) < 0) {
                        Slog.i(TAG, "Finishing op=" + AppOpsManager.opToName(code) + " for non-existing package=" + resolvedPackageName + " in uid=" + uid);
                        return;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
                Slog.wtf(TAG, "Operation not started: uid=" + op.uid + " pkg=" + op.packageName + " op=" + AppOpsManager.opToName(op.op));
                return;
            }
            this.finishOperationLocked(op, false);
            if (op.startNesting <= 0) {
                this.scheduleOpActiveChangedIfNeededLocked(code, uid, packageName, false);
            }
        }
    }

    private void scheduleOpActiveChangedIfNeededLocked(int code, int uid, String packageName, boolean active) {
        ArraySet<ActiveCallback> dispatchedCallbacks = null;
        int callbackListCount = this.mActiveWatchers.size();
        for (int i = 0; i < callbackListCount; ++i) {
            SparseArray<ActiveCallback> callbacks = this.mActiveWatchers.valueAt(i);
            ActiveCallback callback = callbacks.get(code);
            if (callback == null || callback.mWatchingUid >= 0 && callback.mWatchingUid != uid) continue;
            if (dispatchedCallbacks == null) {
                dispatchedCallbacks = new ArraySet<ActiveCallback>();
            }
            dispatchedCallbacks.add(callback);
        }
        if (dispatchedCallbacks == null) {
            return;
        }
        this.mHandler.sendMessage(PooledLambda.obtainMessage(AppOpsService::notifyOpActiveChanged, this, dispatchedCallbacks, code, uid, packageName, active));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOpActiveChanged(ArraySet<ActiveCallback> callbacks, int code, int uid, String packageName, boolean active) {
        long identity = Binder.clearCallingIdentity();
        try {
            int callbackCount = callbacks.size();
            for (int i = 0; i < callbackCount; ++i) {
                ActiveCallback callback = callbacks.valueAt(i);
                try {
                    callback.mCallback.opActiveChanged(code, uid, packageName, active);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @Override
    public int permissionToOpCode(String permission2) {
        if (permission2 == null) {
            return -1;
        }
        return AppOpsManager.permissionToOpCode(permission2);
    }

    void finishOperationLocked(Op op, boolean finishNested) {
        if (op.startNesting <= 1 || finishNested) {
            if (op.startNesting == 1 || finishNested) {
                op.duration = (int)(SystemClock.elapsedRealtime() - op.startRealtime);
                op.time[op.uidState.state] = System.currentTimeMillis();
            } else {
                Slog.w(TAG, "Finishing op nesting under-run: uid " + op.uid + " pkg " + op.packageName + " code " + op.op + " time=" + op.time + " duration=" + op.duration + " nesting=" + op.startNesting);
            }
            if (op.startNesting >= 1) {
                op.uidState.startNesting -= op.startNesting;
            }
            op.startNesting = 0;
        } else {
            --op.startNesting;
            --op.uidState.startNesting;
        }
    }

    private void verifyIncomingUid(int uid) {
        if (uid == Binder.getCallingUid()) {
            return;
        }
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    private void verifyIncomingOp(int op) {
        if (op >= 0 && op < 78) {
            return;
        }
        throw new IllegalArgumentException("Bad operation #" + op);
    }

    private UidState getUidStateLocked(int uid, boolean edit) {
        UidState uidState = this.mUidStates.get(uid);
        if (uidState == null) {
            if (!edit) {
                return null;
            }
            uidState = new UidState(uid);
            this.mUidStates.put(uid, uidState);
        } else if (uidState.pendingStateCommitTime != 0L) {
            if (uidState.pendingStateCommitTime < this.mLastUptime) {
                this.commitUidPendingStateLocked(uidState);
            } else {
                this.mLastUptime = SystemClock.uptimeMillis();
                if (uidState.pendingStateCommitTime < this.mLastUptime) {
                    this.commitUidPendingStateLocked(uidState);
                }
            }
        }
        return uidState;
    }

    private void commitUidPendingStateLocked(UidState uidState) {
        boolean lastForeground = uidState.state <= 2;
        boolean nowForeground = uidState.pendingState <= 2;
        uidState.state = uidState.pendingState;
        uidState.pendingStateCommitTime = 0L;
        if (uidState.hasForegroundWatchers && lastForeground != nowForeground) {
            for (int fgi = uidState.foregroundOps.size() - 1; fgi >= 0; --fgi) {
                int code;
                ArraySet<ModeCallback> callbacks;
                if (!uidState.foregroundOps.valueAt(fgi) || (callbacks = this.mOpModeWatchers.get(code = uidState.foregroundOps.keyAt(fgi))) == null) continue;
                for (int cbi = callbacks.size() - 1; cbi >= 0; --cbi) {
                    boolean doAllPackages;
                    ModeCallback callback = callbacks.valueAt(cbi);
                    if ((callback.mFlags & 1) == 0 || !callback.isWatchingUid(uidState.uid)) continue;
                    boolean bl = doAllPackages = uidState.opModes != null && uidState.opModes.get(code) == 4;
                    if (uidState.pkgOps == null) continue;
                    for (int pkgi = uidState.pkgOps.size() - 1; pkgi >= 0; --pkgi) {
                        Op op = (Op)uidState.pkgOps.valueAt(pkgi).get(code);
                        if (!doAllPackages && (op == null || op.mode != 4)) continue;
                        this.mHandler.sendMessage(PooledLambda.obtainMessage(AppOpsService::notifyOpChanged, this, callback, code, uidState.uid, uidState.pkgOps.keyAt(pkgi)));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ops getOpsRawLocked(int uid, String packageName, boolean edit, boolean uidMismatchExpected) {
        Ops ops;
        UidState uidState = this.getUidStateLocked(uid, edit);
        if (uidState == null) {
            return null;
        }
        if (uidState.pkgOps == null) {
            if (!edit) {
                return null;
            }
            uidState.pkgOps = new ArrayMap();
        }
        if ((ops = uidState.pkgOps.get(packageName)) == null) {
            if (!edit) {
                return null;
            }
            boolean isPrivileged = false;
            if (uid != 0) {
                long ident = Binder.clearCallingIdentity();
                try {
                    int pkgUid = -1;
                    try {
                        ApplicationInfo appInfo = ActivityThread.getPackageManager().getApplicationInfo(packageName, 0x10000000, UserHandle.getUserId(uid));
                        if (appInfo != null) {
                            pkgUid = appInfo.uid;
                            isPrivileged = (appInfo.privateFlags & 8) != 0;
                        } else {
                            pkgUid = AppOpsService.resolveUid(packageName);
                            if (pkgUid >= 0) {
                                isPrivileged = false;
                            }
                        }
                    }
                    catch (RemoteException e) {
                        Slog.w(TAG, "Could not contact PackageManager", e);
                    }
                    if (pkgUid != uid) {
                        if (!uidMismatchExpected) {
                            RuntimeException ex = new RuntimeException("here");
                            ex.fillInStackTrace();
                            Slog.w(TAG, "Bad call: specified package " + packageName + " under uid " + uid + " but it is really " + pkgUid, ex);
                        }
                        Ops ops2 = null;
                        return ops2;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            ops = new Ops(packageName, uidState, isPrivileged);
            uidState.pkgOps.put(packageName, ops);
        }
        return ops;
    }

    private void scheduleWriteLocked() {
        if (!this.mWriteScheduled) {
            this.mWriteScheduled = true;
            this.mHandler.postDelayed(this.mWriteRunner, 1800000L);
        }
    }

    private void scheduleFastWriteLocked() {
        if (!this.mFastWriteScheduled) {
            this.mWriteScheduled = true;
            this.mFastWriteScheduled = true;
            this.mHandler.removeCallbacks(this.mWriteRunner);
            this.mHandler.postDelayed(this.mWriteRunner, 10000L);
        }
    }

    private Op getOpLocked(int code, int uid, String packageName, boolean edit) {
        Ops ops = this.getOpsRawLocked(uid, packageName, edit, false);
        if (ops == null) {
            return null;
        }
        return this.getOpLocked(ops, code, edit);
    }

    private Op getOpLocked(Ops ops, int code, boolean edit) {
        Op op = (Op)ops.get(code);
        if (op == null) {
            if (!edit) {
                return null;
            }
            op = new Op(ops.uidState, ops.packageName, code);
            ops.put(code, op);
        }
        if (edit) {
            this.scheduleWriteLocked();
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOpRestrictedLocked(int uid, int code, String packageName) {
        int userHandle = UserHandle.getUserId(uid);
        int restrictionSetCount = this.mOpUserRestrictions.size();
        for (int i = 0; i < restrictionSetCount; ++i) {
            ClientRestrictionState restrictionState = this.mOpUserRestrictions.valueAt(i);
            if (!restrictionState.hasRestriction(code, packageName, userHandle)) continue;
            if (AppOpsManager.opAllowSystemBypassRestriction(code)) {
                AppOpsService appOpsService = this;
                synchronized (appOpsService) {
                    Ops ops = this.getOpsRawLocked(uid, packageName, true, false);
                    if (ops != null && ops.isPrivileged) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readState() {
        int oldVersion = -1;
        Object object = this.mFile;
        synchronized (object) {
            AppOpsService appOpsService = this;
            synchronized (appOpsService) {
                FileInputStream stream;
                try {
                    stream = this.mFile.openRead();
                }
                catch (FileNotFoundException e) {
                    Slog.i(TAG, "No existing app ops " + this.mFile.getBaseFile() + "; starting empty");
                    return;
                }
                boolean success = false;
                this.mUidStates.clear();
                try {
                    int type;
                    XmlPullParser parser = Xml.newPullParser();
                    parser.setInput(stream, StandardCharsets.UTF_8.name());
                    while ((type = parser.next()) != 2 && type != 1) {
                    }
                    if (type != 2) {
                        throw new IllegalStateException("no start tag found");
                    }
                    String versionString = parser.getAttributeValue(null, "v");
                    if (versionString != null) {
                        oldVersion = Integer.parseInt(versionString);
                    }
                    int outerDepth = parser.getDepth();
                    while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                        if (type == 3 || type == 4) continue;
                        String tagName = parser.getName();
                        if (tagName.equals("pkg")) {
                            this.readPackage(parser);
                            continue;
                        }
                        if (tagName.equals("uid")) {
                            this.readUidOps(parser);
                            continue;
                        }
                        Slog.w(TAG, "Unknown element under <app-ops>: " + parser.getName());
                        XmlUtils.skipCurrentTag(parser);
                    }
                    success = true;
                }
                catch (IllegalStateException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (NullPointerException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (NumberFormatException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (XmlPullParserException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                catch (IndexOutOfBoundsException e) {
                    Slog.w(TAG, "Failed parsing " + e);
                }
                finally {
                    if (!success) {
                        this.mUidStates.clear();
                    }
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        object = this;
        synchronized (object) {
            this.upgradeLocked(oldVersion);
        }
    }

    private void upgradeRunAnyInBackgroundLocked() {
        for (int i = 0; i < this.mUidStates.size(); ++i) {
            int idx;
            UidState uidState = this.mUidStates.valueAt(i);
            if (uidState == null) continue;
            if (uidState.opModes != null && (idx = uidState.opModes.indexOfKey(63)) >= 0) {
                uidState.opModes.put(70, uidState.opModes.valueAt(idx));
            }
            if (uidState.pkgOps == null) continue;
            boolean changed = false;
            for (int j = 0; j < uidState.pkgOps.size(); ++j) {
                Op op;
                Ops ops = uidState.pkgOps.valueAt(j);
                if (ops == null || (op = (Op)ops.get(63)) == null || op.mode == AppOpsManager.opToDefaultMode(op.op)) continue;
                Op copy = new Op(op.uidState, op.packageName, 70);
                copy.mode = op.mode;
                ops.put(70, copy);
                changed = true;
            }
            if (!changed) continue;
            uidState.evalForegroundOps(this.mOpModeWatchers);
        }
    }

    private void upgradeLocked(int oldVersion) {
        if (oldVersion >= 1) {
            return;
        }
        Slog.d(TAG, "Upgrading app-ops xml from version " + oldVersion + " to " + 1);
        switch (oldVersion) {
            case -1: {
                this.upgradeRunAnyInBackgroundLocked();
            }
        }
        this.scheduleFastWriteLocked();
    }

    void readUidOps(XmlPullParser parser) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        int uid = Integer.parseInt(parser.getAttributeValue(null, "n"));
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("op")) {
                int code = Integer.parseInt(parser.getAttributeValue(null, "n"));
                int mode = Integer.parseInt(parser.getAttributeValue(null, "m"));
                UidState uidState = this.getUidStateLocked(uid, true);
                if (uidState.opModes == null) {
                    uidState.opModes = new SparseIntArray();
                }
                uidState.opModes.put(code, mode);
                continue;
            }
            Slog.w(TAG, "Unknown element under <uid-ops>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    void readPackage(XmlPullParser parser) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        String pkgName = parser.getAttributeValue(null, "n");
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("uid")) {
                this.readUid(parser, pkgName);
                continue;
            }
            Slog.w(TAG, "Unknown element under <pkg>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    void readUid(XmlPullParser parser, String pkgName) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        boolean isPrivileged;
        int uid;
        block52: {
            uid = Integer.parseInt(parser.getAttributeValue(null, "n"));
            String isPrivilegedString = parser.getAttributeValue(null, "p");
            isPrivileged = false;
            if (isPrivilegedString == null) {
                try {
                    IPackageManager packageManager = ActivityThread.getPackageManager();
                    if (packageManager != null) {
                        ApplicationInfo appInfo = ActivityThread.getPackageManager().getApplicationInfo(pkgName, 0, UserHandle.getUserId(uid));
                        if (appInfo != null) {
                            isPrivileged = (appInfo.privateFlags & 8) != 0;
                        }
                        break block52;
                    }
                    return;
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Could not contact PackageManager", e);
                }
            } else {
                isPrivileged = Boolean.parseBoolean(isPrivilegedString);
            }
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("op")) {
                UidState uidState = this.getUidStateLocked(uid, true);
                if (uidState.pkgOps == null) {
                    uidState.pkgOps = new ArrayMap();
                }
                Op op = new Op(uidState, pkgName, Integer.parseInt(parser.getAttributeValue(null, "n")));
                block43: for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
                    String name = parser.getAttributeName(i);
                    String value = parser.getAttributeValue(i);
                    switch (name) {
                        case "m": {
                            op.mode = Integer.parseInt(value);
                            continue block43;
                        }
                        case "d": {
                            op.duration = Integer.parseInt(value);
                            continue block43;
                        }
                        case "pu": {
                            op.proxyUid = Integer.parseInt(value);
                            continue block43;
                        }
                        case "pp": {
                            op.proxyPackageName = value;
                            continue block43;
                        }
                        case "tp": {
                            op.time[0] = Long.parseLong(value);
                            continue block43;
                        }
                        case "tt": {
                            op.time[1] = Long.parseLong(value);
                            continue block43;
                        }
                        case "tfs": {
                            op.time[2] = Long.parseLong(value);
                            continue block43;
                        }
                        case "tf": {
                            op.time[3] = Long.parseLong(value);
                            continue block43;
                        }
                        case "tb": {
                            op.time[4] = Long.parseLong(value);
                            continue block43;
                        }
                        case "tc": {
                            op.time[5] = Long.parseLong(value);
                            continue block43;
                        }
                        case "rp": {
                            op.rejectTime[0] = Long.parseLong(value);
                            continue block43;
                        }
                        case "rt": {
                            op.rejectTime[1] = Long.parseLong(value);
                            continue block43;
                        }
                        case "rfs": {
                            op.rejectTime[2] = Long.parseLong(value);
                            continue block43;
                        }
                        case "rf": {
                            op.rejectTime[3] = Long.parseLong(value);
                            continue block43;
                        }
                        case "rb": {
                            op.rejectTime[4] = Long.parseLong(value);
                            continue block43;
                        }
                        case "rc": {
                            op.rejectTime[5] = Long.parseLong(value);
                            continue block43;
                        }
                        case "t": {
                            op.time[1] = Long.parseLong(value);
                            continue block43;
                        }
                        case "r": {
                            op.rejectTime[1] = Long.parseLong(value);
                            continue block43;
                        }
                        default: {
                            Slog.w(TAG, "Unknown attribute in 'op' tag: " + name);
                        }
                    }
                }
                Ops ops = uidState.pkgOps.get(pkgName);
                if (ops == null) {
                    ops = new Ops(pkgName, uidState, isPrivileged);
                    uidState.pkgOps.put(pkgName, ops);
                }
                ops.put(op.op, op);
                continue;
            }
            Slog.w(TAG, "Unknown element under <pkg>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        UidState uidState = this.getUidStateLocked(uid, false);
        if (uidState != null) {
            uidState.evalForegroundOps(this.mOpModeWatchers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeState() {
        AtomicFile atomicFile = this.mFile;
        synchronized (atomicFile) {
            FileOutputStream stream;
            try {
                stream = this.mFile.startWrite();
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to write state: " + e);
                return;
            }
            List<AppOpsManager.PackageOps> allOps = this.getPackagesForOps(null);
            try {
                int j;
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(stream, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, "app-ops");
                out.attribute(null, "v", String.valueOf(1));
                int uidStateCount = this.mUidStates.size();
                for (int i = 0; i < uidStateCount; ++i) {
                    UidState uidState = this.mUidStates.valueAt(i);
                    if (uidState.opModes == null || uidState.opModes.size() <= 0) continue;
                    out.startTag(null, "uid");
                    out.attribute(null, "n", Integer.toString(uidState.uid));
                    SparseIntArray uidOpModes = uidState.opModes;
                    int opCount = uidOpModes.size();
                    for (j = 0; j < opCount; ++j) {
                        int op = uidOpModes.keyAt(j);
                        int mode = uidOpModes.valueAt(j);
                        out.startTag(null, "op");
                        out.attribute(null, "n", Integer.toString(op));
                        out.attribute(null, "m", Integer.toString(mode));
                        out.endTag(null, "op");
                    }
                    out.endTag(null, "uid");
                }
                if (allOps != null) {
                    String lastPkg = null;
                    for (int i = 0; i < allOps.size(); ++i) {
                        AppOpsManager.PackageOps pkg = allOps.get(i);
                        if (!pkg.getPackageName().equals(lastPkg)) {
                            if (lastPkg != null) {
                                out.endTag(null, "pkg");
                            }
                            lastPkg = pkg.getPackageName();
                            out.startTag(null, "pkg");
                            out.attribute(null, "n", lastPkg);
                        }
                        out.startTag(null, "uid");
                        out.attribute(null, "n", Integer.toString(pkg.getUid()));
                        AppOpsService opCount = this;
                        synchronized (opCount) {
                            Ops ops = this.getOpsRawLocked(pkg.getUid(), pkg.getPackageName(), false, false);
                            if (ops != null) {
                                out.attribute(null, "p", Boolean.toString(ops.isPrivileged));
                            } else {
                                out.attribute(null, "p", Boolean.toString(false));
                            }
                        }
                        List<AppOpsManager.OpEntry> ops = pkg.getOps();
                        for (j = 0; j < ops.size(); ++j) {
                            String proxyPackageName;
                            int proxyUid;
                            AppOpsManager.OpEntry op = ops.get(j);
                            out.startTag(null, "op");
                            out.attribute(null, "n", Integer.toString(op.getOp()));
                            if (op.getMode() != AppOpsManager.opToDefaultMode(op.getOp())) {
                                out.attribute(null, "m", Integer.toString(op.getMode()));
                            }
                            for (int k = 0; k < 6; ++k) {
                                long rejectTime;
                                long time = op.getLastTimeFor(k);
                                if (time != 0L) {
                                    out.attribute(null, UID_STATE_TIME_ATTRS[k], Long.toString(time));
                                }
                                if ((rejectTime = op.getLastRejectTimeFor(k)) == 0L) continue;
                                out.attribute(null, UID_STATE_REJECT_ATTRS[k], Long.toString(rejectTime));
                            }
                            int dur = op.getDuration();
                            if (dur != 0) {
                                out.attribute(null, "d", Integer.toString(dur));
                            }
                            if ((proxyUid = op.getProxyUid()) != -1) {
                                out.attribute(null, "pu", Integer.toString(proxyUid));
                            }
                            if ((proxyPackageName = op.getProxyPackageName()) != null) {
                                out.attribute(null, "pp", proxyPackageName);
                            }
                            out.endTag(null, "op");
                        }
                        out.endTag(null, "uid");
                    }
                    if (lastPkg != null) {
                        out.endTag(null, "pkg");
                    }
                }
                out.endTag(null, "app-ops");
                out.endDocument();
                this.mFile.finishWrite(stream);
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to write state, restoring backup.", e);
                this.mFile.failWrite(stream);
            }
        }
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new Shell(this, this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    static void dumpCommandHelp(PrintWriter pw) {
        pw.println("AppOps service (appops) commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("  start [--user <USER_ID>] <PACKAGE | UID> <OP> ");
        pw.println("    Starts a given operation for a particular application.");
        pw.println("  stop [--user <USER_ID>] <PACKAGE | UID> <OP> ");
        pw.println("    Stops a given operation for a particular application.");
        pw.println("  set [--user <USER_ID>] <PACKAGE | UID> <OP> <MODE>");
        pw.println("    Set the mode for a particular application and operation.");
        pw.println("  get [--user <USER_ID>] <PACKAGE | UID> [<OP>]");
        pw.println("    Return the mode for a particular application and optional operation.");
        pw.println("  query-op [--user <USER_ID>] <OP> [<MODE>]");
        pw.println("    Print all packages that currently have the given op in the given mode.");
        pw.println("  reset [--user <USER_ID>] [<PACKAGE>]");
        pw.println("    Reset the given application or all applications to default modes.");
        pw.println("  write-settings");
        pw.println("    Immediately write pending changes to storage.");
        pw.println("  read-settings");
        pw.println("    Read the last written settings, replacing current state in RAM.");
        pw.println("  options:");
        pw.println("    <PACKAGE> an Android package name.");
        pw.println("    <OP>      an AppOps operation.");
        pw.println("    <MODE>    one of allow, ignore, deny, or default");
        pw.println("    <USER_ID> the user id under which the package is installed. If --user is not");
        pw.println("              specified, the current user is assumed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int onShellCommand(Shell shell, String cmd) {
        if (cmd == null) {
            return shell.handleDefaultCommands(cmd);
        }
        PrintWriter pw = shell.getOutPrintWriter();
        PrintWriter err = shell.getErrPrintWriter();
        try {
            switch (cmd) {
                case "set": {
                    int res = shell.parseUserPackageOp(true, err);
                    if (res < 0) {
                        return res;
                    }
                    String modeStr = shell.getNextArg();
                    if (modeStr == null) {
                        err.println("Error: Mode not specified.");
                        return -1;
                    }
                    int mode = Shell.strModeToMode(modeStr, err);
                    if (mode < 0) {
                        return -1;
                    }
                    if (shell.packageName != null) {
                        shell.mInterface.setMode(shell.op, shell.packageUid, shell.packageName, mode);
                    } else {
                        shell.mInterface.setUidMode(shell.op, shell.nonpackageUid, mode);
                    }
                    return 0;
                }
                case "get": {
                    List<AppOpsManager.PackageOps> ops;
                    int res = shell.parseUserPackageOp(false, err);
                    if (res < 0) {
                        return res;
                    }
                    if (shell.packageName != null) {
                        int[] nArray;
                        IAppOpsService iAppOpsService = shell.mInterface;
                        int n = shell.packageUid;
                        String string2 = shell.packageName;
                        if (shell.op != -1) {
                            int[] nArray2 = new int[1];
                            nArray = nArray2;
                            nArray2[0] = shell.op;
                        } else {
                            nArray = null;
                        }
                        ops = iAppOpsService.getOpsForPackage(n, string2, nArray);
                    } else {
                        int[] nArray;
                        IAppOpsService iAppOpsService = shell.mInterface;
                        int n = shell.nonpackageUid;
                        if (shell.op != -1) {
                            int[] nArray3 = new int[1];
                            nArray = nArray3;
                            nArray3[0] = shell.op;
                        } else {
                            nArray = null;
                        }
                        ops = iAppOpsService.getUidOps(n, nArray);
                    }
                    if (ops == null || ops.size() <= 0) {
                        pw.println("No operations.");
                        if (shell.op > -1 && shell.op < 78) {
                            pw.println("Default mode: " + AppOpsManager.modeToName(AppOpsManager.opToDefaultMode(shell.op)));
                        }
                        return 0;
                    }
                    long now = System.currentTimeMillis();
                    for (int i = 0; i < ops.size(); ++i) {
                        List<AppOpsManager.OpEntry> entries = ops.get(i).getOps();
                        for (int j = 0; j < entries.size(); ++j) {
                            AppOpsManager.OpEntry ent = entries.get(j);
                            pw.print(AppOpsManager.opToName(ent.getOp()));
                            pw.print(": ");
                            pw.print(AppOpsManager.modeToName(ent.getMode()));
                            if (ent.getTime() != 0L) {
                                pw.print("; time=");
                                TimeUtils.formatDuration(now - ent.getTime(), pw);
                                pw.print(" ago");
                            }
                            if (ent.getRejectTime() != 0L) {
                                pw.print("; rejectTime=");
                                TimeUtils.formatDuration(now - ent.getRejectTime(), pw);
                                pw.print(" ago");
                            }
                            if (ent.getDuration() == -1) {
                                pw.print(" (running)");
                            } else if (ent.getDuration() != 0) {
                                pw.print("; duration=");
                                TimeUtils.formatDuration((long)ent.getDuration(), pw);
                            }
                            pw.println();
                        }
                    }
                    return 0;
                }
                case "query-op": {
                    int res = shell.parseUserOpMode(1, err);
                    if (res < 0) {
                        return res;
                    }
                    List<AppOpsManager.PackageOps> ops = shell.mInterface.getPackagesForOps(new int[]{shell.op});
                    if (ops == null || ops.size() <= 0) {
                        pw.println("No operations.");
                        return 0;
                    }
                    for (int i = 0; i < ops.size(); ++i) {
                        AppOpsManager.PackageOps pkg = ops.get(i);
                        boolean hasMatch = false;
                        List<AppOpsManager.OpEntry> entries = ops.get(i).getOps();
                        for (int j = 0; j < entries.size(); ++j) {
                            AppOpsManager.OpEntry ent = entries.get(j);
                            if (ent.getOp() != shell.op || ent.getMode() != shell.mode) continue;
                            hasMatch = true;
                            break;
                        }
                        if (!hasMatch) continue;
                        pw.println(pkg.getPackageName());
                    }
                    return 0;
                }
                case "reset": {
                    String argument;
                    String packageName = null;
                    int userId = -2;
                    while ((argument = shell.getNextArg()) != null) {
                        if ("--user".equals(argument)) {
                            String userStr = shell.getNextArgRequired();
                            userId = UserHandle.parseUserArg(userStr);
                            continue;
                        }
                        if (packageName == null) {
                            packageName = argument;
                            continue;
                        }
                        err.println("Error: Unsupported argument: " + argument);
                        return -1;
                    }
                    if (userId == -2) {
                        userId = ActivityManager.getCurrentUser();
                    }
                    shell.mInterface.resetAllModes(userId, packageName);
                    pw.print("Reset all modes for: ");
                    if (userId == -1) {
                        pw.print("all users");
                    } else {
                        pw.print("user ");
                        pw.print(userId);
                    }
                    pw.print(", ");
                    if (packageName == null) {
                        pw.println("all packages");
                    } else {
                        pw.print("package ");
                        pw.println(packageName);
                    }
                    return 0;
                }
                case "write-settings": {
                    shell.mInternal.enforceManageAppOpsModes(Binder.getCallingPid(), Binder.getCallingUid(), -1);
                    long token = Binder.clearCallingIdentity();
                    try {
                        AppOpsService appOpsService = shell.mInternal;
                        synchronized (appOpsService) {
                            shell.mInternal.mHandler.removeCallbacks(shell.mInternal.mWriteRunner);
                        }
                        shell.mInternal.writeState();
                        pw.println("Current settings written.");
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                    return 0;
                }
                case "read-settings": {
                    shell.mInternal.enforceManageAppOpsModes(Binder.getCallingPid(), Binder.getCallingUid(), -1);
                    long token = Binder.clearCallingIdentity();
                    try {
                        shell.mInternal.readState();
                        pw.println("Last settings read.");
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                    return 0;
                }
                case "start": {
                    int res = shell.parseUserPackageOp(true, err);
                    if (res < 0) {
                        return res;
                    }
                    if (shell.packageName == null) {
                        return -1;
                    }
                    shell.mInterface.startOperation(shell.mToken, shell.op, shell.packageUid, shell.packageName, true);
                    return 0;
                }
                case "stop": {
                    int res = shell.parseUserPackageOp(true, err);
                    if (res < 0) {
                        return res;
                    }
                    if (shell.packageName == null) {
                        return -1;
                    }
                    shell.mInterface.finishOperation(shell.mToken, shell.op, shell.packageUid, shell.packageName);
                    return 0;
                }
            }
            return shell.handleDefaultCommands(cmd);
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
            return -1;
        }
    }

    private void dumpHelp(PrintWriter pw) {
        pw.println("AppOps service (appops) dump options:");
        pw.println("  -h");
        pw.println("    Print this help text.");
        pw.println("  --op [OP]");
        pw.println("    Limit output to data associated with the given app op code.");
        pw.println("  --mode [MODE]");
        pw.println("    Limit output to data associated with the given app op mode.");
        pw.println("  --package [PACKAGE]");
        pw.println("    Limit output to data associated with the given package name.");
    }

    private void dumpTimesLocked(PrintWriter pw, String firstPrefix, String prefix, long[] times, long now, SimpleDateFormat sdf, Date date) {
        boolean hasTime = false;
        for (int i = 0; i < 6; ++i) {
            if (times[i] == 0L) continue;
            hasTime = true;
            break;
        }
        if (!hasTime) {
            return;
        }
        boolean first = true;
        for (int i = 0; i < 6; ++i) {
            if (times[i] == 0L) continue;
            pw.print(first ? firstPrefix : prefix);
            first = false;
            pw.print(UID_STATE_NAMES[i]);
            pw.print(" = ");
            date.setTime(times[i]);
            pw.print(sdf.format(date));
            pw.print(" (");
            TimeUtils.formatDuration(times[i] - now, pw);
            pw.println(")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, pw)) {
            return;
        }
        int dumpOp = -1;
        String dumpPackage = null;
        int dumpUid = -1;
        int dumpMode = -1;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("-h".equals(arg)) {
                    this.dumpHelp(pw);
                    return;
                }
                if ("-a".equals(arg)) continue;
                if ("--op".equals(arg)) {
                    if (++i >= args.length) {
                        pw.println("No argument for --op option");
                        return;
                    }
                    dumpOp = Shell.strOpToOp(args[i], pw);
                    if (dumpOp >= 0) continue;
                    return;
                }
                if ("--package".equals(arg)) {
                    if (++i >= args.length) {
                        pw.println("No argument for --package option");
                        return;
                    }
                    dumpPackage = args[i];
                    try {
                        dumpUid = AppGlobals.getPackageManager().getPackageUid(dumpPackage, 0xC02000, 0);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (dumpUid < 0) {
                        pw.println("Unknown package: " + dumpPackage);
                        return;
                    }
                    dumpUid = UserHandle.getAppId(dumpUid);
                    continue;
                }
                if ("--mode".equals(arg)) {
                    if (++i >= args.length) {
                        pw.println("No argument for --mode option");
                        return;
                    }
                    dumpMode = Shell.strModeToMode(args[i], pw);
                    if (dumpMode >= 0) continue;
                    return;
                }
                if (arg.length() > 0 && arg.charAt(0) == '-') {
                    pw.println("Unknown option: " + arg);
                    return;
                }
                pw.println("Unknown command: " + arg);
                return;
            }
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            int j;
            int j2;
            int i;
            boolean printedHeader;
            pw.println("Current AppOps Service state:");
            this.mConstants.dump(pw);
            pw.println();
            long now = System.currentTimeMillis();
            long nowElapsed = SystemClock.elapsedRealtime();
            long nowUptime = SystemClock.uptimeMillis();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Date date = new Date();
            boolean needSep = false;
            if (dumpOp < 0 && dumpMode < 0 && dumpPackage == null && this.mProfileOwners != null) {
                pw.println("  Profile owners:");
                for (int poi = 0; poi < this.mProfileOwners.size(); ++poi) {
                    pw.print("    User #");
                    pw.print(this.mProfileOwners.keyAt(poi));
                    pw.print(": ");
                    UserHandle.formatUid(pw, this.mProfileOwners.valueAt(poi));
                    pw.println();
                }
                pw.println();
            }
            if (this.mOpModeWatchers.size() > 0) {
                printedHeader = false;
                for (i = 0; i < this.mOpModeWatchers.size(); ++i) {
                    if (dumpOp >= 0 && dumpOp != this.mOpModeWatchers.keyAt(i)) continue;
                    boolean printedOpHeader = false;
                    ArraySet<ModeCallback> callbacks = this.mOpModeWatchers.valueAt(i);
                    for (j2 = 0; j2 < callbacks.size(); ++j2) {
                        ModeCallback cb = callbacks.valueAt(j2);
                        if (dumpPackage != null && cb.mWatchingUid >= 0 && dumpUid != UserHandle.getAppId(cb.mWatchingUid)) continue;
                        needSep = true;
                        if (!printedHeader) {
                            pw.println("  Op mode watchers:");
                            printedHeader = true;
                        }
                        if (!printedOpHeader) {
                            pw.print("    Op ");
                            pw.print(AppOpsManager.opToName(this.mOpModeWatchers.keyAt(i)));
                            pw.println(":");
                            printedOpHeader = true;
                        }
                        pw.print("      #");
                        pw.print(j2);
                        pw.print(": ");
                        pw.println(cb);
                    }
                }
            }
            if (this.mPackageModeWatchers.size() > 0 && dumpOp < 0) {
                printedHeader = false;
                for (i = 0; i < this.mPackageModeWatchers.size(); ++i) {
                    if (dumpPackage != null && !dumpPackage.equals(this.mPackageModeWatchers.keyAt(i))) continue;
                    needSep = true;
                    if (!printedHeader) {
                        pw.println("  Package mode watchers:");
                        printedHeader = true;
                    }
                    pw.print("    Pkg ");
                    pw.print(this.mPackageModeWatchers.keyAt(i));
                    pw.println(":");
                    ArraySet<ModeCallback> callbacks = this.mPackageModeWatchers.valueAt(i);
                    for (int j3 = 0; j3 < callbacks.size(); ++j3) {
                        pw.print("      #");
                        pw.print(j3);
                        pw.print(": ");
                        pw.println(callbacks.valueAt(j3));
                    }
                }
            }
            if (this.mModeWatchers.size() > 0 && dumpOp < 0) {
                printedHeader = false;
                for (i = 0; i < this.mModeWatchers.size(); ++i) {
                    ModeCallback cb = this.mModeWatchers.valueAt(i);
                    if (dumpPackage != null && cb.mWatchingUid >= 0 && dumpUid != UserHandle.getAppId(cb.mWatchingUid)) continue;
                    needSep = true;
                    if (!printedHeader) {
                        pw.println("  All op mode watchers:");
                        printedHeader = true;
                    }
                    pw.print("    ");
                    pw.print(Integer.toHexString(System.identityHashCode(this.mModeWatchers.keyAt(i))));
                    pw.print(": ");
                    pw.println(cb);
                }
            }
            if (this.mActiveWatchers.size() > 0 && dumpMode < 0) {
                needSep = true;
                printedHeader = false;
                for (i = 0; i < this.mActiveWatchers.size(); ++i) {
                    SparseArray<ActiveCallback> activeWatchers = this.mActiveWatchers.valueAt(i);
                    if (activeWatchers.size() <= 0) continue;
                    ActiveCallback cb = activeWatchers.valueAt(0);
                    if (dumpOp >= 0 && activeWatchers.indexOfKey(dumpOp) < 0 || dumpPackage != null && cb.mWatchingUid >= 0 && dumpUid != UserHandle.getAppId(cb.mWatchingUid)) continue;
                    if (!printedHeader) {
                        pw.println("  All op active watchers:");
                        printedHeader = true;
                    }
                    pw.print("    ");
                    pw.print(Integer.toHexString(System.identityHashCode(this.mActiveWatchers.keyAt(i))));
                    pw.println(" ->");
                    pw.print("        [");
                    int opCount = activeWatchers.size();
                    for (i = 0; i < opCount; ++i) {
                        if (i > 0) {
                            pw.print(' ');
                        }
                        pw.print(AppOpsManager.opToName(activeWatchers.keyAt(i)));
                        if (i >= opCount - 1) continue;
                        pw.print(',');
                    }
                    pw.println("]");
                    pw.print("        ");
                    pw.println(cb);
                }
            }
            if (this.mClients.size() > 0 && dumpMode < 0) {
                needSep = true;
                printedHeader = false;
                for (i = 0; i < this.mClients.size(); ++i) {
                    boolean printedClient = false;
                    ClientState cs = this.mClients.valueAt(i);
                    if (cs.mStartedOps.size() <= 0) continue;
                    boolean printedStarted = false;
                    for (int j4 = 0; j4 < cs.mStartedOps.size(); ++j4) {
                        Op op = cs.mStartedOps.get(j4);
                        if (dumpOp >= 0 && op.op != dumpOp || dumpPackage != null && !dumpPackage.equals(op.packageName)) continue;
                        if (!printedHeader) {
                            pw.println("  Clients:");
                            printedHeader = true;
                        }
                        if (!printedClient) {
                            pw.print("    ");
                            pw.print(this.mClients.keyAt(i));
                            pw.println(":");
                            pw.print("      ");
                            pw.println(cs);
                            printedClient = true;
                        }
                        if (!printedStarted) {
                            pw.println("      Started ops:");
                            printedStarted = true;
                        }
                        pw.print("        ");
                        pw.print("uid=");
                        pw.print(op.uid);
                        pw.print(" pkg=");
                        pw.print(op.packageName);
                        pw.print(" op=");
                        pw.println(AppOpsManager.opToName(op.op));
                    }
                }
            }
            if (this.mAudioRestrictions.size() > 0 && dumpOp < 0 && dumpPackage != null && dumpMode < 0) {
                printedHeader = false;
                for (int o = 0; o < this.mAudioRestrictions.size(); ++o) {
                    String op = AppOpsManager.opToName(this.mAudioRestrictions.keyAt(o));
                    SparseArray<Restriction> restrictions = this.mAudioRestrictions.valueAt(o);
                    for (int i2 = 0; i2 < restrictions.size(); ++i2) {
                        if (!printedHeader) {
                            pw.println("  Audio Restrictions:");
                            printedHeader = true;
                            needSep = true;
                        }
                        int usage = restrictions.keyAt(i2);
                        pw.print("    ");
                        pw.print(op);
                        pw.print(" usage=");
                        pw.print(AudioAttributes.usageToString(usage));
                        Restriction r = restrictions.valueAt(i2);
                        pw.print(": mode=");
                        pw.println(AppOpsManager.modeToName(r.mode));
                        if (r.exceptionPackages.isEmpty()) continue;
                        pw.println("      Exceptions:");
                        for (j = 0; j < r.exceptionPackages.size(); ++j) {
                            pw.print("        ");
                            pw.println(r.exceptionPackages.valueAt(j));
                        }
                    }
                }
            }
            if (needSep) {
                pw.println();
            }
            for (int i3 = 0; i3 < this.mUidStates.size(); ++i3) {
                UidState uidState = this.mUidStates.valueAt(i3);
                SparseIntArray opModes = uidState.opModes;
                ArrayMap<String, Ops> pkgOps = uidState.pkgOps;
                if (dumpOp >= 0 || dumpPackage != null || dumpMode >= 0) {
                    boolean hasMode;
                    boolean hasOp = dumpOp < 0 || uidState.opModes != null && uidState.opModes.indexOfKey(dumpOp) >= 0;
                    boolean hasPackage = dumpPackage == null;
                    boolean bl = hasMode = dumpMode < 0;
                    if (!hasMode && opModes != null) {
                        for (int opi = 0; !hasMode && opi < opModes.size(); ++opi) {
                            if (opModes.valueAt(opi) != dumpMode) continue;
                            hasMode = true;
                        }
                    }
                    if (pkgOps != null) {
                        for (int pkgi = 0; !(hasOp && hasPackage && hasMode || pkgi >= pkgOps.size()); ++pkgi) {
                            Ops ops = pkgOps.valueAt(pkgi);
                            if (!hasOp && ops != null && ops.indexOfKey(dumpOp) >= 0) {
                                hasOp = true;
                            }
                            if (!hasMode) {
                                for (int opi = 0; !hasMode && opi < ops.size(); ++opi) {
                                    if (((Op)ops.valueAt((int)opi)).mode != dumpMode) continue;
                                    hasMode = true;
                                }
                            }
                            if (hasPackage || !dumpPackage.equals(ops.packageName)) continue;
                            hasPackage = true;
                        }
                    }
                    if (uidState.foregroundOps != null && !hasOp && uidState.foregroundOps.indexOfKey(dumpOp) > 0) {
                        hasOp = true;
                    }
                    if (!hasOp || !hasPackage || !hasMode) continue;
                }
                pw.print("  Uid ");
                UserHandle.formatUid(pw, uidState.uid);
                pw.println(":");
                pw.print("    state=");
                pw.println(UID_STATE_NAMES[uidState.state]);
                if (uidState.state != uidState.pendingState) {
                    pw.print("    pendingState=");
                    pw.println(UID_STATE_NAMES[uidState.pendingState]);
                }
                if (uidState.pendingStateCommitTime != 0L) {
                    pw.print("    pendingStateCommitTime=");
                    TimeUtils.formatDuration(uidState.pendingStateCommitTime, nowUptime, pw);
                    pw.println();
                }
                if (uidState.startNesting != 0) {
                    pw.print("    startNesting=");
                    pw.println(uidState.startNesting);
                }
                if (uidState.foregroundOps != null && (dumpMode < 0 || dumpMode == 4)) {
                    pw.println("    foregroundOps:");
                    for (j2 = 0; j2 < uidState.foregroundOps.size(); ++j2) {
                        if (dumpOp >= 0 && dumpOp != uidState.foregroundOps.keyAt(j2)) continue;
                        pw.print("      ");
                        pw.print(AppOpsManager.opToName(uidState.foregroundOps.keyAt(j2)));
                        pw.print(": ");
                        pw.println(uidState.foregroundOps.valueAt(j2) ? "WATCHER" : "SILENT");
                    }
                    pw.print("    hasForegroundWatchers=");
                    pw.println(uidState.hasForegroundWatchers);
                }
                needSep = true;
                if (opModes != null) {
                    int opModeCount = opModes.size();
                    for (int j5 = 0; j5 < opModeCount; ++j5) {
                        int code = opModes.keyAt(j5);
                        int mode = opModes.valueAt(j5);
                        if (dumpOp >= 0 && dumpOp != code || dumpMode >= 0 && dumpMode != mode) continue;
                        pw.print("      ");
                        pw.print(AppOpsManager.opToName(code));
                        pw.print(": mode=");
                        pw.println(AppOpsManager.modeToName(mode));
                    }
                }
                if (pkgOps == null) continue;
                for (int pkgi = 0; pkgi < pkgOps.size(); ++pkgi) {
                    Ops ops = pkgOps.valueAt(pkgi);
                    if (dumpPackage != null && !dumpPackage.equals(ops.packageName)) continue;
                    boolean printedPackage = false;
                    for (j = 0; j < ops.size(); ++j) {
                        Op op = (Op)ops.valueAt(j);
                        if (dumpOp >= 0 && dumpOp != op.op || dumpMode >= 0 && dumpMode != op.mode) continue;
                        if (!printedPackage) {
                            pw.print("    Package ");
                            pw.print(ops.packageName);
                            pw.println(":");
                            printedPackage = true;
                        }
                        pw.print("      ");
                        pw.print(AppOpsManager.opToName(op.op));
                        pw.print(" (");
                        pw.print(AppOpsManager.modeToName(op.mode));
                        int switchOp = AppOpsManager.opToSwitch(op.op);
                        if (switchOp != op.op) {
                            pw.print(" / switch ");
                            pw.print(AppOpsManager.opToName(switchOp));
                            Op switchObj = (Op)ops.get(switchOp);
                            int mode = switchObj != null ? switchObj.mode : AppOpsManager.opToDefaultMode(switchOp);
                            pw.print("=");
                            pw.print(AppOpsManager.modeToName(mode));
                        }
                        pw.println("): ");
                        this.dumpTimesLocked(pw, "          Access: ", "                  ", op.time, now, sdf, date);
                        this.dumpTimesLocked(pw, "          Reject: ", "                  ", op.rejectTime, now, sdf, date);
                        if (op.duration == -1) {
                            pw.print("          Running start at: ");
                            TimeUtils.formatDuration(nowElapsed - op.startRealtime, pw);
                            pw.println();
                        } else if (op.duration != 0) {
                            pw.print("          duration=");
                            TimeUtils.formatDuration((long)op.duration, pw);
                            pw.println();
                        }
                        if (op.startNesting == 0) continue;
                        pw.print("          startNesting=");
                        pw.println(op.startNesting);
                    }
                }
            }
            if (needSep) {
                pw.println();
            }
            int userRestrictionCount = this.mOpUserRestrictions.size();
            for (i = 0; i < userRestrictionCount; ++i) {
                int excludedPackageCount;
                int restrictionCount;
                IBinder token = this.mOpUserRestrictions.keyAt(i);
                ClientRestrictionState restrictionState = this.mOpUserRestrictions.valueAt(i);
                pw.println("  User restrictions for token " + token + ":");
                int n = restrictionCount = restrictionState.perUserRestrictions != null ? restrictionState.perUserRestrictions.size() : 0;
                if (restrictionCount > 0) {
                    pw.println("      Restricted ops:");
                    for (int j6 = 0; j6 < restrictionCount; ++j6) {
                        int userId = restrictionState.perUserRestrictions.keyAt(j6);
                        boolean[] restrictedOps = restrictionState.perUserRestrictions.valueAt(j6);
                        if (restrictedOps == null) continue;
                        StringBuilder restrictedOpsValue = new StringBuilder();
                        restrictedOpsValue.append("[");
                        int restrictedOpCount = restrictedOps.length;
                        for (int k = 0; k < restrictedOpCount; ++k) {
                            if (!restrictedOps[k]) continue;
                            if (restrictedOpsValue.length() > 1) {
                                restrictedOpsValue.append(", ");
                            }
                            restrictedOpsValue.append(AppOpsManager.opToName(k));
                        }
                        restrictedOpsValue.append("]");
                        pw.print("        ");
                        pw.print("user: ");
                        pw.print(userId);
                        pw.print(" restricted ops: ");
                        pw.println(restrictedOpsValue);
                    }
                }
                int n2 = excludedPackageCount = restrictionState.perUserExcludedPackages != null ? restrictionState.perUserExcludedPackages.size() : 0;
                if (excludedPackageCount <= 0) continue;
                pw.println("      Excluded packages:");
                for (int j7 = 0; j7 < excludedPackageCount; ++j7) {
                    int userId = restrictionState.perUserExcludedPackages.keyAt(j7);
                    Object[] packageNames = restrictionState.perUserExcludedPackages.valueAt(j7);
                    pw.print("        ");
                    pw.print("user: ");
                    pw.print(userId);
                    pw.print(" packages: ");
                    pw.println(Arrays.toString(packageNames));
                }
            }
        }
    }

    @Override
    public void setUserRestrictions(Bundle restrictions, IBinder token, int userHandle) {
        this.checkSystemUid("setUserRestrictions");
        Preconditions.checkNotNull(restrictions);
        Preconditions.checkNotNull(token);
        for (int i = 0; i < 78; ++i) {
            String restriction = AppOpsManager.opToRestriction(i);
            if (restriction == null) continue;
            this.setUserRestrictionNoCheck(i, restrictions.getBoolean(restriction, false), token, userHandle, null);
        }
    }

    @Override
    public void setUserRestriction(int code, boolean restricted, IBinder token, int userHandle, String[] exceptionPackages) {
        if (Binder.getCallingPid() != Process.myPid()) {
            this.mContext.enforcePermission("android.permission.MANAGE_APP_OPS_RESTRICTIONS", Binder.getCallingPid(), Binder.getCallingUid(), null);
        }
        if (userHandle != UserHandle.getCallingUserId() && this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS") != 0) {
            throw new SecurityException("Need INTERACT_ACROSS_USERS_FULL or INTERACT_ACROSS_USERS to interact cross user ");
        }
        this.verifyIncomingOp(code);
        Preconditions.checkNotNull(token);
        this.setUserRestrictionNoCheck(code, restricted, token, userHandle, exceptionPackages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserRestrictionNoCheck(int code, boolean restricted, IBinder token, int userHandle, String[] exceptionPackages) {
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            ClientRestrictionState restrictionState = this.mOpUserRestrictions.get(token);
            if (restrictionState == null) {
                try {
                    restrictionState = new ClientRestrictionState(token);
                }
                catch (RemoteException e) {
                    return;
                }
                this.mOpUserRestrictions.put(token, restrictionState);
            }
            if (restrictionState.setRestriction(code, restricted, exceptionPackages, userHandle)) {
                this.mHandler.sendMessage(PooledLambda.obtainMessage(AppOpsService::notifyWatchersOfChange, this, code, -2));
            }
            if (restrictionState.isDefault()) {
                this.mOpUserRestrictions.remove(token);
                restrictionState.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWatchersOfChange(int code, int uid) {
        ArraySet<ModeCallback> clonedCallbacks;
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            ArraySet<ModeCallback> callbacks = this.mOpModeWatchers.get(code);
            if (callbacks == null) {
                return;
            }
            clonedCallbacks = new ArraySet<ModeCallback>(callbacks);
        }
        this.notifyOpChanged(clonedCallbacks, code, uid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(int userHandle) throws RemoteException {
        this.checkSystemUid("removeUser");
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            int tokenCount = this.mOpUserRestrictions.size();
            for (int i = tokenCount - 1; i >= 0; --i) {
                ClientRestrictionState opRestrictions = this.mOpUserRestrictions.valueAt(i);
                opRestrictions.removeUser(userHandle);
            }
            this.removeUidsForUserLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOperationActive(int code, int uid, String packageName) {
        if (Binder.getCallingUid() != uid && this.mContext.checkCallingOrSelfPermission("android.permission.WATCH_APPOPS") != 0) {
            return false;
        }
        this.verifyIncomingOp(code);
        String resolvedPackageName = AppOpsService.resolvePackageName(uid, packageName);
        if (resolvedPackageName == null) {
            return false;
        }
        AppOpsService appOpsService = this;
        synchronized (appOpsService) {
            for (int i = this.mClients.size() - 1; i >= 0; --i) {
                ClientState client = this.mClients.valueAt(i);
                for (int j = client.mStartedOps.size() - 1; j >= 0; --j) {
                    Op op = client.mStartedOps.get(j);
                    if (op.op != code || op.uid != uid) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void removeUidsForUserLocked(int userHandle) {
        for (int i = this.mUidStates.size() - 1; i >= 0; --i) {
            int uid = this.mUidStates.keyAt(i);
            if (UserHandle.getUserId(uid) != userHandle) continue;
            this.mUidStates.removeAt(i);
        }
    }

    private void checkSystemUid(String function) {
        int uid = Binder.getCallingUid();
        if (uid != 1000) {
            throw new SecurityException(function + " must by called by the system");
        }
    }

    private static String resolvePackageName(int uid, String packageName) {
        if (uid == 0) {
            return "root";
        }
        if (uid == 2000) {
            return "com.android.shell";
        }
        if (uid == 1013) {
            return "media";
        }
        if (uid == 1041) {
            return "audioserver";
        }
        if (uid == 1047) {
            return "cameraserver";
        }
        if (uid == 1000 && packageName == null) {
            return "android";
        }
        return packageName;
    }

    private static int resolveUid(String packageName) {
        if (packageName == null) {
            return -1;
        }
        switch (packageName) {
            case "root": {
                return 0;
            }
            case "shell": {
                return 2000;
            }
            case "media": {
                return 1013;
            }
            case "audioserver": {
                return 1041;
            }
            case "cameraserver": {
                return 1047;
            }
        }
        return -1;
    }

    private static String[] getPackagesForUid(int uid) {
        String[] packageNames = null;
        try {
            packageNames = AppGlobals.getPackageManager().getPackagesForUid(uid);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (packageNames == null) {
            return EmptyArray.STRING;
        }
        return packageNames;
    }

    private final class AppOpsManagerInternalImpl
    extends AppOpsManagerInternal {
        private AppOpsManagerInternalImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDeviceAndProfileOwners(SparseIntArray owners) {
            AppOpsService appOpsService = AppOpsService.this;
            synchronized (appOpsService) {
                AppOpsService.this.mProfileOwners = owners;
            }
        }
    }

    private final class ClientRestrictionState
    implements IBinder.DeathRecipient {
        private final IBinder token;
        SparseArray<boolean[]> perUserRestrictions;
        SparseArray<String[]> perUserExcludedPackages;

        public ClientRestrictionState(IBinder token) throws RemoteException {
            token.linkToDeath(this, 0);
            this.token = token;
        }

        public boolean setRestriction(int code, boolean restricted, String[] excludedPackages, int userId) {
            int[] users;
            boolean changed = false;
            if (this.perUserRestrictions == null && restricted) {
                this.perUserRestrictions = new SparseArray();
            }
            if (userId == -1) {
                List<UserInfo> liveUsers = UserManager.get(AppOpsService.this.mContext).getUsers(false);
                users = new int[liveUsers.size()];
                for (int i = 0; i < liveUsers.size(); ++i) {
                    users[i] = liveUsers.get((int)i).id;
                }
            } else {
                users = new int[]{userId};
            }
            if (this.perUserRestrictions != null) {
                for (int thisUserId : users) {
                    boolean[] userRestrictions = this.perUserRestrictions.get(thisUserId);
                    if (userRestrictions == null && restricted) {
                        userRestrictions = new boolean[78];
                        this.perUserRestrictions.put(thisUserId, userRestrictions);
                    }
                    if (userRestrictions != null && userRestrictions[code] != restricted) {
                        userRestrictions[code] = restricted;
                        if (!restricted && this.isDefault(userRestrictions)) {
                            this.perUserRestrictions.remove(thisUserId);
                            userRestrictions = null;
                        }
                        changed = true;
                    }
                    if (userRestrictions == null) continue;
                    boolean noExcludedPackages = ArrayUtils.isEmpty(excludedPackages);
                    if (this.perUserExcludedPackages == null && !noExcludedPackages) {
                        this.perUserExcludedPackages = new SparseArray();
                    }
                    if (this.perUserExcludedPackages == null || Arrays.equals(excludedPackages, this.perUserExcludedPackages.get(thisUserId))) continue;
                    if (noExcludedPackages) {
                        this.perUserExcludedPackages.remove(thisUserId);
                        if (this.perUserExcludedPackages.size() <= 0) {
                            this.perUserExcludedPackages = null;
                        }
                    } else {
                        this.perUserExcludedPackages.put(thisUserId, excludedPackages);
                    }
                    changed = true;
                }
            }
            return changed;
        }

        public boolean hasRestriction(int restriction, String packageName, int userId) {
            if (this.perUserRestrictions == null) {
                return false;
            }
            boolean[] restrictions = this.perUserRestrictions.get(userId);
            if (restrictions == null) {
                return false;
            }
            if (!restrictions[restriction]) {
                return false;
            }
            if (this.perUserExcludedPackages == null) {
                return true;
            }
            String[] perUserExclusions = this.perUserExcludedPackages.get(userId);
            if (perUserExclusions == null) {
                return true;
            }
            return !ArrayUtils.contains(perUserExclusions, packageName);
        }

        public void removeUser(int userId) {
            if (this.perUserExcludedPackages != null) {
                this.perUserExcludedPackages.remove(userId);
                if (this.perUserExcludedPackages.size() <= 0) {
                    this.perUserExcludedPackages = null;
                }
            }
            if (this.perUserRestrictions != null) {
                this.perUserRestrictions.remove(userId);
                if (this.perUserRestrictions.size() <= 0) {
                    this.perUserRestrictions = null;
                }
            }
        }

        public boolean isDefault() {
            return this.perUserRestrictions == null || this.perUserRestrictions.size() <= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            AppOpsService appOpsService = AppOpsService.this;
            synchronized (appOpsService) {
                AppOpsService.this.mOpUserRestrictions.remove(this.token);
                if (this.perUserRestrictions == null) {
                    return;
                }
                int userCount = this.perUserRestrictions.size();
                for (int i = 0; i < userCount; ++i) {
                    boolean[] restrictions = this.perUserRestrictions.valueAt(i);
                    int restrictionCount = restrictions.length;
                    for (int j = 0; j < restrictionCount; ++j) {
                        if (!restrictions[j]) continue;
                        int changedCode = j;
                        AppOpsService.this.mHandler.post(() -> AppOpsService.this.notifyWatchersOfChange(changedCode, -2));
                    }
                }
                this.destroy();
            }
        }

        public void destroy() {
            this.token.unlinkToDeath(this, 0);
        }

        private boolean isDefault(boolean[] array2) {
            if (ArrayUtils.isEmpty(array2)) {
                return true;
            }
            for (boolean value : array2) {
                if (!value) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Restriction {
        private static final ArraySet<String> NO_EXCEPTIONS = new ArraySet();
        int mode;
        ArraySet<String> exceptionPackages = NO_EXCEPTIONS;

        private Restriction() {
        }
    }

    static class Shell
    extends ShellCommand {
        final IAppOpsService mInterface;
        final AppOpsService mInternal;
        int userId = 0;
        String packageName;
        String opStr;
        String modeStr;
        int op;
        int mode;
        int packageUid;
        int nonpackageUid;
        static final Binder sBinder = new Binder();
        IBinder mToken;

        Shell(IAppOpsService iface, AppOpsService internal) {
            this.mInterface = iface;
            this.mInternal = internal;
            try {
                this.mToken = this.mInterface.getToken(sBinder);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        public int onCommand(String cmd) {
            return AppOpsService.onShellCommand(this, cmd);
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            AppOpsService.dumpCommandHelp(pw);
        }

        private static int strOpToOp(String op, PrintWriter err) {
            try {
                return AppOpsManager.strOpToOp(op);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return Integer.parseInt(op);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return AppOpsManager.strDebugOpToOp(op);
                    }
                    catch (IllegalArgumentException e) {
                        err.println("Error: " + e.getMessage());
                        return -1;
                    }
                }
            }
        }

        static int strModeToMode(String modeStr, PrintWriter err) {
            for (int i = AppOpsManager.MODE_NAMES.length - 1; i >= 0; --i) {
                if (!AppOpsManager.MODE_NAMES[i].equals(modeStr)) continue;
                return i;
            }
            try {
                return Integer.parseInt(modeStr);
            }
            catch (NumberFormatException numberFormatException) {
                err.println("Error: Mode " + modeStr + " is not valid");
                return -1;
            }
        }

        int parseUserOpMode(int defMode, PrintWriter err) throws RemoteException {
            String argument;
            this.userId = -2;
            this.opStr = null;
            this.modeStr = null;
            while ((argument = this.getNextArg()) != null) {
                if ("--user".equals(argument)) {
                    this.userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue;
                }
                if (this.opStr == null) {
                    this.opStr = argument;
                    continue;
                }
                if (this.modeStr != null) continue;
                this.modeStr = argument;
                break;
            }
            if (this.opStr == null) {
                err.println("Error: Operation not specified.");
                return -1;
            }
            this.op = Shell.strOpToOp(this.opStr, err);
            if (this.op < 0) {
                return -1;
            }
            if (this.modeStr != null) {
                this.mode = Shell.strModeToMode(this.modeStr, err);
                if (this.mode < 0) {
                    return -1;
                }
            } else {
                this.mode = defMode;
            }
            return 0;
        }

        int parseUserPackageOp(boolean reqOp, PrintWriter err) throws RemoteException {
            block26: {
                String argument22;
                this.userId = -2;
                this.packageName = null;
                this.opStr = null;
                while ((argument22 = this.getNextArg()) != null) {
                    if ("--user".equals(argument22)) {
                        this.userId = UserHandle.parseUserArg(this.getNextArgRequired());
                        continue;
                    }
                    if (this.packageName == null) {
                        this.packageName = argument22;
                        continue;
                    }
                    if (this.opStr != null) continue;
                    this.opStr = argument22;
                    break;
                }
                if (this.packageName == null) {
                    err.println("Error: Package name not specified.");
                    return -1;
                }
                if (this.opStr == null && reqOp) {
                    err.println("Error: Operation not specified.");
                    return -1;
                }
                if (this.opStr != null) {
                    this.op = Shell.strOpToOp(this.opStr, err);
                    if (this.op < 0) {
                        return -1;
                    }
                } else {
                    this.op = -1;
                }
                if (this.userId == -2) {
                    this.userId = ActivityManager.getCurrentUser();
                }
                this.nonpackageUid = -1;
                try {
                    this.nonpackageUid = Integer.parseInt(this.packageName);
                }
                catch (NumberFormatException argument22) {
                    // empty catch block
                }
                if (this.nonpackageUid == -1 && this.packageName.length() > 1 && this.packageName.charAt(0) == 'u' && this.packageName.indexOf(46) < 0) {
                    int i;
                    for (i = 1; i < this.packageName.length() && this.packageName.charAt(i) >= '0' && this.packageName.charAt(i) <= '9'; ++i) {
                    }
                    if (i > 1 && i < this.packageName.length()) {
                        String userStr = this.packageName.substring(1, i);
                        try {
                            int user = Integer.parseInt(userStr);
                            char type = this.packageName.charAt(i);
                            int startTypeVal = ++i;
                            while (i < this.packageName.length() && this.packageName.charAt(i) >= '0' && this.packageName.charAt(i) <= '9') {
                                ++i;
                            }
                            if (i <= startTypeVal) break block26;
                            String typeValStr = this.packageName.substring(startTypeVal, i);
                            try {
                                int typeVal = Integer.parseInt(typeValStr);
                                if (type == 'a') {
                                    this.nonpackageUid = UserHandle.getUid(user, typeVal + 10000);
                                } else if (type == 's') {
                                    this.nonpackageUid = UserHandle.getUid(user, typeVal);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.nonpackageUid != -1) {
                this.packageName = null;
            } else {
                this.packageUid = AppOpsService.resolveUid(this.packageName);
                if (this.packageUid < 0) {
                    this.packageUid = AppGlobals.getPackageManager().getPackageUid(this.packageName, 8192, this.userId);
                }
                if (this.packageUid < 0) {
                    err.println("Error: No UID for " + this.packageName + " in user " + this.userId);
                    return -1;
                }
            }
            return 0;
        }
    }

    static final class ChangeRec {
        final int op;
        final int uid;
        final String pkg;

        ChangeRec(int _op, int _uid, String _pkg) {
            this.op = _op;
            this.uid = _uid;
            this.pkg = _pkg;
        }
    }

    final class ClientState
    extends Binder
    implements IBinder.DeathRecipient {
        final ArrayList<Op> mStartedOps = new ArrayList();
        final IBinder mAppToken;
        final int mPid;

        ClientState(IBinder appToken) {
            this.mAppToken = appToken;
            this.mPid = Binder.getCallingPid();
            if (!(appToken instanceof Binder)) {
                try {
                    this.mAppToken.linkToDeath(this, 0);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return "ClientState{mAppToken=" + this.mAppToken + ", pid=" + this.mPid + '}';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            AppOpsService appOpsService = AppOpsService.this;
            synchronized (appOpsService) {
                for (int i = this.mStartedOps.size() - 1; i >= 0; --i) {
                    AppOpsService.this.finishOperationLocked(this.mStartedOps.get(i), true);
                }
                AppOpsService.this.mClients.remove(this.mAppToken);
            }
        }
    }

    final class ActiveCallback
    implements IBinder.DeathRecipient {
        final IAppOpsActiveCallback mCallback;
        final int mWatchingUid;
        final int mCallingUid;
        final int mCallingPid;

        ActiveCallback(IAppOpsActiveCallback callback, int watchingUid, int callingUid, int callingPid) {
            this.mCallback = callback;
            this.mWatchingUid = watchingUid;
            this.mCallingUid = callingUid;
            this.mCallingPid = callingPid;
            try {
                this.mCallback.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ActiveCallback{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" watchinguid=");
            UserHandle.formatUid(sb, this.mWatchingUid);
            sb.append(" from uid=");
            UserHandle.formatUid(sb, this.mCallingUid);
            sb.append(" pid=");
            sb.append(this.mCallingPid);
            sb.append('}');
            return sb.toString();
        }

        void destroy() {
            this.mCallback.asBinder().unlinkToDeath(this, 0);
        }

        @Override
        public void binderDied() {
            AppOpsService.this.stopWatchingActive(this.mCallback);
        }
    }

    final class ModeCallback
    implements IBinder.DeathRecipient {
        final IAppOpsCallback mCallback;
        final int mWatchingUid;
        final int mFlags;
        final int mCallingUid;
        final int mCallingPid;

        ModeCallback(IAppOpsCallback callback, int watchingUid, int flags, int callingUid, int callingPid) {
            this.mCallback = callback;
            this.mWatchingUid = watchingUid;
            this.mFlags = flags;
            this.mCallingUid = callingUid;
            this.mCallingPid = callingPid;
            try {
                this.mCallback.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public boolean isWatchingUid(int uid) {
            return uid == -2 || this.mWatchingUid < 0 || this.mWatchingUid == uid;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ModeCallback{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" watchinguid=");
            UserHandle.formatUid(sb, this.mWatchingUid);
            sb.append(" flags=0x");
            sb.append(Integer.toHexString(this.mFlags));
            sb.append(" from uid=");
            UserHandle.formatUid(sb, this.mCallingUid);
            sb.append(" pid=");
            sb.append(this.mCallingPid);
            sb.append('}');
            return sb.toString();
        }

        void unlinkToDeath() {
            this.mCallback.asBinder().unlinkToDeath(this, 0);
        }

        @Override
        public void binderDied() {
            AppOpsService.this.stopWatchingMode(this.mCallback);
        }
    }

    static final class Op {
        final UidState uidState;
        final int uid;
        final String packageName;
        final int op;
        int proxyUid = -1;
        String proxyPackageName;
        int mode;
        int duration;
        long[] time = new long[6];
        long[] rejectTime = new long[6];
        int startNesting;
        long startRealtime;

        Op(UidState _uidState, String _packageName, int _op) {
            this.uidState = _uidState;
            this.uid = _uidState.uid;
            this.packageName = _packageName;
            this.op = _op;
            this.mode = AppOpsManager.opToDefaultMode(this.op);
        }

        boolean hasAnyTime() {
            for (int i = 0; i < 6; ++i) {
                if (this.time[i] != 0L) {
                    return true;
                }
                if (this.rejectTime[i] == 0L) continue;
                return true;
            }
            return false;
        }

        int getMode() {
            return this.uidState.evalMode(this.mode);
        }
    }

    static final class Ops
    extends SparseArray<Op> {
        final String packageName;
        final UidState uidState;
        final boolean isPrivileged;

        Ops(String _packageName, UidState _uidState, boolean _isPrivileged) {
            this.packageName = _packageName;
            this.uidState = _uidState;
            this.isPrivileged = _isPrivileged;
        }
    }

    @VisibleForTesting
    static final class UidState {
        public final int uid;
        public int state = 5;
        public int pendingState = 5;
        public long pendingStateCommitTime;
        public int startNesting;
        public ArrayMap<String, Ops> pkgOps;
        public SparseIntArray opModes;
        public SparseBooleanArray foregroundOps;
        public boolean hasForegroundWatchers;

        public UidState(int uid) {
            this.uid = uid;
        }

        public void clear() {
            this.pkgOps = null;
            this.opModes = null;
        }

        public boolean isDefault() {
            return !(this.pkgOps != null && !this.pkgOps.isEmpty() || this.opModes != null && this.opModes.size() > 0);
        }

        int evalMode(int mode) {
            if (mode == 4) {
                return this.state <= 2 ? 0 : 1;
            }
            return mode;
        }

        private void evalForegroundWatchers(int op, SparseArray<ArraySet<ModeCallback>> watchers, SparseBooleanArray which) {
            boolean curValue = which.get(op, false);
            ArraySet<ModeCallback> callbacks = watchers.get(op);
            if (callbacks != null) {
                for (int cbi = callbacks.size() - 1; !curValue && cbi >= 0; --cbi) {
                    if ((callbacks.valueAt((int)cbi).mFlags & 1) == 0) continue;
                    this.hasForegroundWatchers = true;
                    curValue = true;
                }
            }
            which.put(op, curValue);
        }

        public void evalForegroundOps(SparseArray<ArraySet<ModeCallback>> watchers) {
            int i;
            SparseBooleanArray which = null;
            this.hasForegroundWatchers = false;
            if (this.opModes != null) {
                for (i = this.opModes.size() - 1; i >= 0; --i) {
                    if (this.opModes.valueAt(i) != 4) continue;
                    if (which == null) {
                        which = new SparseBooleanArray();
                    }
                    this.evalForegroundWatchers(this.opModes.keyAt(i), watchers, which);
                }
            }
            if (this.pkgOps != null) {
                for (i = this.pkgOps.size() - 1; i >= 0; --i) {
                    Ops ops = this.pkgOps.valueAt(i);
                    for (int j = ops.size() - 1; j >= 0; --j) {
                        if (((Op)ops.valueAt((int)j)).mode != 4) continue;
                        if (which == null) {
                            which = new SparseBooleanArray();
                        }
                        this.evalForegroundWatchers(ops.keyAt(j), watchers, which);
                    }
                }
            }
            this.foregroundOps = which;
        }
    }

    private final class Constants
    extends ContentObserver {
        private static final String KEY_TOP_STATE_SETTLE_TIME = "top_state_settle_time";
        private static final String KEY_FG_SERVICE_STATE_SETTLE_TIME = "fg_service_state_settle_time";
        private static final String KEY_BG_STATE_SETTLE_TIME = "bg_state_settle_time";
        public long TOP_STATE_SETTLE_TIME;
        public long FG_SERVICE_STATE_SETTLE_TIME;
        public long BG_STATE_SETTLE_TIME;
        private final KeyValueListParser mParser;
        private ContentResolver mResolver;

        public Constants(Handler handler) {
            super(handler);
            this.mParser = new KeyValueListParser(',');
            this.updateConstants();
        }

        public void startMonitoring(ContentResolver resolver) {
            this.mResolver = resolver;
            this.mResolver.registerContentObserver(Settings.Global.getUriFor("app_ops_constants"), false, this);
            this.updateConstants();
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.updateConstants();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConstants() {
            String value = this.mResolver != null ? Settings.Global.getString(this.mResolver, "app_ops_constants") : "";
            AppOpsService appOpsService = AppOpsService.this;
            synchronized (appOpsService) {
                try {
                    this.mParser.setString(value);
                }
                catch (IllegalArgumentException e) {
                    Slog.e(AppOpsService.TAG, "Bad app ops settings", e);
                }
                this.TOP_STATE_SETTLE_TIME = this.mParser.getDurationMillis(KEY_TOP_STATE_SETTLE_TIME, 30000L);
                this.FG_SERVICE_STATE_SETTLE_TIME = this.mParser.getDurationMillis(KEY_FG_SERVICE_STATE_SETTLE_TIME, 10000L);
                this.BG_STATE_SETTLE_TIME = this.mParser.getDurationMillis(KEY_BG_STATE_SETTLE_TIME, 1000L);
            }
        }

        void dump(PrintWriter pw) {
            pw.println("  Settings:");
            pw.print("    ");
            pw.print(KEY_TOP_STATE_SETTLE_TIME);
            pw.print("=");
            TimeUtils.formatDuration(this.TOP_STATE_SETTLE_TIME, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_FG_SERVICE_STATE_SETTLE_TIME);
            pw.print("=");
            TimeUtils.formatDuration(this.FG_SERVICE_STATE_SETTLE_TIME, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_BG_STATE_SETTLE_TIME);
            pw.print("=");
            TimeUtils.formatDuration(this.BG_STATE_SETTLE_TIME, pw);
            pw.println();
        }
    }
}

