/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.net.wifi.IWifiManager;
import android.net.wifi.WifiActivityEnergyInfo;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SynchronousResultReceiver;
import android.os.SystemClock;
import android.telephony.ModemActivityInfo;
import android.telephony.TelephonyManager;
import android.util.IntArray;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.util.function.pooled.PooledLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import libcore.util.EmptyArray;

class BatteryExternalStatsWorker
implements BatteryStatsImpl.ExternalStatsSync {
    private static final String TAG = "BatteryExternalStatsWorker";
    private static final boolean DEBUG = false;
    private static final long EXTERNAL_STATS_SYNC_TIMEOUT_MILLIS = 2000L;
    private static final long MAX_WIFI_STATS_SAMPLE_ERROR_MILLIS = 750L;
    private final ScheduledExecutorService mExecutorService = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "batterystats-worker");
        t.setPriority(5);
        return t;
    });
    private final Context mContext;
    private final BatteryStatsImpl mStats;
    @GuardedBy(value="this")
    private int mUpdateFlags = 0;
    @GuardedBy(value="this")
    private Future<?> mCurrentFuture = null;
    @GuardedBy(value="this")
    private String mCurrentReason = null;
    @GuardedBy(value="this")
    private boolean mOnBattery;
    @GuardedBy(value="this")
    private boolean mOnBatteryScreenOff;
    @GuardedBy(value="this")
    private boolean mUseLatestStates = true;
    @GuardedBy(value="this")
    private final IntArray mUidsToRemove = new IntArray();
    @GuardedBy(value="this")
    private Future<?> mWakelockChangesUpdate;
    @GuardedBy(value="this")
    private Future<?> mBatteryLevelSync;
    private final Object mWorkerLock = new Object();
    @GuardedBy(value="mWorkerLock")
    private IWifiManager mWifiManager = null;
    @GuardedBy(value="mWorkerLock")
    private TelephonyManager mTelephony = null;
    @GuardedBy(value="mWorkerLock")
    private WifiActivityEnergyInfo mLastInfo = new WifiActivityEnergyInfo(0L, 0, 0L, new long[]{0L}, 0L, 0L, 0L, 0L);
    @GuardedBy(value="this")
    private long mLastCollectionTimeStamp;
    private final Runnable mSyncTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean useLatestStates;
            boolean onBatteryScreenOff;
            boolean onBattery;
            int[] uidsToRemove;
            String reason;
            int updateFlags;
            Object object = BatteryExternalStatsWorker.this;
            synchronized (object) {
                updateFlags = BatteryExternalStatsWorker.this.mUpdateFlags;
                reason = BatteryExternalStatsWorker.this.mCurrentReason;
                uidsToRemove = BatteryExternalStatsWorker.this.mUidsToRemove.size() > 0 ? BatteryExternalStatsWorker.this.mUidsToRemove.toArray() : EmptyArray.INT;
                onBattery = BatteryExternalStatsWorker.this.mOnBattery;
                onBatteryScreenOff = BatteryExternalStatsWorker.this.mOnBatteryScreenOff;
                useLatestStates = BatteryExternalStatsWorker.this.mUseLatestStates;
                BatteryExternalStatsWorker.this.mUpdateFlags = 0;
                BatteryExternalStatsWorker.this.mCurrentReason = null;
                BatteryExternalStatsWorker.this.mUidsToRemove.clear();
                BatteryExternalStatsWorker.this.mCurrentFuture = null;
                BatteryExternalStatsWorker.this.mUseLatestStates = true;
                if ((updateFlags & 0x1F) != 0) {
                    BatteryExternalStatsWorker.this.cancelSyncDueToBatteryLevelChangeLocked();
                }
                if ((updateFlags & 1) != 0) {
                    BatteryExternalStatsWorker.this.cancelCpuSyncDueToWakelockChange();
                }
            }
            try {
                object = BatteryExternalStatsWorker.this.mWorkerLock;
                synchronized (object) {
                    BatteryExternalStatsWorker.this.updateExternalStatsLocked(reason, updateFlags, onBattery, onBatteryScreenOff, useLatestStates);
                }
                if ((updateFlags & 1) != 0) {
                    BatteryExternalStatsWorker.this.mStats.copyFromAllUidsCpuTimes();
                }
                object = BatteryExternalStatsWorker.this.mStats;
                synchronized (object) {
                    for (int uid : uidsToRemove) {
                        BatteryExternalStatsWorker.this.mStats.removeIsolatedUidLocked(uid);
                    }
                    BatteryExternalStatsWorker.this.mStats.clearPendingRemovedUids();
                }
            }
            catch (Exception e) {
                Slog.wtf(BatteryExternalStatsWorker.TAG, "Error updating external stats: ", e);
            }
            object = BatteryExternalStatsWorker.this;
            synchronized (object) {
                BatteryExternalStatsWorker.this.mLastCollectionTimeStamp = SystemClock.elapsedRealtime();
            }
        }
    };
    private final Runnable mWriteTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BatteryStatsImpl batteryStatsImpl = BatteryExternalStatsWorker.this.mStats;
            synchronized (batteryStatsImpl) {
                BatteryExternalStatsWorker.this.mStats.writeAsyncLocked();
            }
        }
    };

    BatteryExternalStatsWorker(Context context, BatteryStatsImpl stats) {
        this.mContext = context;
        this.mStats = stats;
    }

    @Override
    public synchronized Future<?> scheduleSync(String reason, int flags) {
        return this.scheduleSyncLocked(reason, flags);
    }

    @Override
    public synchronized Future<?> scheduleCpuSyncDueToRemovedUid(int uid) {
        this.mUidsToRemove.add(uid);
        return this.scheduleSyncLocked("remove-uid", 1);
    }

    @Override
    public synchronized Future<?> scheduleCpuSyncDueToSettingChange() {
        return this.scheduleSyncLocked("setting-change", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> scheduleReadProcStateCpuTimes(boolean onBattery, boolean onBatteryScreenOff, long delayMillis) {
        Object object = this.mStats;
        synchronized (object) {
            if (!this.mStats.trackPerProcStateCpuTimes()) {
                return null;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var5_4
            object = this;
        }
        synchronized (object) {
            if (!this.mExecutorService.isShutdown()) {
                return this.mExecutorService.schedule(PooledLambda.obtainRunnable(BatteryStatsImpl::updateProcStateCpuTimes, this.mStats, onBattery, onBatteryScreenOff).recycleOnUse(), delayMillis, TimeUnit.MILLISECONDS);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> scheduleCopyFromAllUidsCpuTimes(boolean onBattery, boolean onBatteryScreenOff) {
        Object object = this.mStats;
        synchronized (object) {
            if (!this.mStats.trackPerProcStateCpuTimes()) {
                return null;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
            object = this;
        }
        synchronized (object) {
            if (!this.mExecutorService.isShutdown()) {
                return this.mExecutorService.submit(PooledLambda.obtainRunnable(BatteryStatsImpl::copyFromAllUidsCpuTimes, this.mStats, onBattery, onBatteryScreenOff).recycleOnUse());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> scheduleCpuSyncDueToScreenStateChange(boolean onBattery, boolean onBatteryScreenOff) {
        BatteryExternalStatsWorker batteryExternalStatsWorker = this;
        synchronized (batteryExternalStatsWorker) {
            if (this.mCurrentFuture == null || (this.mUpdateFlags & 1) == 0) {
                this.mOnBattery = onBattery;
                this.mOnBatteryScreenOff = onBatteryScreenOff;
                this.mUseLatestStates = false;
            }
            return this.scheduleSyncLocked("screen-state", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> scheduleCpuSyncDueToWakelockChange(long delayMillis) {
        BatteryExternalStatsWorker batteryExternalStatsWorker = this;
        synchronized (batteryExternalStatsWorker) {
            this.mWakelockChangesUpdate = this.scheduleDelayedSyncLocked(this.mWakelockChangesUpdate, () -> {
                this.scheduleSync("wakelock-change", 1);
                this.scheduleRunnable(() -> this.mStats.postBatteryNeedsCpuUpdateMsg());
            }, delayMillis);
            return this.mWakelockChangesUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelCpuSyncDueToWakelockChange() {
        BatteryExternalStatsWorker batteryExternalStatsWorker = this;
        synchronized (batteryExternalStatsWorker) {
            if (this.mWakelockChangesUpdate != null) {
                this.mWakelockChangesUpdate.cancel(false);
                this.mWakelockChangesUpdate = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<?> scheduleSyncDueToBatteryLevelChange(long delayMillis) {
        BatteryExternalStatsWorker batteryExternalStatsWorker = this;
        synchronized (batteryExternalStatsWorker) {
            this.mBatteryLevelSync = this.scheduleDelayedSyncLocked(this.mBatteryLevelSync, () -> this.scheduleSync("battery-level", 31), delayMillis);
            return this.mBatteryLevelSync;
        }
    }

    @GuardedBy(value="this")
    private void cancelSyncDueToBatteryLevelChangeLocked() {
        if (this.mBatteryLevelSync != null) {
            this.mBatteryLevelSync.cancel(false);
            this.mBatteryLevelSync = null;
        }
    }

    @GuardedBy(value="this")
    private Future<?> scheduleDelayedSyncLocked(Future<?> lastScheduledSync, Runnable syncRunnable, long delayMillis) {
        if (this.mExecutorService.isShutdown()) {
            return CompletableFuture.failedFuture(new IllegalStateException("worker shutdown"));
        }
        if (lastScheduledSync != null) {
            if (delayMillis == 0L) {
                lastScheduledSync.cancel(false);
            } else {
                return lastScheduledSync;
            }
        }
        return this.mExecutorService.schedule(syncRunnable, delayMillis, TimeUnit.MILLISECONDS);
    }

    public synchronized Future<?> scheduleWrite() {
        if (this.mExecutorService.isShutdown()) {
            return CompletableFuture.failedFuture(new IllegalStateException("worker shutdown"));
        }
        this.scheduleSyncLocked("write", 31);
        return this.mExecutorService.submit(this.mWriteTask);
    }

    public synchronized void scheduleRunnable(Runnable runnable) {
        if (!this.mExecutorService.isShutdown()) {
            this.mExecutorService.submit(runnable);
        }
    }

    public void shutdown() {
        this.mExecutorService.shutdownNow();
    }

    @GuardedBy(value="this")
    private Future<?> scheduleSyncLocked(String reason, int flags) {
        if (this.mExecutorService.isShutdown()) {
            return CompletableFuture.failedFuture(new IllegalStateException("worker shutdown"));
        }
        if (this.mCurrentFuture == null) {
            this.mUpdateFlags = flags;
            this.mCurrentReason = reason;
            this.mCurrentFuture = this.mExecutorService.submit(this.mSyncTask);
        }
        this.mUpdateFlags |= flags;
        return this.mCurrentFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getLastCollectionTimeStamp() {
        BatteryExternalStatsWorker batteryExternalStatsWorker = this;
        synchronized (batteryExternalStatsWorker) {
            return this.mLastCollectionTimeStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mWorkerLock")
    private void updateExternalStatsLocked(String reason, int updateFlags, boolean onBattery, boolean onBatteryScreenOff, boolean useLatestStates) {
        BluetoothAdapter adapter;
        SynchronousResultReceiver wifiReceiver = null;
        SynchronousResultReceiver bluetoothReceiver = null;
        SynchronousResultReceiver modemReceiver = null;
        if ((updateFlags & 2) != 0) {
            if (this.mWifiManager == null) {
                this.mWifiManager = IWifiManager.Stub.asInterface(ServiceManager.getService("wifi"));
            }
            if (this.mWifiManager != null) {
                try {
                    wifiReceiver = new SynchronousResultReceiver("wifi");
                    this.mWifiManager.requestActivityInfo(wifiReceiver);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        if ((updateFlags & 8) != 0 && (adapter = BluetoothAdapter.getDefaultAdapter()) != null) {
            bluetoothReceiver = new SynchronousResultReceiver("bluetooth");
            adapter.requestControllerActivityEnergyInfo(bluetoothReceiver);
        }
        if ((updateFlags & 4) != 0) {
            if (this.mTelephony == null) {
                this.mTelephony = TelephonyManager.from(this.mContext);
            }
            if (this.mTelephony != null) {
                modemReceiver = new SynchronousResultReceiver("telephony");
                this.mTelephony.requestModemActivityInfo(modemReceiver);
            }
        }
        WifiActivityEnergyInfo wifiInfo = (WifiActivityEnergyInfo)BatteryExternalStatsWorker.awaitControllerInfo(wifiReceiver);
        BluetoothActivityEnergyInfo bluetoothInfo = (BluetoothActivityEnergyInfo)BatteryExternalStatsWorker.awaitControllerInfo(bluetoothReceiver);
        ModemActivityInfo modemInfo = (ModemActivityInfo)BatteryExternalStatsWorker.awaitControllerInfo(modemReceiver);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.addHistoryEventLocked(SystemClock.elapsedRealtime(), SystemClock.uptimeMillis(), 14, reason, 0);
            if ((updateFlags & 1) != 0) {
                if (useLatestStates) {
                    onBattery = this.mStats.isOnBatteryLocked();
                    onBatteryScreenOff = this.mStats.isOnBatteryScreenOffLocked();
                }
                this.mStats.updateCpuTimeLocked(onBattery, onBatteryScreenOff);
            }
            if ((updateFlags & 0x1F) != 0) {
                this.mStats.updateKernelWakelocksLocked();
                this.mStats.updateKernelMemoryBandwidthLocked();
            }
            if ((updateFlags & 0x10) != 0) {
                this.mStats.updateRpmStatsLocked();
            }
            if (bluetoothInfo != null) {
                if (bluetoothInfo.isValid()) {
                    this.mStats.updateBluetoothStateLocked(bluetoothInfo);
                } else {
                    Slog.w(TAG, "bluetooth info is invalid: " + bluetoothInfo);
                }
            }
        }
        if (wifiInfo != null) {
            if (wifiInfo.isValid()) {
                this.mStats.updateWifiState(this.extractDeltaLocked(wifiInfo));
            } else {
                Slog.w(TAG, "wifi info is invalid: " + wifiInfo);
            }
        }
        if (modemInfo != null) {
            if (modemInfo.isValid()) {
                this.mStats.updateMobileRadioState(modemInfo);
            } else {
                Slog.w(TAG, "modem info is invalid: " + modemInfo);
            }
        }
    }

    private static <T extends Parcelable> T awaitControllerInfo(SynchronousResultReceiver receiver) {
        if (receiver == null) {
            return null;
        }
        try {
            SynchronousResultReceiver.Result result = receiver.awaitResult(2000L);
            if (result.bundle != null) {
                result.bundle.setDefusable(true);
                Object data = result.bundle.getParcelable("controller_activity");
                if (data != null) {
                    return data;
                }
            }
            Slog.e(TAG, "no controller energy info supplied for " + receiver.getName());
        }
        catch (TimeoutException e) {
            Slog.w(TAG, "timeout reading " + receiver.getName() + " stats");
        }
        return null;
    }

    @GuardedBy(value="mWorkerLock")
    private WifiActivityEnergyInfo extractDeltaLocked(WifiActivityEnergyInfo latest) {
        long timePeriodMs = latest.mTimestamp - this.mLastInfo.mTimestamp;
        long lastScanMs = this.mLastInfo.mControllerScanTimeMs;
        long lastIdleMs = this.mLastInfo.mControllerIdleTimeMs;
        long lastTxMs = this.mLastInfo.mControllerTxTimeMs;
        long lastRxMs = this.mLastInfo.mControllerRxTimeMs;
        long lastEnergy = this.mLastInfo.mControllerEnergyUsed;
        WifiActivityEnergyInfo delta = this.mLastInfo;
        delta.mTimestamp = latest.getTimeStamp();
        delta.mStackState = latest.getStackState();
        long txTimeMs = latest.mControllerTxTimeMs - lastTxMs;
        long rxTimeMs = latest.mControllerRxTimeMs - lastRxMs;
        long idleTimeMs = latest.mControllerIdleTimeMs - lastIdleMs;
        long scanTimeMs = latest.mControllerScanTimeMs - lastScanMs;
        if (txTimeMs < 0L || rxTimeMs < 0L || scanTimeMs < 0L || idleTimeMs < 0L) {
            long totalOnTimeMs = latest.mControllerTxTimeMs + latest.mControllerRxTimeMs + latest.mControllerIdleTimeMs;
            if (totalOnTimeMs <= timePeriodMs + 750L) {
                delta.mControllerEnergyUsed = latest.mControllerEnergyUsed;
                delta.mControllerRxTimeMs = latest.mControllerRxTimeMs;
                delta.mControllerTxTimeMs = latest.mControllerTxTimeMs;
                delta.mControllerIdleTimeMs = latest.mControllerIdleTimeMs;
                delta.mControllerScanTimeMs = latest.mControllerScanTimeMs;
            } else {
                delta.mControllerEnergyUsed = 0L;
                delta.mControllerRxTimeMs = 0L;
                delta.mControllerTxTimeMs = 0L;
                delta.mControllerIdleTimeMs = 0L;
                delta.mControllerScanTimeMs = 0L;
            }
            Slog.v(TAG, "WiFi energy data was reset, new WiFi energy data is " + delta);
        } else {
            long maxExpectedIdleTimeMs;
            long totalActiveTimeMs = txTimeMs + rxTimeMs;
            if (totalActiveTimeMs > timePeriodMs) {
                maxExpectedIdleTimeMs = 0L;
                if (totalActiveTimeMs > timePeriodMs + 750L) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Total Active time ");
                    TimeUtils.formatDuration(totalActiveTimeMs, sb);
                    sb.append(" is longer than sample period ");
                    TimeUtils.formatDuration(timePeriodMs, sb);
                    sb.append(".\n");
                    sb.append("Previous WiFi snapshot: ").append("idle=");
                    TimeUtils.formatDuration(lastIdleMs, sb);
                    sb.append(" rx=");
                    TimeUtils.formatDuration(lastRxMs, sb);
                    sb.append(" tx=");
                    TimeUtils.formatDuration(lastTxMs, sb);
                    sb.append(" e=").append(lastEnergy);
                    sb.append("\n");
                    sb.append("Current WiFi snapshot: ").append("idle=");
                    TimeUtils.formatDuration(latest.mControllerIdleTimeMs, sb);
                    sb.append(" rx=");
                    TimeUtils.formatDuration(latest.mControllerRxTimeMs, sb);
                    sb.append(" tx=");
                    TimeUtils.formatDuration(latest.mControllerTxTimeMs, sb);
                    sb.append(" e=").append(latest.mControllerEnergyUsed);
                    Slog.wtf(TAG, sb.toString());
                }
            } else {
                maxExpectedIdleTimeMs = timePeriodMs - totalActiveTimeMs;
            }
            delta.mControllerTxTimeMs = txTimeMs;
            delta.mControllerRxTimeMs = rxTimeMs;
            delta.mControllerScanTimeMs = scanTimeMs;
            delta.mControllerIdleTimeMs = Math.min(maxExpectedIdleTimeMs, Math.max(0L, idleTimeMs));
            delta.mControllerEnergyUsed = Math.max(0L, latest.mControllerEnergyUsed - lastEnergy);
        }
        this.mLastInfo = latest;
        return delta;
    }
}

