/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.am.ActivityManagerService;
import java.util.HashMap;
import java.util.Map;

final class CoreSettingsObserver
extends ContentObserver {
    private static final String LOG_TAG = CoreSettingsObserver.class.getSimpleName();
    @VisibleForTesting
    static final Map<String, Class<?>> sSecureSettingToTypeMap = new HashMap();
    @VisibleForTesting
    static final Map<String, Class<?>> sSystemSettingToTypeMap = new HashMap();
    @VisibleForTesting
    static final Map<String, Class<?>> sGlobalSettingToTypeMap = new HashMap();
    private final Bundle mCoreSettings = new Bundle();
    private final ActivityManagerService mActivityManagerService;

    public CoreSettingsObserver(ActivityManagerService activityManagerService) {
        super(activityManagerService.mHandler);
        this.mActivityManagerService = activityManagerService;
        this.beginObserveCoreSettings();
        this.sendCoreSettings();
    }

    public Bundle getCoreSettingsLocked() {
        return (Bundle)this.mCoreSettings.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChange(boolean selfChange) {
        ActivityManagerService activityManagerService = this.mActivityManagerService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.sendCoreSettings();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    private void sendCoreSettings() {
        this.populateSettings(this.mCoreSettings, sSecureSettingToTypeMap);
        this.populateSettings(this.mCoreSettings, sSystemSettingToTypeMap);
        this.populateSettings(this.mCoreSettings, sGlobalSettingToTypeMap);
        this.mActivityManagerService.onCoreSettingsChange(this.mCoreSettings);
    }

    private void beginObserveCoreSettings() {
        Uri uri;
        for (String setting : sSecureSettingToTypeMap.keySet()) {
            uri = Settings.Secure.getUriFor(setting);
            this.mActivityManagerService.mContext.getContentResolver().registerContentObserver(uri, false, this);
        }
        for (String setting : sSystemSettingToTypeMap.keySet()) {
            uri = Settings.System.getUriFor(setting);
            this.mActivityManagerService.mContext.getContentResolver().registerContentObserver(uri, false, this);
        }
        for (String setting : sGlobalSettingToTypeMap.keySet()) {
            uri = Settings.Global.getUriFor(setting);
            this.mActivityManagerService.mContext.getContentResolver().registerContentObserver(uri, false, this);
        }
    }

    @VisibleForTesting
    void populateSettings(Bundle snapshot, Map<String, Class<?>> map) {
        Context context = this.mActivityManagerService.mContext;
        for (Map.Entry<String, Class<?>> entry : map.entrySet()) {
            String setting = entry.getKey();
            String value = map == sSecureSettingToTypeMap ? Settings.Secure.getString(context.getContentResolver(), setting) : (map == sSystemSettingToTypeMap ? Settings.System.getString(context.getContentResolver(), setting) : Settings.Global.getString(context.getContentResolver(), setting));
            if (value == null) continue;
            Class<?> type = entry.getValue();
            if (type == String.class) {
                snapshot.putString(setting, value);
                continue;
            }
            if (type == Integer.TYPE) {
                snapshot.putInt(setting, Integer.parseInt(value));
                continue;
            }
            if (type == Float.TYPE) {
                snapshot.putFloat(setting, Float.parseFloat(value));
                continue;
            }
            if (type != Long.TYPE) continue;
            snapshot.putLong(setting, Long.parseLong(value));
        }
    }

    static {
        sSecureSettingToTypeMap.put("long_press_timeout", Integer.TYPE);
        sSecureSettingToTypeMap.put("multi_press_timeout", Integer.TYPE);
        sSystemSettingToTypeMap.put("time_12_24", String.class);
        sGlobalSettingToTypeMap.put("debug_view_attributes", Integer.TYPE);
    }
}

