/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManagerInternal;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.Trace;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.server.am.ActivityDisplay;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;

class KeyguardController {
    private static final String TAG = "ActivityManager";
    private final ActivityManagerService mService;
    private final ActivityStackSupervisor mStackSupervisor;
    private WindowManagerService mWindowManager;
    private boolean mKeyguardShowing;
    private boolean mAodShowing;
    private boolean mKeyguardGoingAway;
    private boolean mOccluded;
    private boolean mDismissalRequested;
    private ActivityRecord mDismissingKeyguardActivity;
    private int mBeforeUnoccludeTransit;
    private int mVisibilityTransactionDepth;
    private ActivityManagerInternal.SleepToken mSleepToken;
    private int mSecondaryDisplayShowing = -1;

    KeyguardController(ActivityManagerService service, ActivityStackSupervisor stackSupervisor) {
        this.mService = service;
        this.mStackSupervisor = stackSupervisor;
    }

    void setWindowManager(WindowManagerService windowManager) {
        this.mWindowManager = windowManager;
    }

    boolean isKeyguardOrAodShowing(int displayId) {
        return (this.mKeyguardShowing || this.mAodShowing) && !this.mKeyguardGoingAway && (displayId == 0 ? !this.mOccluded : displayId == this.mSecondaryDisplayShowing);
    }

    boolean isKeyguardShowing(int displayId) {
        return this.mKeyguardShowing && !this.mKeyguardGoingAway && (displayId == 0 ? !this.mOccluded : displayId == this.mSecondaryDisplayShowing);
    }

    boolean isKeyguardLocked() {
        return this.mKeyguardShowing && !this.mKeyguardGoingAway;
    }

    boolean isKeyguardGoingAway() {
        return this.mKeyguardGoingAway && this.mKeyguardShowing;
    }

    void setKeyguardShown(boolean keyguardShowing, boolean aodShowing, int secondaryDisplayShowing) {
        boolean showingChanged = keyguardShowing != this.mKeyguardShowing || aodShowing != this.mAodShowing;
        if (!(showingChanged |= this.mKeyguardGoingAway && keyguardShowing) && secondaryDisplayShowing == this.mSecondaryDisplayShowing) {
            return;
        }
        this.mKeyguardShowing = keyguardShowing;
        this.mAodShowing = aodShowing;
        this.mSecondaryDisplayShowing = secondaryDisplayShowing;
        this.mWindowManager.setAodShowing(aodShowing);
        if (showingChanged) {
            this.dismissDockedStackIfNeeded();
            this.setKeyguardGoingAway(false);
            this.mWindowManager.setKeyguardOrAodShowingOnDefaultDisplay(this.isKeyguardOrAodShowing(0));
            if (keyguardShowing) {
                this.mDismissalRequested = false;
            }
        }
        this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
        this.updateKeyguardSleepToken();
    }

    void keyguardGoingAway(int flags) {
        if (!this.mKeyguardShowing) {
            return;
        }
        Trace.traceBegin(64L, "keyguardGoingAway");
        this.mWindowManager.deferSurfaceLayout();
        try {
            this.setKeyguardGoingAway(true);
            this.mWindowManager.prepareAppTransition(20, false, this.convertTransitFlags(flags), false);
            this.updateKeyguardSleepToken();
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
            this.mStackSupervisor.addStartingWindowsForVisibleActivities(true);
            this.mWindowManager.executeAppTransition();
        }
        finally {
            Trace.traceBegin(64L, "keyguardGoingAway: surfaceLayout");
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
            Trace.traceEnd(64L);
        }
    }

    void dismissKeyguard(IBinder token, IKeyguardDismissCallback callback, CharSequence message) {
        ActivityRecord activityRecord = ActivityRecord.forTokenLocked(token);
        if (activityRecord == null || !activityRecord.visibleIgnoringKeyguard) {
            this.failCallback(callback);
            return;
        }
        Slog.i(TAG, "Activity requesting to dismiss Keyguard: " + activityRecord);
        if (activityRecord.getTurnScreenOnFlag() && activityRecord.isTopRunningActivity()) {
            this.mStackSupervisor.wakeUp("dismissKeyguard");
        }
        this.mWindowManager.dismissKeyguard(callback, message);
    }

    private void setKeyguardGoingAway(boolean keyguardGoingAway) {
        this.mKeyguardGoingAway = keyguardGoingAway;
        this.mWindowManager.setKeyguardGoingAway(keyguardGoingAway);
    }

    private void failCallback(IKeyguardDismissCallback callback) {
        try {
            callback.onDismissError();
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to call callback", e);
        }
    }

    private int convertTransitFlags(int keyguardGoingAwayFlags) {
        int result = 0;
        if ((keyguardGoingAwayFlags & 1) != 0) {
            result |= 1;
        }
        if ((keyguardGoingAwayFlags & 2) != 0) {
            result |= 2;
        }
        if ((keyguardGoingAwayFlags & 4) != 0) {
            result |= 4;
        }
        return result;
    }

    void beginActivityVisibilityUpdate() {
        ++this.mVisibilityTransactionDepth;
    }

    void endActivityVisibilityUpdate() {
        --this.mVisibilityTransactionDepth;
        if (this.mVisibilityTransactionDepth == 0) {
            this.visibilitiesUpdated();
        }
    }

    boolean canShowActivityWhileKeyguardShowing(ActivityRecord r, boolean dismissKeyguard) {
        return dismissKeyguard && this.canDismissKeyguard() && !this.mAodShowing && (this.mDismissalRequested || r != this.mDismissingKeyguardActivity);
    }

    boolean canShowWhileOccluded(boolean dismissKeyguard, boolean showWhenLocked) {
        return showWhenLocked || dismissKeyguard && !this.mWindowManager.isKeyguardSecure();
    }

    private void visibilitiesUpdated() {
        boolean lastOccluded = this.mOccluded;
        ActivityRecord lastDismissingKeyguardActivity = this.mDismissingKeyguardActivity;
        this.mOccluded = false;
        this.mDismissingKeyguardActivity = null;
        for (int displayNdx = this.mStackSupervisor.getChildCount() - 1; displayNdx >= 0; --displayNdx) {
            ActivityDisplay display = this.mStackSupervisor.getChildAt(displayNdx);
            for (int stackNdx = display.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = display.getChildAt(stackNdx);
                if (display.mDisplayId == 0 && this.mStackSupervisor.isFocusedStack(stack)) {
                    ActivityRecord topDismissing = stack.getTopDismissingKeyguardActivity();
                    boolean bl = this.mOccluded = stack.topActivityOccludesKeyguard() || topDismissing != null && stack.topRunningActivityLocked() == topDismissing && this.canShowWhileOccluded(true, false);
                }
                if (this.mDismissingKeyguardActivity != null || stack.getTopDismissingKeyguardActivity() == null) continue;
                this.mDismissingKeyguardActivity = stack.getTopDismissingKeyguardActivity();
            }
        }
        this.mOccluded |= this.mWindowManager.isShowingDream();
        if (this.mOccluded != lastOccluded) {
            this.handleOccludedChanged();
        }
        if (this.mDismissingKeyguardActivity != lastDismissingKeyguardActivity) {
            this.handleDismissKeyguard();
        }
    }

    private void handleOccludedChanged() {
        this.mWindowManager.onKeyguardOccludedChanged(this.mOccluded);
        if (this.isKeyguardLocked()) {
            this.mWindowManager.deferSurfaceLayout();
            try {
                this.mWindowManager.prepareAppTransition(this.resolveOccludeTransit(), false, 0, true);
                this.updateKeyguardSleepToken();
                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
                this.mWindowManager.executeAppTransition();
            }
            finally {
                this.mWindowManager.continueSurfaceLayout();
            }
        }
        this.dismissDockedStackIfNeeded();
    }

    private void handleDismissKeyguard() {
        if (!this.mOccluded && this.mDismissingKeyguardActivity != null && this.mWindowManager.isKeyguardSecure()) {
            this.mWindowManager.dismissKeyguard(null, null);
            this.mDismissalRequested = true;
            if (this.mKeyguardShowing && this.canDismissKeyguard() && this.mWindowManager.getPendingAppTransition() == 23) {
                this.mWindowManager.prepareAppTransition(this.mBeforeUnoccludeTransit, false, 0, true);
                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
                this.mWindowManager.executeAppTransition();
            }
        }
    }

    boolean canDismissKeyguard() {
        return this.mWindowManager.isKeyguardTrusted() || !this.mWindowManager.isKeyguardSecure();
    }

    private int resolveOccludeTransit() {
        if (this.mBeforeUnoccludeTransit != -1 && this.mWindowManager.getPendingAppTransition() == 23 && this.mOccluded) {
            return this.mBeforeUnoccludeTransit;
        }
        if (!this.mOccluded) {
            this.mBeforeUnoccludeTransit = this.mWindowManager.getPendingAppTransition();
            return 23;
        }
        return 22;
    }

    private void dismissDockedStackIfNeeded() {
        if (this.mKeyguardShowing && this.mOccluded) {
            ActivityStack stack = this.mStackSupervisor.getDefaultDisplay().getSplitScreenPrimaryStack();
            if (stack == null) {
                return;
            }
            this.mStackSupervisor.moveTasksToFullscreenStackLocked(stack, this.mStackSupervisor.mFocusedStack == stack);
        }
    }

    private void updateKeyguardSleepToken() {
        if (this.mSleepToken == null && this.isKeyguardOrAodShowing(0)) {
            this.mSleepToken = this.mService.acquireSleepToken("Keyguard", 0);
        } else if (this.mSleepToken != null && !this.isKeyguardOrAodShowing(0)) {
            this.mSleepToken.release();
            this.mSleepToken = null;
        }
    }

    void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "KeyguardController:");
        pw.println(prefix + "  mKeyguardShowing=" + this.mKeyguardShowing);
        pw.println(prefix + "  mAodShowing=" + this.mAodShowing);
        pw.println(prefix + "  mKeyguardGoingAway=" + this.mKeyguardGoingAway);
        pw.println(prefix + "  mOccluded=" + this.mOccluded);
        pw.println(prefix + "  mDismissingKeyguardActivity=" + this.mDismissingKeyguardActivity);
        pw.println(prefix + "  mDismissalRequested=" + this.mDismissalRequested);
        pw.println(prefix + "  mVisibilityTransactionDepth=" + this.mVisibilityTransactionDepth);
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10800000001L, this.mKeyguardShowing);
        proto.write(1133871366146L, this.mOccluded);
        proto.end(token);
    }
}

