/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityOptions;
import android.content.pm.ActivityInfo;
import android.graphics.Rect;
import com.android.server.am.ActivityLaunchParamsModifier;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.TaskLaunchParamsModifier;
import com.android.server.am.TaskRecord;
import com.android.server.wm.ConfigurationContainer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

class LaunchParamsController {
    private final ActivityManagerService mService;
    private final List<LaunchParamsModifier> mModifiers = new ArrayList<LaunchParamsModifier>();
    private final LaunchParams mTmpParams = new LaunchParams();
    private final LaunchParams mTmpCurrent = new LaunchParams();
    private final LaunchParams mTmpResult = new LaunchParams();

    LaunchParamsController(ActivityManagerService service) {
        this.mService = service;
    }

    void registerDefaultModifiers(ActivityStackSupervisor supervisor) {
        this.registerModifier(new TaskLaunchParamsModifier());
        this.registerModifier(new ActivityLaunchParamsModifier(supervisor));
    }

    void calculate(TaskRecord task, ActivityInfo.WindowLayout layout2, ActivityRecord activity, ActivityRecord source, ActivityOptions options, LaunchParams result) {
        result.reset();
        block5: for (int i = this.mModifiers.size() - 1; i >= 0; --i) {
            this.mTmpCurrent.set(result);
            this.mTmpResult.reset();
            LaunchParamsModifier modifier = this.mModifiers.get(i);
            switch (modifier.onCalculate(task, layout2, activity, source, options, this.mTmpCurrent, this.mTmpResult)) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    result.set(this.mTmpResult);
                    return;
                }
                case 2: {
                    result.set(this.mTmpResult);
                }
            }
        }
    }

    boolean layoutTask(TaskRecord task, ActivityInfo.WindowLayout layout2) {
        return this.layoutTask(task, layout2, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean layoutTask(TaskRecord task, ActivityInfo.WindowLayout layout2, ActivityRecord activity, ActivityRecord source, ActivityOptions options) {
        this.calculate(task, layout2, activity, source, options, this.mTmpParams);
        if (this.mTmpParams.isEmpty()) {
            return false;
        }
        this.mService.mWindowManager.deferSurfaceLayout();
        try {
            if (this.mTmpParams.hasPreferredDisplay() && this.mTmpParams.mPreferredDisplayId != ((ActivityStack)task.getStack()).getDisplay().mDisplayId) {
                this.mService.moveStackToDisplay(task.getStackId(), this.mTmpParams.mPreferredDisplayId);
            }
            if (this.mTmpParams.hasWindowingMode() && this.mTmpParams.mWindowingMode != ((ConfigurationContainer)task.getStack()).getWindowingMode()) {
                ((ActivityStack)task.getStack()).setWindowingMode(this.mTmpParams.mWindowingMode);
            }
            if (!this.mTmpParams.mBounds.isEmpty()) {
                task.updateOverrideConfiguration(this.mTmpParams.mBounds);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.mService.mWindowManager.continueSurfaceLayout();
        }
    }

    void registerModifier(LaunchParamsModifier modifier) {
        if (this.mModifiers.contains(modifier)) {
            return;
        }
        this.mModifiers.add(modifier);
    }

    static interface LaunchParamsModifier {
        public static final int RESULT_SKIP = 0;
        public static final int RESULT_DONE = 1;
        public static final int RESULT_CONTINUE = 2;

        public int onCalculate(TaskRecord var1, ActivityInfo.WindowLayout var2, ActivityRecord var3, ActivityRecord var4, ActivityOptions var5, LaunchParams var6, LaunchParams var7);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Result {
        }
    }

    static class LaunchParams {
        final Rect mBounds = new Rect();
        int mPreferredDisplayId;
        int mWindowingMode;

        LaunchParams() {
        }

        void reset() {
            this.mBounds.setEmpty();
            this.mPreferredDisplayId = -1;
            this.mWindowingMode = 0;
        }

        void set(LaunchParams params) {
            this.mBounds.set(params.mBounds);
            this.mPreferredDisplayId = params.mPreferredDisplayId;
            this.mWindowingMode = params.mWindowingMode;
        }

        boolean isEmpty() {
            return this.mBounds.isEmpty() && this.mPreferredDisplayId == -1 && this.mWindowingMode == 0;
        }

        boolean hasWindowingMode() {
            return this.mWindowingMode != 0;
        }

        boolean hasPreferredDisplay() {
            return this.mPreferredDisplayId != -1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LaunchParams that = (LaunchParams)o;
            if (this.mPreferredDisplayId != that.mPreferredDisplayId) {
                return false;
            }
            if (this.mWindowingMode != that.mWindowingMode) {
                return false;
            }
            return this.mBounds != null ? this.mBounds.equals(that.mBounds) : that.mBounds == null;
        }

        public int hashCode() {
            int result = this.mBounds != null ? this.mBounds.hashCode() : 0;
            result = 31 * result + this.mPreferredDisplayId;
            result = 31 * result + this.mWindowingMode;
            return result;
        }
    }
}

