/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityOptions;
import android.os.Handler;
import android.util.ArrayMap;
import android.view.RemoteAnimationAdapter;
import com.android.server.am.ActivityManagerService;

class PendingRemoteAnimationRegistry {
    private static final long TIMEOUT_MS = 3000L;
    private final ArrayMap<String, Entry> mEntries = new ArrayMap();
    private final Handler mHandler;
    private final ActivityManagerService mService;

    PendingRemoteAnimationRegistry(ActivityManagerService service, Handler handler) {
        this.mService = service;
        this.mHandler = handler;
    }

    void addPendingAnimation(String packageName, RemoteAnimationAdapter adapter) {
        this.mEntries.put(packageName, new Entry(packageName, adapter));
    }

    ActivityOptions overrideOptionsIfNeeded(String callingPackage, ActivityOptions options) {
        Entry entry = this.mEntries.get(callingPackage);
        if (entry == null) {
            return options;
        }
        if (options == null) {
            options = ActivityOptions.makeRemoteAnimation(entry.adapter);
        } else {
            options.setRemoteAnimationAdapter(entry.adapter);
        }
        this.mEntries.remove(callingPackage);
        return options;
    }

    private class Entry {
        final String packageName;
        final RemoteAnimationAdapter adapter;

        Entry(String packageName, RemoteAnimationAdapter adapter) {
            this.packageName = packageName;
            this.adapter = adapter;
            PendingRemoteAnimationRegistry.this.mHandler.postDelayed(() -> {
                ActivityManagerService activityManagerService = PendingRemoteAnimationRegistry.this.mService;
                synchronized (activityManagerService) {
                    try {
                        ActivityManagerService.boostPriorityForLockedSection();
                        Entry entry = (Entry)PendingRemoteAnimationRegistry.this.mEntries.get(packageName);
                        if (entry == this) {
                            PendingRemoteAnimationRegistry.this.mEntries.remove(packageName);
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
                ActivityManagerService.resetPriorityAfterLockedSection();
            }, 3000L);
        }
    }
}

