/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;

public abstract class PersistentConnection<T> {
    private final Object mLock = new Object();
    private static final boolean DEBUG = false;
    private final String mTag;
    private final Context mContext;
    private final Handler mHandler;
    private final int mUserId;
    private final ComponentName mComponentName;
    private long mNextBackoffMs;
    private final long mRebindBackoffMs;
    private final double mRebindBackoffIncrease;
    private final long mRebindMaxBackoffMs;
    private long mReconnectTime;
    @GuardedBy(value="mLock")
    private boolean mBound;
    @GuardedBy(value="mLock")
    private boolean mShouldBeBound;
    @GuardedBy(value="mLock")
    private boolean mRebindScheduled;
    @GuardedBy(value="mLock")
    private boolean mIsConnected;
    @GuardedBy(value="mLock")
    private T mService;
    private final ServiceConnection mServiceConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = PersistentConnection.this.mLock;
            synchronized (object) {
                if (!PersistentConnection.this.mBound) {
                    Slog.w(PersistentConnection.this.mTag, "Connected: " + PersistentConnection.this.mComponentName.flattenToShortString() + " u" + PersistentConnection.this.mUserId + " but not bound, ignore.");
                    return;
                }
                Slog.i(PersistentConnection.this.mTag, "Connected: " + PersistentConnection.this.mComponentName.flattenToShortString() + " u" + PersistentConnection.this.mUserId);
                PersistentConnection.this.mIsConnected = true;
                PersistentConnection.this.mService = PersistentConnection.this.asInterface(service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = PersistentConnection.this.mLock;
            synchronized (object) {
                Slog.i(PersistentConnection.this.mTag, "Disconnected: " + PersistentConnection.this.mComponentName.flattenToShortString() + " u" + PersistentConnection.this.mUserId);
                PersistentConnection.this.cleanUpConnectionLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBindingDied(ComponentName name) {
            Object object = PersistentConnection.this.mLock;
            synchronized (object) {
                if (!PersistentConnection.this.mBound) {
                    Slog.w(PersistentConnection.this.mTag, "Binding died: " + PersistentConnection.this.mComponentName.flattenToShortString() + " u" + PersistentConnection.this.mUserId + " but not bound, ignore.");
                    return;
                }
                Slog.w(PersistentConnection.this.mTag, "Binding died: " + PersistentConnection.this.mComponentName.flattenToShortString() + " u" + PersistentConnection.this.mUserId);
                PersistentConnection.this.scheduleRebindLocked();
            }
        }
    };
    private final Runnable mBindForBackoffRunnable = () -> this.bindForBackoff();

    public PersistentConnection(String tag, Context context, Handler handler, int userId, ComponentName componentName, long rebindBackoffSeconds, double rebindBackoffIncrease, long rebindMaxBackoffSeconds) {
        this.mTag = tag;
        this.mContext = context;
        this.mHandler = handler;
        this.mUserId = userId;
        this.mComponentName = componentName;
        this.mRebindBackoffMs = rebindBackoffSeconds * 1000L;
        this.mRebindBackoffIncrease = rebindBackoffIncrease;
        this.mRebindMaxBackoffMs = rebindMaxBackoffSeconds * 1000L;
        this.mNextBackoffMs = this.mRebindBackoffMs;
    }

    public final ComponentName getComponentName() {
        return this.mComponentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isBound() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRebindScheduled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRebindScheduled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsConnected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getServiceBinder() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bind() {
        Object object = this.mLock;
        synchronized (object) {
            this.mShouldBeBound = true;
            this.bindInnerLocked(true);
        }
    }

    @GuardedBy(value="mLock")
    public final void bindInnerLocked(boolean resetBackoff) {
        Intent service;
        boolean success;
        this.unscheduleRebindLocked();
        if (this.mBound) {
            return;
        }
        this.mBound = true;
        if (resetBackoff) {
            this.mNextBackoffMs = this.mRebindBackoffMs;
        }
        if (!(success = this.mContext.bindServiceAsUser(service = new Intent().setComponent(this.mComponentName), this.mServiceConnection, 0x4000001, this.mHandler, UserHandle.of(this.mUserId)))) {
            Slog.e(this.mTag, "Binding: " + service.getComponent() + " u" + this.mUserId + " failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void bindForBackoff() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mShouldBeBound) {
                return;
            }
            this.bindInnerLocked(false);
        }
    }

    @GuardedBy(value="mLock")
    private void cleanUpConnectionLocked() {
        this.mIsConnected = false;
        this.mService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unbind() {
        Object object = this.mLock;
        synchronized (object) {
            this.mShouldBeBound = false;
            this.unbindLocked();
        }
    }

    @GuardedBy(value="mLock")
    private final void unbindLocked() {
        this.unscheduleRebindLocked();
        if (!this.mBound) {
            return;
        }
        Slog.i(this.mTag, "Stopping: " + this.mComponentName.flattenToShortString() + " u" + this.mUserId);
        this.mBound = false;
        this.mContext.unbindService(this.mServiceConnection);
        this.cleanUpConnectionLocked();
    }

    @GuardedBy(value="mLock")
    void unscheduleRebindLocked() {
        this.injectRemoveCallbacks(this.mBindForBackoffRunnable);
        this.mRebindScheduled = false;
    }

    @GuardedBy(value="mLock")
    void scheduleRebindLocked() {
        this.unbindLocked();
        if (!this.mRebindScheduled) {
            Slog.i(this.mTag, "Scheduling to reconnect in " + this.mNextBackoffMs + " ms (uptime)");
            this.mReconnectTime = this.injectUptimeMillis() + this.mNextBackoffMs;
            this.injectPostAtTime(this.mBindForBackoffRunnable, this.mReconnectTime);
            this.mNextBackoffMs = Math.min(this.mRebindMaxBackoffMs, (long)((double)this.mNextBackoffMs * this.mRebindBackoffIncrease));
            this.mRebindScheduled = true;
        }
    }

    protected abstract T asInterface(IBinder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String prefix, PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print(prefix);
            pw.print(this.mComponentName.flattenToShortString());
            pw.print(this.mBound ? "  [bound]" : "  [not bound]");
            pw.print(this.mIsConnected ? "  [connected]" : "  [not connected]");
            if (this.mRebindScheduled) {
                pw.print("  reconnect in ");
                TimeUtils.formatDuration(this.mReconnectTime - this.injectUptimeMillis(), pw);
            }
            pw.println();
            pw.print(prefix);
            pw.print("  Next backoff(sec): ");
            pw.print(this.mNextBackoffMs / 1000L);
        }
    }

    @VisibleForTesting
    void injectRemoveCallbacks(Runnable r) {
        this.mHandler.removeCallbacks(r);
    }

    @VisibleForTesting
    void injectPostAtTime(Runnable r, long uptimeMillis) {
        this.mHandler.postAtTime(r, uptimeMillis);
    }

    @VisibleForTesting
    long injectUptimeMillis() {
        return SystemClock.uptimeMillis();
    }

    @VisibleForTesting
    long getNextBackoffMsForTest() {
        return this.mNextBackoffMs;
    }

    @VisibleForTesting
    long getReconnectTimeForTest() {
        return this.mReconnectTime;
    }

    @VisibleForTesting
    ServiceConnection getServiceConnectionForTest() {
        return this.mServiceConnection;
    }

    @VisibleForTesting
    Runnable getBindForBackoffRunnableForTest() {
        return this.mBindForBackoffRunnable;
    }

    @VisibleForTesting
    boolean shouldBeBoundForTest() {
        return this.mShouldBeBound;
    }
}

