/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityOptions;
import android.app.AppOpsManager;
import android.app.IAssistDataReceiver;
import android.content.ComponentName;
import android.content.Intent;
import android.os.RemoteException;
import android.os.Trace;
import android.util.Slog;
import android.view.IRecentsAnimationRunner;
import com.android.server.am.ActivityDisplay;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.ActivityStartController;
import com.android.server.am.AssistDataReceiverProxy;
import com.android.server.am.AssistDataRequester;
import com.android.server.am.SafeActivityOptions;
import com.android.server.am.TaskRecord;
import com.android.server.am.UserController;
import com.android.server.wm.RecentsAnimationController;
import com.android.server.wm.WindowManagerService;

class RecentsAnimation
implements RecentsAnimationController.RecentsAnimationCallbacks,
ActivityDisplay.OnStackOrderChangedListener {
    private static final String TAG = RecentsAnimation.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final ActivityManagerService mService;
    private final ActivityStackSupervisor mStackSupervisor;
    private final ActivityStartController mActivityStartController;
    private final WindowManagerService mWindowManager;
    private final UserController mUserController;
    private final ActivityDisplay mDefaultDisplay;
    private final int mCallingPid;
    private int mTargetActivityType;
    private AssistDataRequester mAssistDataRequester;
    private ActivityStack mRestoreTargetBehindStack;

    RecentsAnimation(ActivityManagerService am, ActivityStackSupervisor stackSupervisor, ActivityStartController activityStartController, WindowManagerService wm, UserController userController, int callingPid) {
        this.mService = am;
        this.mStackSupervisor = stackSupervisor;
        this.mDefaultDisplay = stackSupervisor.getDefaultDisplay();
        this.mActivityStartController = activityStartController;
        this.mWindowManager = wm;
        this.mUserController = userController;
        this.mCallingPid = callingPid;
    }

    void startRecentsActivity(Intent intent, IRecentsAnimationRunner recentsAnimationRunner, ComponentName recentsComponent, int recentsUid, IAssistDataReceiver assistDataReceiver) {
        boolean hasExistingActivity;
        Trace.traceBegin(64L, "RecentsAnimation#startRecentsActivity");
        if (!this.mWindowManager.canStartRecentsAnimation()) {
            this.notifyAnimationCancelBeforeStart(recentsAnimationRunner);
            return;
        }
        this.mTargetActivityType = intent.getComponent() != null && recentsComponent.equals(intent.getComponent()) ? 3 : 2;
        Object targetStack = this.mDefaultDisplay.getStack(0, this.mTargetActivityType);
        ActivityRecord targetActivity = this.getTargetActivity((ActivityStack)targetStack, intent.getComponent());
        boolean bl = hasExistingActivity = targetActivity != null;
        if (hasExistingActivity) {
            ActivityDisplay display = targetActivity.getDisplay();
            this.mRestoreTargetBehindStack = display.getStackAbove((ActivityStack)targetStack);
            if (this.mRestoreTargetBehindStack == null) {
                this.notifyAnimationCancelBeforeStart(recentsAnimationRunner);
                return;
            }
        }
        if (targetActivity == null || !targetActivity.visible) {
            this.mStackSupervisor.sendPowerHintForLaunchStartIfNeeded(true, targetActivity);
        }
        this.mStackSupervisor.getActivityMetricsLogger().notifyActivityLaunching();
        this.mService.setRunningRemoteAnimation(this.mCallingPid, true);
        this.mWindowManager.deferSurfaceLayout();
        try {
            if (assistDataReceiver != null) {
                AppOpsManager appOpsManager = (AppOpsManager)this.mService.mContext.getSystemService("appops");
                AssistDataReceiverProxy proxy = new AssistDataReceiverProxy(assistDataReceiver, recentsComponent.getPackageName());
                this.mAssistDataRequester = new AssistDataRequester(this.mService.mContext, this.mService, this.mWindowManager, appOpsManager, proxy, this, 49, -1);
                this.mAssistDataRequester.requestAssistData(this.mStackSupervisor.getTopVisibleActivities(), true, false, true, false, recentsUid, recentsComponent.getPackageName());
            }
            if (hasExistingActivity) {
                this.mDefaultDisplay.moveStackBehindBottomMostVisibleStack((ActivityStack)targetStack);
                if (((ActivityStack)targetStack).topTask() != targetActivity.getTask()) {
                    ((ActivityStack)targetStack).addTask(targetActivity.getTask(), true, "startRecentsActivity");
                }
            } else {
                ActivityOptions options = ActivityOptions.makeBasic();
                options.setLaunchActivityType(this.mTargetActivityType);
                options.setAvoidMoveToFront();
                intent.addFlags(0x10010000);
                this.mActivityStartController.obtainStarter(intent, "startRecentsActivity_noTargetActivity").setCallingUid(recentsUid).setCallingPackage(recentsComponent.getPackageName()).setActivityOptions(SafeActivityOptions.fromBundle(options.toBundle())).setMayWait(this.mUserController.getCurrentUserId()).execute();
                this.mWindowManager.prepareAppTransition(0, false);
                this.mWindowManager.executeAppTransition();
                targetActivity = ((ActivityStack)this.mDefaultDisplay.getStack(0, this.mTargetActivityType)).getTopActivity();
            }
            targetActivity.mLaunchTaskBehind = true;
            this.mWindowManager.cancelRecentsAnimationSynchronously(2, "startRecentsActivity");
            this.mWindowManager.initializeRecentsAnimation(this.mTargetActivityType, recentsAnimationRunner, this, this.mDefaultDisplay.mDisplayId, this.mStackSupervisor.mRecentTasks.getRecentTaskIds());
            this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, true);
            this.mStackSupervisor.getActivityMetricsLogger().notifyActivityLaunched(2, targetActivity);
            this.mDefaultDisplay.registerStackOrderChangedListener(this);
        }
        catch (Exception e) {
            Slog.e(TAG, "Failed to start recents activity", e);
            throw e;
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void finishAnimation(@RecentsAnimationController.ReorderMode int reorderMode) {
        block6: {
            ActivityManagerService activityManagerService = this.mService;
            // MONITORENTER : activityManagerService
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.mAssistDataRequester != null) {
                    this.mAssistDataRequester.cancel();
                    this.mAssistDataRequester = null;
                }
                this.mDefaultDisplay.unregisterStackOrderChangedListener(this);
                if (this.mWindowManager.getRecentsAnimationController() != null) break block6;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                // MONITOREXIT : activityManagerService
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return;
        }
        if (reorderMode != 0) {
            this.mStackSupervisor.sendPowerHintForLaunchEndIfNeeded();
        }
        this.mService.setRunningRemoteAnimation(this.mCallingPid, false);
        this.mWindowManager.inSurfaceTransaction(() -> {
            Trace.traceBegin(64L, "RecentsAnimation#onAnimationFinished_inSurfaceTransaction");
            this.mWindowManager.deferSurfaceLayout();
            try {
                ActivityRecord targetActivity;
                this.mWindowManager.cleanupRecentsAnimation(reorderMode);
                Object targetStack = this.mDefaultDisplay.getStack(0, this.mTargetActivityType);
                ActivityRecord activityRecord = targetActivity = targetStack != null ? ((ActivityStack)targetStack).getTopActivity() : null;
                if (targetActivity == null) {
                    return;
                }
                targetActivity.mLaunchTaskBehind = false;
                if (reorderMode == 1) {
                    this.mStackSupervisor.mNoAnimActivities.add(targetActivity);
                    ((ActivityStack)targetStack).moveToFront("RecentsAnimation.onAnimationFinished()");
                } else if (reorderMode == 2) {
                    ActivityDisplay display = targetActivity.getDisplay();
                    display.moveStackBehindStack((ActivityStack)targetStack, this.mRestoreTargetBehindStack);
                } else {
                    return;
                }
                this.mWindowManager.prepareAppTransition(0, false);
                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                this.mWindowManager.executeAppTransition();
                this.mWindowManager.checkSplitScreenMinimizedChanged(true);
            }
            catch (Exception e) {
                Slog.e(TAG, "Failed to clean up recents activity", e);
                throw e;
            }
            finally {
                this.mWindowManager.continueSurfaceLayout();
                Trace.traceEnd(64L);
            }
        });
        // MONITOREXIT : activityManagerService
        ActivityManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void onAnimationFinished(@RecentsAnimationController.ReorderMode int reorderMode, boolean runSychronously) {
        if (runSychronously) {
            this.finishAnimation(reorderMode);
        } else {
            this.mService.mHandler.post(() -> this.finishAnimation(reorderMode));
        }
    }

    @Override
    public void onStackOrderChanged() {
        this.mWindowManager.cancelRecentsAnimationSynchronously(0, "stackOrderChanged");
    }

    private void notifyAnimationCancelBeforeStart(IRecentsAnimationRunner recentsAnimationRunner) {
        try {
            recentsAnimationRunner.onAnimationCanceled();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to cancel recents animation before start", e);
        }
    }

    private ActivityStack getTopNonAlwaysOnTopStack() {
        for (int i = this.mDefaultDisplay.getChildCount() - 1; i >= 0; --i) {
            ActivityStack s = this.mDefaultDisplay.getChildAt(i);
            if (s.getWindowConfiguration().isAlwaysOnTop()) continue;
            return s;
        }
        return null;
    }

    private ActivityRecord getTargetActivity(ActivityStack targetStack, ComponentName component) {
        if (targetStack == null) {
            return null;
        }
        for (int i = targetStack.getChildCount() - 1; i >= 0; --i) {
            TaskRecord task = (TaskRecord)targetStack.getChildAt(i);
            if (!task.getBaseIntent().getComponent().equals(component)) continue;
            return task.getTopActivity();
        }
        return targetStack.getTopActivity();
    }
}

