/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.AppGlobals;
import android.app.Dialog;
import android.app.IStopUserCallback;
import android.app.IUserSwitchObserver;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.UserInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.IProgressListener;
import android.os.IRemoteCallback;
import android.os.IUserManager;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManagerInternal;
import android.os.storage.IStorageManager;
import android.os.storage.StorageManager;
import android.util.ArraySet;
import android.util.IntArray;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimingsTraceLog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.SystemServiceManager;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.CarUserSwitchingDialog;
import com.android.server.am.EventLogTags;
import com.android.server.am.PreBootBroadcaster;
import com.android.server.am.UserState;
import com.android.server.am.UserSwitchingDialog;
import com.android.server.pm.UserManagerService;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

class UserController
implements Handler.Callback {
    private static final String TAG = "ActivityManager";
    static final int USER_SWITCH_TIMEOUT_MS = 3000;
    static final int REPORT_USER_SWITCH_MSG = 10;
    static final int CONTINUE_USER_SWITCH_MSG = 20;
    static final int USER_SWITCH_TIMEOUT_MSG = 30;
    static final int START_PROFILES_MSG = 40;
    static final int SYSTEM_USER_START_MSG = 50;
    static final int SYSTEM_USER_CURRENT_MSG = 60;
    static final int FOREGROUND_PROFILE_CHANGED_MSG = 70;
    static final int REPORT_USER_SWITCH_COMPLETE_MSG = 80;
    static final int USER_SWITCH_CALLBACKS_TIMEOUT_MSG = 90;
    static final int SYSTEM_USER_UNLOCK_MSG = 100;
    static final int REPORT_LOCKED_BOOT_COMPLETE_MSG = 110;
    static final int START_USER_SWITCH_FG_MSG = 120;
    static final int START_USER_SWITCH_UI_MSG = 1000;
    private static final int USER_SWITCH_CALLBACKS_TIMEOUT_MS = 5000;
    int mMaxRunningUsers;
    private final Object mLock = new Object();
    private final Injector mInjector;
    private final Handler mHandler;
    private final Handler mUiHandler;
    @GuardedBy(value="mLock")
    private volatile int mCurrentUserId = 0;
    @GuardedBy(value="mLock")
    private volatile int mTargetUserId = -10000;
    @GuardedBy(value="mLock")
    private final SparseArray<UserState> mStartedUsers = new SparseArray();
    @GuardedBy(value="mLock")
    private final ArrayList<Integer> mUserLru = new ArrayList();
    @GuardedBy(value="mLock")
    private int[] mStartedUserArray = new int[]{0};
    @GuardedBy(value="mLock")
    private int[] mCurrentProfileIds = new int[0];
    @GuardedBy(value="mLock")
    private final SparseIntArray mUserProfileGroupIds = new SparseIntArray();
    private final RemoteCallbackList<IUserSwitchObserver> mUserSwitchObservers = new RemoteCallbackList();
    boolean mUserSwitchUiEnabled = true;
    @GuardedBy(value="mLock")
    private volatile ArraySet<String> mCurWaitingUserSwitchCallbacks;
    @GuardedBy(value="mLock")
    private String mSwitchingFromSystemUserMessage;
    @GuardedBy(value="mLock")
    private String mSwitchingToSystemUserMessage;
    @GuardedBy(value="mLock")
    private ArraySet<String> mTimeoutUserSwitchCallbacks;
    private final LockPatternUtils mLockPatternUtils;

    UserController(ActivityManagerService service) {
        this(new Injector(service));
    }

    @VisibleForTesting
    UserController(Injector injector) {
        this.mInjector = injector;
        this.mHandler = this.mInjector.getHandler(this);
        this.mUiHandler = this.mInjector.getUiHandler(this);
        UserState uss = new UserState(UserHandle.SYSTEM);
        uss.mUnlockProgress.addListener(new UserProgressListener());
        this.mStartedUsers.put(0, uss);
        this.mUserLru.add(0);
        this.mLockPatternUtils = this.mInjector.getLockPatternUtils();
        this.updateStartedUserArrayLU();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserSwitch(UserState uss) {
        this.finishUserBoot(uss);
        this.startProfiles();
        Object object = this.mLock;
        synchronized (object) {
            this.stopRunningUsersLU(this.mMaxRunningUsers);
        }
    }

    List<Integer> getRunningUsersLU() {
        ArrayList<Integer> runningUsers = new ArrayList<Integer>();
        for (Integer userId : this.mUserLru) {
            UserState uss = this.mStartedUsers.get(userId);
            if (uss == null || uss.state == 4 || uss.state == 5 || userId == 0 && UserInfo.isSystemOnly(userId)) continue;
            runningUsers.add(userId);
        }
        return runningUsers;
    }

    void stopRunningUsersLU(int maxRunningUsers) {
        List<Integer> currentlyRunning = this.getRunningUsersLU();
        Iterator<Integer> iterator = currentlyRunning.iterator();
        while (currentlyRunning.size() > maxRunningUsers && iterator.hasNext()) {
            Integer userId = iterator.next();
            if (userId == 0 || userId == this.mCurrentUserId || this.stopUsersLU(userId, false, null) != 0) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canStartMoreUsers() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getRunningUsersLU().size() < this.mMaxRunningUsers;
        }
    }

    private void finishUserBoot(UserState uss) {
        this.finishUserBoot(uss, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUserBoot(UserState uss, IIntentReceiver resultTo) {
        int userId;
        block10: {
            block11: {
                userId = uss.mHandle.getIdentifier();
                Slog.d(TAG, "Finishing user boot " + userId);
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mStartedUsers.get(userId) != uss) {
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
                    if (!uss.setState(0, 1)) break block10;
                    this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
                    if (userId != 0 || this.mInjector.isRuntimeRestarted() || this.mInjector.isFirstBootOrUpgrade()) break block11;
                }
                int uptimeSeconds = (int)(SystemClock.elapsedRealtime() / 1000L);
                MetricsLogger.histogram(this.mInjector.getContext(), "framework_locked_boot_completed", uptimeSeconds);
                int MAX_UPTIME_SECONDS = 120;
                if (uptimeSeconds > 120) {
                    Slog.wtf("SystemServerTiming", "finishUserBoot took too long. uptimeSeconds=" + uptimeSeconds);
                }
            }
            this.mHandler.sendMessage(this.mHandler.obtainMessage(110, userId, 0));
            Intent intent = new Intent("android.intent.action.LOCKED_BOOT_COMPLETED", null);
            intent.putExtra("android.intent.extra.user_handle", userId);
            intent.addFlags(0x9000000);
            this.mInjector.broadcastIntent(intent, null, resultTo, 0, null, null, new String[]{"android.permission.RECEIVE_BOOT_COMPLETED"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, userId);
        }
        if (this.mInjector.getUserManager().isManagedProfile(userId)) {
            UserInfo parent = this.mInjector.getUserManager().getProfileParent(userId);
            if (parent != null && this.isUserRunning(parent.id, 4)) {
                Slog.d(TAG, "User " + userId + " (parent " + parent.id + "): attempting unlock because parent is unlocked");
                this.maybeUnlockUser(userId);
            } else {
                String parentId = parent == null ? "<null>" : String.valueOf(parent.id);
                Slog.d(TAG, "User " + userId + " (parent " + parentId + "): delaying unlock because parent is locked");
            }
        } else {
            this.maybeUnlockUser(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUserUnlocking(UserState uss) {
        int userId = uss.mHandle.getIdentifier();
        if (!StorageManager.isUserKeyUnlocked(userId)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStartedUsers.get(userId) != uss || uss.state != 1) {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
            uss.mUnlockProgress.start();
            uss.mUnlockProgress.setProgress(5, this.mInjector.getContext().getString(17039472));
            FgThread.getHandler().post(() -> {
                if (!StorageManager.isUserKeyUnlocked(userId)) {
                    Slog.w(TAG, "User key got locked unexpectedly, leaving user locked.");
                    return;
                }
                this.mInjector.getUserManager().onBeforeUnlockUser(userId);
                Object object = this.mLock;
                synchronized (object) {
                    if (!uss.setState(1, 2)) {
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
                    uss.mUnlockProgress.setProgress(20);
                    this.mHandler.obtainMessage(100, userId, 0, uss).sendToTarget();
                    return;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserUnlocked(UserState uss) {
        UserInfo parent;
        Intent unlockedIntent;
        int userId = uss.mHandle.getIdentifier();
        if (!StorageManager.isUserKeyUnlocked(userId)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStartedUsers.get(uss.mHandle.getIdentifier()) != uss) {
                return;
            }
            if (!uss.setState(2, 3)) {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
            this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
            uss.mUnlockProgress.finish();
            if (userId == 0) {
                this.mInjector.startPersistentApps(262144);
            }
            this.mInjector.installEncryptionUnawareProviders(userId);
            unlockedIntent = new Intent("android.intent.action.USER_UNLOCKED");
            unlockedIntent.putExtra("android.intent.extra.user_handle", userId);
        }
        unlockedIntent.addFlags(0x50000000);
        this.mInjector.broadcastIntent(unlockedIntent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, userId);
        if (this.getUserInfo(userId).isManagedProfile() && (parent = this.mInjector.getUserManager().getProfileParent(userId)) != null) {
            Intent profileUnlockedIntent = new Intent("android.intent.action.MANAGED_PROFILE_UNLOCKED");
            profileUnlockedIntent.putExtra("android.intent.extra.USER", UserHandle.of(userId));
            profileUnlockedIntent.addFlags(0x50000000);
            this.mInjector.broadcastIntent(profileUnlockedIntent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, parent.id);
        }
        UserInfo info = this.getUserInfo(userId);
        if (!Objects.equals(info.lastLoggedInFingerprint, Build.FINGERPRINT)) {
            boolean quiet = info.isManagedProfile() ? !uss.tokenProvided || !this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userId) : false;
            this.mInjector.sendPreBootBroadcast(userId, quiet, () -> this.finishUserUnlockedCompleted(uss));
        } else {
            this.finishUserUnlockedCompleted(uss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUserUnlockedCompleted(UserState uss) {
        UserInfo userInfo;
        int userId;
        block8: {
            userId = uss.mHandle.getIdentifier();
            Object object = this.mLock;
            synchronized (object) {
                if (this.mStartedUsers.get(uss.mHandle.getIdentifier()) != uss) {
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                userInfo = this.getUserInfo(userId);
                if (userInfo != null) break block8;
                return;
            }
        }
        if (!StorageManager.isUserKeyUnlocked(userId)) {
            return;
        }
        this.mInjector.getUserManager().onUserLoggedIn(userId);
        if (!userInfo.isInitialized() && userId != 0) {
            Slog.d(TAG, "Initializing user #" + userId);
            Intent intent = new Intent("android.intent.action.USER_INITIALIZE");
            intent.addFlags(0x11000000);
            this.mInjector.broadcastIntent(intent, null, new IIntentReceiver.Stub(){

                @Override
                public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                    UserController.this.mInjector.getUserManager().makeInitialized(userInfo.id);
                }
            }, 0, null, null, null, -1, null, true, false, ActivityManagerService.MY_PID, 1000, userId);
        }
        Slog.i(TAG, "Sending BOOT_COMPLETE user #" + userId);
        if (userId == 0 && !this.mInjector.isRuntimeRestarted() && !this.mInjector.isFirstBootOrUpgrade()) {
            int uptimeSeconds = (int)(SystemClock.elapsedRealtime() / 1000L);
            MetricsLogger.histogram(this.mInjector.getContext(), "framework_boot_completed", uptimeSeconds);
        }
        Intent bootIntent = new Intent("android.intent.action.BOOT_COMPLETED", null);
        bootIntent.putExtra("android.intent.extra.user_handle", userId);
        bootIntent.addFlags(0x9000000);
        this.mInjector.broadcastIntent(bootIntent, null, new IIntentReceiver.Stub(){

            @Override
            public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                Slog.i(UserController.TAG, "Finished processing BOOT_COMPLETED for u" + userId);
            }
        }, 0, null, null, new String[]{"android.permission.RECEIVE_BOOT_COMPLETED"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, userId);
    }

    int restartUser(int userId, final boolean foreground) {
        return this.stopUser(userId, true, new IStopUserCallback.Stub(){

            @Override
            public void userStopped(int userId) {
                UserController.this.mHandler.post(() -> UserController.this.startUser(userId, foreground));
            }

            @Override
            public void userStopAborted(int userId) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int stopUser(int userId, boolean force, IStopUserCallback callback) {
        if (this.mInjector.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: switchUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        if (userId < 0 || userId == 0) {
            throw new IllegalArgumentException("Can't stop system user " + userId);
        }
        this.enforceShellRestriction("no_debugging_features", userId);
        Object object = this.mLock;
        synchronized (object) {
            return this.stopUsersLU(userId, force, callback);
        }
    }

    private int stopUsersLU(int userId, boolean force, IStopUserCallback callback) {
        if (userId == 0) {
            return -3;
        }
        if (this.isCurrentUserLU(userId)) {
            return -2;
        }
        int[] usersToStop = this.getUsersToStopLU(userId);
        for (int i = 0; i < usersToStop.length; ++i) {
            int relatedUserId = usersToStop[i];
            if (0 != relatedUserId && !this.isCurrentUserLU(relatedUserId)) continue;
            if (force) {
                Slog.i(TAG, "Force stop user " + userId + ". Related users will not be stopped");
                this.stopSingleUserLU(userId, callback);
                return 0;
            }
            return -4;
        }
        for (int userIdToStop : usersToStop) {
            this.stopSingleUserLU(userIdToStop, userIdToStop == userId ? callback : null);
        }
        return 0;
    }

    private void stopSingleUserLU(final int userId, IStopUserCallback callback) {
        final UserState uss = this.mStartedUsers.get(userId);
        if (uss == null) {
            if (callback != null) {
                this.mHandler.post(() -> {
                    try {
                        callback.userStopped(userId);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                });
            }
            return;
        }
        if (callback != null) {
            uss.mStopCallbacks.add(callback);
        }
        if (uss.state != 4 && uss.state != 5) {
            uss.setState(4);
            this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
            this.updateStartedUserArrayLU();
            this.mHandler.post(() -> {
                Intent stoppingIntent = new Intent("android.intent.action.USER_STOPPING");
                stoppingIntent.addFlags(0x40000000);
                stoppingIntent.putExtra("android.intent.extra.user_handle", userId);
                stoppingIntent.putExtra("android.intent.extra.SHUTDOWN_USERSPACE_ONLY", true);
                IIntentReceiver.Stub stoppingReceiver = new IIntentReceiver.Stub(){

                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                        UserController.this.mHandler.post(() -> UserController.this.finishUserStopping(userId, uss));
                    }
                };
                this.mInjector.clearBroadcastQueueForUser(userId);
                this.mInjector.broadcastIntent(stoppingIntent, null, stoppingReceiver, 0, null, null, new String[]{"android.permission.INTERACT_ACROSS_USERS"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, -1);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserStopping(int userId, final UserState uss) {
        Intent shutdownIntent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        IIntentReceiver.Stub shutdownReceiver = new IIntentReceiver.Stub(){

            @Override
            public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                UserController.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        UserController.this.finishUserStopped(uss);
                    }
                });
            }
        };
        Object object = this.mLock;
        synchronized (object) {
            if (uss.state != 4) {
                return;
            }
            uss.setState(5);
        }
        this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
        this.mInjector.batteryStatsServiceNoteEvent(16391, Integer.toString(userId), userId);
        this.mInjector.getSystemServiceManager().stopUser(userId);
        this.mInjector.broadcastIntent(shutdownIntent, null, shutdownReceiver, 0, null, null, null, -1, null, true, false, ActivityManagerService.MY_PID, 1000, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserStopped(UserState uss) {
        boolean stopped;
        ArrayList<IStopUserCallback> callbacks;
        int userId = uss.mHandle.getIdentifier();
        Object object = this.mLock;
        synchronized (object) {
            callbacks = new ArrayList<IStopUserCallback>(uss.mStopCallbacks);
            if (this.mStartedUsers.get(userId) != uss || uss.state != 5) {
                stopped = false;
            } else {
                stopped = true;
                this.mStartedUsers.remove(userId);
                this.mUserLru.remove((Object)userId);
                this.updateStartedUserArrayLU();
            }
        }
        if (stopped) {
            this.mInjector.getUserManagerInternal().removeUserState(userId);
            this.mInjector.activityManagerOnUserStopped(userId);
            this.forceStopUser(userId, "finish user");
        }
        for (int i = 0; i < callbacks.size(); ++i) {
            try {
                if (stopped) {
                    callbacks.get(i).userStopped(userId);
                    continue;
                }
                callbacks.get(i).userStopAborted(userId);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (stopped) {
            this.mInjector.systemServiceManagerCleanupUser(userId);
            this.mInjector.stackSupervisorRemoveUser(userId);
            if (this.getUserInfo(userId).isEphemeral()) {
                this.mInjector.getUserManager().removeUserEvenWhenDisallowed(userId);
            }
            FgThread.getHandler().post(() -> {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mStartedUsers.get(userId) != null) {
                        Slog.w(TAG, "User was restarted, skipping key eviction");
                        return;
                    }
                }
                try {
                    this.getStorageManager().lockUserKey(userId);
                }
                catch (RemoteException re) {
                    throw re.rethrowAsRuntimeException();
                }
            });
        }
    }

    private int[] getUsersToStopLU(int userId) {
        int startedUsersSize = this.mStartedUsers.size();
        IntArray userIds = new IntArray();
        userIds.add(userId);
        int userGroupId = this.mUserProfileGroupIds.get(userId, -10000);
        for (int i = 0; i < startedUsersSize; ++i) {
            boolean sameUserId;
            UserState uss = this.mStartedUsers.valueAt(i);
            int startedUserId = uss.mHandle.getIdentifier();
            int startedUserGroupId = this.mUserProfileGroupIds.get(startedUserId, -10000);
            boolean sameGroup = userGroupId != -10000 && userGroupId == startedUserGroupId;
            boolean bl = sameUserId = startedUserId == userId;
            if (!sameGroup || sameUserId) continue;
            userIds.add(startedUserId);
        }
        return userIds.toArray();
    }

    private void forceStopUser(int userId, String reason) {
        this.mInjector.activityManagerForceStopPackage(userId, reason);
        Intent intent = new Intent("android.intent.action.USER_STOPPED");
        intent.addFlags(0x50000000);
        intent.putExtra("android.intent.extra.user_handle", userId);
        this.mInjector.broadcastIntent(intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopGuestOrEphemeralUserIfBackground(int oldUserId) {
        block9: {
            Object object;
            Object object2 = this.mLock;
            synchronized (object2) {
                UserState oldUss = this.mStartedUsers.get(oldUserId);
                if (oldUserId == 0 || oldUserId == this.mCurrentUserId || oldUss == null || oldUss.state == 4 || oldUss.state == 5) {
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                UserInfo userInfo = this.getUserInfo(oldUserId);
                if (userInfo.isEphemeral()) {
                    LocalServices.getService(UserManagerInternal.class).onEphemeralUserStop(oldUserId);
                }
                if (!userInfo.isGuest() && !userInfo.isEphemeral()) break block9;
                object = this.mLock;
            }
            synchronized (object) {
                this.stopUsersLU(oldUserId, true, null);
            }
        }
    }

    void scheduleStartProfiles() {
        if (!this.mHandler.hasMessages(40)) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(40), 1000L);
        }
    }

    void startProfiles() {
        int i;
        int currentUserId = this.getCurrentUserId();
        List<UserInfo> profiles = this.mInjector.getUserManager().getProfiles(currentUserId, false);
        ArrayList<UserInfo> profilesToStart = new ArrayList<UserInfo>(profiles.size());
        for (UserInfo user : profiles) {
            if ((user.flags & 0x10) != 16 || user.id == currentUserId || user.isQuietModeEnabled()) continue;
            profilesToStart.add(user);
        }
        int profilesToStartSize = profilesToStart.size();
        for (i = 0; i < profilesToStartSize && i < this.mMaxRunningUsers - 1; ++i) {
            this.startUser(((UserInfo)profilesToStart.get((int)i)).id, false);
        }
        if (i < profilesToStartSize) {
            Slog.w(TAG, "More profiles than MAX_RUNNING_USERS");
        }
    }

    private IStorageManager getStorageManager() {
        return IStorageManager.Stub.asInterface(ServiceManager.getService("mount"));
    }

    boolean startUser(int userId, boolean foreground) {
        return this.startUser(userId, foreground, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startUser(int userId, boolean foreground, IProgressListener unlockListener) {
        if (this.mInjector.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: switchUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        Slog.i(TAG, "Starting userid:" + userId + " fg:" + foreground);
        long ident = Binder.clearCallingIdentity();
        try {
            Intent intent;
            Object currentUserIdInt;
            UserState uss;
            UserInfo userInfo;
            int oldUserId = this.getCurrentUserId();
            if (oldUserId == userId) {
                boolean bl = true;
                return bl;
            }
            if (foreground) {
                this.mInjector.clearAllLockedTasks("startUser");
            }
            if ((userInfo = this.getUserInfo(userId)) == null) {
                Slog.w(TAG, "No user info for user #" + userId);
                boolean bl = false;
                return bl;
            }
            if (foreground && userInfo.isManagedProfile()) {
                Slog.w(TAG, "Cannot switch to User #" + userId + ": not a full user");
                boolean bl = false;
                return bl;
            }
            if (foreground && this.mUserSwitchUiEnabled) {
                this.mInjector.getWindowManager().startFreezingScreen(17432710, 17432709);
            }
            boolean needStart = false;
            boolean updateUmState = false;
            Object object = this.mLock;
            synchronized (object) {
                block44: {
                    uss = this.mStartedUsers.get(userId);
                    if (uss == null) {
                        uss = new UserState(UserHandle.of(userId));
                        uss.mUnlockProgress.addListener(new UserProgressListener());
                        this.mStartedUsers.put(userId, uss);
                        this.updateStartedUserArrayLU();
                        needStart = true;
                        updateUmState = true;
                        break block44;
                    }
                    if (uss.state != 5 || this.isCallingOnHandlerThread()) break block44;
                    Slog.i(TAG, "User #" + userId + " is shutting down - will start after full stop");
                    this.mHandler.post(() -> this.startUser(userId, foreground, unlockListener));
                    boolean bl = true;
                    return bl;
                }
                Integer userIdInt = userId;
                this.mUserLru.remove(userIdInt);
                this.mUserLru.add(userIdInt);
            }
            if (unlockListener != null) {
                uss.mUnlockProgress.addListener(unlockListener);
            }
            if (updateUmState) {
                this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
            }
            if (foreground) {
                this.mInjector.reportGlobalUsageEventLocked(16);
                object = this.mLock;
                synchronized (object) {
                    this.mCurrentUserId = userId;
                    this.mTargetUserId = -10000;
                }
                this.mInjector.updateUserConfiguration();
                this.updateCurrentProfileIds();
                this.mInjector.getWindowManager().setCurrentUser(userId, this.getCurrentProfileIds());
                this.mInjector.reportCurWakefulnessUsageEvent();
                if (this.mUserSwitchUiEnabled) {
                    this.mInjector.getWindowManager().setSwitchingUser(true);
                    this.mInjector.getWindowManager().lockNow(null);
                }
            } else {
                currentUserIdInt = this.mCurrentUserId;
                this.updateCurrentProfileIds();
                this.mInjector.getWindowManager().setCurrentProfileIds(this.getCurrentProfileIds());
                Object object2 = this.mLock;
                synchronized (object2) {
                    this.mUserLru.remove(currentUserIdInt);
                    this.mUserLru.add((Integer)currentUserIdInt);
                }
            }
            if (uss.state == 4) {
                uss.setState(uss.lastState);
                this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
                currentUserIdInt = this.mLock;
                synchronized (currentUserIdInt) {
                    this.updateStartedUserArrayLU();
                }
                needStart = true;
            } else if (uss.state == 5) {
                uss.setState(0);
                this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
                currentUserIdInt = this.mLock;
                synchronized (currentUserIdInt) {
                    this.updateStartedUserArrayLU();
                }
                needStart = true;
            }
            if (uss.state == 0) {
                this.mInjector.getUserManager().onBeforeStartUser(userId);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(50, userId, 0));
            }
            if (foreground) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(60, userId, oldUserId));
                this.mHandler.removeMessages(10);
                this.mHandler.removeMessages(30);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(10, oldUserId, userId, uss));
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(30, oldUserId, userId, uss), 3000L);
            }
            if (needStart) {
                intent = new Intent("android.intent.action.USER_STARTED");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", userId);
                this.mInjector.broadcastIntent(intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, userId);
            }
            if (foreground) {
                this.moveUserToForeground(uss, oldUserId, userId);
            } else {
                this.finishUserBoot(uss);
            }
            if (needStart) {
                intent = new Intent("android.intent.action.USER_STARTING");
                intent.addFlags(0x40000000);
                intent.putExtra("android.intent.extra.user_handle", userId);
                this.mInjector.broadcastIntent(intent, null, new IIntentReceiver.Stub(){

                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                    }
                }, 0, null, null, new String[]{"android.permission.INTERACT_ACROSS_USERS"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, -1);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return true;
    }

    private boolean isCallingOnHandlerThread() {
        return Looper.myLooper() == this.mHandler.getLooper();
    }

    void startUserInForeground(int targetUserId) {
        boolean success = this.startUser(targetUserId, true);
        if (!success) {
            this.mInjector.getWindowManager().setSwitchingUser(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unlockUser(int userId, byte[] token, byte[] secret, IProgressListener listener) {
        if (this.mInjector.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: unlockUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        long binderToken = Binder.clearCallingIdentity();
        try {
            boolean bl = this.unlockUserCleared(userId, token, secret, listener);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(binderToken);
        }
    }

    private boolean maybeUnlockUser(int userId) {
        return this.unlockUserCleared(userId, null, null, null);
    }

    private static void notifyFinished(int userId, IProgressListener listener) {
        if (listener == null) {
            return;
        }
        try {
            listener.onFinished(userId, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unlockUserCleared(int userId, byte[] token, byte[] secret, IProgressListener listener) {
        int[] userIds;
        UserState uss;
        Object userInfo;
        if (!StorageManager.isUserKeyUnlocked(userId)) {
            userInfo = this.getUserInfo(userId);
            IStorageManager storageManager = this.getStorageManager();
            try {
                storageManager.unlockUserKey(userId, ((UserInfo)userInfo).serialNumber, token, secret);
            }
            catch (RemoteException | RuntimeException e) {
                Slog.w(TAG, "Failed to unlock: " + e.getMessage());
            }
        }
        userInfo = this.mLock;
        synchronized (userInfo) {
            uss = this.mStartedUsers.get(userId);
            if (uss != null) {
                uss.mUnlockProgress.addListener(listener);
                uss.tokenProvided = token != null;
            }
        }
        if (uss == null) {
            UserController.notifyFinished(userId, listener);
            return false;
        }
        this.finishUserUnlocking(uss);
        Object object = this.mLock;
        synchronized (object) {
            userIds = new int[this.mStartedUsers.size()];
            for (int i = 0; i < userIds.length; ++i) {
                userIds[i] = this.mStartedUsers.keyAt(i);
            }
        }
        for (Object testUserId : (Object)userIds) {
            UserInfo parent = this.mInjector.getUserManager().getProfileParent((int)testUserId);
            if (parent == null || parent.id != userId || testUserId == userId) continue;
            Slog.d(TAG, "User " + (int)testUserId + " (parent " + parent.id + "): attempting unlock because parent was just unlocked");
            this.maybeUnlockUser((int)testUserId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean switchUser(int targetUserId) {
        this.enforceShellRestriction("no_debugging_features", targetUserId);
        int currentUserId = this.getCurrentUserId();
        UserInfo targetUserInfo = this.getUserInfo(targetUserId);
        if (targetUserId == currentUserId) {
            Slog.i(TAG, "user #" + targetUserId + " is already the current user");
            return true;
        }
        if (targetUserInfo == null) {
            Slog.w(TAG, "No user info for user #" + targetUserId);
            return false;
        }
        if (!targetUserInfo.supportsSwitchTo()) {
            Slog.w(TAG, "Cannot switch to User #" + targetUserId + ": not supported");
            return false;
        }
        if (targetUserInfo.isManagedProfile()) {
            Slog.w(TAG, "Cannot switch to User #" + targetUserId + ": not a full user");
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mTargetUserId = targetUserId;
        }
        if (this.mUserSwitchUiEnabled) {
            UserInfo currentUserInfo = this.getUserInfo(currentUserId);
            Pair<UserInfo, UserInfo> userNames = new Pair<UserInfo, UserInfo>(currentUserInfo, targetUserInfo);
            this.mUiHandler.removeMessages(1000);
            this.mUiHandler.sendMessage(this.mHandler.obtainMessage(1000, userNames));
        } else {
            this.mHandler.removeMessages(120);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(120, targetUserId, 0));
        }
        return true;
    }

    private void showUserSwitchDialog(Pair<UserInfo, UserInfo> fromToUserPair) {
        this.mInjector.showUserSwitchingDialog((UserInfo)fromToUserPair.first, (UserInfo)fromToUserPair.second, this.getSwitchingFromSystemUserMessage(), this.getSwitchingToSystemUserMessage());
    }

    private void dispatchForegroundProfileChanged(int userId) {
        int observerCount = this.mUserSwitchObservers.beginBroadcast();
        for (int i = 0; i < observerCount; ++i) {
            try {
                this.mUserSwitchObservers.getBroadcastItem(i).onForegroundProfileSwitch(userId);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    void dispatchUserSwitchComplete(int userId) {
        this.mInjector.getWindowManager().setSwitchingUser(false);
        int observerCount = this.mUserSwitchObservers.beginBroadcast();
        for (int i = 0; i < observerCount; ++i) {
            try {
                this.mUserSwitchObservers.getBroadcastItem(i).onUserSwitchComplete(userId);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    private void dispatchLockedBootComplete(int userId) {
        int observerCount = this.mUserSwitchObservers.beginBroadcast();
        for (int i = 0; i < observerCount; ++i) {
            try {
                this.mUserSwitchObservers.getBroadcastItem(i).onLockedBootComplete(userId);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundUsersIfEnforced(int oldUserId) {
        if (oldUserId == 0) {
            return;
        }
        boolean disallowRunInBg = this.hasUserRestriction("no_run_in_background", oldUserId);
        if (!disallowRunInBg) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.stopUsersLU(oldUserId, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutUserSwitch(UserState uss, int oldUserId, int newUserId) {
        Object object = this.mLock;
        synchronized (object) {
            Slog.e(TAG, "User switch timeout: from " + oldUserId + " to " + newUserId);
            this.mTimeoutUserSwitchCallbacks = this.mCurWaitingUserSwitchCallbacks;
            this.mHandler.removeMessages(90);
            this.sendContinueUserSwitchLU(uss, oldUserId, newUserId);
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(90, oldUserId, newUserId), 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutUserSwitchCallbacks(int oldUserId, int newUserId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTimeoutUserSwitchCallbacks != null && !this.mTimeoutUserSwitchCallbacks.isEmpty()) {
                Slog.wtf(TAG, "User switch timeout: from " + oldUserId + " to " + newUserId + ". Observers that didn't respond: " + this.mTimeoutUserSwitchCallbacks);
                this.mTimeoutUserSwitchCallbacks = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchUserSwitch(final UserState uss, final int oldUserId, final int newUserId) {
        Slog.d(TAG, "Dispatch onUserSwitching oldUser #" + oldUserId + " newUser #" + newUserId);
        int observerCount = this.mUserSwitchObservers.beginBroadcast();
        if (observerCount > 0) {
            final ArraySet<String> curWaitingUserSwitchCallbacks = new ArraySet<String>();
            Object object = this.mLock;
            synchronized (object) {
                uss.switching = true;
                this.mCurWaitingUserSwitchCallbacks = curWaitingUserSwitchCallbacks;
            }
            final AtomicInteger waitingCallbacksCount = new AtomicInteger(observerCount);
            final long dispatchStartedTime = SystemClock.elapsedRealtime();
            for (int i = 0; i < observerCount; ++i) {
                try {
                    final String name = "#" + i + " " + this.mUserSwitchObservers.getBroadcastCookie(i);
                    Object object2 = this.mLock;
                    synchronized (object2) {
                        curWaitingUserSwitchCallbacks.add(name);
                    }
                    IRemoteCallback.Stub callback = new IRemoteCallback.Stub(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void sendResult(Bundle data) throws RemoteException {
                            Object object = UserController.this.mLock;
                            synchronized (object) {
                                long delay = SystemClock.elapsedRealtime() - dispatchStartedTime;
                                if (delay > 3000L) {
                                    Slog.e(UserController.TAG, "User switch timeout: observer " + name + " sent result after " + delay + " ms");
                                }
                                curWaitingUserSwitchCallbacks.remove(name);
                                if (waitingCallbacksCount.decrementAndGet() == 0 && curWaitingUserSwitchCallbacks == UserController.this.mCurWaitingUserSwitchCallbacks) {
                                    UserController.this.sendContinueUserSwitchLU(uss, oldUserId, newUserId);
                                }
                            }
                        }
                    };
                    this.mUserSwitchObservers.getBroadcastItem(i).onUserSwitching(newUserId, callback);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        } else {
            Object object = this.mLock;
            synchronized (object) {
                this.sendContinueUserSwitchLU(uss, oldUserId, newUserId);
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    void sendContinueUserSwitchLU(UserState uss, int oldUserId, int newUserId) {
        this.mCurWaitingUserSwitchCallbacks = null;
        this.mHandler.removeMessages(30);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(20, oldUserId, newUserId, uss));
    }

    void continueUserSwitch(UserState uss, int oldUserId, int newUserId) {
        Slog.d(TAG, "Continue user switch oldUser #" + oldUserId + ", newUser #" + newUserId);
        if (this.mUserSwitchUiEnabled) {
            this.mInjector.getWindowManager().stopFreezingScreen();
        }
        uss.switching = false;
        this.mHandler.removeMessages(80);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(80, newUserId, 0));
        this.stopGuestOrEphemeralUserIfBackground(oldUserId);
        this.stopBackgroundUsersIfEnforced(oldUserId);
    }

    private void moveUserToForeground(UserState uss, int oldUserId, int newUserId) {
        boolean homeInFront = this.mInjector.stackSupervisorSwitchUser(newUserId, uss);
        if (homeInFront) {
            this.mInjector.startHomeActivity(newUserId, "moveUserToForeground");
        } else {
            this.mInjector.stackSupervisorResumeFocusedStackTopActivity();
        }
        EventLogTags.writeAmSwitchUser(newUserId);
        this.sendUserSwitchBroadcasts(oldUserId, newUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendUserSwitchBroadcasts(int oldUserId, int newUserId) {
        long ident = Binder.clearCallingIdentity();
        try {
            Intent intent;
            int profileUserId;
            int i;
            int count;
            List<UserInfo> profiles;
            if (oldUserId >= 0) {
                profiles = this.mInjector.getUserManager().getProfiles(oldUserId, false);
                count = profiles.size();
                for (i = 0; i < count; ++i) {
                    profileUserId = profiles.get((int)i).id;
                    intent = new Intent("android.intent.action.USER_BACKGROUND");
                    intent.addFlags(0x50000000);
                    intent.putExtra("android.intent.extra.user_handle", profileUserId);
                    this.mInjector.broadcastIntent(intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, profileUserId);
                }
            }
            if (newUserId >= 0) {
                profiles = this.mInjector.getUserManager().getProfiles(newUserId, false);
                count = profiles.size();
                for (i = 0; i < count; ++i) {
                    profileUserId = profiles.get((int)i).id;
                    intent = new Intent("android.intent.action.USER_FOREGROUND");
                    intent.addFlags(0x50000000);
                    intent.putExtra("android.intent.extra.user_handle", profileUserId);
                    this.mInjector.broadcastIntent(intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, profileUserId);
                }
                intent = new Intent("android.intent.action.USER_SWITCHED");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", newUserId);
                this.mInjector.broadcastIntent(intent, null, null, 0, null, null, new String[]{"android.permission.MANAGE_USERS"}, -1, null, false, false, ActivityManagerService.MY_PID, 1000, -1);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    int handleIncomingUser(int callingPid, int callingUid, int userId, boolean allowAll, int allowMode, String name, String callerPackage) {
        int callingUserId = UserHandle.getUserId(callingUid);
        if (callingUserId == userId) {
            return userId;
        }
        int targetUserId = this.unsafeConvertIncomingUser(userId);
        if (callingUid != 0 && callingUid != 1000) {
            boolean allow;
            if (this.mInjector.isCallerRecents(callingUid) && callingUserId == this.getCurrentUserId() && this.isSameProfileGroup(callingUserId, targetUserId)) {
                allow = true;
            } else if (this.mInjector.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingPid, callingUid, -1, true) == 0) {
                allow = true;
            } else if (allowMode == 2) {
                allow = false;
            } else if (this.mInjector.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS", callingPid, callingUid, -1, true) != 0) {
                allow = false;
            } else if (allowMode == 0) {
                allow = true;
            } else if (allowMode == 1) {
                allow = this.isSameProfileGroup(callingUserId, targetUserId);
            } else {
                throw new IllegalArgumentException("Unknown mode: " + allowMode);
            }
            if (!allow) {
                if (userId == -3) {
                    targetUserId = callingUserId;
                } else {
                    StringBuilder builder = new StringBuilder(128);
                    builder.append("Permission Denial: ");
                    builder.append(name);
                    if (callerPackage != null) {
                        builder.append(" from ");
                        builder.append(callerPackage);
                    }
                    builder.append(" asks to run as user ");
                    builder.append(userId);
                    builder.append(" but is calling from user ");
                    builder.append(UserHandle.getUserId(callingUid));
                    builder.append("; this requires ");
                    builder.append("android.permission.INTERACT_ACROSS_USERS_FULL");
                    if (allowMode != 2) {
                        builder.append(" or ");
                        builder.append("android.permission.INTERACT_ACROSS_USERS");
                    }
                    String msg = builder.toString();
                    Slog.w(TAG, msg);
                    throw new SecurityException(msg);
                }
            }
        }
        if (!allowAll) {
            this.ensureNotSpecialUser(targetUserId);
        }
        if (callingUid == 2000 && targetUserId >= 0 && this.hasUserRestriction("no_debugging_features", targetUserId)) {
            throw new SecurityException("Shell does not have permission to access user " + targetUserId + "\n " + Debug.getCallers(3));
        }
        return targetUserId;
    }

    int unsafeConvertIncomingUser(int userId) {
        return userId == -2 || userId == -3 ? this.getCurrentUserId() : userId;
    }

    void ensureNotSpecialUser(int userId) {
        if (userId >= 0) {
            return;
        }
        throw new IllegalArgumentException("Call does not support special user #" + userId);
    }

    void registerUserSwitchObserver(IUserSwitchObserver observer, String name) {
        Preconditions.checkNotNull(name, "Observer name cannot be null");
        if (this.mInjector.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: registerUserSwitchObserver() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        this.mUserSwitchObservers.register(observer, name);
    }

    void sendForegroundProfileChanged(int userId) {
        this.mHandler.removeMessages(70);
        this.mHandler.obtainMessage(70, userId, 0).sendToTarget();
    }

    void unregisterUserSwitchObserver(IUserSwitchObserver observer) {
        this.mUserSwitchObservers.unregister(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserState getStartedUserState(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mStartedUsers.get(userId);
        }
    }

    boolean hasStartedUserState(int userId) {
        return this.mStartedUsers.get(userId) != null;
    }

    private void updateStartedUserArrayLU() {
        UserState uss;
        int i;
        int num = 0;
        for (i = 0; i < this.mStartedUsers.size(); ++i) {
            uss = this.mStartedUsers.valueAt(i);
            if (uss.state == 4 || uss.state == 5) continue;
            ++num;
        }
        this.mStartedUserArray = new int[num];
        num = 0;
        for (i = 0; i < this.mStartedUsers.size(); ++i) {
            uss = this.mStartedUsers.valueAt(i);
            if (uss.state == 4 || uss.state == 5) continue;
            this.mStartedUserArray[num++] = this.mStartedUsers.keyAt(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendBootCompleted(IIntentReceiver resultTo) {
        Object startedUsers;
        Object object = this.mLock;
        synchronized (object) {
            startedUsers = this.mStartedUsers.clone();
        }
        for (int i = 0; i < ((SparseArray)startedUsers).size(); ++i) {
            UserState uss = (UserState)((SparseArray)startedUsers).valueAt(i);
            this.finishUserBoot(uss, resultTo);
        }
    }

    void onSystemReady() {
        this.updateCurrentProfileIds();
        this.mInjector.reportCurWakefulnessUsageEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentProfileIds() {
        List<UserInfo> profiles = this.mInjector.getUserManager().getProfiles(this.getCurrentUserId(), false);
        int[] currentProfileIds = new int[profiles.size()];
        for (int i = 0; i < currentProfileIds.length; ++i) {
            currentProfileIds[i] = profiles.get((int)i).id;
        }
        List<UserInfo> users = this.mInjector.getUserManager().getUsers(false);
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentProfileIds = currentProfileIds;
            this.mUserProfileGroupIds.clear();
            for (int i = 0; i < users.size(); ++i) {
                UserInfo user = users.get(i);
                if (user.profileGroupId == -10000) continue;
                this.mUserProfileGroupIds.put(user.id, user.profileGroupId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getStartedUserArray() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mStartedUserArray;
        }
    }

    boolean isUserRunning(int userId, int flags) {
        UserState state = this.getStartedUserState(userId);
        if (state == null) {
            return false;
        }
        if ((flags & 1) != 0) {
            return true;
        }
        if ((flags & 2) != 0) {
            switch (state.state) {
                case 0: 
                case 1: {
                    return true;
                }
            }
            return false;
        }
        if ((flags & 8) != 0) {
            switch (state.state) {
                case 2: 
                case 3: {
                    return true;
                }
                case 4: 
                case 5: {
                    return StorageManager.isUserKeyUnlocked(userId);
                }
            }
            return false;
        }
        if ((flags & 4) != 0) {
            switch (state.state) {
                case 3: {
                    return true;
                }
                case 4: 
                case 5: {
                    return StorageManager.isUserKeyUnlocked(userId);
                }
            }
            return false;
        }
        return state.state != 4 && state.state != 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserInfo getCurrentUser() {
        if (this.mInjector.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0 && this.mInjector.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: getCurrentUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        if (this.mTargetUserId == -10000) {
            return this.getUserInfo(this.mCurrentUserId);
        }
        Object object = this.mLock;
        synchronized (object) {
            return this.getCurrentUserLU();
        }
    }

    UserInfo getCurrentUserLU() {
        int userId = this.mTargetUserId != -10000 ? this.mTargetUserId : this.mCurrentUserId;
        return this.getUserInfo(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentOrTargetUserId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mTargetUserId != -10000 ? this.mTargetUserId : this.mCurrentUserId;
        }
    }

    int getCurrentOrTargetUserIdLU() {
        return this.mTargetUserId != -10000 ? this.mTargetUserId : this.mCurrentUserId;
    }

    int getCurrentUserIdLU() {
        return this.mCurrentUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentUserId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentUserId;
        }
    }

    private boolean isCurrentUserLU(int userId) {
        return userId == this.getCurrentOrTargetUserIdLU();
    }

    int[] getUsers() {
        int[] nArray;
        UserManagerService ums = this.mInjector.getUserManager();
        if (ums != null) {
            nArray = ums.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        }
        return nArray;
    }

    UserInfo getUserInfo(int userId) {
        return this.mInjector.getUserManager().getUserInfo(userId);
    }

    int[] getUserIds() {
        return this.mInjector.getUserManager().getUserIds();
    }

    int[] expandUserId(int userId) {
        if (userId != -1) {
            return new int[]{userId};
        }
        return this.getUsers();
    }

    boolean exists(int userId) {
        return this.mInjector.getUserManager().exists(userId);
    }

    void enforceShellRestriction(String restriction, int userHandle) {
        if (Binder.getCallingUid() == 2000 && (userHandle < 0 || this.hasUserRestriction(restriction, userHandle))) {
            throw new SecurityException("Shell does not have permission to access user " + userHandle);
        }
    }

    boolean hasUserRestriction(String restriction, int userId) {
        return this.mInjector.getUserManager().hasUserRestriction(restriction, userId);
    }

    Set<Integer> getProfileIds(int userId) {
        HashSet<Integer> userIds = new HashSet<Integer>();
        List<UserInfo> profiles = this.mInjector.getUserManager().getProfiles(userId, false);
        for (UserInfo user : profiles) {
            userIds.add(user.id);
        }
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSameProfileGroup(int callingUserId, int targetUserId) {
        if (callingUserId == targetUserId) {
            return true;
        }
        Object object = this.mLock;
        synchronized (object) {
            int callingProfile = this.mUserProfileGroupIds.get(callingUserId, -10000);
            int targetProfile = this.mUserProfileGroupIds.get(targetUserId, -10000);
            return callingProfile != -10000 && callingProfile == targetProfile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isUserOrItsParentRunning(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isUserRunning(userId, 0)) {
                return true;
            }
            int parentUserId = this.mUserProfileGroupIds.get(userId, -10000);
            if (parentUserId == -10000) {
                return false;
            }
            return this.isUserRunning(parentUserId, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCurrentProfile(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return ArrayUtils.contains(this.mCurrentProfileIds, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getCurrentProfileIds() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentProfileIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUserRemoved(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int size = this.mUserProfileGroupIds.size();
            for (int i = size - 1; i >= 0; --i) {
                if (this.mUserProfileGroupIds.keyAt(i) != userId && this.mUserProfileGroupIds.valueAt(i) != userId) continue;
                this.mUserProfileGroupIds.removeAt(i);
            }
            this.mCurrentProfileIds = ArrayUtils.removeInt(this.mCurrentProfileIds, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldConfirmCredentials(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStartedUsers.get(userId) == null) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            if (!this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userId)) {
                return false;
            }
            KeyguardManager km = this.mInjector.getKeyguardManager();
            return km.isDeviceLocked(userId) && km.isDeviceSecure(userId);
        }
    }

    boolean isLockScreenDisabled(int userId) {
        return this.mLockPatternUtils.isLockScreenDisabled(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSwitchingFromSystemUserMessage(String switchingFromSystemUserMessage) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSwitchingFromSystemUserMessage = switchingFromSystemUserMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSwitchingToSystemUserMessage(String switchingToSystemUserMessage) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSwitchingToSystemUserMessage = switchingToSystemUserMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSwitchingFromSystemUserMessage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSwitchingFromSystemUserMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSwitchingToSystemUserMessage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSwitchingToSystemUserMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToProto(ProtoOutputStream proto, long fieldId) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            long token = proto.start(fieldId);
            for (i = 0; i < this.mStartedUsers.size(); ++i) {
                UserState uss = this.mStartedUsers.valueAt(i);
                long uToken = proto.start(2246267895809L);
                proto.write(0x10500000001L, uss.mHandle.getIdentifier());
                uss.writeToProto(proto, 1146756268034L);
                proto.end(uToken);
            }
            for (i = 0; i < this.mStartedUserArray.length; ++i) {
                proto.write(0x20500000002L, this.mStartedUserArray[i]);
            }
            for (i = 0; i < this.mUserLru.size(); ++i) {
                proto.write(2220498092035L, this.mUserLru.get(i));
            }
            if (this.mUserProfileGroupIds.size() > 0) {
                for (i = 0; i < this.mUserProfileGroupIds.size(); ++i) {
                    long uToken = proto.start(2246267895812L);
                    proto.write(0x10500000001L, this.mUserProfileGroupIds.keyAt(i));
                    proto.write(1120986464258L, this.mUserProfileGroupIds.valueAt(i));
                    proto.end(uToken);
                }
            }
            proto.end(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(PrintWriter pw, boolean dumpAll) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            pw.println("  mStartedUsers:");
            for (i = 0; i < this.mStartedUsers.size(); ++i) {
                UserState uss = this.mStartedUsers.valueAt(i);
                pw.print("    User #");
                pw.print(uss.mHandle.getIdentifier());
                pw.print(": ");
                uss.dump("", pw);
            }
            pw.print("  mStartedUserArray: [");
            for (i = 0; i < this.mStartedUserArray.length; ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print(this.mStartedUserArray[i]);
            }
            pw.println("]");
            pw.print("  mUserLru: [");
            for (i = 0; i < this.mUserLru.size(); ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print(this.mUserLru.get(i));
            }
            pw.println("]");
            if (this.mUserProfileGroupIds.size() > 0) {
                pw.println("  mUserProfileGroupIds:");
                for (i = 0; i < this.mUserProfileGroupIds.size(); ++i) {
                    pw.print("    User #");
                    pw.print(this.mUserProfileGroupIds.keyAt(i));
                    pw.print(" -> profile #");
                    pw.println(this.mUserProfileGroupIds.valueAt(i));
                }
            }
        }
    }

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 120: {
                this.startUserInForeground(msg.arg1);
                break;
            }
            case 10: {
                this.dispatchUserSwitch((UserState)msg.obj, msg.arg1, msg.arg2);
                break;
            }
            case 20: {
                this.continueUserSwitch((UserState)msg.obj, msg.arg1, msg.arg2);
                break;
            }
            case 30: {
                this.timeoutUserSwitch((UserState)msg.obj, msg.arg1, msg.arg2);
                break;
            }
            case 90: {
                this.timeoutUserSwitchCallbacks(msg.arg1, msg.arg2);
                break;
            }
            case 40: {
                this.startProfiles();
                break;
            }
            case 50: {
                this.mInjector.batteryStatsServiceNoteEvent(32775, Integer.toString(msg.arg1), msg.arg1);
                this.mInjector.getSystemServiceManager().startUser(msg.arg1);
                break;
            }
            case 100: {
                int userId = msg.arg1;
                this.mInjector.getSystemServiceManager().unlockUser(userId);
                FgThread.getHandler().post(() -> this.mInjector.loadUserRecents(userId));
                this.finishUserUnlocked((UserState)msg.obj);
                break;
            }
            case 60: {
                this.mInjector.batteryStatsServiceNoteEvent(16392, Integer.toString(msg.arg2), msg.arg2);
                this.mInjector.batteryStatsServiceNoteEvent(32776, Integer.toString(msg.arg1), msg.arg1);
                this.mInjector.getSystemServiceManager().switchUser(msg.arg1);
                break;
            }
            case 70: {
                this.dispatchForegroundProfileChanged(msg.arg1);
                break;
            }
            case 80: {
                this.dispatchUserSwitchComplete(msg.arg1);
                break;
            }
            case 110: {
                this.dispatchLockedBootComplete(msg.arg1);
                break;
            }
            case 1000: {
                this.showUserSwitchDialog((Pair)msg.obj);
            }
        }
        return false;
    }

    @VisibleForTesting
    static class Injector {
        private final ActivityManagerService mService;
        private UserManagerService mUserManager;
        private UserManagerInternal mUserManagerInternal;

        Injector(ActivityManagerService service) {
            this.mService = service;
        }

        protected Handler getHandler(Handler.Callback callback) {
            return new Handler(this.mService.mHandlerThread.getLooper(), callback);
        }

        protected Handler getUiHandler(Handler.Callback callback) {
            return new Handler(this.mService.mUiHandler.getLooper(), callback);
        }

        protected Context getContext() {
            return this.mService.mContext;
        }

        protected LockPatternUtils getLockPatternUtils() {
            return new LockPatternUtils(this.getContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected int broadcastIntent(Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String[] requiredPermissions, int appOp, Bundle bOptions, boolean ordered, boolean sticky, int callingPid, int callingUid, int userId) {
            int n;
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    n = this.mService.broadcastIntentLocked(null, null, intent, resolvedType, resultTo, resultCode, resultData, resultExtras, requiredPermissions, appOp, bOptions, ordered, sticky, callingPid, callingUid, userId);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return n;
        }

        int checkCallingPermission(String permission2) {
            return this.mService.checkCallingPermission(permission2);
        }

        WindowManagerService getWindowManager() {
            return this.mService.mWindowManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void activityManagerOnUserStopped(int userId) {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mService.onUserStoppedLocked(userId);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        void systemServiceManagerCleanupUser(int userId) {
            this.mService.mSystemServiceManager.cleanupUser(userId);
        }

        protected UserManagerService getUserManager() {
            if (this.mUserManager == null) {
                IBinder b = ServiceManager.getService("user");
                this.mUserManager = (UserManagerService)IUserManager.Stub.asInterface(b);
            }
            return this.mUserManager;
        }

        UserManagerInternal getUserManagerInternal() {
            if (this.mUserManagerInternal == null) {
                this.mUserManagerInternal = LocalServices.getService(UserManagerInternal.class);
            }
            return this.mUserManagerInternal;
        }

        KeyguardManager getKeyguardManager() {
            return this.mService.mContext.getSystemService(KeyguardManager.class);
        }

        void batteryStatsServiceNoteEvent(int code, String name, int uid) {
            this.mService.mBatteryStatsService.noteEvent(code, name, uid);
        }

        boolean isRuntimeRestarted() {
            return this.mService.mSystemServiceManager.isRuntimeRestarted();
        }

        SystemServiceManager getSystemServiceManager() {
            return this.mService.mSystemServiceManager;
        }

        boolean isFirstBootOrUpgrade() {
            IPackageManager pm = AppGlobals.getPackageManager();
            try {
                return pm.isFirstBoot() || pm.isUpgrade();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void sendPreBootBroadcast(int userId, boolean quiet, final Runnable onFinish) {
            new PreBootBroadcaster(this.mService, userId, null, quiet){

                @Override
                public void onFinished() {
                    onFinish.run();
                }
            }.sendNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void activityManagerForceStopPackage(int userId, String reason) {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mService.forceStopPackageLocked(null, -1, false, false, true, false, false, userId, reason);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        int checkComponentPermission(String permission2, int pid, int uid, int owningUid, boolean exported) {
            return this.mService.checkComponentPermission(permission2, pid, uid, owningUid, exported);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void startHomeActivity(int userId, String reason) {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mService.startHomeActivityLocked(userId, reason);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateUserConfiguration() {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mService.updateUserConfigurationLocked();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearBroadcastQueueForUser(int userId) {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mService.clearBroadcastQueueForUserLocked(userId);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loadUserRecents(int userId) {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mService.getRecentTasks().loadUserRecentsLocked(userId);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        void startPersistentApps(int matchFlags) {
            this.mService.startPersistentApps(matchFlags);
        }

        void installEncryptionUnawareProviders(int userId) {
            this.mService.installEncryptionUnawareProviders(userId);
        }

        void showUserSwitchingDialog(UserInfo fromUser, UserInfo toUser, String switchingFromSystemUserMessage, String switchingToSystemUserMessage) {
            UserSwitchingDialog d = !this.mService.mContext.getPackageManager().hasSystemFeature("android.hardware.type.automotive") ? new UserSwitchingDialog(this.mService, this.mService.mContext, fromUser, toUser, true, switchingFromSystemUserMessage, switchingToSystemUserMessage) : new CarUserSwitchingDialog(this.mService, this.mService.mContext, fromUser, toUser, true, switchingFromSystemUserMessage, switchingToSystemUserMessage);
            ((Dialog)d).show();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reportGlobalUsageEventLocked(int event) {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mService.reportGlobalUsageEventLocked(event);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reportCurWakefulnessUsageEvent() {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mService.reportCurWakefulnessUsageEventLocked();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stackSupervisorRemoveUser(int userId) {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mService.mStackSupervisor.removeUserLocked(userId);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean stackSupervisorSwitchUser(int userId, UserState uss) {
            boolean bl;
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    bl = this.mService.mStackSupervisor.switchUserLocked(userId, uss);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : activityManagerService
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stackSupervisorResumeFocusedStackTopActivity() {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mService.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clearAllLockedTasks(String reason) {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    this.mService.getLockTaskController().clearLockedTasks(reason);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            ActivityManagerService.resetPriorityAfterLockedSection();
        }

        protected boolean isCallerRecents(int callingUid) {
            return this.mService.getRecentTasks().isCallerRecents(callingUid);
        }
    }

    private static class UserProgressListener
    extends IProgressListener.Stub {
        private volatile long mUnlockStarted;

        private UserProgressListener() {
        }

        @Override
        public void onStarted(int id2, Bundle extras) throws RemoteException {
            Slog.d(UserController.TAG, "Started unlocking user " + id2);
            this.mUnlockStarted = SystemClock.uptimeMillis();
        }

        @Override
        public void onProgress(int id2, int progress, Bundle extras) throws RemoteException {
            Slog.d(UserController.TAG, "Unlocking user " + id2 + " progress " + progress);
        }

        @Override
        public void onFinished(int id2, Bundle extras) throws RemoteException {
            long unlockTime = SystemClock.uptimeMillis() - this.mUnlockStarted;
            if (id2 == 0) {
                new TimingsTraceLog("SystemServerTiming", 524288L).logDuration("SystemUserUnlock", unlockTime);
            } else {
                Slog.d(UserController.TAG, "Unlocking user " + id2 + " took " + unlockTime + " ms");
            }
        }
    }
}

