/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IUidObserver;
import android.app.NotificationManager;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHearingAid;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.ContentObserver;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiPlaybackClient;
import android.hardware.hdmi.HdmiTvClient;
import android.media.AudioAttributes;
import android.media.AudioDevicePort;
import android.media.AudioFocusInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioManagerInternal;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioPort;
import android.media.AudioRecordingConfiguration;
import android.media.AudioRoutesInfo;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioRoutesObserver;
import android.media.IAudioServerStateDispatcher;
import android.media.IAudioService;
import android.media.IPlaybackConfigDispatcher;
import android.media.IRecordingConfigDispatcher;
import android.media.IRingtonePlayer;
import android.media.IVolumeController;
import android.media.MediaPlayer;
import android.media.PlayerBase;
import android.media.SoundPool;
import android.media.VolumePolicy;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioPolicyConfig;
import android.media.audiopolicy.IAudioPolicyCallback;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManagerInternal;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.provider.Settings;
import android.service.notification.ZenModeConfig;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import android.util.AndroidRuntimeException;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.IntArray;
import android.util.Log;
import android.util.MathUtils;
import android.util.Slog;
import android.util.SparseIntArray;
import android.view.accessibility.AccessibilityManager;
import android.widget.Toast;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.XmlUtils;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.audio.AudioEventLogger;
import com.android.server.audio.AudioServiceEvents;
import com.android.server.audio.MediaFocusControl;
import com.android.server.audio.PlaybackActivityMonitor;
import com.android.server.audio.RecordingActivityMonitor;
import com.android.server.audio.RotationHelper;
import com.android.server.pm.UserManagerService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class AudioService
extends IAudioService.Stub
implements AccessibilityManager.TouchExplorationStateChangeListener,
AccessibilityManager.AccessibilityServicesStateChangeListener {
    private static final String TAG = "AudioService";
    protected static final boolean DEBUG_MODE = Log.isLoggable("AudioService.MOD", 3);
    protected static final boolean DEBUG_AP = Log.isLoggable("AudioService.AP", 3);
    protected static final boolean DEBUG_VOL = Log.isLoggable("AudioService.VOL", 3);
    protected static final boolean DEBUG_DEVICES = Log.isLoggable("AudioService.DEVICES", 3);
    private static final int PERSIST_DELAY = 500;
    private static final int UNMUTE_STREAM_DELAY = 350;
    private static final int FLAG_ADJUST_VOLUME = 1;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final AppOpsManager mAppOps;
    private final int mPlatformType;
    private final boolean mIsSingleVolume;
    private final VolumeController mVolumeController = new VolumeController();
    private static final int SENDMSG_REPLACE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    private static final int MSG_SET_DEVICE_VOLUME = 0;
    private static final int MSG_PERSIST_VOLUME = 1;
    private static final int MSG_PERSIST_RINGER_MODE = 3;
    private static final int MSG_AUDIO_SERVER_DIED = 4;
    private static final int MSG_PLAY_SOUND_EFFECT = 5;
    private static final int MSG_LOAD_SOUND_EFFECTS = 7;
    private static final int MSG_SET_FORCE_USE = 8;
    private static final int MSG_BT_HEADSET_CNCT_FAILED = 9;
    private static final int MSG_SET_ALL_VOLUMES = 10;
    private static final int MSG_REPORT_NEW_ROUTES = 12;
    private static final int MSG_SET_FORCE_BT_A2DP_USE = 13;
    private static final int MSG_CHECK_MUSIC_ACTIVE = 14;
    private static final int MSG_BROADCAST_AUDIO_BECOMING_NOISY = 15;
    private static final int MSG_CONFIGURE_SAFE_MEDIA_VOLUME = 16;
    private static final int MSG_CONFIGURE_SAFE_MEDIA_VOLUME_FORCED = 17;
    private static final int MSG_PERSIST_SAFE_VOLUME_STATE = 18;
    private static final int MSG_BROADCAST_BT_CONNECTION_STATE = 19;
    private static final int MSG_UNLOAD_SOUND_EFFECTS = 20;
    private static final int MSG_SYSTEM_READY = 21;
    private static final int MSG_PERSIST_MUSIC_ACTIVE_MS = 22;
    private static final int MSG_UNMUTE_STREAM = 24;
    private static final int MSG_DYN_POLICY_MIX_STATE_UPDATE = 25;
    private static final int MSG_INDICATE_SYSTEM_READY = 26;
    private static final int MSG_ACCESSORY_PLUG_MEDIA_UNMUTE = 27;
    private static final int MSG_NOTIFY_VOL_EVENT = 28;
    private static final int MSG_DISPATCH_AUDIO_SERVER_STATE = 29;
    private static final int MSG_ENABLE_SURROUND_FORMATS = 30;
    private static final int MSG_SET_WIRED_DEVICE_CONNECTION_STATE = 100;
    private static final int MSG_SET_A2DP_SRC_CONNECTION_STATE = 101;
    private static final int MSG_SET_A2DP_SINK_CONNECTION_STATE = 102;
    private static final int MSG_A2DP_DEVICE_CONFIG_CHANGE = 103;
    private static final int MSG_DISABLE_AUDIO_FOR_UID = 104;
    private static final int MSG_SET_HEARING_AID_CONNECTION_STATE = 105;
    private static final int MSG_BTA2DP_DOCK_TIMEOUT = 106;
    private static final int BTA2DP_DOCK_TIMEOUT_MILLIS = 8000;
    private static final int BT_HEADSET_CNCT_TIMEOUT_MS = 3000;
    private static final int INDICATE_SYSTEM_READY_RETRY_DELAY_MS = 1000;
    private static final int BT_HEARING_AID_GAIN_MIN = -128;
    private AudioSystemThread mAudioSystemThread;
    private AudioHandler mAudioHandler;
    private VolumeStreamState[] mStreamStates;
    private SettingsObserver mSettingsObserver;
    private int mMode = 0;
    private final Object mSettingsLock = new Object();
    private SoundPool mSoundPool;
    private final Object mSoundEffectsLock = new Object();
    private static final int NUM_SOUNDPOOL_CHANNELS = 4;
    private static final String SOUND_EFFECTS_PATH = "/media/audio/ui/";
    private static final List<String> SOUND_EFFECT_FILES = new ArrayList<String>();
    private final int[][] SOUND_EFFECT_FILES_MAP = new int[10][2];
    protected static int[] MAX_STREAM_VOLUME = new int[]{5, 7, 7, 15, 7, 7, 15, 7, 15, 15, 15};
    protected static int[] MIN_STREAM_VOLUME = new int[]{1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1};
    private final int[] STREAM_VOLUME_ALIAS_VOICE = new int[]{0, 2, 2, 3, 4, 2, 6, 2, 2, 3, 3};
    private final int[] STREAM_VOLUME_ALIAS_TELEVISION = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private final int[] STREAM_VOLUME_ALIAS_DEFAULT = new int[]{0, 2, 2, 3, 4, 2, 6, 2, 2, 3, 3};
    protected static int[] mStreamVolumeAlias;
    private static final int[] STREAM_VOLUME_OPS;
    private final boolean mUseFixedVolume;
    protected static final int DEFAULT_VOL_STREAM_NO_PLAYBACK = 3;
    private final AudioSystem.ErrorCallback mAudioSystemCallback = new AudioSystem.ErrorCallback(){

        @Override
        public void onError(int error) {
            switch (error) {
                case 100: {
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 4, 1, 0, 0, null, 0);
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 29, 2, 0, 0, null, 0);
                    break;
                }
            }
        }
    };
    @GuardedBy(value="mSettingsLock")
    private int mRingerMode;
    @GuardedBy(value="mSettingsLock")
    private int mRingerModeExternal = -1;
    private int mRingerModeAffectedStreams = 0;
    private int mZenModeAffectedStreams = 0;
    private int mRingerAndZenModeMutedStreams;
    private int mMuteAffectedStreams;
    private int mVibrateSetting;
    private final boolean mHasVibrator;
    private Vibrator mVibrator;
    private static final AudioAttributes VIBRATION_ATTRIBUTES;
    private final BroadcastReceiver mReceiver = new AudioServiceBroadcastReceiver();
    private final UserManagerInternal mUserManagerInternal;
    private final ActivityManagerInternal mActivityManagerInternal;
    private final UserManagerInternal.UserRestrictionsListener mUserRestrictionsListener = new AudioServiceUserRestrictionsListener();
    private final ArrayMap<String, DeviceListSpec> mConnectedDevices = new ArrayMap();
    private int mForcedUseForComm;
    private int mForcedUseForCommExt;
    private final ArrayList<SetModeDeathHandler> mSetModeDeathHandlers = new ArrayList();
    private final ArrayList<ScoClient> mScoClients = new ArrayList();
    private BluetoothHeadset mBluetoothHeadset;
    private BluetoothDevice mBluetoothHeadsetDevice;
    private int mScoAudioState;
    private static final int SCO_STATE_INACTIVE = 0;
    private static final int SCO_STATE_ACTIVATE_REQ = 1;
    private static final int SCO_STATE_ACTIVE_INTERNAL = 3;
    private static final int SCO_STATE_DEACTIVATE_REQ = 4;
    private static final int SCO_STATE_DEACTIVATING = 5;
    private static final int SCO_STATE_ACTIVE_EXTERNAL = 2;
    private int mScoAudioMode;
    private static final int SCO_MODE_UNDEFINED = -1;
    private static final int SCO_MODE_VIRTUAL_CALL = 0;
    private static final int SCO_MODE_RAW = 1;
    private static final int SCO_MODE_VR = 2;
    private static final int SCO_MODE_MAX = 2;
    private int mScoConnectionState;
    private boolean mSystemReady;
    private boolean mUserSwitchedReceived;
    private SoundPoolCallback mSoundPoolCallBack;
    private SoundPoolListenerThread mSoundPoolListenerThread;
    private Looper mSoundPoolLooper = null;
    private static int sSoundEffectVolumeDb;
    private int mPrevVolDirection = 0;
    private int mVolumeControlStream = -1;
    private boolean mUserSelectedVolumeControlStream = false;
    private final Object mForceControlStreamLock = new Object();
    private ForceControlStreamClient mForceControlStreamClient = null;
    private volatile IRingtonePlayer mRingtonePlayer;
    private boolean mBluetoothA2dpEnabled;
    private final Object mBluetoothA2dpEnabledLock = new Object();
    final AudioRoutesInfo mCurAudioRoutes = new AudioRoutesInfo();
    final RemoteCallbackList<IAudioRoutesObserver> mRoutesObservers = new RemoteCallbackList();
    int mFixedVolumeDevices = 2890752;
    int mFullVolumeDevices = 0;
    private final boolean mMonitorRotation;
    private boolean mDockAudioMediaEnabled = true;
    private int mDockState = 0;
    private StreamVolumeCommand mPendingVolumeCommand;
    private PowerManager.WakeLock mAudioEventWakeLock;
    private final MediaFocusControl mMediaFocusControl;
    private BluetoothHearingAid mHearingAid;
    private final Object mHearingAidLock = new Object();
    private BluetoothA2dp mA2dp;
    private final Object mA2dpAvrcpLock = new Object();
    private boolean mAvrcpAbsVolSupported = false;
    private static Long mLastDeviceConnectMsgTime;
    private NotificationManager mNm;
    private AudioManagerInternal.RingerModeDelegate mRingerModeDelegate;
    private VolumePolicy mVolumePolicy = VolumePolicy.DEFAULT;
    private long mLoweredFromNormalToVibrateTime;
    private int[] mAccessibilityServiceUids;
    private final Object mAccessibilityServiceUidsLock = new Object();
    private int mEncodedSurroundMode;
    private String mEnabledSurroundFormats;
    private boolean mSurroundModeChanged;
    public static final String CONNECT_INTENT_KEY_PORT_NAME = "portName";
    public static final String CONNECT_INTENT_KEY_STATE = "state";
    public static final String CONNECT_INTENT_KEY_ADDRESS = "address";
    public static final String CONNECT_INTENT_KEY_HAS_PLAYBACK = "hasPlayback";
    public static final String CONNECT_INTENT_KEY_HAS_CAPTURE = "hasCapture";
    public static final String CONNECT_INTENT_KEY_HAS_MIDI = "hasMIDI";
    public static final String CONNECT_INTENT_KEY_DEVICE_CLASS = "class";
    private final IUidObserver mUidObserver = new IUidObserver.Stub(){

        @Override
        public void onUidStateChanged(int uid, int procState, long procStateSeq) {
        }

        @Override
        public void onUidGone(int uid, boolean disabled) {
            this.disableAudioForUid(false, uid);
        }

        @Override
        public void onUidActive(int uid) throws RemoteException {
        }

        @Override
        public void onUidIdle(int uid, boolean disabled) {
        }

        @Override
        public void onUidCachedChanged(int uid, boolean cached) {
            this.disableAudioForUid(cached, uid);
        }

        private void disableAudioForUid(boolean disable, int uid) {
            AudioService.this.queueMsgUnderWakeLock(AudioService.this.mAudioHandler, 104, disable ? 1 : 0, uid, null, 0);
        }
    };
    private int mRmtSbmxFullVolRefCount = 0;
    private ArrayList<RmtSbmxFullVolDeathHandler> mRmtSbmxFullVolDeathHandlers = new ArrayList();
    private static final String TAG_AUDIO_ASSETS = "audio_assets";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_GROUP = "group";
    private static final String ATTR_GROUP_NAME = "name";
    private static final String TAG_ASSET = "asset";
    private static final String ATTR_ASSET_ID = "id";
    private static final String ATTR_ASSET_FILE = "file";
    private static final String ASSET_FILE_VERSION = "1.0";
    private static final String GROUP_TOUCH_SOUNDS = "touch_sounds";
    private static final int SOUND_EFFECTS_LOAD_TIMEOUT_MS = 5000;
    private BluetoothProfile.ServiceListener mBluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            switch (profile) {
                case 2: {
                    ArrayMap arrayMap = AudioService.this.mConnectedDevices;
                    synchronized (arrayMap) {
                        Object object = AudioService.this.mA2dpAvrcpLock;
                        synchronized (object) {
                            AudioService.this.mA2dp = (BluetoothA2dp)proxy;
                            List<BluetoothDevice> deviceList = AudioService.this.mA2dp.getConnectedDevices();
                            if (deviceList.size() > 0) {
                                BluetoothDevice btDevice = deviceList.get(0);
                                int state = AudioService.this.mA2dp.getConnectionState(btDevice);
                                int intState = state == 2 ? 1 : 0;
                                int delay = AudioService.this.checkSendBecomingNoisyIntent(128, intState, 0);
                                String addr = btDevice == null ? "null" : btDevice.getAddress();
                                AudioService.this.mDeviceLogger.log(new AudioEventLogger.StringEvent("A2DP service connected: device addr=" + addr + " state=" + state));
                                AudioService.this.queueMsgUnderWakeLock(AudioService.this.mAudioHandler, 102, state, -1, btDevice, delay);
                            }
                        }
                    }
                }
                case 11: {
                    List<BluetoothDevice> deviceList = proxy.getConnectedDevices();
                    if (deviceList.size() <= 0) break;
                    BluetoothDevice btDevice = deviceList.get(0);
                    ArrayMap arrayMap = AudioService.this.mConnectedDevices;
                    synchronized (arrayMap) {
                        int state = proxy.getConnectionState(btDevice);
                        AudioService.this.queueMsgUnderWakeLock(AudioService.this.mAudioHandler, 101, state, 0, btDevice, 0);
                        break;
                    }
                }
                case 1: {
                    ArrayList arrayList = AudioService.this.mScoClients;
                    synchronized (arrayList) {
                        AudioService.this.mAudioHandler.removeMessages(9);
                        AudioService.this.mBluetoothHeadset = (BluetoothHeadset)proxy;
                        AudioService.this.setBtScoActiveDevice(AudioService.this.mBluetoothHeadset.getActiveDevice());
                        AudioService.this.checkScoAudioState();
                        if (AudioService.this.mScoAudioState == 1 || AudioService.this.mScoAudioState == 4) {
                            boolean status = false;
                            if (AudioService.this.mBluetoothHeadsetDevice != null) {
                                switch (AudioService.this.mScoAudioState) {
                                    case 1: {
                                        status = AudioService.connectBluetoothScoAudioHelper(AudioService.this.mBluetoothHeadset, AudioService.this.mBluetoothHeadsetDevice, AudioService.this.mScoAudioMode);
                                        if (!status) break;
                                        AudioService.this.mScoAudioState = 3;
                                        break;
                                    }
                                    case 4: {
                                        status = AudioService.disconnectBluetoothScoAudioHelper(AudioService.this.mBluetoothHeadset, AudioService.this.mBluetoothHeadsetDevice, AudioService.this.mScoAudioMode);
                                        if (!status) break;
                                        AudioService.this.mScoAudioState = 5;
                                    }
                                }
                            }
                            if (!status) {
                                AudioService.this.mScoAudioState = 0;
                                AudioService.this.broadcastScoConnectionState(0);
                            }
                        }
                        break;
                    }
                }
                case 21: {
                    ArrayMap arrayMap = AudioService.this.mConnectedDevices;
                    synchronized (arrayMap) {
                        Object object = AudioService.this.mHearingAidLock;
                        synchronized (object) {
                            AudioService.this.mHearingAid = (BluetoothHearingAid)proxy;
                            List<BluetoothDevice> deviceList = AudioService.this.mHearingAid.getConnectedDevices();
                            if (deviceList.size() > 0) {
                                BluetoothDevice btDevice = deviceList.get(0);
                                int state = AudioService.this.mHearingAid.getConnectionState(btDevice);
                                int intState = state == 2 ? 1 : 0;
                                int delay = AudioService.this.checkSendBecomingNoisyIntent(0x8000000, intState, 0);
                                AudioService.this.queueMsgUnderWakeLock(AudioService.this.mAudioHandler, 105, state, 0, btDevice, delay);
                            }
                        }
                    }
                }
            }
        }

        @Override
        public void onServiceDisconnected(int profile) {
            switch (profile) {
                case 2: {
                    AudioService.this.disconnectA2dp();
                    break;
                }
                case 11: {
                    AudioService.this.disconnectA2dpSink();
                    break;
                }
                case 1: {
                    AudioService.this.disconnectHeadset();
                    break;
                }
                case 21: {
                    AudioService.this.disconnectHearingAid();
                    break;
                }
            }
        }
    };
    private static final int DEVICE_MEDIA_UNMUTED_ON_PLUG = 67266444;
    int mBecomingNoisyIntentDevices = 201490316;
    private static final int DEVICE_OVERRIDE_A2DP_ROUTE_ON_PLUG = 67264524;
    private String mDockAddress;
    private static final int SAFE_MEDIA_VOLUME_NOT_CONFIGURED = 0;
    private static final int SAFE_MEDIA_VOLUME_DISABLED = 1;
    private static final int SAFE_MEDIA_VOLUME_INACTIVE = 2;
    private static final int SAFE_MEDIA_VOLUME_ACTIVE = 3;
    private Integer mSafeMediaVolumeState;
    private int mMcc = 0;
    private int mSafeMediaVolumeIndex;
    private float mSafeUsbMediaVolumeDbfs;
    private int mSafeUsbMediaVolumeIndex;
    private final int mSafeMediaVolumeDevices = 0x400000C;
    private int mMusicActiveMs;
    private static final int UNSAFE_VOLUME_MUSIC_ACTIVE_MS_MAX = 72000000;
    private static final int MUSIC_ACTIVE_POLL_PERIOD_MS = 60000;
    private static final int SAFE_VOLUME_CONFIGURE_TIMEOUT_MS = 30000;
    private boolean mHdmiSystemAudioSupported = false;
    private HdmiTvClient mHdmiTvClient;
    private HdmiControlManager mHdmiManager;
    private HdmiPlaybackClient mHdmiPlaybackClient;
    private boolean mHdmiCecSink;
    private MyDisplayStatusCallback mHdmiDisplayStatusCallback = new MyDisplayStatusCallback();
    private static final int DEFAULT_STREAM_TYPE_OVERRIDE_DELAY_MS = 0;
    private static final int TOUCH_EXPLORE_STREAM_TYPE_OVERRIDE_DELAY_MS = 1000;
    private static int sStreamOverrideDelayMs;
    private static boolean sIndependentA11yVolume;
    @GuardedBy(value="mSettingsLock")
    private boolean mCameraSoundForced;
    static final int LOG_NB_EVENTS_PHONE_STATE = 20;
    static final int LOG_NB_EVENTS_DEVICE_CONNECTION = 30;
    static final int LOG_NB_EVENTS_FORCE_USE = 20;
    static final int LOG_NB_EVENTS_VOLUME = 40;
    static final int LOG_NB_EVENTS_DYN_POLICY = 10;
    private final AudioEventLogger mModeLogger = new AudioEventLogger(20, "phone state (logged after successfull call to AudioSystem.setPhoneState(int))");
    private final AudioEventLogger mDeviceLogger = new AudioEventLogger(30, "wired/A2DP device connection");
    private final AudioEventLogger mForceUseLogger = new AudioEventLogger(20, "force use (logged before setForceUse() is executed)");
    private final AudioEventLogger mVolumeLogger = new AudioEventLogger(40, "volume changes (logged when command received by AudioService)");
    private final AudioEventLogger mDynPolicyLogger = new AudioEventLogger(10, "dynamic policy events (logged when command received by AudioService)");
    private static final String[] RINGER_MODE_NAMES;
    private final Object mExtVolumeControllerLock = new Object();
    private IAudioPolicyCallback mExtVolumeController;
    private final AudioSystem.DynamicPolicyCallback mDynPolicyCallback = new AudioSystem.DynamicPolicyCallback(){

        @Override
        public void onDynamicPolicyMixStateUpdate(String regId, int state) {
            if (!TextUtils.isEmpty(regId)) {
                AudioService.sendMsg(AudioService.this.mAudioHandler, 25, 2, state, 0, regId, 0);
            }
        }
    };
    private final RecordingActivityMonitor mRecordMonitor;
    private final PlaybackActivityMonitor mPlaybackMonitor;
    private HashMap<IBinder, AsdProxy> mAudioServerStateListeners = new HashMap();
    private final HashMap<IBinder, AudioPolicyProxy> mAudioPolicies = new HashMap();
    @GuardedBy(value="mAudioPolicies")
    private int mAudioPolicyCounter = 0;

    private boolean isPlatformVoice() {
        return this.mPlatformType == 1;
    }

    private boolean isPlatformTelevision() {
        return this.mPlatformType == 2;
    }

    private boolean isPlatformAutomotive() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.automotive");
    }

    private String makeDeviceListKey(int device, String deviceAddress) {
        return "0x" + Integer.toHexString(device) + ":" + deviceAddress;
    }

    public static String makeAlsaAddressString(int card, int device) {
        return "card=" + card + ";device=" + device + ";";
    }

    public AudioService(Context context) {
        int defaultSystemVolume;
        int defaultAlarmVolume;
        int defaultMusicVolume;
        int maxMusicVolume;
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mPlatformType = AudioSystem.getPlatformType(context);
        this.mIsSingleVolume = AudioSystem.isSingleVolume(context);
        this.mUserManagerInternal = LocalServices.getService(UserManagerInternal.class);
        this.mActivityManagerInternal = LocalServices.getService(ActivityManagerInternal.class);
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mAudioEventWakeLock = pm.newWakeLock(1, "handleAudioEvent");
        this.mVibrator = (Vibrator)context.getSystemService("vibrator");
        this.mHasVibrator = this.mVibrator == null ? false : this.mVibrator.hasVibrator();
        int maxCallVolume = SystemProperties.getInt("ro.config.vc_call_vol_steps", -1);
        if (maxCallVolume != -1) {
            AudioService.MAX_STREAM_VOLUME[0] = maxCallVolume;
            AudioSystem.DEFAULT_STREAM_VOLUME[0] = maxCallVolume * 3 / 4;
        }
        if ((maxMusicVolume = SystemProperties.getInt("ro.config.media_vol_steps", -1)) != -1) {
            AudioService.MAX_STREAM_VOLUME[3] = maxMusicVolume;
        }
        AudioSystem.DEFAULT_STREAM_VOLUME[3] = (defaultMusicVolume = SystemProperties.getInt("ro.config.media_vol_default", -1)) != -1 && defaultMusicVolume <= MAX_STREAM_VOLUME[3] ? defaultMusicVolume : (this.isPlatformTelevision() ? MAX_STREAM_VOLUME[3] / 4 : MAX_STREAM_VOLUME[3] / 3);
        int maxAlarmVolume = SystemProperties.getInt("ro.config.alarm_vol_steps", -1);
        if (maxAlarmVolume != -1) {
            AudioService.MAX_STREAM_VOLUME[4] = maxAlarmVolume;
        }
        AudioSystem.DEFAULT_STREAM_VOLUME[4] = (defaultAlarmVolume = SystemProperties.getInt("ro.config.alarm_vol_default", -1)) != -1 && defaultAlarmVolume <= MAX_STREAM_VOLUME[4] ? defaultAlarmVolume : 6 * MAX_STREAM_VOLUME[4] / 7;
        int maxSystemVolume = SystemProperties.getInt("ro.config.system_vol_steps", -1);
        if (maxSystemVolume != -1) {
            AudioService.MAX_STREAM_VOLUME[1] = maxSystemVolume;
        }
        AudioSystem.DEFAULT_STREAM_VOLUME[1] = (defaultSystemVolume = SystemProperties.getInt("ro.config.system_vol_default", -1)) != -1 && defaultSystemVolume <= MAX_STREAM_VOLUME[1] ? defaultSystemVolume : MAX_STREAM_VOLUME[1];
        sSoundEffectVolumeDb = context.getResources().getInteger(17694867);
        this.mForcedUseForComm = 0;
        this.createAudioSystemThread();
        AudioSystem.setErrorCallback(this.mAudioSystemCallback);
        boolean cameraSoundForced = this.readCameraSoundForced();
        this.mCameraSoundForced = new Boolean(cameraSoundForced);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 4, cameraSoundForced ? 11 : 0, new String("AudioService ctor"), 0);
        this.mSafeMediaVolumeState = new Integer(Settings.Global.getInt(this.mContentResolver, "audio_safe_volume_state", 0));
        this.mSafeMediaVolumeIndex = this.mContext.getResources().getInteger(17694852) * 10;
        this.mUseFixedVolume = this.mContext.getResources().getBoolean(17957063);
        this.updateStreamVolumeAlias(false, TAG);
        this.readPersistedSettings();
        this.readUserRestrictions();
        this.mSettingsObserver = new SettingsObserver();
        this.createStreamStates();
        this.mSafeUsbMediaVolumeIndex = this.getSafeUsbMediaVolumeIndex();
        this.mPlaybackMonitor = new PlaybackActivityMonitor(context, MAX_STREAM_VOLUME[4]);
        this.mMediaFocusControl = new MediaFocusControl(this.mContext, this.mPlaybackMonitor);
        this.mRecordMonitor = new RecordingActivityMonitor(this.mContext);
        AudioService.readAndSetLowRamDevice();
        this.mRingerAndZenModeMutedStreams = 0;
        this.setRingerModeInt(this.getRingerModeInternal(), false);
        IntentFilter intentFilter = new IntentFilter("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.profile.action.ACTIVE_DEVICE_CHANGED");
        intentFilter.addAction("android.intent.action.DOCK_EVENT");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.USER_BACKGROUND");
        intentFilter.addAction("android.intent.action.USER_FOREGROUND");
        intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mMonitorRotation = SystemProperties.getBoolean("ro.audio.monitorRotation", false);
        if (this.mMonitorRotation) {
            RotationHelper.init(this.mContext, this.mAudioHandler);
        }
        intentFilter.addAction("android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION");
        intentFilter.addAction("android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION");
        context.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, intentFilter, null, null);
        LocalServices.addService(AudioManagerInternal.class, new AudioServiceInternal());
        this.mUserManagerInternal.addUserRestrictionsListener(this.mUserRestrictionsListener);
        this.mRecordMonitor.initMonitor();
    }

    public void systemReady() {
        AudioService.sendMsg(this.mAudioHandler, 21, 2, 0, 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSystemReady() {
        this.mSystemReady = true;
        AudioService.sendMsg(this.mAudioHandler, 7, 2, 0, 0, null, 0);
        this.mScoConnectionState = -1;
        this.resetBluetoothSco();
        this.getBluetoothHeadset();
        Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
        newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", 0);
        this.sendStickyBroadcastToAll(newIntent);
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            adapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 2);
            adapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 21);
        }
        if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.hdmi.cec")) {
            HdmiControlManager hdmiControlManager = this.mHdmiManager = this.mContext.getSystemService(HdmiControlManager.class);
            synchronized (hdmiControlManager) {
                this.mHdmiTvClient = this.mHdmiManager.getTvClient();
                if (this.mHdmiTvClient != null) {
                    this.mFixedVolumeDevices &= 0xFFD3FFFD;
                }
                this.mHdmiPlaybackClient = this.mHdmiManager.getPlaybackClient();
                this.mHdmiCecSink = false;
            }
        }
        this.mNm = (NotificationManager)this.mContext.getSystemService("notification");
        AudioService.sendMsg(this.mAudioHandler, 17, 0, 0, 0, TAG, SystemProperties.getBoolean("audio.safemedia.bypass", false) ? 0 : 30000);
        this.initA11yMonitoring();
        this.onIndicateSystemReady();
    }

    void onIndicateSystemReady() {
        if (AudioSystem.systemReady() == 0) {
            return;
        }
        AudioService.sendMsg(this.mAudioHandler, 26, 0, 0, 0, null, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAudioServerDied() {
        int forSys;
        if (!this.mSystemReady || AudioSystem.checkAudioFlinger() != 0) {
            Log.e(TAG, "Audioserver died.");
            AudioService.sendMsg(this.mAudioHandler, 4, 1, 0, 0, null, 500);
            return;
        }
        Log.e(TAG, "Audioserver started.");
        AudioSystem.setParameters("restarting=true");
        AudioService.readAndSetLowRamDevice();
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            for (int i = 0; i < this.mConnectedDevices.size(); ++i) {
                DeviceListSpec spec = this.mConnectedDevices.valueAt(i);
                AudioSystem.setDeviceConnectionState(spec.mDeviceType, 1, spec.mDeviceAddress, spec.mDeviceName);
            }
        }
        if (AudioSystem.setPhoneState(this.mMode) == 0) {
            this.mModeLogger.log(new AudioEventLogger.StringEvent("onAudioServerDied causes setPhoneState(" + AudioSystem.modeToString(this.mMode) + ")"));
        }
        this.mForceUseLogger.log(new AudioServiceEvents.ForceUseEvent(0, this.mForcedUseForComm, "onAudioServerDied"));
        AudioSystem.setForceUse(0, this.mForcedUseForComm);
        this.mForceUseLogger.log(new AudioServiceEvents.ForceUseEvent(2, this.mForcedUseForComm, "onAudioServerDied"));
        AudioSystem.setForceUse(2, this.mForcedUseForComm);
        Object i = this.mSettingsLock;
        synchronized (i) {
            forSys = this.mCameraSoundForced ? 11 : 0;
        }
        this.mForceUseLogger.log(new AudioServiceEvents.ForceUseEvent(4, forSys, "onAudioServerDied"));
        AudioSystem.setForceUse(4, forSys);
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
            VolumeStreamState streamState = this.mStreamStates[streamType];
            AudioSystem.initStreamVolume(streamType, streamState.mIndexMin / 10, streamState.mIndexMax / 10);
            streamState.applyAllVolumes();
        }
        this.updateMasterMono(this.mContentResolver);
        this.setRingerModeInt(this.getRingerModeInternal(), false);
        if (this.mMonitorRotation) {
            RotationHelper.updateOrientation();
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mBluetoothA2dpEnabledLock;
        synchronized (hashMap) {
            int forMed = this.mBluetoothA2dpEnabled ? 0 : 10;
            this.mForceUseLogger.log(new AudioServiceEvents.ForceUseEvent(1, forMed, "onAudioServerDied"));
            AudioSystem.setForceUse(1, forMed);
        }
        hashMap = this.mSettingsLock;
        synchronized (hashMap) {
            int forDock = this.mDockAudioMediaEnabled ? 8 : 0;
            this.mForceUseLogger.log(new AudioServiceEvents.ForceUseEvent(3, forDock, "onAudioServerDied"));
            AudioSystem.setForceUse(3, forDock);
            this.sendEncodedSurroundMode(this.mContentResolver, "onAudioServerDied");
            this.sendEnabledSurroundFormats(this.mContentResolver, true);
        }
        if (this.mHdmiManager != null) {
            hashMap = this.mHdmiManager;
            synchronized (hashMap) {
                if (this.mHdmiTvClient != null) {
                    this.setHdmiSystemAudioSupported(this.mHdmiSystemAudioSupported);
                }
            }
        }
        hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            for (AudioPolicyProxy policy : this.mAudioPolicies.values()) {
                policy.connectMixes();
            }
        }
        this.onIndicateSystemReady();
        AudioSystem.setParameters("restarting=false");
        AudioService.sendMsg(this.mAudioHandler, 29, 2, 1, 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDispatchAudioServerStateChange(boolean state) {
        HashMap<IBinder, AsdProxy> hashMap = this.mAudioServerStateListeners;
        synchronized (hashMap) {
            for (AsdProxy asdp : this.mAudioServerStateListeners.values()) {
                try {
                    asdp.callback().dispatchAudioServerStateChange(state);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Could not call dispatchAudioServerStateChange()", e);
                }
            }
        }
    }

    private void createAudioSystemThread() {
        this.mAudioSystemThread = new AudioSystemThread();
        this.mAudioSystemThread.start();
        this.waitForAudioHandlerCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAudioHandlerCreation() {
        AudioService audioService = this;
        synchronized (audioService) {
            while (this.mAudioHandler == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "Interrupted while waiting on volume handler.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllAliasStreamVolumes() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                int numStreamTypes = AudioSystem.getNumStreamTypes();
                for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
                    this.mStreamStates[streamType].setAllIndexes(this.mStreamStates[mStreamVolumeAlias[streamType]], TAG);
                    if (this.mStreamStates[streamType].mIsMuted) continue;
                    this.mStreamStates[streamType].applyAllVolumes();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
    }

    private void checkAllFixedVolumeDevices() {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            this.mStreamStates[streamType].checkFixedVolumeDevices();
        }
    }

    private void checkAllFixedVolumeDevices(int streamType) {
        this.mStreamStates[streamType].checkFixedVolumeDevices();
    }

    private void checkMuteAffectedStreams() {
        for (int i = 0; i < this.mStreamStates.length; ++i) {
            VolumeStreamState vss = this.mStreamStates[i];
            if (vss.mIndexMin <= 0 || vss.mStreamType == 0) continue;
            this.mMuteAffectedStreams &= ~(1 << vss.mStreamType);
        }
    }

    private void createStreamStates() {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        this.mStreamStates = new VolumeStreamState[numStreamTypes];
        VolumeStreamState[] streams = this.mStreamStates;
        for (int i = 0; i < numStreamTypes; ++i) {
            streams[i] = new VolumeStreamState(Settings.System.VOLUME_SETTINGS_INT[mStreamVolumeAlias[i]], i);
        }
        this.checkAllFixedVolumeDevices();
        this.checkAllAliasStreamVolumes();
        this.checkMuteAffectedStreams();
        this.updateDefaultVolumes();
    }

    private void updateDefaultVolumes() {
        for (int stream = 0; stream < this.mStreamStates.length; ++stream) {
            if (stream == mStreamVolumeAlias[stream]) continue;
            AudioSystem.DEFAULT_STREAM_VOLUME[stream] = this.rescaleIndex(AudioSystem.DEFAULT_STREAM_VOLUME[mStreamVolumeAlias[stream]], mStreamVolumeAlias[stream], stream);
        }
    }

    private void dumpStreamStates(PrintWriter pw) {
        pw.println("\nStream volumes (device: index)");
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int i = 0; i < numStreamTypes; ++i) {
            pw.println("- " + AudioSystem.STREAM_NAMES[i] + ":");
            this.mStreamStates[i].dump(pw);
            pw.println("");
        }
        pw.print("\n- mute affected streams = 0x");
        pw.println(Integer.toHexString(this.mMuteAffectedStreams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateStreamVolumeAlias(boolean updateVolumes, String caller) {
        int dtmfStreamAlias;
        int a11yStreamAlias;
        int n = a11yStreamAlias = sIndependentA11yVolume ? 10 : 3;
        if (this.mIsSingleVolume) {
            mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_TELEVISION;
            dtmfStreamAlias = 3;
        } else {
            switch (this.mPlatformType) {
                case 1: {
                    mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_VOICE;
                    dtmfStreamAlias = 2;
                    break;
                }
                default: {
                    mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_DEFAULT;
                    dtmfStreamAlias = 3;
                }
            }
        }
        if (this.mIsSingleVolume) {
            this.mRingerModeAffectedStreams = 0;
        } else if (this.isInCommunication()) {
            dtmfStreamAlias = 0;
            this.mRingerModeAffectedStreams &= 0xFFFFFEFF;
        } else {
            this.mRingerModeAffectedStreams |= 0x100;
        }
        AudioService.mStreamVolumeAlias[8] = dtmfStreamAlias;
        AudioService.mStreamVolumeAlias[10] = a11yStreamAlias;
        if (!updateVolumes || this.mStreamStates == null) return;
        this.updateDefaultVolumes();
        Object object = this.mSettingsLock;
        synchronized (object) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                this.mStreamStates[8].setAllIndexes(this.mStreamStates[dtmfStreamAlias], caller);
                this.mStreamStates[10].mVolumeIndexSettingName = Settings.System.VOLUME_SETTINGS_INT[a11yStreamAlias];
                this.mStreamStates[10].setAllIndexes(this.mStreamStates[a11yStreamAlias], caller);
                this.mStreamStates[10].refreshRange(mStreamVolumeAlias[10]);
                // ** MonitorExit[var6_6] (shouldn't be in output)
            }
        }
        {
            if (sIndependentA11yVolume) {
                this.mStreamStates[10].readSettings();
            }
            this.setRingerModeInt(this.getRingerModeInternal(), false);
            AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[8], 0);
            AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[10], 0);
            return;
        }
    }

    private void readDockAudioSettings(ContentResolver cr) {
        this.mDockAudioMediaEnabled = Settings.Global.getInt(cr, "dock_audio_media_enabled", 0) == 1;
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 3, this.mDockAudioMediaEnabled ? 8 : 0, new String("readDockAudioSettings"), 0);
    }

    private void updateMasterMono(ContentResolver cr) {
        boolean masterMono;
        boolean bl = masterMono = Settings.System.getIntForUser(cr, "master_mono", 0, -2) == 1;
        if (DEBUG_VOL) {
            Log.d(TAG, String.format("Master mono %b", masterMono));
        }
        AudioSystem.setMasterMono(masterMono);
    }

    private void sendEncodedSurroundMode(ContentResolver cr, String eventSource) {
        int encodedSurroundMode = Settings.Global.getInt(cr, "encoded_surround_output", 0);
        this.sendEncodedSurroundMode(encodedSurroundMode, eventSource);
    }

    private void sendEncodedSurroundMode(int encodedSurroundMode, String eventSource) {
        int forceSetting = 16;
        switch (encodedSurroundMode) {
            case 0: {
                forceSetting = 0;
                break;
            }
            case 1: {
                forceSetting = 13;
                break;
            }
            case 2: {
                forceSetting = 14;
                break;
            }
            case 3: {
                forceSetting = 15;
                break;
            }
            default: {
                Log.e(TAG, "updateSurroundSoundSettings: illegal value " + encodedSurroundMode);
            }
        }
        if (forceSetting != 16) {
            AudioService.sendMsg(this.mAudioHandler, 8, 2, 6, forceSetting, eventSource, 0);
        }
    }

    private void sendEnabledSurroundFormats(ContentResolver cr, boolean forceUpdate) {
        if (this.mEncodedSurroundMode != 3) {
            return;
        }
        String enabledSurroundFormats = Settings.Global.getString(cr, "encoded_surround_output_enabled_formats");
        if (enabledSurroundFormats == null) {
            enabledSurroundFormats = "";
        }
        if (!forceUpdate && TextUtils.equals(enabledSurroundFormats, this.mEnabledSurroundFormats)) {
            return;
        }
        this.mEnabledSurroundFormats = enabledSurroundFormats;
        String[] surroundFormats = TextUtils.split(enabledSurroundFormats, ",");
        ArrayList<Integer> formats = new ArrayList<Integer>();
        for (String format : surroundFormats) {
            try {
                int audioFormat = Integer.valueOf(format);
                boolean isSurroundFormat = false;
                for (int sf : AudioFormat.SURROUND_SOUND_ENCODING) {
                    if (sf != audioFormat) continue;
                    isSurroundFormat = true;
                    break;
                }
                if (!isSurroundFormat || formats.contains(audioFormat)) continue;
                formats.add(audioFormat);
            }
            catch (Exception e) {
                Log.e(TAG, "Invalid enabled surround format:" + format);
            }
        }
        Settings.Global.putString(this.mContext.getContentResolver(), "encoded_surround_output_enabled_formats", TextUtils.join((CharSequence)",", formats));
        AudioService.sendMsg(this.mAudioHandler, 30, 2, 0, 0, formats, 0);
    }

    private void onEnableSurroundFormats(ArrayList<Integer> enabledSurroundFormats) {
        for (int surroundFormat : AudioFormat.SURROUND_SOUND_ENCODING) {
            boolean enabled = enabledSurroundFormats.contains(surroundFormat);
            int ret = AudioSystem.setSurroundFormatEnabled(surroundFormat, enabled);
            Log.i(TAG, "enable surround format:" + surroundFormat + " " + enabled + " " + ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPersistedSettings() {
        ContentResolver cr = this.mContentResolver;
        int ringerModeFromSettings = Settings.Global.getInt(cr, "mode_ringer", 2);
        int ringerMode = ringerModeFromSettings;
        if (!this.isValidRingerMode(ringerMode)) {
            ringerMode = 2;
        }
        if (ringerMode == 1 && !this.mHasVibrator) {
            ringerMode = 0;
        }
        if (ringerMode != ringerModeFromSettings) {
            Settings.Global.putInt(cr, "mode_ringer", ringerMode);
        }
        if (this.mUseFixedVolume || this.mIsSingleVolume) {
            ringerMode = 2;
        }
        Object object = this.mSettingsLock;
        synchronized (object) {
            this.mRingerMode = ringerMode;
            if (this.mRingerModeExternal == -1) {
                this.mRingerModeExternal = this.mRingerMode;
            }
            this.mVibrateSetting = AudioSystem.getValueForVibrateSetting(0, 1, this.mHasVibrator ? 2 : 0);
            this.mVibrateSetting = AudioSystem.getValueForVibrateSetting(this.mVibrateSetting, 0, this.mHasVibrator ? 2 : 0);
            this.updateRingerAndZenModeAffectedStreams();
            this.readDockAudioSettings(cr);
            this.sendEncodedSurroundMode(cr, "readPersistedSettings");
            this.sendEnabledSurroundFormats(cr, true);
        }
        this.mMuteAffectedStreams = Settings.System.getIntForUser(cr, "mute_streams_affected", 47, -2);
        this.updateMasterMono(cr);
        this.broadcastRingerMode("android.media.RINGER_MODE_CHANGED", this.mRingerModeExternal);
        this.broadcastRingerMode("android.media.INTERNAL_RINGER_MODE_CHANGED_ACTION", this.mRingerMode);
        this.broadcastVibrateSetting(0);
        this.broadcastVibrateSetting(1);
        this.mVolumeController.loadSettings(cr);
    }

    private void readUserRestrictions() {
        boolean masterMute;
        int currentUser = this.getCurrentUserId();
        boolean bl = masterMute = this.mUserManagerInternal.getUserRestriction(currentUser, "disallow_unmute_device") || this.mUserManagerInternal.getUserRestriction(currentUser, "no_adjust_volume");
        if (this.mUseFixedVolume) {
            masterMute = false;
            AudioSystem.setMasterVolume(1.0f);
        }
        if (DEBUG_VOL) {
            Log.d(TAG, String.format("Master mute %s, user=%d", masterMute, currentUser));
        }
        this.setSystemAudioMute(masterMute);
        AudioSystem.setMasterMute(masterMute);
        this.broadcastMasterMuteStatus(masterMute);
        boolean microphoneMute = this.mUserManagerInternal.getUserRestriction(currentUser, "no_unmute_microphone");
        if (DEBUG_VOL) {
            Log.d(TAG, String.format("Mic mute %s, user=%d", microphoneMute, currentUser));
        }
        AudioSystem.muteMicrophone(microphoneMute);
    }

    private int rescaleIndex(int index, int srcStream, int dstStream) {
        int rescaled = (index * this.mStreamStates[dstStream].getMaxIndex() + this.mStreamStates[srcStream].getMaxIndex() / 2) / this.mStreamStates[srcStream].getMaxIndex();
        if (rescaled < this.mStreamStates[dstStream].getMinIndex()) {
            return this.mStreamStates[dstStream].getMinIndex();
        }
        return rescaled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags, String callingPackage, String caller) {
        IAudioPolicyCallback extVolCtlr;
        Object object = this.mExtVolumeControllerLock;
        synchronized (object) {
            extVolCtlr = this.mExtVolumeController;
        }
        if (extVolCtlr != null) {
            AudioService.sendMsg(this.mAudioHandler, 28, 2, direction, 0, extVolCtlr, 0);
        } else {
            this.adjustSuggestedStreamVolume(direction, suggestedStreamType, flags, callingPackage, caller, Binder.getCallingUid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags, String callingPackage, String caller, int uid) {
        int streamType;
        if (DEBUG_VOL) {
            Log.d(TAG, "adjustSuggestedStreamVolume() stream=" + suggestedStreamType + ", flags=" + flags + ", caller=" + caller + ", volControlStream=" + this.mVolumeControlStream + ", userSelect=" + this.mUserSelectedVolumeControlStream);
        }
        this.mVolumeLogger.log(new AudioServiceEvents.VolumeEvent(0, suggestedStreamType, direction, flags, callingPackage + "/" + caller + " uid:" + uid));
        Object object = this.mForceControlStreamLock;
        synchronized (object) {
            if (this.mUserSelectedVolumeControlStream) {
                streamType = this.mVolumeControlStream;
            } else {
                int maybeActiveStreamType = this.getActiveStreamType(suggestedStreamType);
                boolean activeForReal = maybeActiveStreamType == 2 || maybeActiveStreamType == 5 ? this.wasStreamActiveRecently(maybeActiveStreamType, 0) : AudioSystem.isStreamActive(maybeActiveStreamType, 0);
                streamType = activeForReal || this.mVolumeControlStream == -1 ? maybeActiveStreamType : this.mVolumeControlStream;
            }
        }
        boolean isMute = this.isMuteAdjust(direction);
        this.ensureValidStreamType(streamType);
        int resolvedStream = mStreamVolumeAlias[streamType];
        if ((flags & 4) != 0 && resolvedStream != 2) {
            flags &= 0xFFFFFFFB;
        }
        if (this.mVolumeController.suppressAdjustment(resolvedStream, flags, isMute)) {
            direction = 0;
            flags &= 0xFFFFFFFB;
            flags &= 0xFFFFFFEF;
            if (DEBUG_VOL) {
                Log.d(TAG, "Volume controller suppressed adjustment");
            }
        }
        this.adjustStreamVolume(streamType, direction, flags, callingPackage, caller, uid);
    }

    @Override
    public void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage) {
        if (streamType == 10 && !this.canChangeAccessibilityVolume()) {
            Log.w(TAG, "Trying to call adjustStreamVolume() for a11y withoutCHANGE_ACCESSIBILITY_VOLUME / callingPackage=" + callingPackage);
            return;
        }
        this.mVolumeLogger.log(new AudioServiceEvents.VolumeEvent(1, streamType, direction, flags, callingPackage));
        this.adjustStreamVolume(streamType, direction, flags, callingPackage, callingPackage, Binder.getCallingUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage, String caller, int uid) {
        int step;
        if (this.mUseFixedVolume) {
            return;
        }
        if (DEBUG_VOL) {
            Log.d(TAG, "adjustStreamVolume() stream=" + streamType + ", dir=" + direction + ", flags=" + flags + ", caller=" + caller);
        }
        this.ensureValidDirection(direction);
        this.ensureValidStreamType(streamType);
        boolean isMuteAdjust = this.isMuteAdjust(direction);
        if (isMuteAdjust && !this.isStreamAffectedByMute(streamType)) {
            return;
        }
        if (isMuteAdjust && streamType == 0 && this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.w(TAG, "MODIFY_PHONE_STATE Permission Denial: adjustStreamVolume from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        int streamTypeAlias = mStreamVolumeAlias[streamType];
        VolumeStreamState streamState = this.mStreamStates[streamTypeAlias];
        int device = this.getDeviceForStream(streamTypeAlias);
        int aliasIndex = streamState.getIndex(device);
        boolean adjustVolume = true;
        if ((device & 0x380) == 0 && (flags & 0x40) != 0) {
            return;
        }
        if (uid == 1000) {
            uid = UserHandle.getUid(this.getCurrentUserId(), UserHandle.getAppId(uid));
        }
        if (this.mAppOps.noteOp(STREAM_VOLUME_OPS[streamTypeAlias], uid, callingPackage) != 0) {
            return;
        }
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.mPendingVolumeCommand = null;
        }
        flags &= 0xFFFFFFDF;
        if (streamTypeAlias == 3 && (device & this.mFixedVolumeDevices) != 0) {
            flags |= 0x20;
            step = this.mSafeMediaVolumeState == 3 && (device & 0x400000C) != 0 ? this.safeMediaVolumeIndex(device) : streamState.getMaxIndex();
            if (aliasIndex != 0) {
                aliasIndex = step;
            }
        } else {
            step = this.rescaleIndex(10, streamType, streamTypeAlias);
        }
        if ((flags & 2) != 0 || streamTypeAlias == this.getUiSoundsStreamType()) {
            int result;
            int ringerMode = this.getRingerModeInternal();
            if (ringerMode == 1) {
                flags &= 0xFFFFFFEF;
            }
            boolean bl = adjustVolume = ((result = this.checkForRingerModeChange(aliasIndex, direction, step, streamState.mIsMuted, callingPackage, flags)) & 1) != 0;
            if ((result & 0x80) != 0) {
                flags |= 0x80;
            }
            if ((result & 0x800) != 0) {
                flags |= 0x800;
            }
        }
        if (!this.volumeAdjustmentAllowedByDnd(streamTypeAlias, flags)) {
            adjustVolume = false;
        }
        int oldIndex = this.mStreamStates[streamType].getIndex(device);
        if (adjustVolume && direction != 0) {
            this.mAudioHandler.removeMessages(24);
            if (isMuteAdjust) {
                boolean state;
                if (direction == 101) {
                    state = !streamState.mIsMuted;
                } else {
                    boolean bl = state = direction == -100;
                }
                if (streamTypeAlias == 3) {
                    this.setSystemAudioMute(state);
                }
                for (int stream = 0; stream < this.mStreamStates.length; ++stream) {
                    if (streamTypeAlias != mStreamVolumeAlias[stream] || this.readCameraSoundForced() && this.mStreamStates[stream].getStreamType() == 7) continue;
                    this.mStreamStates[stream].mute(state);
                }
            } else if (direction == 1 && !this.checkSafeMediaVolume(streamTypeAlias, aliasIndex + step, device)) {
                Log.e(TAG, "adjustStreamVolume() safe volume index = " + oldIndex);
                this.mVolumeController.postDisplaySafeVolumeWarning(flags);
            } else if (streamState.adjustIndex(direction * step, device, caller) || streamState.mIsMuted) {
                if (streamState.mIsMuted) {
                    if (direction == 1) {
                        streamState.mute(false);
                    } else if (direction == -1 && this.mIsSingleVolume) {
                        AudioService.sendMsg(this.mAudioHandler, 24, 2, streamTypeAlias, flags, null, 350);
                    }
                }
                AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
            }
            int newIndex = this.mStreamStates[streamType].getIndex(device);
            if (streamTypeAlias == 3 && (device & 0x380) != 0 && (flags & 0x40) == 0) {
                Object object = this.mA2dpAvrcpLock;
                synchronized (object) {
                    if (this.mA2dp != null && this.mAvrcpAbsVolSupported) {
                        this.mA2dp.setAvrcpAbsoluteVolume(newIndex / 10);
                    }
                }
            }
            if ((device & 0x8000000) != 0) {
                this.setHearingAidVolume(newIndex, streamType);
            }
            if (streamTypeAlias == 3) {
                this.setSystemAudioVolume(oldIndex, newIndex, this.getStreamMaxVolume(streamType), flags);
            }
            if (this.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = this.mHdmiManager;
                synchronized (hdmiControlManager) {
                    if (this.mHdmiCecSink && streamTypeAlias == 3 && oldIndex != newIndex) {
                        HdmiPlaybackClient hdmiPlaybackClient = this.mHdmiPlaybackClient;
                        synchronized (hdmiPlaybackClient) {
                            int keyCode = direction == -1 ? 25 : 24;
                            long ident = Binder.clearCallingIdentity();
                            try {
                                this.mHdmiPlaybackClient.sendKeyEvent(keyCode, true);
                                this.mHdmiPlaybackClient.sendKeyEvent(keyCode, false);
                            }
                            finally {
                                Binder.restoreCallingIdentity(ident);
                            }
                        }
                    }
                }
            }
        }
        int index = this.mStreamStates[streamType].getIndex(device);
        this.sendVolumeUpdate(streamType, oldIndex, index, flags);
    }

    private void onUnmuteStream(int stream, int flags) {
        VolumeStreamState streamState = this.mStreamStates[stream];
        streamState.mute(false);
        int device = this.getDeviceForStream(stream);
        int index = this.mStreamStates[stream].getIndex(device);
        this.sendVolumeUpdate(stream, index, index, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSystemAudioVolume(int oldVolume, int newVolume, int maxVolume, int flags) {
        if (this.mHdmiManager == null || this.mHdmiTvClient == null || oldVolume == newVolume || (flags & 0x100) != 0) {
            return;
        }
        HdmiControlManager hdmiControlManager = this.mHdmiManager;
        synchronized (hdmiControlManager) {
            if (!this.mHdmiSystemAudioSupported) {
                return;
            }
            HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
            synchronized (hdmiTvClient) {
                long token = Binder.clearCallingIdentity();
                try {
                    this.mHdmiTvClient.setSystemAudioVolume(oldVolume, newVolume, maxVolume);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }
    }

    private int getNewRingerMode(int stream, int index, int flags) {
        if (this.mIsSingleVolume) {
            return this.getRingerModeExternal();
        }
        if ((flags & 2) != 0 || stream == this.getUiSoundsStreamType()) {
            int newRingerMode = index == 0 ? (this.mHasVibrator ? 1 : (this.mVolumePolicy.volumeDownToEnterSilent ? 0 : 2)) : 2;
            return newRingerMode;
        }
        return this.getRingerModeExternal();
    }

    private boolean isAndroidNPlus(String caller) {
        try {
            ApplicationInfo applicationInfo = this.mContext.getPackageManager().getApplicationInfoAsUser(caller, 0, UserHandle.getUserId(Binder.getCallingUid()));
            return applicationInfo.targetSdkVersion >= 24;
        }
        catch (PackageManager.NameNotFoundException e) {
            return true;
        }
    }

    private boolean wouldToggleZenMode(int newMode) {
        if (this.getRingerModeExternal() == 0 && newMode != 0) {
            return true;
        }
        return this.getRingerModeExternal() != 0 && newMode == 0;
    }

    private void onSetStreamVolume(int streamType, int index, int flags, int device, String caller) {
        int stream = mStreamVolumeAlias[streamType];
        this.setStreamVolumeInt(stream, index, device, false, caller);
        if ((flags & 2) != 0 || stream == this.getUiSoundsStreamType()) {
            this.setRingerMode(this.getNewRingerMode(stream, index, flags), "AudioService.onSetStreamVolume", false);
        }
        this.mStreamStates[stream].mute(index == 0);
    }

    @Override
    public void setStreamVolume(int streamType, int index, int flags, String callingPackage) {
        if (streamType == 10 && !this.canChangeAccessibilityVolume()) {
            Log.w(TAG, "Trying to call setStreamVolume() for a11y without CHANGE_ACCESSIBILITY_VOLUME  callingPackage=" + callingPackage);
            return;
        }
        if (streamType == 0 && index == 0 && this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.w(TAG, "Trying to call setStreamVolume() for STREAM_VOICE_CALL and index 0 without MODIFY_PHONE_STATE  callingPackage=" + callingPackage);
            return;
        }
        this.mVolumeLogger.log(new AudioServiceEvents.VolumeEvent(2, streamType, index, flags, callingPackage));
        this.setStreamVolume(streamType, index, flags, callingPackage, callingPackage, Binder.getCallingUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canChangeAccessibilityVolume() {
        Object object = this.mAccessibilityServiceUidsLock;
        synchronized (object) {
            if (0 == this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_ACCESSIBILITY_VOLUME")) {
                return true;
            }
            if (this.mAccessibilityServiceUids != null) {
                int callingUid = Binder.getCallingUid();
                for (int i = 0; i < this.mAccessibilityServiceUids.length; ++i) {
                    if (this.mAccessibilityServiceUids[i] != callingUid) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStreamVolume(int streamType, int index, int flags, String callingPackage, String caller, int uid) {
        int oldIndex;
        if (DEBUG_VOL) {
            Log.d(TAG, "setStreamVolume(stream=" + streamType + ", index=" + index + ", calling=" + callingPackage + ")");
        }
        if (this.mUseFixedVolume) {
            return;
        }
        this.ensureValidStreamType(streamType);
        int streamTypeAlias = mStreamVolumeAlias[streamType];
        VolumeStreamState streamState = this.mStreamStates[streamTypeAlias];
        int device = this.getDeviceForStream(streamType);
        if ((device & 0x380) == 0 && (flags & 0x40) != 0) {
            return;
        }
        if (uid == 1000) {
            uid = UserHandle.getUid(this.getCurrentUserId(), UserHandle.getAppId(uid));
        }
        if (this.mAppOps.noteOp(STREAM_VOLUME_OPS[streamTypeAlias], uid, callingPackage) != 0) {
            return;
        }
        if (this.isAndroidNPlus(callingPackage) && this.wouldToggleZenMode(this.getNewRingerMode(streamTypeAlias, index, flags)) && !this.mNm.isNotificationPolicyAccessGrantedForPackage(callingPackage)) {
            throw new SecurityException("Not allowed to change Do Not Disturb state");
        }
        if (!this.volumeAdjustmentAllowedByDnd(streamTypeAlias, flags)) {
            return;
        }
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.mPendingVolumeCommand = null;
            oldIndex = streamState.getIndex(device);
            index = this.rescaleIndex(index * 10, streamType, streamTypeAlias);
            if (streamTypeAlias == 3 && (device & 0x380) != 0 && (flags & 0x40) == 0) {
                Object object = this.mA2dpAvrcpLock;
                synchronized (object) {
                    if (this.mA2dp != null && this.mAvrcpAbsVolSupported) {
                        this.mA2dp.setAvrcpAbsoluteVolume(index / 10);
                    }
                }
            }
            if ((device & 0x8000000) != 0) {
                this.setHearingAidVolume(index, streamType);
            }
            if (streamTypeAlias == 3) {
                this.setSystemAudioVolume(oldIndex, index, this.getStreamMaxVolume(streamType), flags);
            }
            flags &= 0xFFFFFFDF;
            if (streamTypeAlias == 3 && (device & this.mFixedVolumeDevices) != 0) {
                flags |= 0x20;
                if (index != 0) {
                    index = this.mSafeMediaVolumeState == 3 && (device & 0x400000C) != 0 ? this.safeMediaVolumeIndex(device) : streamState.getMaxIndex();
                }
            }
            if (!this.checkSafeMediaVolume(streamTypeAlias, index, device)) {
                this.mVolumeController.postDisplaySafeVolumeWarning(flags);
                this.mPendingVolumeCommand = new StreamVolumeCommand(streamType, index, flags, device);
            } else {
                this.onSetStreamVolume(streamType, index, flags, device, caller);
                index = this.mStreamStates[streamType].getIndex(device);
            }
        }
        this.sendVolumeUpdate(streamType, oldIndex, index, flags);
    }

    private boolean volumeAdjustmentAllowedByDnd(int streamTypeAlias, int flags) {
        switch (this.mNm.getZenMode()) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: {
                return !this.isStreamMutedByRingerOrZenMode(streamTypeAlias) || streamTypeAlias == this.getUiSoundsStreamType() || (flags & 2) != 0;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceVolumeControlStream(int streamType, IBinder cb) {
        if (DEBUG_VOL) {
            Log.d(TAG, String.format("forceVolumeControlStream(%d)", streamType));
        }
        Object object = this.mForceControlStreamLock;
        synchronized (object) {
            if (this.mVolumeControlStream != -1 && streamType != -1) {
                this.mUserSelectedVolumeControlStream = true;
            }
            this.mVolumeControlStream = streamType;
            if (this.mVolumeControlStream == -1) {
                if (this.mForceControlStreamClient != null) {
                    this.mForceControlStreamClient.release();
                    this.mForceControlStreamClient = null;
                }
                this.mUserSelectedVolumeControlStream = false;
            } else if (null == this.mForceControlStreamClient) {
                this.mForceControlStreamClient = new ForceControlStreamClient(cb);
            } else if (this.mForceControlStreamClient.getBinder() == cb) {
                Log.d(TAG, "forceVolumeControlStream cb:" + cb + " is already linked.");
            } else {
                this.mForceControlStreamClient.release();
                this.mForceControlStreamClient = new ForceControlStreamClient(cb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBroadcastToAll(Intent intent) {
        intent.addFlags(0x4000000);
        intent.addFlags(0x10000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStickyBroadcastToAll(Intent intent) {
        intent.addFlags(0x10000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentUserId() {
        long ident = Binder.clearCallingIdentity();
        try {
            UserInfo currentUser = ActivityManager.getService().getCurrentUser();
            int n = currentUser.id;
            return n;
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return 0;
    }

    protected void sendVolumeUpdate(int streamType, int oldIndex, int index, int flags) {
        if ((streamType = mStreamVolumeAlias[streamType]) == 3) {
            flags = this.updateFlagsForSystemAudio(flags);
        }
        this.mVolumeController.postVolumeChanged(streamType, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateFlagsForSystemAudio(int flags) {
        if (this.mHdmiTvClient != null) {
            HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
            synchronized (hdmiTvClient) {
                if (this.mHdmiSystemAudioSupported && (flags & 0x100) == 0) {
                    flags &= 0xFFFFFFFE;
                }
            }
        }
        return flags;
    }

    private void sendMasterMuteUpdate(boolean muted, int flags) {
        this.mVolumeController.postMasterMuteChanged(this.updateFlagsForSystemAudio(flags));
        this.broadcastMasterMuteStatus(muted);
    }

    private void broadcastMasterMuteStatus(boolean muted) {
        Intent intent = new Intent("android.media.MASTER_MUTE_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_MASTER_VOLUME_MUTED", muted);
        intent.addFlags(0x24000000);
        this.sendStickyBroadcastToAll(intent);
    }

    private void setStreamVolumeInt(int streamType, int index, int device, boolean force, String caller) {
        VolumeStreamState streamState = this.mStreamStates[streamType];
        if (streamState.setIndex(index, device, caller) || force) {
            AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSystemAudioMute(boolean state) {
        if (this.mHdmiManager == null || this.mHdmiTvClient == null) {
            return;
        }
        HdmiControlManager hdmiControlManager = this.mHdmiManager;
        synchronized (hdmiControlManager) {
            if (!this.mHdmiSystemAudioSupported) {
                return;
            }
            HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
            synchronized (hdmiTvClient) {
                long token = Binder.clearCallingIdentity();
                try {
                    this.mHdmiTvClient.setSystemAudioMute(state);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStreamMute(int streamType) {
        if (streamType == Integer.MIN_VALUE) {
            streamType = this.getActiveStreamType(streamType);
        }
        Class<VolumeStreamState> clazz = VolumeStreamState.class;
        synchronized (VolumeStreamState.class) {
            this.ensureValidStreamType(streamType);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.mStreamStates[streamType].mIsMuted;
        }
    }

    private boolean discardRmtSbmxFullVolDeathHandlerFor(IBinder cb) {
        for (RmtSbmxFullVolDeathHandler handler : this.mRmtSbmxFullVolDeathHandlers) {
            if (!handler.isHandlerFor(cb)) continue;
            handler.forget();
            this.mRmtSbmxFullVolDeathHandlers.remove(handler);
            return true;
        }
        return false;
    }

    private boolean hasRmtSbmxFullVolDeathHandlerFor(IBinder cb) {
        Iterator<RmtSbmxFullVolDeathHandler> it = this.mRmtSbmxFullVolDeathHandlers.iterator();
        while (it.hasNext()) {
            if (!it.next().isHandlerFor(cb)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceRemoteSubmixFullVolume(boolean startForcing, IBinder cb) {
        if (cb == null) {
            return;
        }
        if (0 != this.mContext.checkCallingOrSelfPermission("android.permission.CAPTURE_AUDIO_OUTPUT")) {
            Log.w(TAG, "Trying to call forceRemoteSubmixFullVolume() without CAPTURE_AUDIO_OUTPUT");
            return;
        }
        ArrayList<RmtSbmxFullVolDeathHandler> arrayList = this.mRmtSbmxFullVolDeathHandlers;
        synchronized (arrayList) {
            boolean applyRequired = false;
            if (startForcing) {
                if (!this.hasRmtSbmxFullVolDeathHandlerFor(cb)) {
                    this.mRmtSbmxFullVolDeathHandlers.add(new RmtSbmxFullVolDeathHandler(cb));
                    if (this.mRmtSbmxFullVolRefCount == 0) {
                        this.mFullVolumeDevices |= 0x8000;
                        this.mFixedVolumeDevices |= 0x8000;
                        applyRequired = true;
                    }
                    ++this.mRmtSbmxFullVolRefCount;
                }
            } else if (this.discardRmtSbmxFullVolDeathHandlerFor(cb) && this.mRmtSbmxFullVolRefCount > 0) {
                --this.mRmtSbmxFullVolRefCount;
                if (this.mRmtSbmxFullVolRefCount == 0) {
                    this.mFullVolumeDevices &= 0xFFFF7FFF;
                    this.mFixedVolumeDevices &= 0xFFFF7FFF;
                    applyRequired = true;
                }
            }
            if (applyRequired) {
                this.checkAllFixedVolumeDevices(3);
                this.mStreamStates[3].applyAllVolumes();
            }
        }
    }

    private void setMasterMuteInternal(boolean mute, int flags, String callingPackage, int uid, int userId) {
        if (uid == 1000) {
            uid = UserHandle.getUid(userId, UserHandle.getAppId(uid));
        }
        if (!mute && this.mAppOps.noteOp(33, uid, callingPackage) != 0) {
            return;
        }
        if (userId != UserHandle.getCallingUserId() && this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            return;
        }
        this.setMasterMuteInternalNoCallerCheck(mute, flags, userId);
    }

    private void setMasterMuteInternalNoCallerCheck(boolean mute, int flags, int userId) {
        if (DEBUG_VOL) {
            Log.d(TAG, String.format("Master mute %s, %d, user=%d", mute, flags, userId));
        }
        if (!this.isPlatformAutomotive() && this.mUseFixedVolume) {
            return;
        }
        if (this.getCurrentUserId() == userId && mute != AudioSystem.getMasterMute()) {
            this.setSystemAudioMute(mute);
            AudioSystem.setMasterMute(mute);
            this.sendMasterMuteUpdate(mute, flags);
            Intent intent = new Intent("android.media.MASTER_MUTE_CHANGED_ACTION");
            intent.putExtra("android.media.EXTRA_MASTER_VOLUME_MUTED", mute);
            this.sendBroadcastToAll(intent);
        }
    }

    @Override
    public boolean isMasterMute() {
        return AudioSystem.getMasterMute();
    }

    @Override
    public void setMasterMute(boolean mute, int flags, String callingPackage, int userId) {
        this.setMasterMuteInternal(mute, flags, callingPackage, Binder.getCallingUid(), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        int device = this.getDeviceForStream(streamType);
        Class<VolumeStreamState> clazz = VolumeStreamState.class;
        synchronized (VolumeStreamState.class) {
            int index = this.mStreamStates[streamType].getIndex(device);
            if (this.mStreamStates[streamType].mIsMuted) {
                index = 0;
            }
            if (index != 0 && mStreamVolumeAlias[streamType] == 3 && (device & this.mFixedVolumeDevices) != 0) {
                index = this.mStreamStates[streamType].getMaxIndex();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (index + 5) / 10;
        }
    }

    @Override
    public int getStreamMaxVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return (this.mStreamStates[streamType].getMaxIndex() + 5) / 10;
    }

    @Override
    public int getStreamMinVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return (this.mStreamStates[streamType].getMinIndex() + 5) / 10;
    }

    @Override
    public int getLastAudibleStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        int device = this.getDeviceForStream(streamType);
        return (this.mStreamStates[streamType].getIndex(device) + 5) / 10;
    }

    @Override
    public int getUiSoundsStreamType() {
        return mStreamVolumeAlias[1];
    }

    @Override
    public void setMicrophoneMute(boolean on, String callingPackage, int userId) {
        int uid = Binder.getCallingUid();
        if (uid == 1000) {
            uid = UserHandle.getUid(userId, UserHandle.getAppId(uid));
        }
        if (!on && this.mAppOps.noteOp(44, uid, callingPackage) != 0) {
            return;
        }
        if (!this.checkAudioSettingsPermission("setMicrophoneMute()")) {
            return;
        }
        if (userId != UserHandle.getCallingUserId() && this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            return;
        }
        this.setMicrophoneMuteNoCallerCheck(on, userId);
    }

    private void setMicrophoneMuteNoCallerCheck(boolean on, int userId) {
        if (DEBUG_VOL) {
            Log.d(TAG, String.format("Mic mute %s, user=%d", on, userId));
        }
        if (this.getCurrentUserId() == userId) {
            boolean currentMute = AudioSystem.isMicrophoneMuted();
            long identity = Binder.clearCallingIdentity();
            AudioSystem.muteMicrophone(on);
            Binder.restoreCallingIdentity(identity);
            if (on != currentMute) {
                this.mContext.sendBroadcast(new Intent("android.media.action.MICROPHONE_MUTE_CHANGED").setFlags(0x40000000));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRingerModeExternal() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            return this.mRingerModeExternal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRingerModeInternal() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            return this.mRingerMode;
        }
    }

    private void ensureValidRingerMode(int ringerMode) {
        if (!this.isValidRingerMode(ringerMode)) {
            throw new IllegalArgumentException("Bad ringer mode " + ringerMode);
        }
    }

    @Override
    public boolean isValidRingerMode(int ringerMode) {
        return ringerMode >= 0 && ringerMode <= 2;
    }

    @Override
    public void setRingerModeExternal(int ringerMode, String caller) {
        if (this.isAndroidNPlus(caller) && this.wouldToggleZenMode(ringerMode) && !this.mNm.isNotificationPolicyAccessGrantedForPackage(caller)) {
            throw new SecurityException("Not allowed to change Do Not Disturb state");
        }
        this.setRingerMode(ringerMode, caller, true);
    }

    @Override
    public void setRingerModeInternal(int ringerMode, String caller) {
        this.enforceVolumeController("setRingerModeInternal");
        this.setRingerMode(ringerMode, caller, false);
    }

    public void silenceRingerModeInternal(String reason) {
        VibrationEffect effect = null;
        int ringerMode = 0;
        int toastText = 0;
        int silenceRingerSetting = 0;
        if (this.mContext.getResources().getBoolean(17957072)) {
            silenceRingerSetting = Settings.Secure.getIntForUser(this.mContentResolver, "volume_hush_gesture", 0, -2);
        }
        switch (silenceRingerSetting) {
            case 2: {
                effect = VibrationEffect.get(1);
                ringerMode = 0;
                toastText = 17041033;
                break;
            }
            case 1: {
                effect = VibrationEffect.get(5);
                ringerMode = 1;
                toastText = 17041034;
            }
        }
        this.maybeVibrate(effect);
        this.setRingerModeInternal(ringerMode, reason);
        Toast.makeText(this.mContext, toastText, 0).show();
    }

    private boolean maybeVibrate(VibrationEffect effect) {
        boolean hapticsDisabled;
        if (!this.mHasVibrator) {
            return false;
        }
        boolean bl = hapticsDisabled = Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_enabled", 0, -2) == 0;
        if (hapticsDisabled) {
            return false;
        }
        if (effect == null) {
            return false;
        }
        this.mVibrator.vibrate(Binder.getCallingUid(), this.mContext.getOpPackageName(), effect, VIBRATION_ATTRIBUTES);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRingerMode(int ringerMode, String caller, boolean external) {
        if (this.mUseFixedVolume || this.mIsSingleVolume) {
            return;
        }
        if (caller == null || caller.length() == 0) {
            throw new IllegalArgumentException("Bad caller: " + caller);
        }
        this.ensureValidRingerMode(ringerMode);
        if (ringerMode == 1 && !this.mHasVibrator) {
            ringerMode = 0;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Object object = this.mSettingsLock;
            synchronized (object) {
                int ringerModeInternal = this.getRingerModeInternal();
                int ringerModeExternal = this.getRingerModeExternal();
                if (external) {
                    this.setRingerModeExt(ringerMode);
                    if (this.mRingerModeDelegate != null) {
                        ringerMode = this.mRingerModeDelegate.onSetRingerModeExternal(ringerModeExternal, ringerMode, caller, ringerModeInternal, this.mVolumePolicy);
                    }
                    if (ringerMode != ringerModeInternal) {
                        this.setRingerModeInt(ringerMode, true);
                    }
                } else {
                    if (ringerMode != ringerModeInternal) {
                        this.setRingerModeInt(ringerMode, true);
                    }
                    if (this.mRingerModeDelegate != null) {
                        ringerMode = this.mRingerModeDelegate.onSetRingerModeInternal(ringerModeInternal, ringerMode, caller, ringerModeExternal, this.mVolumePolicy);
                    }
                    this.setRingerModeExt(ringerMode);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRingerModeExt(int ringerMode) {
        Object object = this.mSettingsLock;
        synchronized (object) {
            if (ringerMode == this.mRingerModeExternal) {
                return;
            }
            this.mRingerModeExternal = ringerMode;
        }
        this.broadcastRingerMode("android.media.RINGER_MODE_CHANGED", ringerMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @GuardedBy(value="mSettingsLock")
    private void muteRingerModeStreams() {
        int ringerMode;
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        if (this.mNm == null) {
            this.mNm = (NotificationManager)this.mContext.getSystemService("notification");
        }
        boolean ringerModeMute = (ringerMode = this.mRingerMode) == 1 || ringerMode == 0;
        boolean shouldRingSco = ringerMode == 1 && this.isBluetoothScoOn();
        String eventSource = "muteRingerModeStreams() from u/pid:" + Binder.getCallingUid() + "/" + Binder.getCallingPid();
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 7, shouldRingSco ? 3 : 0, eventSource, 0);
        int streamType = numStreamTypes - 1;
        while (streamType >= 0) {
            boolean shouldMute;
            boolean isMuted = this.isStreamMutedByRingerOrZenMode(streamType);
            boolean muteAllowedBySco = !shouldRingSco || streamType != 2;
            boolean shouldZenMute = this.shouldZenMuteStream(streamType);
            boolean bl = shouldMute = shouldZenMute || ringerModeMute && this.isStreamAffectedByRingerMode(streamType) && muteAllowedBySco;
            if (isMuted != shouldMute) {
                if (!shouldMute) {
                    if (mStreamVolumeAlias[streamType] == 2) {
                        Class<VolumeStreamState> clazz = VolumeStreamState.class;
                        // MONITORENTER : com.android.server.audio.AudioService$VolumeStreamState.class
                        VolumeStreamState vss = this.mStreamStates[streamType];
                        for (int i = 0; i < vss.mIndexMap.size(); ++i) {
                            int device = vss.mIndexMap.keyAt(i);
                            int value = vss.mIndexMap.valueAt(i);
                            if (value != 0) continue;
                            vss.setIndex(10, device, TAG);
                        }
                        int device = this.getDeviceForStream(streamType);
                        AudioService.sendMsg(this.mAudioHandler, 1, 2, device, 0, this.mStreamStates[streamType], 500);
                        // MONITOREXIT : clazz
                    }
                    this.mStreamStates[streamType].mute(false);
                    this.mRingerAndZenModeMutedStreams &= ~(1 << streamType);
                } else {
                    this.mStreamStates[streamType].mute(true);
                    this.mRingerAndZenModeMutedStreams |= 1 << streamType;
                }
            }
            --streamType;
        }
    }

    private boolean isAlarm(int streamType) {
        return streamType == 4;
    }

    private boolean isNotificationOrRinger(int streamType) {
        return streamType == 5 || streamType == 2;
    }

    private boolean isMedia(int streamType) {
        return streamType == 3;
    }

    private boolean isSystem(int streamType) {
        return streamType == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRingerModeInt(int ringerMode, boolean persist) {
        boolean change;
        Object object = this.mSettingsLock;
        synchronized (object) {
            change = this.mRingerMode != ringerMode;
            this.mRingerMode = ringerMode;
            this.muteRingerModeStreams();
        }
        if (persist) {
            AudioService.sendMsg(this.mAudioHandler, 3, 0, 0, 0, null, 500);
        }
        if (change) {
            this.broadcastRingerMode("android.media.INTERNAL_RINGER_MODE_CHANGED_ACTION", ringerMode);
        }
    }

    @Override
    public boolean shouldVibrate(int vibrateType) {
        if (!this.mHasVibrator) {
            return false;
        }
        switch (this.getVibrateSetting(vibrateType)) {
            case 1: {
                return this.getRingerModeExternal() != 0;
            }
            case 2: {
                return this.getRingerModeExternal() == 1;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int getVibrateSetting(int vibrateType) {
        if (!this.mHasVibrator) {
            return 0;
        }
        return this.mVibrateSetting >> vibrateType * 2 & 3;
    }

    @Override
    public void setVibrateSetting(int vibrateType, int vibrateSetting) {
        if (!this.mHasVibrator) {
            return;
        }
        this.mVibrateSetting = AudioSystem.getValueForVibrateSetting(this.mVibrateSetting, vibrateType, vibrateSetting);
        this.broadcastVibrateSetting(vibrateType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMode(int mode, IBinder cb, String callingPackage) {
        if (DEBUG_MODE) {
            Log.v(TAG, "setMode(mode=" + mode + ", callingPackage=" + callingPackage + ")");
        }
        if (!this.checkAudioSettingsPermission("setMode()")) {
            return;
        }
        if (mode == 2 && this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.w(TAG, "MODIFY_PHONE_STATE Permission Denial: setMode(MODE_IN_CALL) from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        if (mode < -1 || mode >= 4) {
            return;
        }
        int oldModeOwnerPid = 0;
        int newModeOwnerPid = 0;
        ArrayList<SetModeDeathHandler> arrayList = this.mSetModeDeathHandlers;
        synchronized (arrayList) {
            if (!this.mSetModeDeathHandlers.isEmpty()) {
                oldModeOwnerPid = this.mSetModeDeathHandlers.get(0).getPid();
            }
            if (mode == -1) {
                mode = this.mMode;
            }
            newModeOwnerPid = this.setModeInt(mode, cb, Binder.getCallingPid(), callingPackage);
        }
        if (newModeOwnerPid != oldModeOwnerPid && newModeOwnerPid != 0) {
            this.disconnectBluetoothSco(newModeOwnerPid);
        }
    }

    private int setModeInt(int mode, IBinder cb, int pid, String caller) {
        int actualMode;
        if (DEBUG_MODE) {
            Log.v(TAG, "setModeInt(mode=" + mode + ", pid=" + pid + ", caller=" + caller + ")");
        }
        int newModeOwnerPid = 0;
        if (cb == null) {
            Log.e(TAG, "setModeInt() called with null binder");
            return newModeOwnerPid;
        }
        SetModeDeathHandler hdlr = null;
        Iterator<SetModeDeathHandler> iter = this.mSetModeDeathHandlers.iterator();
        while (iter.hasNext()) {
            SetModeDeathHandler h = iter.next();
            if (h.getPid() != pid) continue;
            hdlr = h;
            iter.remove();
            hdlr.getBinder().unlinkToDeath(hdlr, 0);
            break;
        }
        int status = 0;
        do {
            actualMode = mode;
            if (mode == 0) {
                if (!this.mSetModeDeathHandlers.isEmpty()) {
                    hdlr = this.mSetModeDeathHandlers.get(0);
                    cb = hdlr.getBinder();
                    actualMode = hdlr.getMode();
                    if (DEBUG_MODE) {
                        Log.w(TAG, " using mode=" + mode + " instead due to death hdlr at pid=" + hdlr.mPid);
                    }
                }
            } else {
                if (hdlr == null) {
                    hdlr = new SetModeDeathHandler(cb, pid);
                }
                try {
                    cb.linkToDeath(hdlr, 0);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "setMode() could not link to " + cb + " binder death");
                }
                this.mSetModeDeathHandlers.add(0, hdlr);
                hdlr.setMode(mode);
            }
            if (actualMode != this.mMode) {
                long identity = Binder.clearCallingIdentity();
                status = AudioSystem.setPhoneState(actualMode);
                Binder.restoreCallingIdentity(identity);
                if (status == 0) {
                    if (DEBUG_MODE) {
                        Log.v(TAG, " mode successfully set to " + actualMode);
                    }
                    this.mMode = actualMode;
                    continue;
                }
                if (hdlr != null) {
                    this.mSetModeDeathHandlers.remove(hdlr);
                    cb.unlinkToDeath(hdlr, 0);
                }
                if (DEBUG_MODE) {
                    Log.w(TAG, " mode set to MODE_NORMAL after phoneState pb");
                }
                mode = 0;
                continue;
            }
            status = 0;
        } while (status != 0 && !this.mSetModeDeathHandlers.isEmpty());
        if (status == 0) {
            if (actualMode != 0) {
                if (this.mSetModeDeathHandlers.isEmpty()) {
                    Log.e(TAG, "setMode() different from MODE_NORMAL with empty mode client stack");
                } else {
                    newModeOwnerPid = this.mSetModeDeathHandlers.get(0).getPid();
                }
            }
            this.mModeLogger.log(new AudioServiceEvents.PhoneStateEvent(caller, pid, mode, newModeOwnerPid, actualMode));
            int streamType = this.getActiveStreamType(Integer.MIN_VALUE);
            int device = this.getDeviceForStream(streamType);
            int index = this.mStreamStates[mStreamVolumeAlias[streamType]].getIndex(device);
            this.setStreamVolumeInt(mStreamVolumeAlias[streamType], index, device, true, caller);
            this.updateStreamVolumeAlias(true, caller);
        }
        return newModeOwnerPid;
    }

    @Override
    public int getMode() {
        return this.mMode;
    }

    private void loadTouchSoundAssetDefaults() {
        SOUND_EFFECT_FILES.add("Effect_Tick.ogg");
        for (int i = 0; i < 10; ++i) {
            this.SOUND_EFFECT_FILES_MAP[i][0] = 0;
            this.SOUND_EFFECT_FILES_MAP[i][1] = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTouchSoundAssets() {
        block17: {
            XmlResourceParser parser = null;
            if (!SOUND_EFFECT_FILES.isEmpty()) {
                return;
            }
            this.loadTouchSoundAssetDefaults();
            try {
                String element;
                boolean inTouchSoundsGroup;
                block18: {
                    String name;
                    parser = this.mContext.getResources().getXml(0x1170001);
                    XmlUtils.beginDocument(parser, TAG_AUDIO_ASSETS);
                    String version = parser.getAttributeValue(null, ATTR_VERSION);
                    inTouchSoundsGroup = false;
                    if (!ASSET_FILE_VERSION.equals(version)) break block17;
                    do {
                        XmlUtils.nextElement(parser);
                        element = parser.getName();
                        if (element == null) break block18;
                    } while (!element.equals(TAG_GROUP) || !GROUP_TOUCH_SOUNDS.equals(name = parser.getAttributeValue(null, ATTR_GROUP_NAME)));
                    inTouchSoundsGroup = true;
                }
                while (inTouchSoundsGroup) {
                    XmlUtils.nextElement(parser);
                    element = parser.getName();
                    if (element == null) {
                        break;
                    }
                    if (!element.equals(TAG_ASSET)) break;
                    String id2 = parser.getAttributeValue(null, ATTR_ASSET_ID);
                    String file = parser.getAttributeValue(null, ATTR_ASSET_FILE);
                    try {
                        Field field = AudioManager.class.getField(id2);
                        int fx = field.getInt(null);
                    }
                    catch (Exception e) {
                        Log.w(TAG, "Invalid touch sound ID: " + id2);
                        continue;
                    }
                    int i = SOUND_EFFECT_FILES.indexOf(file);
                    if (i == -1) {
                        i = SOUND_EFFECT_FILES.size();
                        SOUND_EFFECT_FILES.add(file);
                    }
                    this.SOUND_EFFECT_FILES_MAP[fx][0] = i;
                }
            }
            catch (Resources.NotFoundException e) {
                Log.w(TAG, "audio assets file not found", e);
            }
            catch (XmlPullParserException e) {
                Log.w(TAG, "XML parser exception reading touch sound assets", e);
            }
            catch (IOException e) {
                Log.w(TAG, "I/O exception reading touch sound assets", e);
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
    }

    @Override
    public void playSoundEffect(int effectType) {
        this.playSoundEffectVolume(effectType, -1.0f);
    }

    @Override
    public void playSoundEffectVolume(int effectType, float volume) {
        if (this.isStreamMutedByRingerOrZenMode(1)) {
            return;
        }
        if (effectType >= 10 || effectType < 0) {
            Log.w(TAG, "AudioService effectType value " + effectType + " out of range");
            return;
        }
        AudioService.sendMsg(this.mAudioHandler, 5, 2, effectType, (int)(volume * 1000.0f), null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadSoundEffects() {
        LoadSoundEffectReply reply;
        int attempts = 3;
        LoadSoundEffectReply loadSoundEffectReply = reply = new LoadSoundEffectReply();
        synchronized (loadSoundEffectReply) {
            AudioService.sendMsg(this.mAudioHandler, 7, 2, 0, 0, reply, 0);
            while (reply.mStatus == 1 && attempts-- > 0) {
                try {
                    reply.wait(5000L);
                }
                catch (InterruptedException e) {
                    Log.w(TAG, "loadSoundEffects Interrupted while waiting sound pool loaded.");
                }
            }
        }
        return reply.mStatus == 0;
    }

    @Override
    public void unloadSoundEffects() {
        AudioService.sendMsg(this.mAudioHandler, 20, 2, 0, 0, null, 0);
    }

    @Override
    public void reloadAudioSettings() {
        this.readAudioSettings(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void readAudioSettings(boolean userSwitch) {
        this.readPersistedSettings();
        this.readUserRestrictions();
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            VolumeStreamState streamState = this.mStreamStates[streamType];
            if (userSwitch && mStreamVolumeAlias[streamType] == 3) continue;
            streamState.readSettings();
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            // MONITORENTER : com.android.server.audio.AudioService$VolumeStreamState.class
            if (streamState.mIsMuted && (!this.isStreamAffectedByMute(streamType) && !this.isStreamMutedByRingerOrZenMode(streamType) || this.mUseFixedVolume)) {
                streamState.mIsMuted = false;
            }
            // MONITOREXIT : clazz
        }
        this.setRingerModeInt(this.getRingerModeInternal(), false);
        this.checkAllFixedVolumeDevices();
        this.checkAllAliasStreamVolumes();
        this.checkMuteAffectedStreams();
        Integer n = this.mSafeMediaVolumeState;
        // MONITORENTER : n
        this.mMusicActiveMs = MathUtils.constrain(Settings.Secure.getIntForUser(this.mContentResolver, "unsafe_volume_music_active_ms", 0, -2), 0, 72000000);
        if (this.mSafeMediaVolumeState == 3) {
            this.enforceSafeMediaVolume(TAG);
        }
        // MONITOREXIT : n
    }

    @Override
    public void setSpeakerphoneOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setSpeakerphoneOn()")) {
            return;
        }
        String eventSource = "setSpeakerphoneOn(" + on + ") from u/pid:" + Binder.getCallingUid() + "/" + Binder.getCallingPid();
        if (on) {
            if (this.mForcedUseForComm == 3) {
                AudioService.sendMsg(this.mAudioHandler, 8, 2, 2, 0, eventSource, 0);
            }
            this.mForcedUseForComm = 1;
        } else if (this.mForcedUseForComm == 1) {
            this.mForcedUseForComm = 0;
        }
        this.mForcedUseForCommExt = this.mForcedUseForComm;
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 0, this.mForcedUseForComm, eventSource, 0);
    }

    @Override
    public boolean isSpeakerphoneOn() {
        return this.mForcedUseForCommExt == 1;
    }

    @Override
    public void setBluetoothScoOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setBluetoothScoOn()")) {
            return;
        }
        if (Binder.getCallingUid() >= 10000) {
            this.mForcedUseForCommExt = on ? 3 : 0;
            return;
        }
        String eventSource = "setBluetoothScoOn(" + on + ") from u/pid:" + Binder.getCallingUid() + "/" + Binder.getCallingPid();
        this.setBluetoothScoOnInt(on, eventSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBluetoothScoOnInt(boolean on, String eventSource) {
        block7: {
            Log.i(TAG, "setBluetoothScoOnInt: " + on + " " + eventSource);
            if (on) {
                ArrayList<ScoClient> arrayList = this.mScoClients;
                synchronized (arrayList) {
                    if (this.mBluetoothHeadset != null && this.mBluetoothHeadset.getAudioState(this.mBluetoothHeadsetDevice) != 12) {
                        this.mForcedUseForCommExt = 3;
                        Log.w(TAG, "setBluetoothScoOnInt(true) failed because " + this.mBluetoothHeadsetDevice + " is not in audio connected mode");
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 6] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.mForcedUseForComm = 3;
                    break block7;
                }
            }
            if (this.mForcedUseForComm == 3) {
                this.mForcedUseForComm = 0;
            }
        }
        this.mForcedUseForCommExt = this.mForcedUseForComm;
        AudioSystem.setParameters("BT_SCO=" + (on ? "on" : "off"));
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 0, this.mForcedUseForComm, eventSource, 0);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 2, this.mForcedUseForComm, eventSource, 0);
        this.setRingerModeInt(this.getRingerModeInternal(), false);
    }

    @Override
    public boolean isBluetoothScoOn() {
        return this.mForcedUseForCommExt == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBluetoothA2dpOn(boolean on) {
        String eventSource = "setBluetoothA2dpOn(" + on + ") from u/pid:" + Binder.getCallingUid() + "/" + Binder.getCallingPid();
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            if (this.mBluetoothA2dpEnabled == on) {
                return;
            }
            this.mBluetoothA2dpEnabled = on;
            AudioService.sendMsg(this.mAudioHandler, 13, 2, 1, this.mBluetoothA2dpEnabled ? 0 : 10, eventSource, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBluetoothA2dpOn() {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            return this.mBluetoothA2dpEnabled;
        }
    }

    @Override
    public void startBluetoothSco(IBinder cb, int targetSdkVersion) {
        int scoAudioMode = targetSdkVersion < 18 ? 0 : -1;
        this.startBluetoothScoInt(cb, scoAudioMode);
    }

    @Override
    public void startBluetoothScoVirtualCall(IBinder cb) {
        this.startBluetoothScoInt(cb, 0);
    }

    void startBluetoothScoInt(IBinder cb, int scoAudioMode) {
        if (!this.checkAudioSettingsPermission("startBluetoothSco()") || !this.mSystemReady) {
            return;
        }
        ScoClient client = this.getScoClient(cb, true);
        long ident = Binder.clearCallingIdentity();
        client.incCount(scoAudioMode);
        Binder.restoreCallingIdentity(ident);
    }

    @Override
    public void stopBluetoothSco(IBinder cb) {
        if (!this.checkAudioSettingsPermission("stopBluetoothSco()") || !this.mSystemReady) {
            return;
        }
        ScoClient client = this.getScoClient(cb, false);
        long ident = Binder.clearCallingIdentity();
        if (client != null) {
            client.decCount();
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkScoAudioState() {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            if (this.mBluetoothHeadset != null && this.mBluetoothHeadsetDevice != null && this.mScoAudioState == 0 && this.mBluetoothHeadset.getAudioState(this.mBluetoothHeadsetDevice) != 10) {
                this.mScoAudioState = 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScoClient getScoClient(IBinder cb, boolean create) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            for (ScoClient existingClient : this.mScoClients) {
                if (existingClient.getBinder() != cb) continue;
                return existingClient;
            }
            if (create) {
                ScoClient newClient = new ScoClient(cb);
                this.mScoClients.add(newClient);
                return newClient;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllScoClients(int exceptPid, boolean stopSco) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            ScoClient savedClient = null;
            for (ScoClient cl : this.mScoClients) {
                if (cl.getPid() != exceptPid) {
                    cl.clearCount(stopSco);
                    continue;
                }
                savedClient = cl;
            }
            this.mScoClients.clear();
            if (savedClient != null) {
                this.mScoClients.add(savedClient);
            }
        }
    }

    private boolean getBluetoothHeadset() {
        boolean result = false;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            result = adapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 1);
        }
        AudioService.sendMsg(this.mAudioHandler, 9, 0, 0, 0, null, result ? 3000 : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectBluetoothSco(int exceptPid) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            this.checkScoAudioState();
            if (this.mScoAudioState == 2) {
                return;
            }
            this.clearAllScoClients(exceptPid, true);
        }
    }

    private static boolean disconnectBluetoothScoAudioHelper(BluetoothHeadset bluetoothHeadset, BluetoothDevice device, int scoAudioMode) {
        switch (scoAudioMode) {
            case 1: {
                return bluetoothHeadset.disconnectAudio();
            }
            case 0: {
                return bluetoothHeadset.stopScoUsingVirtualVoiceCall();
            }
            case 2: {
                return bluetoothHeadset.stopVoiceRecognition(device);
            }
        }
        return false;
    }

    private static boolean connectBluetoothScoAudioHelper(BluetoothHeadset bluetoothHeadset, BluetoothDevice device, int scoAudioMode) {
        switch (scoAudioMode) {
            case 1: {
                return bluetoothHeadset.connectAudio();
            }
            case 0: {
                return bluetoothHeadset.startScoUsingVirtualVoiceCall();
            }
            case 2: {
                return bluetoothHeadset.startVoiceRecognition(device);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetBluetoothSco() {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            this.clearAllScoClients(0, false);
            this.mScoAudioState = 0;
            this.broadcastScoConnectionState(0);
        }
        AudioSystem.setParameters("A2dpSuspended=false");
        this.setBluetoothScoOnInt(false, "resetBluetoothSco");
    }

    private void broadcastScoConnectionState(int state) {
        AudioService.sendMsg(this.mAudioHandler, 19, 2, state, 0, null, 0);
    }

    private void onBroadcastScoConnectionState(int state) {
        if (state != this.mScoConnectionState) {
            Intent newIntent = new Intent("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", state);
            newIntent.putExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", this.mScoConnectionState);
            this.sendStickyBroadcastToAll(newIntent);
            this.mScoConnectionState = state;
        }
    }

    private boolean handleBtScoActiveDeviceChange(BluetoothDevice btDevice, boolean isActive) {
        if (btDevice == null) {
            return true;
        }
        String address = btDevice.getAddress();
        BluetoothClass btClass = btDevice.getBluetoothClass();
        int inDevice = -2147483640;
        int[] outDeviceTypes = new int[]{16, 32, 64};
        if (btClass != null) {
            switch (btClass.getDeviceClass()) {
                case 1028: 
                case 1032: {
                    outDeviceTypes = new int[]{32};
                    break;
                }
                case 1056: {
                    outDeviceTypes = new int[]{64};
                }
            }
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        String btDeviceName = btDevice.getName();
        boolean result = false;
        if (isActive) {
            result |= this.handleDeviceConnection(isActive, outDeviceTypes[0], address, btDeviceName);
        } else {
            for (int outDeviceType : outDeviceTypes) {
                result |= this.handleDeviceConnection(isActive, outDeviceType, address, btDeviceName);
            }
        }
        result = this.handleDeviceConnection(isActive, inDevice, address, btDeviceName) && result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBtScoActiveDevice(BluetoothDevice btDevice) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            Log.i(TAG, "setBtScoActiveDevice: " + this.mBluetoothHeadsetDevice + " -> " + btDevice);
            BluetoothDevice previousActiveDevice = this.mBluetoothHeadsetDevice;
            if (!Objects.equals(btDevice, previousActiveDevice)) {
                if (!this.handleBtScoActiveDeviceChange(previousActiveDevice, false)) {
                    Log.w(TAG, "setBtScoActiveDevice() failed to remove previous device " + previousActiveDevice);
                }
                if (!this.handleBtScoActiveDeviceChange(btDevice, true)) {
                    Log.e(TAG, "setBtScoActiveDevice() failed to add new device " + btDevice);
                    btDevice = null;
                }
                this.mBluetoothHeadsetDevice = btDevice;
                if (this.mBluetoothHeadsetDevice == null) {
                    this.resetBluetoothSco();
                }
            }
        }
    }

    void disconnectAllBluetoothProfiles() {
        this.disconnectA2dp();
        this.disconnectA2dpSink();
        this.disconnectHeadset();
        this.disconnectHearingAid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectA2dp() {
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            Object object = this.mA2dpAvrcpLock;
            synchronized (object) {
                ArraySet toRemove = null;
                for (int i = 0; i < this.mConnectedDevices.size(); ++i) {
                    DeviceListSpec deviceSpec = this.mConnectedDevices.valueAt(i);
                    if (deviceSpec.mDeviceType != 128) continue;
                    toRemove = toRemove != null ? toRemove : new ArraySet();
                    toRemove.add(deviceSpec.mDeviceAddress);
                }
                if (toRemove != null) {
                    int delay = this.checkSendBecomingNoisyIntent(128, 0, 0);
                    for (int i = 0; i < toRemove.size(); ++i) {
                        this.makeA2dpDeviceUnavailableLater((String)toRemove.valueAt(i), delay);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectA2dpSink() {
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            int i;
            ArraySet toRemove = null;
            for (i = 0; i < this.mConnectedDevices.size(); ++i) {
                DeviceListSpec deviceSpec = this.mConnectedDevices.valueAt(i);
                if (deviceSpec.mDeviceType != -2147352576) continue;
                toRemove = toRemove != null ? toRemove : new ArraySet();
                toRemove.add(deviceSpec.mDeviceAddress);
            }
            if (toRemove != null) {
                for (i = 0; i < toRemove.size(); ++i) {
                    this.makeA2dpSrcUnavailable((String)toRemove.valueAt(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectHeadset() {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            this.setBtScoActiveDevice(null);
            this.mBluetoothHeadset = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectHearingAid() {
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            Object object = this.mHearingAidLock;
            synchronized (object) {
                ArraySet toRemove = null;
                for (int i = 0; i < this.mConnectedDevices.size(); ++i) {
                    DeviceListSpec deviceSpec = this.mConnectedDevices.valueAt(i);
                    if (deviceSpec.mDeviceType != 0x8000000) continue;
                    toRemove = toRemove != null ? toRemove : new ArraySet();
                    toRemove.add(deviceSpec.mDeviceAddress);
                }
                if (toRemove != null) {
                    int delay = this.checkSendBecomingNoisyIntent(0x8000000, 0, 0);
                    for (int i = 0; i < toRemove.size(); ++i) {
                        this.makeHearingAidDeviceUnavailable((String)toRemove.valueAt(i));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCheckMusicActive(String caller) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            int device;
            if (this.mSafeMediaVolumeState == 2 && ((device = this.getDeviceForStream(3)) & 0x400000C) != 0) {
                AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, caller, 60000);
                int index = this.mStreamStates[3].getIndex(device);
                if (AudioSystem.isStreamActive(3, 0) && index > this.safeMediaVolumeIndex(device)) {
                    this.mMusicActiveMs += 60000;
                    if (this.mMusicActiveMs > 72000000) {
                        this.setSafeMediaVolumeEnabled(true, caller);
                        this.mMusicActiveMs = 0;
                    }
                    this.saveMusicActiveMs();
                }
            }
        }
    }

    private void saveMusicActiveMs() {
        this.mAudioHandler.obtainMessage(22, this.mMusicActiveMs, 0).sendToTarget();
    }

    private int getSafeUsbMediaVolumeIndex() {
        int index;
        float gainDB;
        int min = MIN_STREAM_VOLUME[3];
        int max = MAX_STREAM_VOLUME[3];
        this.mSafeUsbMediaVolumeDbfs = (float)this.mContext.getResources().getInteger(17694853) / 100.0f;
        while (Math.abs(max - min) > 1 && !Float.isNaN(gainDB = AudioSystem.getStreamVolumeDB(3, index = (max + min) / 2, 0x4000000))) {
            if (gainDB == this.mSafeUsbMediaVolumeDbfs) {
                min = index;
                break;
            }
            if (gainDB < this.mSafeUsbMediaVolumeDbfs) {
                min = index;
                continue;
            }
            max = index;
        }
        return min * 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConfigureSafeVolume(boolean force, String caller) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            int mcc = this.mContext.getResources().getConfiguration().mcc;
            if (this.mMcc != mcc || this.mMcc == 0 && force) {
                int persistedState;
                this.mSafeMediaVolumeIndex = this.mContext.getResources().getInteger(17694852) * 10;
                this.mSafeUsbMediaVolumeIndex = this.getSafeUsbMediaVolumeIndex();
                boolean safeMediaVolumeEnabled = SystemProperties.getBoolean("audio.safemedia.force", false) || this.mContext.getResources().getBoolean(17957014);
                boolean safeMediaVolumeBypass = SystemProperties.getBoolean("audio.safemedia.bypass", false);
                if (safeMediaVolumeEnabled && !safeMediaVolumeBypass) {
                    persistedState = 3;
                    if (this.mSafeMediaVolumeState != 2) {
                        if (this.mMusicActiveMs == 0) {
                            this.mSafeMediaVolumeState = 3;
                            this.enforceSafeMediaVolume(caller);
                        } else {
                            this.mSafeMediaVolumeState = 2;
                        }
                    }
                } else {
                    persistedState = 1;
                    this.mSafeMediaVolumeState = 1;
                }
                this.mMcc = mcc;
                AudioService.sendMsg(this.mAudioHandler, 18, 2, persistedState, 0, null, 0);
            }
        }
    }

    private int checkForRingerModeChange(int oldIndex, int direction, int step, boolean isMuted, String caller, int flags) {
        int result = 1;
        if (this.isPlatformTelevision() || this.mIsSingleVolume) {
            return result;
        }
        int ringerMode = this.getRingerModeInternal();
        switch (ringerMode) {
            case 2: {
                if (direction == -1) {
                    if (this.mHasVibrator) {
                        if (step > oldIndex || oldIndex >= 2 * step) break;
                        ringerMode = 1;
                        this.mLoweredFromNormalToVibrateTime = SystemClock.uptimeMillis();
                        break;
                    }
                    if (oldIndex != step || !this.mVolumePolicy.volumeDownToEnterSilent) break;
                    ringerMode = 0;
                    break;
                }
                if (!this.mIsSingleVolume || direction != 101 && direction != -100) break;
                ringerMode = this.mHasVibrator ? 1 : 0;
                result &= 0xFFFFFFFE;
                break;
            }
            case 1: {
                if (!this.mHasVibrator) {
                    Log.e(TAG, "checkForRingerModeChange() current ringer mode is vibratebut no vibrator is present");
                    break;
                }
                if (direction == -1) {
                    if (this.mIsSingleVolume && oldIndex >= 2 * step && isMuted) {
                        ringerMode = 2;
                    } else if (this.mPrevVolDirection != -1) {
                        if (this.mVolumePolicy.volumeDownToEnterSilent) {
                            long diff = SystemClock.uptimeMillis() - this.mLoweredFromNormalToVibrateTime;
                            if (diff > (long)this.mVolumePolicy.vibrateToSilentDebounce && this.mRingerModeDelegate.canVolumeDownEnterSilent()) {
                                ringerMode = 0;
                            }
                        } else {
                            result |= 0x800;
                        }
                    }
                } else if (direction == 1 || direction == 101 || direction == 100) {
                    ringerMode = 2;
                }
                result &= 0xFFFFFFFE;
                break;
            }
            case 0: {
                if (this.mIsSingleVolume && direction == -1 && oldIndex >= 2 * step && isMuted) {
                    ringerMode = 2;
                } else if (direction == 1 || direction == 101 || direction == 100) {
                    if (!this.mVolumePolicy.volumeUpToExitSilent) {
                        result |= 0x80;
                    } else {
                        ringerMode = this.mHasVibrator && direction == 1 ? 1 : 2;
                    }
                }
                result &= 0xFFFFFFFE;
                break;
            }
            default: {
                Log.e(TAG, "checkForRingerModeChange() wrong ringer mode: " + ringerMode);
            }
        }
        if (this.isAndroidNPlus(caller) && this.wouldToggleZenMode(ringerMode) && !this.mNm.isNotificationPolicyAccessGrantedForPackage(caller) && (flags & 0x1000) == 0) {
            throw new SecurityException("Not allowed to change Do Not Disturb state");
        }
        this.setRingerMode(ringerMode, "AudioService.checkForRingerModeChange", false);
        this.mPrevVolDirection = direction;
        return result;
    }

    @Override
    public boolean isStreamAffectedByRingerMode(int streamType) {
        return (this.mRingerModeAffectedStreams & 1 << streamType) != 0;
    }

    private boolean shouldZenMuteStream(int streamType) {
        if (this.mNm.getZenMode() != 1) {
            return false;
        }
        NotificationManager.Policy zenPolicy = this.mNm.getNotificationPolicy();
        boolean muteAlarms = (zenPolicy.priorityCategories & 0x20) == 0;
        boolean muteMedia = (zenPolicy.priorityCategories & 0x40) == 0;
        boolean muteSystem = (zenPolicy.priorityCategories & 0x80) == 0;
        boolean muteNotificationAndRing = ZenModeConfig.areAllPriorityOnlyNotificationZenSoundsMuted(this.mNm.getNotificationPolicy());
        return muteAlarms && this.isAlarm(streamType) || muteMedia && this.isMedia(streamType) || muteSystem && this.isSystem(streamType) || muteNotificationAndRing && this.isNotificationOrRinger(streamType);
    }

    private boolean isStreamMutedByRingerOrZenMode(int streamType) {
        return (this.mRingerAndZenModeMutedStreams & 1 << streamType) != 0;
    }

    private boolean updateZenModeAffectedStreams() {
        int zenModeAffectedStreams = 0;
        if (this.mSystemReady && this.mNm.getZenMode() == 1) {
            NotificationManager.Policy zenPolicy = this.mNm.getNotificationPolicy();
            if ((zenPolicy.priorityCategories & 0x20) == 0) {
                zenModeAffectedStreams |= 0x10;
            }
            if ((zenPolicy.priorityCategories & 0x40) == 0) {
                zenModeAffectedStreams |= 8;
            }
            if ((zenPolicy.priorityCategories & 0x80) == 0) {
                zenModeAffectedStreams |= 2;
            }
        }
        if (this.mZenModeAffectedStreams != zenModeAffectedStreams) {
            this.mZenModeAffectedStreams = zenModeAffectedStreams;
            return true;
        }
        return false;
    }

    @GuardedBy(value="mSettingsLock")
    private boolean updateRingerAndZenModeAffectedStreams() {
        boolean updatedZenModeAffectedStreams = this.updateZenModeAffectedStreams();
        int ringerModeAffectedStreams = Settings.System.getIntForUser(this.mContentResolver, "mode_ringer_streams_affected", 166, -2);
        if (this.mIsSingleVolume) {
            ringerModeAffectedStreams = 0;
        } else if (this.mRingerModeDelegate != null) {
            ringerModeAffectedStreams = this.mRingerModeDelegate.getRingerModeAffectedStreams(ringerModeAffectedStreams);
        }
        ringerModeAffectedStreams = this.mCameraSoundForced ? (ringerModeAffectedStreams &= 0xFFFFFF7F) : (ringerModeAffectedStreams |= 0x80);
        ringerModeAffectedStreams = mStreamVolumeAlias[8] == 2 ? (ringerModeAffectedStreams |= 0x100) : (ringerModeAffectedStreams &= 0xFFFFFEFF);
        if (ringerModeAffectedStreams != this.mRingerModeAffectedStreams) {
            Settings.System.putIntForUser(this.mContentResolver, "mode_ringer_streams_affected", ringerModeAffectedStreams, -2);
            this.mRingerModeAffectedStreams = ringerModeAffectedStreams;
            return true;
        }
        return updatedZenModeAffectedStreams;
    }

    @Override
    public boolean isStreamAffectedByMute(int streamType) {
        return (this.mMuteAffectedStreams & 1 << streamType) != 0;
    }

    private void ensureValidDirection(int direction) {
        switch (direction) {
            case -100: 
            case -1: 
            case 0: 
            case 1: 
            case 100: 
            case 101: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction " + direction);
            }
        }
    }

    private void ensureValidStreamType(int streamType) {
        if (streamType < 0 || streamType >= this.mStreamStates.length) {
            throw new IllegalArgumentException("Bad stream type " + streamType);
        }
    }

    private boolean isMuteAdjust(int adjust) {
        return adjust == -100 || adjust == 100 || adjust == 101;
    }

    private boolean isInCommunication() {
        boolean IsInCall = false;
        TelecomManager telecomManager = (TelecomManager)this.mContext.getSystemService("telecom");
        long ident = Binder.clearCallingIdentity();
        IsInCall = telecomManager.isInCall();
        Binder.restoreCallingIdentity(ident);
        return IsInCall || this.getMode() == 3 || this.getMode() == 2;
    }

    private boolean wasStreamActiveRecently(int stream, int delay_ms) {
        return AudioSystem.isStreamActive(stream, delay_ms) || AudioSystem.isStreamActiveRemotely(stream, delay_ms);
    }

    private int getActiveStreamType(int suggestedStreamType) {
        if (this.mIsSingleVolume && suggestedStreamType == Integer.MIN_VALUE) {
            return 3;
        }
        switch (this.mPlatformType) {
            case 1: {
                if (this.isInCommunication()) {
                    if (AudioSystem.getForceUse(0) == 3) {
                        return 6;
                    }
                    return 0;
                }
                if (suggestedStreamType == Integer.MIN_VALUE) {
                    if (this.wasStreamActiveRecently(2, sStreamOverrideDelayMs)) {
                        if (DEBUG_VOL) {
                            Log.v(TAG, "getActiveStreamType: Forcing STREAM_RING stream active");
                        }
                        return 2;
                    }
                    if (this.wasStreamActiveRecently(5, sStreamOverrideDelayMs)) {
                        if (DEBUG_VOL) {
                            Log.v(TAG, "getActiveStreamType: Forcing STREAM_NOTIFICATION stream active");
                        }
                        return 5;
                    }
                    if (DEBUG_VOL) {
                        Log.v(TAG, "getActiveStreamType: Forcing DEFAULT_VOL_STREAM_NO_PLAYBACK(3) b/c default");
                    }
                    return 3;
                }
                if (this.wasStreamActiveRecently(5, sStreamOverrideDelayMs)) {
                    if (DEBUG_VOL) {
                        Log.v(TAG, "getActiveStreamType: Forcing STREAM_NOTIFICATION stream active");
                    }
                    return 5;
                }
                if (!this.wasStreamActiveRecently(2, sStreamOverrideDelayMs)) break;
                if (DEBUG_VOL) {
                    Log.v(TAG, "getActiveStreamType: Forcing STREAM_RING stream active");
                }
                return 2;
            }
        }
        if (this.isInCommunication()) {
            if (AudioSystem.getForceUse(0) == 3) {
                if (DEBUG_VOL) {
                    Log.v(TAG, "getActiveStreamType: Forcing STREAM_BLUETOOTH_SCO");
                }
                return 6;
            }
            if (DEBUG_VOL) {
                Log.v(TAG, "getActiveStreamType: Forcing STREAM_VOICE_CALL");
            }
            return 0;
        }
        if (AudioSystem.isStreamActive(5, sStreamOverrideDelayMs)) {
            if (DEBUG_VOL) {
                Log.v(TAG, "getActiveStreamType: Forcing STREAM_NOTIFICATION");
            }
            return 5;
        }
        if (AudioSystem.isStreamActive(2, sStreamOverrideDelayMs)) {
            if (DEBUG_VOL) {
                Log.v(TAG, "getActiveStreamType: Forcing STREAM_RING");
            }
            return 2;
        }
        if (suggestedStreamType == Integer.MIN_VALUE) {
            if (AudioSystem.isStreamActive(5, sStreamOverrideDelayMs)) {
                if (DEBUG_VOL) {
                    Log.v(TAG, "getActiveStreamType: Forcing STREAM_NOTIFICATION");
                }
                return 5;
            }
            if (AudioSystem.isStreamActive(2, sStreamOverrideDelayMs)) {
                if (DEBUG_VOL) {
                    Log.v(TAG, "getActiveStreamType: Forcing STREAM_RING");
                }
                return 2;
            }
            if (DEBUG_VOL) {
                Log.v(TAG, "getActiveStreamType: Forcing DEFAULT_VOL_STREAM_NO_PLAYBACK(3) b/c default");
            }
            return 3;
        }
        if (DEBUG_VOL) {
            Log.v(TAG, "getActiveStreamType: Returning suggested type " + suggestedStreamType);
        }
        return suggestedStreamType;
    }

    private void broadcastRingerMode(String action, int ringerMode) {
        Intent broadcast = new Intent(action);
        broadcast.putExtra("android.media.EXTRA_RINGER_MODE", ringerMode);
        broadcast.addFlags(0x24000000);
        this.sendStickyBroadcastToAll(broadcast);
    }

    private void broadcastVibrateSetting(int vibrateType) {
        if (this.mActivityManagerInternal.isSystemReady()) {
            Intent broadcast = new Intent("android.media.VIBRATE_SETTING_CHANGED");
            broadcast.putExtra("android.media.EXTRA_VIBRATE_TYPE", vibrateType);
            broadcast.putExtra("android.media.EXTRA_VIBRATE_SETTING", this.getVibrateSetting(vibrateType));
            this.sendBroadcastToAll(broadcast);
        }
    }

    private void queueMsgUnderWakeLock(Handler handler, int msg, int arg1, int arg2, Object obj, int delay) {
        long ident = Binder.clearCallingIdentity();
        this.mAudioEventWakeLock.acquire();
        Binder.restoreCallingIdentity(ident);
        AudioService.sendMsg(handler, msg, 2, arg1, arg2, obj, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendMsg(Handler handler, int msg, int existingMsgPolicy, int arg1, int arg2, Object obj, int delay) {
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        Long l = mLastDeviceConnectMsgTime;
        synchronized (l) {
            long time = SystemClock.uptimeMillis() + (long)delay;
            if (msg == 101 || msg == 102 || msg == 105 || msg == 100 || msg == 103 || msg == 106) {
                if (mLastDeviceConnectMsgTime >= time) {
                    time = mLastDeviceConnectMsgTime + 30L;
                }
                mLastDeviceConnectMsgTime = time;
            }
            handler.sendMessageAtTime(handler.obtainMessage(msg, arg1, arg2, obj), time);
        }
    }

    boolean checkAudioSettingsPermission(String method) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0) {
            return true;
        }
        String msg = "Audio Settings Permission Denial: " + method + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid();
        Log.w(TAG, msg);
        return false;
    }

    private int getDeviceForStream(int stream) {
        int device = this.getDevicesForStream(stream);
        if ((device & device - 1) != 0) {
            device = (device & 2) != 0 ? 2 : ((device & 0x40000) != 0 ? 262144 : ((device & 0x80000) != 0 ? 524288 : ((device & 0x200000) != 0 ? 0x200000 : (device &= 0x380))));
        }
        return device;
    }

    private int getDevicesForStream(int stream) {
        return this.getDevicesForStream(stream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDevicesForStream(int stream, boolean checkOthers) {
        this.ensureValidStreamType(stream);
        Class<VolumeStreamState> clazz = VolumeStreamState.class;
        synchronized (VolumeStreamState.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.mStreamStates[stream].observeDevicesForStream_syncVSS(checkOthers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void observeDevicesForStreams(int skipStream) {
        Class<VolumeStreamState> clazz = VolumeStreamState.class;
        synchronized (VolumeStreamState.class) {
            for (int stream = 0; stream < this.mStreamStates.length; ++stream) {
                if (stream == skipStream) continue;
                this.mStreamStates[stream].observeDevicesForStream_syncVSS(false);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWiredDeviceConnectionState(int type, int state, String address, String name, String caller) {
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            if (DEBUG_DEVICES) {
                Slog.i(TAG, "setWiredDeviceConnectionState(" + state + " nm: " + name + " addr:" + address + ")");
            }
            int delay = this.checkSendBecomingNoisyIntent(type, state, 0);
            this.queueMsgUnderWakeLock(this.mAudioHandler, 100, 0, 0, new WiredDeviceConnectionState(type, state, address, name, caller), delay);
        }
    }

    @Override
    public void setHearingAidDeviceConnectionState(BluetoothDevice device, int state) {
        Log.i(TAG, "setBluetoothHearingAidDeviceConnectionState");
        this.setBluetoothHearingAidDeviceConnectionState(device, state, false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBluetoothHearingAidDeviceConnectionState(BluetoothDevice device, int state, boolean suppressNoisyIntent, int musicDevice) {
        int delay;
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            if (!suppressNoisyIntent) {
                int intState = state == 2 ? 1 : 0;
                delay = this.checkSendBecomingNoisyIntent(0x8000000, intState, musicDevice);
            } else {
                delay = 0;
            }
            this.queueMsgUnderWakeLock(this.mAudioHandler, 105, state, 0, device, delay);
        }
        return delay;
    }

    @Override
    public int setBluetoothA2dpDeviceConnectionState(BluetoothDevice device, int state, int profile) {
        return this.setBluetoothA2dpDeviceConnectionStateSuppressNoisyIntent(device, state, profile, false, -1);
    }

    @Override
    public int setBluetoothA2dpDeviceConnectionStateSuppressNoisyIntent(BluetoothDevice device, int state, int profile, boolean suppressNoisyIntent, int a2dpVolume) {
        this.mDeviceLogger.log(new AudioEventLogger.StringEvent("setBluetoothA2dpDeviceConnectionStateSuppressNoisyIntent state=" + state + " addr=" + device.getAddress() + " prof=" + profile + " supprNoisy=" + suppressNoisyIntent + " vol=" + a2dpVolume));
        if (this.mAudioHandler.hasMessages(102, device)) {
            this.mDeviceLogger.log(new AudioEventLogger.StringEvent("A2DP connection state ignored"));
            return 0;
        }
        return this.setBluetoothA2dpDeviceConnectionStateInt(device, state, profile, suppressNoisyIntent, 0, a2dpVolume);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBluetoothA2dpDeviceConnectionStateInt(BluetoothDevice device, int state, int profile, boolean suppressNoisyIntent, int musicDevice, int a2dpVolume) {
        int delay;
        if (profile != 2 && profile != 11) {
            throw new IllegalArgumentException("invalid profile " + profile);
        }
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            if (profile == 2 && !suppressNoisyIntent) {
                int intState = state == 2 ? 1 : 0;
                delay = this.checkSendBecomingNoisyIntent(128, intState, musicDevice);
            } else {
                delay = 0;
            }
            if (DEBUG_DEVICES) {
                Log.d(TAG, "setBluetoothA2dpDeviceConnectionStateInt device: " + device + " state: " + state + " delay(ms): " + delay + " suppressNoisyIntent: " + suppressNoisyIntent);
            }
            this.queueMsgUnderWakeLock(this.mAudioHandler, profile == 2 ? 102 : 101, state, a2dpVolume, device, delay);
        }
        return delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBluetoothA2dpDeviceConfigChange(BluetoothDevice device) {
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            this.queueMsgUnderWakeLock(this.mAudioHandler, 103, 0, 0, device, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAccessoryPlugMediaUnmute(int newDevice) {
        if (DEBUG_VOL) {
            Log.i(TAG, String.format("onAccessoryPlugMediaUnmute newDevice=%d [%s]", newDevice, AudioSystem.getOutputDeviceName(newDevice)));
        }
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            if (this.mNm.getZenMode() != 2 && (newDevice & 0x402678C) != 0 && this.mStreamStates[3].mIsMuted && this.mStreamStates[3].getIndex(newDevice) != 0 && (newDevice & AudioSystem.getDevicesForStream(3)) != 0) {
                if (DEBUG_VOL) {
                    Log.i(TAG, String.format(" onAccessoryPlugMediaUnmute unmuting device=%d [%s]", newDevice, AudioSystem.getOutputDeviceName(newDevice)));
                }
                this.mStreamStates[3].mute(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDeviceVolume(VolumeStreamState streamState, int device) {
        Class<VolumeStreamState> clazz = VolumeStreamState.class;
        synchronized (VolumeStreamState.class) {
            streamState.applyDeviceVolume_syncVSS(device);
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (streamType == streamState.mStreamType || mStreamVolumeAlias[streamType] != streamState.mStreamType) continue;
                int streamDevice = this.getDeviceForStream(streamType);
                if (device != streamDevice && this.mAvrcpAbsVolSupported && (device & 0x380) != 0) {
                    this.mStreamStates[streamType].applyDeviceVolume_syncVSS(device);
                }
                this.mStreamStates[streamType].applyDeviceVolume_syncVSS(streamDevice);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            AudioService.sendMsg(this.mAudioHandler, 1, 2, device, 0, streamState, 500);
            return;
        }
    }

    private void makeA2dpDeviceAvailable(String address, String name, String eventSource) {
        VolumeStreamState streamState = this.mStreamStates[3];
        this.setBluetoothA2dpOnInt(true, eventSource);
        AudioSystem.setDeviceConnectionState(128, 1, address, name);
        AudioSystem.setParameters("A2dpSuspended=false");
        this.mConnectedDevices.put(this.makeDeviceListKey(128, address), new DeviceListSpec(128, name, address));
        AudioService.sendMsg(this.mAudioHandler, 27, 2, 128, 0, null, 0);
    }

    private void onSendBecomingNoisyIntent() {
        this.sendBroadcastToAll(new Intent("android.media.AUDIO_BECOMING_NOISY"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeA2dpDeviceUnavailableNow(String address) {
        if (address == null) {
            return;
        }
        Object object = this.mA2dpAvrcpLock;
        synchronized (object) {
            this.mAvrcpAbsVolSupported = false;
        }
        AudioSystem.setDeviceConnectionState(128, 0, address, "");
        this.mConnectedDevices.remove(this.makeDeviceListKey(128, address));
        this.setCurrentAudioRouteName(null);
        if (this.mDockAddress == address) {
            this.mDockAddress = null;
        }
    }

    private void makeA2dpDeviceUnavailableLater(String address, int delayMs) {
        AudioSystem.setParameters("A2dpSuspended=true");
        this.mConnectedDevices.remove(this.makeDeviceListKey(128, address));
        this.queueMsgUnderWakeLock(this.mAudioHandler, 106, 0, 0, address, delayMs);
    }

    private void makeA2dpSrcAvailable(String address) {
        AudioSystem.setDeviceConnectionState(-2147352576, 1, address, "");
        this.mConnectedDevices.put(this.makeDeviceListKey(-2147352576, address), new DeviceListSpec(-2147352576, "", address));
    }

    private void makeA2dpSrcUnavailable(String address) {
        AudioSystem.setDeviceConnectionState(-2147352576, 0, address, "");
        this.mConnectedDevices.remove(this.makeDeviceListKey(-2147352576, address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHearingAidVolume(int index, int streamType) {
        Object object = this.mHearingAidLock;
        synchronized (object) {
            if (this.mHearingAid != null) {
                int gainDB = (int)AudioSystem.getStreamVolumeDB(streamType, index / 10, 0x8000000);
                if (gainDB < -128) {
                    gainDB = -128;
                }
                this.mHearingAid.setVolume(gainDB);
            }
        }
    }

    private void makeHearingAidDeviceAvailable(String address, String name, String eventSource) {
        int index = this.mStreamStates[3].getIndex(0x8000000);
        this.setHearingAidVolume(index, 3);
        AudioSystem.setDeviceConnectionState(0x8000000, 1, address, name);
        this.mConnectedDevices.put(this.makeDeviceListKey(0x8000000, address), new DeviceListSpec(0x8000000, name, address));
        AudioService.sendMsg(this.mAudioHandler, 27, 2, 0x8000000, 0, null, 0);
    }

    private void makeHearingAidDeviceUnavailable(String address) {
        AudioSystem.setDeviceConnectionState(0x8000000, 0, address, "");
        this.mConnectedDevices.remove(this.makeDeviceListKey(0x8000000, address));
        this.setCurrentAudioRouteName(null);
    }

    private void cancelA2dpDeviceTimeout() {
        this.mAudioHandler.removeMessages(106);
    }

    private boolean hasScheduledA2dpDockTimeout() {
        return this.mAudioHandler.hasMessages(106);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetA2dpSinkConnectionState(BluetoothDevice btDevice, int state, int a2dpVolume) {
        if (DEBUG_DEVICES) {
            Log.d(TAG, "onSetA2dpSinkConnectionState btDevice= " + btDevice + " state= " + state + " is dock: " + btDevice.isBluetoothDock());
        }
        if (btDevice == null) {
            return;
        }
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            boolean isConnected;
            String key = this.makeDeviceListKey(128, btDevice.getAddress());
            DeviceListSpec deviceSpec = this.mConnectedDevices.get(key);
            boolean bl = isConnected = deviceSpec != null;
            if (isConnected && state != 2) {
                if (btDevice.isBluetoothDock()) {
                    if (state == 0) {
                        this.makeA2dpDeviceUnavailableLater(address, 8000);
                    }
                } else {
                    this.makeA2dpDeviceUnavailableNow(address);
                }
                this.setCurrentAudioRouteName(null);
            } else if (!isConnected && state == 2) {
                if (btDevice.isBluetoothDock()) {
                    this.cancelA2dpDeviceTimeout();
                    this.mDockAddress = address;
                } else if (this.hasScheduledA2dpDockTimeout() && this.mDockAddress != null) {
                    this.cancelA2dpDeviceTimeout();
                    this.makeA2dpDeviceUnavailableNow(this.mDockAddress);
                }
                if (a2dpVolume != -1) {
                    VolumeStreamState streamState = this.mStreamStates[3];
                    streamState.setIndex(a2dpVolume *= 10, 128, "onSetA2dpSinkConnectionState");
                    this.setDeviceVolume(streamState, 128);
                }
                this.makeA2dpDeviceAvailable(address, btDevice.getName(), "onSetA2dpSinkConnectionState");
                this.setCurrentAudioRouteName(btDevice.getAliasName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetA2dpSourceConnectionState(BluetoothDevice btDevice, int state) {
        if (DEBUG_VOL) {
            Log.d(TAG, "onSetA2dpSourceConnectionState btDevice=" + btDevice + " state=" + state);
        }
        if (btDevice == null) {
            return;
        }
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            boolean isConnected;
            String key = this.makeDeviceListKey(-2147352576, address);
            DeviceListSpec deviceSpec = this.mConnectedDevices.get(key);
            boolean bl = isConnected = deviceSpec != null;
            if (isConnected && state != 2) {
                this.makeA2dpSrcUnavailable(address);
            } else if (!isConnected && state == 2) {
                this.makeA2dpSrcAvailable(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetHearingAidConnectionState(BluetoothDevice btDevice, int state) {
        if (DEBUG_DEVICES) {
            Log.d(TAG, "onSetHearingAidConnectionState btDevice=" + btDevice + ", state=" + state);
        }
        if (btDevice == null) {
            return;
        }
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            boolean isConnected;
            String key = this.makeDeviceListKey(0x8000000, btDevice.getAddress());
            DeviceListSpec deviceSpec = this.mConnectedDevices.get(key);
            boolean bl = isConnected = deviceSpec != null;
            if (isConnected && state != 2) {
                this.makeHearingAidDeviceUnavailable(address);
                this.setCurrentAudioRouteName(null);
            } else if (!isConnected && state == 2) {
                this.makeHearingAidDeviceAvailable(address, btDevice.getName(), "onSetHearingAidConnectionState");
                this.setCurrentAudioRouteName(btDevice.getAliasName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentAudioRouteName(String name) {
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            if (!TextUtils.equals(this.mCurAudioRoutes.bluetoothName, name)) {
                this.mCurAudioRoutes.bluetoothName = name;
                AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBluetoothA2dpDeviceConfigChange(BluetoothDevice btDevice) {
        if (DEBUG_DEVICES) {
            Log.d(TAG, "onBluetoothA2dpDeviceConfigChange btDevice=" + btDevice);
        }
        if (btDevice == null) {
            return;
        }
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        this.mDeviceLogger.log(new AudioEventLogger.StringEvent("onBluetoothA2dpDeviceConfigChange addr=" + address));
        int device = 128;
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            if (this.mAudioHandler.hasMessages(102, btDevice)) {
                this.mDeviceLogger.log(new AudioEventLogger.StringEvent("A2dp config change ignored"));
                return;
            }
            String key = this.makeDeviceListKey(device, address);
            DeviceListSpec deviceSpec = this.mConnectedDevices.get(key);
            if (deviceSpec != null) {
                int musicDevice = this.getDeviceForStream(3);
                if (AudioSystem.handleDeviceConfigChange(device, address, btDevice.getName()) != 0) {
                    this.setBluetoothA2dpDeviceConnectionStateInt(btDevice, 0, 2, false, musicDevice, -1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void avrcpSupportsAbsoluteVolume(String address, boolean support) {
        Object object = this.mA2dpAvrcpLock;
        synchronized (object) {
            this.mAvrcpAbsVolSupported = support;
            AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, this.mStreamStates[3], 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleDeviceConnection(boolean connect, int device, String address, String deviceName) {
        if (DEBUG_DEVICES) {
            Slog.i(TAG, "handleDeviceConnection(" + connect + " dev:" + Integer.toHexString(device) + " address:" + address + " name:" + deviceName + ")");
        }
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            DeviceListSpec deviceSpec;
            boolean isConnected;
            String deviceKey = this.makeDeviceListKey(device, address);
            if (DEBUG_DEVICES) {
                Slog.i(TAG, "deviceKey:" + deviceKey);
            }
            boolean bl = isConnected = (deviceSpec = this.mConnectedDevices.get(deviceKey)) != null;
            if (DEBUG_DEVICES) {
                Slog.i(TAG, "deviceSpec:" + deviceSpec + " is(already)Connected:" + isConnected);
            }
            if (connect && !isConnected) {
                int res = AudioSystem.setDeviceConnectionState(device, 1, address, deviceName);
                if (res != 0) {
                    Slog.e(TAG, "not connecting device 0x" + Integer.toHexString(device) + " due to command error " + res);
                    return false;
                }
                this.mConnectedDevices.put(deviceKey, new DeviceListSpec(device, deviceName, address));
                AudioService.sendMsg(this.mAudioHandler, 27, 2, device, 0, null, 0);
                return true;
            }
            if (!connect && isConnected) {
                AudioSystem.setDeviceConnectionState(device, 0, address, deviceName);
                this.mConnectedDevices.remove(deviceKey);
                return true;
            }
            Log.w(TAG, "handleDeviceConnection() failed, deviceKey=" + deviceKey + ", deviceSpec=" + deviceSpec + ", connect=" + connect);
        }
        return false;
    }

    private int checkSendBecomingNoisyIntent(int device, int state, int musicDevice) {
        int delay = 0;
        if (state == 0 && (device & this.mBecomingNoisyIntentDevices) != 0) {
            int devices = 0;
            for (int i = 0; i < this.mConnectedDevices.size(); ++i) {
                int dev = this.mConnectedDevices.valueAt((int)i).mDeviceType;
                if ((dev & Integer.MIN_VALUE) != 0 || (dev & this.mBecomingNoisyIntentDevices) == 0) continue;
                devices |= dev;
            }
            if (musicDevice == 0) {
                musicDevice = this.getDeviceForStream(3);
            }
            if ((device == musicDevice || this.isInCommunication()) && device == devices && !this.hasMediaDynamicPolicy()) {
                this.mAudioHandler.removeMessages(15);
                AudioService.sendMsg(this.mAudioHandler, 15, 0, 0, 0, null, 0);
                delay = 1000;
            }
        }
        return delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasMediaDynamicPolicy() {
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app;
            if (this.mAudioPolicies.isEmpty()) {
                return false;
            }
            Collection<AudioPolicyProxy> appColl = this.mAudioPolicies.values();
            Iterator<AudioPolicyProxy> iterator = appColl.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(app = iterator.next()).hasMixAffectingUsage(1));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAudioRoutes(int device, int state) {
        int connType = 0;
        if (device == 4) {
            connType = 1;
        } else if (device == 8 || device == 131072) {
            connType = 2;
        } else if (device == 1024 || device == 262144) {
            connType = 8;
        } else if (device == 16384 || device == 0x4000000) {
            connType = 16;
        }
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            if (connType != 0) {
                int newConn = this.mCurAudioRoutes.mainType;
                newConn = state != 0 ? (newConn |= connType) : (newConn &= ~connType);
                if (newConn != this.mCurAudioRoutes.mainType) {
                    this.mCurAudioRoutes.mainType = newConn;
                    AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendDeviceConnectionIntent(int device, int state, String address, String deviceName) {
        if (DEBUG_DEVICES) {
            Slog.i(TAG, "sendDeviceConnectionIntent(dev:0x" + Integer.toHexString(device) + " state:0x" + Integer.toHexString(state) + " address:" + address + " name:" + deviceName + ");");
        }
        Intent intent = new Intent();
        if (device == 4) {
            intent.setAction("android.intent.action.HEADSET_PLUG");
            intent.putExtra("microphone", 1);
        } else if (device == 8 || device == 131072) {
            intent.setAction("android.intent.action.HEADSET_PLUG");
            intent.putExtra("microphone", 0);
        } else if (device == 0x4000000) {
            intent.setAction("android.intent.action.HEADSET_PLUG");
            intent.putExtra("microphone", AudioSystem.getDeviceConnectionState(-2113929216, "") == 1 ? 1 : 0);
        } else if (device == -2113929216) {
            if (AudioSystem.getDeviceConnectionState(0x4000000, "") != 1) return;
            intent.setAction("android.intent.action.HEADSET_PLUG");
            intent.putExtra("microphone", 1);
        } else if (device == 1024 || device == 262144) {
            this.configureHdmiPlugIntent(intent, state);
        }
        if (intent.getAction() == null) {
            return;
        }
        intent.putExtra(CONNECT_INTENT_KEY_STATE, state);
        intent.putExtra(CONNECT_INTENT_KEY_ADDRESS, address);
        intent.putExtra(CONNECT_INTENT_KEY_PORT_NAME, deviceName);
        intent.addFlags(0x40000000);
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManager.broadcastStickyIntent(intent, -1);
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetWiredDeviceConnectionState(int device, int state, String address, String deviceName, String caller) {
        if (DEBUG_DEVICES) {
            Slog.i(TAG, "onSetWiredDeviceConnectionState(dev:" + Integer.toHexString(device) + " state:" + Integer.toHexString(state) + " address:" + address + " deviceName:" + deviceName + " caller: " + caller + ");");
        }
        ArrayMap<String, DeviceListSpec> arrayMap = this.mConnectedDevices;
        synchronized (arrayMap) {
            if (state == 0 && (device & 0x402600C) != 0) {
                this.setBluetoothA2dpOnInt(true, "onSetWiredDeviceConnectionState state 0");
            }
            if (!this.handleDeviceConnection(state == 1, device, address, deviceName)) {
                return;
            }
            if (state != 0) {
                if ((device & 0x402600C) != 0) {
                    this.setBluetoothA2dpOnInt(false, "onSetWiredDeviceConnectionState state not 0");
                }
                if ((device & 0x400000C) != 0) {
                    AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, caller, 60000);
                }
                if (this.isPlatformTelevision() && (device & 0x400) != 0) {
                    this.mFixedVolumeDevices |= 0x400;
                    this.checkAllFixedVolumeDevices();
                    if (this.mHdmiManager != null) {
                        HdmiControlManager hdmiControlManager = this.mHdmiManager;
                        synchronized (hdmiControlManager) {
                            if (this.mHdmiPlaybackClient != null) {
                                this.mHdmiCecSink = false;
                                this.mHdmiPlaybackClient.queryDisplayStatus(this.mHdmiDisplayStatusCallback);
                            }
                        }
                    }
                }
                if ((device & 0x400) != 0) {
                    this.sendEnabledSurroundFormats(this.mContentResolver, true);
                }
            } else if (this.isPlatformTelevision() && (device & 0x400) != 0 && this.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = this.mHdmiManager;
                synchronized (hdmiControlManager) {
                    this.mHdmiCecSink = false;
                }
            }
            this.sendDeviceConnectionIntent(device, state, address, deviceName);
            this.updateAudioRoutes(device, state);
        }
    }

    private void configureHdmiPlugIntent(Intent intent, int state) {
        int[] portGeneration;
        ArrayList<AudioPort> ports;
        int status;
        intent.setAction("android.media.action.HDMI_AUDIO_PLUG");
        intent.putExtra("android.media.extra.AUDIO_PLUG_STATE", state);
        if (state == 1 && (status = AudioSystem.listAudioPorts(ports = new ArrayList<AudioPort>(), portGeneration = new int[1])) == 0) {
            for (AudioPort port : ports) {
                AudioDevicePort devicePort;
                if (!(port instanceof AudioDevicePort) || (devicePort = (AudioDevicePort)port).type() != 1024 && devicePort.type() != 262144) continue;
                int[] formats = AudioFormat.filterPublicFormats(devicePort.formats());
                if (formats.length > 0) {
                    ArrayList<Integer> encodingList = new ArrayList<Integer>(1);
                    for (int format : formats) {
                        if (format == 0) continue;
                        encodingList.add(format);
                    }
                    int[] encodingArray = new int[encodingList.size()];
                    for (int i = 0; i < encodingArray.length; ++i) {
                        encodingArray[i] = (Integer)encodingList.get(i);
                    }
                    intent.putExtra("android.media.extra.ENCODINGS", encodingArray);
                }
                int maxChannels = 0;
                for (int mask : devicePort.channelMasks()) {
                    int channelCount = AudioFormat.channelCountFromOutChannelMask(mask);
                    if (channelCount <= maxChannels) continue;
                    maxChannels = channelCount;
                }
                intent.putExtra("android.media.extra.MAX_CHANNEL_COUNT", maxChannels);
            }
        }
    }

    private void handleAudioEffectBroadcast(Context context, Intent intent) {
        ResolveInfo ri;
        String target = intent.getPackage();
        if (target != null) {
            Log.w(TAG, "effect broadcast already targeted to " + target);
            return;
        }
        intent.addFlags(32);
        List<ResolveInfo> ril = context.getPackageManager().queryBroadcastReceivers(intent, 0);
        if (ril != null && ril.size() != 0 && (ri = ril.get(0)) != null && ri.activityInfo != null && ri.activityInfo.packageName != null) {
            intent.setPackage(ri.activityInfo.packageName);
            context.sendBroadcastAsUser(intent, UserHandle.ALL);
            return;
        }
        Log.w(TAG, "couldn't find receiver package for effect intent");
    }

    private void killBackgroundUserProcessesWithRecordAudioPermission(UserInfo oldUser) {
        List packages;
        PackageManager pm = this.mContext.getPackageManager();
        ComponentName homeActivityName = null;
        if (!oldUser.isManagedProfile()) {
            homeActivityName = this.mActivityManagerInternal.getHomeActivityForUser(oldUser.id);
        }
        String[] permissions = new String[]{"android.permission.RECORD_AUDIO"};
        try {
            packages = AppGlobals.getPackageManager().getPackagesHoldingPermissions(permissions, 0, oldUser.id).getList();
        }
        catch (RemoteException e) {
            throw new AndroidRuntimeException(e);
        }
        for (int j = packages.size() - 1; j >= 0; --j) {
            PackageInfo pkg = (PackageInfo)packages.get(j);
            if (UserHandle.getAppId(pkg.applicationInfo.uid) < 10000 || pm.checkPermission("android.permission.INTERACT_ACROSS_USERS", pkg.packageName) == 0 || homeActivityName != null && pkg.packageName.equals(homeActivityName.getPackageName()) && pkg.applicationInfo.isSystemApp()) continue;
            try {
                int uid = pkg.applicationInfo.uid;
                ActivityManager.getService().killUid(UserHandle.getAppId(uid), UserHandle.getUserId(uid), "killBackgroundUserProcessesWithAudioRecordPermission");
                continue;
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling killUid", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forceFocusDuckingForAccessibility(AudioAttributes aa, int request, int uid) {
        if (aa == null || aa.getUsage() != 11 || request != 3) {
            return false;
        }
        Bundle extraInfo = aa.getBundle();
        if (extraInfo == null || !extraInfo.getBoolean("a11y_force_ducking")) {
            return false;
        }
        if (uid == 0) {
            return true;
        }
        Object object = this.mAccessibilityServiceUidsLock;
        synchronized (object) {
            if (this.mAccessibilityServiceUids != null) {
                int callingUid = Binder.getCallingUid();
                for (int i = 0; i < this.mAccessibilityServiceUids.length; ++i) {
                    if (this.mAccessibilityServiceUids[i] != callingUid) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requestAudioFocus(AudioAttributes aa, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, int flags, IAudioPolicyCallback pcb, int sdk) {
        if ((flags & 4) == 4) {
            if ("AudioFocus_For_Phone_Ring_And_Calls".equals(clientId)) {
                if (0 != this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE")) {
                    Log.e(TAG, "Invalid permission to (un)lock audio focus", new Exception());
                    return 0;
                }
            } else {
                HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
                synchronized (hashMap) {
                    if (!this.mAudioPolicies.containsKey(pcb.asBinder())) {
                        Log.e(TAG, "Invalid unregistered AudioPolicy to (un)lock audio focus");
                        return 0;
                    }
                }
            }
        }
        return this.mMediaFocusControl.requestAudioFocus(aa, durationHint, cb, fd, clientId, callingPackageName, flags, sdk, this.forceFocusDuckingForAccessibility(aa, durationHint, Binder.getCallingUid()));
    }

    @Override
    public int abandonAudioFocus(IAudioFocusDispatcher fd, String clientId, AudioAttributes aa, String callingPackageName) {
        return this.mMediaFocusControl.abandonAudioFocus(fd, clientId, aa, callingPackageName);
    }

    @Override
    public void unregisterAudioFocusClient(String clientId) {
        this.mMediaFocusControl.unregisterAudioFocusClient(clientId);
    }

    @Override
    public int getCurrentAudioFocus() {
        return this.mMediaFocusControl.getCurrentAudioFocus();
    }

    @Override
    public int getFocusRampTimeMs(int focusGain, AudioAttributes attr2) {
        return MediaFocusControl.getFocusRampTimeMs(focusGain, attr2);
    }

    private boolean readCameraSoundForced() {
        return SystemProperties.getBoolean("audio.camerasound.force", false) || this.mContext.getResources().getBoolean(17956910);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void handleConfigurationChanged(Context context) {
        try {
            Configuration config = context.getResources().getConfiguration();
            AudioService.sendMsg(this.mAudioHandler, 16, 0, 0, 0, TAG, 0);
            boolean cameraSoundForced = this.readCameraSoundForced();
            Object object = this.mSettingsLock;
            // MONITORENTER : object
            boolean cameraSoundForcedChanged = cameraSoundForced != this.mCameraSoundForced;
            this.mCameraSoundForced = cameraSoundForced;
            if (cameraSoundForcedChanged) {
                if (!this.mIsSingleVolume) {
                    Class<VolumeStreamState> clazz = VolumeStreamState.class;
                    // MONITORENTER : com.android.server.audio.AudioService$VolumeStreamState.class
                    VolumeStreamState s = this.mStreamStates[7];
                    if (cameraSoundForced) {
                        s.setAllIndexesToMax();
                        this.mRingerModeAffectedStreams &= 0xFFFFFF7F;
                    } else {
                        s.setAllIndexes(this.mStreamStates[1], TAG);
                        this.mRingerModeAffectedStreams |= 0x80;
                    }
                    // MONITOREXIT : clazz
                    this.setRingerModeInt(this.getRingerModeInternal(), false);
                }
                AudioService.sendMsg(this.mAudioHandler, 8, 2, 4, cameraSoundForced ? 11 : 0, new String("handleConfigurationChanged"), 0);
                AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[7], 0);
            }
            // MONITOREXIT : object
            this.mVolumeController.setLayoutDirection(config.getLayoutDirection());
            return;
        }
        catch (Exception e) {
            Log.e(TAG, "Error handling configuration change: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBluetoothA2dpOnInt(boolean on, String eventSource) {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            this.mBluetoothA2dpEnabled = on;
            this.mAudioHandler.removeMessages(13);
            this.setForceUseInt_SyncDevices(1, this.mBluetoothA2dpEnabled ? 0 : 10, eventSource);
        }
    }

    private void setForceUseInt_SyncDevices(int usage, int config, String eventSource) {
        if (usage == 1) {
            AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
        }
        this.mForceUseLogger.log(new AudioServiceEvents.ForceUseEvent(usage, config, eventSource));
        AudioSystem.setForceUse(usage, config);
    }

    @Override
    public void setRingtonePlayer(IRingtonePlayer player) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REMOTE_AUDIO_PLAYBACK", null);
        this.mRingtonePlayer = player;
    }

    @Override
    public IRingtonePlayer getRingtonePlayer() {
        return this.mRingtonePlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver observer) {
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            AudioRoutesInfo routes = new AudioRoutesInfo(this.mCurAudioRoutes);
            this.mRoutesObservers.register(observer);
            return routes;
        }
    }

    private int safeMediaVolumeIndex(int device) {
        if ((device & 0x400000C) == 0) {
            return MAX_STREAM_VOLUME[3];
        }
        if (device == 0x4000000) {
            return this.mSafeUsbMediaVolumeIndex;
        }
        return this.mSafeMediaVolumeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSafeMediaVolumeEnabled(boolean on, String caller) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            if (this.mSafeMediaVolumeState != 0 && this.mSafeMediaVolumeState != 1) {
                if (on && this.mSafeMediaVolumeState == 2) {
                    this.mSafeMediaVolumeState = 3;
                    this.enforceSafeMediaVolume(caller);
                } else if (!on && this.mSafeMediaVolumeState == 3) {
                    this.mSafeMediaVolumeState = 2;
                    this.mMusicActiveMs = 1;
                    this.saveMusicActiveMs();
                    AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, caller, 60000);
                }
            }
        }
    }

    private void enforceSafeMediaVolume(String caller) {
        VolumeStreamState streamState = this.mStreamStates[3];
        int devices = 0x400000C;
        int i = 0;
        while (devices != 0) {
            int device;
            if (((device = 1 << i++) & devices) == 0) continue;
            int index = streamState.getIndex(device);
            if (index > this.safeMediaVolumeIndex(device)) {
                streamState.setIndex(this.safeMediaVolumeIndex(device), device, caller);
                AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
            }
            devices &= ~device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSafeMediaVolume(int streamType, int index, int device) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            return this.mSafeMediaVolumeState != 3 || mStreamVolumeAlias[streamType] != 3 || (device & 0x400000C) == 0 || index <= this.safeMediaVolumeIndex(device);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableSafeMediaVolume(String callingPackage) {
        this.enforceVolumeController("disable the safe media volume");
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.setSafeMediaVolumeEnabled(false, callingPackage);
            if (this.mPendingVolumeCommand != null) {
                this.onSetStreamVolume(this.mPendingVolumeCommand.mStreamType, this.mPendingVolumeCommand.mIndex, this.mPendingVolumeCommand.mFlags, this.mPendingVolumeCommand.mDevice, callingPackage);
                this.mPendingVolumeCommand = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setHdmiSystemAudioSupported(boolean on) {
        int device = 0;
        if (this.mHdmiManager != null) {
            HdmiControlManager hdmiControlManager = this.mHdmiManager;
            synchronized (hdmiControlManager) {
                if (this.mHdmiTvClient == null) {
                    Log.w(TAG, "Only Hdmi-Cec enabled TV device supports system audio mode.");
                    return device;
                }
                HdmiTvClient hdmiTvClient = this.mHdmiTvClient;
                synchronized (hdmiTvClient) {
                    if (this.mHdmiSystemAudioSupported != on) {
                        this.mHdmiSystemAudioSupported = on;
                        int config = on ? 12 : 0;
                        this.mForceUseLogger.log(new AudioServiceEvents.ForceUseEvent(5, config, "setHdmiSystemAudioSupported"));
                        AudioSystem.setForceUse(5, config);
                    }
                    device = this.getDevicesForStream(3);
                }
            }
        }
        return device;
    }

    @Override
    public boolean isHdmiSystemAudioSupported() {
        return this.mHdmiSystemAudioSupported;
    }

    private void initA11yMonitoring() {
        AccessibilityManager accessibilityManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
        this.updateDefaultStreamOverrideDelay(accessibilityManager.isTouchExplorationEnabled());
        this.updateA11yVolumeAlias(accessibilityManager.isAccessibilityVolumeStreamActive());
        accessibilityManager.addTouchExplorationStateChangeListener(this, null);
        accessibilityManager.addAccessibilityServicesStateChangeListener(this, null);
    }

    @Override
    public void onTouchExplorationStateChanged(boolean enabled) {
        this.updateDefaultStreamOverrideDelay(enabled);
    }

    private void updateDefaultStreamOverrideDelay(boolean touchExploreEnabled) {
        sStreamOverrideDelayMs = touchExploreEnabled ? 1000 : 0;
        if (DEBUG_VOL) {
            Log.d(TAG, "Touch exploration enabled=" + touchExploreEnabled + " stream override delay is now " + sStreamOverrideDelayMs + " ms");
        }
    }

    @Override
    public void onAccessibilityServicesStateChanged(AccessibilityManager accessibilityManager) {
        this.updateA11yVolumeAlias(accessibilityManager.isAccessibilityVolumeStreamActive());
    }

    private void updateA11yVolumeAlias(boolean a11VolEnabled) {
        if (DEBUG_VOL) {
            Log.d(TAG, "Accessibility volume enabled = " + a11VolEnabled);
        }
        if (sIndependentA11yVolume != a11VolEnabled) {
            sIndependentA11yVolume = a11VolEnabled;
            this.updateStreamVolumeAlias(true, TAG);
            this.mVolumeController.setA11yMode(sIndependentA11yVolume ? 1 : 0);
            this.mVolumeController.postVolumeChanged(10, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCameraSoundForced() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            return this.mCameraSoundForced;
        }
    }

    private void dumpRingerMode(PrintWriter pw) {
        pw.println("\nRinger mode: ");
        pw.println("- mode (internal) = " + RINGER_MODE_NAMES[this.mRingerMode]);
        pw.println("- mode (external) = " + RINGER_MODE_NAMES[this.mRingerModeExternal]);
        this.dumpRingerModeStreams(pw, "affected", this.mRingerModeAffectedStreams);
        this.dumpRingerModeStreams(pw, "muted", this.mRingerAndZenModeMutedStreams);
        pw.print("- delegate = ");
        pw.println(this.mRingerModeDelegate);
    }

    private void dumpRingerModeStreams(PrintWriter pw, String type, int streams) {
        pw.print("- ringer mode ");
        pw.print(type);
        pw.print(" streams = 0x");
        pw.print(Integer.toHexString(streams));
        if (streams != 0) {
            pw.print(" (");
            boolean first = true;
            for (int i = 0; i < AudioSystem.STREAM_NAMES.length; ++i) {
                int stream = 1 << i;
                if ((streams & stream) == 0) continue;
                if (!first) {
                    pw.print(',');
                }
                pw.print(AudioSystem.STREAM_NAMES[i]);
                streams &= ~stream;
                first = false;
            }
            if (streams != 0) {
                if (!first) {
                    pw.print(',');
                }
                pw.print(streams);
            }
            pw.print(')');
        }
        pw.println();
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        this.mMediaFocusControl.dump(pw);
        this.dumpStreamStates(pw);
        this.dumpRingerMode(pw);
        pw.println("\nAudio routes:");
        pw.print("  mMainType=0x");
        pw.println(Integer.toHexString(this.mCurAudioRoutes.mainType));
        pw.print("  mBluetoothName=");
        pw.println(this.mCurAudioRoutes.bluetoothName);
        pw.println("\nOther state:");
        pw.print("  mVolumeController=");
        pw.println(this.mVolumeController);
        pw.print("  mSafeMediaVolumeState=");
        pw.println(AudioService.safeMediaVolumeStateToString(this.mSafeMediaVolumeState));
        pw.print("  mSafeMediaVolumeIndex=");
        pw.println(this.mSafeMediaVolumeIndex);
        pw.print("  mSafeUsbMediaVolumeIndex=");
        pw.println(this.mSafeUsbMediaVolumeIndex);
        pw.print("  mSafeUsbMediaVolumeDbfs=");
        pw.println(this.mSafeUsbMediaVolumeDbfs);
        pw.print("  sIndependentA11yVolume=");
        pw.println(sIndependentA11yVolume);
        pw.print("  mPendingVolumeCommand=");
        pw.println(this.mPendingVolumeCommand);
        pw.print("  mMusicActiveMs=");
        pw.println(this.mMusicActiveMs);
        pw.print("  mMcc=");
        pw.println(this.mMcc);
        pw.print("  mCameraSoundForced=");
        pw.println(this.mCameraSoundForced);
        pw.print("  mHasVibrator=");
        pw.println(this.mHasVibrator);
        pw.print("  mVolumePolicy=");
        pw.println(this.mVolumePolicy);
        pw.print("  mAvrcpAbsVolSupported=");
        pw.println(this.mAvrcpAbsVolSupported);
        this.dumpAudioPolicies(pw);
        this.mDynPolicyLogger.dump(pw);
        this.mPlaybackMonitor.dump(pw);
        this.mRecordMonitor.dump(pw);
        pw.println("\n");
        pw.println("\nEvent logs:");
        this.mModeLogger.dump(pw);
        pw.println("\n");
        this.mDeviceLogger.dump(pw);
        pw.println("\n");
        this.mForceUseLogger.dump(pw);
        pw.println("\n");
        this.mVolumeLogger.dump(pw);
    }

    private static String safeMediaVolumeStateToString(Integer state) {
        switch (state) {
            case 0: {
                return "SAFE_MEDIA_VOLUME_NOT_CONFIGURED";
            }
            case 1: {
                return "SAFE_MEDIA_VOLUME_DISABLED";
            }
            case 2: {
                return "SAFE_MEDIA_VOLUME_INACTIVE";
            }
            case 3: {
                return "SAFE_MEDIA_VOLUME_ACTIVE";
            }
        }
        return null;
    }

    private static void readAndSetLowRamDevice() {
        boolean isLowRamDevice = ActivityManager.isLowRamDeviceStatic();
        long totalMemory = 0x40000000L;
        try {
            ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
            ActivityManager.getService().getMemoryInfo(info);
            totalMemory = info.totalMem;
        }
        catch (RemoteException e) {
            Log.w(TAG, "Cannot obtain MemoryInfo from ActivityManager, assume low memory device");
            isLowRamDevice = true;
        }
        int status = AudioSystem.setLowRamDevice(isLowRamDevice, totalMemory);
        if (status != 0) {
            Log.w(TAG, "AudioFlinger informed of device's low RAM attribute; status " + status);
        }
    }

    private void enforceVolumeController(String action) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", "Only SystemUI can " + action);
    }

    @Override
    public void setVolumeController(final IVolumeController controller) {
        this.enforceVolumeController("set the volume controller");
        if (this.mVolumeController.isSameBinder(controller)) {
            return;
        }
        this.mVolumeController.postDismiss();
        if (controller != null) {
            try {
                controller.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                    @Override
                    public void binderDied() {
                        if (AudioService.this.mVolumeController.isSameBinder(controller)) {
                            Log.w(AudioService.TAG, "Current remote volume controller died, unregistering");
                            AudioService.this.setVolumeController(null);
                        }
                    }
                }, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mVolumeController.setController(controller);
        if (DEBUG_VOL) {
            Log.d(TAG, "Volume controller: " + this.mVolumeController);
        }
    }

    @Override
    public void notifyVolumeControllerVisible(IVolumeController controller, boolean visible) {
        this.enforceVolumeController("notify about volume controller visibility");
        if (!this.mVolumeController.isSameBinder(controller)) {
            return;
        }
        this.mVolumeController.setVisible(visible);
        if (DEBUG_VOL) {
            Log.d(TAG, "Volume controller visible: " + visible);
        }
    }

    @Override
    public void setVolumePolicy(VolumePolicy policy) {
        this.enforceVolumeController("set volume policy");
        if (policy != null && !policy.equals(this.mVolumePolicy)) {
            this.mVolumePolicy = policy;
            if (DEBUG_VOL) {
                Log.d(TAG, "Volume policy changed: " + this.mVolumePolicy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String registerAudioPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb, boolean hasFocusListener, boolean isFocusPolicy, boolean isVolumeController) {
        boolean hasPermissionForPolicy;
        AudioSystem.setDynamicPolicyCallback(this.mDynPolicyCallback);
        String regId = null;
        boolean bl = hasPermissionForPolicy = 0 == this.mContext.checkCallingPermission("android.permission.MODIFY_AUDIO_ROUTING");
        if (!hasPermissionForPolicy) {
            Slog.w(TAG, "Can't register audio policy for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid() + ", need MODIFY_AUDIO_ROUTING");
            return null;
        }
        this.mDynPolicyLogger.log(new AudioEventLogger.StringEvent("registerAudioPolicy for " + pcb.asBinder() + " with config:" + policyConfig).printLog(TAG));
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            try {
                if (this.mAudioPolicies.containsKey(pcb.asBinder())) {
                    Slog.e(TAG, "Cannot re-register policy");
                    return null;
                }
                AudioPolicyProxy app = new AudioPolicyProxy(policyConfig, pcb, hasFocusListener, isFocusPolicy, isVolumeController);
                pcb.asBinder().linkToDeath(app, 0);
                regId = app.getRegistrationId();
                this.mAudioPolicies.put(pcb.asBinder(), app);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Audio policy registration failed, could not link to " + pcb + " binder death", e);
                return null;
            }
            return regId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAudioPolicyAsync(IAudioPolicyCallback pcb) {
        this.mDynPolicyLogger.log(new AudioEventLogger.StringEvent("unregisterAudioPolicyAsync for " + pcb.asBinder()).printLog(TAG));
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = this.mAudioPolicies.remove(pcb.asBinder());
            if (app == null) {
                Slog.w(TAG, "Trying to unregister unknown audio policy for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid());
                return;
            }
            pcb.asBinder().unlinkToDeath(app, 0);
            app.release();
        }
    }

    @GuardedBy(value="mAudioPolicies")
    private AudioPolicyProxy checkUpdateForPolicy(IAudioPolicyCallback pcb, String errorMsg) {
        boolean hasPermissionForPolicy;
        boolean bl = hasPermissionForPolicy = 0 == this.mContext.checkCallingPermission("android.permission.MODIFY_AUDIO_ROUTING");
        if (!hasPermissionForPolicy) {
            Slog.w(TAG, errorMsg + " for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid() + ", need MODIFY_AUDIO_ROUTING");
            return null;
        }
        AudioPolicyProxy app = this.mAudioPolicies.get(pcb.asBinder());
        if (app == null) {
            Slog.w(TAG, errorMsg + " for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid() + ", unregistered policy");
            return null;
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) {
        if (DEBUG_AP) {
            Log.d(TAG, "addMixForPolicy for " + pcb.asBinder() + " with config:" + policyConfig);
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = this.checkUpdateForPolicy(pcb, "Cannot add AudioMix in audio policy");
            if (app == null) {
                return -1;
            }
            app.addMixes(policyConfig.getMixes());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeMixForPolicy(AudioPolicyConfig policyConfig, IAudioPolicyCallback pcb) {
        if (DEBUG_AP) {
            Log.d(TAG, "removeMixForPolicy for " + pcb.asBinder() + " with config:" + policyConfig);
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = this.checkUpdateForPolicy(pcb, "Cannot add AudioMix in audio policy");
            if (app == null) {
                return -1;
            }
            app.removeMixes(policyConfig.getMixes());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setFocusPropertiesForPolicy(int duckingBehavior, IAudioPolicyCallback pcb) {
        if (DEBUG_AP) {
            Log.d(TAG, "setFocusPropertiesForPolicy() duck behavior=" + duckingBehavior + " policy " + pcb.asBinder());
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy app = this.checkUpdateForPolicy(pcb, "Cannot change audio policy focus properties");
            if (app == null) {
                return -1;
            }
            if (!this.mAudioPolicies.containsKey(pcb.asBinder())) {
                Slog.e(TAG, "Cannot change audio policy focus properties, unregistered policy");
                return -1;
            }
            if (duckingBehavior == 1) {
                for (AudioPolicyProxy policy : this.mAudioPolicies.values()) {
                    if (policy.mFocusDuckBehavior != 1) continue;
                    Slog.e(TAG, "Cannot change audio policy ducking behavior, already handled");
                    return -1;
                }
            }
            app.mFocusDuckBehavior = duckingBehavior;
            this.mMediaFocusControl.setDuckingInExtPolicyAvailable(duckingBehavior == 1);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExtVolumeController(IAudioPolicyCallback apc) {
        if (!this.mContext.getResources().getBoolean(17956982)) {
            Log.e(TAG, "Cannot set external volume controller: device not set for volume keys handled in PhoneWindowManager");
            return;
        }
        Object object = this.mExtVolumeControllerLock;
        synchronized (object) {
            if (this.mExtVolumeController != null && !this.mExtVolumeController.asBinder().pingBinder()) {
                Log.e(TAG, "Cannot set external volume controller: existing controller");
            }
            this.mExtVolumeController = apc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAudioPolicies(PrintWriter pw) {
        pw.println("\nAudio policies:");
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            for (AudioPolicyProxy policy : this.mAudioPolicies.values()) {
                pw.println(policy.toLogFriendlyString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onDynPolicyMixStateUpdate(String regId, int state) {
        if (DEBUG_AP) {
            Log.d(TAG, "onDynamicPolicyMixStateUpdate(" + regId + ", " + state + ")");
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            AudioPolicyProxy policy;
            Iterator<AudioPolicyProxy> iterator = this.mAudioPolicies.values().iterator();
            block5: while (true) {
                AudioMix mix;
                if (!iterator.hasNext()) return;
                policy = iterator.next();
                Iterator<AudioMix> iterator2 = policy.getMixes().iterator();
                do {
                    if (!iterator2.hasNext()) continue block5;
                } while (!(mix = iterator2.next()).getRegistration().equals(regId));
                break;
            }
            try {
                policy.mPolicyCallback.notifyMixStateUpdate(regId, state);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Can't call notifyMixStateUpdate() on IAudioPolicyCallback " + policy.mPolicyCallback.asBinder(), e);
            }
            return;
        }
    }

    @Override
    public void registerRecordingCallback(IRecordingConfigDispatcher rcdb) {
        boolean isPrivileged = 0 == this.mContext.checkCallingPermission("android.permission.MODIFY_AUDIO_ROUTING");
        this.mRecordMonitor.registerRecordingCallback(rcdb, isPrivileged);
    }

    @Override
    public void unregisterRecordingCallback(IRecordingConfigDispatcher rcdb) {
        this.mRecordMonitor.unregisterRecordingCallback(rcdb);
    }

    @Override
    public List<AudioRecordingConfiguration> getActiveRecordingConfigurations() {
        boolean isPrivileged = 0 == this.mContext.checkCallingPermission("android.permission.MODIFY_AUDIO_ROUTING");
        return this.mRecordMonitor.getActiveRecordingConfigurations(isPrivileged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableRingtoneSync(int userId) {
        int callingUserId = UserHandle.getCallingUserId();
        if (callingUserId != userId) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "disable sound settings syncing for another profile");
        }
        long token = Binder.clearCallingIdentity();
        try {
            Settings.Secure.putIntForUser(this.mContentResolver, "sync_parent_sounds", 0, userId);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public void registerPlaybackCallback(IPlaybackConfigDispatcher pcdb) {
        boolean isPrivileged = 0 == this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_ROUTING");
        this.mPlaybackMonitor.registerPlaybackCallback(pcdb, isPrivileged);
    }

    @Override
    public void unregisterPlaybackCallback(IPlaybackConfigDispatcher pcdb) {
        this.mPlaybackMonitor.unregisterPlaybackCallback(pcdb);
    }

    @Override
    public List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() {
        boolean isPrivileged = 0 == this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_ROUTING");
        return this.mPlaybackMonitor.getActivePlaybackConfigurations(isPrivileged);
    }

    @Override
    public int trackPlayer(PlayerBase.PlayerIdCard pic) {
        return this.mPlaybackMonitor.trackPlayer(pic);
    }

    @Override
    public void playerAttributes(int piid, AudioAttributes attr2) {
        this.mPlaybackMonitor.playerAttributes(piid, attr2, Binder.getCallingUid());
    }

    @Override
    public void playerEvent(int piid, int event) {
        this.mPlaybackMonitor.playerEvent(piid, event, Binder.getCallingUid());
    }

    @Override
    public void playerHasOpPlayAudio(int piid, boolean hasOpPlayAudio) {
        this.mPlaybackMonitor.playerHasOpPlayAudio(piid, hasOpPlayAudio, Binder.getCallingUid());
    }

    @Override
    public void releasePlayer(int piid) {
        this.mPlaybackMonitor.releasePlayer(piid, Binder.getCallingUid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int dispatchFocusChange(AudioFocusInfo afi, int focusChange, IAudioPolicyCallback pcb) {
        if (afi == null) {
            throw new IllegalArgumentException("Illegal null AudioFocusInfo");
        }
        if (pcb == null) {
            throw new IllegalArgumentException("Illegal null AudioPolicy callback");
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            if (!this.mAudioPolicies.containsKey(pcb.asBinder())) {
                throw new IllegalStateException("Unregistered AudioPolicy for focus dispatch");
            }
            return this.mMediaFocusControl.dispatchFocusChange(afi, focusChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusRequestResultFromExtPolicy(AudioFocusInfo afi, int requestResult, IAudioPolicyCallback pcb) {
        if (afi == null) {
            throw new IllegalArgumentException("Illegal null AudioFocusInfo");
        }
        if (pcb == null) {
            throw new IllegalArgumentException("Illegal null AudioPolicy callback");
        }
        HashMap<IBinder, AudioPolicyProxy> hashMap = this.mAudioPolicies;
        synchronized (hashMap) {
            if (!this.mAudioPolicies.containsKey(pcb.asBinder())) {
                throw new IllegalStateException("Unregistered AudioPolicy for external focus");
            }
            this.mMediaFocusControl.setFocusRequestResultFromExtPolicy(afi, requestResult);
        }
    }

    private void checkMonitorAudioServerStatePermission() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_ROUTING") != 0) {
            throw new SecurityException("Not allowed to monitor audioserver state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAudioServerStateDispatcher(IAudioServerStateDispatcher asd) {
        this.checkMonitorAudioServerStatePermission();
        HashMap<IBinder, AsdProxy> hashMap = this.mAudioServerStateListeners;
        synchronized (hashMap) {
            if (this.mAudioServerStateListeners.containsKey(asd.asBinder())) {
                Slog.w(TAG, "Cannot re-register audio server state dispatcher");
                return;
            }
            AsdProxy asdp = new AsdProxy(asd);
            try {
                asd.asBinder().linkToDeath(asdp, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mAudioServerStateListeners.put(asd.asBinder(), asdp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAudioServerStateDispatcher(IAudioServerStateDispatcher asd) {
        this.checkMonitorAudioServerStatePermission();
        HashMap<IBinder, AsdProxy> hashMap = this.mAudioServerStateListeners;
        synchronized (hashMap) {
            AsdProxy asdp = this.mAudioServerStateListeners.remove(asd.asBinder());
            if (asdp == null) {
                Slog.w(TAG, "Trying to unregister unknown audioserver state dispatcher for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid());
                return;
            }
            asd.asBinder().unlinkToDeath(asdp, 0);
        }
    }

    @Override
    public boolean isAudioServerRunning() {
        this.checkMonitorAudioServerStatePermission();
        return AudioSystem.checkAudioFlinger() == 0;
    }

    static /* synthetic */ int[] access$11702(AudioService x0, int[] x1) {
        x0.mAccessibilityServiceUids = x1;
        return x1;
    }

    static {
        STREAM_VOLUME_OPS = new int[]{34, 36, 35, 36, 37, 38, 39, 36, 36, 36, 64};
        VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
        mLastDeviceConnectMsgTime = new Long(0L);
        sIndependentA11yVolume = false;
        RINGER_MODE_NAMES = new String[]{"SILENT", "VIBRATE", "NORMAL"};
    }

    private class AsdProxy
    implements IBinder.DeathRecipient {
        private final IAudioServerStateDispatcher mAsd;

        AsdProxy(IAudioServerStateDispatcher asd) {
            this.mAsd = asd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            HashMap hashMap = AudioService.this.mAudioServerStateListeners;
            synchronized (hashMap) {
                AudioService.this.mAudioServerStateListeners.remove(this.mAsd.asBinder());
            }
        }

        IAudioServerStateDispatcher callback() {
            return this.mAsd;
        }
    }

    public class AudioPolicyProxy
    extends AudioPolicyConfig
    implements IBinder.DeathRecipient {
        private static final String TAG = "AudioPolicyProxy";
        final IAudioPolicyCallback mPolicyCallback;
        final boolean mHasFocusListener;
        final boolean mIsVolumeController;
        int mFocusDuckBehavior;
        boolean mIsFocusPolicy;

        AudioPolicyProxy(AudioPolicyConfig config, IAudioPolicyCallback token, boolean hasFocusListener, boolean isFocusPolicy, boolean isVolumeController) {
            super(config);
            this.mFocusDuckBehavior = 0;
            this.mIsFocusPolicy = false;
            this.setRegistration(new String(config.hashCode() + ":ap:" + AudioService.this.mAudioPolicyCounter++));
            this.mPolicyCallback = token;
            this.mHasFocusListener = hasFocusListener;
            this.mIsVolumeController = isVolumeController;
            if (this.mHasFocusListener) {
                AudioService.this.mMediaFocusControl.addFocusFollower(this.mPolicyCallback);
                if (isFocusPolicy) {
                    this.mIsFocusPolicy = true;
                    AudioService.this.mMediaFocusControl.setFocusPolicy(this.mPolicyCallback);
                }
            }
            if (this.mIsVolumeController) {
                AudioService.this.setExtVolumeController(this.mPolicyCallback);
            }
            this.connectMixes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = AudioService.this.mAudioPolicies;
            synchronized (object) {
                Log.i(TAG, "audio policy " + this.mPolicyCallback + " died");
                this.release();
                AudioService.this.mAudioPolicies.remove(this.mPolicyCallback.asBinder());
            }
            if (this.mIsVolumeController) {
                object = AudioService.this.mExtVolumeControllerLock;
                synchronized (object) {
                    AudioService.this.mExtVolumeController = null;
                }
            }
        }

        String getRegistrationId() {
            return this.getRegistration();
        }

        void release() {
            if (this.mIsFocusPolicy) {
                AudioService.this.mMediaFocusControl.unsetFocusPolicy(this.mPolicyCallback);
            }
            if (this.mFocusDuckBehavior == 1) {
                AudioService.this.mMediaFocusControl.setDuckingInExtPolicyAvailable(false);
            }
            if (this.mHasFocusListener) {
                AudioService.this.mMediaFocusControl.removeFocusFollower(this.mPolicyCallback);
            }
            long identity = Binder.clearCallingIdentity();
            AudioSystem.registerPolicyMixes(this.mMixes, false);
            Binder.restoreCallingIdentity(identity);
        }

        boolean hasMixAffectingUsage(int usage) {
            for (AudioMix mix : this.mMixes) {
                if (!mix.isAffectingUsage(usage)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addMixes(ArrayList<AudioMix> mixes) {
            ArrayList arrayList = this.mMixes;
            synchronized (arrayList) {
                AudioSystem.registerPolicyMixes(this.mMixes, false);
                this.add(mixes);
                AudioSystem.registerPolicyMixes(this.mMixes, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeMixes(ArrayList<AudioMix> mixes) {
            ArrayList arrayList = this.mMixes;
            synchronized (arrayList) {
                AudioSystem.registerPolicyMixes(this.mMixes, false);
                this.remove(mixes);
                AudioSystem.registerPolicyMixes(this.mMixes, true);
            }
        }

        void connectMixes() {
            long identity = Binder.clearCallingIdentity();
            AudioSystem.registerPolicyMixes(this.mMixes, true);
            Binder.restoreCallingIdentity(identity);
        }
    }

    final class AudioServiceInternal
    extends AudioManagerInternal {
        AudioServiceInternal() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRingerModeDelegate(AudioManagerInternal.RingerModeDelegate delegate) {
            AudioService.this.mRingerModeDelegate = delegate;
            if (AudioService.this.mRingerModeDelegate != null) {
                Object object = AudioService.this.mSettingsLock;
                synchronized (object) {
                    AudioService.this.updateRingerAndZenModeAffectedStreams();
                }
                this.setRingerModeInternal(this.getRingerModeInternal(), "AudioService.setRingerModeDelegate");
            }
        }

        @Override
        public void adjustSuggestedStreamVolumeForUid(int streamType, int direction, int flags, String callingPackage, int uid) {
            AudioService.this.adjustSuggestedStreamVolume(direction, streamType, flags, callingPackage, callingPackage, uid);
        }

        @Override
        public void adjustStreamVolumeForUid(int streamType, int direction, int flags, String callingPackage, int uid) {
            AudioService.this.adjustStreamVolume(streamType, direction, flags, callingPackage, callingPackage, uid);
        }

        @Override
        public void setStreamVolumeForUid(int streamType, int direction, int flags, String callingPackage, int uid) {
            AudioService.this.setStreamVolume(streamType, direction, flags, callingPackage, callingPackage, uid);
        }

        @Override
        public int getRingerModeInternal() {
            return AudioService.this.getRingerModeInternal();
        }

        @Override
        public void setRingerModeInternal(int ringerMode, String caller) {
            AudioService.this.setRingerModeInternal(ringerMode, caller);
        }

        @Override
        public void silenceRingerModeInternal(String caller) {
            AudioService.this.silenceRingerModeInternal(caller);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateRingerModeAffectedStreamsInternal() {
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                if (AudioService.this.updateRingerAndZenModeAffectedStreams()) {
                    AudioService.this.setRingerModeInt(this.getRingerModeInternal(), false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAccessibilityServiceUids(IntArray uids) {
            Object object = AudioService.this.mAccessibilityServiceUidsLock;
            synchronized (object) {
                if (uids.size() == 0) {
                    AudioService.access$11702(AudioService.this, null);
                } else {
                    boolean changed;
                    boolean bl = changed = AudioService.this.mAccessibilityServiceUids == null || AudioService.this.mAccessibilityServiceUids.length != uids.size();
                    if (!changed) {
                        for (int i = 0; i < AudioService.this.mAccessibilityServiceUids.length; ++i) {
                            if (uids.get(i) == AudioService.this.mAccessibilityServiceUids[i]) continue;
                            changed = true;
                            break;
                        }
                    }
                    if (changed) {
                        AudioService.access$11702(AudioService.this, uids.toArray());
                    }
                }
            }
        }
    }

    public static class VolumeController {
        private static final String TAG = "VolumeController";
        private IVolumeController mController;
        private boolean mVisible;
        private long mNextLongPress;
        private int mLongPressTimeout;

        public void setController(IVolumeController controller) {
            this.mController = controller;
            this.mVisible = false;
        }

        public void loadSettings(ContentResolver cr) {
            this.mLongPressTimeout = Settings.Secure.getIntForUser(cr, "long_press_timeout", 500, -2);
        }

        public boolean suppressAdjustment(int resolvedStream, int flags, boolean isMute) {
            if (isMute) {
                return false;
            }
            boolean suppress = false;
            if (resolvedStream == 3 && this.mController != null) {
                long now = SystemClock.uptimeMillis();
                if ((flags & 1) != 0 && !this.mVisible) {
                    if (this.mNextLongPress < now) {
                        this.mNextLongPress = now + (long)this.mLongPressTimeout;
                    }
                    suppress = true;
                } else if (this.mNextLongPress > 0L) {
                    if (now > this.mNextLongPress) {
                        this.mNextLongPress = 0L;
                    } else {
                        suppress = true;
                    }
                }
            }
            return suppress;
        }

        public void setVisible(boolean visible) {
            this.mVisible = visible;
        }

        public boolean isSameBinder(IVolumeController controller) {
            return Objects.equals(this.asBinder(), VolumeController.binder(controller));
        }

        public IBinder asBinder() {
            return VolumeController.binder(this.mController);
        }

        private static IBinder binder(IVolumeController controller) {
            return controller == null ? null : controller.asBinder();
        }

        public String toString() {
            return "VolumeController(" + this.asBinder() + ",mVisible=" + this.mVisible + ")";
        }

        public void postDisplaySafeVolumeWarning(int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.displaySafeVolumeWarning(flags);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling displaySafeVolumeWarning", e);
            }
        }

        public void postVolumeChanged(int streamType, int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.volumeChanged(streamType, flags);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling volumeChanged", e);
            }
        }

        public void postMasterMuteChanged(int flags) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.masterMuteChanged(flags);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling masterMuteChanged", e);
            }
        }

        public void setLayoutDirection(int layoutDirection) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.setLayoutDirection(layoutDirection);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling setLayoutDirection", e);
            }
        }

        public void postDismiss() {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.dismiss();
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling dismiss", e);
            }
        }

        public void setA11yMode(int a11yMode) {
            if (this.mController == null) {
                return;
            }
            try {
                this.mController.setA11yMode(a11yMode);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Error calling setA11Mode", e);
            }
        }
    }

    private class MyDisplayStatusCallback
    implements HdmiPlaybackClient.DisplayStatusCallback {
        private MyDisplayStatusCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(int status) {
            if (AudioService.this.mHdmiManager != null) {
                HdmiControlManager hdmiControlManager = AudioService.this.mHdmiManager;
                synchronized (hdmiControlManager) {
                    AudioService.this.mHdmiCecSink = status != -1;
                    if (AudioService.this.isPlatformTelevision() && !AudioService.this.mHdmiCecSink) {
                        AudioService.this.mFixedVolumeDevices &= 0xFFFFFBFF;
                    }
                    AudioService.this.checkAllFixedVolumeDevices();
                }
            }
        }
    }

    private class AudioServiceUserRestrictionsListener
    implements UserManagerInternal.UserRestrictionsListener {
        private AudioServiceUserRestrictionsListener() {
        }

        @Override
        public void onUserRestrictionsChanged(int userId, Bundle newRestrictions, Bundle prevRestrictions) {
            boolean isRestricted;
            boolean wasRestricted = prevRestrictions.getBoolean("no_unmute_microphone");
            if (wasRestricted != (isRestricted = newRestrictions.getBoolean("no_unmute_microphone"))) {
                AudioService.this.setMicrophoneMuteNoCallerCheck(isRestricted, userId);
            }
            wasRestricted = prevRestrictions.getBoolean("no_adjust_volume") || prevRestrictions.getBoolean("disallow_unmute_device");
            boolean bl = isRestricted = newRestrictions.getBoolean("no_adjust_volume") || newRestrictions.getBoolean("disallow_unmute_device");
            if (wasRestricted != isRestricted) {
                AudioService.this.setMasterMuteInternalNoCallerCheck(isRestricted, 0, userId);
            }
        }
    }

    private class AudioServiceBroadcastReceiver
    extends BroadcastReceiver {
        private AudioServiceBroadcastReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.DOCK_EVENT")) {
                int config;
                int dockState = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                switch (dockState) {
                    case 1: {
                        config = 7;
                        break;
                    }
                    case 2: {
                        config = 6;
                        break;
                    }
                    case 3: {
                        config = 8;
                        break;
                    }
                    case 4: {
                        config = 9;
                        break;
                    }
                    default: {
                        config = 0;
                    }
                }
                if (dockState != 3 && (dockState != 0 || AudioService.this.mDockState != 3)) {
                    AudioService.this.mForceUseLogger.log(new AudioServiceEvents.ForceUseEvent(3, config, "ACTION_DOCK_EVENT intent"));
                    AudioSystem.setForceUse(3, config);
                }
                AudioService.this.mDockState = dockState;
            } else if (action.equals("android.bluetooth.headset.profile.action.ACTIVE_DEVICE_CHANGED")) {
                BluetoothDevice btDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                AudioService.this.setBtScoActiveDevice(btDevice);
            } else if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                boolean broadcast = false;
                int scoAudioState = -1;
                ArrayList arrayList = AudioService.this.mScoClients;
                synchronized (arrayList) {
                    int btState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    if (!(AudioService.this.mScoClients.isEmpty() || AudioService.this.mScoAudioState != 3 && AudioService.this.mScoAudioState != 1 && AudioService.this.mScoAudioState != 4 && AudioService.this.mScoAudioState != 5)) {
                        broadcast = true;
                    }
                    switch (btState) {
                        case 12: {
                            scoAudioState = 1;
                            if (AudioService.this.mScoAudioState != 3 && AudioService.this.mScoAudioState != 4) {
                                AudioService.this.mScoAudioState = 2;
                            }
                            AudioService.this.setBluetoothScoOn(true);
                            break;
                        }
                        case 10: {
                            AudioService.this.setBluetoothScoOn(false);
                            scoAudioState = 0;
                            if (AudioService.this.mScoAudioState == 1 && AudioService.this.mBluetoothHeadset != null && AudioService.this.mBluetoothHeadsetDevice != null && AudioService.connectBluetoothScoAudioHelper(AudioService.this.mBluetoothHeadset, AudioService.this.mBluetoothHeadsetDevice, AudioService.this.mScoAudioMode)) {
                                AudioService.this.mScoAudioState = 3;
                                broadcast = false;
                                break;
                            }
                            AudioService.this.clearAllScoClients(0, AudioService.this.mScoAudioState == 3);
                            AudioService.this.mScoAudioState = 0;
                            break;
                        }
                        case 11: {
                            if (AudioService.this.mScoAudioState != 3 && AudioService.this.mScoAudioState != 4) {
                                AudioService.this.mScoAudioState = 2;
                            }
                        }
                        default: {
                            broadcast = false;
                        }
                    }
                }
                if (broadcast) {
                    AudioService.this.broadcastScoConnectionState(scoAudioState);
                    Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
                    newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", scoAudioState);
                    AudioService.this.sendStickyBroadcastToAll(newIntent);
                }
            } else if (action.equals("android.intent.action.SCREEN_ON")) {
                if (AudioService.this.mMonitorRotation) {
                    RotationHelper.enable();
                }
                AudioSystem.setParameters("screen_state=on");
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                if (AudioService.this.mMonitorRotation) {
                    RotationHelper.disable();
                }
                AudioSystem.setParameters("screen_state=off");
            } else if (action.equals("android.intent.action.CONFIGURATION_CHANGED")) {
                AudioService.this.handleConfigurationChanged(context);
            } else if (action.equals("android.intent.action.USER_SWITCHED")) {
                if (AudioService.this.mUserSwitchedReceived) {
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 15, 0, 0, 0, null, 0);
                }
                AudioService.this.mUserSwitchedReceived = true;
                AudioService.this.mMediaFocusControl.discardAudioFocusOwner();
                AudioService.this.readAudioSettings(true);
                AudioService.sendMsg(AudioService.this.mAudioHandler, 10, 2, 0, 0, AudioService.this.mStreamStates[3], 0);
            } else if (action.equals("android.intent.action.USER_BACKGROUND")) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                if (userId >= 0) {
                    UserInfo userInfo = UserManagerService.getInstance().getUserInfo(userId);
                    AudioService.this.killBackgroundUserProcessesWithRecordAudioPermission(userInfo);
                }
                UserManagerService.getInstance().setUserRestriction("no_record_audio", true, userId);
            } else if (action.equals("android.intent.action.USER_FOREGROUND")) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                UserManagerService.getInstance().setUserRestriction("no_record_audio", false, userId);
            } else if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                if (state == 10 || state == 13) {
                    AudioService.this.disconnectAllBluetoothProfiles();
                }
            } else if (action.equals("android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION") || action.equals("android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION")) {
                AudioService.this.handleAudioEffectBroadcast(context, intent);
            }
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        SettingsObserver() {
            super(new Handler());
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("zen_mode"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("zen_mode_config_etag"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("mode_ringer_streams_affected"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("dock_audio_media_enabled"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("master_mono"), false, this);
            AudioService.this.mEncodedSurroundMode = Settings.Global.getInt(AudioService.this.mContentResolver, "encoded_surround_output", 0);
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("encoded_surround_output"), false, this);
            AudioService.this.mEnabledSurroundFormats = Settings.Global.getString(AudioService.this.mContentResolver, "encoded_surround_output_enabled_formats");
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("encoded_surround_output_enabled_formats"), false, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                if (AudioService.this.updateRingerAndZenModeAffectedStreams()) {
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerModeInternal(), false);
                }
                AudioService.this.readDockAudioSettings(AudioService.this.mContentResolver);
                AudioService.this.updateMasterMono(AudioService.this.mContentResolver);
                this.updateEncodedSurroundOutput();
                AudioService.this.sendEnabledSurroundFormats(AudioService.this.mContentResolver, AudioService.this.mSurroundModeChanged);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEncodedSurroundOutput() {
            int newSurroundMode = Settings.Global.getInt(AudioService.this.mContentResolver, "encoded_surround_output", 0);
            if (AudioService.this.mEncodedSurroundMode != newSurroundMode) {
                AudioService.this.sendEncodedSurroundMode(newSurroundMode, "SettingsObserver");
                ArrayMap arrayMap = AudioService.this.mConnectedDevices;
                synchronized (arrayMap) {
                    String key = AudioService.this.makeDeviceListKey(1024, "");
                    DeviceListSpec deviceSpec = (DeviceListSpec)AudioService.this.mConnectedDevices.get(key);
                    if (deviceSpec != null) {
                        AudioService.this.setWiredDeviceConnectionState(1024, 0, "", "", "android");
                        AudioService.this.setWiredDeviceConnectionState(1024, 1, "", "", "android");
                    }
                }
                AudioService.this.mEncodedSurroundMode = newSurroundMode;
                AudioService.this.mSurroundModeChanged = true;
            } else {
                AudioService.this.mSurroundModeChanged = false;
            }
        }
    }

    private class AudioHandler
    extends Handler {
        private AudioHandler() {
        }

        private void setAllVolumes(VolumeStreamState streamState) {
            streamState.applyAllVolumes();
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (streamType == streamState.mStreamType || mStreamVolumeAlias[streamType] != streamState.mStreamType) continue;
                AudioService.this.mStreamStates[streamType].applyAllVolumes();
            }
        }

        private void persistVolume(VolumeStreamState streamState, int device) {
            if (AudioService.this.mUseFixedVolume) {
                return;
            }
            if (AudioService.this.mIsSingleVolume && streamState.mStreamType != 3) {
                return;
            }
            if (streamState.hasValidSettingsName()) {
                Settings.System.putIntForUser(AudioService.this.mContentResolver, streamState.getSettingNameForDevice(device), (streamState.getIndex(device) + 5) / 10, -2);
            }
        }

        private void persistRingerMode(int ringerMode) {
            if (AudioService.this.mUseFixedVolume) {
                return;
            }
            Settings.Global.putInt(AudioService.this.mContentResolver, "mode_ringer", ringerMode);
        }

        private String getSoundEffectFilePath(int effectType) {
            String filePath = Environment.getProductDirectory() + AudioService.SOUND_EFFECTS_PATH + (String)SOUND_EFFECT_FILES.get(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][0]);
            if (!new File(filePath).isFile()) {
                filePath = Environment.getRootDirectory() + AudioService.SOUND_EFFECTS_PATH + (String)SOUND_EFFECT_FILES.get(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][0]);
            }
            return filePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onLoadSoundEffects() {
            int status;
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                int effect;
                if (!AudioService.this.mSystemReady) {
                    Log.w(AudioService.TAG, "onLoadSoundEffects() called before boot complete");
                    return false;
                }
                if (AudioService.this.mSoundPool != null) {
                    return true;
                }
                AudioService.this.loadTouchSoundAssets();
                AudioService.this.mSoundPool = new SoundPool.Builder().setMaxStreams(4).setAudioAttributes(new AudioAttributes.Builder().setUsage(13).setContentType(4).build()).build();
                AudioService.this.mSoundPoolCallBack = null;
                AudioService.this.mSoundPoolListenerThread = new SoundPoolListenerThread();
                AudioService.this.mSoundPoolListenerThread.start();
                int attempts = 3;
                while (AudioService.this.mSoundPoolCallBack == null && attempts-- > 0) {
                    try {
                        AudioService.this.mSoundEffectsLock.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        Log.w(AudioService.TAG, "Interrupted while waiting sound pool listener thread.");
                    }
                }
                if (AudioService.this.mSoundPoolCallBack == null) {
                    Log.w(AudioService.TAG, "onLoadSoundEffects() SoundPool listener or thread creation error");
                    if (AudioService.this.mSoundPoolLooper != null) {
                        AudioService.this.mSoundPoolLooper.quit();
                        AudioService.this.mSoundPoolLooper = null;
                    }
                    AudioService.this.mSoundPoolListenerThread = null;
                    AudioService.this.mSoundPool.release();
                    AudioService.this.mSoundPool = null;
                    return false;
                }
                int[] poolId = new int[SOUND_EFFECT_FILES.size()];
                for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.size(); ++fileIdx) {
                    poolId[fileIdx] = -1;
                }
                int numSamples = 0;
                for (effect = 0; effect < 10; ++effect) {
                    if (AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1] == 0) continue;
                    if (poolId[AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]] == -1) {
                        String filePath = this.getSoundEffectFilePath(effect);
                        int sampleId = AudioService.this.mSoundPool.load(filePath, 0);
                        if (sampleId <= 0) {
                            Log.w(AudioService.TAG, "Soundpool could not load file: " + filePath);
                            continue;
                        }
                        ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = sampleId;
                        poolId[((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][0]] = sampleId;
                        ++numSamples;
                        continue;
                    }
                    ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = poolId[AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]];
                }
                if (numSamples > 0) {
                    AudioService.this.mSoundPoolCallBack.setSamples(poolId);
                    attempts = 3;
                    status = 1;
                    while (status == 1 && attempts-- > 0) {
                        try {
                            AudioService.this.mSoundEffectsLock.wait(5000L);
                            status = AudioService.this.mSoundPoolCallBack.status();
                        }
                        catch (InterruptedException e) {
                            Log.w(AudioService.TAG, "Interrupted while waiting sound pool callback.");
                        }
                    }
                } else {
                    status = -1;
                }
                if (AudioService.this.mSoundPoolLooper != null) {
                    AudioService.this.mSoundPoolLooper.quit();
                    AudioService.this.mSoundPoolLooper = null;
                }
                AudioService.this.mSoundPoolListenerThread = null;
                if (status != 0) {
                    Log.w(AudioService.TAG, "onLoadSoundEffects(), Error " + status + " while loading samples");
                    for (effect = 0; effect < 10; ++effect) {
                        if (AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1] <= 0) continue;
                        ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                    }
                    AudioService.this.mSoundPool.release();
                    AudioService.this.mSoundPool = null;
                }
            }
            return status == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onUnloadSoundEffects() {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                int[] poolId = new int[SOUND_EFFECT_FILES.size()];
                for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.size(); ++fileIdx) {
                    poolId[fileIdx] = 0;
                }
                for (int effect = 0; effect < 10; ++effect) {
                    if (AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1] <= 0 || poolId[AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]] != 0) continue;
                    AudioService.this.mSoundPool.unload(AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1]);
                    ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                    poolId[((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][0]] = -1;
                }
                AudioService.this.mSoundPool.release();
                AudioService.this.mSoundPool = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPlaySoundEffect(int effectType, int volume) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                this.onLoadSoundEffects();
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                float volFloat = volume < 0 ? (float)Math.pow(10.0, (float)sSoundEffectVolumeDb / 20.0f) : (float)volume / 1000.0f;
                if (AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1] > 0) {
                    AudioService.this.mSoundPool.play(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1], volFloat, volFloat, 0, 0, 1.0f);
                } else {
                    MediaPlayer mediaPlayer = new MediaPlayer();
                    try {
                        String filePath = this.getSoundEffectFilePath(effectType);
                        mediaPlayer.setDataSource(filePath);
                        mediaPlayer.setAudioStreamType(1);
                        mediaPlayer.prepare();
                        mediaPlayer.setVolume(volFloat);
                        mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                            @Override
                            public void onCompletion(MediaPlayer mp) {
                                AudioHandler.this.cleanupPlayer(mp);
                            }
                        });
                        mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                            @Override
                            public boolean onError(MediaPlayer mp, int what, int extra) {
                                AudioHandler.this.cleanupPlayer(mp);
                                return true;
                            }
                        });
                        mediaPlayer.start();
                    }
                    catch (IOException ex) {
                        Log.w(AudioService.TAG, "MediaPlayer IOException: " + ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Log.w(AudioService.TAG, "MediaPlayer IllegalArgumentException: " + ex);
                    }
                    catch (IllegalStateException ex) {
                        Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                    }
                }
            }
        }

        private void cleanupPlayer(MediaPlayer mp) {
            if (mp != null) {
                try {
                    mp.stop();
                    mp.release();
                }
                catch (IllegalStateException ex) {
                    Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setForceUse(int usage, int config, String eventSource) {
            ArrayMap arrayMap = AudioService.this.mConnectedDevices;
            synchronized (arrayMap) {
                AudioService.this.setForceUseInt_SyncDevices(usage, config, eventSource);
            }
        }

        private void onPersistSafeVolumeState(int state) {
            Settings.Global.putInt(AudioService.this.mContentResolver, "audio_safe_volume_state", state);
        }

        private void onNotifyVolumeEvent(IAudioPolicyCallback apc, int direction) {
            try {
                apc.notifyVolumeAdjust(direction);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    AudioService.this.setDeviceVolume((VolumeStreamState)msg.obj, msg.arg1);
                    break;
                }
                case 10: {
                    this.setAllVolumes((VolumeStreamState)msg.obj);
                    break;
                }
                case 1: {
                    this.persistVolume((VolumeStreamState)msg.obj, msg.arg1);
                    break;
                }
                case 3: {
                    this.persistRingerMode(AudioService.this.getRingerModeInternal());
                    break;
                }
                case 4: {
                    AudioService.this.onAudioServerDied();
                    break;
                }
                case 29: {
                    AudioService.this.onDispatchAudioServerStateChange(msg.arg1 == 1);
                    break;
                }
                case 20: {
                    this.onUnloadSoundEffects();
                    break;
                }
                case 7: {
                    LoadSoundEffectReply reply;
                    boolean loaded = this.onLoadSoundEffects();
                    if (msg.obj == null) break;
                    LoadSoundEffectReply loadSoundEffectReply = reply = (LoadSoundEffectReply)msg.obj;
                    synchronized (loadSoundEffectReply) {
                        reply.mStatus = loaded ? 0 : -1;
                        reply.notify();
                        break;
                    }
                }
                case 5: {
                    this.onPlaySoundEffect(msg.arg1, msg.arg2);
                    break;
                }
                case 106: {
                    ArrayMap reply = AudioService.this.mConnectedDevices;
                    synchronized (reply) {
                        AudioService.this.makeA2dpDeviceUnavailableNow((String)msg.obj);
                    }
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 8: 
                case 13: {
                    this.setForceUse(msg.arg1, msg.arg2, (String)msg.obj);
                    break;
                }
                case 9: {
                    AudioService.this.resetBluetoothSco();
                    break;
                }
                case 100: {
                    WiredDeviceConnectionState connectState = (WiredDeviceConnectionState)msg.obj;
                    AudioService.this.mDeviceLogger.log(new AudioServiceEvents.WiredDevConnectEvent(connectState));
                    AudioService.this.onSetWiredDeviceConnectionState(connectState.mType, connectState.mState, connectState.mAddress, connectState.mName, connectState.mCaller);
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 101: {
                    AudioService.this.onSetA2dpSourceConnectionState((BluetoothDevice)msg.obj, msg.arg1);
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 102: {
                    AudioService.this.onSetA2dpSinkConnectionState((BluetoothDevice)msg.obj, msg.arg1, msg.arg2);
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 105: {
                    AudioService.this.onSetHearingAidConnectionState((BluetoothDevice)msg.obj, msg.arg1);
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 103: {
                    AudioService.this.onBluetoothA2dpDeviceConfigChange((BluetoothDevice)msg.obj);
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 104: {
                    AudioService.this.mPlaybackMonitor.disableAudioForUid(msg.arg1 == 1, msg.arg2);
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 12: {
                    int N = AudioService.this.mRoutesObservers.beginBroadcast();
                    if (N > 0) {
                        AudioRoutesInfo routes;
                        AudioRoutesInfo audioRoutesInfo = AudioService.this.mCurAudioRoutes;
                        synchronized (audioRoutesInfo) {
                            routes = new AudioRoutesInfo(AudioService.this.mCurAudioRoutes);
                        }
                        while (N > 0) {
                            IAudioRoutesObserver obs = AudioService.this.mRoutesObservers.getBroadcastItem(--N);
                            try {
                                obs.dispatchAudioRoutesChanged(routes);
                            }
                            catch (RemoteException remoteException) {}
                        }
                    }
                    AudioService.this.mRoutesObservers.finishBroadcast();
                    AudioService.this.observeDevicesForStreams(-1);
                    break;
                }
                case 14: {
                    AudioService.this.onCheckMusicActive((String)msg.obj);
                    break;
                }
                case 15: {
                    AudioService.this.onSendBecomingNoisyIntent();
                    break;
                }
                case 16: 
                case 17: {
                    AudioService.this.onConfigureSafeVolume(msg.what == 17, (String)msg.obj);
                    break;
                }
                case 18: {
                    this.onPersistSafeVolumeState(msg.arg1);
                    break;
                }
                case 19: {
                    AudioService.this.onBroadcastScoConnectionState(msg.arg1);
                    break;
                }
                case 21: {
                    AudioService.this.onSystemReady();
                    break;
                }
                case 26: {
                    AudioService.this.onIndicateSystemReady();
                    break;
                }
                case 27: {
                    AudioService.this.onAccessoryPlugMediaUnmute(msg.arg1);
                    break;
                }
                case 22: {
                    int musicActiveMs = msg.arg1;
                    Settings.Secure.putIntForUser(AudioService.this.mContentResolver, "unsafe_volume_music_active_ms", musicActiveMs, -2);
                    break;
                }
                case 24: {
                    AudioService.this.onUnmuteStream(msg.arg1, msg.arg2);
                    break;
                }
                case 25: {
                    AudioService.this.onDynPolicyMixStateUpdate((String)msg.obj, msg.arg1);
                    break;
                }
                case 28: {
                    this.onNotifyVolumeEvent((IAudioPolicyCallback)msg.obj, msg.arg1);
                    break;
                }
                case 30: {
                    AudioService.this.onEnableSurroundFormats((ArrayList)msg.obj);
                }
            }
        }
    }

    private class AudioSystemThread
    extends Thread {
        AudioSystemThread() {
            super(AudioService.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            AudioService audioService = AudioService.this;
            synchronized (audioService) {
                AudioService.this.mAudioHandler = new AudioHandler();
                AudioService.this.notify();
            }
            Looper.loop();
        }
    }

    public class VolumeStreamState {
        private final int mStreamType;
        private int mIndexMin;
        private int mIndexMax;
        private boolean mIsMuted;
        private String mVolumeIndexSettingName;
        private int mObservedDevices;
        private final SparseIntArray mIndexMap = new SparseIntArray(8);
        private final Intent mVolumeChanged;
        private final Intent mStreamDevicesChanged;

        private VolumeStreamState(String settingName, int streamType) {
            this.mVolumeIndexSettingName = settingName;
            this.mStreamType = streamType;
            this.mIndexMin = MIN_STREAM_VOLUME[streamType] * 10;
            this.mIndexMax = MAX_STREAM_VOLUME[streamType] * 10;
            AudioSystem.initStreamVolume(streamType, this.mIndexMin / 10, this.mIndexMax / 10);
            this.readSettings();
            this.mVolumeChanged = new Intent("android.media.VOLUME_CHANGED_ACTION");
            this.mVolumeChanged.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", this.mStreamType);
            this.mStreamDevicesChanged = new Intent("android.media.STREAM_DEVICES_CHANGED_ACTION");
            this.mStreamDevicesChanged.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", this.mStreamType);
        }

        public int observeDevicesForStream_syncVSS(boolean checkOthers) {
            int devices = AudioSystem.getDevicesForStream(this.mStreamType);
            if (devices == this.mObservedDevices) {
                return devices;
            }
            int prevDevices = this.mObservedDevices;
            this.mObservedDevices = devices;
            if (checkOthers) {
                AudioService.this.observeDevicesForStreams(this.mStreamType);
            }
            if (mStreamVolumeAlias[this.mStreamType] == this.mStreamType) {
                EventLogTags.writeStreamDevicesChanged(this.mStreamType, prevDevices, devices);
            }
            AudioService.this.sendBroadcastToAll(this.mStreamDevicesChanged.putExtra("android.media.EXTRA_PREV_VOLUME_STREAM_DEVICES", prevDevices).putExtra("android.media.EXTRA_VOLUME_STREAM_DEVICES", devices));
            return devices;
        }

        public String getSettingNameForDevice(int device) {
            if (!this.hasValidSettingsName()) {
                return null;
            }
            String suffix = AudioSystem.getOutputDeviceName(device);
            if (suffix.isEmpty()) {
                return this.mVolumeIndexSettingName;
            }
            return this.mVolumeIndexSettingName + "_" + suffix;
        }

        private boolean hasValidSettingsName() {
            return this.mVolumeIndexSettingName != null && !this.mVolumeIndexSettingName.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void readSettings() {
            Class<VolumeStreamState> clazz = AudioService.this.mSettingsLock;
            // MONITORENTER : clazz
            Class<VolumeStreamState> clazz2 = VolumeStreamState.class;
            // MONITORENTER : com.android.server.audio.AudioService$VolumeStreamState.class
            if (AudioService.this.mUseFixedVolume) {
                this.mIndexMap.put(0x40000000, this.mIndexMax);
                // MONITOREXIT : clazz2
                // MONITOREXIT : clazz
                return;
            }
            if (this.mStreamType == 1 || this.mStreamType == 7) {
                int index = 10 * AudioSystem.DEFAULT_STREAM_VOLUME[this.mStreamType];
                if (AudioService.this.mCameraSoundForced) {
                    index = this.mIndexMax;
                }
                this.mIndexMap.put(0x40000000, index);
                // MONITOREXIT : clazz2
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz2
            // MONITOREXIT : clazz
            clazz = VolumeStreamState.class;
            // MONITORENTER : com.android.server.audio.AudioService$VolumeStreamState.class
            int remainingDevices = 0x4FFFFFFF;
            int i = 0;
            while (true) {
                if (remainingDevices == 0) {
                    // MONITOREXIT : clazz
                    return;
                }
                int device = 1 << i;
                if ((device & remainingDevices) != 0) {
                    int index;
                    int defaultIndex;
                    remainingDevices &= ~device;
                    int n = defaultIndex = device == 0x40000000 ? AudioSystem.DEFAULT_STREAM_VOLUME[this.mStreamType] : -1;
                    if (!this.hasValidSettingsName()) {
                        index = defaultIndex;
                    } else {
                        String name = this.getSettingNameForDevice(device);
                        index = Settings.System.getIntForUser(AudioService.this.mContentResolver, name, defaultIndex, -2);
                    }
                    if (index != -1) {
                        this.mIndexMap.put(device, this.getValidIndex(10 * index));
                    }
                }
                ++i;
            }
        }

        private int getAbsoluteVolumeIndex(int index) {
            index = index == 0 ? 0 : (index == 1 ? (int)((double)this.mIndexMax * 0.5) / 10 : (index == 2 ? (int)((double)this.mIndexMax * 0.7) / 10 : (index == 3 ? (int)((double)this.mIndexMax * 0.85) / 10 : (this.mIndexMax + 5) / 10)));
            return index;
        }

        public void applyDeviceVolume_syncVSS(int device) {
            int index = this.mIsMuted ? 0 : ((device & 0x380) != 0 && AudioService.this.mAvrcpAbsVolSupported ? this.getAbsoluteVolumeIndex((this.getIndex(device) + 5) / 10) : ((device & AudioService.this.mFullVolumeDevices) != 0 ? (this.mIndexMax + 5) / 10 : ((device & 0x8000000) != 0 ? (this.mIndexMax + 5) / 10 : (this.getIndex(device) + 5) / 10)));
            AudioSystem.setStreamVolumeIndex(this.mStreamType, index, device);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyAllVolumes() {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                int index;
                for (int i = 0; i < this.mIndexMap.size(); ++i) {
                    int device = this.mIndexMap.keyAt(i);
                    if (device == 0x40000000) continue;
                    index = this.mIsMuted ? 0 : ((device & 0x380) != 0 && AudioService.this.mAvrcpAbsVolSupported ? this.getAbsoluteVolumeIndex((this.getIndex(device) + 5) / 10) : ((device & AudioService.this.mFullVolumeDevices) != 0 ? (this.mIndexMax + 5) / 10 : ((device & 0x8000000) != 0 ? (this.mIndexMax + 5) / 10 : (this.mIndexMap.valueAt(i) + 5) / 10)));
                    AudioSystem.setStreamVolumeIndex(this.mStreamType, index, device);
                }
                index = this.mIsMuted ? 0 : (this.getIndex(0x40000000) + 5) / 10;
                AudioSystem.setStreamVolumeIndex(this.mStreamType, index, 0x40000000);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public boolean adjustIndex(int deltaIndex, int device, String caller) {
            return this.setIndex(this.getIndex(device) + deltaIndex, device, caller);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setIndex(int index, int device, String caller) {
            boolean changed;
            int oldIndex;
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                Class<VolumeStreamState> clazz = VolumeStreamState.class;
                synchronized (VolumeStreamState.class) {
                    oldIndex = this.getIndex(device);
                    index = this.getValidIndex(index);
                    if (this.mStreamType == 7 && AudioService.this.mCameraSoundForced) {
                        index = this.mIndexMax;
                    }
                    this.mIndexMap.put(device, index);
                    changed = oldIndex != index;
                    boolean isCurrentDevice = device == AudioService.this.getDeviceForStream(this.mStreamType);
                    int numStreamTypes = AudioSystem.getNumStreamTypes();
                    for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                        VolumeStreamState aliasStreamState = AudioService.this.mStreamStates[streamType];
                        if (streamType == this.mStreamType || mStreamVolumeAlias[streamType] != this.mStreamType || !changed && aliasStreamState.hasIndexForDevice(device)) continue;
                        int scaledIndex = AudioService.this.rescaleIndex(index, this.mStreamType, streamType);
                        aliasStreamState.setIndex(scaledIndex, device, caller);
                        if (!isCurrentDevice) continue;
                        aliasStreamState.setIndex(scaledIndex, AudioService.this.getDeviceForStream(streamType), caller);
                    }
                    if (changed && this.mStreamType == 2 && device == 2) {
                        for (int i = 0; i < this.mIndexMap.size(); ++i) {
                            int otherDevice = this.mIndexMap.keyAt(i);
                            if ((otherDevice & 0x70) == 0) continue;
                            this.mIndexMap.put(otherDevice, index);
                        }
                    }
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                }
            }
            {
                if (changed) {
                    oldIndex = (oldIndex + 5) / 10;
                    index = (index + 5) / 10;
                    if (mStreamVolumeAlias[this.mStreamType] == this.mStreamType) {
                        if (caller == null) {
                            Log.w(AudioService.TAG, "No caller for volume_changed event", new Throwable());
                        }
                        EventLogTags.writeVolumeChanged(this.mStreamType, oldIndex, index, this.mIndexMax / 10, caller);
                    }
                    this.mVolumeChanged.putExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", index);
                    this.mVolumeChanged.putExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", oldIndex);
                    this.mVolumeChanged.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE_ALIAS", mStreamVolumeAlias[this.mStreamType]);
                    AudioService.this.sendBroadcastToAll(this.mVolumeChanged);
                }
                return changed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIndex(int device) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                int index = this.mIndexMap.get(device, -1);
                if (index == -1) {
                    index = this.mIndexMap.get(0x40000000);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return index;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasIndexForDevice(int device) {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.mIndexMap.get(device, -1) != -1;
            }
        }

        public int getMaxIndex() {
            return this.mIndexMax;
        }

        public int getMinIndex() {
            return this.mIndexMin;
        }

        @GuardedBy(value="VolumeStreamState.class")
        public void refreshRange(int sourceStreamType) {
            this.mIndexMin = MIN_STREAM_VOLUME[sourceStreamType] * 10;
            this.mIndexMax = MAX_STREAM_VOLUME[sourceStreamType] * 10;
            for (int i = 0; i < this.mIndexMap.size(); ++i) {
                int device = this.mIndexMap.keyAt(i);
                int index = this.mIndexMap.valueAt(i);
                this.mIndexMap.put(device, this.getValidIndex(index));
            }
        }

        @GuardedBy(value="VolumeStreamState.class")
        public void setAllIndexes(VolumeStreamState srcStream, String caller) {
            if (this.mStreamType == srcStream.mStreamType) {
                return;
            }
            int srcStreamType = srcStream.getStreamType();
            int index = srcStream.getIndex(0x40000000);
            index = AudioService.this.rescaleIndex(index, srcStreamType, this.mStreamType);
            for (int i = 0; i < this.mIndexMap.size(); ++i) {
                this.mIndexMap.put(this.mIndexMap.keyAt(i), index);
            }
            SparseIntArray srcMap = srcStream.mIndexMap;
            for (int i = 0; i < srcMap.size(); ++i) {
                int device = srcMap.keyAt(i);
                index = srcMap.valueAt(i);
                index = AudioService.this.rescaleIndex(index, srcStreamType, this.mStreamType);
                this.setIndex(index, device, caller);
            }
        }

        @GuardedBy(value="VolumeStreamState.class")
        public void setAllIndexesToMax() {
            for (int i = 0; i < this.mIndexMap.size(); ++i) {
                this.mIndexMap.put(this.mIndexMap.keyAt(i), this.mIndexMax);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mute(boolean state) {
            boolean changed = false;
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                if (state != this.mIsMuted) {
                    changed = true;
                    this.mIsMuted = state;
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 10, 2, 0, 0, this, 0);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (changed) {
                    Intent intent = new Intent("android.media.STREAM_MUTE_CHANGED_ACTION");
                    intent.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", this.mStreamType);
                    intent.putExtra("android.media.EXTRA_STREAM_VOLUME_MUTED", state);
                    AudioService.this.sendBroadcastToAll(intent);
                }
                return;
            }
        }

        public int getStreamType() {
            return this.mStreamType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkFixedVolumeDevices() {
            Class<VolumeStreamState> clazz = VolumeStreamState.class;
            synchronized (VolumeStreamState.class) {
                if (mStreamVolumeAlias[this.mStreamType] == 3) {
                    for (int i = 0; i < this.mIndexMap.size(); ++i) {
                        int device = this.mIndexMap.keyAt(i);
                        int index = this.mIndexMap.valueAt(i);
                        if ((device & AudioService.this.mFullVolumeDevices) != 0 || (device & AudioService.this.mFixedVolumeDevices) != 0 && index != 0) {
                            this.mIndexMap.put(device, this.mIndexMax);
                        }
                        this.applyDeviceVolume_syncVSS(device);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private int getValidIndex(int index) {
            if (index < this.mIndexMin) {
                return this.mIndexMin;
            }
            if (AudioService.this.mUseFixedVolume || index > this.mIndexMax) {
                return this.mIndexMax;
            }
            return index;
        }

        private void dump(PrintWriter pw) {
            int device;
            pw.print("   Muted: ");
            pw.println(this.mIsMuted);
            pw.print("   Min: ");
            pw.println((this.mIndexMin + 5) / 10);
            pw.print("   Max: ");
            pw.println((this.mIndexMax + 5) / 10);
            pw.print("   Current: ");
            for (int i = 0; i < this.mIndexMap.size(); ++i) {
                String deviceName;
                if (i > 0) {
                    pw.print(", ");
                }
                device = this.mIndexMap.keyAt(i);
                pw.print(Integer.toHexString(device));
                String string2 = deviceName = device == 0x40000000 ? "default" : AudioSystem.getOutputDeviceName(device);
                if (!deviceName.isEmpty()) {
                    pw.print(" (");
                    pw.print(deviceName);
                    pw.print(")");
                }
                pw.print(": ");
                int index = (this.mIndexMap.valueAt(i) + 5) / 10;
                pw.print(index);
            }
            pw.println();
            pw.print("   Devices: ");
            int devices = AudioService.this.getDevicesForStream(this.mStreamType);
            int i = 0;
            int n = 0;
            while ((device = 1 << i) != 0x40000000) {
                if ((devices & device) != 0) {
                    if (n++ > 0) {
                        pw.print(", ");
                    }
                    pw.print(AudioSystem.getOutputDeviceName(device));
                }
                ++i;
            }
        }
    }

    class WiredDeviceConnectionState {
        public final int mType;
        public final int mState;
        public final String mAddress;
        public final String mName;
        public final String mCaller;

        public WiredDeviceConnectionState(int type, int state, String address, String name, String caller) {
            this.mType = type;
            this.mState = state;
            this.mAddress = address;
            this.mName = name;
            this.mCaller = caller;
        }
    }

    private class ScoClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mCreatorPid;
        private int mStartcount;

        ScoClient(IBinder cb) {
            this.mCb = cb;
            this.mCreatorPid = Binder.getCallingPid();
            this.mStartcount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                Log.w(AudioService.TAG, "SCO client died");
                int index = AudioService.this.mScoClients.indexOf(this);
                if (index < 0) {
                    Log.w(AudioService.TAG, "unregistered SCO client died");
                } else {
                    this.clearCount(true);
                    AudioService.this.mScoClients.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incCount(int scoAudioMode) {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                this.requestScoState(12, scoAudioMode);
                if (this.mStartcount == 0) {
                    try {
                        this.mCb.linkToDeath(this, 0);
                    }
                    catch (RemoteException e) {
                        Log.w(AudioService.TAG, "ScoClient  incCount() could not link to " + this.mCb + " binder death");
                    }
                }
                ++this.mStartcount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount == 0) {
                    Log.w(AudioService.TAG, "ScoClient.decCount() already 0");
                } else {
                    --this.mStartcount;
                    if (this.mStartcount == 0) {
                        try {
                            this.mCb.unlinkToDeath(this, 0);
                        }
                        catch (NoSuchElementException e) {
                            Log.w(AudioService.TAG, "decCount() going to 0 but not registered to binder");
                        }
                    }
                    this.requestScoState(10, 0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCount(boolean stopSco) {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount != 0) {
                    try {
                        this.mCb.unlinkToDeath(this, 0);
                    }
                    catch (NoSuchElementException e) {
                        Log.w(AudioService.TAG, "clearCount() mStartcount: " + this.mStartcount + " != 0 but not registered to binder");
                    }
                }
                this.mStartcount = 0;
                if (stopSco) {
                    this.requestScoState(10, 0);
                }
            }
        }

        public int getCount() {
            return this.mStartcount;
        }

        public IBinder getBinder() {
            return this.mCb;
        }

        public int getPid() {
            return this.mCreatorPid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int totalCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int count = 0;
                for (ScoClient mScoClient : AudioService.this.mScoClients) {
                    count += mScoClient.getCount();
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void requestScoState(int state, int scoAudioMode) {
            AudioService.this.checkScoAudioState();
            int clientCount = this.totalCount();
            if (clientCount != 0) {
                Log.i(AudioService.TAG, "requestScoState: state=" + state + ", scoAudioMode=" + scoAudioMode + ", clientCount=" + clientCount);
                return;
            }
            if (state == 12) {
                AudioService.this.broadcastScoConnectionState(2);
                ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
                synchronized (arrayList) {
                    int modeOwnerPid;
                    int n = modeOwnerPid = AudioService.this.mSetModeDeathHandlers.isEmpty() ? 0 : ((SetModeDeathHandler)AudioService.this.mSetModeDeathHandlers.get(0)).getPid();
                    if (modeOwnerPid != 0 && modeOwnerPid != this.mCreatorPid) {
                        Log.w(AudioService.TAG, "requestScoState: audio mode is not NORMAL and modeOwnerPid " + modeOwnerPid + " != creatorPid " + this.mCreatorPid);
                        AudioService.this.broadcastScoConnectionState(0);
                        return;
                    }
                    switch (AudioService.this.mScoAudioState) {
                        case 0: {
                            AudioService.this.mScoAudioMode = scoAudioMode;
                            if (scoAudioMode == -1) {
                                AudioService.this.mScoAudioMode = 0;
                                if (AudioService.this.mBluetoothHeadsetDevice != null) {
                                    AudioService.this.mScoAudioMode = Settings.Global.getInt(AudioService.this.mContentResolver, "bluetooth_sco_channel_" + AudioService.this.mBluetoothHeadsetDevice.getAddress(), 0);
                                    if (AudioService.this.mScoAudioMode > 2 || AudioService.this.mScoAudioMode < 0) {
                                        AudioService.this.mScoAudioMode = 0;
                                    }
                                }
                            }
                            if (AudioService.this.mBluetoothHeadset == null) {
                                if (AudioService.this.getBluetoothHeadset()) {
                                    AudioService.this.mScoAudioState = 1;
                                    break;
                                }
                                Log.w(AudioService.TAG, "requestScoState: getBluetoothHeadset failed during connection, mScoAudioMode=" + AudioService.this.mScoAudioMode);
                                AudioService.this.broadcastScoConnectionState(0);
                                break;
                            }
                            if (AudioService.this.mBluetoothHeadsetDevice == null) {
                                Log.w(AudioService.TAG, "requestScoState: no active device while connecting, mScoAudioMode=" + AudioService.this.mScoAudioMode);
                                AudioService.this.broadcastScoConnectionState(0);
                                break;
                            }
                            if (AudioService.connectBluetoothScoAudioHelper(AudioService.this.mBluetoothHeadset, AudioService.this.mBluetoothHeadsetDevice, AudioService.this.mScoAudioMode)) {
                                AudioService.this.mScoAudioState = 3;
                                break;
                            }
                            Log.w(AudioService.TAG, "requestScoState: connect to " + AudioService.this.mBluetoothHeadsetDevice + " failed, mScoAudioMode=" + AudioService.this.mScoAudioMode);
                            AudioService.this.broadcastScoConnectionState(0);
                            break;
                        }
                        case 5: {
                            AudioService.this.mScoAudioState = 1;
                            break;
                        }
                        case 4: {
                            AudioService.this.mScoAudioState = 3;
                            AudioService.this.broadcastScoConnectionState(1);
                            break;
                        }
                        default: {
                            Log.w(AudioService.TAG, "requestScoState: failed to connect in state " + AudioService.this.mScoAudioState + ", scoAudioMode=" + scoAudioMode);
                            AudioService.this.broadcastScoConnectionState(0);
                        }
                    }
                }
            } else if (state == 10) {
                switch (AudioService.this.mScoAudioState) {
                    case 3: {
                        if (AudioService.this.mBluetoothHeadset == null) {
                            if (AudioService.this.getBluetoothHeadset()) {
                                AudioService.this.mScoAudioState = 4;
                                break;
                            }
                            Log.w(AudioService.TAG, "requestScoState: getBluetoothHeadset failed during disconnection, mScoAudioMode=" + AudioService.this.mScoAudioMode);
                            AudioService.this.mScoAudioState = 0;
                            AudioService.this.broadcastScoConnectionState(0);
                            break;
                        }
                        if (AudioService.this.mBluetoothHeadsetDevice == null) {
                            AudioService.this.mScoAudioState = 0;
                            AudioService.this.broadcastScoConnectionState(0);
                            break;
                        }
                        if (AudioService.disconnectBluetoothScoAudioHelper(AudioService.this.mBluetoothHeadset, AudioService.this.mBluetoothHeadsetDevice, AudioService.this.mScoAudioMode)) {
                            AudioService.this.mScoAudioState = 5;
                            break;
                        }
                        AudioService.this.mScoAudioState = 0;
                        AudioService.this.broadcastScoConnectionState(0);
                        break;
                    }
                    case 1: {
                        AudioService.this.mScoAudioState = 0;
                        AudioService.this.broadcastScoConnectionState(0);
                        break;
                    }
                    default: {
                        Log.w(AudioService.TAG, "requestScoState: failed to disconnect in state " + AudioService.this.mScoAudioState + ", scoAudioMode=" + scoAudioMode);
                        AudioService.this.broadcastScoConnectionState(0);
                    }
                }
            }
        }
    }

    private final class SoundPoolCallback
    implements SoundPool.OnLoadCompleteListener {
        int mStatus = 1;
        List<Integer> mSamples = new ArrayList<Integer>();

        private SoundPoolCallback() {
        }

        public int status() {
            return this.mStatus;
        }

        public void setSamples(int[] samples) {
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] <= 0) continue;
                this.mSamples.add(samples[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                int i = this.mSamples.indexOf(sampleId);
                if (i >= 0) {
                    this.mSamples.remove(i);
                }
                if (status != 0 || this.mSamples.isEmpty()) {
                    this.mStatus = status;
                    AudioService.this.mSoundEffectsLock.notify();
                }
            }
        }
    }

    class SoundPoolListenerThread
    extends Thread {
        public SoundPoolListenerThread() {
            super("SoundPoolListenerThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            AudioService.this.mSoundPoolLooper = Looper.myLooper();
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool != null) {
                    AudioService.this.mSoundPoolCallBack = new SoundPoolCallback();
                    AudioService.this.mSoundPool.setOnLoadCompleteListener(AudioService.this.mSoundPoolCallBack);
                }
                AudioService.this.mSoundEffectsLock.notify();
            }
            Looper.loop();
        }
    }

    class LoadSoundEffectReply {
        public int mStatus = 1;

        LoadSoundEffectReply() {
        }
    }

    private class SetModeDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mPid;
        private int mMode = 0;

        SetModeDeathHandler(IBinder cb, int pid) {
            this.mCb = cb;
            this.mPid = pid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            int oldModeOwnerPid = 0;
            int newModeOwnerPid = 0;
            ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
            synchronized (arrayList) {
                int index;
                Log.w(AudioService.TAG, "setMode() client died");
                if (!AudioService.this.mSetModeDeathHandlers.isEmpty()) {
                    oldModeOwnerPid = ((SetModeDeathHandler)AudioService.this.mSetModeDeathHandlers.get(0)).getPid();
                }
                if ((index = AudioService.this.mSetModeDeathHandlers.indexOf(this)) < 0) {
                    Log.w(AudioService.TAG, "unregistered setMode() client died");
                } else {
                    newModeOwnerPid = AudioService.this.setModeInt(0, this.mCb, this.mPid, AudioService.TAG);
                }
            }
            if (newModeOwnerPid != oldModeOwnerPid && newModeOwnerPid != 0) {
                long ident = Binder.clearCallingIdentity();
                AudioService.this.disconnectBluetoothSco(newModeOwnerPid);
                Binder.restoreCallingIdentity(ident);
            }
        }

        public int getPid() {
            return this.mPid;
        }

        public void setMode(int mode) {
            this.mMode = mode;
        }

        public int getMode() {
            return this.mMode;
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private class RmtSbmxFullVolDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mICallback;

        RmtSbmxFullVolDeathHandler(IBinder cb) {
            this.mICallback = cb;
            try {
                cb.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Log.e(AudioService.TAG, "can't link to death", e);
            }
        }

        boolean isHandlerFor(IBinder cb) {
            return this.mICallback.equals(cb);
        }

        void forget() {
            try {
                this.mICallback.unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException e) {
                Log.e(AudioService.TAG, "error unlinking to death", e);
            }
        }

        @Override
        public void binderDied() {
            Log.w(AudioService.TAG, "Recorder with remote submix at full volume died " + this.mICallback);
            AudioService.this.forceRemoteSubmixFullVolume(false, this.mICallback);
        }
    }

    private class ForceControlStreamClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        ForceControlStreamClient(IBinder cb) {
            if (cb != null) {
                try {
                    cb.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    Log.w(AudioService.TAG, "ForceControlStreamClient() could not link to " + cb + " binder death");
                    cb = null;
                }
            }
            this.mCb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = AudioService.this.mForceControlStreamLock;
            synchronized (object) {
                Log.w(AudioService.TAG, "SCO client died");
                if (AudioService.this.mForceControlStreamClient != this) {
                    Log.w(AudioService.TAG, "unregistered control stream client died");
                } else {
                    AudioService.this.mForceControlStreamClient = null;
                    AudioService.this.mVolumeControlStream = -1;
                    AudioService.this.mUserSelectedVolumeControlStream = false;
                }
            }
        }

        public void release() {
            if (this.mCb != null) {
                this.mCb.unlinkToDeath(this, 0);
                this.mCb = null;
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    class StreamVolumeCommand {
        public final int mStreamType;
        public final int mIndex;
        public final int mFlags;
        public final int mDevice;

        StreamVolumeCommand(int streamType, int index, int flags, int device) {
            this.mStreamType = streamType;
            this.mIndex = index;
            this.mFlags = flags;
            this.mDevice = device;
        }

        public String toString() {
            return "{streamType=" + this.mStreamType + ",index=" + this.mIndex + ",flags=" + this.mFlags + ",device=" + this.mDevice + '}';
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private AudioService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new AudioService(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService("audio", this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                this.mService.systemReady();
            }
        }
    }

    private class DeviceListSpec {
        int mDeviceType;
        String mDeviceName;
        String mDeviceAddress;

        public DeviceListSpec(int deviceType, String deviceName, String deviceAddress) {
            this.mDeviceType = deviceType;
            this.mDeviceName = deviceName;
            this.mDeviceAddress = deviceAddress;
        }

        public String toString() {
            return "[type:0x" + Integer.toHexString(this.mDeviceType) + " name:" + this.mDeviceName + " address:" + this.mDeviceAddress + "]";
        }
    }
}

