/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.autofill.IAutofillFieldClassificationService;
import android.util.Log;
import android.util.Slog;
import android.view.autofill.AutofillValue;
import com.android.internal.annotations.GuardedBy;
import com.android.server.autofill.Helper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class FieldClassificationStrategy {
    private static final String TAG = "FieldClassificationStrategy";
    private final Context mContext;
    private final Object mLock = new Object();
    private final int mUserId;
    @GuardedBy(value="mLock")
    private ServiceConnection mServiceConnection;
    @GuardedBy(value="mLock")
    private IAutofillFieldClassificationService mRemoteService;
    @GuardedBy(value="mLock")
    private ArrayList<Command> mQueuedCommands;

    public FieldClassificationStrategy(Context context, int userId) {
        this.mContext = context;
        this.mUserId = userId;
    }

    ServiceInfo getServiceInfo() {
        String packageName = this.mContext.getPackageManager().getServicesSystemSharedLibraryPackageName();
        if (packageName == null) {
            Slog.w(TAG, "no external services package!");
            return null;
        }
        Intent intent = new Intent("android.service.autofill.AutofillFieldClassificationService");
        intent.setPackage(packageName);
        ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveService(intent, 132);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Slog.w(TAG, "No valid components found.");
            return null;
        }
        return resolveInfo.serviceInfo;
    }

    private ComponentName getServiceComponentName() {
        ServiceInfo serviceInfo = this.getServiceInfo();
        if (serviceInfo == null) {
            return null;
        }
        ComponentName name = new ComponentName(serviceInfo.packageName, serviceInfo.name);
        if (!"android.permission.BIND_AUTOFILL_FIELD_CLASSIFICATION_SERVICE".equals(serviceInfo.permission)) {
            Slog.w(TAG, name.flattenToShortString() + " does not require permission " + "android.permission.BIND_AUTOFILL_FIELD_CLASSIFICATION_SERVICE");
            return null;
        }
        if (Helper.sVerbose) {
            Slog.v(TAG, "getServiceComponentName(): " + name);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                if (Helper.sDebug) {
                    Slog.d(TAG, "reset(): unbinding service.");
                }
                this.mContext.unbindService(this.mServiceConnection);
                this.mServiceConnection = null;
            } else if (Helper.sDebug) {
                Slog.d(TAG, "reset(): service is not bound. Do nothing.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndRun(Command command) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRemoteService != null) {
                try {
                    if (Helper.sVerbose) {
                        Slog.v(TAG, "running command right away");
                    }
                    command.run(this.mRemoteService);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "exception calling service: " + e);
                }
                return;
            }
            if (Helper.sDebug) {
                Slog.d(TAG, "service is null; queuing command");
            }
            if (this.mQueuedCommands == null) {
                this.mQueuedCommands = new ArrayList(1);
            }
            this.mQueuedCommands.add(command);
            if (this.mServiceConnection != null) {
                return;
            }
            if (Helper.sVerbose) {
                Slog.v(TAG, "creating connection");
            }
            this.mServiceConnection = new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceConnected(ComponentName name, IBinder service) {
                    if (Helper.sVerbose) {
                        Slog.v(FieldClassificationStrategy.TAG, "onServiceConnected(): " + name);
                    }
                    Object object = FieldClassificationStrategy.this.mLock;
                    synchronized (object) {
                        FieldClassificationStrategy.this.mRemoteService = IAutofillFieldClassificationService.Stub.asInterface(service);
                        if (FieldClassificationStrategy.this.mQueuedCommands != null) {
                            int size = FieldClassificationStrategy.this.mQueuedCommands.size();
                            if (Helper.sDebug) {
                                Slog.d(FieldClassificationStrategy.TAG, "running " + size + " queued commands");
                            }
                            for (int i = 0; i < size; ++i) {
                                Command queuedCommand = (Command)FieldClassificationStrategy.this.mQueuedCommands.get(i);
                                try {
                                    if (Helper.sVerbose) {
                                        Slog.v(FieldClassificationStrategy.TAG, "running queued command #" + i);
                                    }
                                    queuedCommand.run(FieldClassificationStrategy.this.mRemoteService);
                                    continue;
                                }
                                catch (RemoteException e) {
                                    Slog.w(FieldClassificationStrategy.TAG, "exception calling " + name + ": " + e);
                                }
                            }
                            FieldClassificationStrategy.this.mQueuedCommands = null;
                        } else if (Helper.sDebug) {
                            Slog.d(FieldClassificationStrategy.TAG, "no queued commands");
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceDisconnected(ComponentName name) {
                    if (Helper.sVerbose) {
                        Slog.v(FieldClassificationStrategy.TAG, "onServiceDisconnected(): " + name);
                    }
                    Object object = FieldClassificationStrategy.this.mLock;
                    synchronized (object) {
                        FieldClassificationStrategy.this.mRemoteService = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBindingDied(ComponentName name) {
                    if (Helper.sVerbose) {
                        Slog.v(FieldClassificationStrategy.TAG, "onBindingDied(): " + name);
                    }
                    Object object = FieldClassificationStrategy.this.mLock;
                    synchronized (object) {
                        FieldClassificationStrategy.this.mRemoteService = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNullBinding(ComponentName name) {
                    if (Helper.sVerbose) {
                        Slog.v(FieldClassificationStrategy.TAG, "onNullBinding(): " + name);
                    }
                    Object object = FieldClassificationStrategy.this.mLock;
                    synchronized (object) {
                        FieldClassificationStrategy.this.mRemoteService = null;
                    }
                }
            };
            ComponentName component = this.getServiceComponentName();
            if (Helper.sVerbose) {
                Slog.v(TAG, "binding to: " + component);
            }
            if (component != null) {
                Intent intent = new Intent();
                intent.setComponent(component);
                long token = Binder.clearCallingIdentity();
                try {
                    this.mContext.bindServiceAsUser(intent, this.mServiceConnection, 1, UserHandle.of(this.mUserId));
                    if (Helper.sVerbose) {
                        Slog.v(TAG, "bound");
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }
    }

    String[] getAvailableAlgorithms() {
        return this.getMetadataValue("android.autofill.field_classification.available_algorithms", (res, id2) -> res.getStringArray(id2));
    }

    String getDefaultAlgorithm() {
        return this.getMetadataValue("android.autofill.field_classification.default_algorithm", (res, id2) -> res.getString(id2));
    }

    private <T> T getMetadataValue(String field, MetadataParser<T> parser) {
        Resources res;
        ServiceInfo serviceInfo = this.getServiceInfo();
        if (serviceInfo == null) {
            return null;
        }
        PackageManager pm = this.mContext.getPackageManager();
        try {
            res = pm.getResourcesForApplication(serviceInfo.applicationInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Error getting application resources for " + serviceInfo, e);
            return null;
        }
        int resourceId = serviceInfo.metaData.getInt(field);
        return parser.get(res, resourceId);
    }

    void getScores(RemoteCallback callback, String algorithmName, Bundle algorithmArgs, List<AutofillValue> actualValues, String[] userDataValues) {
        this.connectAndRun(service -> service.getScores(callback, algorithmName, algorithmArgs, actualValues, userDataValues));
    }

    void dump(String prefix, PrintWriter pw) {
        ComponentName impl = this.getServiceComponentName();
        pw.print(prefix);
        pw.print("User ID: ");
        pw.println(this.mUserId);
        pw.print(prefix);
        pw.print("Queued commands: ");
        if (this.mQueuedCommands == null) {
            pw.println("N/A");
        } else {
            pw.println(this.mQueuedCommands.size());
        }
        pw.print(prefix);
        pw.print("Implementation: ");
        if (impl == null) {
            pw.println("N/A");
            return;
        }
        pw.println(impl.flattenToShortString());
        pw.print(prefix);
        pw.print("Available algorithms: ");
        pw.println(Arrays.toString(this.getAvailableAlgorithms()));
        pw.print(prefix);
        pw.print("Default algorithm: ");
        pw.println(this.getDefaultAlgorithm());
    }

    private static interface MetadataParser<T> {
        public T get(Resources var1, int var2);
    }

    private static interface Command {
        public void run(IAutofillFieldClassificationService var1) throws RemoteException;
    }
}

