/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.service.autofill.FillRequest;
import android.service.autofill.FillResponse;
import android.service.autofill.IAutoFillService;
import android.service.autofill.IFillCallback;
import android.service.autofill.ISaveCallback;
import android.service.autofill.SaveRequest;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.FgThread;
import com.android.server.autofill.Helper;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;

final class RemoteFillService
implements IBinder.DeathRecipient {
    private static final String LOG_TAG = "RemoteFillService";
    private static final long TIMEOUT_IDLE_BIND_MILLIS = 5000L;
    private static final long TIMEOUT_REMOTE_REQUEST_MILLIS = 5000L;
    private static final int MSG_UNBIND = 3;
    private final Context mContext;
    private final ComponentName mComponentName;
    private final Intent mIntent;
    private final FillServiceCallbacks mCallbacks;
    private final int mUserId;
    private final ServiceConnection mServiceConnection = new RemoteServiceConnection();
    private final Handler mHandler;
    private final boolean mBindInstantServiceAllowed;
    private IAutoFillService mAutoFillService;
    private boolean mBinding;
    private boolean mDestroyed;
    private boolean mServiceDied;
    private boolean mCompleted;
    private PendingRequest mPendingRequest;

    public RemoteFillService(Context context, ComponentName componentName, int userId, FillServiceCallbacks callbacks, boolean bindInstantServiceAllowed) {
        this.mContext = context;
        this.mCallbacks = callbacks;
        this.mComponentName = componentName;
        this.mIntent = new Intent("android.service.autofill.AutofillService").setComponent(this.mComponentName);
        this.mUserId = userId;
        this.mHandler = new Handler(FgThread.getHandler().getLooper());
        this.mBindInstantServiceAllowed = bindInstantServiceAllowed;
    }

    public void destroy() {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(RemoteFillService::handleDestroy, this));
    }

    private void handleDestroy() {
        if (this.checkIfDestroyed()) {
            return;
        }
        if (this.mPendingRequest != null) {
            this.mPendingRequest.cancel();
            this.mPendingRequest = null;
        }
        this.ensureUnbound();
        this.mDestroyed = true;
    }

    @Override
    public void binderDied() {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(RemoteFillService::handleBinderDied, this));
    }

    private void handleBinderDied() {
        if (this.checkIfDestroyed()) {
            return;
        }
        if (this.mAutoFillService != null) {
            this.mAutoFillService.asBinder().unlinkToDeath(this, 0);
        }
        this.mAutoFillService = null;
        this.mServiceDied = true;
        this.mCallbacks.onServiceDied(this);
    }

    public int cancelCurrentRequest() {
        if (this.mDestroyed) {
            return Integer.MIN_VALUE;
        }
        int requestId = Integer.MIN_VALUE;
        if (this.mPendingRequest != null) {
            if (this.mPendingRequest instanceof PendingFillRequest) {
                requestId = ((PendingFillRequest)this.mPendingRequest).mRequest.getId();
            }
            this.mPendingRequest.cancel();
            this.mPendingRequest = null;
        }
        return requestId;
    }

    public void onFillRequest(FillRequest request) {
        this.cancelScheduledUnbind();
        this.scheduleRequest(new PendingFillRequest(request, this));
    }

    public void onSaveRequest(SaveRequest request) {
        this.cancelScheduledUnbind();
        this.scheduleRequest(new PendingSaveRequest(request, this));
    }

    private void scheduleRequest(PendingRequest pendingRequest) {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(RemoteFillService::handlePendingRequest, this, pendingRequest));
    }

    public void dump(String prefix, PrintWriter pw) {
        String tab = "  ";
        pw.append(prefix).append("service:").println();
        pw.append(prefix).append(tab).append("userId=").append(String.valueOf(this.mUserId)).println();
        pw.append(prefix).append(tab).append("componentName=").append(this.mComponentName.flattenToString()).println();
        pw.append(prefix).append(tab).append("destroyed=").append(String.valueOf(this.mDestroyed)).println();
        pw.append(prefix).append(tab).append("bound=").append(String.valueOf(this.isBound())).println();
        pw.append(prefix).append(tab).append("hasPendingRequest=").append(String.valueOf(this.mPendingRequest != null)).println();
        pw.append(prefix).append("mBindInstantServiceAllowed=").println(this.mBindInstantServiceAllowed);
        pw.println();
    }

    private void cancelScheduledUnbind() {
        this.mHandler.removeMessages(3);
    }

    private void scheduleUnbind() {
        this.cancelScheduledUnbind();
        this.mHandler.sendMessageDelayed(PooledLambda.obtainMessage(RemoteFillService::handleUnbind, this).setWhat(3), 5000L);
    }

    private void handleUnbind() {
        if (this.checkIfDestroyed()) {
            return;
        }
        this.ensureUnbound();
    }

    private void handlePendingRequest(PendingRequest pendingRequest) {
        if (this.checkIfDestroyed()) {
            return;
        }
        if (this.mCompleted) {
            return;
        }
        if (!this.isBound()) {
            if (this.mPendingRequest != null) {
                this.mPendingRequest.cancel();
            }
            this.mPendingRequest = pendingRequest;
            this.ensureBound();
        } else {
            if (Helper.sVerbose) {
                Slog.v(LOG_TAG, "[user: " + this.mUserId + "] handlePendingRequest()");
            }
            pendingRequest.run();
            if (pendingRequest.isFinal()) {
                this.mCompleted = true;
            }
        }
    }

    private boolean isBound() {
        return this.mAutoFillService != null;
    }

    private void ensureBound() {
        boolean willBind;
        if (this.isBound() || this.mBinding) {
            return;
        }
        if (Helper.sVerbose) {
            Slog.v(LOG_TAG, "[user: " + this.mUserId + "] ensureBound()");
        }
        this.mBinding = true;
        int flags = 0x4000001;
        if (this.mBindInstantServiceAllowed) {
            flags |= 0x400000;
        }
        if (!(willBind = this.mContext.bindServiceAsUser(this.mIntent, this.mServiceConnection, flags, new UserHandle(this.mUserId)))) {
            Slog.w(LOG_TAG, "[user: " + this.mUserId + "] could not bind to " + this.mIntent + " using flags " + flags);
            this.mBinding = false;
            if (!this.mServiceDied) {
                this.handleBinderDied();
            }
        }
    }

    private void ensureUnbound() {
        if (!this.isBound() && !this.mBinding) {
            return;
        }
        if (Helper.sVerbose) {
            Slog.v(LOG_TAG, "[user: " + this.mUserId + "] ensureUnbound()");
        }
        this.mBinding = false;
        if (this.isBound()) {
            try {
                this.mAutoFillService.onConnectedStateChanged(false);
            }
            catch (Exception e) {
                Slog.w(LOG_TAG, "Exception calling onDisconnected(): " + e);
            }
            if (this.mAutoFillService != null) {
                this.mAutoFillService.asBinder().unlinkToDeath(this, 0);
                this.mAutoFillService = null;
            }
        }
        this.mContext.unbindService(this.mServiceConnection);
    }

    private void dispatchOnFillRequestSuccess(PendingFillRequest pendingRequest, FillResponse response, int requestFlags) {
        this.mHandler.post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onFillRequestSuccess(pendingRequest.mRequest.getId(), response, this.mComponentName.getPackageName(), requestFlags);
            }
        });
    }

    private void dispatchOnFillRequestFailure(PendingFillRequest pendingRequest, CharSequence message) {
        this.mHandler.post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onFillRequestFailure(pendingRequest.mRequest.getId(), message, this.mComponentName.getPackageName());
            }
        });
    }

    private void dispatchOnFillRequestTimeout(PendingFillRequest pendingRequest) {
        this.mHandler.post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onFillRequestTimeout(pendingRequest.mRequest.getId(), this.mComponentName.getPackageName());
            }
        });
    }

    private void dispatchOnFillTimeout(ICancellationSignal cancellationSignal) {
        this.mHandler.post(() -> {
            try {
                cancellationSignal.cancel();
            }
            catch (RemoteException e) {
                Slog.w(LOG_TAG, "Error calling cancellation signal: " + e);
            }
        });
    }

    private void dispatchOnSaveRequestSuccess(PendingRequest pendingRequest, IntentSender intentSender) {
        this.mHandler.post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onSaveRequestSuccess(this.mComponentName.getPackageName(), intentSender);
            }
        });
    }

    private void dispatchOnSaveRequestFailure(PendingRequest pendingRequest, CharSequence message) {
        this.mHandler.post(() -> {
            if (this.handleResponseCallbackCommon(pendingRequest)) {
                this.mCallbacks.onSaveRequestFailure(message, this.mComponentName.getPackageName());
            }
        });
    }

    private boolean handleResponseCallbackCommon(PendingRequest pendingRequest) {
        if (this.mDestroyed) {
            return false;
        }
        if (this.mPendingRequest == pendingRequest) {
            this.mPendingRequest = null;
        }
        if (this.mPendingRequest == null) {
            this.scheduleUnbind();
        }
        return true;
    }

    private boolean checkIfDestroyed() {
        if (this.mDestroyed && Helper.sVerbose) {
            Slog.v(LOG_TAG, "Not handling operation as service for " + this.mComponentName + " is already destroyed");
        }
        return this.mDestroyed;
    }

    private static final class PendingSaveRequest
    extends PendingRequest {
        private final SaveRequest mRequest;
        private final ISaveCallback mCallback;

        public PendingSaveRequest(SaveRequest request, RemoteFillService service) {
            super(service);
            this.mRequest = request;
            this.mCallback = new ISaveCallback.Stub(){

                @Override
                public void onSuccess(IntentSender intentSender) {
                    if (!this.finish()) {
                        return;
                    }
                    RemoteFillService remoteService = this.getService();
                    if (remoteService != null) {
                        remoteService.dispatchOnSaveRequestSuccess(this, intentSender);
                    }
                }

                @Override
                public void onFailure(CharSequence message) {
                    if (!this.finish()) {
                        return;
                    }
                    RemoteFillService remoteService = this.getService();
                    if (remoteService != null) {
                        remoteService.dispatchOnSaveRequestFailure(this, message);
                    }
                }
            };
        }

        @Override
        void onTimeout(RemoteFillService remoteService) {
            remoteService.dispatchOnSaveRequestFailure(this, null);
        }

        @Override
        public void run() {
            RemoteFillService remoteService = this.getService();
            if (remoteService != null) {
                try {
                    remoteService.mAutoFillService.onSaveRequest(this.mRequest, this.mCallback);
                }
                catch (RemoteException e) {
                    Slog.e(RemoteFillService.LOG_TAG, "Error calling on save request", e);
                    remoteService.dispatchOnSaveRequestFailure(this, null);
                }
            }
        }

        @Override
        public boolean isFinal() {
            return true;
        }
    }

    private static final class PendingFillRequest
    extends PendingRequest {
        private final FillRequest mRequest;
        private final IFillCallback mCallback;
        private ICancellationSignal mCancellation;

        public PendingFillRequest(final FillRequest request, RemoteFillService service) {
            super(service);
            this.mRequest = request;
            this.mCallback = new IFillCallback.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCancellable(ICancellationSignal cancellation) {
                    Object object = mLock;
                    synchronized (object) {
                        boolean cancelled;
                        Object object2 = mLock;
                        synchronized (object2) {
                            mCancellation = cancellation;
                            cancelled = this.isCancelledLocked();
                        }
                        if (cancelled) {
                            try {
                                cancellation.cancel();
                            }
                            catch (RemoteException e) {
                                Slog.e(RemoteFillService.LOG_TAG, "Error requesting a cancellation", e);
                            }
                        }
                    }
                }

                @Override
                public void onSuccess(FillResponse response) {
                    if (!this.finish()) {
                        return;
                    }
                    RemoteFillService remoteService = this.getService();
                    if (remoteService != null) {
                        remoteService.dispatchOnFillRequestSuccess(this, response, request.getFlags());
                    }
                }

                @Override
                public void onFailure(int requestId, CharSequence message) {
                    if (!this.finish()) {
                        return;
                    }
                    RemoteFillService remoteService = this.getService();
                    if (remoteService != null) {
                        remoteService.dispatchOnFillRequestFailure(this, message);
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onTimeout(RemoteFillService remoteService) {
            ICancellationSignal cancellation;
            Object object = this.mLock;
            synchronized (object) {
                cancellation = this.mCancellation;
            }
            if (cancellation != null) {
                remoteService.dispatchOnFillTimeout(cancellation);
            }
            remoteService.dispatchOnFillRequestTimeout(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.isCancelledLocked()) {
                    if (Helper.sDebug) {
                        Slog.d(RemoteFillService.LOG_TAG, "run() called after canceled: " + this.mRequest);
                    }
                    return;
                }
            }
            RemoteFillService remoteService = this.getService();
            if (remoteService != null) {
                try {
                    remoteService.mAutoFillService.onFillRequest(this.mRequest, this.mCallback);
                }
                catch (RemoteException e) {
                    Slog.e(RemoteFillService.LOG_TAG, "Error calling on fill request", e);
                    remoteService.dispatchOnFillRequestFailure(this, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            ICancellationSignal cancellation;
            if (!super.cancel()) {
                return false;
            }
            Object object = this.mLock;
            synchronized (object) {
                cancellation = this.mCancellation;
            }
            if (cancellation != null) {
                try {
                    cancellation.cancel();
                }
                catch (RemoteException e) {
                    Slog.e(RemoteFillService.LOG_TAG, "Error cancelling a fill request", e);
                }
            }
            return true;
        }
    }

    private static abstract class PendingRequest
    implements Runnable {
        protected final Object mLock = new Object();
        private final WeakReference<RemoteFillService> mWeakService;
        private final Runnable mTimeoutTrigger;
        private final Handler mServiceHandler;
        @GuardedBy(value="mLock")
        private boolean mCancelled;
        @GuardedBy(value="mLock")
        private boolean mCompleted;

        PendingRequest(RemoteFillService service) {
            this.mWeakService = new WeakReference<RemoteFillService>(service);
            this.mServiceHandler = service.mHandler;
            this.mTimeoutTrigger = () -> {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mCancelled) {
                        return;
                    }
                    this.mCompleted = true;
                }
                Slog.w(RemoteFillService.LOG_TAG, this.getClass().getSimpleName() + " timed out");
                RemoteFillService remoteService = (RemoteFillService)this.mWeakService.get();
                if (remoteService != null) {
                    Slog.w(RemoteFillService.LOG_TAG, this.getClass().getSimpleName() + " timed out after " + 5000L + " ms");
                    this.onTimeout(remoteService);
                }
            };
            this.mServiceHandler.postAtTime(this.mTimeoutTrigger, SystemClock.uptimeMillis() + 5000L);
        }

        protected RemoteFillService getService() {
            return (RemoteFillService)this.mWeakService.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean finish() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCompleted || this.mCancelled) {
                    return false;
                }
                this.mCompleted = true;
            }
            this.mServiceHandler.removeCallbacks(this.mTimeoutTrigger);
            return true;
        }

        @GuardedBy(value="mLock")
        protected boolean isCancelledLocked() {
            return this.mCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancel() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCancelled || this.mCompleted) {
                    return false;
                }
                this.mCancelled = true;
            }
            this.mServiceHandler.removeCallbacks(this.mTimeoutTrigger);
            return true;
        }

        abstract void onTimeout(RemoteFillService var1);

        boolean isFinal() {
            return false;
        }
    }

    private class RemoteServiceConnection
    implements ServiceConnection {
        private RemoteServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            if (RemoteFillService.this.mDestroyed || !RemoteFillService.this.mBinding) {
                Slog.wtf(RemoteFillService.LOG_TAG, "onServiceConnected was dispatched after unbindService.");
                return;
            }
            RemoteFillService.this.mBinding = false;
            RemoteFillService.this.mAutoFillService = IAutoFillService.Stub.asInterface(service);
            try {
                service.linkToDeath(RemoteFillService.this, 0);
            }
            catch (RemoteException re) {
                RemoteFillService.this.handleBinderDied();
                return;
            }
            try {
                RemoteFillService.this.mAutoFillService.onConnectedStateChanged(true);
            }
            catch (RemoteException e) {
                Slog.w(RemoteFillService.LOG_TAG, "Exception calling onConnected(): " + e);
            }
            if (RemoteFillService.this.mPendingRequest != null) {
                PendingRequest pendingRequest = RemoteFillService.this.mPendingRequest;
                RemoteFillService.this.mPendingRequest = null;
                RemoteFillService.this.handlePendingRequest(pendingRequest);
            }
            RemoteFillService.this.mServiceDied = false;
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            RemoteFillService.this.mBinding = true;
            RemoteFillService.this.mAutoFillService = null;
        }
    }

    public static interface FillServiceCallbacks {
        public void onFillRequestSuccess(int var1, FillResponse var2, String var3, int var4);

        public void onFillRequestFailure(int var1, CharSequence var2, String var3);

        public void onFillRequestTimeout(int var1, String var2);

        public void onSaveRequestSuccess(String var1, IntentSender var2);

        public void onSaveRequestFailure(CharSequence var1, String var2);

        public void onServiceDied(RemoteFillService var1);
    }
}

