/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.AppGlobals;
import android.app.backup.BlobBackupHelper;
import android.content.pm.IPackageManager;
import android.util.Slog;

public class PreferredActivityBackupHelper
extends BlobBackupHelper {
    private static final String TAG = "PreferredBackup";
    private static final boolean DEBUG = false;
    private static final int STATE_VERSION = 3;
    private static final String KEY_PREFERRED = "preferred-activity";
    private static final String KEY_DEFAULT_APPS = "default-apps";
    private static final String KEY_INTENT_VERIFICATION = "intent-verification";

    public PreferredActivityBackupHelper() {
        super(3, KEY_PREFERRED, KEY_DEFAULT_APPS, KEY_INTENT_VERIFICATION);
    }

    @Override
    protected byte[] getBackupPayload(String key) {
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            switch (key) {
                case "preferred-activity": {
                    return pm.getPreferredActivityBackup(0);
                }
                case "default-apps": {
                    return pm.getDefaultAppsBackup(0);
                }
                case "intent-verification": {
                    return pm.getIntentFilterVerificationBackup(0);
                }
            }
            Slog.w(TAG, "Unexpected backup key " + key);
        }
        catch (Exception e) {
            Slog.e(TAG, "Unable to store payload " + key);
        }
        return null;
    }

    @Override
    protected void applyRestoredPayload(String key, byte[] payload) {
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            switch (key) {
                case "preferred-activity": {
                    pm.restorePreferredActivities(payload, 0);
                    break;
                }
                case "default-apps": {
                    pm.restoreDefaultApps(payload, 0);
                    break;
                }
                case "intent-verification": {
                    pm.restoreIntentFilterVerification(payload, 0);
                    break;
                }
                default: {
                    Slog.w(TAG, "Unexpected restore key " + key);
                    break;
                }
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "Unable to restore key " + key);
        }
    }
}

