/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.fullbackup;

import android.app.IBackupAgent;
import android.app.backup.BackupProgress;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IBackupObserver;
import android.app.backup.IFullBackupRestoreObserver;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import com.android.internal.backup.IBackupTransport;
import com.android.internal.util.Preconditions;
import com.android.server.backup.BackupAgentTimeoutParameters;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.FullBackupJob;
import com.android.server.backup.TransportManager;
import com.android.server.backup.fullbackup.FullBackupEngine;
import com.android.server.backup.fullbackup.FullBackupPreflight;
import com.android.server.backup.fullbackup.FullBackupTask;
import com.android.server.backup.internal.OnTaskFinishedListener;
import com.android.server.backup.internal.Operation;
import com.android.server.backup.transport.TransportClient;
import com.android.server.backup.transport.TransportNotAvailableException;
import com.android.server.backup.utils.AppBackupUtils;
import com.android.server.backup.utils.BackupManagerMonitorUtils;
import com.android.server.backup.utils.BackupObserverUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class PerformFullTransportBackupTask
extends FullBackupTask
implements BackupRestoreTask {
    private static final String TAG = "PFTBT";
    private BackupManagerService backupManagerService;
    private final Object mCancelLock = new Object();
    ArrayList<PackageInfo> mPackages;
    PackageInfo mCurrentPackage;
    boolean mUpdateSchedule;
    CountDownLatch mLatch;
    FullBackupJob mJob;
    IBackupObserver mBackupObserver;
    IBackupManagerMonitor mMonitor;
    boolean mUserInitiated;
    SinglePackageBackupRunner mBackupRunner;
    private final int mBackupRunnerOpToken;
    private final OnTaskFinishedListener mListener;
    private final TransportClient mTransportClient;
    private volatile boolean mIsDoingBackup;
    private volatile boolean mCancelAll;
    private final int mCurrentOpToken;
    private final BackupAgentTimeoutParameters mAgentTimeoutParameters;

    public static PerformFullTransportBackupTask newWithCurrentTransport(BackupManagerService backupManagerService, IFullBackupRestoreObserver observer, String[] whichPackages, boolean updateSchedule, FullBackupJob runningJob, CountDownLatch latch, IBackupObserver backupObserver, IBackupManagerMonitor monitor, boolean userInitiated, String caller) {
        TransportManager transportManager = backupManagerService.getTransportManager();
        TransportClient transportClient = transportManager.getCurrentTransportClient(caller);
        OnTaskFinishedListener listener = listenerCaller -> transportManager.disposeOfTransportClient(transportClient, listenerCaller);
        return new PerformFullTransportBackupTask(backupManagerService, transportClient, observer, whichPackages, updateSchedule, runningJob, latch, backupObserver, monitor, listener, userInitiated);
    }

    public PerformFullTransportBackupTask(BackupManagerService backupManagerService, TransportClient transportClient, IFullBackupRestoreObserver observer, String[] whichPackages, boolean updateSchedule, FullBackupJob runningJob, CountDownLatch latch, IBackupObserver backupObserver, IBackupManagerMonitor monitor, OnTaskFinishedListener listener, boolean userInitiated) {
        super(observer);
        this.backupManagerService = backupManagerService;
        this.mTransportClient = transportClient;
        this.mUpdateSchedule = updateSchedule;
        this.mLatch = latch;
        this.mJob = runningJob;
        this.mPackages = new ArrayList(whichPackages.length);
        this.mBackupObserver = backupObserver;
        this.mMonitor = monitor;
        this.mListener = listener != null ? listener : OnTaskFinishedListener.NOP;
        this.mUserInitiated = userInitiated;
        this.mCurrentOpToken = backupManagerService.generateRandomIntegerToken();
        this.mBackupRunnerOpToken = backupManagerService.generateRandomIntegerToken();
        this.mAgentTimeoutParameters = Preconditions.checkNotNull(backupManagerService.getAgentTimeoutParameters(), "Timeout parameters cannot be null");
        if (backupManagerService.isBackupOperationInProgress()) {
            Slog.d(TAG, "Skipping full backup. A backup is already in progress.");
            this.mCancelAll = true;
            return;
        }
        this.registerTask();
        for (String pkg : whichPackages) {
            try {
                PackageInfo info;
                PackageManager pm = backupManagerService.getPackageManager();
                this.mCurrentPackage = info = pm.getPackageInfo(pkg, 0x8000000);
                if (!AppBackupUtils.appIsEligibleForBackup(info.applicationInfo, pm)) {
                    this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 9, this.mCurrentPackage, 3, null);
                    BackupObserverUtils.sendBackupOnPackageResult(this.mBackupObserver, pkg, -2001);
                    continue;
                }
                if (!AppBackupUtils.appGetsFullBackup(info)) {
                    this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 10, this.mCurrentPackage, 3, null);
                    BackupObserverUtils.sendBackupOnPackageResult(this.mBackupObserver, pkg, -2001);
                    continue;
                }
                if (AppBackupUtils.appIsStopped(info.applicationInfo)) {
                    this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 11, this.mCurrentPackage, 3, null);
                    BackupObserverUtils.sendBackupOnPackageResult(this.mBackupObserver, pkg, -2001);
                    continue;
                }
                this.mPackages.add(info);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.i(TAG, "Requested package " + pkg + " not found; ignoring");
                this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 12, this.mCurrentPackage, 3, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTask() {
        Object object = this.backupManagerService.getCurrentOpLock();
        synchronized (object) {
            Slog.d(TAG, "backupmanager pftbt token=" + Integer.toHexString(this.mCurrentOpToken));
            this.backupManagerService.getCurrentOperations().put(this.mCurrentOpToken, new Operation(0, this, 2));
        }
    }

    public void unregisterTask() {
        this.backupManagerService.removeOperation(this.mCurrentOpToken);
    }

    @Override
    public void execute() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCancel(boolean cancelAll) {
        Object object = this.mCancelLock;
        synchronized (object) {
            if (!cancelAll) {
                Slog.wtf(TAG, "Expected cancelAll to be true.");
            }
            if (this.mCancelAll) {
                Slog.d(TAG, "Ignoring duplicate cancel call.");
                return;
            }
            this.mCancelAll = true;
            if (this.mIsDoingBackup) {
                this.backupManagerService.handleCancel(this.mBackupRunnerOpToken, cancelAll);
                try {
                    IBackupTransport transport = this.mTransportClient.getConnectedTransport("PFTBT.handleCancel()");
                    transport.cancelFullBackup();
                }
                catch (RemoteException | TransportNotAvailableException e) {
                    Slog.w(TAG, "Error calling cancelFullBackup() on transport: " + e);
                }
            }
        }
    }

    @Override
    public void operationComplete(long result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        ParcelFileDescriptor[] enginePipes = null;
        ParcelFileDescriptor[] transportPipes = null;
        long backoff = 0L;
        int backupRunStatus = 0;
        try {
            if (!this.backupManagerService.isEnabled() || !this.backupManagerService.isProvisioned()) {
                Slog.i(TAG, "full backup requested but enabled=" + this.backupManagerService.isEnabled() + " provisioned=" + this.backupManagerService.isProvisioned() + "; ignoring");
                int monitoringEvent = this.backupManagerService.isProvisioned() ? 13 : 14;
                this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, monitoringEvent, null, 3, null);
                this.mUpdateSchedule = false;
                backupRunStatus = -2001;
                if (this.mCancelAll) {
                    backupRunStatus = -2003;
                }
                Slog.i(TAG, "Full backup completed with status: " + backupRunStatus);
                BackupObserverUtils.sendBackupFinished(this.mBackupObserver, backupRunStatus);
                this.cleanUpPipes(transportPipes);
                this.cleanUpPipes(enginePipes);
                this.unregisterTask();
                if (this.mJob != null) {
                    this.mJob.finishBackupPass();
                }
                Object object = this.backupManagerService.getQueueLock();
                // MONITORENTER : object
                this.backupManagerService.setRunningFullBackupTask(null);
                // MONITOREXIT : object
                this.mListener.onFinished("PFTBT.run()");
                this.mLatch.countDown();
                if (this.mUpdateSchedule) {
                    this.backupManagerService.scheduleNextFullBackupJob(backoff);
                }
                Slog.i(TAG, "Full data backup pass finished.");
                this.backupManagerService.getWakelock().release();
                return;
            }
            IBackupTransport transport = this.mTransportClient.connect("PFTBT.run()");
            if (transport == null) {
                Slog.w(TAG, "Transport not present; full data backup not performed");
                backupRunStatus = -1000;
                this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 15, this.mCurrentPackage, 1, null);
                return;
            }
            int N = this.mPackages.size();
            byte[] buffer = new byte[8192];
            int i = 0;
            while (i < N) {
                this.mBackupRunner = null;
                PackageInfo currentPackage = this.mPackages.get(i);
                String packageName = currentPackage.packageName;
                Slog.i(TAG, "Initiating full-data transport backup of " + packageName + " token: " + this.mCurrentOpToken);
                EventLog.writeEvent(2840, packageName);
                transportPipes = ParcelFileDescriptor.createPipe();
                int flags = this.mUserInitiated ? 1 : 0;
                long quota = Long.MAX_VALUE;
                Object object = this.mCancelLock;
                // MONITORENTER : object
                if (this.mCancelAll) {
                    // MONITOREXIT : object
                    return;
                }
                int backupPackageStatus = transport.performFullBackup(currentPackage, transportPipes[0], flags);
                if (backupPackageStatus == 0) {
                    quota = transport.getBackupQuota(currentPackage.packageName, true);
                    enginePipes = ParcelFileDescriptor.createPipe();
                    this.mBackupRunner = new SinglePackageBackupRunner(enginePipes[1], currentPackage, this.mTransportClient, quota, this.mBackupRunnerOpToken, transport.getTransportFlags());
                    enginePipes[1].close();
                    enginePipes[1] = null;
                    this.mIsDoingBackup = true;
                }
                // MONITOREXIT : object
                if (backupPackageStatus == 0) {
                    Object object2;
                    transportPipes[0].close();
                    transportPipes[0] = null;
                    new Thread((Runnable)this.mBackupRunner, "package-backup-bridge").start();
                    FileInputStream in = new FileInputStream(enginePipes[0].getFileDescriptor());
                    FileOutputStream out = new FileOutputStream(transportPipes[1].getFileDescriptor());
                    long totalRead = 0L;
                    long preflightResult = this.mBackupRunner.getPreflightResultBlocking();
                    if (preflightResult < 0L) {
                        this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 16, this.mCurrentPackage, 3, BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_PREFLIGHT_ERROR", preflightResult));
                        backupPackageStatus = (int)preflightResult;
                    } else {
                        int nRead = 0;
                        do {
                            if ((nRead = in.read(buffer)) <= 0) continue;
                            out.write(buffer, 0, nRead);
                            object2 = this.mCancelLock;
                            // MONITORENTER : object2
                            if (!this.mCancelAll) {
                                backupPackageStatus = transport.sendBackupData(nRead);
                            }
                            // MONITOREXIT : object2
                            totalRead += (long)nRead;
                            if (this.mBackupObserver == null || preflightResult <= 0L) continue;
                            BackupObserverUtils.sendBackupOnUpdate(this.mBackupObserver, packageName, new BackupProgress(preflightResult, totalRead));
                        } while (nRead > 0 && backupPackageStatus == 0);
                        if (backupPackageStatus == -1005) {
                            Slog.w(TAG, "Package hit quota limit in-flight " + packageName + ": " + totalRead + " of " + quota);
                            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 18, this.mCurrentPackage, 1, null);
                            this.mBackupRunner.sendQuotaExceeded(totalRead, quota);
                        }
                    }
                    int backupRunnerResult = this.mBackupRunner.getBackupResultBlocking();
                    object2 = this.mCancelLock;
                    // MONITORENTER : object2
                    this.mIsDoingBackup = false;
                    if (!this.mCancelAll) {
                        if (backupRunnerResult == 0) {
                            int finishResult = transport.finishBackup();
                            if (backupPackageStatus == 0) {
                                backupPackageStatus = finishResult;
                            }
                        } else {
                            transport.cancelFullBackup();
                        }
                    }
                    // MONITOREXIT : object2
                    if (backupPackageStatus == 0 && backupRunnerResult != 0) {
                        backupPackageStatus = backupRunnerResult;
                    }
                    if (backupPackageStatus != 0) {
                        Slog.e(TAG, "Error " + backupPackageStatus + " backing up " + packageName);
                    }
                    backoff = transport.requestFullBackupTime();
                    Slog.i(TAG, "Transport suggested backoff=" + backoff);
                }
                if (this.mUpdateSchedule) {
                    this.backupManagerService.enqueueFullBackup(packageName, System.currentTimeMillis());
                }
                if (backupPackageStatus == -1002) {
                    BackupObserverUtils.sendBackupOnPackageResult(this.mBackupObserver, packageName, -1002);
                    Slog.i(TAG, "Transport rejected backup of " + packageName + ", skipping");
                    EventLog.writeEvent(2841, packageName, "transport rejected");
                    if (this.mBackupRunner != null) {
                        this.backupManagerService.tearDownAgentAndKill(currentPackage.applicationInfo);
                    }
                } else if (backupPackageStatus == -1005) {
                    BackupObserverUtils.sendBackupOnPackageResult(this.mBackupObserver, packageName, -1005);
                    Slog.i(TAG, "Transport quota exceeded for package: " + packageName);
                    EventLog.writeEvent(2845, packageName);
                    this.backupManagerService.tearDownAgentAndKill(currentPackage.applicationInfo);
                } else if (backupPackageStatus == -1003) {
                    BackupObserverUtils.sendBackupOnPackageResult(this.mBackupObserver, packageName, -1003);
                    Slog.w(TAG, "Application failure for package: " + packageName);
                    EventLog.writeEvent(2823, packageName);
                    this.backupManagerService.tearDownAgentAndKill(currentPackage.applicationInfo);
                } else if (backupPackageStatus == -2003) {
                    BackupObserverUtils.sendBackupOnPackageResult(this.mBackupObserver, packageName, -2003);
                    Slog.w(TAG, "Backup cancelled. package=" + packageName + ", cancelAll=" + this.mCancelAll);
                    EventLog.writeEvent(2846, packageName);
                    this.backupManagerService.tearDownAgentAndKill(currentPackage.applicationInfo);
                } else {
                    if (backupPackageStatus != 0) {
                        BackupObserverUtils.sendBackupOnPackageResult(this.mBackupObserver, packageName, -1000);
                        Slog.w(TAG, "Transport failed; aborting backup: " + backupPackageStatus);
                        EventLog.writeEvent(2842, new Object[0]);
                        backupRunStatus = -1000;
                        this.backupManagerService.tearDownAgentAndKill(currentPackage.applicationInfo);
                        if (this.mCancelAll) {
                            backupRunStatus = -2003;
                        }
                        Slog.i(TAG, "Full backup completed with status: " + backupRunStatus);
                        BackupObserverUtils.sendBackupFinished(this.mBackupObserver, backupRunStatus);
                        this.cleanUpPipes(transportPipes);
                        this.cleanUpPipes(enginePipes);
                        this.unregisterTask();
                        if (this.mJob != null) {
                            this.mJob.finishBackupPass();
                        }
                        object = this.backupManagerService.getQueueLock();
                        // MONITORENTER : object
                        this.backupManagerService.setRunningFullBackupTask(null);
                        // MONITOREXIT : object
                        this.mListener.onFinished("PFTBT.run()");
                        this.mLatch.countDown();
                        if (this.mUpdateSchedule) {
                            this.backupManagerService.scheduleNextFullBackupJob(backoff);
                        }
                        Slog.i(TAG, "Full data backup pass finished.");
                        this.backupManagerService.getWakelock().release();
                        return;
                    }
                    BackupObserverUtils.sendBackupOnPackageResult(this.mBackupObserver, packageName, 0);
                    EventLog.writeEvent(2843, packageName);
                    this.backupManagerService.logBackupComplete(packageName);
                }
                this.cleanUpPipes(transportPipes);
                this.cleanUpPipes(enginePipes);
                if (currentPackage.applicationInfo != null) {
                    Slog.i(TAG, "Unbinding agent in " + packageName);
                    this.backupManagerService.addBackupTrace("unbinding " + packageName);
                    try {
                        this.backupManagerService.getActivityManager().unbindBackupAgent(currentPackage.applicationInfo);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            return;
        }
        catch (Exception e) {
            backupRunStatus = -1000;
            Slog.w(TAG, "Exception trying full transport backup", e);
            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 19, this.mCurrentPackage, 3, BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_EXCEPTION_FULL_BACKUP", Log.getStackTraceString(e)));
            return;
        }
        finally {
            if (this.mCancelAll) {
                backupRunStatus = -2003;
            }
            Slog.i(TAG, "Full backup completed with status: " + backupRunStatus);
            BackupObserverUtils.sendBackupFinished(this.mBackupObserver, backupRunStatus);
            this.cleanUpPipes(transportPipes);
            this.cleanUpPipes(enginePipes);
            this.unregisterTask();
            if (this.mJob != null) {
                this.mJob.finishBackupPass();
            }
            Object object = this.backupManagerService.getQueueLock();
        }
    }

    void cleanUpPipes(ParcelFileDescriptor[] pipes) {
        if (pipes != null) {
            ParcelFileDescriptor fd;
            if (pipes[0] != null) {
                fd = pipes[0];
                pipes[0] = null;
                try {
                    fd.close();
                }
                catch (IOException e) {
                    Slog.w(TAG, "Unable to close pipe!");
                }
            }
            if (pipes[1] != null) {
                fd = pipes[1];
                pipes[1] = null;
                try {
                    fd.close();
                }
                catch (IOException e) {
                    Slog.w(TAG, "Unable to close pipe!");
                }
            }
        }
    }

    class SinglePackageBackupRunner
    implements Runnable,
    BackupRestoreTask {
        final ParcelFileDescriptor mOutput;
        final PackageInfo mTarget;
        final SinglePackageBackupPreflight mPreflight;
        final CountDownLatch mPreflightLatch;
        final CountDownLatch mBackupLatch;
        private final int mCurrentOpToken;
        private final int mEphemeralToken;
        private FullBackupEngine mEngine;
        private volatile int mPreflightResult;
        private volatile int mBackupResult;
        private final long mQuota;
        private volatile boolean mIsCancelled;
        private final int mTransportFlags;

        SinglePackageBackupRunner(ParcelFileDescriptor output, PackageInfo target, TransportClient transportClient, long quota, int currentOpToken, int transportFlags) throws IOException {
            this.mOutput = ParcelFileDescriptor.dup(output.getFileDescriptor());
            this.mTarget = target;
            this.mCurrentOpToken = currentOpToken;
            this.mEphemeralToken = PerformFullTransportBackupTask.this.backupManagerService.generateRandomIntegerToken();
            this.mPreflight = new SinglePackageBackupPreflight(transportClient, quota, this.mEphemeralToken, transportFlags);
            this.mPreflightLatch = new CountDownLatch(1);
            this.mBackupLatch = new CountDownLatch(1);
            this.mPreflightResult = -1003;
            this.mBackupResult = -1003;
            this.mQuota = quota;
            this.mTransportFlags = transportFlags;
            this.registerTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerTask() {
            Object object = PerformFullTransportBackupTask.this.backupManagerService.getCurrentOpLock();
            synchronized (object) {
                PerformFullTransportBackupTask.this.backupManagerService.getCurrentOperations().put(this.mCurrentOpToken, new Operation(0, this, 0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregisterTask() {
            Object object = PerformFullTransportBackupTask.this.backupManagerService.getCurrentOpLock();
            synchronized (object) {
                PerformFullTransportBackupTask.this.backupManagerService.getCurrentOperations().remove(this.mCurrentOpToken);
            }
        }

        @Override
        public void run() {
            FileOutputStream out = new FileOutputStream(this.mOutput.getFileDescriptor());
            this.mEngine = new FullBackupEngine(PerformFullTransportBackupTask.this.backupManagerService, out, this.mPreflight, this.mTarget, false, this, this.mQuota, this.mCurrentOpToken, this.mTransportFlags);
            try {
                try {
                    if (!this.mIsCancelled) {
                        this.mPreflightResult = this.mEngine.preflightCheck();
                    }
                }
                finally {
                    this.mPreflightLatch.countDown();
                }
                if (this.mPreflightResult == 0 && !this.mIsCancelled) {
                    this.mBackupResult = this.mEngine.backupOnePackage();
                }
            }
            catch (Exception e) {
                Slog.e(PerformFullTransportBackupTask.TAG, "Exception during full package backup of " + this.mTarget.packageName);
            }
            finally {
                this.unregisterTask();
                this.mBackupLatch.countDown();
                try {
                    this.mOutput.close();
                }
                catch (IOException e) {
                    Slog.w(PerformFullTransportBackupTask.TAG, "Error closing transport pipe in runner");
                }
            }
        }

        public void sendQuotaExceeded(long backupDataBytes, long quotaBytes) {
            this.mEngine.sendQuotaExceeded(backupDataBytes, quotaBytes);
        }

        long getPreflightResultBlocking() {
            long fullBackupAgentTimeoutMillis = PerformFullTransportBackupTask.this.mAgentTimeoutParameters.getFullBackupAgentTimeoutMillis();
            try {
                this.mPreflightLatch.await(fullBackupAgentTimeoutMillis, TimeUnit.MILLISECONDS);
                if (this.mIsCancelled) {
                    return -2003L;
                }
                if (this.mPreflightResult == 0) {
                    return this.mPreflight.getExpectedSizeOrErrorCode();
                }
                return this.mPreflightResult;
            }
            catch (InterruptedException e) {
                return -1003L;
            }
        }

        int getBackupResultBlocking() {
            long fullBackupAgentTimeoutMillis = PerformFullTransportBackupTask.this.mAgentTimeoutParameters.getFullBackupAgentTimeoutMillis();
            try {
                this.mBackupLatch.await(fullBackupAgentTimeoutMillis, TimeUnit.MILLISECONDS);
                if (this.mIsCancelled) {
                    return -2003;
                }
                return this.mBackupResult;
            }
            catch (InterruptedException e) {
                return -1003;
            }
        }

        @Override
        public void execute() {
        }

        @Override
        public void operationComplete(long result) {
        }

        @Override
        public void handleCancel(boolean cancelAll) {
            Slog.w(PerformFullTransportBackupTask.TAG, "Full backup cancel of " + this.mTarget.packageName);
            PerformFullTransportBackupTask.this.mMonitor = BackupManagerMonitorUtils.monitorEvent(PerformFullTransportBackupTask.this.mMonitor, 4, PerformFullTransportBackupTask.this.mCurrentPackage, 2, null);
            this.mIsCancelled = true;
            PerformFullTransportBackupTask.this.backupManagerService.handleCancel(this.mEphemeralToken, cancelAll);
            PerformFullTransportBackupTask.this.backupManagerService.tearDownAgentAndKill(this.mTarget.applicationInfo);
            this.mPreflightLatch.countDown();
            this.mBackupLatch.countDown();
            PerformFullTransportBackupTask.this.backupManagerService.removeOperation(this.mCurrentOpToken);
        }
    }

    class SinglePackageBackupPreflight
    implements BackupRestoreTask,
    FullBackupPreflight {
        final AtomicLong mResult = new AtomicLong(-1003L);
        final CountDownLatch mLatch = new CountDownLatch(1);
        final TransportClient mTransportClient;
        final long mQuota;
        private final int mCurrentOpToken;
        private final int mTransportFlags;

        SinglePackageBackupPreflight(TransportClient transportClient, long quota, int currentOpToken, int transportFlags) {
            this.mTransportClient = transportClient;
            this.mQuota = quota;
            this.mCurrentOpToken = currentOpToken;
            this.mTransportFlags = transportFlags;
        }

        @Override
        public int preflightFullBackup(PackageInfo pkg, IBackupAgent agent) {
            int result;
            long fullBackupAgentTimeoutMillis = PerformFullTransportBackupTask.this.mAgentTimeoutParameters.getFullBackupAgentTimeoutMillis();
            try {
                PerformFullTransportBackupTask.this.backupManagerService.prepareOperationTimeout(this.mCurrentOpToken, fullBackupAgentTimeoutMillis, this, 0);
                PerformFullTransportBackupTask.this.backupManagerService.addBackupTrace("preflighting");
                agent.doMeasureFullBackup(this.mQuota, this.mCurrentOpToken, PerformFullTransportBackupTask.this.backupManagerService.getBackupManagerBinder(), this.mTransportFlags);
                this.mLatch.await(fullBackupAgentTimeoutMillis, TimeUnit.MILLISECONDS);
                long totalSize = this.mResult.get();
                if (totalSize < 0L) {
                    return (int)totalSize;
                }
                IBackupTransport transport = this.mTransportClient.connectOrThrow("PFTBT$SPBP.preflightFullBackup()");
                result = transport.checkFullBackupSize(totalSize);
                if (result == -1005) {
                    agent.doQuotaExceeded(totalSize, this.mQuota);
                }
            }
            catch (Exception e) {
                Slog.w(PerformFullTransportBackupTask.TAG, "Exception preflighting " + pkg.packageName + ": " + e.getMessage());
                result = -1003;
            }
            return result;
        }

        @Override
        public void execute() {
        }

        @Override
        public void operationComplete(long result) {
            this.mResult.set(result);
            this.mLatch.countDown();
            PerformFullTransportBackupTask.this.backupManagerService.removeOperation(this.mCurrentOpToken);
        }

        @Override
        public void handleCancel(boolean cancelAll) {
            this.mResult.set(-1003L);
            this.mLatch.countDown();
            PerformFullTransportBackupTask.this.backupManagerService.removeOperation(this.mCurrentOpToken);
        }

        @Override
        public long getExpectedSizeOrErrorCode() {
            long fullBackupAgentTimeoutMillis = PerformFullTransportBackupTask.this.mAgentTimeoutParameters.getFullBackupAgentTimeoutMillis();
            try {
                this.mLatch.await(fullBackupAgentTimeoutMillis, TimeUnit.MILLISECONDS);
                return this.mResult.get();
            }
            catch (InterruptedException e) {
                return -1L;
            }
        }
    }
}

