/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.utils;

import com.android.server.backup.utils.DataStreamCodec;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public final class DataStreamFileCodec<T> {
    private final File mFile;
    private final DataStreamCodec<T> mCodec;

    public DataStreamFileCodec(File file, DataStreamCodec<T> codec) {
        this.mFile = file;
        this.mCodec = codec;
    }

    public T deserialize() throws IOException {
        Throwable throwable = null;
        try (FileInputStream fileInputStream = new FileInputStream(this.mFile);){
            T t;
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            Throwable throwable2 = null;
            try {
                t = this.mCodec.deserialize(dataInputStream);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        DataStreamFileCodec.$closeResource(throwable2, dataInputStream);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            DataStreamFileCodec.$closeResource(throwable2, dataInputStream);
            return t;
        }
    }

    public void serialize(T t) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.mFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);){
            this.mCodec.serialize(t, dataOutputStream);
            dataOutputStream.flush();
        }
    }
}

