/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.broadcastradio.hal1;

import android.hardware.radio.ITunerCallback;
import android.hardware.radio.ProgramList;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.broadcastradio.hal1.Tuner;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

class TunerCallback
implements ITunerCallback {
    private static final String TAG = "BroadcastRadioService.TunerCallback";
    private final long mNativeContext;
    private final Tuner mTuner;
    private final ITunerCallback mClientCallback;
    private final AtomicReference<ProgramList.Filter> mProgramListFilter = new AtomicReference();
    private boolean mInitialConfigurationDone = false;

    TunerCallback(Tuner tuner, ITunerCallback clientCallback, int halRev) {
        this.mTuner = tuner;
        this.mClientCallback = clientCallback;
        this.mNativeContext = this.nativeInit(tuner, halRev);
    }

    protected void finalize() throws Throwable {
        this.nativeFinalize(this.mNativeContext);
        super.finalize();
    }

    private native long nativeInit(Tuner var1, int var2);

    private native void nativeFinalize(long var1);

    private native void nativeDetach(long var1);

    public void detach() {
        this.nativeDetach(this.mNativeContext);
    }

    private void dispatch(RunnableThrowingRemoteException func) {
        try {
            func.run();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "client died", e);
        }
    }

    private void handleHwFailure() {
        this.onError(0);
        this.mTuner.close();
    }

    void startProgramListUpdates(ProgramList.Filter filter) {
        if (filter == null) {
            filter = new ProgramList.Filter();
        }
        this.mProgramListFilter.set(filter);
        this.sendProgramListUpdate();
    }

    void stopProgramListUpdates() {
        this.mProgramListFilter.set(null);
    }

    boolean isInitialConfigurationDone() {
        return this.mInitialConfigurationDone;
    }

    @Override
    public void onError(int status) {
        this.dispatch(() -> this.mClientCallback.onError(status));
    }

    @Override
    public void onTuneFailed(int result, ProgramSelector selector) {
        Slog.e(TAG, "Not applicable for HAL 1.x");
    }

    @Override
    public void onConfigurationChanged(RadioManager.BandConfig config) {
        this.mInitialConfigurationDone = true;
        this.dispatch(() -> this.mClientCallback.onConfigurationChanged(config));
    }

    @Override
    public void onCurrentProgramInfoChanged(RadioManager.ProgramInfo info) {
        this.dispatch(() -> this.mClientCallback.onCurrentProgramInfoChanged(info));
    }

    @Override
    public void onTrafficAnnouncement(boolean active) {
        this.dispatch(() -> this.mClientCallback.onTrafficAnnouncement(active));
    }

    @Override
    public void onEmergencyAnnouncement(boolean active) {
        this.dispatch(() -> this.mClientCallback.onEmergencyAnnouncement(active));
    }

    @Override
    public void onAntennaState(boolean connected) {
        this.dispatch(() -> this.mClientCallback.onAntennaState(connected));
    }

    @Override
    public void onBackgroundScanAvailabilityChange(boolean isAvailable) {
        this.dispatch(() -> this.mClientCallback.onBackgroundScanAvailabilityChange(isAvailable));
    }

    @Override
    public void onBackgroundScanComplete() {
        this.dispatch(() -> this.mClientCallback.onBackgroundScanComplete());
    }

    @Override
    public void onProgramListChanged() {
        this.dispatch(() -> this.mClientCallback.onProgramListChanged());
        this.sendProgramListUpdate();
    }

    private void sendProgramListUpdate() {
        List<RadioManager.ProgramInfo> modified;
        ProgramList.Filter filter = this.mProgramListFilter.get();
        if (filter == null) {
            return;
        }
        try {
            modified = this.mTuner.getProgramList(filter.getVendorFilter());
        }
        catch (IllegalStateException ex) {
            Slog.d(TAG, "Program list not ready yet");
            return;
        }
        Set<RadioManager.ProgramInfo> modifiedSet = modified.stream().collect(Collectors.toSet());
        ProgramList.Chunk chunk = new ProgramList.Chunk(true, true, modifiedSet, null);
        this.dispatch(() -> this.mClientCallback.onProgramListUpdated(chunk));
    }

    @Override
    public void onProgramListUpdated(ProgramList.Chunk chunk) {
        this.dispatch(() -> this.mClientCallback.onProgramListUpdated(chunk));
    }

    @Override
    public void onParametersUpdated(Map parameters) {
        Slog.e(TAG, "Not applicable for HAL 1.x");
    }

    @Override
    public IBinder asBinder() {
        throw new RuntimeException("Not a binder");
    }

    private static interface RunnableThrowingRemoteException {
        public void run() throws RemoteException;
    }
}

