/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.broadcastradio.hal2;

import android.hardware.broadcastradio.V2_0.AmFmBandRange;
import android.hardware.broadcastradio.V2_0.AmFmRegionConfig;
import android.hardware.broadcastradio.V2_0.DabTableEntry;
import android.hardware.broadcastradio.V2_0.Metadata;
import android.hardware.broadcastradio.V2_0.MetadataKey;
import android.hardware.broadcastradio.V2_0.ProgramFilter;
import android.hardware.broadcastradio.V2_0.ProgramIdentifier;
import android.hardware.broadcastradio.V2_0.ProgramInfo;
import android.hardware.broadcastradio.V2_0.ProgramListChunk;
import android.hardware.broadcastradio.V2_0.Properties;
import android.hardware.broadcastradio.V2_0.VendorKeyValue;
import android.hardware.radio.Announcement;
import android.hardware.radio.ProgramList;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioMetadata;
import android.os.ParcelableException;
import android.util.Slog;
import com.android.server.broadcastradio.hal2.FrequencyBand;
import com.android.server.broadcastradio.hal2.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class Convert {
    private static final String TAG = "BcRadio2Srv.convert";
    private static final Map<Integer, MetadataDef> metadataKeys = new HashMap<Integer, MetadataDef>();

    Convert() {
    }

    static void throwOnError(String action, int result) {
        switch (result) {
            case 0: {
                return;
            }
            case 1: {
                throw new ParcelableException(new RuntimeException(action + ": UNKNOWN_ERROR"));
            }
            case 2: {
                throw new ParcelableException(new RuntimeException(action + ": INTERNAL_ERROR"));
            }
            case 3: {
                throw new IllegalArgumentException(action + ": INVALID_ARGUMENTS");
            }
            case 4: {
                throw new IllegalStateException(action + ": INVALID_STATE");
            }
            case 5: {
                throw new UnsupportedOperationException(action + ": NOT_SUPPORTED");
            }
            case 6: {
                throw new ParcelableException(new RuntimeException(action + ": TIMEOUT"));
            }
        }
        throw new ParcelableException(new RuntimeException(action + ": unknown error (" + result + ")"));
    }

    static ArrayList<VendorKeyValue> vendorInfoToHal(Map<String, String> info) {
        if (info == null) {
            return new ArrayList<VendorKeyValue>();
        }
        ArrayList<VendorKeyValue> list = new ArrayList<VendorKeyValue>();
        for (Map.Entry<String, String> entry : info.entrySet()) {
            VendorKeyValue elem = new VendorKeyValue();
            elem.key = entry.getKey();
            elem.value = entry.getValue();
            if (elem.key == null || elem.value == null) {
                Slog.w(TAG, "VendorKeyValue contains null pointers");
                continue;
            }
            list.add(elem);
        }
        return list;
    }

    static Map<String, String> vendorInfoFromHal(List<VendorKeyValue> info) {
        if (info == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (VendorKeyValue kvp : info) {
            if (kvp.key == null || kvp.value == null) {
                Slog.w(TAG, "VendorKeyValue contains null pointers");
                continue;
            }
            map.put(kvp.key, kvp.value);
        }
        return map;
    }

    private static int identifierTypeToProgramType(int idType) {
        switch (idType) {
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 5;
            }
            case 9: 
            case 10: {
                return 6;
            }
            case 12: 
            case 13: {
                return 7;
            }
        }
        if (idType >= 1000 && idType <= 1999) {
            return idType;
        }
        return 0;
    }

    private static int[] identifierTypesToProgramTypes(int[] idTypes) {
        HashSet<Integer> pTypes = new HashSet<Integer>();
        for (int idType : idTypes) {
            int pType = Convert.identifierTypeToProgramType(idType);
            if (pType == 0) continue;
            pTypes.add(pType);
            if (pType == 2) {
                pTypes.add(1);
            }
            if (pType != 4) continue;
            pTypes.add(3);
        }
        return pTypes.stream().mapToInt(Integer::intValue).toArray();
    }

    private static RadioManager.BandDescriptor[] amfmConfigToBands(AmFmRegionConfig config) {
        if (config == null) {
            return new RadioManager.BandDescriptor[0];
        }
        int len = config.ranges.size();
        ArrayList<RadioManager.BandDescriptor> bands = new ArrayList<RadioManager.BandDescriptor>(len);
        int region = 0;
        for (AmFmBandRange range : config.ranges) {
            FrequencyBand bandType = Utils.getBand(range.lowerBound);
            if (bandType == FrequencyBand.UNKNOWN) {
                Slog.e(TAG, "Unknown frequency band at " + range.lowerBound + "kHz");
                continue;
            }
            if (bandType == FrequencyBand.FM) {
                bands.add(new RadioManager.FmBandDescriptor(region, 1, range.lowerBound, range.upperBound, range.spacing, true, true, true, true, true));
                continue;
            }
            bands.add(new RadioManager.AmBandDescriptor(region, 0, range.lowerBound, range.upperBound, range.spacing, true));
        }
        return bands.toArray(new RadioManager.BandDescriptor[bands.size()]);
    }

    private static Map<String, Integer> dabConfigFromHal(List<DabTableEntry> config) {
        if (config == null) {
            return null;
        }
        return config.stream().collect(Collectors.toMap(e -> e.label, e -> e.frequency));
    }

    static RadioManager.ModuleProperties propertiesFromHal(int id2, String serviceName, Properties prop, AmFmRegionConfig amfmConfig, List<DabTableEntry> dabConfig) {
        Objects.requireNonNull(serviceName);
        Objects.requireNonNull(prop);
        int[] supportedIdentifierTypes = prop.supportedIdentifierTypes.stream().mapToInt(Integer::intValue).toArray();
        int[] supportedProgramTypes = Convert.identifierTypesToProgramTypes(supportedIdentifierTypes);
        return new RadioManager.ModuleProperties(id2, serviceName, 0, prop.maker, prop.product, prop.version, prop.serial, 1, 1, false, false, Convert.amfmConfigToBands(amfmConfig), true, supportedProgramTypes, supportedIdentifierTypes, Convert.dabConfigFromHal(dabConfig), Convert.vendorInfoFromHal(prop.vendorInfo));
    }

    static void programIdentifierToHal(ProgramIdentifier hwId, ProgramSelector.Identifier id2) {
        hwId.type = id2.getType();
        hwId.value = id2.getValue();
    }

    static ProgramIdentifier programIdentifierToHal(ProgramSelector.Identifier id2) {
        ProgramIdentifier hwId = new ProgramIdentifier();
        Convert.programIdentifierToHal(hwId, id2);
        return hwId;
    }

    static ProgramSelector.Identifier programIdentifierFromHal(ProgramIdentifier id2) {
        if (id2.type == 0) {
            return null;
        }
        return new ProgramSelector.Identifier(id2.type, id2.value);
    }

    static android.hardware.broadcastradio.V2_0.ProgramSelector programSelectorToHal(ProgramSelector sel) {
        android.hardware.broadcastradio.V2_0.ProgramSelector hwSel = new android.hardware.broadcastradio.V2_0.ProgramSelector();
        Convert.programIdentifierToHal(hwSel.primaryId, sel.getPrimaryId());
        Arrays.stream(sel.getSecondaryIds()).map(Convert::programIdentifierToHal).forEachOrdered(hwSel.secondaryIds::add);
        return hwSel;
    }

    static ProgramSelector programSelectorFromHal(android.hardware.broadcastradio.V2_0.ProgramSelector sel) {
        ProgramSelector.Identifier[] secondaryIds = (ProgramSelector.Identifier[])sel.secondaryIds.stream().map(Convert::programIdentifierFromHal).map(Objects::requireNonNull).toArray(ProgramSelector.Identifier[]::new);
        return new ProgramSelector(Convert.identifierTypeToProgramType(sel.primaryId.type), Objects.requireNonNull(Convert.programIdentifierFromHal(sel.primaryId)), secondaryIds, null);
    }

    private static RadioMetadata metadataFromHal(ArrayList<Metadata> meta) {
        RadioMetadata.Builder builder = new RadioMetadata.Builder();
        for (Metadata entry : meta) {
            MetadataDef keyDef = metadataKeys.get(entry.key);
            if (keyDef == null) {
                Slog.i(TAG, "Ignored unknown metadata entry: " + MetadataKey.toString(entry.key));
                continue;
            }
            if (keyDef.type == MetadataType.STRING) {
                builder.putString(keyDef.key, entry.stringValue);
                continue;
            }
            builder.putInt(keyDef.key, (int)entry.intValue);
        }
        return builder.build();
    }

    static RadioManager.ProgramInfo programInfoFromHal(ProgramInfo info) {
        Collection relatedContent = info.relatedContent.stream().map(id2 -> Objects.requireNonNull(Convert.programIdentifierFromHal(id2))).collect(Collectors.toList());
        return new RadioManager.ProgramInfo(Convert.programSelectorFromHal(info.selector), Convert.programIdentifierFromHal(info.logicallyTunedTo), Convert.programIdentifierFromHal(info.physicallyTunedTo), relatedContent, info.infoFlags, info.signalQuality, Convert.metadataFromHal(info.metadata), Convert.vendorInfoFromHal(info.vendorInfo));
    }

    static ProgramFilter programFilterToHal(ProgramList.Filter filter) {
        if (filter == null) {
            filter = new ProgramList.Filter();
        }
        ProgramFilter hwFilter = new ProgramFilter();
        filter.getIdentifierTypes().stream().forEachOrdered(hwFilter.identifierTypes::add);
        filter.getIdentifiers().stream().forEachOrdered(id2 -> hwFilter.identifiers.add(Convert.programIdentifierToHal(id2)));
        hwFilter.includeCategories = filter.areCategoriesIncluded();
        hwFilter.excludeModifications = filter.areModificationsExcluded();
        return hwFilter;
    }

    static ProgramList.Chunk programListChunkFromHal(ProgramListChunk chunk) {
        Set<RadioManager.ProgramInfo> modified = chunk.modified.stream().map(info -> Convert.programInfoFromHal(info)).collect(Collectors.toSet());
        Set<ProgramSelector.Identifier> removed = chunk.removed.stream().map(id2 -> Objects.requireNonNull(Convert.programIdentifierFromHal(id2))).collect(Collectors.toSet());
        return new ProgramList.Chunk(chunk.purge, chunk.complete, modified, removed);
    }

    public static Announcement announcementFromHal(android.hardware.broadcastradio.V2_0.Announcement hwAnnouncement) {
        return new Announcement(Convert.programSelectorFromHal(hwAnnouncement.selector), hwAnnouncement.type, Convert.vendorInfoFromHal(hwAnnouncement.vendorInfo));
    }

    static <T> ArrayList<T> listToArrayList(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list instanceof ArrayList) {
            return (ArrayList)list;
        }
        return new ArrayList<T>(list);
    }

    static {
        metadataKeys.put(1, new MetadataDef(MetadataType.STRING, "android.hardware.radio.metadata.RDS_PS"));
        metadataKeys.put(2, new MetadataDef(MetadataType.INT, "android.hardware.radio.metadata.RDS_PTY"));
        metadataKeys.put(3, new MetadataDef(MetadataType.INT, "android.hardware.radio.metadata.RBDS_PTY"));
        metadataKeys.put(4, new MetadataDef(MetadataType.STRING, "android.hardware.radio.metadata.RDS_RT"));
        metadataKeys.put(5, new MetadataDef(MetadataType.STRING, "android.hardware.radio.metadata.TITLE"));
        metadataKeys.put(6, new MetadataDef(MetadataType.STRING, "android.hardware.radio.metadata.ARTIST"));
        metadataKeys.put(7, new MetadataDef(MetadataType.STRING, "android.hardware.radio.metadata.ALBUM"));
        metadataKeys.put(8, new MetadataDef(MetadataType.INT, "android.hardware.radio.metadata.ICON"));
        metadataKeys.put(9, new MetadataDef(MetadataType.INT, "android.hardware.radio.metadata.ART"));
        metadataKeys.put(10, new MetadataDef(MetadataType.STRING, "android.hardware.radio.metadata.PROGRAM_NAME"));
        metadataKeys.put(11, new MetadataDef(MetadataType.STRING, "android.hardware.radio.metadata.DAB_ENSEMBLE_NAME"));
        metadataKeys.put(12, new MetadataDef(MetadataType.STRING, "android.hardware.radio.metadata.DAB_ENSEMBLE_NAME_SHORT"));
        metadataKeys.put(13, new MetadataDef(MetadataType.STRING, "android.hardware.radio.metadata.DAB_SERVICE_NAME"));
        metadataKeys.put(14, new MetadataDef(MetadataType.STRING, "android.hardware.radio.metadata.DAB_SERVICE_NAME_SHORT"));
        metadataKeys.put(15, new MetadataDef(MetadataType.STRING, "android.hardware.radio.metadata.DAB_COMPONENT_NAME"));
        metadataKeys.put(16, new MetadataDef(MetadataType.STRING, "android.hardware.radio.metadata.DAB_COMPONENT_NAME_SHORT"));
    }

    private static class MetadataDef {
        private MetadataType type;
        private String key;

        private MetadataDef(MetadataType type, String key) {
            this.type = type;
            this.key = key;
        }
    }

    private static enum MetadataType {
        INT,
        STRING;

    }
}

