/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.broadcastradio.hal2;

import android.hardware.broadcastradio.V2_0.ITunerCallback;
import android.hardware.broadcastradio.V2_0.ProgramInfo;
import android.hardware.broadcastradio.V2_0.ProgramListChunk;
import android.hardware.broadcastradio.V2_0.ProgramSelector;
import android.hardware.broadcastradio.V2_0.VendorKeyValue;
import android.hardware.radio.ITunerCallback;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.broadcastradio.hal2.Convert;
import java.util.ArrayList;
import java.util.Objects;

class TunerCallback
extends ITunerCallback.Stub {
    private static final String TAG = "BcRadio2Srv.cb";
    final ITunerCallback mClientCb;

    TunerCallback(ITunerCallback clientCallback) {
        this.mClientCb = Objects.requireNonNull(clientCallback);
    }

    static void dispatch(RunnableThrowingRemoteException func) {
        try {
            func.run();
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "callback call failed", ex);
        }
    }

    @Override
    public void onTuneFailed(int result, ProgramSelector selector) {
        TunerCallback.dispatch(() -> this.mClientCb.onTuneFailed(result, Convert.programSelectorFromHal(selector)));
    }

    @Override
    public void onCurrentProgramInfoChanged(ProgramInfo info) {
        TunerCallback.dispatch(() -> this.mClientCb.onCurrentProgramInfoChanged(Convert.programInfoFromHal(info)));
    }

    @Override
    public void onProgramListUpdated(ProgramListChunk chunk) {
        TunerCallback.dispatch(() -> this.mClientCb.onProgramListUpdated(Convert.programListChunkFromHal(chunk)));
    }

    @Override
    public void onAntennaStateChange(boolean connected) {
        TunerCallback.dispatch(() -> this.mClientCb.onAntennaState(connected));
    }

    @Override
    public void onParametersUpdated(ArrayList<VendorKeyValue> parameters) {
        TunerCallback.dispatch(() -> this.mClientCb.onParametersUpdated(Convert.vendorInfoFromHal(parameters)));
    }

    static interface RunnableThrowingRemoteException {
        public void run() throws RemoteException;
    }
}

