/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.net.INetd;
import android.net.INetworkStatsService;
import android.net.InterfaceConfiguration;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.net.ip.InterfaceController;
import android.net.ip.RouterAdvertisementDaemon;
import android.net.util.InterfaceParams;
import android.net.util.InterfaceSet;
import android.net.util.NetworkConstants;
import android.net.util.SharedLog;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.server.connectivity.tethering.IControlsTethering;
import com.android.server.connectivity.tethering.TetheringDependencies;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;

public class TetherInterfaceStateMachine
extends StateMachine {
    private static final IpPrefix LINK_LOCAL_PREFIX = new IpPrefix("fe80::/64");
    private static final byte DOUG_ADAMS = 42;
    private static final String USB_NEAR_IFACE_ADDR = "192.168.42.129";
    private static final int USB_PREFIX_LENGTH = 24;
    private static final String WIFI_HOST_IFACE_ADDR = "192.168.43.1";
    private static final int WIFI_HOST_IFACE_PREFIX_LENGTH = 24;
    private static final String TAG = "TetherInterfaceSM";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private static final Class[] messageClasses = new Class[]{TetherInterfaceStateMachine.class};
    private static final SparseArray<String> sMagicDecoderRing = MessageUtils.findMessageNames(messageClasses);
    private static final int BASE_IFACE = 327780;
    public static final int CMD_TETHER_REQUESTED = 327782;
    public static final int CMD_TETHER_UNREQUESTED = 327783;
    public static final int CMD_INTERFACE_DOWN = 327784;
    public static final int CMD_IP_FORWARDING_ENABLE_ERROR = 327787;
    public static final int CMD_IP_FORWARDING_DISABLE_ERROR = 327788;
    public static final int CMD_START_TETHERING_ERROR = 327789;
    public static final int CMD_STOP_TETHERING_ERROR = 327790;
    public static final int CMD_SET_DNS_FORWARDERS_ERROR = 327791;
    public static final int CMD_TETHER_CONNECTION_CHANGED = 327792;
    public static final int CMD_IPV6_TETHER_UPDATE = 327793;
    private final State mInitialState;
    private final State mLocalHotspotState;
    private final State mTetheredState;
    private final State mUnavailableState;
    private final SharedLog mLog;
    private final INetworkManagementService mNMService;
    private final INetd mNetd;
    private final INetworkStatsService mStatsService;
    private final IControlsTethering mTetherController;
    private final InterfaceController mInterfaceCtrl;
    private final String mIfaceName;
    private final int mInterfaceType;
    private final LinkProperties mLinkProperties;
    private final TetheringDependencies mDeps;
    private int mLastError;
    private int mServingMode;
    private InterfaceSet mUpstreamIfaceSet;
    private InterfaceParams mInterfaceParams;
    private LinkProperties mLastIPv6LinkProperties;
    private RouterAdvertisementDaemon mRaDaemon;
    private RouterAdvertisementDaemon.RaParams mLastRaParams;

    public TetherInterfaceStateMachine(String ifaceName, Looper looper, int interfaceType, SharedLog log, INetworkManagementService nMService, INetworkStatsService statsService, IControlsTethering tetherController, TetheringDependencies deps) {
        super(ifaceName, looper);
        this.mLog = log.forSubComponent(ifaceName);
        this.mNMService = nMService;
        this.mNetd = deps.getNetdService();
        this.mStatsService = statsService;
        this.mTetherController = tetherController;
        this.mInterfaceCtrl = new InterfaceController(ifaceName, nMService, this.mNetd, this.mLog);
        this.mIfaceName = ifaceName;
        this.mInterfaceType = interfaceType;
        this.mLinkProperties = new LinkProperties();
        this.mDeps = deps;
        this.resetLinkProperties();
        this.mLastError = 0;
        this.mServingMode = 1;
        this.mInitialState = new InitialState();
        this.mLocalHotspotState = new LocalHotspotState();
        this.mTetheredState = new TetheredState();
        this.mUnavailableState = new UnavailableState();
        this.addState(this.mInitialState);
        this.addState(this.mLocalHotspotState);
        this.addState(this.mTetheredState);
        this.addState(this.mUnavailableState);
        this.setInitialState(this.mInitialState);
    }

    public String interfaceName() {
        return this.mIfaceName;
    }

    public int interfaceType() {
        return this.mInterfaceType;
    }

    public int lastError() {
        return this.mLastError;
    }

    public int servingMode() {
        return this.mServingMode;
    }

    public LinkProperties linkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    public void stop() {
        this.sendMessage(327784);
    }

    public void unwanted() {
        this.sendMessage(327783);
    }

    private boolean startIPv4() {
        return this.configureIPv4(true);
    }

    private void stopIPv4() {
        this.configureIPv4(false);
        this.mInterfaceCtrl.clearIPv4Address();
    }

    private boolean configureIPv4(boolean enabled) {
        LinkAddress linkAddr;
        String ipAsString = null;
        int prefixLen = 0;
        if (this.mInterfaceType == 1) {
            ipAsString = USB_NEAR_IFACE_ADDR;
            prefixLen = 24;
        } else if (this.mInterfaceType == 0) {
            ipAsString = this.getRandomWifiIPv4Address();
            prefixLen = 24;
        } else {
            return true;
        }
        try {
            InterfaceConfiguration ifcg = this.mNMService.getInterfaceConfig(this.mIfaceName);
            if (ifcg == null) {
                this.mLog.e("Received null interface config");
                return false;
            }
            InetAddress addr = NetworkUtils.numericToInetAddress(ipAsString);
            linkAddr = new LinkAddress(addr, prefixLen);
            ifcg.setLinkAddress(linkAddr);
            if (this.mInterfaceType == 0) {
                ifcg.ignoreInterfaceUpDownStatus();
            } else if (enabled) {
                ifcg.setInterfaceUp();
            } else {
                ifcg.setInterfaceDown();
            }
            ifcg.clearFlag("running");
            this.mNMService.setInterfaceConfig(this.mIfaceName, ifcg);
        }
        catch (Exception e) {
            this.mLog.e("Error configuring interface " + e);
            return false;
        }
        RouteInfo route = new RouteInfo(linkAddr);
        if (enabled) {
            this.mLinkProperties.addLinkAddress(linkAddr);
            this.mLinkProperties.addRoute(route);
        } else {
            this.mLinkProperties.removeLinkAddress(linkAddr);
            this.mLinkProperties.removeRoute(route);
        }
        return true;
    }

    private String getRandomWifiIPv4Address() {
        try {
            byte[] bytes = NetworkUtils.numericToInetAddress(WIFI_HOST_IFACE_ADDR).getAddress();
            bytes[3] = TetherInterfaceStateMachine.getRandomSanitizedByte((byte)42, NetworkConstants.asByte(0), NetworkConstants.asByte(1), NetworkConstants.FF);
            return InetAddress.getByAddress(bytes).getHostAddress();
        }
        catch (Exception e) {
            return WIFI_HOST_IFACE_ADDR;
        }
    }

    private boolean startIPv6() {
        this.mInterfaceParams = this.mDeps.getInterfaceParams(this.mIfaceName);
        if (this.mInterfaceParams == null) {
            this.mLog.e("Failed to find InterfaceParams");
            this.stopIPv6();
            return false;
        }
        this.mRaDaemon = this.mDeps.getRouterAdvertisementDaemon(this.mInterfaceParams);
        if (!this.mRaDaemon.start()) {
            this.stopIPv6();
            return false;
        }
        return true;
    }

    private void stopIPv6() {
        this.mInterfaceParams = null;
        this.setRaParams(null);
        if (this.mRaDaemon != null) {
            this.mRaDaemon.stop();
            this.mRaDaemon = null;
        }
    }

    private void updateUpstreamIPv6LinkProperties(LinkProperties v6only) {
        if (this.mRaDaemon == null) {
            return;
        }
        if (Objects.equals(this.mLastIPv6LinkProperties, v6only)) {
            return;
        }
        RouterAdvertisementDaemon.RaParams params = null;
        if (v6only != null) {
            params = new RouterAdvertisementDaemon.RaParams();
            params.mtu = v6only.getMtu();
            params.hasDefaultRoute = v6only.hasIPv6DefaultRoute();
            for (LinkAddress linkAddr : v6only.getLinkAddresses()) {
                if (linkAddr.getPrefixLength() != 64) continue;
                IpPrefix prefix = new IpPrefix(linkAddr.getAddress(), linkAddr.getPrefixLength());
                params.prefixes.add(prefix);
                Inet6Address dnsServer = TetherInterfaceStateMachine.getLocalDnsIpFor(prefix);
                if (dnsServer == null) continue;
                params.dnses.add(dnsServer);
            }
        }
        this.setRaParams(params);
        this.mLastIPv6LinkProperties = v6only;
    }

    private void configureLocalIPv6Routes(HashSet<IpPrefix> deprecatedPrefixes, HashSet<IpPrefix> newPrefixes) {
        if (!deprecatedPrefixes.isEmpty()) {
            ArrayList<RouteInfo> toBeRemoved = TetherInterfaceStateMachine.getLocalRoutesFor(this.mIfaceName, deprecatedPrefixes);
            try {
                int removalFailures = this.mNMService.removeRoutesFromLocalNetwork(toBeRemoved);
                if (removalFailures > 0) {
                    this.mLog.e(String.format("Failed to remove %d IPv6 routes from local table.", removalFailures));
                }
            }
            catch (RemoteException e) {
                this.mLog.e("Failed to remove IPv6 routes from local table: " + e);
            }
            for (RouteInfo route : toBeRemoved) {
                this.mLinkProperties.removeRoute(route);
            }
        }
        if (newPrefixes != null && !newPrefixes.isEmpty()) {
            HashSet addedPrefixes = (HashSet)newPrefixes.clone();
            if (this.mLastRaParams != null) {
                addedPrefixes.removeAll(this.mLastRaParams.prefixes);
            }
            if (this.mLastRaParams == null || this.mLastRaParams.prefixes.isEmpty()) {
                addedPrefixes.add(LINK_LOCAL_PREFIX);
            }
            if (!addedPrefixes.isEmpty()) {
                ArrayList<RouteInfo> toBeAdded = TetherInterfaceStateMachine.getLocalRoutesFor(this.mIfaceName, addedPrefixes);
                try {
                    this.mNMService.addInterfaceToLocalNetwork(this.mIfaceName, toBeAdded);
                }
                catch (RemoteException e) {
                    this.mLog.e("Failed to add IPv6 routes to local table: " + e);
                }
                for (RouteInfo route : toBeAdded) {
                    this.mLinkProperties.addRoute(route);
                }
            }
        }
    }

    private void configureLocalIPv6Dns(HashSet<Inet6Address> deprecatedDnses, HashSet<Inet6Address> newDnses) {
        block11: {
            if (this.mNetd == null) {
                if (newDnses != null) {
                    newDnses.clear();
                }
                this.mLog.e("No netd service instance available; not setting local IPv6 addresses");
                return;
            }
            if (!deprecatedDnses.isEmpty()) {
                for (Inet6Address dns : deprecatedDnses) {
                    if (!this.mInterfaceCtrl.removeAddress(dns, 64)) {
                        this.mLog.e("Failed to remove local dns IP " + dns);
                    }
                    this.mLinkProperties.removeLinkAddress(new LinkAddress(dns, 64));
                }
            }
            if (newDnses != null && !newDnses.isEmpty()) {
                HashSet addedDnses = (HashSet)newDnses.clone();
                if (this.mLastRaParams != null) {
                    addedDnses.removeAll(this.mLastRaParams.dnses);
                }
                for (Inet6Address dns : addedDnses) {
                    if (!this.mInterfaceCtrl.addAddress(dns, 64)) {
                        this.mLog.e("Failed to add local dns IP " + dns);
                        newDnses.remove(dns);
                    }
                    this.mLinkProperties.addLinkAddress(new LinkAddress(dns, 64));
                }
            }
            try {
                this.mNetd.tetherApplyDnsInterfaces();
            }
            catch (RemoteException | ServiceSpecificException e) {
                this.mLog.e("Failed to update local DNS caching server");
                if (newDnses == null) break block11;
                newDnses.clear();
            }
        }
    }

    private void setRaParams(RouterAdvertisementDaemon.RaParams newParams) {
        if (this.mRaDaemon != null) {
            RouterAdvertisementDaemon.RaParams deprecatedParams = RouterAdvertisementDaemon.RaParams.getDeprecatedRaParams(this.mLastRaParams, newParams);
            this.configureLocalIPv6Routes(deprecatedParams.prefixes, newParams != null ? newParams.prefixes : null);
            this.configureLocalIPv6Dns(deprecatedParams.dnses, newParams != null ? newParams.dnses : null);
            this.mRaDaemon.buildNewRa(deprecatedParams, newParams);
        }
        this.mLastRaParams = newParams;
    }

    private void logMessage(State state, int what) {
        this.mLog.log(state.getName() + " got " + sMagicDecoderRing.get(what, Integer.toString(what)));
    }

    private void sendInterfaceState(int newInterfaceState) {
        this.mServingMode = newInterfaceState;
        this.mTetherController.updateInterfaceState(this, newInterfaceState, this.mLastError);
        this.sendLinkProperties();
    }

    private void sendLinkProperties() {
        this.mTetherController.updateLinkProperties(this, new LinkProperties(this.mLinkProperties));
    }

    private void resetLinkProperties() {
        this.mLinkProperties.clear();
        this.mLinkProperties.setInterfaceName(this.mIfaceName);
    }

    private static ArrayList<RouteInfo> getLocalRoutesFor(String ifname, HashSet<IpPrefix> prefixes) {
        ArrayList<RouteInfo> localRoutes = new ArrayList<RouteInfo>();
        for (IpPrefix ipp : prefixes) {
            localRoutes.add(new RouteInfo(ipp, null, ifname));
        }
        return localRoutes;
    }

    private static Inet6Address getLocalDnsIpFor(IpPrefix localPrefix) {
        byte[] dnsBytes = localPrefix.getRawAddress();
        dnsBytes[dnsBytes.length - 1] = TetherInterfaceStateMachine.getRandomSanitizedByte((byte)42, NetworkConstants.asByte(0), NetworkConstants.asByte(1));
        try {
            return Inet6Address.getByAddress(null, dnsBytes, 0);
        }
        catch (UnknownHostException e) {
            Slog.wtf(TAG, "Failed to construct Inet6Address from: " + localPrefix);
            return null;
        }
    }

    private static byte getRandomSanitizedByte(byte dflt, byte ... excluded) {
        byte random = (byte)new Random().nextInt();
        for (byte value : excluded) {
            if (random != value) continue;
            return dflt;
        }
        return random;
    }

    class UnavailableState
    extends State {
        UnavailableState() {
        }

        @Override
        public void enter() {
            TetherInterfaceStateMachine.this.mLastError = 0;
            TetherInterfaceStateMachine.this.sendInterfaceState(0);
        }
    }

    class TetheredState
    extends BaseServingState {
        TetheredState() {
        }

        @Override
        public void enter() {
            super.enter();
            if (TetherInterfaceStateMachine.this.mLastError != 0) {
                TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mInitialState);
            }
            TetherInterfaceStateMachine.this.sendInterfaceState(2);
        }

        @Override
        public void exit() {
            this.cleanupUpstream();
            super.exit();
        }

        private void cleanupUpstream() {
            if (TetherInterfaceStateMachine.this.mUpstreamIfaceSet == null) {
                return;
            }
            for (String ifname : ((TetherInterfaceStateMachine)TetherInterfaceStateMachine.this).mUpstreamIfaceSet.ifnames) {
                this.cleanupUpstreamInterface(ifname);
            }
            TetherInterfaceStateMachine.this.mUpstreamIfaceSet = null;
        }

        private void cleanupUpstreamInterface(String upstreamIface) {
            try {
                TetherInterfaceStateMachine.this.mStatsService.forceUpdate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                TetherInterfaceStateMachine.this.mNMService.stopInterfaceForwarding(TetherInterfaceStateMachine.this.mIfaceName, upstreamIface);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                TetherInterfaceStateMachine.this.mNMService.disableNat(TetherInterfaceStateMachine.this.mIfaceName, upstreamIface);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public boolean processMessage(Message message) {
            if (super.processMessage(message)) {
                return true;
            }
            TetherInterfaceStateMachine.this.logMessage(this, message.what);
            switch (message.what) {
                case 327782: {
                    TetherInterfaceStateMachine.this.mLog.e("CMD_TETHER_REQUESTED while already tethering.");
                    break;
                }
                case 327792: {
                    InterfaceSet newUpstreamIfaceSet = (InterfaceSet)message.obj;
                    if (this.noChangeInUpstreamIfaceSet(newUpstreamIfaceSet)) break;
                    if (newUpstreamIfaceSet == null) {
                        this.cleanupUpstream();
                        break;
                    }
                    for (String removed : this.upstreamInterfacesRemoved(newUpstreamIfaceSet)) {
                        this.cleanupUpstreamInterface(removed);
                    }
                    Set<String> added = this.upstreamInterfacesAdd(newUpstreamIfaceSet);
                    TetherInterfaceStateMachine.this.mUpstreamIfaceSet = newUpstreamIfaceSet;
                    for (String ifname : added) {
                        try {
                            TetherInterfaceStateMachine.this.mNMService.enableNat(TetherInterfaceStateMachine.this.mIfaceName, ifname);
                            TetherInterfaceStateMachine.this.mNMService.startInterfaceForwarding(TetherInterfaceStateMachine.this.mIfaceName, ifname);
                        }
                        catch (Exception e) {
                            TetherInterfaceStateMachine.this.mLog.e("Exception enabling NAT: " + e);
                            this.cleanupUpstream();
                            TetherInterfaceStateMachine.this.mLastError = 8;
                            TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mInitialState);
                            return true;
                        }
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private boolean noChangeInUpstreamIfaceSet(InterfaceSet newIfaces) {
            if (TetherInterfaceStateMachine.this.mUpstreamIfaceSet == null && newIfaces == null) {
                return true;
            }
            if (TetherInterfaceStateMachine.this.mUpstreamIfaceSet != null && newIfaces != null) {
                return TetherInterfaceStateMachine.this.mUpstreamIfaceSet.equals(newIfaces);
            }
            return false;
        }

        private Set<String> upstreamInterfacesRemoved(InterfaceSet newIfaces) {
            if (TetherInterfaceStateMachine.this.mUpstreamIfaceSet == null) {
                return new HashSet<String>();
            }
            HashSet<String> removed = new HashSet<String>(((TetherInterfaceStateMachine)TetherInterfaceStateMachine.this).mUpstreamIfaceSet.ifnames);
            removed.removeAll(newIfaces.ifnames);
            return removed;
        }

        private Set<String> upstreamInterfacesAdd(InterfaceSet newIfaces) {
            HashSet<String> added = new HashSet<String>(newIfaces.ifnames);
            if (TetherInterfaceStateMachine.this.mUpstreamIfaceSet != null) {
                added.removeAll(((TetherInterfaceStateMachine)TetherInterfaceStateMachine.this).mUpstreamIfaceSet.ifnames);
            }
            return added;
        }
    }

    class LocalHotspotState
    extends BaseServingState {
        LocalHotspotState() {
        }

        @Override
        public void enter() {
            super.enter();
            if (TetherInterfaceStateMachine.this.mLastError != 0) {
                TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mInitialState);
            }
            TetherInterfaceStateMachine.this.sendInterfaceState(3);
        }

        @Override
        public boolean processMessage(Message message) {
            if (super.processMessage(message)) {
                return true;
            }
            TetherInterfaceStateMachine.this.logMessage(this, message.what);
            switch (message.what) {
                case 327782: {
                    TetherInterfaceStateMachine.this.mLog.e("CMD_TETHER_REQUESTED while in local-only hotspot mode.");
                    break;
                }
                case 327792: {
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class BaseServingState
    extends State {
        BaseServingState() {
        }

        @Override
        public void enter() {
            if (!TetherInterfaceStateMachine.this.startIPv4()) {
                TetherInterfaceStateMachine.this.mLastError = 10;
                return;
            }
            try {
                TetherInterfaceStateMachine.this.mNMService.tetherInterface(TetherInterfaceStateMachine.this.mIfaceName);
            }
            catch (Exception e) {
                TetherInterfaceStateMachine.this.mLog.e("Error Tethering: " + e);
                TetherInterfaceStateMachine.this.mLastError = 6;
                return;
            }
            if (!TetherInterfaceStateMachine.this.startIPv6()) {
                TetherInterfaceStateMachine.this.mLog.e("Failed to startIPv6");
                return;
            }
        }

        @Override
        public void exit() {
            TetherInterfaceStateMachine.this.stopIPv6();
            try {
                TetherInterfaceStateMachine.this.mNMService.untetherInterface(TetherInterfaceStateMachine.this.mIfaceName);
            }
            catch (Exception e) {
                TetherInterfaceStateMachine.this.mLastError = 7;
                TetherInterfaceStateMachine.this.mLog.e("Failed to untether interface: " + e);
            }
            TetherInterfaceStateMachine.this.stopIPv4();
            TetherInterfaceStateMachine.this.resetLinkProperties();
        }

        @Override
        public boolean processMessage(Message message) {
            TetherInterfaceStateMachine.this.logMessage(this, message.what);
            switch (message.what) {
                case 327783: {
                    TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mInitialState);
                    break;
                }
                case 327784: {
                    TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mUnavailableState);
                    break;
                }
                case 327793: {
                    TetherInterfaceStateMachine.this.updateUpstreamIPv6LinkProperties((LinkProperties)message.obj);
                    TetherInterfaceStateMachine.this.sendLinkProperties();
                    break;
                }
                case 327787: 
                case 327788: 
                case 327789: 
                case 327790: 
                case 327791: {
                    TetherInterfaceStateMachine.this.mLastError = 5;
                    TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mInitialState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class InitialState
    extends State {
        InitialState() {
        }

        @Override
        public void enter() {
            TetherInterfaceStateMachine.this.sendInterfaceState(1);
        }

        @Override
        public boolean processMessage(Message message) {
            TetherInterfaceStateMachine.this.logMessage(this, message.what);
            block0 : switch (message.what) {
                case 327782: {
                    TetherInterfaceStateMachine.this.mLastError = 0;
                    switch (message.arg1) {
                        case 3: {
                            TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mLocalHotspotState);
                            break block0;
                        }
                        case 2: {
                            TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mTetheredState);
                            break block0;
                        }
                    }
                    TetherInterfaceStateMachine.this.mLog.e("Invalid tethering interface serving state specified.");
                    break;
                }
                case 327784: {
                    TetherInterfaceStateMachine.this.transitionTo(TetherInterfaceStateMachine.this.mUnavailableState);
                    break;
                }
                case 327793: {
                    TetherInterfaceStateMachine.this.updateUpstreamIPv6LinkProperties((LinkProperties)message.obj);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }
}

