/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.display.AmbientBrightnessDayStats;
import android.hardware.display.BrightnessChangeEvent;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.DisplayManagerInternal;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.provider.Settings;
import android.util.MathUtils;
import android.util.Slog;
import android.util.TimeUtils;
import android.view.Display;
import com.android.internal.app.IBatteryStats;
import com.android.server.LocalServices;
import com.android.server.am.BatteryStatsService;
import com.android.server.display.AutomaticBrightnessController;
import com.android.server.display.BrightnessMappingStrategy;
import com.android.server.display.BrightnessTracker;
import com.android.server.display.ColorFade;
import com.android.server.display.DisplayBlanker;
import com.android.server.display.DisplayPowerState;
import com.android.server.display.HysteresisLevels;
import com.android.server.display.RampAnimator;
import com.android.server.policy.WindowManagerPolicy;
import java.io.PrintWriter;

final class DisplayPowerController
implements AutomaticBrightnessController.Callbacks {
    private static final String TAG = "DisplayPowerController";
    private static final String SCREEN_ON_BLOCKED_TRACE_NAME = "Screen on blocked";
    private static final String SCREEN_OFF_BLOCKED_TRACE_NAME = "Screen off blocked";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_PRETEND_PROXIMITY_SENSOR_ABSENT = false;
    private static final boolean USE_COLOR_FADE_ON_ANIMATION = false;
    private static final int SCREEN_DIM_MINIMUM_REDUCTION = 10;
    private static final int COLOR_FADE_ON_ANIMATION_DURATION_MILLIS = 250;
    private static final int COLOR_FADE_OFF_ANIMATION_DURATION_MILLIS = 400;
    private static final int MSG_UPDATE_POWER_STATE = 1;
    private static final int MSG_PROXIMITY_SENSOR_DEBOUNCED = 2;
    private static final int MSG_SCREEN_ON_UNBLOCKED = 3;
    private static final int MSG_SCREEN_OFF_UNBLOCKED = 4;
    private static final int MSG_CONFIGURE_BRIGHTNESS = 5;
    private static final int MSG_SET_TEMPORARY_BRIGHTNESS = 6;
    private static final int MSG_SET_TEMPORARY_AUTO_BRIGHTNESS_ADJUSTMENT = 7;
    private static final int PROXIMITY_UNKNOWN = -1;
    private static final int PROXIMITY_NEGATIVE = 0;
    private static final int PROXIMITY_POSITIVE = 1;
    private static final int PROXIMITY_SENSOR_POSITIVE_DEBOUNCE_DELAY = 0;
    private static final int PROXIMITY_SENSOR_NEGATIVE_DEBOUNCE_DELAY = 250;
    private static final float TYPICAL_PROXIMITY_THRESHOLD = 5.0f;
    private static final int RAMP_STATE_SKIP_NONE = 0;
    private static final int RAMP_STATE_SKIP_INITIAL = 1;
    private static final int RAMP_STATE_SKIP_AUTOBRIGHT = 2;
    private static final int REPORTED_TO_POLICY_SCREEN_OFF = 0;
    private static final int REPORTED_TO_POLICY_SCREEN_TURNING_ON = 1;
    private static final int REPORTED_TO_POLICY_SCREEN_ON = 2;
    private static final int REPORTED_TO_POLICY_SCREEN_TURNING_OFF = 3;
    private final Object mLock = new Object();
    private final Context mContext;
    private final DisplayControllerHandler mHandler;
    private final DisplayManagerInternal.DisplayPowerCallbacks mCallbacks;
    private final IBatteryStats mBatteryStats;
    private final SensorManager mSensorManager;
    private final WindowManagerPolicy mWindowManagerPolicy;
    private final DisplayBlanker mBlanker;
    private final BrightnessTracker mBrightnessTracker;
    private final SettingsObserver mSettingsObserver;
    private Sensor mProximitySensor;
    private final int mScreenBrightnessDozeConfig;
    private final int mScreenBrightnessDimConfig;
    private final int mScreenBrightnessRangeMinimum;
    private final int mScreenBrightnessRangeMaximum;
    private final int mScreenBrightnessDefault;
    private final int mScreenBrightnessForVrRangeMinimum;
    private final int mScreenBrightnessForVrRangeMaximum;
    private final int mScreenBrightnessForVrDefault;
    private boolean mUseSoftwareAutoBrightnessConfig;
    private final boolean mAllowAutoBrightnessWhileDozingConfig;
    private final boolean mColorFadeEnabled;
    private boolean mColorFadeFadesConfig;
    private boolean mDisplayBlanksAfterDozeConfig;
    private boolean mBrightnessBucketsInDozeConfig;
    private DisplayManagerInternal.DisplayPowerRequest mPendingRequestLocked;
    private boolean mPendingWaitForNegativeProximityLocked;
    private boolean mPendingRequestChangedLocked;
    private boolean mDisplayReadyLocked;
    private boolean mPendingUpdatePowerStateLocked;
    private DisplayManagerInternal.DisplayPowerRequest mPowerRequest;
    private DisplayPowerState mPowerState;
    private boolean mWaitingForNegativeProximity;
    private float mProximityThreshold;
    private boolean mProximitySensorEnabled;
    private int mProximity = -1;
    private int mPendingProximity = -1;
    private long mPendingProximityDebounceTime = -1L;
    private boolean mScreenOffBecauseOfProximity;
    private ScreenOnUnblocker mPendingScreenOnUnblocker;
    private ScreenOffUnblocker mPendingScreenOffUnblocker;
    private boolean mPendingScreenOff;
    private boolean mUnfinishedBusiness;
    private long mScreenOnBlockStartRealTime;
    private long mScreenOffBlockStartRealTime;
    private int mReportedScreenStateToPolicy;
    private boolean mDozing;
    private boolean mAppliedAutoBrightness;
    private boolean mAppliedDimming;
    private boolean mAppliedLowPower;
    private boolean mAppliedScreenBrightnessOverride;
    private boolean mAppliedTemporaryBrightness;
    private boolean mAppliedTemporaryAutoBrightnessAdjustment;
    private boolean mAppliedBrightnessBoost;
    private final int mBrightnessRampRateFast;
    private final int mBrightnessRampRateSlow;
    private final boolean mSkipScreenOnBrightnessRamp;
    private int mSkipRampState = 0;
    private int mInitialAutoBrightness;
    private AutomaticBrightnessController mAutomaticBrightnessController;
    private BrightnessMappingStrategy mBrightnessMapper;
    private BrightnessConfiguration mBrightnessConfiguration;
    private int mLastUserSetScreenBrightness;
    private int mPendingScreenBrightnessSetting;
    private int mCurrentScreenBrightnessSetting;
    private int mTemporaryScreenBrightness;
    private int mScreenBrightnessForVr;
    private float mAutoBrightnessAdjustment;
    private float mPendingAutoBrightnessAdjustment;
    private float mTemporaryAutoBrightnessAdjustment;
    private ObjectAnimator mColorFadeOnAnimator;
    private ObjectAnimator mColorFadeOffAnimator;
    private RampAnimator<DisplayPowerState> mScreenBrightnessRampAnimator;
    private final Animator.AnimatorListener mAnimatorListener = new Animator.AnimatorListener(){

        @Override
        public void onAnimationStart(Animator animation) {
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            DisplayPowerController.this.sendUpdatePowerState();
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
        }

        @Override
        public void onAnimationCancel(Animator animation) {
        }
    };
    private final RampAnimator.Listener mRampAnimatorListener = new RampAnimator.Listener(){

        @Override
        public void onAnimationEnd() {
            DisplayPowerController.this.sendUpdatePowerState();
        }
    };
    private final Runnable mCleanListener = new Runnable(){

        @Override
        public void run() {
            DisplayPowerController.this.sendUpdatePowerState();
        }
    };
    private final Runnable mOnStateChangedRunnable = new Runnable(){

        @Override
        public void run() {
            DisplayPowerController.this.mCallbacks.onStateChanged();
            DisplayPowerController.this.mCallbacks.releaseSuspendBlocker();
        }
    };
    private final Runnable mOnProximityPositiveRunnable = new Runnable(){

        @Override
        public void run() {
            DisplayPowerController.this.mCallbacks.onProximityPositive();
            DisplayPowerController.this.mCallbacks.releaseSuspendBlocker();
        }
    };
    private final Runnable mOnProximityNegativeRunnable = new Runnable(){

        @Override
        public void run() {
            DisplayPowerController.this.mCallbacks.onProximityNegative();
            DisplayPowerController.this.mCallbacks.releaseSuspendBlocker();
        }
    };
    private final SensorEventListener mProximitySensorListener = new SensorEventListener(){

        @Override
        public void onSensorChanged(SensorEvent event) {
            if (DisplayPowerController.this.mProximitySensorEnabled) {
                long time = SystemClock.uptimeMillis();
                float distance = event.values[0];
                boolean positive = distance >= 0.0f && distance < DisplayPowerController.this.mProximityThreshold;
                DisplayPowerController.this.handleProximitySensorEvent(time, positive);
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    public DisplayPowerController(Context context, DisplayManagerInternal.DisplayPowerCallbacks callbacks, Handler handler, SensorManager sensorManager, DisplayBlanker blanker) {
        this.mHandler = new DisplayControllerHandler(handler.getLooper());
        this.mBrightnessTracker = new BrightnessTracker(context, null);
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mCallbacks = callbacks;
        this.mBatteryStats = BatteryStatsService.getService();
        this.mSensorManager = sensorManager;
        this.mWindowManagerPolicy = LocalServices.getService(WindowManagerPolicy.class);
        this.mBlanker = blanker;
        this.mContext = context;
        Resources resources = context.getResources();
        int screenBrightnessSettingMinimum = DisplayPowerController.clampAbsoluteBrightness(resources.getInteger(17694862));
        this.mScreenBrightnessDozeConfig = DisplayPowerController.clampAbsoluteBrightness(resources.getInteger(17694856));
        this.mScreenBrightnessDimConfig = DisplayPowerController.clampAbsoluteBrightness(resources.getInteger(17694855));
        this.mScreenBrightnessRangeMinimum = Math.min(screenBrightnessSettingMinimum, this.mScreenBrightnessDimConfig);
        this.mScreenBrightnessRangeMaximum = DisplayPowerController.clampAbsoluteBrightness(resources.getInteger(17694861));
        this.mScreenBrightnessDefault = DisplayPowerController.clampAbsoluteBrightness(resources.getInteger(17694860));
        this.mScreenBrightnessForVrRangeMinimum = DisplayPowerController.clampAbsoluteBrightness(resources.getInteger(17694859));
        this.mScreenBrightnessForVrRangeMaximum = DisplayPowerController.clampAbsoluteBrightness(resources.getInteger(17694858));
        this.mScreenBrightnessForVrDefault = DisplayPowerController.clampAbsoluteBrightness(resources.getInteger(17694857));
        this.mUseSoftwareAutoBrightnessConfig = resources.getBoolean(17956895);
        this.mAllowAutoBrightnessWhileDozingConfig = resources.getBoolean(17956872);
        this.mBrightnessRampRateFast = resources.getInteger(17694745);
        this.mBrightnessRampRateSlow = resources.getInteger(17694746);
        this.mSkipScreenOnBrightnessRamp = resources.getBoolean(17957026);
        if (this.mUseSoftwareAutoBrightnessConfig) {
            float dozeScaleFactor = resources.getFraction(0x1130003, 1, 1);
            int[] brightLevels = resources.getIntArray(17236006);
            int[] darkLevels = resources.getIntArray(17236007);
            int[] luxHysteresisLevels = resources.getIntArray(17236008);
            HysteresisLevels hysteresisLevels = new HysteresisLevels(brightLevels, darkLevels, luxHysteresisLevels);
            long brighteningLightDebounce = resources.getInteger(17694732);
            long darkeningLightDebounce = resources.getInteger(17694733);
            boolean autoBrightnessResetAmbientLuxAfterWarmUp = resources.getBoolean(17956891);
            int lightSensorWarmUpTimeConfig = resources.getInteger(17694798);
            int lightSensorRate = resources.getInteger(17694735);
            int initialLightSensorRate = resources.getInteger(0x10E000E);
            if (initialLightSensorRate == -1) {
                initialLightSensorRate = lightSensorRate;
            } else if (initialLightSensorRate > lightSensorRate) {
                Slog.w(TAG, "Expected config_autoBrightnessInitialLightSensorRate (" + initialLightSensorRate + ") to be less than or equal to config_autoBrightnessLightSensorRate (" + lightSensorRate + ").");
            }
            this.mBrightnessMapper = BrightnessMappingStrategy.create(resources);
            if (this.mBrightnessMapper != null) {
                this.mAutomaticBrightnessController = new AutomaticBrightnessController(this, handler.getLooper(), sensorManager, this.mBrightnessMapper, lightSensorWarmUpTimeConfig, this.mScreenBrightnessRangeMinimum, this.mScreenBrightnessRangeMaximum, dozeScaleFactor, lightSensorRate, initialLightSensorRate, brighteningLightDebounce, darkeningLightDebounce, autoBrightnessResetAmbientLuxAfterWarmUp, hysteresisLevels);
            } else {
                this.mUseSoftwareAutoBrightnessConfig = false;
            }
        }
        this.mColorFadeEnabled = !ActivityManager.isLowRamDeviceStatic();
        this.mColorFadeFadesConfig = resources.getBoolean(17956888);
        this.mDisplayBlanksAfterDozeConfig = resources.getBoolean(17956933);
        this.mBrightnessBucketsInDozeConfig = resources.getBoolean(17956934);
        this.mProximitySensor = this.mSensorManager.getDefaultSensor(8);
        if (this.mProximitySensor != null) {
            this.mProximityThreshold = Math.min(this.mProximitySensor.getMaximumRange(), 5.0f);
        }
        this.mCurrentScreenBrightnessSetting = this.getScreenBrightnessSetting();
        this.mScreenBrightnessForVr = this.getScreenBrightnessForVrSetting();
        this.mAutoBrightnessAdjustment = this.getAutoBrightnessAdjustmentSetting();
        this.mTemporaryScreenBrightness = -1;
        this.mPendingScreenBrightnessSetting = -1;
        this.mTemporaryAutoBrightnessAdjustment = Float.NaN;
        this.mPendingAutoBrightnessAdjustment = Float.NaN;
    }

    public boolean isProximitySensorAvailable() {
        return this.mProximitySensor != null;
    }

    public ParceledListSlice<BrightnessChangeEvent> getBrightnessEvents(int userId, boolean includePackage) {
        return this.mBrightnessTracker.getEvents(userId, includePackage);
    }

    public void onSwitchUser(int newUserId) {
        this.handleSettingsChange(true);
        this.mBrightnessTracker.onSwitchUser(newUserId);
    }

    public ParceledListSlice<AmbientBrightnessDayStats> getAmbientBrightnessStats(int userId) {
        return this.mBrightnessTracker.getAmbientBrightnessStats(userId);
    }

    public void persistBrightnessTrackerState() {
        this.mBrightnessTracker.persistBrightnessTrackerState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestPowerState(DisplayManagerInternal.DisplayPowerRequest request, boolean waitForNegativeProximity) {
        Object object = this.mLock;
        synchronized (object) {
            boolean changed = false;
            if (waitForNegativeProximity && !this.mPendingWaitForNegativeProximityLocked) {
                this.mPendingWaitForNegativeProximityLocked = true;
                changed = true;
            }
            if (this.mPendingRequestLocked == null) {
                this.mPendingRequestLocked = new DisplayManagerInternal.DisplayPowerRequest(request);
                changed = true;
            } else if (!this.mPendingRequestLocked.equals(request)) {
                this.mPendingRequestLocked.copyFrom(request);
                changed = true;
            }
            if (changed) {
                this.mDisplayReadyLocked = false;
            }
            if (changed && !this.mPendingRequestChangedLocked) {
                this.mPendingRequestChangedLocked = true;
                this.sendUpdatePowerStateLocked();
            }
            return this.mDisplayReadyLocked;
        }
    }

    public BrightnessConfiguration getDefaultBrightnessConfiguration() {
        return this.mAutomaticBrightnessController.getDefaultConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUpdatePowerState() {
        Object object = this.mLock;
        synchronized (object) {
            this.sendUpdatePowerStateLocked();
        }
    }

    private void sendUpdatePowerStateLocked() {
        if (!this.mPendingUpdatePowerStateLocked) {
            this.mPendingUpdatePowerStateLocked = true;
            Message msg = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessage(msg);
        }
    }

    private void initialize() {
        this.mPowerState = new DisplayPowerState(this.mBlanker, this.mColorFadeEnabled ? new ColorFade(0) : null);
        if (this.mColorFadeEnabled) {
            this.mColorFadeOnAnimator = ObjectAnimator.ofFloat(this.mPowerState, DisplayPowerState.COLOR_FADE_LEVEL, 0.0f, 1.0f);
            this.mColorFadeOnAnimator.setDuration(250L);
            this.mColorFadeOnAnimator.addListener(this.mAnimatorListener);
            this.mColorFadeOffAnimator = ObjectAnimator.ofFloat(this.mPowerState, DisplayPowerState.COLOR_FADE_LEVEL, 1.0f, 0.0f);
            this.mColorFadeOffAnimator.setDuration(400L);
            this.mColorFadeOffAnimator.addListener(this.mAnimatorListener);
        }
        this.mScreenBrightnessRampAnimator = new RampAnimator<DisplayPowerState>(this.mPowerState, DisplayPowerState.SCREEN_BRIGHTNESS);
        this.mScreenBrightnessRampAnimator.setListener(this.mRampAnimatorListener);
        try {
            this.mBatteryStats.noteScreenState(this.mPowerState.getScreenState());
            this.mBatteryStats.noteScreenBrightness(this.mPowerState.getScreenBrightness());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        float brightness = this.convertToNits(this.mPowerState.getScreenBrightness());
        if (brightness >= 0.0f) {
            this.mBrightnessTracker.start(brightness);
        }
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("screen_brightness"), false, this.mSettingsObserver, -1);
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("screen_brightness_for_vr"), false, this.mSettingsObserver, -1);
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("screen_auto_brightness_adj"), false, this.mSettingsObserver, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePowerState() {
        boolean finished;
        float autoBrightnessAdjustment;
        int state;
        boolean mustNotify;
        boolean mustInitialize = false;
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingUpdatePowerStateLocked = false;
            if (this.mPendingRequestLocked == null) {
                return;
            }
            if (this.mPowerRequest == null) {
                this.mPowerRequest = new DisplayManagerInternal.DisplayPowerRequest(this.mPendingRequestLocked);
                this.mWaitingForNegativeProximity = this.mPendingWaitForNegativeProximityLocked;
                this.mPendingWaitForNegativeProximityLocked = false;
                this.mPendingRequestChangedLocked = false;
                mustInitialize = true;
            } else if (this.mPendingRequestChangedLocked) {
                this.mPowerRequest.copyFrom(this.mPendingRequestLocked);
                this.mWaitingForNegativeProximity |= this.mPendingWaitForNegativeProximityLocked;
                this.mPendingWaitForNegativeProximityLocked = false;
                this.mPendingRequestChangedLocked = false;
                this.mDisplayReadyLocked = false;
            }
            mustNotify = !this.mDisplayReadyLocked;
        }
        if (mustInitialize) {
            this.initialize();
        }
        int brightness = -1;
        boolean performScreenOffTransition = false;
        switch (this.mPowerRequest.policy) {
            case 0: {
                state = 1;
                performScreenOffTransition = true;
                break;
            }
            case 1: {
                state = this.mPowerRequest.dozeScreenState != 0 ? this.mPowerRequest.dozeScreenState : 3;
                if (this.mAllowAutoBrightnessWhileDozingConfig) break;
                brightness = this.mPowerRequest.dozeScreenBrightness;
                break;
            }
            case 4: {
                state = 5;
                break;
            }
            default: {
                state = 2;
            }
        }
        assert (state != 0);
        if (this.mProximitySensor != null) {
            if (this.mPowerRequest.useProximitySensor && state != 1) {
                this.setProximitySensorEnabled(true);
                if (!this.mScreenOffBecauseOfProximity && this.mProximity == 1) {
                    this.mScreenOffBecauseOfProximity = true;
                    this.sendOnProximityPositiveWithWakelock();
                }
            } else if (this.mWaitingForNegativeProximity && this.mScreenOffBecauseOfProximity && this.mProximity == 1 && state != 1) {
                this.setProximitySensorEnabled(true);
            } else {
                this.setProximitySensorEnabled(false);
                this.mWaitingForNegativeProximity = false;
            }
            if (this.mScreenOffBecauseOfProximity && this.mProximity != 1) {
                this.mScreenOffBecauseOfProximity = false;
                this.sendOnProximityNegativeWithWakelock();
            }
        } else {
            this.mWaitingForNegativeProximity = false;
        }
        if (this.mScreenOffBecauseOfProximity) {
            state = 1;
        }
        int oldState = this.mPowerState.getScreenState();
        this.animateScreenStateChange(state, performScreenOffTransition);
        state = this.mPowerState.getScreenState();
        if (state == 1) {
            brightness = 0;
        }
        if (state == 5) {
            brightness = this.mScreenBrightnessForVr;
        }
        if (brightness < 0 && this.mPowerRequest.screenBrightnessOverride > 0) {
            brightness = this.mPowerRequest.screenBrightnessOverride;
            this.mAppliedScreenBrightnessOverride = true;
        } else {
            this.mAppliedScreenBrightnessOverride = false;
        }
        boolean autoBrightnessEnabledInDoze = this.mAllowAutoBrightnessWhileDozingConfig && Display.isDozeState(state);
        boolean autoBrightnessEnabled = this.mPowerRequest.useAutoBrightness && (state == 2 || autoBrightnessEnabledInDoze) && brightness < 0 && this.mAutomaticBrightnessController != null;
        boolean userSetBrightnessChanged = this.updateUserSetScreenBrightness();
        if (userSetBrightnessChanged) {
            this.mTemporaryScreenBrightness = -1;
        }
        if (this.mTemporaryScreenBrightness > 0) {
            brightness = this.mTemporaryScreenBrightness;
            this.mAppliedTemporaryBrightness = true;
        } else {
            this.mAppliedTemporaryBrightness = false;
        }
        boolean autoBrightnessAdjustmentChanged = this.updateAutoBrightnessAdjustment();
        if (autoBrightnessAdjustmentChanged) {
            this.mTemporaryAutoBrightnessAdjustment = Float.NaN;
        }
        if (!Float.isNaN(this.mTemporaryAutoBrightnessAdjustment)) {
            autoBrightnessAdjustment = this.mTemporaryAutoBrightnessAdjustment;
            this.mAppliedTemporaryAutoBrightnessAdjustment = true;
        } else {
            autoBrightnessAdjustment = this.mAutoBrightnessAdjustment;
            this.mAppliedTemporaryAutoBrightnessAdjustment = false;
        }
        if (this.mPowerRequest.boostScreenBrightness && brightness != 0) {
            brightness = 255;
            this.mAppliedBrightnessBoost = true;
        } else {
            this.mAppliedBrightnessBoost = false;
        }
        boolean userInitiatedChange = brightness < 0 && (autoBrightnessAdjustmentChanged || userSetBrightnessChanged);
        boolean hadUserBrightnessPoint = false;
        if (this.mAutomaticBrightnessController != null) {
            hadUserBrightnessPoint = this.mAutomaticBrightnessController.hasUserDataPoints();
            this.mAutomaticBrightnessController.configure(autoBrightnessEnabled, this.mBrightnessConfiguration, (float)this.mLastUserSetScreenBrightness / 255.0f, userSetBrightnessChanged, autoBrightnessAdjustment, autoBrightnessAdjustmentChanged, this.mPowerRequest.policy);
        }
        boolean slowChange = false;
        if (brightness < 0) {
            float newAutoBrightnessAdjustment = autoBrightnessAdjustment;
            if (autoBrightnessEnabled) {
                brightness = this.mAutomaticBrightnessController.getAutomaticScreenBrightness();
                newAutoBrightnessAdjustment = this.mAutomaticBrightnessController.getAutomaticScreenBrightnessAdjustment();
            }
            if (brightness >= 0) {
                brightness = this.clampScreenBrightness(brightness);
                if (this.mAppliedAutoBrightness && !autoBrightnessAdjustmentChanged) {
                    slowChange = true;
                }
                this.putScreenBrightnessSetting(brightness);
                this.mAppliedAutoBrightness = true;
            } else {
                this.mAppliedAutoBrightness = false;
            }
            if (autoBrightnessAdjustment != newAutoBrightnessAdjustment) {
                this.putAutoBrightnessAdjustmentSetting(newAutoBrightnessAdjustment);
            }
        } else {
            this.mAppliedAutoBrightness = false;
        }
        if (brightness < 0 && Display.isDozeState(state)) {
            brightness = this.mScreenBrightnessDozeConfig;
        }
        if (brightness < 0) {
            brightness = this.clampScreenBrightness(this.mCurrentScreenBrightnessSetting);
        }
        if (this.mPowerRequest.policy == 2) {
            if (brightness > this.mScreenBrightnessRangeMinimum) {
                brightness = Math.max(Math.min(brightness - 10, this.mScreenBrightnessDimConfig), this.mScreenBrightnessRangeMinimum);
            }
            if (!this.mAppliedDimming) {
                slowChange = false;
            }
            this.mAppliedDimming = true;
        } else if (this.mAppliedDimming) {
            slowChange = false;
            this.mAppliedDimming = false;
        }
        if (this.mPowerRequest.lowPowerMode) {
            if (brightness > this.mScreenBrightnessRangeMinimum) {
                float brightnessFactor = Math.min(this.mPowerRequest.screenLowPowerBrightnessFactor, 1.0f);
                int lowPowerBrightness = (int)((float)brightness * brightnessFactor);
                brightness = Math.max(lowPowerBrightness, this.mScreenBrightnessRangeMinimum);
            }
            if (!this.mAppliedLowPower) {
                slowChange = false;
            }
            this.mAppliedLowPower = true;
        } else if (this.mAppliedLowPower) {
            slowChange = false;
            this.mAppliedLowPower = false;
        }
        if (!this.mPendingScreenOff) {
            boolean brightnessIsTemporary;
            if (this.mSkipScreenOnBrightnessRamp) {
                if (state == 2) {
                    if (this.mSkipRampState == 0 && this.mDozing) {
                        this.mInitialAutoBrightness = brightness;
                        this.mSkipRampState = 1;
                    } else if (this.mSkipRampState == 1 && this.mUseSoftwareAutoBrightnessConfig && brightness != this.mInitialAutoBrightness) {
                        this.mSkipRampState = 2;
                    } else if (this.mSkipRampState == 2) {
                        this.mSkipRampState = 0;
                    }
                } else {
                    this.mSkipRampState = 0;
                }
            }
            boolean wasOrWillBeInVr = state == 5 || oldState == 5;
            boolean initialRampSkip = state == 2 && this.mSkipRampState != 0;
            boolean hasBrightnessBuckets = Display.isDozeState(state) && this.mBrightnessBucketsInDozeConfig;
            boolean isDisplayContentVisible = this.mColorFadeEnabled && this.mPowerState.getColorFadeLevel() == 1.0f;
            boolean bl = brightnessIsTemporary = this.mAppliedTemporaryBrightness || this.mAppliedTemporaryAutoBrightnessAdjustment;
            if (initialRampSkip || hasBrightnessBuckets || wasOrWillBeInVr || !isDisplayContentVisible || brightnessIsTemporary) {
                this.animateScreenBrightness(brightness, 0);
            } else {
                this.animateScreenBrightness(brightness, slowChange ? this.mBrightnessRampRateSlow : this.mBrightnessRampRateFast);
            }
            if (!brightnessIsTemporary) {
                this.notifyBrightnessChanged(brightness, userInitiatedChange, hadUserBrightnessPoint);
            }
        }
        boolean ready = this.mPendingScreenOnUnblocker == null && (!this.mColorFadeEnabled || !this.mColorFadeOnAnimator.isStarted() && !this.mColorFadeOffAnimator.isStarted()) && this.mPowerState.waitUntilClean(this.mCleanListener);
        boolean bl = finished = ready && !this.mScreenBrightnessRampAnimator.isAnimating();
        if (ready && state != 1 && this.mReportedScreenStateToPolicy == 1) {
            this.setReportedScreenState(2);
            this.mWindowManagerPolicy.screenTurnedOn();
        }
        if (!finished && !this.mUnfinishedBusiness) {
            this.mCallbacks.acquireSuspendBlocker();
            this.mUnfinishedBusiness = true;
        }
        if (ready && mustNotify) {
            Object object2 = this.mLock;
            synchronized (object2) {
                if (!this.mPendingRequestChangedLocked) {
                    this.mDisplayReadyLocked = true;
                }
            }
            this.sendOnStateChangedWithWakelock();
        }
        if (finished && this.mUnfinishedBusiness) {
            this.mUnfinishedBusiness = false;
            this.mCallbacks.releaseSuspendBlocker();
        }
        this.mDozing = state != 2;
    }

    @Override
    public void updateBrightness() {
        this.sendUpdatePowerState();
    }

    public void setBrightnessConfiguration(BrightnessConfiguration c) {
        Message msg = this.mHandler.obtainMessage(5, c);
        msg.sendToTarget();
    }

    public void setTemporaryBrightness(int brightness) {
        Message msg = this.mHandler.obtainMessage(6, brightness, 0);
        msg.sendToTarget();
    }

    public void setTemporaryAutoBrightnessAdjustment(float adjustment) {
        Message msg = this.mHandler.obtainMessage(7, Float.floatToIntBits(adjustment), 0);
        msg.sendToTarget();
    }

    private void blockScreenOn() {
        if (this.mPendingScreenOnUnblocker == null) {
            Trace.asyncTraceBegin(131072L, SCREEN_ON_BLOCKED_TRACE_NAME, 0);
            this.mPendingScreenOnUnblocker = new ScreenOnUnblocker();
            this.mScreenOnBlockStartRealTime = SystemClock.elapsedRealtime();
            Slog.i(TAG, "Blocking screen on until initial contents have been drawn.");
        }
    }

    private void unblockScreenOn() {
        if (this.mPendingScreenOnUnblocker != null) {
            this.mPendingScreenOnUnblocker = null;
            long delay = SystemClock.elapsedRealtime() - this.mScreenOnBlockStartRealTime;
            Slog.i(TAG, "Unblocked screen on after " + delay + " ms");
            Trace.asyncTraceEnd(131072L, SCREEN_ON_BLOCKED_TRACE_NAME, 0);
        }
    }

    private void blockScreenOff() {
        if (this.mPendingScreenOffUnblocker == null) {
            Trace.asyncTraceBegin(131072L, SCREEN_OFF_BLOCKED_TRACE_NAME, 0);
            this.mPendingScreenOffUnblocker = new ScreenOffUnblocker();
            this.mScreenOffBlockStartRealTime = SystemClock.elapsedRealtime();
            Slog.i(TAG, "Blocking screen off");
        }
    }

    private void unblockScreenOff() {
        if (this.mPendingScreenOffUnblocker != null) {
            this.mPendingScreenOffUnblocker = null;
            long delay = SystemClock.elapsedRealtime() - this.mScreenOffBlockStartRealTime;
            Slog.i(TAG, "Unblocked screen off after " + delay + " ms");
            Trace.asyncTraceEnd(131072L, SCREEN_OFF_BLOCKED_TRACE_NAME, 0);
        }
    }

    private boolean setScreenState(int state) {
        return this.setScreenState(state, false);
    }

    private boolean setScreenState(int state, boolean reportOnly) {
        boolean isOff;
        boolean bl = isOff = state == 1;
        if (this.mPowerState.getScreenState() != state) {
            if (isOff && !this.mScreenOffBecauseOfProximity) {
                if (this.mReportedScreenStateToPolicy == 2) {
                    this.setReportedScreenState(3);
                    this.blockScreenOff();
                    this.mWindowManagerPolicy.screenTurningOff(this.mPendingScreenOffUnblocker);
                    this.unblockScreenOff();
                } else if (this.mPendingScreenOffUnblocker != null) {
                    return false;
                }
            }
            if (!reportOnly) {
                Trace.traceCounter(131072L, "ScreenState", state);
                this.mPowerState.setScreenState(state);
                try {
                    this.mBatteryStats.noteScreenState(state);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        if (isOff && this.mReportedScreenStateToPolicy != 0 && !this.mScreenOffBecauseOfProximity) {
            this.setReportedScreenState(0);
            this.unblockScreenOn();
            this.mWindowManagerPolicy.screenTurnedOff();
        } else if (!isOff && this.mReportedScreenStateToPolicy == 3) {
            this.unblockScreenOff();
            this.mWindowManagerPolicy.screenTurnedOff();
            this.setReportedScreenState(0);
        }
        if (!isOff && this.mReportedScreenStateToPolicy == 0) {
            this.setReportedScreenState(1);
            if (this.mPowerState.getColorFadeLevel() == 0.0f) {
                this.blockScreenOn();
            } else {
                this.unblockScreenOn();
            }
            this.mWindowManagerPolicy.screenTurningOn(this.mPendingScreenOnUnblocker);
        }
        return this.mPendingScreenOnUnblocker == null;
    }

    private void setReportedScreenState(int state) {
        Trace.traceCounter(131072L, "ReportedScreenStateToPolicy", state);
        this.mReportedScreenStateToPolicy = state;
    }

    private int clampScreenBrightnessForVr(int value) {
        return MathUtils.constrain(value, this.mScreenBrightnessForVrRangeMinimum, this.mScreenBrightnessForVrRangeMaximum);
    }

    private int clampScreenBrightness(int value) {
        return MathUtils.constrain(value, this.mScreenBrightnessRangeMinimum, this.mScreenBrightnessRangeMaximum);
    }

    private void animateScreenBrightness(int target, int rate) {
        if (this.mScreenBrightnessRampAnimator.animateTo(target, rate)) {
            Trace.traceCounter(131072L, "TargetScreenBrightness", target);
            try {
                this.mBatteryStats.noteScreenBrightness(target);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void animateScreenStateChange(int target, boolean performScreenOffTransition) {
        if (this.mColorFadeEnabled && (this.mColorFadeOnAnimator.isStarted() || this.mColorFadeOffAnimator.isStarted())) {
            if (target != 2) {
                return;
            }
            this.mPendingScreenOff = false;
        }
        if (this.mDisplayBlanksAfterDozeConfig && Display.isDozeState(this.mPowerState.getScreenState()) && !Display.isDozeState(target)) {
            this.mPowerState.prepareColorFade(this.mContext, this.mColorFadeFadesConfig ? 2 : 0);
            if (this.mColorFadeOffAnimator != null) {
                this.mColorFadeOffAnimator.end();
            }
            this.setScreenState(1, target != 1);
        }
        if (this.mPendingScreenOff && target != 1) {
            this.setScreenState(1);
            this.mPendingScreenOff = false;
            this.mPowerState.dismissColorFadeResources();
        }
        if (target == 2) {
            if (!this.setScreenState(2)) {
                return;
            }
            this.mPowerState.setColorFadeLevel(1.0f);
            this.mPowerState.dismissColorFade();
        } else if (target == 5) {
            if (this.mScreenBrightnessRampAnimator.isAnimating() && this.mPowerState.getScreenState() == 2) {
                return;
            }
            if (!this.setScreenState(5)) {
                return;
            }
            this.mPowerState.setColorFadeLevel(1.0f);
            this.mPowerState.dismissColorFade();
        } else if (target == 3) {
            if (this.mScreenBrightnessRampAnimator.isAnimating() && this.mPowerState.getScreenState() == 2) {
                return;
            }
            if (!this.setScreenState(3)) {
                return;
            }
            this.mPowerState.setColorFadeLevel(1.0f);
            this.mPowerState.dismissColorFade();
        } else if (target == 4) {
            if (this.mScreenBrightnessRampAnimator.isAnimating() && this.mPowerState.getScreenState() != 4) {
                return;
            }
            if (this.mPowerState.getScreenState() != 4) {
                if (!this.setScreenState(3)) {
                    return;
                }
                this.setScreenState(4);
            }
            this.mPowerState.setColorFadeLevel(1.0f);
            this.mPowerState.dismissColorFade();
        } else if (target == 6) {
            if (this.mScreenBrightnessRampAnimator.isAnimating() && this.mPowerState.getScreenState() != 6) {
                return;
            }
            if (this.mPowerState.getScreenState() != 6) {
                if (!this.setScreenState(2)) {
                    return;
                }
                this.setScreenState(6);
            }
            this.mPowerState.setColorFadeLevel(1.0f);
            this.mPowerState.dismissColorFade();
        } else {
            this.mPendingScreenOff = true;
            if (!this.mColorFadeEnabled) {
                this.mPowerState.setColorFadeLevel(0.0f);
            }
            if (this.mPowerState.getColorFadeLevel() == 0.0f) {
                this.setScreenState(1);
                this.mPendingScreenOff = false;
                this.mPowerState.dismissColorFadeResources();
            } else if (performScreenOffTransition && this.mPowerState.prepareColorFade(this.mContext, this.mColorFadeFadesConfig ? 2 : 1) && this.mPowerState.getScreenState() != 1) {
                this.mColorFadeOffAnimator.start();
            } else {
                this.mColorFadeOffAnimator.end();
            }
        }
    }

    private void setProximitySensorEnabled(boolean enable) {
        if (enable) {
            if (!this.mProximitySensorEnabled) {
                this.mProximitySensorEnabled = true;
                this.mSensorManager.registerListener(this.mProximitySensorListener, this.mProximitySensor, 3, this.mHandler);
            }
        } else if (this.mProximitySensorEnabled) {
            this.mProximitySensorEnabled = false;
            this.mProximity = -1;
            this.mPendingProximity = -1;
            this.mHandler.removeMessages(2);
            this.mSensorManager.unregisterListener(this.mProximitySensorListener);
            this.clearPendingProximityDebounceTime();
        }
    }

    private void handleProximitySensorEvent(long time, boolean positive) {
        if (this.mProximitySensorEnabled) {
            if (this.mPendingProximity == 0 && !positive) {
                return;
            }
            if (this.mPendingProximity == 1 && positive) {
                return;
            }
            this.mHandler.removeMessages(2);
            if (positive) {
                this.mPendingProximity = 1;
                this.setPendingProximityDebounceTime(time + 0L);
            } else {
                this.mPendingProximity = 0;
                this.setPendingProximityDebounceTime(time + 250L);
            }
            this.debounceProximitySensor();
        }
    }

    private void debounceProximitySensor() {
        if (this.mProximitySensorEnabled && this.mPendingProximity != -1 && this.mPendingProximityDebounceTime >= 0L) {
            long now = SystemClock.uptimeMillis();
            if (this.mPendingProximityDebounceTime <= now) {
                this.mProximity = this.mPendingProximity;
                this.updatePowerState();
                this.clearPendingProximityDebounceTime();
            } else {
                Message msg = this.mHandler.obtainMessage(2);
                this.mHandler.sendMessageAtTime(msg, this.mPendingProximityDebounceTime);
            }
        }
    }

    private void clearPendingProximityDebounceTime() {
        if (this.mPendingProximityDebounceTime >= 0L) {
            this.mPendingProximityDebounceTime = -1L;
            this.mCallbacks.releaseSuspendBlocker();
        }
    }

    private void setPendingProximityDebounceTime(long debounceTime) {
        if (this.mPendingProximityDebounceTime < 0L) {
            this.mCallbacks.acquireSuspendBlocker();
        }
        this.mPendingProximityDebounceTime = debounceTime;
    }

    private void sendOnStateChangedWithWakelock() {
        this.mCallbacks.acquireSuspendBlocker();
        this.mHandler.post(this.mOnStateChangedRunnable);
    }

    private void handleSettingsChange(boolean userSwitch) {
        this.mPendingScreenBrightnessSetting = this.getScreenBrightnessSetting();
        if (userSwitch) {
            this.mCurrentScreenBrightnessSetting = this.mPendingScreenBrightnessSetting;
            if (this.mAutomaticBrightnessController != null) {
                this.mAutomaticBrightnessController.resetShortTermModel();
            }
        }
        this.mPendingAutoBrightnessAdjustment = this.getAutoBrightnessAdjustmentSetting();
        this.mScreenBrightnessForVr = this.getScreenBrightnessForVrSetting();
        this.sendUpdatePowerState();
    }

    private float getAutoBrightnessAdjustmentSetting() {
        float adj = Settings.System.getFloatForUser(this.mContext.getContentResolver(), "screen_auto_brightness_adj", 0.0f, -2);
        return Float.isNaN(adj) ? 0.0f : DisplayPowerController.clampAutoBrightnessAdjustment(adj);
    }

    private int getScreenBrightnessSetting() {
        int brightness = Settings.System.getIntForUser(this.mContext.getContentResolver(), "screen_brightness", this.mScreenBrightnessDefault, -2);
        return DisplayPowerController.clampAbsoluteBrightness(brightness);
    }

    private int getScreenBrightnessForVrSetting() {
        int brightness = Settings.System.getIntForUser(this.mContext.getContentResolver(), "screen_brightness_for_vr", this.mScreenBrightnessForVrDefault, -2);
        return this.clampScreenBrightnessForVr(brightness);
    }

    private void putScreenBrightnessSetting(int brightness) {
        this.mCurrentScreenBrightnessSetting = brightness;
        Settings.System.putIntForUser(this.mContext.getContentResolver(), "screen_brightness", brightness, -2);
    }

    private void putAutoBrightnessAdjustmentSetting(float adjustment) {
        this.mAutoBrightnessAdjustment = adjustment;
        Settings.System.putFloatForUser(this.mContext.getContentResolver(), "screen_auto_brightness_adj", adjustment, -2);
    }

    private boolean updateAutoBrightnessAdjustment() {
        if (Float.isNaN(this.mPendingAutoBrightnessAdjustment)) {
            return false;
        }
        if (this.mAutoBrightnessAdjustment == this.mPendingAutoBrightnessAdjustment) {
            this.mPendingAutoBrightnessAdjustment = Float.NaN;
            return false;
        }
        this.mAutoBrightnessAdjustment = this.mPendingAutoBrightnessAdjustment;
        this.mPendingAutoBrightnessAdjustment = Float.NaN;
        return true;
    }

    private boolean updateUserSetScreenBrightness() {
        if (this.mPendingScreenBrightnessSetting < 0) {
            return false;
        }
        if (this.mCurrentScreenBrightnessSetting == this.mPendingScreenBrightnessSetting) {
            this.mPendingScreenBrightnessSetting = -1;
            return false;
        }
        this.mCurrentScreenBrightnessSetting = this.mPendingScreenBrightnessSetting;
        this.mLastUserSetScreenBrightness = this.mPendingScreenBrightnessSetting;
        this.mPendingScreenBrightnessSetting = -1;
        return true;
    }

    private void notifyBrightnessChanged(int brightness, boolean userInitiated, boolean hadUserDataPoint) {
        float brightnessInNits = this.convertToNits(brightness);
        if (this.mPowerRequest.useAutoBrightness && brightnessInNits >= 0.0f && this.mAutomaticBrightnessController != null) {
            float powerFactor = this.mPowerRequest.lowPowerMode ? this.mPowerRequest.screenLowPowerBrightnessFactor : 1.0f;
            this.mBrightnessTracker.notifyBrightnessChanged(brightnessInNits, userInitiated, powerFactor, hadUserDataPoint, this.mAutomaticBrightnessController.isDefaultConfig());
        }
    }

    private float convertToNits(int backlight) {
        if (this.mBrightnessMapper != null) {
            return this.mBrightnessMapper.convertToNits(backlight);
        }
        return -1.0f;
    }

    private void sendOnProximityPositiveWithWakelock() {
        this.mCallbacks.acquireSuspendBlocker();
        this.mHandler.post(this.mOnProximityPositiveRunnable);
    }

    private void sendOnProximityNegativeWithWakelock() {
        this.mCallbacks.acquireSuspendBlocker();
        this.mHandler.post(this.mOnProximityNegativeRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(final PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println();
            pw.println("Display Power Controller Locked State:");
            pw.println("  mDisplayReadyLocked=" + this.mDisplayReadyLocked);
            pw.println("  mPendingRequestLocked=" + this.mPendingRequestLocked);
            pw.println("  mPendingRequestChangedLocked=" + this.mPendingRequestChangedLocked);
            pw.println("  mPendingWaitForNegativeProximityLocked=" + this.mPendingWaitForNegativeProximityLocked);
            pw.println("  mPendingUpdatePowerStateLocked=" + this.mPendingUpdatePowerStateLocked);
        }
        pw.println();
        pw.println("Display Power Controller Configuration:");
        pw.println("  mScreenBrightnessDozeConfig=" + this.mScreenBrightnessDozeConfig);
        pw.println("  mScreenBrightnessDimConfig=" + this.mScreenBrightnessDimConfig);
        pw.println("  mScreenBrightnessRangeMinimum=" + this.mScreenBrightnessRangeMinimum);
        pw.println("  mScreenBrightnessRangeMaximum=" + this.mScreenBrightnessRangeMaximum);
        pw.println("  mScreenBrightnessDefault=" + this.mScreenBrightnessDefault);
        pw.println("  mScreenBrightnessForVrRangeMinimum=" + this.mScreenBrightnessForVrRangeMinimum);
        pw.println("  mScreenBrightnessForVrRangeMaximum=" + this.mScreenBrightnessForVrRangeMaximum);
        pw.println("  mScreenBrightnessForVrDefault=" + this.mScreenBrightnessForVrDefault);
        pw.println("  mUseSoftwareAutoBrightnessConfig=" + this.mUseSoftwareAutoBrightnessConfig);
        pw.println("  mAllowAutoBrightnessWhileDozingConfig=" + this.mAllowAutoBrightnessWhileDozingConfig);
        pw.println("  mBrightnessRampRateFast=" + this.mBrightnessRampRateFast);
        pw.println("  mBrightnessRampRateSlow=" + this.mBrightnessRampRateSlow);
        pw.println("  mSkipScreenOnBrightnessRamp=" + this.mSkipScreenOnBrightnessRamp);
        pw.println("  mColorFadeFadesConfig=" + this.mColorFadeFadesConfig);
        pw.println("  mColorFadeEnabled=" + this.mColorFadeEnabled);
        pw.println("  mDisplayBlanksAfterDozeConfig=" + this.mDisplayBlanksAfterDozeConfig);
        pw.println("  mBrightnessBucketsInDozeConfig=" + this.mBrightnessBucketsInDozeConfig);
        this.mHandler.runWithScissors(new Runnable(){

            @Override
            public void run() {
                DisplayPowerController.this.dumpLocal(pw);
            }
        }, 1000L);
    }

    private void dumpLocal(PrintWriter pw) {
        pw.println();
        pw.println("Display Power Controller Thread State:");
        pw.println("  mPowerRequest=" + this.mPowerRequest);
        pw.println("  mUnfinishedBusiness=" + this.mUnfinishedBusiness);
        pw.println("  mWaitingForNegativeProximity=" + this.mWaitingForNegativeProximity);
        pw.println("  mProximitySensor=" + this.mProximitySensor);
        pw.println("  mProximitySensorEnabled=" + this.mProximitySensorEnabled);
        pw.println("  mProximityThreshold=" + this.mProximityThreshold);
        pw.println("  mProximity=" + DisplayPowerController.proximityToString(this.mProximity));
        pw.println("  mPendingProximity=" + DisplayPowerController.proximityToString(this.mPendingProximity));
        pw.println("  mPendingProximityDebounceTime=" + TimeUtils.formatUptime(this.mPendingProximityDebounceTime));
        pw.println("  mScreenOffBecauseOfProximity=" + this.mScreenOffBecauseOfProximity);
        pw.println("  mLastUserSetScreenBrightness=" + this.mLastUserSetScreenBrightness);
        pw.println("  mCurrentScreenBrightnessSetting=" + this.mCurrentScreenBrightnessSetting);
        pw.println("  mPendingScreenBrightnessSetting=" + this.mPendingScreenBrightnessSetting);
        pw.println("  mTemporaryScreenBrightness=" + this.mTemporaryScreenBrightness);
        pw.println("  mAutoBrightnessAdjustment=" + this.mAutoBrightnessAdjustment);
        pw.println("  mTemporaryAutoBrightnessAdjustment=" + this.mTemporaryAutoBrightnessAdjustment);
        pw.println("  mPendingAutoBrightnessAdjustment=" + this.mPendingAutoBrightnessAdjustment);
        pw.println("  mScreenBrightnessForVr=" + this.mScreenBrightnessForVr);
        pw.println("  mAppliedAutoBrightness=" + this.mAppliedAutoBrightness);
        pw.println("  mAppliedDimming=" + this.mAppliedDimming);
        pw.println("  mAppliedLowPower=" + this.mAppliedLowPower);
        pw.println("  mAppliedScreenBrightnessOverride=" + this.mAppliedScreenBrightnessOverride);
        pw.println("  mAppliedTemporaryBrightness=" + this.mAppliedTemporaryBrightness);
        pw.println("  mDozing=" + this.mDozing);
        pw.println("  mSkipRampState=" + DisplayPowerController.skipRampStateToString(this.mSkipRampState));
        pw.println("  mInitialAutoBrightness=" + this.mInitialAutoBrightness);
        pw.println("  mScreenOnBlockStartRealTime=" + this.mScreenOnBlockStartRealTime);
        pw.println("  mScreenOffBlockStartRealTime=" + this.mScreenOffBlockStartRealTime);
        pw.println("  mPendingScreenOnUnblocker=" + this.mPendingScreenOnUnblocker);
        pw.println("  mPendingScreenOffUnblocker=" + this.mPendingScreenOffUnblocker);
        pw.println("  mPendingScreenOff=" + this.mPendingScreenOff);
        pw.println("  mReportedToPolicy=" + DisplayPowerController.reportedToPolicyToString(this.mReportedScreenStateToPolicy));
        pw.println("  mScreenBrightnessRampAnimator.isAnimating()=" + this.mScreenBrightnessRampAnimator.isAnimating());
        if (this.mColorFadeOnAnimator != null) {
            pw.println("  mColorFadeOnAnimator.isStarted()=" + this.mColorFadeOnAnimator.isStarted());
        }
        if (this.mColorFadeOffAnimator != null) {
            pw.println("  mColorFadeOffAnimator.isStarted()=" + this.mColorFadeOffAnimator.isStarted());
        }
        if (this.mPowerState != null) {
            this.mPowerState.dump(pw);
        }
        if (this.mAutomaticBrightnessController != null) {
            this.mAutomaticBrightnessController.dump(pw);
        }
        if (this.mBrightnessTracker != null) {
            pw.println();
            this.mBrightnessTracker.dump(pw);
        }
    }

    private static String proximityToString(int state) {
        switch (state) {
            case -1: {
                return "Unknown";
            }
            case 0: {
                return "Negative";
            }
            case 1: {
                return "Positive";
            }
        }
        return Integer.toString(state);
    }

    private static String reportedToPolicyToString(int state) {
        switch (state) {
            case 0: {
                return "REPORTED_TO_POLICY_SCREEN_OFF";
            }
            case 1: {
                return "REPORTED_TO_POLICY_SCREEN_TURNING_ON";
            }
            case 2: {
                return "REPORTED_TO_POLICY_SCREEN_ON";
            }
        }
        return Integer.toString(state);
    }

    private static String skipRampStateToString(int state) {
        switch (state) {
            case 0: {
                return "RAMP_STATE_SKIP_NONE";
            }
            case 1: {
                return "RAMP_STATE_SKIP_INITIAL";
            }
            case 2: {
                return "RAMP_STATE_SKIP_AUTOBRIGHT";
            }
        }
        return Integer.toString(state);
    }

    private static int clampAbsoluteBrightness(int value) {
        return MathUtils.constrain(value, 0, 255);
    }

    private static float clampAutoBrightnessAdjustment(float value) {
        return MathUtils.constrain(value, -1.0f, 1.0f);
    }

    private final class ScreenOffUnblocker
    implements WindowManagerPolicy.ScreenOffListener {
        private ScreenOffUnblocker() {
        }

        @Override
        public void onScreenOff() {
            Message msg = DisplayPowerController.this.mHandler.obtainMessage(4, this);
            DisplayPowerController.this.mHandler.sendMessage(msg);
        }
    }

    private final class ScreenOnUnblocker
    implements WindowManagerPolicy.ScreenOnListener {
        private ScreenOnUnblocker() {
        }

        @Override
        public void onScreenOn() {
            Message msg = DisplayPowerController.this.mHandler.obtainMessage(3, this);
            DisplayPowerController.this.mHandler.sendMessage(msg);
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            DisplayPowerController.this.handleSettingsChange(false);
        }
    }

    private final class DisplayControllerHandler
    extends Handler {
        public DisplayControllerHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    DisplayPowerController.this.updatePowerState();
                    break;
                }
                case 2: {
                    DisplayPowerController.this.debounceProximitySensor();
                    break;
                }
                case 3: {
                    if (DisplayPowerController.this.mPendingScreenOnUnblocker != msg.obj) break;
                    DisplayPowerController.this.unblockScreenOn();
                    DisplayPowerController.this.updatePowerState();
                    break;
                }
                case 4: {
                    if (DisplayPowerController.this.mPendingScreenOffUnblocker != msg.obj) break;
                    DisplayPowerController.this.unblockScreenOff();
                    DisplayPowerController.this.updatePowerState();
                    break;
                }
                case 5: {
                    DisplayPowerController.this.mBrightnessConfiguration = (BrightnessConfiguration)msg.obj;
                    DisplayPowerController.this.updatePowerState();
                    break;
                }
                case 6: {
                    DisplayPowerController.this.mTemporaryScreenBrightness = msg.arg1;
                    DisplayPowerController.this.updatePowerState();
                    break;
                }
                case 7: {
                    DisplayPowerController.this.mTemporaryAutoBrightnessAdjustment = Float.intBitsToFloat(msg.arg1);
                    DisplayPowerController.this.updatePowerState();
                }
            }
        }
    }
}

