/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.IUidObserver;
import android.app.job.IJobScheduler;
import android.app.job.JobInfo;
import android.app.job.JobWorkItem;
import android.app.usage.UsageStatsManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ServiceInfo;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.BatteryStatsInternal;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManagerInternal;
import android.provider.Settings;
import android.util.KeyValueListParser;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.StatsLog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.server.AppStateTracker;
import com.android.server.DeviceIdleController;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.job.JobCompletedListener;
import com.android.server.job.JobPackageTracker;
import com.android.server.job.JobSchedulerInternal;
import com.android.server.job.JobSchedulerShellCommand;
import com.android.server.job.JobServiceContext;
import com.android.server.job.JobStore;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.BackgroundJobsController;
import com.android.server.job.controllers.BatteryController;
import com.android.server.job.controllers.ConnectivityController;
import com.android.server.job.controllers.ContentObserverController;
import com.android.server.job.controllers.DeviceIdleJobsController;
import com.android.server.job.controllers.IdleController;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import com.android.server.job.controllers.StorageController;
import com.android.server.job.controllers.TimeController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import libcore.util.EmptyArray;

public class JobSchedulerService
extends SystemService
implements StateChangedListener,
JobCompletedListener {
    public static final String TAG = "JobScheduler";
    public static final boolean DEBUG = Log.isLoggable("JobScheduler", 3);
    public static final boolean DEBUG_STANDBY = DEBUG;
    private static final int MAX_JOB_CONTEXTS_COUNT = 16;
    private static final boolean ENFORCE_MAX_JOBS = true;
    private static final int MAX_JOBS_PER_APP = 100;
    @VisibleForTesting
    public static Clock sSystemClock = Clock.systemUTC();
    @VisibleForTesting
    public static Clock sUptimeMillisClock = SystemClock.uptimeMillisClock();
    @VisibleForTesting
    public static Clock sElapsedRealtimeClock = SystemClock.elapsedRealtimeClock();
    final Object mLock = new Object();
    final JobStore mJobs;
    final StandbyTracker mStandbyTracker;
    final JobPackageTracker mJobPackageTracker = new JobPackageTracker();
    static final int MSG_JOB_EXPIRED = 0;
    static final int MSG_CHECK_JOB = 1;
    static final int MSG_STOP_JOB = 2;
    static final int MSG_CHECK_JOB_GREEDY = 3;
    static final int MSG_UID_STATE_CHANGED = 4;
    static final int MSG_UID_GONE = 5;
    static final int MSG_UID_ACTIVE = 6;
    static final int MSG_UID_IDLE = 7;
    final List<JobServiceContext> mActiveServices = new ArrayList<JobServiceContext>();
    private final List<StateController> mControllers;
    private final BatteryController mBatteryController;
    private final StorageController mStorageController;
    private final DeviceIdleJobsController mDeviceIdleJobsController;
    final ArrayList<JobStatus> mPendingJobs = new ArrayList();
    int[] mStartedUsers = EmptyArray.INT;
    final JobHandler mHandler;
    final JobSchedulerStub mJobSchedulerStub;
    PackageManagerInternal mLocalPM;
    ActivityManagerInternal mActivityManagerInternal;
    IBatteryStats mBatteryStats;
    DeviceIdleController.LocalService mLocalDeviceIdleController;
    AppStateTracker mAppStateTracker;
    final UsageStatsManagerInternal mUsageStats;
    boolean mReadyToRock;
    boolean mReportedActive;
    volatile boolean mInParole;
    int mMaxActiveJobs = 1;
    final SparseIntArray mUidPriorityOverride = new SparseIntArray();
    final SparseIntArray mBackingUpUids = new SparseIntArray();
    final long[] mNextBucketHeartbeat = new long[]{0L, 0L, 0L, 0L, Long.MAX_VALUE};
    long mHeartbeat = 0L;
    long mLastHeartbeatTime = sElapsedRealtimeClock.millis();
    static final int ACTIVE_INDEX = 0;
    static final int WORKING_INDEX = 1;
    static final int FREQUENT_INDEX = 2;
    static final int RARE_INDEX = 3;
    static final int NEVER_INDEX = 4;
    final SparseArray<HashMap<String, Long>> mLastJobHeartbeats = new SparseArray();
    static final String HEARTBEAT_TAG = "*job.heartbeat*";
    final HeartbeatAlarmListener mHeartbeatAlarm = new HeartbeatAlarmListener();
    JobStatus[] mTmpAssignContextIdToJobMap = new JobStatus[16];
    boolean[] mTmpAssignAct = new boolean[16];
    int[] mTmpAssignPreferredUidForContext = new int[16];
    final Constants mConstants;
    final ConstantsObserver mConstantsObserver;
    static final Comparator<JobStatus> mEnqueueTimeComparator = (o1, o2) -> {
        if (o1.enqueueTime < o2.enqueueTime) {
            return -1;
        }
        return o1.enqueueTime > o2.enqueueTime ? 1 : 0;
    };
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (DEBUG) {
                Slog.d(JobSchedulerService.TAG, "Receieved: " + action);
            }
            String pkgName = JobSchedulerService.this.getPackageName(intent);
            int pkgUid = intent.getIntExtra("android.intent.extra.UID", -1);
            if ("android.intent.action.PACKAGE_CHANGED".equals(action)) {
                if (pkgName != null && pkgUid != -1) {
                    String[] changedComponents = intent.getStringArrayExtra("android.intent.extra.changed_component_name_list");
                    if (changedComponents != null) {
                        for (String component : changedComponents) {
                            if (!component.equals(pkgName)) continue;
                            if (DEBUG) {
                                Slog.d(JobSchedulerService.TAG, "Package state change: " + pkgName);
                            }
                            try {
                                int userId = UserHandle.getUserId(pkgUid);
                                IPackageManager pm = AppGlobals.getPackageManager();
                                int state = pm.getApplicationEnabledSetting(pkgName, userId);
                                if (state == 2 || state == 3) {
                                    if (DEBUG) {
                                        Slog.d(JobSchedulerService.TAG, "Removing jobs for package " + pkgName + " in user " + userId);
                                    }
                                    JobSchedulerService.this.cancelJobsForPackageAndUid(pkgName, pkgUid, "app disabled");
                                }
                            }
                            catch (RemoteException | IllegalArgumentException exception) {}
                            break;
                        }
                    }
                } else {
                    Slog.w(JobSchedulerService.TAG, "PACKAGE_CHANGED for " + pkgName + " / uid " + pkgUid);
                }
            } else if ("android.intent.action.PACKAGE_REMOVED".equals(action)) {
                if (!intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                    int uidRemoved = intent.getIntExtra("android.intent.extra.UID", -1);
                    if (DEBUG) {
                        Slog.d(JobSchedulerService.TAG, "Removing jobs for uid: " + uidRemoved);
                    }
                    JobSchedulerService.this.cancelJobsForPackageAndUid(pkgName, uidRemoved, "app uninstalled");
                }
            } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", 0);
                if (DEBUG) {
                    Slog.d(JobSchedulerService.TAG, "Removing jobs for user: " + userId);
                }
                JobSchedulerService.this.cancelJobsForUser(userId);
            } else if ("android.intent.action.QUERY_PACKAGE_RESTART".equals(action)) {
                if (pkgUid != -1) {
                    List<JobStatus> jobsForUid;
                    Object object = JobSchedulerService.this.mLock;
                    synchronized (object) {
                        jobsForUid = JobSchedulerService.this.mJobs.getJobsByUid(pkgUid);
                    }
                    for (int i = jobsForUid.size() - 1; i >= 0; --i) {
                        if (!jobsForUid.get(i).getSourcePackageName().equals(pkgName)) continue;
                        if (DEBUG) {
                            Slog.d(JobSchedulerService.TAG, "Restart query: package " + pkgName + " at uid " + pkgUid + " has jobs");
                        }
                        this.setResultCode(-1);
                        break;
                    }
                }
            } else if ("android.intent.action.PACKAGE_RESTARTED".equals(action) && pkgUid != -1) {
                if (DEBUG) {
                    Slog.d(JobSchedulerService.TAG, "Removing jobs for pkg " + pkgName + " at uid " + pkgUid);
                }
                JobSchedulerService.this.cancelJobsForPackageAndUid(pkgName, pkgUid, "app force stopped");
            }
        }
    };
    private final IUidObserver mUidObserver = new IUidObserver.Stub(){

        @Override
        public void onUidStateChanged(int uid, int procState, long procStateSeq) {
            JobSchedulerService.this.mHandler.obtainMessage(4, uid, procState).sendToTarget();
        }

        @Override
        public void onUidGone(int uid, boolean disabled) {
            JobSchedulerService.this.mHandler.obtainMessage(5, uid, disabled ? 1 : 0).sendToTarget();
        }

        @Override
        public void onUidActive(int uid) throws RemoteException {
            JobSchedulerService.this.mHandler.obtainMessage(6, uid, 0).sendToTarget();
        }

        @Override
        public void onUidIdle(int uid, boolean disabled) {
            JobSchedulerService.this.mHandler.obtainMessage(7, uid, disabled ? 1 : 0).sendToTarget();
        }

        @Override
        public void onUidCachedChanged(int uid, boolean cached) {
        }
    };
    private final Predicate<Integer> mIsUidActivePredicate = this::isUidActive;
    private final BroadcastReceiver mTimeSetReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.TIME_SET".equals(intent.getAction()) && JobSchedulerService.this.mJobs.clockNowValidToInflate(sSystemClock.millis())) {
                Slog.i(JobSchedulerService.TAG, "RTC now valid; recalculating persisted job windows");
                context.unregisterReceiver(this);
                FgThread.getHandler().post(JobSchedulerService.this.mJobTimeUpdater);
            }
        }
    };
    private final Runnable mJobTimeUpdater = () -> {
        ArrayList<JobStatus> toRemove = new ArrayList<JobStatus>();
        ArrayList<JobStatus> toAdd = new ArrayList<JobStatus>();
        Object object = this.mLock;
        synchronized (object) {
            this.getJobStore().getRtcCorrectedJobsLocked(toAdd, toRemove);
            int N = toAdd.size();
            for (int i = 0; i < N; ++i) {
                JobStatus oldJob = toRemove.get(i);
                JobStatus newJob = toAdd.get(i);
                if (DEBUG) {
                    Slog.v(TAG, "  replacing " + oldJob + " with " + newJob);
                }
                this.cancelJobImplLocked(oldJob, newJob, "deferred rtc calculation");
            }
        }
    };
    private final ReadyJobQueueFunctor mReadyQueueFunctor = new ReadyJobQueueFunctor();
    private final MaybeReadyJobQueueFunctor mMaybeQueueFunctor = new MaybeReadyJobQueueFunctor();

    static <T> void addOrderedItem(ArrayList<T> array2, T newItem, Comparator<T> comparator) {
        int where = Collections.binarySearch(array2, newItem, comparator);
        if (where < 0) {
            where ^= 0xFFFFFFFF;
        }
        array2.add(where, newItem);
    }

    private String getPackageName(Intent intent) {
        Uri uri = intent.getData();
        String pkg = uri != null ? uri.getSchemeSpecificPart() : null;
        return pkg;
    }

    public Context getTestableContext() {
        return this.getContext();
    }

    public Object getLock() {
        return this.mLock;
    }

    public JobStore getJobStore() {
        return this.mJobs;
    }

    public Constants getConstants() {
        return this.mConstants;
    }

    @Override
    public void onStartUser(int userHandle) {
        this.mStartedUsers = ArrayUtils.appendInt(this.mStartedUsers, userHandle);
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    @Override
    public void onUnlockUser(int userHandle) {
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    @Override
    public void onStopUser(int userHandle) {
        this.mStartedUsers = ArrayUtils.removeInt(this.mStartedUsers, userHandle);
    }

    private boolean isUidActive(int uid) {
        return this.mAppStateTracker.isUidActiveSynced(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scheduleAsPackage(JobInfo job, JobWorkItem work, int uId, String packageName, int userId, String tag) {
        try {
            if (ActivityManager.getService().isAppStartModeDisabled(uId, job.getService().getPackageName())) {
                Slog.w(TAG, "Not scheduling job " + uId + ":" + job.toString() + " -- package not allowed to start");
                return 0;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Object object = this.mLock;
        synchronized (object) {
            JobStatus toCancel = this.mJobs.getJobByUidAndJobId(uId, job.getId());
            if (work != null && toCancel != null && toCancel.getJob().equals(job)) {
                toCancel.enqueueWorkLocked(ActivityManager.getService(), work);
                toCancel.maybeAddForegroundExemption(this.mIsUidActivePredicate);
                return 1;
            }
            JobStatus jobStatus = JobStatus.createFromJobInfo(job, uId, packageName, userId, tag);
            jobStatus.maybeAddForegroundExemption(this.mIsUidActivePredicate);
            if (DEBUG) {
                Slog.d(TAG, "SCHEDULE: " + jobStatus.toShortString());
            }
            if (packageName == null && this.mJobs.countJobsForUid(uId) > 100) {
                Slog.w(TAG, "Too many jobs for uid " + uId);
                throw new IllegalStateException("Apps may not schedule more than 100 distinct jobs");
            }
            jobStatus.prepareLocked(ActivityManager.getService());
            if (toCancel != null) {
                this.cancelJobImplLocked(toCancel, jobStatus, "job rescheduled by app");
            }
            if (work != null) {
                jobStatus.enqueueWorkLocked(ActivityManager.getService(), work);
            }
            this.startTrackingJobLocked(jobStatus, toCancel);
            StatsLog.write_non_chained(8, uId, null, jobStatus.getBatteryName(), 2, 0);
            if (this.isReadyToBeExecutedLocked(jobStatus)) {
                this.mJobPackageTracker.notePending(jobStatus);
                JobSchedulerService.addOrderedItem(this.mPendingJobs, jobStatus, mEnqueueTimeComparator);
                this.maybeRunPendingJobsLocked();
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobInfo> getPendingJobs(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            List<JobStatus> jobs = this.mJobs.getJobsByUid(uid);
            ArrayList<JobInfo> outList = new ArrayList<JobInfo>(jobs.size());
            for (int i = jobs.size() - 1; i >= 0; --i) {
                JobStatus job = jobs.get(i);
                outList.add(job.getJob());
            }
            return outList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo getPendingJob(int uid, int jobId) {
        Object object = this.mLock;
        synchronized (object) {
            List<JobStatus> jobs = this.mJobs.getJobsByUid(uid);
            for (int i = jobs.size() - 1; i >= 0; --i) {
                JobStatus job = jobs.get(i);
                if (job.getJobId() != jobId) continue;
                return job.getJob();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelJobsForUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            List<JobStatus> jobsForUser = this.mJobs.getJobsByUser(userHandle);
            for (int i = 0; i < jobsForUser.size(); ++i) {
                JobStatus toRemove = jobsForUser.get(i);
                this.cancelJobImplLocked(toRemove, null, "user removed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelJobsForNonExistentUsers() {
        UserManagerInternal umi = LocalServices.getService(UserManagerInternal.class);
        Object object = this.mLock;
        synchronized (object) {
            this.mJobs.removeJobsOfNonUsers(umi.getUserIds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelJobsForPackageAndUid(String pkgName, int uid, String reason) {
        if ("android".equals(pkgName)) {
            Slog.wtfStack(TAG, "Can't cancel all jobs for system package");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            List<JobStatus> jobsForUid = this.mJobs.getJobsByUid(uid);
            for (int i = jobsForUid.size() - 1; i >= 0; --i) {
                JobStatus job = jobsForUid.get(i);
                if (!job.getSourcePackageName().equals(pkgName)) continue;
                this.cancelJobImplLocked(job, null, reason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelJobsForUid(int uid, String reason) {
        if (uid == 1000) {
            Slog.wtfStack(TAG, "Can't cancel all jobs for system uid");
            return false;
        }
        boolean jobsCanceled = false;
        Object object = this.mLock;
        synchronized (object) {
            List<JobStatus> jobsForUid = this.mJobs.getJobsByUid(uid);
            for (int i = 0; i < jobsForUid.size(); ++i) {
                JobStatus toRemove = jobsForUid.get(i);
                this.cancelJobImplLocked(toRemove, null, reason);
                jobsCanceled = true;
            }
        }
        return jobsCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelJob(int uid, int jobId, int callingUid) {
        Object object = this.mLock;
        synchronized (object) {
            JobStatus toCancel = this.mJobs.getJobByUidAndJobId(uid, jobId);
            if (toCancel != null) {
                this.cancelJobImplLocked(toCancel, null, "cancel() called by app, callingUid=" + callingUid + " uid=" + uid + " jobId=" + jobId);
            }
            return toCancel != null;
        }
    }

    private void cancelJobImplLocked(JobStatus cancelled, JobStatus incomingJob, String reason) {
        if (DEBUG) {
            Slog.d(TAG, "CANCEL: " + cancelled.toShortString());
        }
        cancelled.unprepareLocked(ActivityManager.getService());
        this.stopTrackingJobLocked(cancelled, incomingJob, true);
        if (this.mPendingJobs.remove(cancelled)) {
            this.mJobPackageTracker.noteNonpending(cancelled);
        }
        this.stopJobOnServiceContextLocked(cancelled, 0, reason);
        this.reportActiveLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUidState(int uid, int procState) {
        Object object = this.mLock;
        synchronized (object) {
            if (procState == 2) {
                this.mUidPriorityOverride.put(uid, 40);
            } else if (procState <= 4) {
                this.mUidPriorityOverride.put(uid, 30);
            } else {
                this.mUidPriorityOverride.delete(uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeviceIdleStateChanged(boolean deviceIdle) {
        Object object = this.mLock;
        synchronized (object) {
            if (deviceIdle) {
                for (int i = 0; i < this.mActiveServices.size(); ++i) {
                    JobServiceContext jsc = this.mActiveServices.get(i);
                    JobStatus executing = jsc.getRunningJobLocked();
                    if (executing == null || (executing.getFlags() & 1) != 0) continue;
                    jsc.cancelExecutingJobLocked(4, "cancelled due to doze");
                }
            } else if (this.mReadyToRock) {
                if (this.mLocalDeviceIdleController != null && !this.mReportedActive) {
                    this.mReportedActive = true;
                    this.mLocalDeviceIdleController.setJobsActive(true);
                }
                this.mHandler.obtainMessage(1).sendToTarget();
            }
        }
    }

    void reportActiveLocked() {
        boolean active;
        boolean bl = active = this.mPendingJobs.size() > 0;
        if (this.mPendingJobs.size() <= 0) {
            for (int i = 0; i < this.mActiveServices.size(); ++i) {
                JobServiceContext jsc = this.mActiveServices.get(i);
                JobStatus job = jsc.getRunningJobLocked();
                if (job == null || (job.getJob().getFlags() & 1) != 0 || job.dozeWhitelisted || job.uidActive) continue;
                active = true;
                break;
            }
        }
        if (this.mReportedActive != active) {
            this.mReportedActive = active;
            if (this.mLocalDeviceIdleController != null) {
                this.mLocalDeviceIdleController.setJobsActive(active);
            }
        }
    }

    void reportAppUsage(String packageName, int userId) {
    }

    public JobSchedulerService(Context context) {
        super(context);
        this.mLocalPM = LocalServices.getService(PackageManagerInternal.class);
        this.mActivityManagerInternal = Preconditions.checkNotNull(LocalServices.getService(ActivityManagerInternal.class));
        this.mHandler = new JobHandler(context.getMainLooper());
        this.mConstants = new Constants();
        this.mConstantsObserver = new ConstantsObserver(this.mHandler);
        this.mJobSchedulerStub = new JobSchedulerStub();
        this.mStandbyTracker = new StandbyTracker();
        this.mUsageStats = LocalServices.getService(UsageStatsManagerInternal.class);
        this.mUsageStats.addAppIdleStateChangeListener(this.mStandbyTracker);
        this.publishLocalService(JobSchedulerInternal.class, new LocalService());
        this.mJobs = JobStore.initAndGet(this);
        this.mControllers = new ArrayList<StateController>();
        this.mControllers.add(new ConnectivityController(this));
        this.mControllers.add(new TimeController(this));
        this.mControllers.add(new IdleController(this));
        this.mBatteryController = new BatteryController(this);
        this.mControllers.add(this.mBatteryController);
        this.mStorageController = new StorageController(this);
        this.mControllers.add(this.mStorageController);
        this.mControllers.add(new BackgroundJobsController(this));
        this.mControllers.add(new ContentObserverController(this));
        this.mDeviceIdleJobsController = new DeviceIdleJobsController(this);
        this.mControllers.add(this.mDeviceIdleJobsController);
        if (!this.mJobs.jobTimesInflatedValid()) {
            Slog.w(TAG, "!!! RTC not yet good; tracking time updates for job scheduling");
            context.registerReceiver(this.mTimeSetReceiver, new IntentFilter("android.intent.action.TIME_SET"));
        }
    }

    @Override
    public void onStart() {
        this.publishBinderService("jobscheduler", this.mJobSchedulerStub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (500 == phase) {
            this.mConstantsObserver.start(this.getContext().getContentResolver());
            this.mAppStateTracker = Preconditions.checkNotNull(LocalServices.getService(AppStateTracker.class));
            this.setNextHeartbeatAlarm();
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.PACKAGE_REMOVED");
            filter.addAction("android.intent.action.PACKAGE_CHANGED");
            filter.addAction("android.intent.action.PACKAGE_RESTARTED");
            filter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
            filter.addDataScheme("package");
            this.getContext().registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, filter, null, null);
            IntentFilter userFilter = new IntentFilter("android.intent.action.USER_REMOVED");
            this.getContext().registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, userFilter, null, null);
            try {
                ActivityManager.getService().registerUidObserver(this.mUidObserver, 15, -1, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.cancelJobsForNonExistentUsers();
        } else if (phase == 600) {
            Object object = this.mLock;
            synchronized (object) {
                this.mReadyToRock = true;
                this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
                this.mLocalDeviceIdleController = LocalServices.getService(DeviceIdleController.LocalService.class);
                for (int i = 0; i < 16; ++i) {
                    this.mActiveServices.add(new JobServiceContext(this, this.mBatteryStats, this.mJobPackageTracker, this.getContext().getMainLooper()));
                }
                this.mJobs.forEachJob(job -> {
                    for (int controller = 0; controller < this.mControllers.size(); ++controller) {
                        StateController sc = this.mControllers.get(controller);
                        sc.maybeStartTrackingJobLocked((JobStatus)job, null);
                    }
                });
                this.mHandler.obtainMessage(1).sendToTarget();
            }
        }
    }

    private void startTrackingJobLocked(JobStatus jobStatus, JobStatus lastJob) {
        if (!jobStatus.isPreparedLocked()) {
            Slog.wtf(TAG, "Not yet prepared when started tracking: " + jobStatus);
        }
        jobStatus.enqueueTime = sElapsedRealtimeClock.millis();
        boolean update = this.mJobs.add(jobStatus);
        if (this.mReadyToRock) {
            for (int i = 0; i < this.mControllers.size(); ++i) {
                StateController controller = this.mControllers.get(i);
                if (update) {
                    controller.maybeStopTrackingJobLocked(jobStatus, null, true);
                }
                controller.maybeStartTrackingJobLocked(jobStatus, lastJob);
            }
        }
    }

    private boolean stopTrackingJobLocked(JobStatus jobStatus, JobStatus incomingJob, boolean writeBack) {
        jobStatus.stopTrackingJobLocked(ActivityManager.getService(), incomingJob);
        boolean removed = this.mJobs.remove(jobStatus, writeBack);
        if (removed && this.mReadyToRock) {
            for (int i = 0; i < this.mControllers.size(); ++i) {
                StateController controller = this.mControllers.get(i);
                controller.maybeStopTrackingJobLocked(jobStatus, incomingJob, false);
            }
        }
        return removed;
    }

    private boolean stopJobOnServiceContextLocked(JobStatus job, int reason, String debugReason) {
        for (int i = 0; i < this.mActiveServices.size(); ++i) {
            JobServiceContext jsc = this.mActiveServices.get(i);
            JobStatus executing = jsc.getRunningJobLocked();
            if (executing == null || !executing.matches(job.getUid(), job.getJobId())) continue;
            jsc.cancelExecutingJobLocked(reason, debugReason);
            return true;
        }
        return false;
    }

    private boolean isCurrentlyActiveLocked(JobStatus job) {
        for (int i = 0; i < this.mActiveServices.size(); ++i) {
            JobServiceContext serviceContext = this.mActiveServices.get(i);
            JobStatus running = serviceContext.getRunningJobLocked();
            if (running == null || !running.matches(job.getUid(), job.getJobId())) continue;
            return true;
        }
        return false;
    }

    void noteJobsPending(List<JobStatus> jobs) {
        for (int i = jobs.size() - 1; i >= 0; --i) {
            JobStatus job = jobs.get(i);
            this.mJobPackageTracker.notePending(job);
        }
    }

    void noteJobsNonpending(List<JobStatus> jobs) {
        for (int i = jobs.size() - 1; i >= 0; --i) {
            JobStatus job = jobs.get(i);
            this.mJobPackageTracker.noteNonpending(job);
        }
    }

    private JobStatus getRescheduleJobForFailureLocked(JobStatus failureToReschedule) {
        long delayMillis;
        long elapsedNowMillis = sElapsedRealtimeClock.millis();
        JobInfo job = failureToReschedule.getJob();
        long initialBackoffMillis = job.getInitialBackoffMillis();
        int backoffAttempts = failureToReschedule.getNumFailures() + 1;
        if (failureToReschedule.hasWorkLocked()) {
            if (backoffAttempts > this.mConstants.MAX_WORK_RESCHEDULE_COUNT) {
                Slog.w(TAG, "Not rescheduling " + failureToReschedule + ": attempt #" + backoffAttempts + " > work limit " + this.mConstants.MAX_STANDARD_RESCHEDULE_COUNT);
                return null;
            }
        } else if (backoffAttempts > this.mConstants.MAX_STANDARD_RESCHEDULE_COUNT) {
            Slog.w(TAG, "Not rescheduling " + failureToReschedule + ": attempt #" + backoffAttempts + " > std limit " + this.mConstants.MAX_STANDARD_RESCHEDULE_COUNT);
            return null;
        }
        switch (job.getBackoffPolicy()) {
            case 0: {
                long backoff = initialBackoffMillis;
                if (backoff < this.mConstants.MIN_LINEAR_BACKOFF_TIME) {
                    backoff = this.mConstants.MIN_LINEAR_BACKOFF_TIME;
                }
                delayMillis = backoff * (long)backoffAttempts;
                break;
            }
            default: {
                if (DEBUG) {
                    Slog.v(TAG, "Unrecognised back-off policy, defaulting to exponential.");
                }
            }
            case 1: {
                long backoff = initialBackoffMillis;
                if (backoff < this.mConstants.MIN_EXP_BACKOFF_TIME) {
                    backoff = this.mConstants.MIN_EXP_BACKOFF_TIME;
                }
                delayMillis = (long)Math.scalb(backoff, backoffAttempts - 1);
            }
        }
        delayMillis = Math.min(delayMillis, 18000000L);
        JobStatus newJob = new JobStatus(failureToReschedule, this.getCurrentHeartbeat(), elapsedNowMillis + delayMillis, Long.MAX_VALUE, backoffAttempts, failureToReschedule.getLastSuccessfulRunTime(), sSystemClock.millis());
        for (int ic = 0; ic < this.mControllers.size(); ++ic) {
            StateController controller = this.mControllers.get(ic);
            controller.rescheduleForFailureLocked(newJob, failureToReschedule);
        }
        return newJob;
    }

    private JobStatus getRescheduleJobForPeriodic(JobStatus periodicToReschedule) {
        long elapsedNow = sElapsedRealtimeClock.millis();
        long runEarly = 0L;
        if (periodicToReschedule.hasDeadlineConstraint()) {
            runEarly = Math.max(periodicToReschedule.getLatestRunTimeElapsed() - elapsedNow, 0L);
        }
        long flex = periodicToReschedule.getJob().getFlexMillis();
        long period = periodicToReschedule.getJob().getIntervalMillis();
        long newLatestRuntimeElapsed = elapsedNow + runEarly + period;
        long newEarliestRunTimeElapsed = newLatestRuntimeElapsed - flex;
        if (DEBUG) {
            Slog.v(TAG, "Rescheduling executed periodic. New execution window [" + newEarliestRunTimeElapsed / 1000L + ", " + newLatestRuntimeElapsed / 1000L + "]s");
        }
        return new JobStatus(periodicToReschedule, this.getCurrentHeartbeat(), newEarliestRunTimeElapsed, newLatestRuntimeElapsed, 0, sSystemClock.millis(), periodicToReschedule.getLastFailedRunTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long heartbeatWhenJobsLastRun(String packageName, int userId) {
        long heartbeat = -this.mConstants.STANDBY_BEATS[3];
        boolean cacheHit = false;
        Object object = this.mLock;
        synchronized (object) {
            long cachedValue;
            HashMap<String, Long> jobPackages = this.mLastJobHeartbeats.get(userId);
            if (jobPackages != null && (cachedValue = jobPackages.getOrDefault(packageName, Long.MAX_VALUE).longValue()) < Long.MAX_VALUE) {
                cacheHit = true;
                heartbeat = cachedValue;
            }
            if (!cacheHit) {
                long timeSinceJob = this.mUsageStats.getTimeSinceLastJobRun(packageName, userId);
                if (timeSinceJob < Long.MAX_VALUE) {
                    heartbeat = this.mHeartbeat - timeSinceJob / this.mConstants.STANDBY_HEARTBEAT_TIME;
                }
                this.setLastJobHeartbeatLocked(packageName, userId, heartbeat);
            }
        }
        if (DEBUG_STANDBY) {
            Slog.v(TAG, "Last job heartbeat " + heartbeat + " for " + packageName + "/" + userId);
        }
        return heartbeat;
    }

    long heartbeatWhenJobsLastRun(JobStatus job) {
        return this.heartbeatWhenJobsLastRun(job.getSourcePackageName(), job.getSourceUserId());
    }

    void setLastJobHeartbeatLocked(String packageName, int userId, long heartbeat) {
        HashMap<String, Long> jobPackages = this.mLastJobHeartbeats.get(userId);
        if (jobPackages == null) {
            jobPackages = new HashMap();
            this.mLastJobHeartbeats.put(userId, jobPackages);
        }
        jobPackages.put(packageName, heartbeat);
    }

    @Override
    public void onJobCompletedLocked(JobStatus jobStatus, boolean needsReschedule) {
        JobStatus rescheduledJob;
        if (DEBUG) {
            Slog.d(TAG, "Completed " + jobStatus + ", reschedule=" + needsReschedule);
        }
        if (!this.stopTrackingJobLocked(jobStatus, rescheduledJob = needsReschedule ? this.getRescheduleJobForFailureLocked(jobStatus) : null, !jobStatus.getJob().isPeriodic())) {
            if (DEBUG) {
                Slog.d(TAG, "Could not find job to remove. Was job removed while executing?");
            }
            this.mHandler.obtainMessage(3).sendToTarget();
            return;
        }
        if (rescheduledJob != null) {
            try {
                rescheduledJob.prepareLocked(ActivityManager.getService());
            }
            catch (SecurityException e) {
                Slog.w(TAG, "Unable to regrant job permissions for " + rescheduledJob);
            }
            this.startTrackingJobLocked(rescheduledJob, jobStatus);
        } else if (jobStatus.getJob().isPeriodic()) {
            JobStatus rescheduledPeriodic = this.getRescheduleJobForPeriodic(jobStatus);
            try {
                rescheduledPeriodic.prepareLocked(ActivityManager.getService());
            }
            catch (SecurityException e) {
                Slog.w(TAG, "Unable to regrant job permissions for " + rescheduledPeriodic);
            }
            this.startTrackingJobLocked(rescheduledPeriodic, jobStatus);
        }
        jobStatus.unprepareLocked(ActivityManager.getService());
        this.reportActiveLocked();
        this.mHandler.obtainMessage(3).sendToTarget();
    }

    @Override
    public void onControllerStateChanged() {
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    @Override
    public void onRunJobNow(JobStatus jobStatus) {
        this.mHandler.obtainMessage(0, jobStatus).sendToTarget();
    }

    private void stopNonReadyActiveJobsLocked() {
        for (int i = 0; i < this.mActiveServices.size(); ++i) {
            JobServiceContext serviceContext = this.mActiveServices.get(i);
            JobStatus running = serviceContext.getRunningJobLocked();
            if (running == null || running.isReady()) continue;
            serviceContext.cancelExecutingJobLocked(1, "cancelled due to unsatisfied constraints");
        }
    }

    private void queueReadyJobsForExecutionLocked() {
        if (DEBUG) {
            Slog.d(TAG, "queuing all ready jobs for execution:");
        }
        this.noteJobsNonpending(this.mPendingJobs);
        this.mPendingJobs.clear();
        this.stopNonReadyActiveJobsLocked();
        this.mJobs.forEachJob(this.mReadyQueueFunctor);
        this.mReadyQueueFunctor.postProcess();
        if (DEBUG) {
            int queuedJobs = this.mPendingJobs.size();
            if (queuedJobs == 0) {
                Slog.d(TAG, "No jobs pending.");
            } else {
                Slog.d(TAG, queuedJobs + " jobs queued.");
            }
        }
    }

    private void maybeQueueReadyJobsForExecutionLocked() {
        if (DEBUG) {
            Slog.d(TAG, "Maybe queuing ready jobs...");
        }
        this.noteJobsNonpending(this.mPendingJobs);
        this.mPendingJobs.clear();
        this.stopNonReadyActiveJobsLocked();
        this.mJobs.forEachJob(this.mMaybeQueueFunctor);
        this.mMaybeQueueFunctor.postProcess();
    }

    void advanceHeartbeatLocked(long beatsElapsed) {
        this.mHeartbeat += beatsElapsed;
        if (DEBUG_STANDBY) {
            Slog.v(TAG, "Advancing standby heartbeat by " + beatsElapsed + " to " + this.mHeartbeat);
        }
        boolean didAdvanceBucket = false;
        for (int i = 1; i < this.mNextBucketHeartbeat.length - 1; ++i) {
            if (this.mHeartbeat >= this.mNextBucketHeartbeat[i]) {
                didAdvanceBucket = true;
            }
            while (this.mHeartbeat > this.mNextBucketHeartbeat[i]) {
                int n = i;
                this.mNextBucketHeartbeat[n] = this.mNextBucketHeartbeat[n] + (long)this.mConstants.STANDBY_BEATS[i];
            }
            if (!DEBUG_STANDBY) continue;
            Slog.v(TAG, "   Bucket " + i + " next heartbeat " + this.mNextBucketHeartbeat[i]);
        }
        if (didAdvanceBucket) {
            if (DEBUG_STANDBY) {
                Slog.v(TAG, "Hit bucket boundary; reevaluating job runnability");
            }
            this.mHandler.obtainMessage(1).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNextHeartbeatAlarm() {
        long heartbeatLength;
        Object object = this.mLock;
        synchronized (object) {
            heartbeatLength = this.mConstants.STANDBY_HEARTBEAT_TIME;
        }
        long now = sElapsedRealtimeClock.millis();
        long nextBeatOrdinal = (now + heartbeatLength) / heartbeatLength;
        long nextHeartbeat = nextBeatOrdinal * heartbeatLength;
        if (DEBUG_STANDBY) {
            Slog.i(TAG, "Setting heartbeat alarm for " + nextHeartbeat + " = " + TimeUtils.formatDuration(nextHeartbeat - now));
        }
        AlarmManager am = (AlarmManager)this.getContext().getSystemService("alarm");
        am.setExact(3, nextHeartbeat, HEARTBEAT_TAG, this.mHeartbeatAlarm, this.mHandler);
    }

    private boolean isReadyToBeExecutedLocked(JobStatus job) {
        boolean componentPresent;
        boolean jobReady = job.isReady();
        if (DEBUG) {
            Slog.v(TAG, "isReadyToBeExecutedLocked: " + job.toShortString() + " ready=" + jobReady);
        }
        if (!jobReady) {
            if (job.getSourcePackageName().equals("android.jobscheduler.cts.jobtestapp")) {
                Slog.v(TAG, "    NOT READY: " + job);
            }
            return false;
        }
        boolean jobExists = this.mJobs.containsJob(job);
        int userId = job.getUserId();
        boolean userStarted = ArrayUtils.contains(this.mStartedUsers, userId);
        if (DEBUG) {
            Slog.v(TAG, "isReadyToBeExecutedLocked: " + job.toShortString() + " exists=" + jobExists + " userStarted=" + userStarted);
        }
        if (!jobExists || !userStarted) {
            return false;
        }
        boolean jobPending = this.mPendingJobs.contains(job);
        boolean jobActive = this.isCurrentlyActiveLocked(job);
        if (DEBUG) {
            Slog.v(TAG, "isReadyToBeExecutedLocked: " + job.toShortString() + " pending=" + jobPending + " active=" + jobActive);
        }
        if (jobPending || jobActive) {
            return false;
        }
        if (DEBUG_STANDBY) {
            Slog.v(TAG, "isReadyToBeExecutedLocked: " + job.toShortString() + " parole=" + this.mInParole + " active=" + job.uidActive + " exempt=" + job.getJob().isExemptedFromAppStandby());
        }
        if (!(this.mInParole || job.uidActive || job.getJob().isExemptedFromAppStandby())) {
            int bucket = job.getStandbyBucket();
            if (DEBUG_STANDBY) {
                Slog.v(TAG, "  bucket=" + bucket + " heartbeat=" + this.mHeartbeat + " next=" + this.mNextBucketHeartbeat[bucket]);
            }
            if (this.mHeartbeat < this.mNextBucketHeartbeat[bucket]) {
                long appLastRan = this.heartbeatWhenJobsLastRun(job);
                if (bucket >= this.mConstants.STANDBY_BEATS.length || this.mHeartbeat > appLastRan && this.mHeartbeat < appLastRan + (long)this.mConstants.STANDBY_BEATS[bucket]) {
                    if (job.getWhenStandbyDeferred() == 0L) {
                        if (DEBUG_STANDBY) {
                            Slog.v(TAG, "Bucket deferral: " + this.mHeartbeat + " < " + (appLastRan + (long)this.mConstants.STANDBY_BEATS[bucket]) + " for " + job);
                        }
                        job.setWhenStandbyDeferred(sElapsedRealtimeClock.millis());
                    }
                    return false;
                }
                if (DEBUG_STANDBY) {
                    Slog.v(TAG, "Bucket deferred job aged into runnability at " + this.mHeartbeat + " : " + job);
                }
            }
        }
        try {
            componentPresent = AppGlobals.getPackageManager().getServiceInfo(job.getServiceComponent(), 0x10000000, userId) != null;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        if (DEBUG) {
            Slog.v(TAG, "isReadyToBeExecutedLocked: " + job.toShortString() + " componentPresent=" + componentPresent);
        }
        return componentPresent;
    }

    private void maybeRunPendingJobsLocked() {
        if (DEBUG) {
            Slog.d(TAG, "pending queue: " + this.mPendingJobs.size() + " jobs.");
        }
        this.assignJobsToContextsLocked();
        this.reportActiveLocked();
    }

    private int adjustJobPriority(int curPriority, JobStatus job) {
        if (curPriority < 40) {
            float factor = this.mJobPackageTracker.getLoadFactor(job);
            if (factor >= this.mConstants.HEAVY_USE_FACTOR) {
                curPriority -= 80;
            } else if (factor >= this.mConstants.MODERATE_USE_FACTOR) {
                curPriority -= 40;
            }
        }
        return curPriority;
    }

    private int evaluateJobPriorityLocked(JobStatus job) {
        int priority = job.getPriority();
        if (priority >= 30) {
            return this.adjustJobPriority(priority, job);
        }
        int override = this.mUidPriorityOverride.get(job.getSourceUid(), 0);
        if (override != 0) {
            return this.adjustJobPriority(override, job);
        }
        return this.adjustJobPriority(priority, job);
    }

    private void assignJobsToContextsLocked() {
        int i;
        int memLevel;
        if (DEBUG) {
            Slog.d(TAG, this.printPendingQueue());
        }
        try {
            memLevel = ActivityManager.getService().getMemoryTrimLevel();
        }
        catch (RemoteException e) {
            memLevel = 0;
        }
        switch (memLevel) {
            case 1: {
                this.mMaxActiveJobs = this.mConstants.BG_MODERATE_JOB_COUNT;
                break;
            }
            case 2: {
                this.mMaxActiveJobs = this.mConstants.BG_LOW_JOB_COUNT;
                break;
            }
            case 3: {
                this.mMaxActiveJobs = this.mConstants.BG_CRITICAL_JOB_COUNT;
                break;
            }
            default: {
                this.mMaxActiveJobs = this.mConstants.BG_NORMAL_JOB_COUNT;
            }
        }
        JobStatus[] contextIdToJobMap = this.mTmpAssignContextIdToJobMap;
        boolean[] act = this.mTmpAssignAct;
        int[] preferredUidForContext = this.mTmpAssignPreferredUidForContext;
        int numActive = 0;
        int numForeground = 0;
        for (i = 0; i < 16; ++i) {
            JobServiceContext js = this.mActiveServices.get(i);
            JobStatus status = js.getRunningJobLocked();
            contextIdToJobMap[i] = status;
            if (contextIdToJobMap[i] != null) {
                ++numActive;
                if (status.lastEvaluatedPriority >= 40) {
                    ++numForeground;
                }
            }
            act[i] = false;
            preferredUidForContext[i] = js.getPreferredUid();
        }
        if (DEBUG) {
            Slog.d(TAG, this.printContextIdToJobMap(contextIdToJobMap, "running jobs initial"));
        }
        for (i = 0; i < this.mPendingJobs.size(); ++i) {
            int priority;
            JobStatus nextPending = this.mPendingJobs.get(i);
            int jobRunningContext = this.findJobContextIdFromMap(nextPending, contextIdToJobMap);
            if (jobRunningContext != -1) continue;
            nextPending.lastEvaluatedPriority = priority = this.evaluateJobPriorityLocked(nextPending);
            int minPriority = Integer.MAX_VALUE;
            int minPriorityContextId = -1;
            for (int j = 0; j < 16; ++j) {
                JobStatus job = contextIdToJobMap[j];
                int preferredUid = preferredUidForContext[j];
                if (job == null) {
                    if (numActive >= this.mMaxActiveJobs && (priority < 40 || numForeground >= this.mConstants.FG_JOB_COUNT) || preferredUid != nextPending.getUid() && preferredUid != -1) continue;
                    minPriorityContextId = j;
                    break;
                }
                if (job.getUid() != nextPending.getUid() || this.evaluateJobPriorityLocked(job) >= nextPending.lastEvaluatedPriority || minPriority <= nextPending.lastEvaluatedPriority) continue;
                minPriority = nextPending.lastEvaluatedPriority;
                minPriorityContextId = j;
            }
            if (minPriorityContextId == -1) continue;
            contextIdToJobMap[minPriorityContextId] = nextPending;
            act[minPriorityContextId] = true;
            ++numActive;
            if (priority < 40) continue;
            ++numForeground;
        }
        if (DEBUG) {
            Slog.d(TAG, this.printContextIdToJobMap(contextIdToJobMap, "running jobs final"));
        }
        this.mJobPackageTracker.noteConcurrency(numActive, numForeground);
        for (i = 0; i < 16; ++i) {
            boolean preservePreferredUid = false;
            if (act[i]) {
                JobStatus js = this.mActiveServices.get(i).getRunningJobLocked();
                if (js != null) {
                    if (DEBUG) {
                        Slog.d(TAG, "preempting job: " + this.mActiveServices.get(i).getRunningJobLocked());
                    }
                    this.mActiveServices.get(i).preemptExecutingJobLocked();
                    preservePreferredUid = true;
                } else {
                    JobStatus pendingJob = contextIdToJobMap[i];
                    if (DEBUG) {
                        Slog.d(TAG, "About to run job on context " + String.valueOf(i) + ", job: " + pendingJob);
                    }
                    for (int ic = 0; ic < this.mControllers.size(); ++ic) {
                        this.mControllers.get(ic).prepareForExecutionLocked(pendingJob);
                    }
                    if (!this.mActiveServices.get(i).executeRunnableJob(pendingJob)) {
                        Slog.d(TAG, "Error executing " + pendingJob);
                    }
                    if (this.mPendingJobs.remove(pendingJob)) {
                        this.mJobPackageTracker.noteNonpending(pendingJob);
                    }
                }
            }
            if (preservePreferredUid) continue;
            this.mActiveServices.get(i).clearPreferredUid();
        }
    }

    int findJobContextIdFromMap(JobStatus jobStatus, JobStatus[] map) {
        for (int i = 0; i < map.length; ++i) {
            if (map[i] == null || !map[i].matches(jobStatus.getUid(), jobStatus.getJobId())) continue;
            return i;
        }
        return -1;
    }

    public static int standbyBucketToBucketIndex(int bucket) {
        if (bucket == 50) {
            return 4;
        }
        if (bucket > 30) {
            return 3;
        }
        if (bucket > 20) {
            return 2;
        }
        if (bucket > 10) {
            return 1;
        }
        return 0;
    }

    public static int standbyBucketForPackage(String packageName, int userId, long elapsedNow) {
        UsageStatsManagerInternal usageStats = LocalServices.getService(UsageStatsManagerInternal.class);
        int bucket = usageStats != null ? usageStats.getAppStandbyBucket(packageName, userId, elapsedNow) : 0;
        bucket = JobSchedulerService.standbyBucketToBucketIndex(bucket);
        if (DEBUG_STANDBY) {
            Slog.v(TAG, packageName + "/" + userId + " standby bucket index: " + bucket);
        }
        return bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeRunCommand(String pkgName, int userId, int jobId, boolean force) {
        if (DEBUG) {
            Slog.v(TAG, "executeRunCommand(): " + pkgName + "/" + userId + " " + jobId + " f=" + force);
        }
        try {
            int uid = AppGlobals.getPackageManager().getPackageUid(pkgName, 0, userId != -1 ? userId : 0);
            if (uid < 0) {
                return -1000;
            }
            Object object = this.mLock;
            synchronized (object) {
                JobStatus js = this.mJobs.getJobByUidAndJobId(uid, jobId);
                if (js == null) {
                    return -1001;
                }
                int n = js.overrideState = force ? 2 : 1;
                if (!js.isConstraintsSatisfied()) {
                    js.overrideState = 0;
                    return -1002;
                }
                this.queueReadyJobsForExecutionLocked();
                this.maybeRunPendingJobsLocked();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeTimeoutCommand(PrintWriter pw, String pkgName, int userId, boolean hasJobId, int jobId) {
        if (DEBUG) {
            Slog.v(TAG, "executeTimeoutCommand(): " + pkgName + "/" + userId + " " + jobId);
        }
        Object object = this.mLock;
        synchronized (object) {
            boolean foundSome = false;
            for (int i = 0; i < this.mActiveServices.size(); ++i) {
                JobServiceContext jc = this.mActiveServices.get(i);
                JobStatus js = jc.getRunningJobLocked();
                if (!jc.timeoutIfExecutingLocked(pkgName, userId, hasJobId, jobId, "shell")) continue;
                foundSome = true;
                pw.print("Timing out: ");
                js.printUniqueId(pw);
                pw.print(" ");
                pw.println(js.getServiceComponent().flattenToShortString());
            }
            if (!foundSome) {
                pw.println("No matching executing jobs found.");
            }
        }
        return 0;
    }

    int executeCancelCommand(PrintWriter pw, String pkgName, int userId, boolean hasJobId, int jobId) {
        if (DEBUG) {
            Slog.v(TAG, "executeCancelCommand(): " + pkgName + "/" + userId + " " + jobId);
        }
        int pkgUid = -1;
        try {
            IPackageManager pm = AppGlobals.getPackageManager();
            pkgUid = pm.getPackageUid(pkgName, 0, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (pkgUid < 0) {
            pw.println("Package " + pkgName + " not found.");
            return -1000;
        }
        if (!hasJobId) {
            pw.println("Canceling all jobs for " + pkgName + " in user " + userId);
            if (!this.cancelJobsForUid(pkgUid, "cancel shell command for package")) {
                pw.println("No matching jobs found.");
            }
        } else {
            pw.println("Canceling job " + pkgName + "/#" + jobId + " in user " + userId);
            if (!this.cancelJob(pkgUid, jobId, 2000)) {
                pw.println("No matching job found.");
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMonitorBattery(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBatteryController != null) {
                this.mBatteryController.getTracker().setMonitorBatteryLocked(enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getBatterySeq() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBatteryController != null ? this.mBatteryController.getTracker().getSeq() : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getBatteryCharging() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBatteryController != null ? this.mBatteryController.getTracker().isOnStablePower() : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getBatteryNotLow() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBatteryController != null ? this.mBatteryController.getTracker().isBatteryNotLow() : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getStorageSeq() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mStorageController != null ? this.mStorageController.getTracker().getSeq() : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getStorageNotLow() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mStorageController != null ? this.mStorageController.getTracker().isStorageNotLow() : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCurrentHeartbeat() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mHeartbeat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getJobState(PrintWriter pw, String pkgName, int userId, int jobId) {
        try {
            int uid = AppGlobals.getPackageManager().getPackageUid(pkgName, 0, userId != -1 ? userId : 0);
            if (uid < 0) {
                pw.print("unknown(");
                pw.print(pkgName);
                pw.println(")");
                return -1000;
            }
            Object object = this.mLock;
            synchronized (object) {
                JobStatus js = this.mJobs.getJobByUidAndJobId(uid, jobId);
                if (DEBUG) {
                    Slog.d(TAG, "get-job-state " + uid + "/" + jobId + ": " + js);
                }
                if (js == null) {
                    pw.print("unknown(");
                    UserHandle.formatUid(pw, uid);
                    pw.print("/jid");
                    pw.print(jobId);
                    pw.println(")");
                    return -1001;
                }
                boolean printed = false;
                if (this.mPendingJobs.contains(js)) {
                    pw.print("pending");
                    printed = true;
                }
                if (this.isCurrentlyActiveLocked(js)) {
                    if (printed) {
                        pw.print(" ");
                    }
                    printed = true;
                    pw.println("active");
                }
                if (!ArrayUtils.contains(this.mStartedUsers, js.getUserId())) {
                    if (printed) {
                        pw.print(" ");
                    }
                    printed = true;
                    pw.println("user-stopped");
                }
                if (this.mBackingUpUids.indexOfKey(js.getSourceUid()) >= 0) {
                    if (printed) {
                        pw.print(" ");
                    }
                    printed = true;
                    pw.println("backing-up");
                }
                boolean componentPresent = false;
                try {
                    componentPresent = AppGlobals.getPackageManager().getServiceInfo(js.getServiceComponent(), 0x10000000, js.getUserId()) != null;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                if (!componentPresent) {
                    if (printed) {
                        pw.print(" ");
                    }
                    printed = true;
                    pw.println("no-component");
                }
                if (js.isReady()) {
                    if (printed) {
                        pw.print(" ");
                    }
                    printed = true;
                    pw.println("ready");
                }
                if (!printed) {
                    pw.print("waiting");
                }
                pw.println();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeHeartbeatCommand(PrintWriter pw, int numBeats) {
        if (numBeats < 1) {
            pw.println(this.getCurrentHeartbeat());
            return 0;
        }
        pw.print("Advancing standby heartbeat by ");
        pw.println(numBeats);
        Object object = this.mLock;
        synchronized (object) {
            this.advanceHeartbeatLocked(numBeats);
        }
        return 0;
    }

    void triggerDockState(boolean idleState) {
        Intent dockIntent = idleState ? new Intent("android.intent.action.DOCK_IDLE") : new Intent("android.intent.action.DOCK_ACTIVE");
        dockIntent.setPackage("android");
        dockIntent.addFlags(0x50000000);
        this.getContext().sendBroadcastAsUser(dockIntent, UserHandle.ALL);
    }

    private String printContextIdToJobMap(JobStatus[] map, String initial) {
        StringBuilder s = new StringBuilder(initial + ": ");
        for (int i = 0; i < map.length; ++i) {
            s.append("(").append(map[i] == null ? -1 : map[i].getJobId()).append(map[i] == null ? -1 : map[i].getUid()).append(")");
        }
        return s.toString();
    }

    private String printPendingQueue() {
        StringBuilder s = new StringBuilder("Pending queue: ");
        for (JobStatus js : this.mPendingJobs) {
            s.append("(").append(js.getJob().getId()).append(", ").append(js.getUid()).append(") ");
        }
        return s.toString();
    }

    static void dumpHelp(PrintWriter pw) {
        pw.println("Job Scheduler (jobscheduler) dump options:");
        pw.println("  [-h] [package] ...");
        pw.println("    -h: print this help");
        pw.println("  [package] is an optional package name to limit the output to.");
    }

    private static void sortJobs(List<JobStatus> jobs) {
        Collections.sort(jobs, new Comparator<JobStatus>(){

            @Override
            public int compare(JobStatus o1, JobStatus o2) {
                int uid1 = o1.getUid();
                int uid2 = o2.getUid();
                int id1 = o1.getJobId();
                int id2 = o2.getJobId();
                if (uid1 != uid2) {
                    return uid1 < uid2 ? -1 : 1;
                }
                return id1 < id2 ? -1 : (id1 > id2 ? 1 : 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpInternal(IndentingPrintWriter pw, int filterUid) {
        int filterUidFinal = UserHandle.getAppId(filterUid);
        long nowElapsed = sElapsedRealtimeClock.millis();
        long nowUptime = sUptimeMillisClock.millis();
        Predicate<JobStatus> predicate = js -> filterUidFinal == -1 || UserHandle.getAppId(js.getUid()) == filterUidFinal || UserHandle.getAppId(js.getSourceUid()) == filterUidFinal;
        Object object = this.mLock;
        synchronized (object) {
            int i;
            this.mConstants.dump(pw);
            pw.println();
            pw.println("  Heartbeat:");
            pw.print("    Current:    ");
            pw.println(this.mHeartbeat);
            pw.println("    Next");
            pw.print("      ACTIVE:   ");
            pw.println(this.mNextBucketHeartbeat[0]);
            pw.print("      WORKING:  ");
            pw.println(this.mNextBucketHeartbeat[1]);
            pw.print("      FREQUENT: ");
            pw.println(this.mNextBucketHeartbeat[2]);
            pw.print("      RARE:     ");
            pw.println(this.mNextBucketHeartbeat[3]);
            pw.print("    Last heartbeat: ");
            TimeUtils.formatDuration(this.mLastHeartbeatTime, nowElapsed, pw);
            pw.println();
            pw.print("    Next heartbeat: ");
            TimeUtils.formatDuration(this.mLastHeartbeatTime + this.mConstants.STANDBY_HEARTBEAT_TIME, nowElapsed, pw);
            pw.println();
            pw.print("    In parole?: ");
            pw.print(this.mInParole);
            pw.println();
            pw.println();
            pw.println("Started users: " + Arrays.toString(this.mStartedUsers));
            pw.print("Registered ");
            pw.print(this.mJobs.size());
            pw.println(" jobs:");
            if (this.mJobs.size() > 0) {
                List<JobStatus> jobs = this.mJobs.mJobSet.getAllJobs();
                JobSchedulerService.sortJobs(jobs);
                for (JobStatus job : jobs) {
                    pw.print("  JOB #");
                    job.printUniqueId(pw);
                    pw.print(": ");
                    pw.println(job.toShortStringExceptUniqueId());
                    if (!predicate.test(job)) continue;
                    job.dump(pw, "    ", true, nowElapsed);
                    pw.print("    Last run heartbeat: ");
                    pw.print(this.heartbeatWhenJobsLastRun(job));
                    pw.println();
                    pw.print("    Ready: ");
                    pw.print(this.isReadyToBeExecutedLocked(job));
                    pw.print(" (job=");
                    pw.print(job.isReady());
                    pw.print(" user=");
                    pw.print(ArrayUtils.contains(this.mStartedUsers, job.getUserId()));
                    pw.print(" !pending=");
                    pw.print(!this.mPendingJobs.contains(job));
                    pw.print(" !active=");
                    pw.print(!this.isCurrentlyActiveLocked(job));
                    pw.print(" !backingup=");
                    pw.print(this.mBackingUpUids.indexOfKey(job.getSourceUid()) < 0);
                    pw.print(" comp=");
                    boolean componentPresent = false;
                    try {
                        componentPresent = AppGlobals.getPackageManager().getServiceInfo(job.getServiceComponent(), 0x10000000, job.getUserId()) != null;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    pw.print(componentPresent);
                    pw.println(")");
                }
            } else {
                pw.println("  None.");
            }
            for (i = 0; i < this.mControllers.size(); ++i) {
                pw.println();
                pw.println(this.mControllers.get(i).getClass().getSimpleName() + ":");
                pw.increaseIndent();
                this.mControllers.get(i).dumpControllerStateLocked(pw, predicate);
                pw.decreaseIndent();
            }
            pw.println();
            pw.println("Uid priority overrides:");
            for (i = 0; i < this.mUidPriorityOverride.size(); ++i) {
                int uid = this.mUidPriorityOverride.keyAt(i);
                if (filterUidFinal != -1 && filterUidFinal != UserHandle.getAppId(uid)) continue;
                pw.print("  ");
                pw.print(UserHandle.formatUid(uid));
                pw.print(": ");
                pw.println(this.mUidPriorityOverride.valueAt(i));
            }
            if (this.mBackingUpUids.size() > 0) {
                pw.println();
                pw.println("Backing up uids:");
                boolean first = true;
                for (int i2 = 0; i2 < this.mBackingUpUids.size(); ++i2) {
                    int uid = this.mBackingUpUids.keyAt(i2);
                    if (filterUidFinal != -1 && filterUidFinal != UserHandle.getAppId(uid)) continue;
                    if (first) {
                        pw.print("  ");
                        first = false;
                    } else {
                        pw.print(", ");
                    }
                    pw.print(UserHandle.formatUid(uid));
                }
                pw.println();
            }
            pw.println();
            this.mJobPackageTracker.dump(pw, "", filterUidFinal);
            pw.println();
            if (this.mJobPackageTracker.dumpHistory(pw, "", filterUidFinal)) {
                pw.println();
            }
            pw.println("Pending queue:");
            for (i = 0; i < this.mPendingJobs.size(); ++i) {
                JobStatus job = this.mPendingJobs.get(i);
                pw.print("  Pending #");
                pw.print(i);
                pw.print(": ");
                pw.println(job.toShortString());
                job.dump(pw, "    ", false, nowElapsed);
                int priority = this.evaluateJobPriorityLocked(job);
                if (priority != 0) {
                    pw.print("    Evaluated priority: ");
                    pw.println(priority);
                }
                pw.print("    Tag: ");
                pw.println(job.getTag());
                pw.print("    Enq: ");
                TimeUtils.formatDuration(job.madePending - nowUptime, pw);
                pw.println();
            }
            pw.println();
            pw.println("Active jobs:");
            for (i = 0; i < this.mActiveServices.size(); ++i) {
                JobServiceContext jsc = this.mActiveServices.get(i);
                pw.print("  Slot #");
                pw.print(i);
                pw.print(": ");
                JobStatus job = jsc.getRunningJobLocked();
                if (job == null) {
                    if (jsc.mStoppedReason != null) {
                        pw.print("inactive since ");
                        TimeUtils.formatDuration(jsc.mStoppedTime, nowElapsed, pw);
                        pw.print(", stopped because: ");
                        pw.println(jsc.mStoppedReason);
                        continue;
                    }
                    pw.println("inactive");
                    continue;
                }
                pw.println(job.toShortString());
                pw.print("    Running for: ");
                TimeUtils.formatDuration(nowElapsed - jsc.getExecutionStartTimeElapsed(), pw);
                pw.print(", timeout at: ");
                TimeUtils.formatDuration(jsc.getTimeoutElapsed() - nowElapsed, pw);
                pw.println();
                job.dump(pw, "    ", false, nowElapsed);
                int priority = this.evaluateJobPriorityLocked(jsc.getRunningJobLocked());
                if (priority != 0) {
                    pw.print("    Evaluated priority: ");
                    pw.println(priority);
                }
                pw.print("    Active at ");
                TimeUtils.formatDuration(job.madeActive - nowUptime, pw);
                pw.print(", pending for ");
                TimeUtils.formatDuration(job.madeActive - job.madePending, pw);
                pw.println();
            }
            if (filterUid == -1) {
                pw.println();
                pw.print("mReadyToRock=");
                pw.println(this.mReadyToRock);
                pw.print("mReportedActive=");
                pw.println(this.mReportedActive);
                pw.print("mMaxActiveJobs=");
                pw.println(this.mMaxActiveJobs);
            }
            pw.println();
            pw.print("PersistStats: ");
            pw.println(this.mJobs.getPersistStats());
        }
        pw.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpInternalProto(FileDescriptor fd, int filterUid) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        int filterUidFinal = UserHandle.getAppId(filterUid);
        long nowElapsed = sElapsedRealtimeClock.millis();
        long nowUptime = sUptimeMillisClock.millis();
        Predicate<JobStatus> predicate = js -> filterUidFinal == -1 || UserHandle.getAppId(js.getUid()) == filterUidFinal || UserHandle.getAppId(js.getSourceUid()) == filterUidFinal;
        Object object = this.mLock;
        synchronized (object) {
            int uid;
            int i;
            this.mConstants.dump(proto, 0x10B00000001L);
            proto.write(1120986464270L, this.mHeartbeat);
            proto.write(2220498092047L, this.mNextBucketHeartbeat[0]);
            proto.write(2220498092047L, this.mNextBucketHeartbeat[1]);
            proto.write(2220498092047L, this.mNextBucketHeartbeat[2]);
            proto.write(2220498092047L, this.mNextBucketHeartbeat[3]);
            proto.write(0x10300000010L, this.mLastHeartbeatTime - nowUptime);
            proto.write(0x10300000011L, this.mLastHeartbeatTime + this.mConstants.STANDBY_HEARTBEAT_TIME - nowUptime);
            proto.write(1133871366162L, this.mInParole);
            for (int u : this.mStartedUsers) {
                proto.write(0x20500000002L, u);
            }
            if (this.mJobs.size() > 0) {
                List<JobStatus> jobs = this.mJobs.mJobSet.getAllJobs();
                JobSchedulerService.sortJobs(jobs);
                Iterator iterator = jobs.iterator();
                while (iterator.hasNext()) {
                    JobStatus job = (JobStatus)iterator.next();
                    long rjToken = proto.start(2246267895811L);
                    job.writeToShortProto(proto, 0x10B00000001L);
                    if (!predicate.test(job)) continue;
                    job.dump(proto, 1146756268034L, true, nowElapsed);
                    proto.write(1133871366147L, job.isReady());
                    proto.write(1133871366148L, ArrayUtils.contains(this.mStartedUsers, job.getUserId()));
                    proto.write(1133871366149L, this.mPendingJobs.contains(job));
                    proto.write(1133871366150L, this.isCurrentlyActiveLocked(job));
                    proto.write(1133871366151L, this.mBackingUpUids.indexOfKey(job.getSourceUid()) >= 0);
                    boolean componentPresent = false;
                    try {
                        componentPresent = AppGlobals.getPackageManager().getServiceInfo(job.getServiceComponent(), 0x10000000, job.getUserId()) != null;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    proto.write(0x10800000008L, componentPresent);
                    proto.write(1112396529673L, this.heartbeatWhenJobsLastRun(job));
                    proto.end(rjToken);
                }
            }
            for (StateController controller : this.mControllers) {
                controller.dumpControllerStateLocked(proto, 2246267895812L, predicate);
            }
            for (i = 0; i < this.mUidPriorityOverride.size(); ++i) {
                uid = this.mUidPriorityOverride.keyAt(i);
                if (filterUidFinal != -1 && filterUidFinal != UserHandle.getAppId(uid)) continue;
                long pToken = proto.start(2246267895813L);
                proto.write(0x10500000001L, uid);
                proto.write(0x11100000002L, this.mUidPriorityOverride.valueAt(i));
                proto.end(pToken);
            }
            for (i = 0; i < this.mBackingUpUids.size(); ++i) {
                uid = this.mBackingUpUids.keyAt(i);
                if (filterUidFinal != -1 && filterUidFinal != UserHandle.getAppId(uid)) continue;
                proto.write(2220498092038L, uid);
            }
            this.mJobPackageTracker.dump(proto, 1146756268040L, filterUidFinal);
            this.mJobPackageTracker.dumpHistory(proto, 1146756268039L, filterUidFinal);
            for (JobStatus job : this.mPendingJobs) {
                long pjToken = proto.start(2246267895817L);
                job.writeToShortProto(proto, 0x10B00000001L);
                job.dump(proto, 1146756268034L, false, nowElapsed);
                int priority = this.evaluateJobPriorityLocked(job);
                if (priority != 0) {
                    proto.write(0x11100000003L, priority);
                }
                proto.write(1112396529668L, nowUptime - job.madePending);
                proto.end(pjToken);
            }
            for (JobServiceContext jsc : this.mActiveServices) {
                long ajToken = proto.start(2246267895818L);
                JobStatus job = jsc.getRunningJobLocked();
                if (job == null) {
                    long ijToken = proto.start(0x10B00000001L);
                    proto.write(0x10300000001L, nowElapsed - jsc.mStoppedTime);
                    if (jsc.mStoppedReason != null) {
                        proto.write(1138166333442L, jsc.mStoppedReason);
                    }
                    proto.end(ijToken);
                } else {
                    long rjToken = proto.start(1146756268034L);
                    job.writeToShortProto(proto, 0x10B00000001L);
                    proto.write(1112396529666L, nowElapsed - jsc.getExecutionStartTimeElapsed());
                    proto.write(0x10300000003L, jsc.getTimeoutElapsed() - nowElapsed);
                    job.dump(proto, 1146756268036L, false, nowElapsed);
                    int priority = this.evaluateJobPriorityLocked(jsc.getRunningJobLocked());
                    if (priority != 0) {
                        proto.write(0x11100000005L, priority);
                    }
                    proto.write(1112396529670L, nowUptime - job.madeActive);
                    proto.write(1112396529671L, job.madeActive - job.madePending);
                    proto.end(rjToken);
                }
                proto.end(ajToken);
            }
            if (filterUid == -1) {
                proto.write(1133871366155L, this.mReadyToRock);
                proto.write(1133871366156L, this.mReportedActive);
                proto.write(1120986464269L, this.mMaxActiveJobs);
            }
        }
        proto.flush();
    }

    final class JobSchedulerStub
    extends IJobScheduler.Stub {
        private final SparseArray<Boolean> mPersistCache = new SparseArray();

        JobSchedulerStub() {
        }

        private void enforceValidJobRequest(int uid, JobInfo job) {
            IPackageManager pm = AppGlobals.getPackageManager();
            ComponentName service = job.getService();
            try {
                ServiceInfo si = pm.getServiceInfo(service, 786432, UserHandle.getUserId(uid));
                if (si == null) {
                    throw new IllegalArgumentException("No such service " + service);
                }
                if (si.applicationInfo.uid != uid) {
                    throw new IllegalArgumentException("uid " + uid + " cannot schedule job in " + service.getPackageName());
                }
                if (!"android.permission.BIND_JOB_SERVICE".equals(si.permission)) {
                    throw new IllegalArgumentException("Scheduled service " + service + " does not require android.permission.BIND_JOB_SERVICE permission");
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean canPersistJobs(int pid, int uid) {
            boolean canPersist;
            SparseArray<Boolean> sparseArray = this.mPersistCache;
            synchronized (sparseArray) {
                Boolean cached = this.mPersistCache.get(uid);
                if (cached != null) {
                    canPersist = cached;
                } else {
                    int result = JobSchedulerService.this.getContext().checkPermission("android.permission.RECEIVE_BOOT_COMPLETED", pid, uid);
                    canPersist = result == 0;
                    this.mPersistCache.put(uid, canPersist);
                }
            }
            return canPersist;
        }

        private void validateJobFlags(JobInfo job, int callingUid) {
            if ((job.getFlags() & 1) != 0) {
                JobSchedulerService.this.getContext().enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", JobSchedulerService.TAG);
            }
            if ((job.getFlags() & 8) != 0) {
                if (callingUid != 1000) {
                    throw new SecurityException("Job has invalid flags");
                }
                if (job.isPeriodic()) {
                    Slog.wtf(JobSchedulerService.TAG, "Periodic jobs mustn't have FLAG_EXEMPT_FROM_APP_STANDBY. Job=" + job);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int schedule(JobInfo job) throws RemoteException {
            if (DEBUG) {
                Slog.d(JobSchedulerService.TAG, "Scheduling job: " + job.toString());
            }
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            int userId = UserHandle.getUserId(uid);
            this.enforceValidJobRequest(uid, job);
            if (job.isPersisted() && !this.canPersistJobs(pid, uid)) {
                throw new IllegalArgumentException("Error: requested job be persisted without holding RECEIVE_BOOT_COMPLETED permission.");
            }
            this.validateJobFlags(job, uid);
            long ident = Binder.clearCallingIdentity();
            try {
                int n = JobSchedulerService.this.scheduleAsPackage(job, null, uid, null, userId, null);
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int enqueue(JobInfo job, JobWorkItem work) throws RemoteException {
            if (DEBUG) {
                Slog.d(JobSchedulerService.TAG, "Enqueueing job: " + job.toString() + " work: " + work);
            }
            int uid = Binder.getCallingUid();
            int userId = UserHandle.getUserId(uid);
            this.enforceValidJobRequest(uid, job);
            if (job.isPersisted()) {
                throw new IllegalArgumentException("Can't enqueue work for persisted jobs");
            }
            if (work == null) {
                throw new NullPointerException("work is null");
            }
            this.validateJobFlags(job, uid);
            long ident = Binder.clearCallingIdentity();
            try {
                int n = JobSchedulerService.this.scheduleAsPackage(job, work, uid, null, userId, null);
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int scheduleAsPackage(JobInfo job, String packageName, int userId, String tag) throws RemoteException {
            int callerUid = Binder.getCallingUid();
            if (DEBUG) {
                Slog.d(JobSchedulerService.TAG, "Caller uid " + callerUid + " scheduling job: " + job.toString() + " on behalf of " + packageName + "/");
            }
            if (packageName == null) {
                throw new NullPointerException("Must specify a package for scheduleAsPackage()");
            }
            int mayScheduleForOthers = JobSchedulerService.this.getContext().checkCallingOrSelfPermission("android.permission.UPDATE_DEVICE_STATS");
            if (mayScheduleForOthers != 0) {
                throw new SecurityException("Caller uid " + callerUid + " not permitted to schedule jobs for other apps");
            }
            this.validateJobFlags(job, callerUid);
            long ident = Binder.clearCallingIdentity();
            try {
                int n = JobSchedulerService.this.scheduleAsPackage(job, null, callerUid, packageName, userId, tag);
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<JobInfo> getAllPendingJobs() throws RemoteException {
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                List<JobInfo> list = JobSchedulerService.this.getPendingJobs(uid);
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JobInfo getPendingJob(int jobId) throws RemoteException {
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                JobInfo jobInfo = JobSchedulerService.this.getPendingJob(uid, jobId);
                return jobInfo;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelAll() throws RemoteException {
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                JobSchedulerService.this.cancelJobsForUid(uid, "cancelAll() called by app, callingUid=" + uid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(int jobId) throws RemoteException {
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                JobSchedulerService.this.cancelJob(uid, jobId, uid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpAndUsageStatsPermission(JobSchedulerService.this.getContext(), JobSchedulerService.TAG, pw)) {
                return;
            }
            int filterUid = -1;
            boolean proto = false;
            if (!ArrayUtils.isEmpty(args)) {
                int opti;
                for (opti = 0; opti < args.length; ++opti) {
                    String arg = args[opti];
                    if ("-h".equals(arg)) {
                        JobSchedulerService.dumpHelp(pw);
                        return;
                    }
                    if ("-a".equals(arg)) continue;
                    if ("--proto".equals(arg)) {
                        proto = true;
                        continue;
                    }
                    if (arg.length() <= 0 || arg.charAt(0) != '-') break;
                    pw.println("Unknown option: " + arg);
                    return;
                }
                if (opti < args.length) {
                    String pkg = args[opti];
                    try {
                        filterUid = JobSchedulerService.this.getContext().getPackageManager().getPackageUid(pkg, 0x400000);
                    }
                    catch (PackageManager.NameNotFoundException ignored) {
                        pw.println("Invalid package: " + pkg);
                        return;
                    }
                }
            }
            long identityToken = Binder.clearCallingIdentity();
            try {
                if (proto) {
                    JobSchedulerService.this.dumpInternalProto(fd, filterUid);
                } else {
                    JobSchedulerService.this.dumpInternal(new IndentingPrintWriter((Writer)pw, "  "), filterUid);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new JobSchedulerShellCommand(JobSchedulerService.this).exec(this, in, out, err, args, callback, resultReceiver);
        }
    }

    static class DeferredJobCounter
    implements Consumer<JobStatus> {
        private int mDeferred = 0;

        DeferredJobCounter() {
        }

        public int numDeferred() {
            return this.mDeferred;
        }

        @Override
        public void accept(JobStatus job) {
            if (job.getWhenStandbyDeferred() > 0L) {
                ++this.mDeferred;
            }
        }
    }

    final class StandbyTracker
    extends UsageStatsManagerInternal.AppIdleStateChangeListener {
        StandbyTracker() {
        }

        @Override
        public void onAppIdleStateChanged(String packageName, int userId, boolean idle, int bucket, int reason) {
            int uid = JobSchedulerService.this.mLocalPM.getPackageUid(packageName, 8192, userId);
            if (uid < 0) {
                if (DEBUG_STANDBY) {
                    Slog.i(JobSchedulerService.TAG, "App idle state change for unknown app " + packageName + "/" + userId);
                }
                return;
            }
            int bucketIndex = JobSchedulerService.standbyBucketToBucketIndex(bucket);
            BackgroundThread.getHandler().post(() -> {
                if (DEBUG_STANDBY) {
                    Slog.i(JobSchedulerService.TAG, "Moving uid " + uid + " to bucketIndex " + bucketIndex);
                }
                Object object = JobSchedulerService.this.mLock;
                synchronized (object) {
                    JobSchedulerService.this.mJobs.forEachJobForSourceUid(uid, job -> {
                        if (packageName.equals(job.getSourcePackageName())) {
                            job.setStandbyBucket(bucketIndex);
                        }
                    });
                    JobSchedulerService.this.onControllerStateChanged();
                }
            });
        }

        @Override
        public void onParoleStateChanged(boolean isParoleOn) {
            if (DEBUG_STANDBY) {
                Slog.i(JobSchedulerService.TAG, "Global parole state now " + (isParoleOn ? "ON" : "OFF"));
            }
            JobSchedulerService.this.mInParole = isParoleOn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUserInteractionStarted(String packageName, int userId) {
            int uid = JobSchedulerService.this.mLocalPM.getPackageUid(packageName, 8192, userId);
            if (uid < 0) {
                return;
            }
            long sinceLast = JobSchedulerService.this.mUsageStats.getTimeSinceLastJobRun(packageName, userId);
            if (sinceLast > 172800000L) {
                sinceLast = 0L;
            }
            DeferredJobCounter counter = new DeferredJobCounter();
            Object object = JobSchedulerService.this.mLock;
            synchronized (object) {
                JobSchedulerService.this.mJobs.forEachJobForSourceUid(uid, counter);
            }
            if (counter.numDeferred() > 0 || sinceLast > 0L) {
                BatteryStatsInternal mBatteryStatsInternal = LocalServices.getService(BatteryStatsInternal.class);
                mBatteryStatsInternal.noteJobsDeferred(uid, counter.numDeferred(), sinceLast);
            }
        }
    }

    final class LocalService
    implements JobSchedulerInternal {
        LocalService() {
        }

        @Override
        public long currentHeartbeat() {
            return JobSchedulerService.this.getCurrentHeartbeat();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long nextHeartbeatForBucket(int bucket) {
            Object object = JobSchedulerService.this.mLock;
            synchronized (object) {
                return JobSchedulerService.this.mNextBucketHeartbeat[bucket];
            }
        }

        @Override
        public long baseHeartbeatForApp(String packageName, int userId, int appStandbyBucket) {
            if (appStandbyBucket == 0 || appStandbyBucket >= JobSchedulerService.this.mConstants.STANDBY_BEATS.length) {
                if (DEBUG_STANDBY) {
                    Slog.v(JobSchedulerService.TAG, "Base heartbeat forced ZERO for new job in " + packageName + "/" + userId);
                }
                return 0L;
            }
            long baseHeartbeat = JobSchedulerService.this.heartbeatWhenJobsLastRun(packageName, userId);
            if (DEBUG_STANDBY) {
                Slog.v(JobSchedulerService.TAG, "Base heartbeat " + baseHeartbeat + " for new job in " + packageName + "/" + userId);
            }
            return baseHeartbeat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void noteJobStart(String packageName, int userId) {
            Object object = JobSchedulerService.this.mLock;
            synchronized (object) {
                JobSchedulerService.this.setLastJobHeartbeatLocked(packageName, userId, JobSchedulerService.this.mHeartbeat);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<JobInfo> getSystemScheduledPendingJobs() {
            Object object = JobSchedulerService.this.mLock;
            synchronized (object) {
                ArrayList<JobInfo> pendingJobs = new ArrayList<JobInfo>();
                JobSchedulerService.this.mJobs.forEachJob(1000, job -> {
                    if (job.getJob().isPeriodic() || !JobSchedulerService.this.isCurrentlyActiveLocked(job)) {
                        pendingJobs.add(job.getJob());
                    }
                });
                return pendingJobs;
            }
        }

        @Override
        public void cancelJobsForUid(int uid, String reason) {
            JobSchedulerService.this.cancelJobsForUid(uid, reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addBackingUpUid(int uid) {
            Object object = JobSchedulerService.this.mLock;
            synchronized (object) {
                JobSchedulerService.this.mBackingUpUids.put(uid, uid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeBackingUpUid(int uid) {
            Object object = JobSchedulerService.this.mLock;
            synchronized (object) {
                JobSchedulerService.this.mBackingUpUids.delete(uid);
                if (JobSchedulerService.this.mJobs.countJobsForUid(uid) > 0) {
                    JobSchedulerService.this.mHandler.obtainMessage(1).sendToTarget();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearAllBackingUpUids() {
            Object object = JobSchedulerService.this.mLock;
            synchronized (object) {
                if (JobSchedulerService.this.mBackingUpUids.size() > 0) {
                    JobSchedulerService.this.mBackingUpUids.clear();
                    JobSchedulerService.this.mHandler.obtainMessage(1).sendToTarget();
                }
            }
        }

        @Override
        public void reportAppUsage(String packageName, int userId) {
            JobSchedulerService.this.reportAppUsage(packageName, userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JobSchedulerInternal.JobStorePersistStats getPersistStats() {
            Object object = JobSchedulerService.this.mLock;
            synchronized (object) {
                return new JobSchedulerInternal.JobStorePersistStats(JobSchedulerService.this.mJobs.getPersistStats());
            }
        }
    }

    class HeartbeatAlarmListener
    implements AlarmManager.OnAlarmListener {
        HeartbeatAlarmListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            Object object = JobSchedulerService.this.mLock;
            synchronized (object) {
                long sinceLast = sElapsedRealtimeClock.millis() - JobSchedulerService.this.mLastHeartbeatTime;
                long beatsElapsed = sinceLast / JobSchedulerService.this.mConstants.STANDBY_HEARTBEAT_TIME;
                if (beatsElapsed > 0L) {
                    JobSchedulerService.this.mLastHeartbeatTime += beatsElapsed * JobSchedulerService.this.mConstants.STANDBY_HEARTBEAT_TIME;
                    JobSchedulerService.this.advanceHeartbeatLocked(beatsElapsed);
                }
            }
            JobSchedulerService.this.setNextHeartbeatAlarm();
        }
    }

    final class MaybeReadyJobQueueFunctor
    implements Consumer<JobStatus> {
        int chargingCount;
        int batteryNotLowCount;
        int storageNotLowCount;
        int idleCount;
        int backoffCount;
        int connectivityCount;
        int contentCount;
        List<JobStatus> runnableJobs;

        public MaybeReadyJobQueueFunctor() {
            this.reset();
        }

        @Override
        public void accept(JobStatus job) {
            if (JobSchedulerService.this.isReadyToBeExecutedLocked(job)) {
                try {
                    if (ActivityManager.getService().isAppStartModeDisabled(job.getUid(), job.getJob().getService().getPackageName())) {
                        Slog.w(JobSchedulerService.TAG, "Aborting job " + job.getUid() + ":" + job.getJob().toString() + " -- package not allowed to start");
                        JobSchedulerService.this.mHandler.obtainMessage(2, job).sendToTarget();
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                if (job.getNumFailures() > 0) {
                    ++this.backoffCount;
                }
                if (job.hasIdleConstraint()) {
                    ++this.idleCount;
                }
                if (job.hasConnectivityConstraint()) {
                    ++this.connectivityCount;
                }
                if (job.hasChargingConstraint()) {
                    ++this.chargingCount;
                }
                if (job.hasBatteryNotLowConstraint()) {
                    ++this.batteryNotLowCount;
                }
                if (job.hasStorageNotLowConstraint()) {
                    ++this.storageNotLowCount;
                }
                if (job.hasContentTriggerConstraint()) {
                    ++this.contentCount;
                }
                if (this.runnableJobs == null) {
                    this.runnableJobs = new ArrayList<JobStatus>();
                }
                this.runnableJobs.add(job);
            }
        }

        public void postProcess() {
            if (this.backoffCount > 0 || this.idleCount >= JobSchedulerService.this.mConstants.MIN_IDLE_COUNT || this.connectivityCount >= JobSchedulerService.this.mConstants.MIN_CONNECTIVITY_COUNT || this.chargingCount >= JobSchedulerService.this.mConstants.MIN_CHARGING_COUNT || this.batteryNotLowCount >= JobSchedulerService.this.mConstants.MIN_BATTERY_NOT_LOW_COUNT || this.storageNotLowCount >= JobSchedulerService.this.mConstants.MIN_STORAGE_NOT_LOW_COUNT || this.contentCount >= JobSchedulerService.this.mConstants.MIN_CONTENT_COUNT || this.runnableJobs != null && this.runnableJobs.size() >= JobSchedulerService.this.mConstants.MIN_READY_JOBS_COUNT) {
                if (DEBUG) {
                    Slog.d(JobSchedulerService.TAG, "maybeQueueReadyJobsForExecutionLocked: Running jobs.");
                }
                JobSchedulerService.this.noteJobsPending(this.runnableJobs);
                JobSchedulerService.this.mPendingJobs.addAll(this.runnableJobs);
                if (JobSchedulerService.this.mPendingJobs.size() > 1) {
                    JobSchedulerService.this.mPendingJobs.sort(mEnqueueTimeComparator);
                }
            } else if (DEBUG) {
                Slog.d(JobSchedulerService.TAG, "maybeQueueReadyJobsForExecutionLocked: Not running anything.");
            }
            this.reset();
        }

        private void reset() {
            this.chargingCount = 0;
            this.idleCount = 0;
            this.backoffCount = 0;
            this.connectivityCount = 0;
            this.batteryNotLowCount = 0;
            this.storageNotLowCount = 0;
            this.contentCount = 0;
            this.runnableJobs = null;
        }
    }

    final class ReadyJobQueueFunctor
    implements Consumer<JobStatus> {
        ArrayList<JobStatus> newReadyJobs;

        ReadyJobQueueFunctor() {
        }

        @Override
        public void accept(JobStatus job) {
            if (JobSchedulerService.this.isReadyToBeExecutedLocked(job)) {
                if (DEBUG) {
                    Slog.d(JobSchedulerService.TAG, "    queued " + job.toShortString());
                }
                if (this.newReadyJobs == null) {
                    this.newReadyJobs = new ArrayList();
                }
                this.newReadyJobs.add(job);
            }
        }

        public void postProcess() {
            if (this.newReadyJobs != null) {
                JobSchedulerService.this.noteJobsPending(this.newReadyJobs);
                JobSchedulerService.this.mPendingJobs.addAll(this.newReadyJobs);
                if (JobSchedulerService.this.mPendingJobs.size() > 1) {
                    JobSchedulerService.this.mPendingJobs.sort(mEnqueueTimeComparator);
                }
            }
            this.newReadyJobs = null;
        }
    }

    private final class JobHandler
    extends Handler {
        public JobHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) {
            Object object = JobSchedulerService.this.mLock;
            synchronized (object) {
                if (!JobSchedulerService.this.mReadyToRock) {
                    return;
                }
                switch (message.what) {
                    case 0: {
                        JobStatus runNow = (JobStatus)message.obj;
                        if (runNow != null && JobSchedulerService.this.isReadyToBeExecutedLocked(runNow)) {
                            JobSchedulerService.this.mJobPackageTracker.notePending(runNow);
                            JobSchedulerService.addOrderedItem(JobSchedulerService.this.mPendingJobs, runNow, mEnqueueTimeComparator);
                            break;
                        }
                        JobSchedulerService.this.queueReadyJobsForExecutionLocked();
                        break;
                    }
                    case 1: {
                        if (JobSchedulerService.this.mReportedActive) {
                            JobSchedulerService.this.queueReadyJobsForExecutionLocked();
                            break;
                        }
                        JobSchedulerService.this.maybeQueueReadyJobsForExecutionLocked();
                        break;
                    }
                    case 3: {
                        JobSchedulerService.this.queueReadyJobsForExecutionLocked();
                        break;
                    }
                    case 2: {
                        JobSchedulerService.this.cancelJobImplLocked((JobStatus)message.obj, null, "app no longer allowed to run");
                        break;
                    }
                    case 4: {
                        int uid = message.arg1;
                        int procState = message.arg2;
                        JobSchedulerService.this.updateUidState(uid, procState);
                        break;
                    }
                    case 5: {
                        int uid = message.arg1;
                        boolean disabled = message.arg2 != 0;
                        JobSchedulerService.this.updateUidState(uid, 18);
                        if (disabled) {
                            JobSchedulerService.this.cancelJobsForUid(uid, "uid gone");
                        }
                        Object object2 = JobSchedulerService.this.mLock;
                        synchronized (object2) {
                            JobSchedulerService.this.mDeviceIdleJobsController.setUidActiveLocked(uid, false);
                            break;
                        }
                    }
                    case 6: {
                        int uid = message.arg1;
                        Object disabled = JobSchedulerService.this.mLock;
                        synchronized (disabled) {
                            JobSchedulerService.this.mDeviceIdleJobsController.setUidActiveLocked(uid, true);
                            break;
                        }
                    }
                    case 7: {
                        boolean disabled;
                        int uid = message.arg1;
                        boolean bl = disabled = message.arg2 != 0;
                        if (disabled) {
                            JobSchedulerService.this.cancelJobsForUid(uid, "app uid idle");
                        }
                        Object object3 = JobSchedulerService.this.mLock;
                        synchronized (object3) {
                            JobSchedulerService.this.mDeviceIdleJobsController.setUidActiveLocked(uid, false);
                            break;
                        }
                    }
                }
                JobSchedulerService.this.maybeRunPendingJobsLocked();
                this.removeMessages(1);
            }
        }
    }

    public static class Constants {
        private static final String KEY_MIN_IDLE_COUNT = "min_idle_count";
        private static final String KEY_MIN_CHARGING_COUNT = "min_charging_count";
        private static final String KEY_MIN_BATTERY_NOT_LOW_COUNT = "min_battery_not_low_count";
        private static final String KEY_MIN_STORAGE_NOT_LOW_COUNT = "min_storage_not_low_count";
        private static final String KEY_MIN_CONNECTIVITY_COUNT = "min_connectivity_count";
        private static final String KEY_MIN_CONTENT_COUNT = "min_content_count";
        private static final String KEY_MIN_READY_JOBS_COUNT = "min_ready_jobs_count";
        private static final String KEY_HEAVY_USE_FACTOR = "heavy_use_factor";
        private static final String KEY_MODERATE_USE_FACTOR = "moderate_use_factor";
        private static final String KEY_FG_JOB_COUNT = "fg_job_count";
        private static final String KEY_BG_NORMAL_JOB_COUNT = "bg_normal_job_count";
        private static final String KEY_BG_MODERATE_JOB_COUNT = "bg_moderate_job_count";
        private static final String KEY_BG_LOW_JOB_COUNT = "bg_low_job_count";
        private static final String KEY_BG_CRITICAL_JOB_COUNT = "bg_critical_job_count";
        private static final String KEY_MAX_STANDARD_RESCHEDULE_COUNT = "max_standard_reschedule_count";
        private static final String KEY_MAX_WORK_RESCHEDULE_COUNT = "max_work_reschedule_count";
        private static final String KEY_MIN_LINEAR_BACKOFF_TIME = "min_linear_backoff_time";
        private static final String KEY_MIN_EXP_BACKOFF_TIME = "min_exp_backoff_time";
        private static final String KEY_STANDBY_HEARTBEAT_TIME = "standby_heartbeat_time";
        private static final String KEY_STANDBY_WORKING_BEATS = "standby_working_beats";
        private static final String KEY_STANDBY_FREQUENT_BEATS = "standby_frequent_beats";
        private static final String KEY_STANDBY_RARE_BEATS = "standby_rare_beats";
        private static final String KEY_CONN_CONGESTION_DELAY_FRAC = "conn_congestion_delay_frac";
        private static final String KEY_CONN_PREFETCH_RELAX_FRAC = "conn_prefetch_relax_frac";
        private static final int DEFAULT_MIN_IDLE_COUNT = 1;
        private static final int DEFAULT_MIN_CHARGING_COUNT = 1;
        private static final int DEFAULT_MIN_BATTERY_NOT_LOW_COUNT = 1;
        private static final int DEFAULT_MIN_STORAGE_NOT_LOW_COUNT = 1;
        private static final int DEFAULT_MIN_CONNECTIVITY_COUNT = 1;
        private static final int DEFAULT_MIN_CONTENT_COUNT = 1;
        private static final int DEFAULT_MIN_READY_JOBS_COUNT = 1;
        private static final float DEFAULT_HEAVY_USE_FACTOR = 0.9f;
        private static final float DEFAULT_MODERATE_USE_FACTOR = 0.5f;
        private static final int DEFAULT_FG_JOB_COUNT = 4;
        private static final int DEFAULT_BG_NORMAL_JOB_COUNT = 6;
        private static final int DEFAULT_BG_MODERATE_JOB_COUNT = 4;
        private static final int DEFAULT_BG_LOW_JOB_COUNT = 1;
        private static final int DEFAULT_BG_CRITICAL_JOB_COUNT = 1;
        private static final int DEFAULT_MAX_STANDARD_RESCHEDULE_COUNT = Integer.MAX_VALUE;
        private static final int DEFAULT_MAX_WORK_RESCHEDULE_COUNT = Integer.MAX_VALUE;
        private static final long DEFAULT_MIN_LINEAR_BACKOFF_TIME = 10000L;
        private static final long DEFAULT_MIN_EXP_BACKOFF_TIME = 10000L;
        private static final long DEFAULT_STANDBY_HEARTBEAT_TIME = 660000L;
        private static final int DEFAULT_STANDBY_WORKING_BEATS = 11;
        private static final int DEFAULT_STANDBY_FREQUENT_BEATS = 43;
        private static final int DEFAULT_STANDBY_RARE_BEATS = 130;
        private static final float DEFAULT_CONN_CONGESTION_DELAY_FRAC = 0.5f;
        private static final float DEFAULT_CONN_PREFETCH_RELAX_FRAC = 0.5f;
        int MIN_IDLE_COUNT = 1;
        int MIN_CHARGING_COUNT = 1;
        int MIN_BATTERY_NOT_LOW_COUNT = 1;
        int MIN_STORAGE_NOT_LOW_COUNT = 1;
        int MIN_CONNECTIVITY_COUNT = 1;
        int MIN_CONTENT_COUNT = 1;
        int MIN_READY_JOBS_COUNT = 1;
        float HEAVY_USE_FACTOR = 0.9f;
        float MODERATE_USE_FACTOR = 0.5f;
        int FG_JOB_COUNT = 4;
        int BG_NORMAL_JOB_COUNT = 6;
        int BG_MODERATE_JOB_COUNT = 4;
        int BG_LOW_JOB_COUNT = 1;
        int BG_CRITICAL_JOB_COUNT = 1;
        int MAX_STANDARD_RESCHEDULE_COUNT = Integer.MAX_VALUE;
        int MAX_WORK_RESCHEDULE_COUNT = Integer.MAX_VALUE;
        long MIN_LINEAR_BACKOFF_TIME = 10000L;
        long MIN_EXP_BACKOFF_TIME = 10000L;
        long STANDBY_HEARTBEAT_TIME = 660000L;
        final int[] STANDBY_BEATS = new int[]{0, 11, 43, 130};
        public float CONN_CONGESTION_DELAY_FRAC = 0.5f;
        public float CONN_PREFETCH_RELAX_FRAC = 0.5f;
        private final KeyValueListParser mParser = new KeyValueListParser(',');

        void updateConstantsLocked(String value) {
            try {
                this.mParser.setString(value);
            }
            catch (Exception e) {
                Slog.e(JobSchedulerService.TAG, "Bad jobscheduler settings", e);
            }
            this.MIN_IDLE_COUNT = this.mParser.getInt(KEY_MIN_IDLE_COUNT, 1);
            this.MIN_CHARGING_COUNT = this.mParser.getInt(KEY_MIN_CHARGING_COUNT, 1);
            this.MIN_BATTERY_NOT_LOW_COUNT = this.mParser.getInt(KEY_MIN_BATTERY_NOT_LOW_COUNT, 1);
            this.MIN_STORAGE_NOT_LOW_COUNT = this.mParser.getInt(KEY_MIN_STORAGE_NOT_LOW_COUNT, 1);
            this.MIN_CONNECTIVITY_COUNT = this.mParser.getInt(KEY_MIN_CONNECTIVITY_COUNT, 1);
            this.MIN_CONTENT_COUNT = this.mParser.getInt(KEY_MIN_CONTENT_COUNT, 1);
            this.MIN_READY_JOBS_COUNT = this.mParser.getInt(KEY_MIN_READY_JOBS_COUNT, 1);
            this.HEAVY_USE_FACTOR = this.mParser.getFloat(KEY_HEAVY_USE_FACTOR, 0.9f);
            this.MODERATE_USE_FACTOR = this.mParser.getFloat(KEY_MODERATE_USE_FACTOR, 0.5f);
            this.FG_JOB_COUNT = this.mParser.getInt(KEY_FG_JOB_COUNT, 4);
            this.BG_NORMAL_JOB_COUNT = this.mParser.getInt(KEY_BG_NORMAL_JOB_COUNT, 6);
            if (this.FG_JOB_COUNT + this.BG_NORMAL_JOB_COUNT > 16) {
                this.BG_NORMAL_JOB_COUNT = 16 - this.FG_JOB_COUNT;
            }
            this.BG_MODERATE_JOB_COUNT = this.mParser.getInt(KEY_BG_MODERATE_JOB_COUNT, 4);
            if (this.FG_JOB_COUNT + this.BG_MODERATE_JOB_COUNT > 16) {
                this.BG_MODERATE_JOB_COUNT = 16 - this.FG_JOB_COUNT;
            }
            this.BG_LOW_JOB_COUNT = this.mParser.getInt(KEY_BG_LOW_JOB_COUNT, 1);
            if (this.FG_JOB_COUNT + this.BG_LOW_JOB_COUNT > 16) {
                this.BG_LOW_JOB_COUNT = 16 - this.FG_JOB_COUNT;
            }
            this.BG_CRITICAL_JOB_COUNT = this.mParser.getInt(KEY_BG_CRITICAL_JOB_COUNT, 1);
            if (this.FG_JOB_COUNT + this.BG_CRITICAL_JOB_COUNT > 16) {
                this.BG_CRITICAL_JOB_COUNT = 16 - this.FG_JOB_COUNT;
            }
            this.MAX_STANDARD_RESCHEDULE_COUNT = this.mParser.getInt(KEY_MAX_STANDARD_RESCHEDULE_COUNT, Integer.MAX_VALUE);
            this.MAX_WORK_RESCHEDULE_COUNT = this.mParser.getInt(KEY_MAX_WORK_RESCHEDULE_COUNT, Integer.MAX_VALUE);
            this.MIN_LINEAR_BACKOFF_TIME = this.mParser.getDurationMillis(KEY_MIN_LINEAR_BACKOFF_TIME, 10000L);
            this.MIN_EXP_BACKOFF_TIME = this.mParser.getDurationMillis(KEY_MIN_EXP_BACKOFF_TIME, 10000L);
            this.STANDBY_HEARTBEAT_TIME = this.mParser.getDurationMillis(KEY_STANDBY_HEARTBEAT_TIME, 660000L);
            this.STANDBY_BEATS[1] = this.mParser.getInt(KEY_STANDBY_WORKING_BEATS, 11);
            this.STANDBY_BEATS[2] = this.mParser.getInt(KEY_STANDBY_FREQUENT_BEATS, 43);
            this.STANDBY_BEATS[3] = this.mParser.getInt(KEY_STANDBY_RARE_BEATS, 130);
            this.CONN_CONGESTION_DELAY_FRAC = this.mParser.getFloat(KEY_CONN_CONGESTION_DELAY_FRAC, 0.5f);
            this.CONN_PREFETCH_RELAX_FRAC = this.mParser.getFloat(KEY_CONN_PREFETCH_RELAX_FRAC, 0.5f);
        }

        void dump(IndentingPrintWriter pw) {
            pw.println("Settings:");
            pw.increaseIndent();
            pw.printPair(KEY_MIN_IDLE_COUNT, this.MIN_IDLE_COUNT).println();
            pw.printPair(KEY_MIN_CHARGING_COUNT, this.MIN_CHARGING_COUNT).println();
            pw.printPair(KEY_MIN_BATTERY_NOT_LOW_COUNT, this.MIN_BATTERY_NOT_LOW_COUNT).println();
            pw.printPair(KEY_MIN_STORAGE_NOT_LOW_COUNT, this.MIN_STORAGE_NOT_LOW_COUNT).println();
            pw.printPair(KEY_MIN_CONNECTIVITY_COUNT, this.MIN_CONNECTIVITY_COUNT).println();
            pw.printPair(KEY_MIN_CONTENT_COUNT, this.MIN_CONTENT_COUNT).println();
            pw.printPair(KEY_MIN_READY_JOBS_COUNT, this.MIN_READY_JOBS_COUNT).println();
            pw.printPair(KEY_HEAVY_USE_FACTOR, Float.valueOf(this.HEAVY_USE_FACTOR)).println();
            pw.printPair(KEY_MODERATE_USE_FACTOR, Float.valueOf(this.MODERATE_USE_FACTOR)).println();
            pw.printPair(KEY_FG_JOB_COUNT, this.FG_JOB_COUNT).println();
            pw.printPair(KEY_BG_NORMAL_JOB_COUNT, this.BG_NORMAL_JOB_COUNT).println();
            pw.printPair(KEY_BG_MODERATE_JOB_COUNT, this.BG_MODERATE_JOB_COUNT).println();
            pw.printPair(KEY_BG_LOW_JOB_COUNT, this.BG_LOW_JOB_COUNT).println();
            pw.printPair(KEY_BG_CRITICAL_JOB_COUNT, this.BG_CRITICAL_JOB_COUNT).println();
            pw.printPair(KEY_MAX_STANDARD_RESCHEDULE_COUNT, this.MAX_STANDARD_RESCHEDULE_COUNT).println();
            pw.printPair(KEY_MAX_WORK_RESCHEDULE_COUNT, this.MAX_WORK_RESCHEDULE_COUNT).println();
            pw.printPair(KEY_MIN_LINEAR_BACKOFF_TIME, this.MIN_LINEAR_BACKOFF_TIME).println();
            pw.printPair(KEY_MIN_EXP_BACKOFF_TIME, this.MIN_EXP_BACKOFF_TIME).println();
            pw.printPair(KEY_STANDBY_HEARTBEAT_TIME, this.STANDBY_HEARTBEAT_TIME).println();
            pw.print("standby_beats={");
            pw.print(this.STANDBY_BEATS[0]);
            for (int i = 1; i < this.STANDBY_BEATS.length; ++i) {
                pw.print(", ");
                pw.print(this.STANDBY_BEATS[i]);
            }
            pw.println('}');
            pw.printPair(KEY_CONN_CONGESTION_DELAY_FRAC, Float.valueOf(this.CONN_CONGESTION_DELAY_FRAC)).println();
            pw.printPair(KEY_CONN_PREFETCH_RELAX_FRAC, Float.valueOf(this.CONN_PREFETCH_RELAX_FRAC)).println();
            pw.decreaseIndent();
        }

        void dump(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10500000001L, this.MIN_IDLE_COUNT);
            proto.write(1120986464258L, this.MIN_CHARGING_COUNT);
            proto.write(1120986464259L, this.MIN_BATTERY_NOT_LOW_COUNT);
            proto.write(1120986464260L, this.MIN_STORAGE_NOT_LOW_COUNT);
            proto.write(0x10500000005L, this.MIN_CONNECTIVITY_COUNT);
            proto.write(1120986464262L, this.MIN_CONTENT_COUNT);
            proto.write(1120986464263L, this.MIN_READY_JOBS_COUNT);
            proto.write(0x10100000008L, this.HEAVY_USE_FACTOR);
            proto.write(0x10100000009L, this.MODERATE_USE_FACTOR);
            proto.write(1120986464266L, this.FG_JOB_COUNT);
            proto.write(1120986464267L, this.BG_NORMAL_JOB_COUNT);
            proto.write(1120986464268L, this.BG_MODERATE_JOB_COUNT);
            proto.write(1120986464269L, this.BG_LOW_JOB_COUNT);
            proto.write(1120986464270L, this.BG_CRITICAL_JOB_COUNT);
            proto.write(1120986464271L, this.MAX_STANDARD_RESCHEDULE_COUNT);
            proto.write(0x10500000010L, this.MAX_WORK_RESCHEDULE_COUNT);
            proto.write(0x10300000011L, this.MIN_LINEAR_BACKOFF_TIME);
            proto.write(1112396529682L, this.MIN_EXP_BACKOFF_TIME);
            proto.write(0x10300000013L, this.STANDBY_HEARTBEAT_TIME);
            for (int period : this.STANDBY_BEATS) {
                proto.write(2220498092052L, period);
            }
            proto.write(0x10100000015L, this.CONN_CONGESTION_DELAY_FRAC);
            proto.write(0x10100000016L, this.CONN_PREFETCH_RELAX_FRAC);
            proto.end(token);
        }
    }

    private class ConstantsObserver
    extends ContentObserver {
        private ContentResolver mResolver;

        public ConstantsObserver(Handler handler) {
            super(handler);
        }

        public void start(ContentResolver resolver) {
            this.mResolver = resolver;
            this.mResolver.registerContentObserver(Settings.Global.getUriFor("job_scheduler_constants"), false, this);
            this.updateConstants();
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.updateConstants();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConstants() {
            Object object = JobSchedulerService.this.mLock;
            synchronized (object) {
                try {
                    JobSchedulerService.this.mConstants.updateConstantsLocked(Settings.Global.getString(this.mResolver, "job_scheduler_constants"));
                }
                catch (IllegalArgumentException e) {
                    Slog.e(JobSchedulerService.TAG, "Bad jobscheduler settings", e);
                }
            }
            JobSchedulerService.this.setNextHeartbeatAlarm();
        }
    }
}

