/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.content.Context;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.JobStatus;
import java.util.function.Predicate;

public abstract class StateController {
    protected final JobSchedulerService mService;
    protected final StateChangedListener mStateChangedListener;
    protected final Context mContext;
    protected final Object mLock;
    protected final JobSchedulerService.Constants mConstants;

    StateController(JobSchedulerService service) {
        this.mService = service;
        this.mStateChangedListener = service;
        this.mContext = service.getTestableContext();
        this.mLock = service.getLock();
        this.mConstants = service.getConstants();
    }

    public abstract void maybeStartTrackingJobLocked(JobStatus var1, JobStatus var2);

    public void prepareForExecutionLocked(JobStatus jobStatus) {
    }

    public abstract void maybeStopTrackingJobLocked(JobStatus var1, JobStatus var2, boolean var3);

    public void rescheduleForFailureLocked(JobStatus newJob, JobStatus failureToReschedule) {
    }

    public abstract void dumpControllerStateLocked(IndentingPrintWriter var1, Predicate<JobStatus> var2);

    public abstract void dumpControllerStateLocked(ProtoOutputStream var1, long var2, Predicate<JobStatus> var4);
}

