/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.hardware.contexthub.V1_0.ContextHubMsg;
import android.hardware.contexthub.V1_0.IContexthub;
import android.hardware.location.IContextHubClient;
import android.hardware.location.IContextHubClientCallback;
import android.hardware.location.NanoAppMessage;
import android.os.RemoteException;
import android.util.Log;
import com.android.server.location.ContextHubClientBroker;
import com.android.server.location.ContextHubServiceUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

class ContextHubClientManager {
    private static final String TAG = "ContextHubClientManager";
    private static final int MAX_CLIENT_ID = Short.MAX_VALUE;
    private static final boolean DEBUG_LOG_ENABLED = true;
    private final Context mContext;
    private final IContexthub mContextHubProxy;
    private final ConcurrentHashMap<Short, ContextHubClientBroker> mHostEndPointIdToClientMap = new ConcurrentHashMap();
    private int mNextHostEndpointId = 0;

    ContextHubClientManager(Context context, IContexthub contextHubProxy) {
        this.mContext = context;
        this.mContextHubProxy = contextHubProxy;
    }

    IContextHubClient registerClient(IContextHubClientCallback clientCallback, int contextHubId) {
        ContextHubClientBroker broker = this.createNewClientBroker(clientCallback, contextHubId);
        try {
            broker.attachDeathRecipient();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to attach death recipient to client");
            broker.close();
            return null;
        }
        Log.d(TAG, "Registered client with host endpoint ID " + broker.getHostEndPointId());
        return IContextHubClient.Stub.asInterface(broker);
    }

    void onMessageFromNanoApp(int contextHubId, ContextHubMsg message) {
        NanoAppMessage clientMessage = ContextHubServiceUtil.createNanoAppMessage(message);
        Log.v(TAG, "Received " + clientMessage);
        if (clientMessage.isBroadcastMessage()) {
            this.broadcastMessage(contextHubId, clientMessage);
        } else {
            ContextHubClientBroker proxy = this.mHostEndPointIdToClientMap.get(message.hostEndPoint);
            if (proxy != null) {
                proxy.sendMessageToClient(clientMessage);
            } else {
                Log.e(TAG, "Cannot send message to unregistered client (host endpoint ID = " + message.hostEndPoint + ")");
            }
        }
    }

    void unregisterClient(short hostEndPointId) {
        if (this.mHostEndPointIdToClientMap.remove(hostEndPointId) != null) {
            Log.d(TAG, "Unregistered client with host endpoint ID " + hostEndPointId);
        } else {
            Log.e(TAG, "Cannot unregister non-existing client with host endpoint ID " + hostEndPointId);
        }
    }

    void onNanoAppLoaded(int contextHubId, long nanoAppId) {
        this.forEachClientOfHub(contextHubId, client -> client.onNanoAppLoaded(nanoAppId));
    }

    void onNanoAppUnloaded(int contextHubId, long nanoAppId) {
        this.forEachClientOfHub(contextHubId, client -> client.onNanoAppUnloaded(nanoAppId));
    }

    void onHubReset(int contextHubId) {
        this.forEachClientOfHub(contextHubId, client -> client.onHubReset());
    }

    void onNanoAppAborted(int contextHubId, long nanoAppId, int abortCode) {
        this.forEachClientOfHub(contextHubId, client -> client.onNanoAppAborted(nanoAppId, abortCode));
    }

    private synchronized ContextHubClientBroker createNewClientBroker(IContextHubClientCallback clientCallback, int contextHubId) {
        if (this.mHostEndPointIdToClientMap.size() == 32768) {
            throw new IllegalStateException("Could not register client - max limit exceeded");
        }
        ContextHubClientBroker broker = null;
        int id2 = this.mNextHostEndpointId;
        for (int i = 0; i <= Short.MAX_VALUE; ++i) {
            if (!this.mHostEndPointIdToClientMap.containsKey((short)id2)) {
                broker = new ContextHubClientBroker(this.mContext, this.mContextHubProxy, this, contextHubId, (short)id2, clientCallback);
                this.mHostEndPointIdToClientMap.put((short)id2, broker);
                this.mNextHostEndpointId = id2 == Short.MAX_VALUE ? 0 : id2 + 1;
                break;
            }
            id2 = id2 == Short.MAX_VALUE ? 0 : id2 + 1;
        }
        return broker;
    }

    private void broadcastMessage(int contextHubId, NanoAppMessage message) {
        this.forEachClientOfHub(contextHubId, client -> client.sendMessageToClient(message));
    }

    private void forEachClientOfHub(int contextHubId, Consumer<ContextHubClientBroker> callback) {
        for (ContextHubClientBroker broker : this.mHostEndPointIdToClientMap.values()) {
            if (broker.getAttachedContextHubId() != contextHubId) continue;
            callback.accept(broker);
        }
    }
}

