/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.hardware.contexthub.V1_0.IContexthub;
import android.hardware.location.IContextHubTransactionCallback;
import android.hardware.location.NanoAppBinary;
import android.hardware.location.NanoAppState;
import android.os.RemoteException;
import android.util.Log;
import com.android.server.location.ContextHubClientManager;
import com.android.server.location.ContextHubServiceTransaction;
import com.android.server.location.ContextHubServiceUtil;
import com.android.server.location.NanoAppStateManager;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class ContextHubTransactionManager {
    private static final String TAG = "ContextHubTransactionManager";
    private static final int MAX_PENDING_REQUESTS = 10000;
    private final IContexthub mContextHubProxy;
    private final ContextHubClientManager mClientManager;
    private final NanoAppStateManager mNanoAppStateManager;
    private final ArrayDeque<ContextHubServiceTransaction> mTransactionQueue = new ArrayDeque();
    private final AtomicInteger mNextAvailableId = new AtomicInteger();
    private final ScheduledThreadPoolExecutor mTimeoutExecutor = new ScheduledThreadPoolExecutor(1);
    private ScheduledFuture<?> mTimeoutFuture = null;

    ContextHubTransactionManager(IContexthub contextHubProxy, ContextHubClientManager clientManager, NanoAppStateManager nanoAppStateManager) {
        this.mContextHubProxy = contextHubProxy;
        this.mClientManager = clientManager;
        this.mNanoAppStateManager = nanoAppStateManager;
    }

    ContextHubServiceTransaction createLoadTransaction(final int contextHubId, final NanoAppBinary nanoAppBinary, final IContextHubTransactionCallback onCompleteCallback) {
        return new ContextHubServiceTransaction(this.mNextAvailableId.getAndIncrement(), 0){

            @Override
            int onTransact() {
                android.hardware.contexthub.V1_0.NanoAppBinary hidlNanoAppBinary = ContextHubServiceUtil.createHidlNanoAppBinary(nanoAppBinary);
                try {
                    return ContextHubTransactionManager.this.mContextHubProxy.loadNanoApp(contextHubId, hidlNanoAppBinary, this.getTransactionId());
                }
                catch (RemoteException e) {
                    Log.e(ContextHubTransactionManager.TAG, "RemoteException while trying to load nanoapp with ID 0x" + Long.toHexString(nanoAppBinary.getNanoAppId()), e);
                    return 1;
                }
            }

            @Override
            void onTransactionComplete(int result) {
                if (result == 0) {
                    ContextHubTransactionManager.this.mNanoAppStateManager.addNanoAppInstance(contextHubId, nanoAppBinary.getNanoAppId(), nanoAppBinary.getNanoAppVersion());
                }
                try {
                    onCompleteCallback.onTransactionComplete(result);
                    if (result == 0) {
                        ContextHubTransactionManager.this.mClientManager.onNanoAppLoaded(contextHubId, nanoAppBinary.getNanoAppId());
                    }
                }
                catch (RemoteException e) {
                    Log.e(ContextHubTransactionManager.TAG, "RemoteException while calling client onTransactionComplete", e);
                }
            }
        };
    }

    ContextHubServiceTransaction createUnloadTransaction(final int contextHubId, final long nanoAppId, final IContextHubTransactionCallback onCompleteCallback) {
        return new ContextHubServiceTransaction(this.mNextAvailableId.getAndIncrement(), 1){

            @Override
            int onTransact() {
                try {
                    return ContextHubTransactionManager.this.mContextHubProxy.unloadNanoApp(contextHubId, nanoAppId, this.getTransactionId());
                }
                catch (RemoteException e) {
                    Log.e(ContextHubTransactionManager.TAG, "RemoteException while trying to unload nanoapp with ID 0x" + Long.toHexString(nanoAppId), e);
                    return 1;
                }
            }

            @Override
            void onTransactionComplete(int result) {
                if (result == 0) {
                    ContextHubTransactionManager.this.mNanoAppStateManager.removeNanoAppInstance(contextHubId, nanoAppId);
                }
                try {
                    onCompleteCallback.onTransactionComplete(result);
                    if (result == 0) {
                        ContextHubTransactionManager.this.mClientManager.onNanoAppUnloaded(contextHubId, nanoAppId);
                    }
                }
                catch (RemoteException e) {
                    Log.e(ContextHubTransactionManager.TAG, "RemoteException while calling client onTransactionComplete", e);
                }
            }
        };
    }

    ContextHubServiceTransaction createEnableTransaction(final int contextHubId, final long nanoAppId, final IContextHubTransactionCallback onCompleteCallback) {
        return new ContextHubServiceTransaction(this.mNextAvailableId.getAndIncrement(), 2){

            @Override
            int onTransact() {
                try {
                    return ContextHubTransactionManager.this.mContextHubProxy.enableNanoApp(contextHubId, nanoAppId, this.getTransactionId());
                }
                catch (RemoteException e) {
                    Log.e(ContextHubTransactionManager.TAG, "RemoteException while trying to enable nanoapp with ID 0x" + Long.toHexString(nanoAppId), e);
                    return 1;
                }
            }

            @Override
            void onTransactionComplete(int result) {
                try {
                    onCompleteCallback.onTransactionComplete(result);
                }
                catch (RemoteException e) {
                    Log.e(ContextHubTransactionManager.TAG, "RemoteException while calling client onTransactionComplete", e);
                }
            }
        };
    }

    ContextHubServiceTransaction createDisableTransaction(final int contextHubId, final long nanoAppId, final IContextHubTransactionCallback onCompleteCallback) {
        return new ContextHubServiceTransaction(this.mNextAvailableId.getAndIncrement(), 3){

            @Override
            int onTransact() {
                try {
                    return ContextHubTransactionManager.this.mContextHubProxy.disableNanoApp(contextHubId, nanoAppId, this.getTransactionId());
                }
                catch (RemoteException e) {
                    Log.e(ContextHubTransactionManager.TAG, "RemoteException while trying to disable nanoapp with ID 0x" + Long.toHexString(nanoAppId), e);
                    return 1;
                }
            }

            @Override
            void onTransactionComplete(int result) {
                try {
                    onCompleteCallback.onTransactionComplete(result);
                }
                catch (RemoteException e) {
                    Log.e(ContextHubTransactionManager.TAG, "RemoteException while calling client onTransactionComplete", e);
                }
            }
        };
    }

    ContextHubServiceTransaction createQueryTransaction(final int contextHubId, final IContextHubTransactionCallback onCompleteCallback) {
        return new ContextHubServiceTransaction(this.mNextAvailableId.getAndIncrement(), 4){

            @Override
            int onTransact() {
                try {
                    return ContextHubTransactionManager.this.mContextHubProxy.queryApps(contextHubId);
                }
                catch (RemoteException e) {
                    Log.e(ContextHubTransactionManager.TAG, "RemoteException while trying to query for nanoapps", e);
                    return 1;
                }
            }

            @Override
            void onTransactionComplete(int result) {
                this.onQueryResponse(result, Collections.emptyList());
            }

            @Override
            void onQueryResponse(int result, List<NanoAppState> nanoAppStateList) {
                try {
                    onCompleteCallback.onQueryResponse(result, nanoAppStateList);
                }
                catch (RemoteException e) {
                    Log.e(ContextHubTransactionManager.TAG, "RemoteException while calling client onQueryComplete", e);
                }
            }
        };
    }

    synchronized void addTransaction(ContextHubServiceTransaction transaction) throws IllegalStateException {
        if (this.mTransactionQueue.size() == 10000) {
            throw new IllegalStateException("Transaction queue is full (capacity = 10000)");
        }
        this.mTransactionQueue.add(transaction);
        if (this.mTransactionQueue.size() == 1) {
            this.startNextTransaction();
        }
    }

    synchronized void onTransactionResponse(int transactionId, int result) {
        ContextHubServiceTransaction transaction = this.mTransactionQueue.peek();
        if (transaction == null) {
            Log.w(TAG, "Received unexpected transaction response (no transaction pending)");
            return;
        }
        if (transaction.getTransactionId() != transactionId) {
            Log.w(TAG, "Received unexpected transaction response (expected ID = " + transaction.getTransactionId() + ", received ID = " + transactionId + ")");
            return;
        }
        transaction.onTransactionComplete(result == 0 ? 0 : 5);
        this.removeTransactionAndStartNext();
    }

    synchronized void onQueryResponse(List<NanoAppState> nanoAppStateList) {
        ContextHubServiceTransaction transaction = this.mTransactionQueue.peek();
        if (transaction == null) {
            Log.w(TAG, "Received unexpected query response (no transaction pending)");
            return;
        }
        if (transaction.getTransactionType() != 4) {
            Log.w(TAG, "Received unexpected query response (expected " + transaction + ")");
            return;
        }
        transaction.onQueryResponse(0, nanoAppStateList);
        this.removeTransactionAndStartNext();
    }

    synchronized void onHubReset() {
        ContextHubServiceTransaction transaction = this.mTransactionQueue.peek();
        if (transaction == null) {
            return;
        }
        this.removeTransactionAndStartNext();
    }

    private void removeTransactionAndStartNext() {
        this.mTimeoutFuture.cancel(false);
        ContextHubServiceTransaction transaction = this.mTransactionQueue.remove();
        transaction.setComplete();
        if (!this.mTransactionQueue.isEmpty()) {
            this.startNextTransaction();
        }
    }

    private void startNextTransaction() {
        int result = 1;
        while (result != 0 && !this.mTransactionQueue.isEmpty()) {
            ContextHubServiceTransaction transaction = this.mTransactionQueue.peek();
            result = transaction.onTransact();
            if (result == 0) {
                Runnable onTimeoutFunc = () -> {
                    ContextHubTransactionManager contextHubTransactionManager = this;
                    synchronized (contextHubTransactionManager) {
                        if (!transaction.isComplete()) {
                            Log.d(TAG, transaction + " timed out");
                            transaction.onTransactionComplete(6);
                            this.removeTransactionAndStartNext();
                        }
                    }
                };
                long timeoutSeconds = transaction.getTimeout(TimeUnit.SECONDS);
                this.mTimeoutFuture = this.mTimeoutExecutor.schedule(onTimeoutFunc, timeoutSeconds, TimeUnit.SECONDS);
                continue;
            }
            transaction.onTransactionComplete(ContextHubServiceUtil.toTransactionResult(result));
            this.mTransactionQueue.remove();
        }
    }
}

