/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore;

import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.security.keystore.recovery.TrustedRootCertificates;
import android.util.Log;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;

public class TestOnlyInsecureCertificateHelper {
    private static final String TAG = "TestCertHelper";

    public X509Certificate getRootCertificate(String rootCertificateAlias) throws RemoteException {
        if (this.isTestOnlyCertificateAlias(rootCertificateAlias = this.getDefaultCertificateAliasIfEmpty(rootCertificateAlias))) {
            return TrustedRootCertificates.getTestOnlyInsecureCertificate();
        }
        X509Certificate rootCertificate = TrustedRootCertificates.getRootCertificate(rootCertificateAlias);
        if (rootCertificate == null) {
            throw new ServiceSpecificException(28, "The provided root certificate alias is invalid");
        }
        return rootCertificate;
    }

    public String getDefaultCertificateAliasIfEmpty(String rootCertificateAlias) {
        if (rootCertificateAlias == null || rootCertificateAlias.isEmpty()) {
            Log.e(TAG, "rootCertificateAlias is null or empty - use secure default value");
            rootCertificateAlias = "GoogleCloudKeyVaultServiceV1";
        }
        return rootCertificateAlias;
    }

    public boolean isTestOnlyCertificateAlias(String rootCertificateAlias) {
        return "TEST_ONLY_INSECURE_CERTIFICATE_ALIAS".equals(rootCertificateAlias);
    }

    public boolean isValidRootCertificateAlias(String rootCertificateAlias) {
        return TrustedRootCertificates.getRootCertificates().containsKey(rootCertificateAlias) || this.isTestOnlyCertificateAlias(rootCertificateAlias);
    }

    public boolean doesCredentialSupportInsecureMode(int credentialType, String credential) {
        return credentialType == 2 && credential != null && credential.startsWith("INSECURE_PSWD_");
    }

    public Map<String, SecretKey> keepOnlyWhitelistedInsecureKeys(Map<String, SecretKey> rawKeys) {
        if (rawKeys == null) {
            return null;
        }
        HashMap<String, SecretKey> filteredKeys = new HashMap<String, SecretKey>();
        for (Map.Entry<String, SecretKey> entry : rawKeys.entrySet()) {
            String alias = entry.getKey();
            if (alias == null || !alias.startsWith("INSECURE_KEY_ALIAS_KEY_MATERIAL_IS_NOT_PROTECTED_")) continue;
            filteredKeys.put(entry.getKey(), entry.getValue());
            Log.d(TAG, "adding key with insecure alias " + alias + " to the recovery snapshot");
        }
        return filteredKeys;
    }
}

