/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore.serialization;

import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.KeyChainSnapshot;
import android.security.keystore.recovery.KeyDerivationParams;
import android.security.keystore.recovery.WrappedApplicationKey;
import android.util.Base64;
import android.util.Xml;
import com.android.server.locksettings.recoverablekeystore.serialization.KeyChainSnapshotSchema;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class KeyChainSnapshotSerializer {
    public static void serialize(KeyChainSnapshot keyChainSnapshot, OutputStream outputStream) throws IOException, CertificateEncodingException {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        xmlSerializer.setOutput(outputStream, "UTF-8");
        xmlSerializer.startDocument(null, null);
        xmlSerializer.startTag(KeyChainSnapshotSchema.NAMESPACE, "keyChainSnapshot");
        KeyChainSnapshotSerializer.writeKeyChainSnapshotProperties(xmlSerializer, keyChainSnapshot);
        KeyChainSnapshotSerializer.writeKeyChainProtectionParams(xmlSerializer, keyChainSnapshot.getKeyChainProtectionParams());
        KeyChainSnapshotSerializer.writeApplicationKeys(xmlSerializer, keyChainSnapshot.getWrappedApplicationKeys());
        xmlSerializer.endTag(KeyChainSnapshotSchema.NAMESPACE, "keyChainSnapshot");
        xmlSerializer.endDocument();
    }

    private static void writeApplicationKeys(XmlSerializer xmlSerializer, List<WrappedApplicationKey> wrappedApplicationKeys) throws IOException {
        xmlSerializer.startTag(KeyChainSnapshotSchema.NAMESPACE, "applicationKeysList");
        for (WrappedApplicationKey key : wrappedApplicationKeys) {
            xmlSerializer.startTag(KeyChainSnapshotSchema.NAMESPACE, "applicationKey");
            KeyChainSnapshotSerializer.writeApplicationKeyProperties(xmlSerializer, key);
            xmlSerializer.endTag(KeyChainSnapshotSchema.NAMESPACE, "applicationKey");
        }
        xmlSerializer.endTag(KeyChainSnapshotSchema.NAMESPACE, "applicationKeysList");
    }

    private static void writeApplicationKeyProperties(XmlSerializer xmlSerializer, WrappedApplicationKey applicationKey) throws IOException {
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "alias", applicationKey.getAlias());
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "keyMaterial", applicationKey.getEncryptedKeyMaterial());
    }

    private static void writeKeyChainProtectionParams(XmlSerializer xmlSerializer, List<KeyChainProtectionParams> keyChainProtectionParamsList) throws IOException {
        xmlSerializer.startTag(KeyChainSnapshotSchema.NAMESPACE, "keyChainProtectionParamsList");
        for (KeyChainProtectionParams keyChainProtectionParams : keyChainProtectionParamsList) {
            xmlSerializer.startTag(KeyChainSnapshotSchema.NAMESPACE, "keyChainProtectionParams");
            KeyChainSnapshotSerializer.writeKeyChainProtectionParamsProperties(xmlSerializer, keyChainProtectionParams);
            xmlSerializer.endTag(KeyChainSnapshotSchema.NAMESPACE, "keyChainProtectionParams");
        }
        xmlSerializer.endTag(KeyChainSnapshotSchema.NAMESPACE, "keyChainProtectionParamsList");
    }

    private static void writeKeyChainProtectionParamsProperties(XmlSerializer xmlSerializer, KeyChainProtectionParams keyChainProtectionParams) throws IOException {
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "userSecretType", keyChainProtectionParams.getUserSecretType());
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "lockScreenUiType", keyChainProtectionParams.getLockScreenUiFormat());
        KeyChainSnapshotSerializer.writeKeyDerivationParams(xmlSerializer, keyChainProtectionParams.getKeyDerivationParams());
    }

    private static void writeKeyDerivationParams(XmlSerializer xmlSerializer, KeyDerivationParams keyDerivationParams) throws IOException {
        xmlSerializer.startTag(KeyChainSnapshotSchema.NAMESPACE, "keyDerivationParams");
        KeyChainSnapshotSerializer.writeKeyDerivationParamsProperties(xmlSerializer, keyDerivationParams);
        xmlSerializer.endTag(KeyChainSnapshotSchema.NAMESPACE, "keyDerivationParams");
    }

    private static void writeKeyDerivationParamsProperties(XmlSerializer xmlSerializer, KeyDerivationParams keyDerivationParams) throws IOException {
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "algorithm", keyDerivationParams.getAlgorithm());
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "salt", keyDerivationParams.getSalt());
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "memoryDifficulty", keyDerivationParams.getMemoryDifficulty());
    }

    private static void writeKeyChainSnapshotProperties(XmlSerializer xmlSerializer, KeyChainSnapshot keyChainSnapshot) throws IOException, CertificateEncodingException {
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "snapshotVersion", keyChainSnapshot.getSnapshotVersion());
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "maxAttempts", keyChainSnapshot.getMaxAttempts());
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "counterId", keyChainSnapshot.getCounterId());
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "recoveryKeyMaterial", keyChainSnapshot.getEncryptedRecoveryKeyBlob());
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "serverParams", keyChainSnapshot.getServerParams());
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, "thmCertPath", keyChainSnapshot.getTrustedHardwareCertPath());
    }

    private static void writePropertyTag(XmlSerializer xmlSerializer, String propertyName, long propertyValue) throws IOException {
        xmlSerializer.startTag(KeyChainSnapshotSchema.NAMESPACE, propertyName);
        xmlSerializer.text(Long.toString(propertyValue));
        xmlSerializer.endTag(KeyChainSnapshotSchema.NAMESPACE, propertyName);
    }

    private static void writePropertyTag(XmlSerializer xmlSerializer, String propertyName, String propertyValue) throws IOException {
        xmlSerializer.startTag(KeyChainSnapshotSchema.NAMESPACE, propertyName);
        xmlSerializer.text(propertyValue);
        xmlSerializer.endTag(KeyChainSnapshotSchema.NAMESPACE, propertyName);
    }

    private static void writePropertyTag(XmlSerializer xmlSerializer, String propertyName, byte[] propertyValue) throws IOException {
        xmlSerializer.startTag(KeyChainSnapshotSchema.NAMESPACE, propertyName);
        xmlSerializer.text(Base64.encodeToString(propertyValue, 0));
        xmlSerializer.endTag(KeyChainSnapshotSchema.NAMESPACE, propertyName);
    }

    private static void writePropertyTag(XmlSerializer xmlSerializer, String propertyName, CertPath certPath) throws IOException, CertificateEncodingException {
        KeyChainSnapshotSerializer.writePropertyTag(xmlSerializer, propertyName, certPath.getEncoded("PkiPath"));
    }

    private KeyChainSnapshotSerializer() {
    }
}

