/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net.watchlist;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    private static final int FILE_READ_BUFFER_SIZE = 16384;

    private DigestUtils() {
    }

    public static byte[] getSha256Hash(File apkFile) throws IOException, NoSuchAlgorithmException {
        try (FileInputStream stream = new FileInputStream(apkFile);){
            byte[] byArray = DigestUtils.getSha256Hash(stream);
            return byArray;
        }
    }

    public static byte[] getSha256Hash(InputStream stream) throws IOException, NoSuchAlgorithmException {
        int bytesRead;
        MessageDigest digester = MessageDigest.getInstance("SHA256");
        byte[] buf = new byte[16384];
        while ((bytesRead = stream.read(buf)) >= 0) {
            digester.update(buf, 0, bytesRead);
        }
        return digester.digest();
    }
}

