/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net.watchlist;

import android.content.Context;
import android.net.IIpConnectivityMetrics;
import android.net.INetdEventCallback;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.provider.Settings;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.net.INetworkWatchlistManager;
import com.android.internal.util.DumpUtils;
import com.android.server.ServiceThread;
import com.android.server.SystemService;
import com.android.server.net.BaseNetdEventCallback;
import com.android.server.net.watchlist.NetworkWatchlistShellCommand;
import com.android.server.net.watchlist.ReportWatchlistJobService;
import com.android.server.net.watchlist.WatchlistConfig;
import com.android.server.net.watchlist.WatchlistLoggingHandler;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class NetworkWatchlistService
extends INetworkWatchlistManager.Stub {
    private static final String TAG = NetworkWatchlistService.class.getSimpleName();
    static final boolean DEBUG = false;
    private static final int MAX_NUM_OF_WATCHLIST_DIGESTS = 10000;
    @GuardedBy(value="mLoggingSwitchLock")
    private volatile boolean mIsLoggingEnabled = false;
    private final Object mLoggingSwitchLock = new Object();
    private final WatchlistConfig mConfig;
    private final Context mContext;
    private final ServiceThread mHandlerThread;
    @VisibleForTesting
    IIpConnectivityMetrics mIpConnectivityMetrics;
    @VisibleForTesting
    WatchlistLoggingHandler mNetworkWatchlistHandler;
    private final INetdEventCallback mNetdEventCallback = new BaseNetdEventCallback(){

        @Override
        public void onDnsEvent(String hostname, String[] ipAddresses, int ipAddressesCount, long timestamp, int uid) {
            if (!NetworkWatchlistService.this.mIsLoggingEnabled) {
                return;
            }
            NetworkWatchlistService.this.mNetworkWatchlistHandler.asyncNetworkEvent(hostname, ipAddresses, uid);
        }

        @Override
        public void onConnectEvent(String ipAddr, int port, long timestamp, int uid) {
            if (!NetworkWatchlistService.this.mIsLoggingEnabled) {
                return;
            }
            NetworkWatchlistService.this.mNetworkWatchlistHandler.asyncNetworkEvent(null, new String[]{ipAddr}, uid);
        }
    };

    public NetworkWatchlistService(Context context) {
        this.mContext = context;
        this.mConfig = WatchlistConfig.getInstance();
        this.mHandlerThread = new ServiceThread(TAG, 10, false);
        this.mHandlerThread.start();
        this.mNetworkWatchlistHandler = new WatchlistLoggingHandler(this.mContext, this.mHandlerThread.getLooper());
        this.mNetworkWatchlistHandler.reportWatchlistIfNecessary();
    }

    @VisibleForTesting
    NetworkWatchlistService(Context context, ServiceThread handlerThread, WatchlistLoggingHandler handler, IIpConnectivityMetrics ipConnectivityMetrics) {
        this.mContext = context;
        this.mConfig = WatchlistConfig.getInstance();
        this.mHandlerThread = handlerThread;
        this.mNetworkWatchlistHandler = handler;
        this.mIpConnectivityMetrics = ipConnectivityMetrics;
    }

    private void init() {
        this.mConfig.removeTestModeConfig();
    }

    private void initIpConnectivityMetrics() {
        this.mIpConnectivityMetrics = IIpConnectivityMetrics.Stub.asInterface(ServiceManager.getService("connmetrics"));
    }

    private boolean isCallerShell() {
        int callingUid = Binder.getCallingUid();
        return callingUid == 2000 || callingUid == 0;
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        if (!this.isCallerShell()) {
            Slog.w(TAG, "Only shell is allowed to call network watchlist shell commands");
            return;
        }
        new NetworkWatchlistShellCommand(this, this.mContext).exec(this, in, out, err, args, callback, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected boolean startWatchlistLoggingImpl() throws RemoteException {
        Object object = this.mLoggingSwitchLock;
        synchronized (object) {
            if (this.mIsLoggingEnabled) {
                Slog.w(TAG, "Watchlist logging is already running");
                return true;
            }
            try {
                if (this.mIpConnectivityMetrics.addNetdEventCallback(2, this.mNetdEventCallback)) {
                    this.mIsLoggingEnabled = true;
                    return true;
                }
                return false;
            }
            catch (RemoteException re) {
                return false;
            }
        }
    }

    @Override
    public boolean startWatchlistLogging() throws RemoteException {
        this.enforceWatchlistLoggingPermission();
        return this.startWatchlistLoggingImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected boolean stopWatchlistLoggingImpl() {
        Object object = this.mLoggingSwitchLock;
        synchronized (object) {
            if (!this.mIsLoggingEnabled) {
                Slog.w(TAG, "Watchlist logging is not running");
                return true;
            }
            this.mIsLoggingEnabled = false;
            try {
                return this.mIpConnectivityMetrics.removeNetdEventCallback(2);
            }
            catch (RemoteException re) {
                return false;
            }
        }
    }

    @Override
    public boolean stopWatchlistLogging() throws RemoteException {
        this.enforceWatchlistLoggingPermission();
        return this.stopWatchlistLoggingImpl();
    }

    @Override
    public byte[] getWatchlistConfigHash() {
        return this.mConfig.getWatchlistConfigHash();
    }

    private void enforceWatchlistLoggingPermission() {
        int uid = Binder.getCallingUid();
        if (uid != 1000) {
            throw new SecurityException(String.format("Uid %d has no permission to change watchlist setting.", uid));
        }
    }

    @Override
    public void reloadWatchlist() throws RemoteException {
        this.enforceWatchlistLoggingPermission();
        Slog.i(TAG, "Reloading watchlist");
        this.mConfig.reloadConfig();
    }

    @Override
    public void reportWatchlistIfNecessary() {
        this.mNetworkWatchlistHandler.reportWatchlistIfNecessary();
    }

    public boolean forceReportWatchlistForTest(long lastReportTime) {
        if (this.mConfig.isConfigSecure()) {
            return false;
        }
        this.mNetworkWatchlistHandler.forceReportWatchlistForTest(lastReportTime);
        return true;
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        this.mConfig.dump(fd, pw, args);
    }

    public static class Lifecycle
    extends SystemService {
        private NetworkWatchlistService mService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            if (Settings.Global.getInt(this.getContext().getContentResolver(), "network_watchlist_enabled", 1) == 0) {
                Slog.i(TAG, "Network Watchlist service is disabled");
                return;
            }
            this.mService = new NetworkWatchlistService(this.getContext());
            this.publishBinderService("network_watchlist", this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                if (Settings.Global.getInt(this.getContext().getContentResolver(), "network_watchlist_enabled", 1) == 0) {
                    Slog.i(TAG, "Network Watchlist service is disabled");
                    return;
                }
                try {
                    this.mService.init();
                    this.mService.initIpConnectivityMetrics();
                    this.mService.startWatchlistLogging();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                ReportWatchlistJobService.schedule(this.getContext());
            }
        }
    }
}

