/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net.watchlist;

import android.content.Context;
import android.os.Binder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ShellCommand;
import android.provider.Settings;
import com.android.server.net.watchlist.NetworkWatchlistService;
import com.android.server.net.watchlist.WatchlistConfig;
import java.io.FileInputStream;
import java.io.PrintWriter;

class NetworkWatchlistShellCommand
extends ShellCommand {
    final Context mContext;
    final NetworkWatchlistService mService;

    NetworkWatchlistShellCommand(NetworkWatchlistService service, Context context) {
        this.mContext = context;
        this.mService = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        try {
            switch (cmd) {
                case "set-test-config": {
                    return this.runSetTestConfig();
                }
                case "force-generate-report": {
                    return this.runForceGenerateReport();
                }
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (Exception e) {
            pw.println("Exception: " + e);
            return -1;
        }
    }

    private int runSetTestConfig() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        try {
            String configXmlPath = this.getNextArgRequired();
            ParcelFileDescriptor pfd = this.openFileForSystem(configXmlPath, "r");
            if (pfd != null) {
                FileInputStream fileStream = new FileInputStream(pfd.getFileDescriptor());
                WatchlistConfig.getInstance().setTestMode(fileStream);
            }
            pw.println("Success!");
        }
        catch (Exception ex) {
            pw.println("Error: " + ex.toString());
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runForceGenerateReport() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        long ident = Binder.clearCallingIdentity();
        try {
            if (WatchlistConfig.getInstance().isConfigSecure()) {
                pw.println("Error: Cannot force generate report under production config");
                int n = -1;
                return n;
            }
            Settings.Global.putLong(this.mContext.getContentResolver(), "network_watchlist_last_report_time", 0L);
            this.mService.forceReportWatchlistForTest(System.currentTimeMillis());
            pw.println("Success!");
        }
        catch (Exception ex) {
            pw.println("Error: " + ex);
            int n = -1;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return 0;
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Network watchlist manager commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("  set-test-config your_watchlist_config.xml");
        pw.println("    Set network watchlist test config file.");
        pw.println("  force-generate-report");
        pw.println("    Force generate watchlist test report.");
    }
}

