/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net.watchlist;

import android.privacy.DifferentialPrivacyEncoder;
import android.privacy.internal.longitudinalreporting.LongitudinalReportingConfig;
import android.privacy.internal.longitudinalreporting.LongitudinalReportingEncoder;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.net.watchlist.WatchlistReportDbHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PrivacyUtils {
    private static final String TAG = "PrivacyUtils";
    private static final boolean DEBUG = false;
    private static final String ENCODER_ID_PREFIX = "watchlist_encoder:";
    private static final double PROB_F = 0.469;
    private static final double PROB_P = 0.28;
    private static final double PROB_Q = 1.0;

    private PrivacyUtils() {
    }

    @VisibleForTesting
    static DifferentialPrivacyEncoder createInsecureDPEncoderForTest(String appDigest) {
        LongitudinalReportingConfig config = PrivacyUtils.createLongitudinalReportingConfig(appDigest);
        return LongitudinalReportingEncoder.createInsecureEncoderForTest(config);
    }

    @VisibleForTesting
    static DifferentialPrivacyEncoder createSecureDPEncoder(byte[] userSecret, String appDigest) {
        LongitudinalReportingConfig config = PrivacyUtils.createLongitudinalReportingConfig(appDigest);
        return LongitudinalReportingEncoder.createEncoder(config, userSecret);
    }

    private static LongitudinalReportingConfig createLongitudinalReportingConfig(String appDigest) {
        return new LongitudinalReportingConfig(ENCODER_ID_PREFIX + appDigest, 0.469, 0.28, 1.0);
    }

    @VisibleForTesting
    static Map<String, Boolean> createDpEncodedReportMap(boolean isSecure, byte[] userSecret, List<String> appDigestList, WatchlistReportDbHelper.AggregatedResult aggregatedResult) {
        int appDigestListSize = appDigestList.size();
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(appDigestListSize);
        for (int i = 0; i < appDigestListSize; ++i) {
            String appDigest = appDigestList.get(i);
            DifferentialPrivacyEncoder encoder = isSecure ? PrivacyUtils.createSecureDPEncoder(userSecret, appDigest) : PrivacyUtils.createInsecureDPEncoderForTest(appDigest);
            boolean visitedWatchlist = aggregatedResult.appDigestList.contains(appDigest);
            boolean encodedVisitedWatchlist = (encoder.encodeBoolean(visitedWatchlist)[0] & 1) == 1;
            resultMap.put(appDigest, encodedVisitedWatchlist);
        }
        return resultMap;
    }
}

