/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net.watchlist;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Environment;
import com.android.internal.util.HexDump;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class WatchlistReportDbHelper
extends SQLiteOpenHelper {
    private static final String TAG = "WatchlistReportDbHelper";
    private static final String NAME = "watchlist_report.db";
    private static final int VERSION = 2;
    private static final int IDLE_CONNECTION_TIMEOUT_MS = 30000;
    private static final String CREATE_TABLE_MODEL = "CREATE TABLE records(app_digest BLOB,cnc_domain TEXT,timestamp INTEGER DEFAULT 0 )";
    private static final int INDEX_DIGEST = 0;
    private static final int INDEX_CNC_DOMAIN = 1;
    private static final int INDEX_TIMESTAMP = 2;
    private static final String[] DIGEST_DOMAIN_PROJECTION = new String[]{"app_digest", "cnc_domain"};
    private static WatchlistReportDbHelper sInstance;

    static File getSystemWatchlistDbFile() {
        return new File(Environment.getDataSystemDirectory(), NAME);
    }

    private WatchlistReportDbHelper(Context context) {
        super(context, WatchlistReportDbHelper.getSystemWatchlistDbFile().getAbsolutePath(), null, 2);
        this.setIdleConnectionTimeout(30000L);
    }

    public static synchronized WatchlistReportDbHelper getInstance(Context context) {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new WatchlistReportDbHelper(context);
        return sInstance;
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(CREATE_TABLE_MODEL);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS records");
        this.onCreate(db);
    }

    public boolean insertNewRecord(byte[] appDigest, String cncDomain, long timestamp) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("app_digest", appDigest);
        values.put("cnc_domain", cncDomain);
        values.put("timestamp", timestamp);
        return db.insert("records", null, values) != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AggregatedResult getAggregatedRecords(long untilTimestamp) {
        String selectStatement = "timestamp < ?";
        SQLiteDatabase db = this.getReadableDatabase();
        try (Cursor c = null;){
            c = db.query(true, "records", DIGEST_DOMAIN_PROJECTION, "timestamp < ?", new String[]{Long.toString(untilTimestamp)}, null, null, null, null);
            if (c == null) {
                AggregatedResult aggregatedResult = null;
                return aggregatedResult;
            }
            HashSet<String> appDigestList = new HashSet<String>();
            HashMap<String, String> appDigestCNCList = new HashMap<String, String>();
            String cncDomainVisited = null;
            while (c.moveToNext()) {
                String digestHexStr = HexDump.toHexString(c.getBlob(0));
                String cncDomain = c.getString(1);
                appDigestList.add(digestHexStr);
                if (cncDomainVisited != null) {
                    cncDomainVisited = cncDomain;
                }
                appDigestCNCList.put(digestHexStr, cncDomain);
            }
            AggregatedResult aggregatedResult = new AggregatedResult(appDigestList, cncDomainVisited, appDigestCNCList);
            return aggregatedResult;
        }
    }

    public boolean cleanup(long untilTimestamp) {
        String clause;
        SQLiteDatabase db = this.getWritableDatabase();
        return db.delete("records", clause = "timestamp< " + untilTimestamp, null) != 0;
    }

    public static class AggregatedResult {
        final Set<String> appDigestList;
        final String cncDomainVisited;
        final HashMap<String, String> appDigestCNCList;

        public AggregatedResult(Set<String> appDigestList, String cncDomainVisited, HashMap<String, String> appDigestCNCList) {
            this.appDigestList = appDigestList;
            this.cncDomainVisited = cncDomainVisited;
            this.appDigestCNCList = appDigestCNCList;
        }
    }

    private static class WhiteListReportContract {
        private static final String TABLE = "records";
        private static final String APP_DIGEST = "app_digest";
        private static final String CNC_DOMAIN = "cnc_domain";
        private static final String TIMESTAMP = "timestamp";

        private WhiteListReportContract() {
        }
    }
}

