/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationSignalExtractor;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.notification.RankingConfig;
import com.android.server.notification.RankingReconsideration;
import com.android.server.notification.ZenModeHelper;

public class NotificationIntrusivenessExtractor
implements NotificationSignalExtractor {
    private static final String TAG = "IntrusivenessExtractor";
    private static final boolean DBG = Log.isLoggable("IntrusivenessExtractor", 3);
    @VisibleForTesting
    static final long HANG_TIME_MS = 10000L;

    @Override
    public void initialize(Context ctx, NotificationUsageStats usageStats) {
        if (DBG) {
            Slog.d(TAG, "Initializing  " + this.getClass().getSimpleName() + ".");
        }
    }

    @Override
    public RankingReconsideration process(NotificationRecord record) {
        if (record == null || record.getNotification() == null) {
            if (DBG) {
                Slog.d(TAG, "skipping empty notification");
            }
            return null;
        }
        if ((long)record.getFreshnessMs(System.currentTimeMillis()) < 10000L && record.getImportance() >= 3) {
            if (record.getSound() != null && record.getSound() != Uri.EMPTY) {
                record.setRecentlyIntrusive(true);
            }
            if (record.getVibration() != null) {
                record.setRecentlyIntrusive(true);
            }
            if (record.getNotification().fullScreenIntent != null) {
                record.setRecentlyIntrusive(true);
            }
        }
        if (!record.isRecentlyIntrusive()) {
            return null;
        }
        return new RankingReconsideration(record.getKey(), 10000L){

            @Override
            public void work() {
            }

            @Override
            public void applyChangesLocked(NotificationRecord record) {
                if (System.currentTimeMillis() - record.getLastIntrusive() >= 10000L) {
                    record.setRecentlyIntrusive(false);
                }
            }
        };
    }

    @Override
    public void setConfig(RankingConfig config) {
    }

    @Override
    public void setZenHelper(ZenModeHelper helper) {
    }
}

