/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.metrics.LogMaker;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.notification.NotificationListenerService;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.notification.GlobalSortKeyComparator;
import com.android.server.notification.NotificationComparator;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationSignalExtractor;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.notification.RankingConfig;
import com.android.server.notification.RankingHandler;
import com.android.server.notification.RankingReconsideration;
import com.android.server.notification.ZenModeHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class RankingHelper
implements RankingConfig {
    private static final String TAG = "RankingHelper";
    private static final int XML_VERSION = 1;
    static final String TAG_RANKING = "ranking";
    private static final String TAG_PACKAGE = "package";
    private static final String TAG_CHANNEL = "channel";
    private static final String TAG_GROUP = "channelGroup";
    private static final String ATT_VERSION = "version";
    private static final String ATT_NAME = "name";
    private static final String ATT_UID = "uid";
    private static final String ATT_ID = "id";
    private static final String ATT_PRIORITY = "priority";
    private static final String ATT_VISIBILITY = "visibility";
    private static final String ATT_IMPORTANCE = "importance";
    private static final String ATT_SHOW_BADGE = "show_badge";
    private static final String ATT_APP_USER_LOCKED_FIELDS = "app_user_locked_fields";
    private static final int DEFAULT_PRIORITY = 0;
    private static final int DEFAULT_VISIBILITY = -1000;
    private static final int DEFAULT_IMPORTANCE = -1000;
    private static final boolean DEFAULT_SHOW_BADGE = true;
    private static final int DEFAULT_LOCKED_APP_FIELDS = 0;
    private final NotificationSignalExtractor[] mSignalExtractors;
    private final NotificationComparator mPreliminaryComparator;
    private final GlobalSortKeyComparator mFinalComparator = new GlobalSortKeyComparator();
    private final ArrayMap<String, Record> mRecords = new ArrayMap();
    private final ArrayMap<String, NotificationRecord> mProxyByGroupTmp = new ArrayMap();
    private final ArrayMap<String, Record> mRestoredWithoutUids = new ArrayMap();
    private final Context mContext;
    private final RankingHandler mRankingHandler;
    private final PackageManager mPm;
    private SparseBooleanArray mBadgingEnabled;
    private boolean mAreChannelsBypassingDnd;
    private ZenModeHelper mZenModeHelper;

    public RankingHelper(Context context, PackageManager pm, RankingHandler rankingHandler, ZenModeHelper zenHelper, NotificationUsageStats usageStats, String[] extractorNames) {
        this.mContext = context;
        this.mRankingHandler = rankingHandler;
        this.mPm = pm;
        this.mZenModeHelper = zenHelper;
        this.mPreliminaryComparator = new NotificationComparator(this.mContext);
        this.updateBadgingEnabled();
        int N = extractorNames.length;
        this.mSignalExtractors = new NotificationSignalExtractor[N];
        for (int i = 0; i < N; ++i) {
            try {
                Class<?> extractorClass = this.mContext.getClassLoader().loadClass(extractorNames[i]);
                NotificationSignalExtractor extractor = (NotificationSignalExtractor)extractorClass.newInstance();
                extractor.initialize(this.mContext, usageStats);
                extractor.setConfig(this);
                extractor.setZenHelper(zenHelper);
                this.mSignalExtractors[i] = extractor;
                continue;
            }
            catch (ClassNotFoundException e) {
                Slog.w(TAG, "Couldn't find extractor " + extractorNames[i] + ".", e);
                continue;
            }
            catch (InstantiationException e) {
                Slog.w(TAG, "Couldn't instantiate extractor " + extractorNames[i] + ".", e);
                continue;
            }
            catch (IllegalAccessException e) {
                Slog.w(TAG, "Problem accessing extractor " + extractorNames[i] + ".", e);
            }
        }
        this.mAreChannelsBypassingDnd = (this.mZenModeHelper.getNotificationPolicy().state & 1) == 1;
        this.updateChannelsBypassingDnd();
    }

    public <T extends NotificationSignalExtractor> T findExtractor(Class<T> extractorClass) {
        for (NotificationSignalExtractor extractor : this.mSignalExtractors) {
            if (!extractorClass.equals(extractor.getClass())) continue;
            return (T)extractor;
        }
        return null;
    }

    public void extractSignals(NotificationRecord r) {
        for (NotificationSignalExtractor extractor : this.mSignalExtractors) {
            try {
                RankingReconsideration recon = extractor.process(r);
                if (recon == null) continue;
                this.mRankingHandler.requestReconsideration(recon);
            }
            catch (Throwable t) {
                Slog.w(TAG, "NotificationSignalExtractor failed.", t);
            }
        }
    }

    public void readXml(XmlPullParser parser, boolean forRestore) throws XmlPullParserException, IOException {
        int type = parser.getEventType();
        if (type != 2) {
            return;
        }
        String tag = parser.getName();
        if (!TAG_RANKING.equals(tag)) {
            return;
        }
        this.mRestoredWithoutUids.clear();
        while ((type = parser.next()) != 1) {
            tag = parser.getName();
            if (type == 3 && TAG_RANKING.equals(tag)) {
                return;
            }
            if (type != 2 || !TAG_PACKAGE.equals(tag)) continue;
            int uid = XmlUtils.readIntAttribute(parser, ATT_UID, Record.UNKNOWN_UID);
            String name = parser.getAttributeValue(null, ATT_NAME);
            if (TextUtils.isEmpty(name)) continue;
            if (forRestore) {
                try {
                    uid = this.mPm.getPackageUidAsUser(name, 0);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            Record r = this.getOrCreateRecord(name, uid, XmlUtils.readIntAttribute(parser, ATT_IMPORTANCE, -1000), XmlUtils.readIntAttribute(parser, ATT_PRIORITY, 0), XmlUtils.readIntAttribute(parser, ATT_VISIBILITY, -1000), XmlUtils.readBooleanAttribute(parser, ATT_SHOW_BADGE, true));
            r.importance = XmlUtils.readIntAttribute(parser, ATT_IMPORTANCE, -1000);
            r.priority = XmlUtils.readIntAttribute(parser, ATT_PRIORITY, 0);
            r.visibility = XmlUtils.readIntAttribute(parser, ATT_VISIBILITY, -1000);
            r.showBadge = XmlUtils.readBooleanAttribute(parser, ATT_SHOW_BADGE, true);
            r.lockedAppFields = XmlUtils.readIntAttribute(parser, ATT_APP_USER_LOCKED_FIELDS, 0);
            int innerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                String id2;
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (TAG_GROUP.equals(tagName)) {
                    id2 = parser.getAttributeValue(null, ATT_ID);
                    String groupName = parser.getAttributeValue(null, ATT_NAME);
                    if (!TextUtils.isEmpty(id2)) {
                        NotificationChannelGroup group = new NotificationChannelGroup(id2, groupName);
                        group.populateFromXml(parser);
                        r.groups.put(id2, group);
                    }
                }
                if (!TAG_CHANNEL.equals(tagName)) continue;
                id2 = parser.getAttributeValue(null, ATT_ID);
                String channelName = parser.getAttributeValue(null, ATT_NAME);
                int channelImportance = XmlUtils.readIntAttribute(parser, ATT_IMPORTANCE, -1000);
                if (TextUtils.isEmpty(id2) || TextUtils.isEmpty(channelName)) continue;
                NotificationChannel channel = new NotificationChannel(id2, channelName, channelImportance);
                if (forRestore) {
                    channel.populateFromXmlForRestore(parser, this.mContext);
                } else {
                    channel.populateFromXml(parser);
                }
                r.channels.put(id2, channel);
            }
            try {
                this.deleteDefaultChannelIfNeeded(r);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.e(TAG, "deleteDefaultChannelIfNeeded - Exception: " + e);
            }
        }
        throw new IllegalStateException("Failed to reach END_DOCUMENT");
    }

    private static String recordKey(String pkg, int uid) {
        return pkg + "|" + uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Record getRecord(String pkg, int uid) {
        String key = RankingHelper.recordKey(pkg, uid);
        ArrayMap<String, Record> arrayMap = this.mRecords;
        synchronized (arrayMap) {
            return this.mRecords.get(key);
        }
    }

    private Record getOrCreateRecord(String pkg, int uid) {
        return this.getOrCreateRecord(pkg, uid, -1000, 0, -1000, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Record getOrCreateRecord(String pkg, int uid, int importance, int priority, int visibility, boolean showBadge) {
        String key = RankingHelper.recordKey(pkg, uid);
        ArrayMap<String, Record> arrayMap = this.mRecords;
        synchronized (arrayMap) {
            Record r;
            Record record = r = uid == Record.UNKNOWN_UID ? this.mRestoredWithoutUids.get(pkg) : this.mRecords.get(key);
            if (r == null) {
                r = new Record();
                r.pkg = pkg;
                r.uid = uid;
                r.importance = importance;
                r.priority = priority;
                r.visibility = visibility;
                r.showBadge = showBadge;
                try {
                    this.createDefaultChannelIfNeeded(r);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.e(TAG, "createDefaultChannelIfNeeded - Exception: " + e);
                }
                if (r.uid == Record.UNKNOWN_UID) {
                    this.mRestoredWithoutUids.put(pkg, r);
                } else {
                    this.mRecords.put(key, r);
                }
            }
            return r;
        }
    }

    private boolean shouldHaveDefaultChannel(Record r) throws PackageManager.NameNotFoundException {
        int userId = UserHandle.getUserId(r.uid);
        ApplicationInfo applicationInfo = this.mPm.getApplicationInfoAsUser(r.pkg, 0, userId);
        return applicationInfo.targetSdkVersion < 26;
    }

    private void deleteDefaultChannelIfNeeded(Record r) throws PackageManager.NameNotFoundException {
        if (!r.channels.containsKey("miscellaneous")) {
            return;
        }
        if (this.shouldHaveDefaultChannel(r)) {
            return;
        }
        r.channels.remove("miscellaneous");
    }

    private void createDefaultChannelIfNeeded(Record r) throws PackageManager.NameNotFoundException {
        if (r.channels.containsKey("miscellaneous")) {
            r.channels.get("miscellaneous").setName(this.mContext.getString(17039783));
            return;
        }
        if (!this.shouldHaveDefaultChannel(r)) {
            return;
        }
        NotificationChannel channel = new NotificationChannel("miscellaneous", this.mContext.getString(17039783), r.importance);
        channel.setBypassDnd(r.priority == 2);
        channel.setLockscreenVisibility(r.visibility);
        if (r.importance != -1000) {
            channel.lockFields(4);
        }
        if (r.priority != 0) {
            channel.lockFields(1);
        }
        if (r.visibility != -1000) {
            channel.lockFields(2);
        }
        r.channels.put(channel.getId(), channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXml(XmlSerializer out, boolean forBackup) throws IOException {
        out.startTag(null, TAG_RANKING);
        out.attribute(null, ATT_VERSION, Integer.toString(1));
        ArrayMap<String, Record> arrayMap = this.mRecords;
        synchronized (arrayMap) {
            int N = this.mRecords.size();
            for (int i = 0; i < N; ++i) {
                boolean hasNonDefaultSettings;
                Record r = this.mRecords.valueAt(i);
                if (forBackup && UserHandle.getUserId(r.uid) != 0) continue;
                boolean bl = hasNonDefaultSettings = r.importance != -1000 || r.priority != 0 || r.visibility != -1000 || !r.showBadge || r.lockedAppFields != 0 || r.channels.size() > 0 || r.groups.size() > 0;
                if (!hasNonDefaultSettings) continue;
                out.startTag(null, TAG_PACKAGE);
                out.attribute(null, ATT_NAME, r.pkg);
                if (r.importance != -1000) {
                    out.attribute(null, ATT_IMPORTANCE, Integer.toString(r.importance));
                }
                if (r.priority != 0) {
                    out.attribute(null, ATT_PRIORITY, Integer.toString(r.priority));
                }
                if (r.visibility != -1000) {
                    out.attribute(null, ATT_VISIBILITY, Integer.toString(r.visibility));
                }
                out.attribute(null, ATT_SHOW_BADGE, Boolean.toString(r.showBadge));
                out.attribute(null, ATT_APP_USER_LOCKED_FIELDS, Integer.toString(r.lockedAppFields));
                if (!forBackup) {
                    out.attribute(null, ATT_UID, Integer.toString(r.uid));
                }
                for (NotificationChannelGroup group : r.groups.values()) {
                    group.writeXml(out);
                }
                for (NotificationChannel channel : r.channels.values()) {
                    if (forBackup) {
                        if (channel.isDeleted()) continue;
                        channel.writeXmlForBackup(out, this.mContext);
                        continue;
                    }
                    channel.writeXml(out);
                }
                out.endTag(null, TAG_PACKAGE);
            }
        }
        out.endTag(null, TAG_RANKING);
    }

    private void updateConfig() {
        int N = this.mSignalExtractors.length;
        for (int i = 0; i < N; ++i) {
            this.mSignalExtractors[i].setConfig(this);
        }
        this.mRankingHandler.requestSort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(ArrayList<NotificationRecord> notificationList) {
        int N = notificationList.size();
        for (int i = N - 1; i >= 0; --i) {
            notificationList.get(i).setGlobalSortKey(null);
        }
        Collections.sort(notificationList, this.mPreliminaryComparator);
        ArrayMap<String, NotificationRecord> arrayMap = this.mProxyByGroupTmp;
        synchronized (arrayMap) {
            NotificationRecord record;
            int i;
            for (i = N - 1; i >= 0; --i) {
                record = notificationList.get(i);
                record.setAuthoritativeRank(i);
                String groupKey = record.getGroupKey();
                NotificationRecord existingProxy = this.mProxyByGroupTmp.get(groupKey);
                if (existingProxy != null) continue;
                this.mProxyByGroupTmp.put(groupKey, record);
            }
            for (i = 0; i < N; ++i) {
                record = notificationList.get(i);
                NotificationRecord groupProxy = this.mProxyByGroupTmp.get(record.getGroupKey());
                String groupSortKey = record.getNotification().getSortKey();
                String groupSortKeyPortion = groupSortKey == null ? "nsk" : (groupSortKey.equals("") ? "esk" : "gsk=" + groupSortKey);
                boolean isGroupSummary = record.getNotification().isGroupSummary();
                record.setGlobalSortKey(String.format("intrsv=%c:grnk=0x%04x:gsmry=%c:%s:rnk=0x%04x", Character.valueOf((char)(record.isRecentlyIntrusive() && record.getImportance() > 1 ? 48 : 49)), groupProxy.getAuthoritativeRank(), Character.valueOf(isGroupSummary ? (char)'0' : '1'), groupSortKeyPortion, record.getAuthoritativeRank()));
            }
            this.mProxyByGroupTmp.clear();
        }
        Collections.sort(notificationList, this.mFinalComparator);
    }

    public int indexOf(ArrayList<NotificationRecord> notificationList, NotificationRecord target) {
        return Collections.binarySearch(notificationList, target, this.mFinalComparator);
    }

    @Override
    public int getImportance(String packageName, int uid) {
        return this.getOrCreateRecord((String)packageName, (int)uid).importance;
    }

    public boolean getIsAppImportanceLocked(String packageName, int uid) {
        int userLockedFields = this.getOrCreateRecord((String)packageName, (int)uid).lockedAppFields;
        return (userLockedFields & 1) != 0;
    }

    @Override
    public boolean canShowBadge(String packageName, int uid) {
        return this.getOrCreateRecord((String)packageName, (int)uid).showBadge;
    }

    @Override
    public void setShowBadge(String packageName, int uid, boolean showBadge) {
        this.getOrCreateRecord((String)packageName, (int)uid).showBadge = showBadge;
        this.updateConfig();
    }

    @Override
    public boolean isGroupBlocked(String packageName, int uid, String groupId) {
        if (groupId == null) {
            return false;
        }
        Record r = this.getOrCreateRecord(packageName, uid);
        NotificationChannelGroup group = r.groups.get(groupId);
        if (group == null) {
            return false;
        }
        return group.isBlocked();
    }

    int getPackagePriority(String pkg, int uid) {
        return this.getOrCreateRecord((String)pkg, (int)uid).priority;
    }

    int getPackageVisibility(String pkg, int uid) {
        return this.getOrCreateRecord((String)pkg, (int)uid).visibility;
    }

    @Override
    public void createNotificationChannelGroup(String pkg, int uid, NotificationChannelGroup group, boolean fromTargetApp) {
        Preconditions.checkNotNull(pkg);
        Preconditions.checkNotNull(group);
        Preconditions.checkNotNull(group.getId());
        Preconditions.checkNotNull(!TextUtils.isEmpty(group.getName()));
        Record r = this.getOrCreateRecord(pkg, uid);
        if (r == null) {
            throw new IllegalArgumentException("Invalid package");
        }
        NotificationChannelGroup oldGroup = r.groups.get(group.getId());
        if (!group.equals(oldGroup)) {
            MetricsLogger.action(this.getChannelGroupLog(group.getId(), pkg));
        }
        if (oldGroup != null) {
            group.setChannels(oldGroup.getChannels());
            if (fromTargetApp) {
                group.setBlocked(oldGroup.isBlocked());
            }
        }
        r.groups.put(group.getId(), group);
    }

    @Override
    public void createNotificationChannel(String pkg, int uid, NotificationChannel channel, boolean fromTargetApp, boolean hasDndAccess) {
        Preconditions.checkNotNull(pkg);
        Preconditions.checkNotNull(channel);
        Preconditions.checkNotNull(channel.getId());
        Preconditions.checkArgument(!TextUtils.isEmpty(channel.getName()));
        Record r = this.getOrCreateRecord(pkg, uid);
        if (r == null) {
            throw new IllegalArgumentException("Invalid package");
        }
        if (channel.getGroup() != null && !r.groups.containsKey(channel.getGroup())) {
            throw new IllegalArgumentException("NotificationChannelGroup doesn't exist");
        }
        if ("miscellaneous".equals(channel.getId())) {
            throw new IllegalArgumentException("Reserved id");
        }
        NotificationChannel existing = r.channels.get(channel.getId());
        if (existing != null && fromTargetApp) {
            if (existing.isDeleted()) {
                existing.setDeleted(false);
                MetricsLogger.action(this.getChannelLog(channel, pkg).setType(1));
            }
            existing.setName(channel.getName().toString());
            existing.setDescription(channel.getDescription());
            existing.setBlockableSystem(channel.isBlockableSystem());
            if (existing.getGroup() == null) {
                existing.setGroup(channel.getGroup());
            }
            if (existing.getUserLockedFields() == 0 && channel.getImportance() < existing.getImportance()) {
                existing.setImportance(channel.getImportance());
            }
            if (existing.getUserLockedFields() == 0 && hasDndAccess) {
                boolean bypassDnd = channel.canBypassDnd();
                existing.setBypassDnd(bypassDnd);
                if (bypassDnd != this.mAreChannelsBypassingDnd) {
                    this.updateChannelsBypassingDnd();
                }
            }
            this.updateConfig();
            return;
        }
        if (channel.getImportance() < 0 || channel.getImportance() > 5) {
            throw new IllegalArgumentException("Invalid importance level");
        }
        if (fromTargetApp && !hasDndAccess) {
            channel.setBypassDnd(r.priority == 2);
        }
        if (fromTargetApp) {
            channel.setLockscreenVisibility(r.visibility);
        }
        this.clearLockedFields(channel);
        if (channel.getLockscreenVisibility() == 1) {
            channel.setLockscreenVisibility(-1000);
        }
        if (!r.showBadge) {
            channel.setShowBadge(false);
        }
        r.channels.put(channel.getId(), channel);
        if (channel.canBypassDnd() != this.mAreChannelsBypassingDnd) {
            this.updateChannelsBypassingDnd();
        }
        MetricsLogger.action(this.getChannelLog(channel, pkg).setType(1));
    }

    void clearLockedFields(NotificationChannel channel) {
        channel.unlockFields(channel.getUserLockedFields());
    }

    @Override
    public void updateNotificationChannel(String pkg, int uid, NotificationChannel updatedChannel, boolean fromUser) {
        Preconditions.checkNotNull(updatedChannel);
        Preconditions.checkNotNull(updatedChannel.getId());
        Record r = this.getOrCreateRecord(pkg, uid);
        if (r == null) {
            throw new IllegalArgumentException("Invalid package");
        }
        NotificationChannel channel = r.channels.get(updatedChannel.getId());
        if (channel == null || channel.isDeleted()) {
            throw new IllegalArgumentException("Channel does not exist");
        }
        if (updatedChannel.getLockscreenVisibility() == 1) {
            updatedChannel.setLockscreenVisibility(-1000);
        }
        if (!fromUser) {
            updatedChannel.unlockFields(updatedChannel.getUserLockedFields());
        }
        if (fromUser) {
            updatedChannel.lockFields(channel.getUserLockedFields());
            this.lockFieldsForUpdate(channel, updatedChannel);
        }
        r.channels.put(updatedChannel.getId(), updatedChannel);
        if ("miscellaneous".equals(updatedChannel.getId())) {
            r.importance = updatedChannel.getImportance();
            r.priority = updatedChannel.canBypassDnd() ? 2 : 0;
            r.visibility = updatedChannel.getLockscreenVisibility();
            r.showBadge = updatedChannel.canShowBadge();
        }
        if (!channel.equals(updatedChannel)) {
            MetricsLogger.action(this.getChannelLog(updatedChannel, pkg));
        }
        if (updatedChannel.canBypassDnd() != this.mAreChannelsBypassingDnd) {
            this.updateChannelsBypassingDnd();
        }
        this.updateConfig();
    }

    @Override
    public NotificationChannel getNotificationChannel(String pkg, int uid, String channelId, boolean includeDeleted) {
        NotificationChannel nc;
        Preconditions.checkNotNull(pkg);
        Record r = this.getOrCreateRecord(pkg, uid);
        if (r == null) {
            return null;
        }
        if (channelId == null) {
            channelId = "miscellaneous";
        }
        if ((nc = r.channels.get(channelId)) != null && (includeDeleted || !nc.isDeleted())) {
            return nc;
        }
        return null;
    }

    @Override
    public void deleteNotificationChannel(String pkg, int uid, String channelId) {
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return;
        }
        NotificationChannel channel = r.channels.get(channelId);
        if (channel != null) {
            channel.setDeleted(true);
            LogMaker lm = this.getChannelLog(channel, pkg);
            lm.setType(2);
            MetricsLogger.action(lm);
            if (this.mAreChannelsBypassingDnd && channel.canBypassDnd()) {
                this.updateChannelsBypassingDnd();
            }
        }
    }

    @Override
    @VisibleForTesting
    public void permanentlyDeleteNotificationChannel(String pkg, int uid, String channelId) {
        Preconditions.checkNotNull(pkg);
        Preconditions.checkNotNull(channelId);
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return;
        }
        r.channels.remove(channelId);
    }

    @Override
    public void permanentlyDeleteNotificationChannels(String pkg, int uid) {
        int N;
        Preconditions.checkNotNull(pkg);
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return;
        }
        for (int i = N = r.channels.size() - 1; i >= 0; --i) {
            String key = r.channels.keyAt(i);
            if ("miscellaneous".equals(key)) continue;
            r.channels.remove(key);
        }
    }

    public NotificationChannelGroup getNotificationChannelGroupWithChannels(String pkg, int uid, String groupId, boolean includeDeleted) {
        Preconditions.checkNotNull(pkg);
        Record r = this.getRecord(pkg, uid);
        if (r == null || groupId == null || !r.groups.containsKey(groupId)) {
            return null;
        }
        Object group = r.groups.get(groupId).clone();
        ((NotificationChannelGroup)group).setChannels(new ArrayList<NotificationChannel>());
        int N = r.channels.size();
        for (int i = 0; i < N; ++i) {
            NotificationChannel nc = r.channels.valueAt(i);
            if (!includeDeleted && nc.isDeleted() || !groupId.equals(nc.getGroup())) continue;
            ((NotificationChannelGroup)group).addChannel(nc);
        }
        return group;
    }

    public NotificationChannelGroup getNotificationChannelGroup(String groupId, String pkg, int uid) {
        Preconditions.checkNotNull(pkg);
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return null;
        }
        return r.groups.get(groupId);
    }

    @Override
    public ParceledListSlice<NotificationChannelGroup> getNotificationChannelGroups(String pkg, int uid, boolean includeDeleted, boolean includeNonGrouped) {
        Preconditions.checkNotNull(pkg);
        ArrayMap<String, Object> groups = new ArrayMap<String, Object>();
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return ParceledListSlice.emptyList();
        }
        NotificationChannelGroup nonGrouped = new NotificationChannelGroup(null, null);
        int N = r.channels.size();
        for (int i = 0; i < N; ++i) {
            NotificationChannel nc = r.channels.valueAt(i);
            if (!includeDeleted && nc.isDeleted()) continue;
            if (nc.getGroup() != null) {
                if (r.groups.get(nc.getGroup()) == null) continue;
                Object ncg = (NotificationChannelGroup)groups.get(nc.getGroup());
                if (ncg == null) {
                    ncg = r.groups.get(nc.getGroup()).clone();
                    ((NotificationChannelGroup)ncg).setChannels(new ArrayList<NotificationChannel>());
                    groups.put(nc.getGroup(), ncg);
                }
                ((NotificationChannelGroup)ncg).addChannel(nc);
                continue;
            }
            nonGrouped.addChannel(nc);
        }
        if (includeNonGrouped && nonGrouped.getChannels().size() > 0) {
            groups.put(null, nonGrouped);
        }
        return new ParceledListSlice<NotificationChannelGroup>(new ArrayList(groups.values()));
    }

    public List<NotificationChannel> deleteNotificationChannelGroup(String pkg, int uid, String groupId) {
        ArrayList<NotificationChannel> deletedChannels = new ArrayList<NotificationChannel>();
        Record r = this.getRecord(pkg, uid);
        if (r == null || TextUtils.isEmpty(groupId)) {
            return deletedChannels;
        }
        r.groups.remove(groupId);
        int N = r.channels.size();
        for (int i = 0; i < N; ++i) {
            NotificationChannel nc = r.channels.valueAt(i);
            if (!groupId.equals(nc.getGroup())) continue;
            nc.setDeleted(true);
            deletedChannels.add(nc);
        }
        return deletedChannels;
    }

    @Override
    public Collection<NotificationChannelGroup> getNotificationChannelGroups(String pkg, int uid) {
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return new ArrayList<NotificationChannelGroup>();
        }
        return r.groups.values();
    }

    @Override
    public ParceledListSlice<NotificationChannel> getNotificationChannels(String pkg, int uid, boolean includeDeleted) {
        Preconditions.checkNotNull(pkg);
        ArrayList<NotificationChannel> channels = new ArrayList<NotificationChannel>();
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return ParceledListSlice.emptyList();
        }
        int N = r.channels.size();
        for (int i = 0; i < N; ++i) {
            NotificationChannel nc = r.channels.valueAt(i);
            if (!includeDeleted && nc.isDeleted()) continue;
            channels.add(nc);
        }
        return new ParceledListSlice<NotificationChannel>(channels);
    }

    public boolean onlyHasDefaultChannel(String pkg, int uid) {
        Record r = this.getOrCreateRecord(pkg, uid);
        return r.channels.size() == 1 && r.channels.containsKey("miscellaneous");
    }

    public int getDeletedChannelCount(String pkg, int uid) {
        Preconditions.checkNotNull(pkg);
        int deletedCount = 0;
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return deletedCount;
        }
        int N = r.channels.size();
        for (int i = 0; i < N; ++i) {
            NotificationChannel nc = r.channels.valueAt(i);
            if (!nc.isDeleted()) continue;
            ++deletedCount;
        }
        return deletedCount;
    }

    public int getBlockedChannelCount(String pkg, int uid) {
        Preconditions.checkNotNull(pkg);
        int blockedCount = 0;
        Record r = this.getRecord(pkg, uid);
        if (r == null) {
            return blockedCount;
        }
        int N = r.channels.size();
        for (int i = 0; i < N; ++i) {
            NotificationChannel nc = r.channels.valueAt(i);
            if (nc.isDeleted() || 0 != nc.getImportance()) continue;
            ++blockedCount;
        }
        return blockedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBlockedAppCount(int userId) {
        int count = 0;
        ArrayMap<String, Record> arrayMap = this.mRecords;
        synchronized (arrayMap) {
            int N = this.mRecords.size();
            for (int i = 0; i < N; ++i) {
                Record r = this.mRecords.valueAt(i);
                if (userId != UserHandle.getUserId(r.uid) || r.importance != 0) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChannelsBypassingDnd() {
        ArrayMap<String, Record> arrayMap = this.mRecords;
        synchronized (arrayMap) {
            int numRecords = this.mRecords.size();
            for (int recordIndex = 0; recordIndex < numRecords; ++recordIndex) {
                Record r = this.mRecords.valueAt(recordIndex);
                int numChannels = r.channels.size();
                for (int channelIndex = 0; channelIndex < numChannels; ++channelIndex) {
                    NotificationChannel channel = r.channels.valueAt(channelIndex);
                    if (channel.isDeleted() || !channel.canBypassDnd()) continue;
                    if (!this.mAreChannelsBypassingDnd) {
                        this.mAreChannelsBypassingDnd = true;
                        this.updateZenPolicy(true);
                    }
                    return;
                }
            }
        }
        if (this.mAreChannelsBypassingDnd) {
            this.mAreChannelsBypassingDnd = false;
            this.updateZenPolicy(false);
        }
    }

    public void updateZenPolicy(boolean areChannelsBypassingDnd) {
        NotificationManager.Policy policy = this.mZenModeHelper.getNotificationPolicy();
        this.mZenModeHelper.setNotificationPolicy(new NotificationManager.Policy(policy.priorityCategories, policy.priorityCallSenders, policy.priorityMessageSenders, policy.suppressedVisualEffects, areChannelsBypassingDnd ? 1 : 0));
    }

    public boolean areChannelsBypassingDnd() {
        return this.mAreChannelsBypassingDnd;
    }

    @Override
    public void setImportance(String pkgName, int uid, int importance) {
        this.getOrCreateRecord((String)pkgName, (int)uid).importance = importance;
        this.updateConfig();
    }

    public void setEnabled(String packageName, int uid, boolean enabled) {
        boolean wasEnabled;
        boolean bl = wasEnabled = this.getImportance(packageName, uid) != 0;
        if (wasEnabled == enabled) {
            return;
        }
        this.setImportance(packageName, uid, enabled ? -1000 : 0);
    }

    public void setAppImportanceLocked(String packageName, int uid) {
        Record record = this.getOrCreateRecord(packageName, uid);
        if ((record.lockedAppFields & 1) != 0) {
            return;
        }
        record.lockedAppFields |= 1;
        this.updateConfig();
    }

    @VisibleForTesting
    void lockFieldsForUpdate(NotificationChannel original, NotificationChannel update) {
        if (original.canBypassDnd() != update.canBypassDnd()) {
            update.lockFields(1);
        }
        if (original.getLockscreenVisibility() != update.getLockscreenVisibility()) {
            update.lockFields(2);
        }
        if (original.getImportance() != update.getImportance()) {
            update.lockFields(4);
        }
        if (original.shouldShowLights() != update.shouldShowLights() || original.getLightColor() != update.getLightColor()) {
            update.lockFields(8);
        }
        if (!Objects.equals(original.getSound(), update.getSound())) {
            update.lockFields(32);
        }
        if (!Arrays.equals(original.getVibrationPattern(), update.getVibrationPattern()) || original.shouldVibrate() != update.shouldVibrate()) {
            update.lockFields(16);
        }
        if (original.canShowBadge() != update.canShowBadge()) {
            update.lockFields(128);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix, NotificationManagerService.DumpFilter filter) {
        int N = this.mSignalExtractors.length;
        pw.print(prefix);
        pw.print("mSignalExtractors.length = ");
        pw.println(N);
        for (int i = 0; i < N; ++i) {
            pw.print(prefix);
            pw.print("  ");
            pw.println(this.mSignalExtractors[i].getClass().getSimpleName());
        }
        pw.print(prefix);
        pw.println("per-package config:");
        pw.println("Records:");
        ArrayMap<String, Record> arrayMap = this.mRecords;
        synchronized (arrayMap) {
            RankingHelper.dumpRecords(pw, prefix, filter, this.mRecords);
        }
        pw.println("Restored without uid:");
        RankingHelper.dumpRecords(pw, prefix, filter, this.mRestoredWithoutUids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(ProtoOutputStream proto, NotificationManagerService.DumpFilter filter) {
        int N = this.mSignalExtractors.length;
        for (int i = 0; i < N; ++i) {
            proto.write(2237677961217L, this.mSignalExtractors[i].getClass().getSimpleName());
        }
        ArrayMap<String, Record> arrayMap = this.mRecords;
        synchronized (arrayMap) {
            RankingHelper.dumpRecords(proto, 0x20B00000002L, filter, this.mRecords);
        }
        RankingHelper.dumpRecords(proto, 2246267895811L, filter, this.mRestoredWithoutUids);
    }

    private static void dumpRecords(ProtoOutputStream proto, long fieldId, NotificationManagerService.DumpFilter filter, ArrayMap<String, Record> records) {
        int N = records.size();
        for (int i = 0; i < N; ++i) {
            Record r = records.valueAt(i);
            if (!filter.matches(r.pkg)) continue;
            long fToken = proto.start(fieldId);
            proto.write(0x10900000001L, r.pkg);
            proto.write(1120986464258L, r.uid);
            proto.write(0x11100000003L, r.importance);
            proto.write(1120986464260L, r.priority);
            proto.write(0x11100000005L, r.visibility);
            proto.write(1133871366150L, r.showBadge);
            for (NotificationChannel channel : r.channels.values()) {
                channel.writeToProto(proto, 2246267895815L);
            }
            for (NotificationChannelGroup group : r.groups.values()) {
                group.writeToProto(proto, 2246267895816L);
            }
            proto.end(fToken);
        }
    }

    private static void dumpRecords(PrintWriter pw, String prefix, NotificationManagerService.DumpFilter filter, ArrayMap<String, Record> records) {
        int N = records.size();
        for (int i = 0; i < N; ++i) {
            Record r = records.valueAt(i);
            if (!filter.matches(r.pkg)) continue;
            pw.print(prefix);
            pw.print("  AppSettings: ");
            pw.print(r.pkg);
            pw.print(" (");
            pw.print(r.uid == Record.UNKNOWN_UID ? "UNKNOWN_UID" : Integer.toString(r.uid));
            pw.print(')');
            if (r.importance != -1000) {
                pw.print(" importance=");
                pw.print(NotificationListenerService.Ranking.importanceToString(r.importance));
            }
            if (r.priority != 0) {
                pw.print(" priority=");
                pw.print(Notification.priorityToString(r.priority));
            }
            if (r.visibility != -1000) {
                pw.print(" visibility=");
                pw.print(Notification.visibilityToString(r.visibility));
            }
            pw.print(" showBadge=");
            pw.print(Boolean.toString(r.showBadge));
            pw.println();
            for (NotificationChannel channel : r.channels.values()) {
                pw.print(prefix);
                pw.print("  ");
                pw.print("  ");
                pw.println(channel);
            }
            for (NotificationChannelGroup group : r.groups.values()) {
                pw.print(prefix);
                pw.print("  ");
                pw.print("  ");
                pw.println(group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject dumpJson(NotificationManagerService.DumpFilter filter) {
        JSONObject ranking = new JSONObject();
        JSONArray records = new JSONArray();
        try {
            ranking.put("noUid", this.mRestoredWithoutUids.size());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        ArrayMap<String, Record> arrayMap = this.mRecords;
        synchronized (arrayMap) {
            int N = this.mRecords.size();
            for (int i = 0; i < N; ++i) {
                Record r = this.mRecords.valueAt(i);
                if (filter != null && !filter.matches(r.pkg)) continue;
                JSONObject record = new JSONObject();
                try {
                    record.put("userId", UserHandle.getUserId(r.uid));
                    record.put("packageName", r.pkg);
                    if (r.importance != -1000) {
                        record.put(ATT_IMPORTANCE, NotificationListenerService.Ranking.importanceToString(r.importance));
                    }
                    if (r.priority != 0) {
                        record.put(ATT_PRIORITY, Notification.priorityToString(r.priority));
                    }
                    if (r.visibility != -1000) {
                        record.put(ATT_VISIBILITY, Notification.visibilityToString(r.visibility));
                    }
                    if (!r.showBadge) {
                        record.put("showBadge", (Object)r.showBadge);
                    }
                    JSONArray channels = new JSONArray();
                    for (NotificationChannel channel : r.channels.values()) {
                        channels.put(channel.toJson());
                    }
                    record.put("channels", channels);
                    JSONArray groups = new JSONArray();
                    for (NotificationChannelGroup group : r.groups.values()) {
                        groups.put(group.toJson());
                    }
                    record.put("groups", groups);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                records.put(record);
            }
        }
        try {
            ranking.put("records", records);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return ranking;
    }

    public JSONArray dumpBansJson(NotificationManagerService.DumpFilter filter) {
        JSONArray bans = new JSONArray();
        Map<Integer, String> packageBans = this.getPackageBans();
        for (Map.Entry<Integer, String> ban : packageBans.entrySet()) {
            int userId = UserHandle.getUserId(ban.getKey());
            String packageName = ban.getValue();
            if (filter != null && !filter.matches(packageName)) continue;
            JSONObject banJson = new JSONObject();
            try {
                banJson.put("userId", userId);
                banJson.put("packageName", packageName);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            bans.put(banJson);
        }
        return bans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, String> getPackageBans() {
        ArrayMap<String, Record> arrayMap = this.mRecords;
        synchronized (arrayMap) {
            int N = this.mRecords.size();
            ArrayMap<Integer, String> packageBans = new ArrayMap<Integer, String>(N);
            for (int i = 0; i < N; ++i) {
                Record r = this.mRecords.valueAt(i);
                if (r.importance != 0) continue;
                packageBans.put(r.uid, r.pkg);
            }
            return packageBans;
        }
    }

    public JSONArray dumpChannelsJson(NotificationManagerService.DumpFilter filter) {
        JSONArray channels = new JSONArray();
        Map<String, Integer> packageChannels = this.getPackageChannels();
        for (Map.Entry<String, Integer> channelCount : packageChannels.entrySet()) {
            String packageName = channelCount.getKey();
            if (filter != null && !filter.matches(packageName)) continue;
            JSONObject channelCountJson = new JSONObject();
            try {
                channelCountJson.put("packageName", packageName);
                channelCountJson.put("channelCount", channelCount.getValue());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            channels.put(channelCountJson);
        }
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> getPackageChannels() {
        ArrayMap<String, Integer> packageChannels = new ArrayMap<String, Integer>();
        ArrayMap<String, Record> arrayMap = this.mRecords;
        synchronized (arrayMap) {
            for (int i = 0; i < this.mRecords.size(); ++i) {
                Record r = this.mRecords.valueAt(i);
                int channelCount = 0;
                for (int j = 0; j < r.channels.size(); ++j) {
                    if (r.channels.valueAt(j).isDeleted()) continue;
                    ++channelCount;
                }
                packageChannels.put(r.pkg, channelCount);
            }
        }
        return packageChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserRemoved(int userId) {
        ArrayMap<String, Record> arrayMap = this.mRecords;
        synchronized (arrayMap) {
            int N = this.mRecords.size();
            for (int i = N - 1; i >= 0; --i) {
                Record record = this.mRecords.valueAt(i);
                if (UserHandle.getUserId(record.uid) != userId) continue;
                this.mRecords.removeAt(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLocaleChanged(Context context, int userId) {
        ArrayMap<String, Record> arrayMap = this.mRecords;
        synchronized (arrayMap) {
            int N = this.mRecords.size();
            for (int i = 0; i < N; ++i) {
                Record record = this.mRecords.valueAt(i);
                if (UserHandle.getUserId(record.uid) != userId || !record.channels.containsKey("miscellaneous")) continue;
                record.channels.get("miscellaneous").setName(context.getResources().getString(17039783));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPackagesChanged(boolean removingPackage, int changeUserId, String[] pkgList, int[] uidList) {
        if (pkgList == null || pkgList.length == 0) {
            return;
        }
        boolean updated = false;
        if (removingPackage) {
            int size = Math.min(pkgList.length, uidList.length);
            for (int i = 0; i < size; ++i) {
                String pkg = pkgList[i];
                int uid = uidList[i];
                ArrayMap<String, Record> arrayMap = this.mRecords;
                synchronized (arrayMap) {
                    this.mRecords.remove(RankingHelper.recordKey(pkg, uid));
                }
                this.mRestoredWithoutUids.remove(pkg);
                updated = true;
            }
        } else {
            for (String pkg : pkgList) {
                Record r = this.mRestoredWithoutUids.get(pkg);
                if (r != null) {
                    try {
                        r.uid = this.mPm.getPackageUidAsUser(r.pkg, changeUserId);
                        this.mRestoredWithoutUids.remove(pkg);
                        ArrayMap<String, Record> arrayMap = this.mRecords;
                        synchronized (arrayMap) {
                            this.mRecords.put(RankingHelper.recordKey(r.pkg, r.uid), r);
                        }
                        updated = true;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
                try {
                    Record fullRecord = this.getRecord(pkg, this.mPm.getPackageUidAsUser(pkg, changeUserId));
                    if (fullRecord == null) continue;
                    this.createDefaultChannelIfNeeded(fullRecord);
                    this.deleteDefaultChannelIfNeeded(fullRecord);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (updated) {
            this.updateConfig();
        }
    }

    private LogMaker getChannelLog(NotificationChannel channel, String pkg) {
        return new LogMaker(856).setType(6).setPackageName(pkg).addTaggedData(857, channel.getId()).addTaggedData(858, channel.getImportance());
    }

    private LogMaker getChannelGroupLog(String groupId, String pkg) {
        return new LogMaker(859).setType(6).addTaggedData(860, groupId).setPackageName(pkg);
    }

    public void updateBadgingEnabled() {
        if (this.mBadgingEnabled == null) {
            this.mBadgingEnabled = new SparseBooleanArray();
        }
        boolean changed = false;
        for (int index = 0; index < this.mBadgingEnabled.size(); ++index) {
            int userId = this.mBadgingEnabled.keyAt(index);
            boolean oldValue = this.mBadgingEnabled.get(userId);
            boolean newValue = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "notification_badging", 1, userId) != 0;
            this.mBadgingEnabled.put(userId, newValue);
            changed |= oldValue != newValue;
        }
        if (changed) {
            this.updateConfig();
        }
    }

    @Override
    public boolean badgingEnabled(UserHandle userHandle) {
        int userId = userHandle.getIdentifier();
        if (userId == -1) {
            return false;
        }
        if (this.mBadgingEnabled.indexOfKey(userId) < 0) {
            this.mBadgingEnabled.put(userId, Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "notification_badging", 1, userId) != 0);
        }
        return this.mBadgingEnabled.get(userId, true);
    }

    private static class Record {
        static int UNKNOWN_UID = -10000;
        String pkg;
        int uid = UNKNOWN_UID;
        int importance = -1000;
        int priority = 0;
        int visibility = -1000;
        boolean showBadge = true;
        int lockedAppFields = 0;
        ArrayMap<String, NotificationChannel> channels = new ArrayMap();
        Map<String, NotificationChannelGroup> groups = new ConcurrentHashMap<String, NotificationChannelGroup>();

        private Record() {
        }
    }

    public static @interface LockableAppFields {
        public static final int USER_LOCKED_IMPORTANCE = 1;
    }
}

