/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.AuxiliaryResolveInfo;
import android.content.pm.InstantAppIntentFilter;
import android.content.pm.InstantAppRequest;
import android.content.pm.InstantAppResolveInfo;
import android.metrics.LogMaker;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.android.server.pm.InstantAppResolverConnection;
import com.android.server.pm.PackageManagerService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public abstract class InstantAppResolver {
    private static final boolean DEBUG_INSTANT = Build.IS_DEBUGGABLE;
    private static final String TAG = "PackageManager";
    private static final int RESOLUTION_SUCCESS = 0;
    private static final int RESOLUTION_FAILURE = 1;
    private static final int RESOLUTION_BIND_TIMEOUT = 2;
    private static final int RESOLUTION_CALL_TIMEOUT = 3;
    private static MetricsLogger sMetricsLogger;

    private static MetricsLogger getLogger() {
        if (sMetricsLogger == null) {
            sMetricsLogger = new MetricsLogger();
        }
        return sMetricsLogger;
    }

    public static Intent sanitizeIntent(Intent origIntent) {
        Intent sanitizedIntent = new Intent(origIntent.getAction());
        Set<String> categories = origIntent.getCategories();
        if (categories != null) {
            for (String category : categories) {
                sanitizedIntent.addCategory(category);
            }
        }
        Uri sanitizedUri = origIntent.getData() == null ? null : Uri.fromParts(origIntent.getScheme(), "", "");
        sanitizedIntent.setDataAndType(sanitizedUri, origIntent.getType());
        sanitizedIntent.addFlags(origIntent.getFlags());
        sanitizedIntent.setPackage(origIntent.getPackage());
        return sanitizedIntent;
    }

    public static AuxiliaryResolveInfo doInstantAppResolutionPhaseOne(InstantAppResolverConnection connection, InstantAppRequest requestObj) {
        long startTime = System.currentTimeMillis();
        String token = UUID.randomUUID().toString();
        if (DEBUG_INSTANT) {
            Log.d(TAG, "[" + token + "] Phase1; resolving");
        }
        Intent origIntent = requestObj.origIntent;
        Intent sanitizedIntent = InstantAppResolver.sanitizeIntent(origIntent);
        AuxiliaryResolveInfo resolveInfo = null;
        int resolutionStatus = 0;
        try {
            List<InstantAppResolveInfo> instantAppResolveInfoList = connection.getInstantAppResolveInfoList(sanitizedIntent, requestObj.digest.getDigestPrefixSecure(), token);
            if (instantAppResolveInfoList != null && instantAppResolveInfoList.size() > 0) {
                resolveInfo = InstantAppResolver.filterInstantAppIntent(instantAppResolveInfoList, origIntent, requestObj.resolvedType, requestObj.userId, origIntent.getPackage(), requestObj.digest, token);
            }
        }
        catch (InstantAppResolverConnection.ConnectionException e) {
            resolutionStatus = e.failure == 1 ? 2 : (e.failure == 2 ? 3 : 1);
        }
        if (requestObj.resolveForStart && resolutionStatus == 0) {
            InstantAppResolver.logMetrics(899, startTime, token, resolutionStatus);
        }
        if (DEBUG_INSTANT && resolveInfo == null) {
            if (resolutionStatus == 2) {
                Log.d(TAG, "[" + token + "] Phase1; bind timed out");
            } else if (resolutionStatus == 3) {
                Log.d(TAG, "[" + token + "] Phase1; call timed out");
            } else if (resolutionStatus != 0) {
                Log.d(TAG, "[" + token + "] Phase1; service connection error");
            } else {
                Log.d(TAG, "[" + token + "] Phase1; No results matched");
            }
        }
        if (resolveInfo == null && (origIntent.getFlags() & 0x800) != 0) {
            return new AuxiliaryResolveInfo(token, false, InstantAppResolver.createFailureIntent(origIntent, token), null);
        }
        return resolveInfo;
    }

    public static void doInstantAppResolutionPhaseTwo(final Context context, InstantAppResolverConnection connection, final InstantAppRequest requestObj, final ActivityInfo instantAppInstaller, Handler callbackHandler) {
        block5: {
            long startTime = System.currentTimeMillis();
            final String token = requestObj.responseObj.token;
            if (DEBUG_INSTANT) {
                Log.d(TAG, "[" + token + "] Phase2; resolving");
            }
            final Intent origIntent = requestObj.origIntent;
            final Intent sanitizedIntent = InstantAppResolver.sanitizeIntent(origIntent);
            InstantAppResolverConnection.PhaseTwoCallback callback = new InstantAppResolverConnection.PhaseTwoCallback(){

                @Override
                void onPhaseTwoResolved(List<InstantAppResolveInfo> instantAppResolveInfoList, long startTime) {
                    AuxiliaryResolveInfo instantAppIntentInfo;
                    Intent failureIntent = instantAppResolveInfoList != null && instantAppResolveInfoList.size() > 0 ? ((instantAppIntentInfo = InstantAppResolver.filterInstantAppIntent(instantAppResolveInfoList, origIntent, null, 0, origIntent.getPackage(), requestObj.digest, token)) != null ? instantAppIntentInfo.failureIntent : null) : null;
                    Intent installerIntent = InstantAppResolver.buildEphemeralInstallerIntent(requestObj.origIntent, sanitizedIntent, failureIntent, requestObj.callingPackage, requestObj.verificationBundle, requestObj.resolvedType, requestObj.userId, requestObj.responseObj.installFailureActivity, token, false, requestObj.responseObj.filters);
                    installerIntent.setComponent(new ComponentName(instantAppInstaller.packageName, instantAppInstaller.name));
                    InstantAppResolver.logMetrics(900, startTime, token, requestObj.responseObj.filters != null ? 0 : 1);
                    context.startActivity(installerIntent);
                }
            };
            try {
                connection.getInstantAppIntentFilterList(sanitizedIntent, requestObj.digest.getDigestPrefixSecure(), token, callback, callbackHandler, startTime);
            }
            catch (InstantAppResolverConnection.ConnectionException e) {
                int resolutionStatus = 1;
                if (e.failure == 1) {
                    resolutionStatus = 2;
                }
                InstantAppResolver.logMetrics(900, startTime, token, resolutionStatus);
                if (!DEBUG_INSTANT) break block5;
                if (resolutionStatus == 2) {
                    Log.d(TAG, "[" + token + "] Phase2; bind timed out");
                }
                Log.d(TAG, "[" + token + "] Phase2; service connection error");
            }
        }
    }

    public static Intent buildEphemeralInstallerIntent(Intent origIntent, Intent sanitizedIntent, Intent failureIntent, String callingPackage, Bundle verificationBundle, String resolvedType, int userId, ComponentName installFailureActivity, String token, boolean needsPhaseTwo, List<AuxiliaryResolveInfo.AuxiliaryFilter> filters) {
        int flags = origIntent.getFlags();
        Intent intent = new Intent();
        intent.setFlags(flags | 0x40000000 | 0x800000);
        if (token != null) {
            intent.putExtra("android.intent.extra.EPHEMERAL_TOKEN", token);
            intent.putExtra("android.intent.extra.INSTANT_APP_TOKEN", token);
        }
        if (origIntent.getData() != null) {
            intent.putExtra("android.intent.extra.EPHEMERAL_HOSTNAME", origIntent.getData().getHost());
            intent.putExtra("android.intent.extra.INSTANT_APP_HOSTNAME", origIntent.getData().getHost());
        }
        intent.putExtra("android.intent.extra.INSTANT_APP_ACTION", origIntent.getAction());
        intent.putExtra("android.intent.extra.INTENT", sanitizedIntent);
        if (needsPhaseTwo) {
            intent.setAction("android.intent.action.RESOLVE_INSTANT_APP_PACKAGE");
        } else {
            if (failureIntent != null || installFailureActivity != null) {
                try {
                    Intent onFailureIntent;
                    if (installFailureActivity != null) {
                        onFailureIntent = new Intent();
                        onFailureIntent.setComponent(installFailureActivity);
                        if (filters != null && filters.size() == 1) {
                            onFailureIntent.putExtra("android.intent.extra.SPLIT_NAME", filters.get((int)0).splitName);
                        }
                        onFailureIntent.putExtra("android.intent.extra.INTENT", origIntent);
                    } else {
                        onFailureIntent = failureIntent;
                    }
                    IIntentSender failureIntentTarget = ActivityManager.getService().getIntentSender(2, callingPackage, null, null, 1, new Intent[]{onFailureIntent}, new String[]{resolvedType}, 0x54000000, null, userId);
                    IntentSender failureSender = new IntentSender(failureIntentTarget);
                    intent.putExtra("android.intent.extra.EPHEMERAL_FAILURE", failureSender);
                    intent.putExtra("android.intent.extra.INSTANT_APP_FAILURE", failureSender);
                }
                catch (RemoteException onFailureIntent) {
                    // empty catch block
                }
            }
            Intent successIntent = new Intent(origIntent);
            successIntent.setLaunchToken(token);
            try {
                IIntentSender successIntentTarget = ActivityManager.getService().getIntentSender(2, callingPackage, null, null, 0, new Intent[]{successIntent}, new String[]{resolvedType}, 0x54000000, null, userId);
                IntentSender successSender = new IntentSender(successIntentTarget);
                intent.putExtra("android.intent.extra.EPHEMERAL_SUCCESS", successSender);
                intent.putExtra("android.intent.extra.INSTANT_APP_SUCCESS", successSender);
            }
            catch (RemoteException successIntentTarget) {
                // empty catch block
            }
            if (verificationBundle != null) {
                intent.putExtra("android.intent.extra.VERIFICATION_BUNDLE", verificationBundle);
            }
            intent.putExtra("android.intent.extra.CALLING_PACKAGE", callingPackage);
            if (filters != null) {
                Parcelable[] resolvableFilters = new Bundle[filters.size()];
                int max = filters.size();
                for (int i = 0; i < max; ++i) {
                    Bundle resolvableFilter = new Bundle();
                    AuxiliaryResolveInfo.AuxiliaryFilter filter = filters.get(i);
                    resolvableFilter.putBoolean("android.intent.extra.UNKNOWN_INSTANT_APP", filter.resolveInfo != null && filter.resolveInfo.shouldLetInstallerDecide());
                    resolvableFilter.putString("android.intent.extra.PACKAGE_NAME", filter.packageName);
                    resolvableFilter.putString("android.intent.extra.SPLIT_NAME", filter.splitName);
                    resolvableFilter.putLong("android.intent.extra.LONG_VERSION_CODE", filter.versionCode);
                    resolvableFilter.putBundle("android.intent.extra.INSTANT_APP_EXTRAS", filter.extras);
                    resolvableFilters[i] = resolvableFilter;
                    if (i != 0) continue;
                    intent.putExtras(resolvableFilter);
                    intent.putExtra("android.intent.extra.VERSION_CODE", (int)filter.versionCode);
                }
                intent.putExtra("android.intent.extra.INSTANT_APP_BUNDLES", resolvableFilters);
            }
            intent.setAction("android.intent.action.INSTALL_INSTANT_APP_PACKAGE");
        }
        return intent;
    }

    private static AuxiliaryResolveInfo filterInstantAppIntent(List<InstantAppResolveInfo> instantAppResolveInfoList, Intent origIntent, String resolvedType, int userId, String packageName, InstantAppResolveInfo.InstantAppDigest digest, String token) {
        int[] shaPrefix = digest.getDigestPrefix();
        byte[][] digestBytes = digest.getDigestBytes();
        boolean requiresSecondPhase = false;
        ArrayList<AuxiliaryResolveInfo.AuxiliaryFilter> filters = null;
        boolean requiresPrefixMatch = origIntent.isWebIntent() || shaPrefix.length > 0 && (origIntent.getFlags() & 0x800) == 0;
        for (InstantAppResolveInfo instantAppResolveInfo : instantAppResolveInfoList) {
            List<AuxiliaryResolveInfo.AuxiliaryFilter> matchFilters;
            if (requiresPrefixMatch && instantAppResolveInfo.shouldLetInstallerDecide()) {
                Slog.d(TAG, "InstantAppResolveInfo with mShouldLetInstallerDecide=true when digest required; ignoring");
                continue;
            }
            byte[] filterDigestBytes = instantAppResolveInfo.getDigestBytes();
            if (shaPrefix.length > 0 && (requiresPrefixMatch || filterDigestBytes.length > 0)) {
                boolean matchFound = false;
                for (int i = shaPrefix.length - 1; i >= 0; --i) {
                    if (!Arrays.equals(digestBytes[i], filterDigestBytes)) continue;
                    matchFound = true;
                    break;
                }
                if (!matchFound) continue;
            }
            if ((matchFilters = InstantAppResolver.computeResolveFilters(origIntent, resolvedType, userId, packageName, token, instantAppResolveInfo)) == null) continue;
            if (matchFilters.isEmpty()) {
                requiresSecondPhase = true;
            }
            if (filters == null) {
                filters = new ArrayList<AuxiliaryResolveInfo.AuxiliaryFilter>(matchFilters);
                continue;
            }
            filters.addAll(matchFilters);
        }
        if (filters != null && !filters.isEmpty()) {
            return new AuxiliaryResolveInfo(token, requiresSecondPhase, InstantAppResolver.createFailureIntent(origIntent, token), (List<AuxiliaryResolveInfo.AuxiliaryFilter>)filters);
        }
        return null;
    }

    private static Intent createFailureIntent(Intent origIntent, String token) {
        Intent failureIntent = new Intent(origIntent);
        failureIntent.setFlags(failureIntent.getFlags() | 0x200);
        failureIntent.setFlags(failureIntent.getFlags() & 0xFFFFF7FF);
        failureIntent.setLaunchToken(token);
        return failureIntent;
    }

    private static List<AuxiliaryResolveInfo.AuxiliaryFilter> computeResolveFilters(Intent origIntent, String resolvedType, int userId, String packageName, String token, InstantAppResolveInfo instantAppInfo) {
        if (instantAppInfo.shouldLetInstallerDecide()) {
            return Collections.singletonList(new AuxiliaryResolveInfo.AuxiliaryFilter(instantAppInfo, null, instantAppInfo.getExtras()));
        }
        if (packageName != null && !packageName.equals(instantAppInfo.getPackageName())) {
            return null;
        }
        List<InstantAppIntentFilter> instantAppFilters = instantAppInfo.getIntentFilters();
        if (instantAppFilters == null || instantAppFilters.isEmpty()) {
            if (origIntent.isWebIntent()) {
                return null;
            }
            if (DEBUG_INSTANT) {
                Log.d(TAG, "No app filters; go to phase 2");
            }
            return Collections.emptyList();
        }
        PackageManagerService.InstantAppIntentResolver instantAppResolver = new PackageManagerService.InstantAppIntentResolver();
        for (int j = instantAppFilters.size() - 1; j >= 0; --j) {
            InstantAppIntentFilter instantAppFilter = instantAppFilters.get(j);
            List<IntentFilter> splitFilters = instantAppFilter.getFilters();
            if (splitFilters == null || splitFilters.isEmpty()) continue;
            for (int k = splitFilters.size() - 1; k >= 0; --k) {
                IntentFilter filter = splitFilters.get(k);
                Iterator<IntentFilter.AuthorityEntry> authorities = filter.authoritiesIterator();
                if (!(authorities != null && authorities.hasNext() || !filter.hasDataScheme("http") && !filter.hasDataScheme("https") || !filter.hasAction("android.intent.action.VIEW") || !filter.hasCategory("android.intent.category.BROWSABLE"))) continue;
                instantAppResolver.addFilter(new AuxiliaryResolveInfo.AuxiliaryFilter(filter, instantAppInfo, instantAppFilter.getSplitName(), instantAppInfo.getExtras()));
            }
        }
        List<AuxiliaryResolveInfo.AuxiliaryFilter> matchedResolveInfoList = instantAppResolver.queryIntent(origIntent, resolvedType, false, userId);
        if (!matchedResolveInfoList.isEmpty()) {
            if (DEBUG_INSTANT) {
                Log.d(TAG, "[" + token + "] Found match(es); " + matchedResolveInfoList);
            }
            return matchedResolveInfoList;
        }
        if (DEBUG_INSTANT) {
            Log.d(TAG, "[" + token + "] No matches found package: " + instantAppInfo.getPackageName() + ", versionCode: " + instantAppInfo.getVersionCode());
        }
        return null;
    }

    private static void logMetrics(int action, long startTime, String token, int status) {
        LogMaker logMaker = new LogMaker(action).setType(4).addTaggedData(901, new Long(System.currentTimeMillis() - startTime)).addTaggedData(903, token).addTaggedData(902, new Integer(status));
        InstantAppResolver.getLogger().write(logMaker);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResolutionStatus {
    }
}

