/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PackageDeleteObserver;
import android.app.PackageInstallObserver;
import android.app.admin.DevicePolicyManagerInternal;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageInstaller;
import android.content.pm.IPackageInstallerCallback;
import android.content.pm.IPackageInstallerSession;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.VersionedPackage;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.system.ErrnoException;
import android.system.Os;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.ExceptionUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageHelper;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.ImageUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.pm.PackageInstallerSession;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.permission.PermissionManagerInternal;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PackageInstallerService
extends IPackageInstaller.Stub {
    private static final String TAG = "PackageInstaller";
    private static final boolean LOGD = false;
    private static final String TAG_SESSIONS = "sessions";
    private static final long MAX_AGE_MILLIS = 259200000L;
    private static final long MAX_ACTIVE_SESSIONS = 1024L;
    private static final long MAX_HISTORICAL_SESSIONS = 0x100000L;
    private final Context mContext;
    private final PackageManagerService mPm;
    private final PermissionManagerInternal mPermissionManager;
    private AppOpsManager mAppOps;
    private final HandlerThread mInstallThread;
    private final Handler mInstallHandler;
    private final Callbacks mCallbacks;
    private final AtomicFile mSessionsFile;
    private final File mSessionsDir;
    private final InternalCallback mInternalCallback = new InternalCallback();
    private final Random mRandom = new SecureRandom();
    @GuardedBy(value="mSessions")
    private final SparseBooleanArray mAllocatedSessions = new SparseBooleanArray();
    @GuardedBy(value="mSessions")
    private final SparseArray<PackageInstallerSession> mSessions = new SparseArray();
    @GuardedBy(value="mSessions")
    private final List<String> mHistoricalSessions = new ArrayList<String>();
    @GuardedBy(value="mSessions")
    private final SparseIntArray mHistoricalSessionsByInstaller = new SparseIntArray();
    @GuardedBy(value="mSessions")
    private final SparseBooleanArray mLegacySessions = new SparseBooleanArray();
    private static final FilenameFilter sStageFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return PackageInstallerService.isStageName(name);
        }
    };

    public PackageInstallerService(Context context, PackageManagerService pm) {
        this.mContext = context;
        this.mPm = pm;
        this.mPermissionManager = LocalServices.getService(PermissionManagerInternal.class);
        this.mInstallThread = new HandlerThread(TAG);
        this.mInstallThread.start();
        this.mInstallHandler = new Handler(this.mInstallThread.getLooper());
        this.mCallbacks = new Callbacks(this.mInstallThread.getLooper());
        this.mSessionsFile = new AtomicFile(new File(Environment.getDataSystemDirectory(), "install_sessions.xml"), "package-session");
        this.mSessionsDir = new File(Environment.getDataSystemDirectory(), "install_sessions");
        this.mSessionsDir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        this.mAppOps = this.mContext.getSystemService(AppOpsManager.class);
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            this.readSessionsLocked();
            this.reconcileStagesLocked(StorageManager.UUID_PRIVATE_INTERNAL, false);
            this.reconcileStagesLocked(StorageManager.UUID_PRIVATE_INTERNAL, true);
            ArraySet<File> unclaimedIcons = PackageInstallerService.newArraySet(this.mSessionsDir.listFiles());
            for (int i = 0; i < this.mSessions.size(); ++i) {
                PackageInstallerSession session = this.mSessions.valueAt(i);
                unclaimedIcons.remove(this.buildAppIconFile(session.sessionId));
            }
            for (File icon : unclaimedIcons) {
                Slog.w(TAG, "Deleting orphan icon " + icon);
                icon.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mSessions")
    private void reconcileStagesLocked(String volumeUuid, boolean isEphemeral) {
        File stagingDir = this.buildStagingDir(volumeUuid, isEphemeral);
        ArraySet<File> unclaimedStages = PackageInstallerService.newArraySet(stagingDir.listFiles(sStageFilter));
        for (int i = 0; i < this.mSessions.size(); ++i) {
            PackageInstallerSession session = this.mSessions.valueAt(i);
            unclaimedStages.remove(session.stageDir);
        }
        for (File stage : unclaimedStages) {
            Slog.w(TAG, "Deleting orphan stage " + stage);
            Object object = this.mPm.mInstallLock;
            synchronized (object) {
                this.mPm.removeCodePathLI(stage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPrivateVolumeMounted(String volumeUuid) {
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            this.reconcileStagesLocked(volumeUuid, false);
        }
    }

    public static boolean isStageName(String name) {
        boolean isFile = name.startsWith("vmdl") && name.endsWith(".tmp");
        boolean isContainer = name.startsWith("smdl") && name.endsWith(".tmp");
        boolean isLegacyContainer = name.startsWith("smdl2tmp");
        return isFile || isContainer || isLegacyContainer;
    }

    @Deprecated
    public File allocateStageDirLegacy(String volumeUuid, boolean isEphemeral) throws IOException {
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            try {
                int sessionId = this.allocateSessionIdLocked();
                this.mLegacySessions.put(sessionId, true);
                File stageDir = this.buildStageDir(volumeUuid, sessionId, isEphemeral);
                PackageInstallerService.prepareStageDir(stageDir);
                return stageDir;
            }
            catch (IllegalStateException e) {
                throw new IOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String allocateExternalStageCidLegacy() {
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            int sessionId = this.allocateSessionIdLocked();
            this.mLegacySessions.put(sessionId, true);
            return "smdl" + sessionId + ".tmp";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mSessions")
    private void readSessionsLocked() {
        this.mSessions.clear();
        FileInputStream fis = null;
        try {
            int type;
            fis = this.mSessionsFile.openRead();
            XmlPullParser in = Xml.newPullParser();
            in.setInput(fis, StandardCharsets.UTF_8.name());
            while ((type = in.next()) != 1) {
                boolean valid;
                PackageInstallerSession session;
                String tag;
                if (type != 2 || !"session".equals(tag = in.getName())) continue;
                try {
                    session = PackageInstallerSession.readFromXml(in, this.mInternalCallback, this.mContext, this.mPm, this.mInstallThread.getLooper(), this.mSessionsDir);
                }
                catch (Exception e) {
                    Slog.e(TAG, "Could not read session", e);
                    continue;
                }
                long age = System.currentTimeMillis() - session.createdMillis;
                if (age >= 259200000L) {
                    Slog.w(TAG, "Abandoning old session first created at " + session.createdMillis);
                    valid = false;
                } else {
                    valid = true;
                }
                if (valid) {
                    this.mSessions.put(session.sessionId, session);
                } else {
                    this.addHistoricalSessionLocked(session);
                }
                this.mAllocatedSessions.put(session.sessionId, true);
            }
        }
        catch (FileNotFoundException in) {
        }
        catch (IOException | XmlPullParserException e) {
            Slog.wtf(TAG, "Failed reading install sessions", e);
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
    }

    @GuardedBy(value="mSessions")
    private void addHistoricalSessionLocked(PackageInstallerSession session) {
        CharArrayWriter writer = new CharArrayWriter();
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "    ");
        session.dump(pw);
        this.mHistoricalSessions.add(writer.toString());
        int installerUid = session.getInstallerUid();
        this.mHistoricalSessionsByInstaller.put(installerUid, this.mHistoricalSessionsByInstaller.get(installerUid) + 1);
    }

    @GuardedBy(value="mSessions")
    private void writeSessionsLocked() {
        block3: {
            FileOutputStream fos = null;
            try {
                fos = this.mSessionsFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, TAG_SESSIONS);
                int size = this.mSessions.size();
                for (int i = 0; i < size; ++i) {
                    PackageInstallerSession session = this.mSessions.valueAt(i);
                    session.write(out, this.mSessionsDir);
                }
                out.endTag(null, TAG_SESSIONS);
                out.endDocument();
                this.mSessionsFile.finishWrite(fos);
            }
            catch (IOException e) {
                if (fos == null) break block3;
                this.mSessionsFile.failWrite(fos);
            }
        }
    }

    private File buildAppIconFile(int sessionId) {
        return new File(this.mSessionsDir, "app_icon." + sessionId + ".png");
    }

    private void writeSessionsAsync() {
        IoThread.getHandler().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SparseArray sparseArray = PackageInstallerService.this.mSessions;
                synchronized (sparseArray) {
                    PackageInstallerService.this.writeSessionsLocked();
                }
            }
        });
    }

    @Override
    public int createSession(PackageInstaller.SessionParams params, String installerPackageName, int userId) {
        try {
            return this.createSessionInternal(params, installerPackageName, userId);
        }
        catch (IOException e) {
            throw ExceptionUtils.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createSessionInternal(PackageInstaller.SessionParams params, String installerPackageName, int userId) throws IOException {
        int sessionId;
        int callingUid = Binder.getCallingUid();
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, true, "createSession");
        if (this.mPm.isUserRestricted(userId, "no_install_apps")) {
            throw new SecurityException("User restriction prevents installing");
        }
        if (callingUid == 2000 || callingUid == 0) {
            params.installFlags |= 0x20;
        } else {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.INSTALL_PACKAGES") != 0) {
                this.mAppOps.checkPackage(callingUid, installerPackageName);
            }
            params.installFlags &= 0xFFFFFFDF;
            params.installFlags &= 0xFFFFFFBF;
            params.installFlags |= 2;
            if ((params.installFlags & 0x10000) != 0 && !this.mPm.isCallerVerifier(callingUid)) {
                params.installFlags &= 0xFFFEFFFF;
            }
        }
        if ((params.installFlags & 0x100) != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.INSTALL_GRANT_RUNTIME_PERMISSIONS") == -1) {
            throw new SecurityException("You need the android.permission.INSTALL_GRANT_RUNTIME_PERMISSIONS permission to use the PackageManager.INSTALL_GRANT_RUNTIME_PERMISSIONS flag");
        }
        if ((params.installFlags & 1) != 0 || (params.installFlags & 8) != 0) {
            throw new IllegalArgumentException("New installs into ASEC containers no longer supported");
        }
        if (params.appIcon != null) {
            ActivityManager am = (ActivityManager)this.mContext.getSystemService("activity");
            int iconSize = am.getLauncherLargeIconSize();
            if (params.appIcon.getWidth() > iconSize * 2 || params.appIcon.getHeight() > iconSize * 2) {
                params.appIcon = Bitmap.createScaledBitmap(params.appIcon, iconSize, iconSize, true);
            }
        }
        switch (params.mode) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid install mode: " + params.mode);
            }
        }
        if ((params.installFlags & 0x10) != 0) {
            if (!PackageHelper.fitsOnInternal(this.mContext, params)) {
                throw new IOException("No suitable internal storage available");
            }
        } else if ((params.installFlags & 8) != 0) {
            if (!PackageHelper.fitsOnExternal(this.mContext, params)) {
                throw new IOException("No suitable external storage available");
            }
        } else if ((params.installFlags & 0x200) != 0) {
            params.setInstallFlagsInternal();
        } else {
            params.setInstallFlagsInternal();
            long ident = Binder.clearCallingIdentity();
            try {
                params.volumeUuid = PackageHelper.resolveInstallVolume(this.mContext, params);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            int activeCount = PackageInstallerService.getSessionCount(this.mSessions, callingUid);
            if ((long)activeCount >= 1024L) {
                throw new IllegalStateException("Too many active sessions for UID " + callingUid);
            }
            int historicalCount = this.mHistoricalSessionsByInstaller.get(callingUid);
            if ((long)historicalCount >= 0x100000L) {
                throw new IllegalStateException("Too many historical sessions for UID " + callingUid);
            }
            sessionId = this.allocateSessionIdLocked();
        }
        long createdMillis = System.currentTimeMillis();
        File stageDir = null;
        String stageCid = null;
        if ((params.installFlags & 0x10) != 0) {
            boolean isInstant = (params.installFlags & 0x800) != 0;
            stageDir = this.buildStageDir(params.volumeUuid, sessionId, isInstant);
        } else {
            stageCid = this.buildExternalStageCid(sessionId);
        }
        PackageInstallerSession session = new PackageInstallerSession(this.mInternalCallback, this.mContext, this.mPm, this.mInstallThread.getLooper(), sessionId, userId, installerPackageName, callingUid, params, createdMillis, stageDir, stageCid, false, false);
        SparseArray<PackageInstallerSession> sparseArray2 = this.mSessions;
        synchronized (sparseArray2) {
            this.mSessions.put(sessionId, session);
        }
        this.mCallbacks.notifySessionCreated(session.sessionId, session.userId);
        this.writeSessionsAsync();
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSessionAppIcon(int sessionId, Bitmap appIcon) {
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            PackageInstallerSession session = this.mSessions.get(sessionId);
            if (session == null || !this.isCallingUidOwner(session)) {
                throw new SecurityException("Caller has no access to session " + sessionId);
            }
            if (appIcon != null) {
                ActivityManager am = (ActivityManager)this.mContext.getSystemService("activity");
                int iconSize = am.getLauncherLargeIconSize();
                if (appIcon.getWidth() > iconSize * 2 || appIcon.getHeight() > iconSize * 2) {
                    appIcon = Bitmap.createScaledBitmap(appIcon, iconSize, iconSize, true);
                }
            }
            session.params.appIcon = appIcon;
            session.params.appIconLastModified = -1L;
            this.mInternalCallback.onSessionBadgingChanged(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSessionAppLabel(int sessionId, String appLabel) {
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            PackageInstallerSession session = this.mSessions.get(sessionId);
            if (session == null || !this.isCallingUidOwner(session)) {
                throw new SecurityException("Caller has no access to session " + sessionId);
            }
            session.params.appLabel = appLabel;
            this.mInternalCallback.onSessionBadgingChanged(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abandonSession(int sessionId) {
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            PackageInstallerSession session = this.mSessions.get(sessionId);
            if (session == null || !this.isCallingUidOwner(session)) {
                throw new SecurityException("Caller has no access to session " + sessionId);
            }
            session.abandon();
        }
    }

    @Override
    public IPackageInstallerSession openSession(int sessionId) {
        try {
            return this.openSessionInternal(sessionId);
        }
        catch (IOException e) {
            throw ExceptionUtils.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPackageInstallerSession openSessionInternal(int sessionId) throws IOException {
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            PackageInstallerSession session = this.mSessions.get(sessionId);
            if (session == null || !this.isCallingUidOwner(session)) {
                throw new SecurityException("Caller has no access to session " + sessionId);
            }
            session.open();
            return session;
        }
    }

    @GuardedBy(value="mSessions")
    private int allocateSessionIdLocked() {
        int n = 0;
        do {
            int sessionId;
            if (this.mAllocatedSessions.get(sessionId = this.mRandom.nextInt(0x7FFFFFFE) + 1, false)) continue;
            this.mAllocatedSessions.put(sessionId, true);
            return sessionId;
        } while (n++ < 32);
        throw new IllegalStateException("Failed to allocate session ID");
    }

    private File buildStagingDir(String volumeUuid, boolean isEphemeral) {
        return Environment.getDataAppDirectory(volumeUuid);
    }

    private File buildStageDir(String volumeUuid, int sessionId, boolean isEphemeral) {
        File stagingDir = this.buildStagingDir(volumeUuid, isEphemeral);
        return new File(stagingDir, "vmdl" + sessionId + ".tmp");
    }

    static void prepareStageDir(File stageDir) throws IOException {
        if (stageDir.exists()) {
            throw new IOException("Session dir already exists: " + stageDir);
        }
        try {
            Os.mkdir(stageDir.getAbsolutePath(), 493);
            Os.chmod(stageDir.getAbsolutePath(), 493);
        }
        catch (ErrnoException e) {
            throw new IOException("Failed to prepare session dir: " + stageDir, e);
        }
        if (!SELinux.restorecon(stageDir)) {
            throw new IOException("Failed to restorecon session dir: " + stageDir);
        }
    }

    private String buildExternalStageCid(int sessionId) {
        return "smdl" + sessionId + ".tmp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageInstaller.SessionInfo getSessionInfo(int sessionId) {
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            PackageInstallerSession session = this.mSessions.get(sessionId);
            return session != null ? session.generateInfo() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PackageInstaller.SessionInfo> getAllSessions(int userId) {
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getAllSessions");
        ArrayList<PackageInstaller.SessionInfo> result = new ArrayList<PackageInstaller.SessionInfo>();
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mSessions.size(); ++i) {
                PackageInstallerSession session = this.mSessions.valueAt(i);
                if (session.userId != userId) continue;
                result.add(session.generateInfo(false));
            }
        }
        return new ParceledListSlice<PackageInstaller.SessionInfo>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PackageInstaller.SessionInfo> getMySessions(String installerPackageName, int userId) {
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getMySessions");
        this.mAppOps.checkPackage(Binder.getCallingUid(), installerPackageName);
        ArrayList<PackageInstaller.SessionInfo> result = new ArrayList<PackageInstaller.SessionInfo>();
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mSessions.size(); ++i) {
                PackageInstallerSession session = this.mSessions.valueAt(i);
                PackageInstaller.SessionInfo info = session.generateInfo(false);
                if (!Objects.equals(info.getInstallerPackageName(), installerPackageName) || session.userId != userId) continue;
                result.add(info);
            }
        }
        return new ParceledListSlice<PackageInstaller.SessionInfo>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall(VersionedPackage versionedPackage, String callerPackageName, int flags, IntentSender statusReceiver, int userId) throws RemoteException {
        int callingUid = Binder.getCallingUid();
        this.mPermissionManager.enforceCrossUserPermission(callingUid, userId, true, true, "uninstall");
        if (callingUid != 2000 && callingUid != 0) {
            this.mAppOps.checkPackage(callingUid, callerPackageName);
        }
        int callingUserId = UserHandle.getUserId(callingUid);
        DevicePolicyManagerInternal dpmi = LocalServices.getService(DevicePolicyManagerInternal.class);
        boolean isDeviceOwnerOrAffiliatedProfileOwner = dpmi != null && dpmi.isActiveAdminWithPolicy(callingUid, -1) && dpmi.isUserAffiliatedWithDevice(callingUserId);
        PackageDeleteObserverAdapter adapter = new PackageDeleteObserverAdapter(this.mContext, statusReceiver, versionedPackage.getPackageName(), isDeviceOwnerOrAffiliatedProfileOwner, userId);
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DELETE_PACKAGES") == 0) {
            this.mPm.deletePackageVersioned(versionedPackage, adapter.getBinder(), userId, flags);
        } else if (isDeviceOwnerOrAffiliatedProfileOwner) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mPm.deletePackageVersioned(versionedPackage, adapter.getBinder(), userId, flags);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        } else {
            ApplicationInfo appInfo = this.mPm.getApplicationInfo(callerPackageName, 0, userId);
            if (appInfo.targetSdkVersion >= 28) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.REQUEST_DELETE_PACKAGES", null);
            }
            Intent intent = new Intent("android.intent.action.UNINSTALL_PACKAGE");
            intent.setData(Uri.fromParts("package", versionedPackage.getPackageName(), null));
            intent.putExtra("android.content.pm.extra.CALLBACK", adapter.getBinder().asBinder());
            adapter.onUserActionRequired(intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermissionsResult(int sessionId, boolean accepted) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", TAG);
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            PackageInstallerSession session = this.mSessions.get(sessionId);
            if (session != null) {
                session.setPermissionsResult(accepted);
            }
        }
    }

    @Override
    public void registerCallback(IPackageInstallerCallback callback, int userId) {
        this.mPermissionManager.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "registerCallback");
        this.mCallbacks.register(callback, userId);
    }

    @Override
    public void unregisterCallback(IPackageInstallerCallback callback) {
        this.mCallbacks.unregister(callback);
    }

    private static int getSessionCount(SparseArray<PackageInstallerSession> sessions, int installerUid) {
        int count = 0;
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            PackageInstallerSession session = sessions.valueAt(i);
            if (session.getInstallerUid() != installerUid) continue;
            ++count;
        }
        return count;
    }

    private boolean isCallingUidOwner(PackageInstallerSession session) {
        int callingUid = Binder.getCallingUid();
        if (callingUid == 0) {
            return true;
        }
        return session != null && callingUid == session.getInstallerUid();
    }

    private static Notification buildSuccessNotification(Context context, String contentText, String basePackageName, int userId) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = AppGlobals.getPackageManager().getPackageInfo(basePackageName, 0x4000000, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (packageInfo == null || packageInfo.applicationInfo == null) {
            Slog.w(TAG, "Notification not built for package: " + basePackageName);
            return null;
        }
        PackageManager pm = context.getPackageManager();
        Bitmap packageIcon = ImageUtils.buildScaledBitmap(packageInfo.applicationInfo.loadIcon(pm), context.getResources().getDimensionPixelSize(0x1050005), context.getResources().getDimensionPixelSize(17104902));
        CharSequence packageLabel = packageInfo.applicationInfo.loadLabel(pm);
        return new Notification.Builder(context, SystemNotificationChannels.DEVICE_ADMIN).setSmallIcon(17302293).setColor(context.getResources().getColor(17170774)).setContentTitle(packageLabel).setContentText(contentText).setStyle(new Notification.BigTextStyle().bigText(contentText)).setLargeIcon(packageIcon).build();
    }

    public static <E> ArraySet<E> newArraySet(E ... elements) {
        ArraySet set = new ArraySet();
        if (elements != null) {
            set.ensureCapacity(elements.length);
            Collections.addAll(set, elements);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(IndentingPrintWriter pw) {
        SparseArray<PackageInstallerSession> sparseArray = this.mSessions;
        synchronized (sparseArray) {
            int i;
            pw.println("Active install sessions:");
            pw.increaseIndent();
            int N = this.mSessions.size();
            for (i = 0; i < N; ++i) {
                PackageInstallerSession session = this.mSessions.valueAt(i);
                session.dump(pw);
                pw.println();
            }
            pw.println();
            pw.decreaseIndent();
            pw.println("Historical install sessions:");
            pw.increaseIndent();
            N = this.mHistoricalSessions.size();
            for (i = 0; i < N; ++i) {
                pw.print(this.mHistoricalSessions.get(i));
                pw.println();
            }
            pw.println();
            pw.decreaseIndent();
            pw.println("Legacy install sessions:");
            pw.increaseIndent();
            pw.println(this.mLegacySessions.toString());
            pw.decreaseIndent();
        }
    }

    class InternalCallback {
        InternalCallback() {
        }

        public void onSessionBadgingChanged(PackageInstallerSession session) {
            PackageInstallerService.this.mCallbacks.notifySessionBadgingChanged(session.sessionId, session.userId);
            PackageInstallerService.this.writeSessionsAsync();
        }

        public void onSessionActiveChanged(PackageInstallerSession session, boolean active) {
            PackageInstallerService.this.mCallbacks.notifySessionActiveChanged(session.sessionId, session.userId, active);
        }

        public void onSessionProgressChanged(PackageInstallerSession session, float progress) {
            PackageInstallerService.this.mCallbacks.notifySessionProgressChanged(session.sessionId, session.userId, progress);
        }

        public void onSessionFinished(final PackageInstallerSession session, boolean success) {
            PackageInstallerService.this.mCallbacks.notifySessionFinished(session.sessionId, session.userId, success);
            PackageInstallerService.this.mInstallHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SparseArray sparseArray = PackageInstallerService.this.mSessions;
                    synchronized (sparseArray) {
                        PackageInstallerService.this.mSessions.remove(session.sessionId);
                        PackageInstallerService.this.addHistoricalSessionLocked(session);
                        File appIconFile = PackageInstallerService.this.buildAppIconFile(session.sessionId);
                        if (appIconFile.exists()) {
                            appIconFile.delete();
                        }
                        PackageInstallerService.this.writeSessionsLocked();
                    }
                }
            });
        }

        public void onSessionPrepared(PackageInstallerSession session) {
            PackageInstallerService.this.writeSessionsAsync();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSessionSealedBlocking(PackageInstallerSession session) {
            SparseArray sparseArray = PackageInstallerService.this.mSessions;
            synchronized (sparseArray) {
                PackageInstallerService.this.writeSessionsLocked();
            }
        }
    }

    private static class Callbacks
    extends Handler {
        private static final int MSG_SESSION_CREATED = 1;
        private static final int MSG_SESSION_BADGING_CHANGED = 2;
        private static final int MSG_SESSION_ACTIVE_CHANGED = 3;
        private static final int MSG_SESSION_PROGRESS_CHANGED = 4;
        private static final int MSG_SESSION_FINISHED = 5;
        private final RemoteCallbackList<IPackageInstallerCallback> mCallbacks = new RemoteCallbackList();

        public Callbacks(Looper looper) {
            super(looper);
        }

        public void register(IPackageInstallerCallback callback, int userId) {
            this.mCallbacks.register(callback, new UserHandle(userId));
        }

        public void unregister(IPackageInstallerCallback callback) {
            this.mCallbacks.unregister(callback);
        }

        @Override
        public void handleMessage(Message msg) {
            int userId = msg.arg2;
            int n = this.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                IPackageInstallerCallback callback = this.mCallbacks.getBroadcastItem(i);
                UserHandle user = (UserHandle)this.mCallbacks.getBroadcastCookie(i);
                if (userId != user.getIdentifier()) continue;
                try {
                    this.invokeCallback(callback, msg);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mCallbacks.finishBroadcast();
        }

        private void invokeCallback(IPackageInstallerCallback callback, Message msg) throws RemoteException {
            int sessionId = msg.arg1;
            switch (msg.what) {
                case 1: {
                    callback.onSessionCreated(sessionId);
                    break;
                }
                case 2: {
                    callback.onSessionBadgingChanged(sessionId);
                    break;
                }
                case 3: {
                    callback.onSessionActiveChanged(sessionId, (Boolean)msg.obj);
                    break;
                }
                case 4: {
                    callback.onSessionProgressChanged(sessionId, ((Float)msg.obj).floatValue());
                    break;
                }
                case 5: {
                    callback.onSessionFinished(sessionId, (Boolean)msg.obj);
                }
            }
        }

        private void notifySessionCreated(int sessionId, int userId) {
            this.obtainMessage(1, sessionId, userId).sendToTarget();
        }

        private void notifySessionBadgingChanged(int sessionId, int userId) {
            this.obtainMessage(2, sessionId, userId).sendToTarget();
        }

        private void notifySessionActiveChanged(int sessionId, int userId, boolean active) {
            this.obtainMessage(3, sessionId, userId, active).sendToTarget();
        }

        private void notifySessionProgressChanged(int sessionId, int userId, float progress) {
            this.obtainMessage(4, sessionId, userId, Float.valueOf(progress)).sendToTarget();
        }

        public void notifySessionFinished(int sessionId, int userId, boolean success) {
            this.obtainMessage(5, sessionId, userId, success).sendToTarget();
        }
    }

    static class PackageInstallObserverAdapter
    extends PackageInstallObserver {
        private final Context mContext;
        private final IntentSender mTarget;
        private final int mSessionId;
        private final boolean mShowNotification;
        private final int mUserId;

        public PackageInstallObserverAdapter(Context context, IntentSender target, int sessionId, boolean showNotification, int userId) {
            this.mContext = context;
            this.mTarget = target;
            this.mSessionId = sessionId;
            this.mShowNotification = showNotification;
            this.mUserId = userId;
        }

        @Override
        public void onUserActionRequired(Intent intent) {
            Intent fillIn = new Intent();
            fillIn.putExtra("android.content.pm.extra.SESSION_ID", this.mSessionId);
            fillIn.putExtra("android.content.pm.extra.STATUS", -1);
            fillIn.putExtra("android.intent.extra.INTENT", intent);
            try {
                this.mTarget.sendIntent(this.mContext, 0, fillIn, null, null);
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                // empty catch block
            }
        }

        @Override
        public void onPackageInstalled(String basePackageName, int returnCode, String msg, Bundle extras) {
            String existing;
            if (1 == returnCode && this.mShowNotification) {
                boolean update = extras != null && extras.getBoolean("android.intent.extra.REPLACING");
                Notification notification = PackageInstallerService.buildSuccessNotification(this.mContext, this.mContext.getResources().getString(update ? 17040410 : 17040409), basePackageName, this.mUserId);
                if (notification != null) {
                    NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
                    notificationManager.notify(basePackageName, 21, notification);
                }
            }
            Intent fillIn = new Intent();
            fillIn.putExtra("android.content.pm.extra.PACKAGE_NAME", basePackageName);
            fillIn.putExtra("android.content.pm.extra.SESSION_ID", this.mSessionId);
            fillIn.putExtra("android.content.pm.extra.STATUS", PackageManager.installStatusToPublicStatus(returnCode));
            fillIn.putExtra("android.content.pm.extra.STATUS_MESSAGE", PackageManager.installStatusToString(returnCode, msg));
            fillIn.putExtra("android.content.pm.extra.LEGACY_STATUS", returnCode);
            if (extras != null && !TextUtils.isEmpty(existing = extras.getString("android.content.pm.extra.FAILURE_EXISTING_PACKAGE"))) {
                fillIn.putExtra("android.content.pm.extra.OTHER_PACKAGE_NAME", existing);
            }
            try {
                this.mTarget.sendIntent(this.mContext, 0, fillIn, null, null);
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                // empty catch block
            }
        }
    }

    static class PackageDeleteObserverAdapter
    extends PackageDeleteObserver {
        private final Context mContext;
        private final IntentSender mTarget;
        private final String mPackageName;
        private final Notification mNotification;

        public PackageDeleteObserverAdapter(Context context, IntentSender target, String packageName, boolean showNotification, int userId) {
            this.mContext = context;
            this.mTarget = target;
            this.mPackageName = packageName;
            this.mNotification = showNotification ? PackageInstallerService.buildSuccessNotification(this.mContext, this.mContext.getResources().getString(17040408), packageName, userId) : null;
        }

        @Override
        public void onUserActionRequired(Intent intent) {
            Intent fillIn = new Intent();
            fillIn.putExtra("android.content.pm.extra.PACKAGE_NAME", this.mPackageName);
            fillIn.putExtra("android.content.pm.extra.STATUS", -1);
            fillIn.putExtra("android.intent.extra.INTENT", intent);
            try {
                this.mTarget.sendIntent(this.mContext, 0, fillIn, null, null);
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                // empty catch block
            }
        }

        @Override
        public void onPackageDeleted(String basePackageName, int returnCode, String msg) {
            if (1 == returnCode && this.mNotification != null) {
                NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
                notificationManager.notify(basePackageName, 21, this.mNotification);
            }
            Intent fillIn = new Intent();
            fillIn.putExtra("android.content.pm.extra.PACKAGE_NAME", this.mPackageName);
            fillIn.putExtra("android.content.pm.extra.STATUS", PackageManager.deleteStatusToPublicStatus(returnCode));
            fillIn.putExtra("android.content.pm.extra.STATUS_MESSAGE", PackageManager.deleteStatusToString(returnCode, msg));
            fillIn.putExtra("android.content.pm.extra.LEGACY_STATUS", returnCode);
            try {
                this.mTarget.sendIntent(this.mContext, 0, fillIn, null, null);
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                // empty catch block
            }
        }
    }
}

