/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.os.SystemProperties;
import dalvik.system.DexFile;

public class PackageManagerServiceCompilerMapping {
    public static final String[] REASON_STRINGS = new String[]{"first-boot", "boot", "install", "bg-dexopt", "ab-ota", "inactive", "shared"};
    static final int REASON_SHARED_INDEX = 6;

    private static String getSystemPropertyName(int reason) {
        if (reason < 0 || reason >= REASON_STRINGS.length) {
            throw new IllegalArgumentException("reason " + reason + " invalid");
        }
        return "pm.dexopt." + REASON_STRINGS[reason];
    }

    private static String getAndCheckValidity(int reason) {
        String sysPropValue = SystemProperties.get(PackageManagerServiceCompilerMapping.getSystemPropertyName(reason));
        if (sysPropValue == null || sysPropValue.isEmpty() || !DexFile.isValidCompilerFilter(sysPropValue)) {
            throw new IllegalStateException("Value \"" + sysPropValue + "\" not valid (reason " + REASON_STRINGS[reason] + ")");
        }
        if (!PackageManagerServiceCompilerMapping.isFilterAllowedForReason(reason, sysPropValue)) {
            throw new IllegalStateException("Value \"" + sysPropValue + "\" not allowed (reason " + REASON_STRINGS[reason] + ")");
        }
        return sysPropValue;
    }

    private static boolean isFilterAllowedForReason(int reason, String filter) {
        return reason != 6 || !DexFile.isProfileGuidedCompilerFilter(filter);
    }

    static void checkProperties() {
        Throwable toThrow = null;
        for (int reason = 0; reason <= 6; ++reason) {
            try {
                String sysPropName = PackageManagerServiceCompilerMapping.getSystemPropertyName(reason);
                if (sysPropName == null || sysPropName.isEmpty()) {
                    throw new IllegalStateException("Reason system property name \"" + sysPropName + "\" for reason " + REASON_STRINGS[reason]);
                }
                PackageManagerServiceCompilerMapping.getAndCheckValidity(reason);
                continue;
            }
            catch (Exception exc) {
                if (toThrow == null) {
                    toThrow = new IllegalStateException("PMS compiler filter settings are bad.");
                }
                toThrow.addSuppressed(exc);
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public static String getCompilerFilterForReason(int reason) {
        return PackageManagerServiceCompilerMapping.getAndCheckValidity(reason);
    }

    public static String getDefaultCompilerFilter() {
        String value = SystemProperties.get("dalvik.vm.dex2oat-filter");
        if (value == null || value.isEmpty()) {
            return "speed";
        }
        if (!DexFile.isValidCompilerFilter(value) || DexFile.isProfileGuidedCompilerFilter(value)) {
            return "speed";
        }
        return value;
    }

    public static String getReasonName(int reason) {
        if (reason == -1) {
            return "unknown";
        }
        if (reason < 0 || reason >= REASON_STRINGS.length) {
            throw new IllegalArgumentException("reason " + reason + " invalid");
        }
        return REASON_STRINGS[reason];
    }

    static {
        if (7 != REASON_STRINGS.length) {
            throw new IllegalStateException("REASON_STRINGS not correct");
        }
        if (!"shared".equals(REASON_STRINGS[6])) {
            throw new IllegalStateException("REASON_STRINGS not correct because of shared index");
        }
    }
}

