/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageInfo;
import com.android.internal.util.Preconditions;
import com.android.server.pm.ShortcutPackageInfo;
import com.android.server.pm.ShortcutService;
import com.android.server.pm.ShortcutUser;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

abstract class ShortcutPackageItem {
    private static final String TAG = "ShortcutService";
    private static final String KEY_NAME = "name";
    private final int mPackageUserId;
    private final String mPackageName;
    private final ShortcutPackageInfo mPackageInfo;
    protected ShortcutUser mShortcutUser;

    protected ShortcutPackageItem(ShortcutUser shortcutUser, int packageUserId, String packageName, ShortcutPackageInfo packageInfo) {
        this.mShortcutUser = shortcutUser;
        this.mPackageUserId = packageUserId;
        this.mPackageName = Preconditions.checkStringNotEmpty(packageName);
        this.mPackageInfo = Preconditions.checkNotNull(packageInfo);
    }

    public void replaceUser(ShortcutUser user) {
        this.mShortcutUser = user;
    }

    public ShortcutUser getUser() {
        return this.mShortcutUser;
    }

    public int getPackageUserId() {
        return this.mPackageUserId;
    }

    public abstract int getOwnerUserId();

    public String getPackageName() {
        return this.mPackageName;
    }

    public ShortcutPackageInfo getPackageInfo() {
        return this.mPackageInfo;
    }

    public void refreshPackageSignatureAndSave() {
        if (this.mPackageInfo.isShadow()) {
            return;
        }
        ShortcutService s = this.mShortcutUser.mService;
        this.mPackageInfo.refreshSignature(s, this);
        s.scheduleSaveUser(this.getOwnerUserId());
    }

    public void attemptToRestoreIfNeededAndSave() {
        int restoreBlockReason;
        if (!this.mPackageInfo.isShadow()) {
            return;
        }
        ShortcutService s = this.mShortcutUser.mService;
        if (!s.isPackageInstalled(this.mPackageName, this.mPackageUserId)) {
            return;
        }
        long currentVersionCode = -1L;
        if (!this.mPackageInfo.hasSignatures()) {
            s.wtf("Attempted to restore package " + this.mPackageName + "/u" + this.mPackageUserId + " but signatures not found in the restore data.");
            restoreBlockReason = 102;
        } else {
            PackageInfo pi = s.getPackageInfoWithSignatures(this.mPackageName, this.mPackageUserId);
            currentVersionCode = pi.getLongVersionCode();
            restoreBlockReason = this.mPackageInfo.canRestoreTo(s, pi, this.canRestoreAnyVersion());
        }
        this.onRestored(restoreBlockReason);
        this.mPackageInfo.setShadow(false);
        s.scheduleSaveUser(this.mPackageUserId);
    }

    protected abstract boolean canRestoreAnyVersion();

    protected abstract void onRestored(int var1);

    public abstract void saveToXml(XmlSerializer var1, boolean var2) throws IOException, XmlPullParserException;

    public JSONObject dumpCheckin(boolean clear) throws JSONException {
        JSONObject result = new JSONObject();
        result.put(KEY_NAME, this.mPackageName);
        return result;
    }

    public void verifyStates() {
    }
}

