/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.os.IBinder;
import com.android.server.LocalServices;
import com.android.server.policy.BarController;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.wm.WindowManagerInternal;

public class StatusBarController
extends BarController {
    private final WindowManagerInternal.AppTransitionListener mAppTransitionListener = new WindowManagerInternal.AppTransitionListener(){

        @Override
        public void onAppTransitionPendingLocked() {
            StatusBarController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    StatusBarManagerInternal statusbar = StatusBarController.this.getStatusBarInternal();
                    if (statusbar != null) {
                        statusbar.appTransitionPending();
                    }
                }
            });
        }

        @Override
        public int onAppTransitionStartingLocked(int transit, IBinder openToken, IBinder closeToken, long duration, final long statusBarAnimationStartTime, final long statusBarAnimationDuration) {
            StatusBarController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    StatusBarManagerInternal statusbar = StatusBarController.this.getStatusBarInternal();
                    if (statusbar != null) {
                        statusbar.appTransitionStarting(statusBarAnimationStartTime, statusBarAnimationDuration);
                    }
                }
            });
            return 0;
        }

        @Override
        public void onAppTransitionCancelledLocked(int transit) {
            StatusBarController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    StatusBarManagerInternal statusbar = StatusBarController.this.getStatusBarInternal();
                    if (statusbar != null) {
                        statusbar.appTransitionCancelled();
                    }
                }
            });
        }

        @Override
        public void onAppTransitionFinishedLocked(IBinder token) {
            StatusBarController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    StatusBarManagerInternal statusbar = LocalServices.getService(StatusBarManagerInternal.class);
                    if (statusbar != null) {
                        statusbar.appTransitionFinished();
                    }
                }
            });
        }
    };

    public StatusBarController() {
        super("StatusBar", 0x4000000, 0x10000000, 0x40000000, 1, 0x4000000, 8);
    }

    public void setTopAppHidesStatusBar(boolean hidesStatusBar) {
        StatusBarManagerInternal statusbar = this.getStatusBarInternal();
        if (statusbar != null) {
            statusbar.setTopAppHidesStatusBar(hidesStatusBar);
        }
    }

    @Override
    protected boolean skipAnimation() {
        return this.mWin.getAttrs().height == -1;
    }

    public WindowManagerInternal.AppTransitionListener getAppTransitionListener() {
        return this.mAppTransitionListener;
    }
}

