/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.slice;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.ShellCommand;
import android.util.ArraySet;
import com.android.server.slice.SliceManagerService;
import java.io.PrintWriter;
import java.util.List;

public class SliceShellCommand
extends ShellCommand {
    private final SliceManagerService mService;

    public SliceShellCommand(SliceManagerService service) {
        this.mService = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        switch (cmd) {
            case "get-permissions": {
                return this.runGetPermissions(this.getNextArgRequired());
            }
        }
        return 0;
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Status bar commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("");
        pw.println("  get-permissions <authority>");
        pw.println("    List the pkgs that have permission to an authority.");
        pw.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runGetPermissions(String authority) {
        if (Binder.getCallingUid() != 2000 && Binder.getCallingUid() != 0) {
            this.getOutPrintWriter().println("Only shell can get permissions");
            return -1;
        }
        Context context = this.mService.getContext();
        long ident = Binder.clearCallingIdentity();
        try {
            Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
            if (!"vnd.android.slice".equals(context.getContentResolver().getType(uri))) {
                this.getOutPrintWriter().println(authority + " is not a slice provider");
                int n = -1;
                return n;
            }
            Bundle b = context.getContentResolver().call(uri, "get_permissions", null, null);
            if (b == null) {
                this.getOutPrintWriter().println("An error occurred getting permissions");
                int n = -1;
                return n;
            }
            String[] permissions = b.getStringArray("result");
            PrintWriter pw = this.getOutPrintWriter();
            ArraySet<String> listedPackages = new ArraySet<String>();
            if (permissions != null && permissions.length != 0) {
                List<PackageInfo> apps = context.getPackageManager().getPackagesHoldingPermissions(permissions, 0);
                for (PackageInfo app : apps) {
                    pw.println(app.packageName);
                    listedPackages.add(app.packageName);
                }
            }
            for (String pkg : this.mService.getAllPackagesGranted(authority)) {
                if (listedPackages.contains(pkg)) continue;
                pw.println(pkg);
                listedPackages.add(pkg);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return 0;
    }
}

