/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.usage.ConfigurationStats;
import android.app.usage.EventList;
import android.app.usage.EventStats;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.content.res.Configuration;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.util.List;

class IntervalStats {
    public long beginTime;
    public long endTime;
    public long lastTimeSaved;
    public final EventTracker interactiveTracker = new EventTracker();
    public final EventTracker nonInteractiveTracker = new EventTracker();
    public final EventTracker keyguardShownTracker = new EventTracker();
    public final EventTracker keyguardHiddenTracker = new EventTracker();
    public final ArrayMap<String, UsageStats> packageStats = new ArrayMap();
    public final ArrayMap<Configuration, ConfigurationStats> configurations = new ArrayMap();
    public Configuration activeConfiguration;
    public EventList events;
    private final ArraySet<String> mStringCache = new ArraySet();

    IntervalStats() {
    }

    UsageStats getOrCreateUsageStats(String packageName) {
        UsageStats usageStats = this.packageStats.get(packageName);
        if (usageStats == null) {
            usageStats = new UsageStats();
            usageStats.mPackageName = this.getCachedStringRef(packageName);
            usageStats.mBeginTimeStamp = this.beginTime;
            usageStats.mEndTimeStamp = this.endTime;
            this.packageStats.put(usageStats.mPackageName, usageStats);
        }
        return usageStats;
    }

    ConfigurationStats getOrCreateConfigurationStats(Configuration config) {
        ConfigurationStats configStats = this.configurations.get(config);
        if (configStats == null) {
            configStats = new ConfigurationStats();
            configStats.mBeginTimeStamp = this.beginTime;
            configStats.mEndTimeStamp = this.endTime;
            configStats.mConfiguration = config;
            this.configurations.put(config, configStats);
        }
        return configStats;
    }

    UsageEvents.Event buildEvent(String packageName, String className) {
        UsageEvents.Event event = new UsageEvents.Event();
        event.mPackage = this.getCachedStringRef(packageName);
        if (className != null) {
            event.mClass = this.getCachedStringRef(className);
        }
        return event;
    }

    private boolean isStatefulEvent(int eventType) {
        switch (eventType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private boolean isUserVisibleEvent(int eventType) {
        return eventType != 6 && eventType != 11;
    }

    void update(String packageName, long timeStamp, int eventType) {
        UsageStats usageStats = this.getOrCreateUsageStats(packageName);
        if (!(eventType != 2 && eventType != 3 || usageStats.mLastEvent != 1 && usageStats.mLastEvent != 4)) {
            usageStats.mTotalTimeInForeground += timeStamp - usageStats.mLastTimeUsed;
        }
        if (this.isStatefulEvent(eventType)) {
            usageStats.mLastEvent = eventType;
        }
        if (this.isUserVisibleEvent(eventType)) {
            usageStats.mLastTimeUsed = timeStamp;
        }
        usageStats.mEndTimeStamp = timeStamp;
        if (eventType == 1) {
            ++usageStats.mLaunchCount;
        }
        this.endTime = timeStamp;
    }

    void updateChooserCounts(String packageName, String category, String action) {
        ArrayMap<Object, Object> chooserCounts;
        int idx;
        UsageStats usageStats = this.getOrCreateUsageStats(packageName);
        if (usageStats.mChooserCounts == null) {
            usageStats.mChooserCounts = new ArrayMap();
        }
        if ((idx = usageStats.mChooserCounts.indexOfKey(action)) < 0) {
            chooserCounts = new ArrayMap();
            usageStats.mChooserCounts.put(action, chooserCounts);
        } else {
            chooserCounts = usageStats.mChooserCounts.valueAt(idx);
        }
        int currentCount = chooserCounts.getOrDefault(category, 0);
        chooserCounts.put(category, currentCount + 1);
    }

    void updateConfigurationStats(Configuration config, long timeStamp) {
        if (this.activeConfiguration != null) {
            ConfigurationStats activeStats = this.configurations.get(this.activeConfiguration);
            activeStats.mTotalTimeActive += timeStamp - activeStats.mLastTimeActive;
            activeStats.mLastTimeActive = timeStamp - 1L;
        }
        if (config != null) {
            ConfigurationStats configStats = this.getOrCreateConfigurationStats(config);
            configStats.mLastTimeActive = timeStamp;
            ++configStats.mActivationCount;
            this.activeConfiguration = configStats.mConfiguration;
        }
        this.endTime = timeStamp;
    }

    void incrementAppLaunchCount(String packageName) {
        UsageStats usageStats = this.getOrCreateUsageStats(packageName);
        ++usageStats.mAppLaunchCount;
    }

    void commitTime(long timeStamp) {
        this.interactiveTracker.commitTime(timeStamp);
        this.nonInteractiveTracker.commitTime(timeStamp);
        this.keyguardShownTracker.commitTime(timeStamp);
        this.keyguardHiddenTracker.commitTime(timeStamp);
    }

    void updateScreenInteractive(long timeStamp) {
        this.interactiveTracker.update(timeStamp);
        this.nonInteractiveTracker.commitTime(timeStamp);
    }

    void updateScreenNonInteractive(long timeStamp) {
        this.nonInteractiveTracker.update(timeStamp);
        this.interactiveTracker.commitTime(timeStamp);
    }

    void updateKeyguardShown(long timeStamp) {
        this.keyguardShownTracker.update(timeStamp);
        this.keyguardHiddenTracker.commitTime(timeStamp);
    }

    void updateKeyguardHidden(long timeStamp) {
        this.keyguardHiddenTracker.update(timeStamp);
        this.keyguardShownTracker.commitTime(timeStamp);
    }

    void addEventStatsTo(List<EventStats> out) {
        this.interactiveTracker.addToEventStats(out, 15, this.beginTime, this.endTime);
        this.nonInteractiveTracker.addToEventStats(out, 16, this.beginTime, this.endTime);
        this.keyguardShownTracker.addToEventStats(out, 17, this.beginTime, this.endTime);
        this.keyguardHiddenTracker.addToEventStats(out, 18, this.beginTime, this.endTime);
    }

    private String getCachedStringRef(String str) {
        int index = this.mStringCache.indexOf(str);
        if (index < 0) {
            this.mStringCache.add(str);
            return str;
        }
        return this.mStringCache.valueAt(index);
    }

    public static final class EventTracker {
        public long curStartTime;
        public long lastEventTime;
        public long duration;
        public int count;

        public void commitTime(long timeStamp) {
            if (this.curStartTime != 0L) {
                this.duration += timeStamp - this.duration;
                this.curStartTime = 0L;
            }
        }

        public void update(long timeStamp) {
            if (this.curStartTime == 0L) {
                ++this.count;
            }
            this.commitTime(timeStamp);
            this.curStartTime = timeStamp;
            this.lastEventTime = timeStamp;
        }

        void addToEventStats(List<EventStats> out, int event, long beginTime, long endTime) {
            if (this.count != 0 || this.duration != 0L) {
                EventStats ev = new EventStats();
                ev.mEventType = event;
                ev.mCount = this.count;
                ev.mTotalTime = this.duration;
                ev.mLastEventTime = this.lastEventTime;
                ev.mBeginTimeStamp = beginTime;
                ev.mEndTimeStamp = endTime;
                out.add(ev);
            }
        }
    }
}

