/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.media.IAudioService;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.util.dump.DualDumpOutputStream;
import com.android.server.audio.AudioService;
import com.android.server.usb.UsbAlsaJackDetector;

public final class UsbAlsaDevice {
    private static final String TAG = "UsbAlsaDevice";
    protected static final boolean DEBUG = false;
    private final int mCardNum;
    private final int mDeviceNum;
    private final String mDeviceAddress;
    private final boolean mHasOutput;
    private final boolean mHasInput;
    private final boolean mIsInputHeadset;
    private final boolean mIsOutputHeadset;
    private boolean mSelected = false;
    private int mOutputState;
    private int mInputState;
    private UsbAlsaJackDetector mJackDetector;
    private IAudioService mAudioService;
    private String mDeviceName = "";
    private String mDeviceDescription = "";

    public UsbAlsaDevice(IAudioService audioService, int card, int device, String deviceAddress, boolean hasOutput, boolean hasInput, boolean isInputHeadset, boolean isOutputHeadset) {
        this.mAudioService = audioService;
        this.mCardNum = card;
        this.mDeviceNum = device;
        this.mDeviceAddress = deviceAddress;
        this.mHasOutput = hasOutput;
        this.mHasInput = hasInput;
        this.mIsInputHeadset = isInputHeadset;
        this.mIsOutputHeadset = isOutputHeadset;
    }

    public int getCardNum() {
        return this.mCardNum;
    }

    public int getDeviceNum() {
        return this.mDeviceNum;
    }

    public String getDeviceAddress() {
        return this.mDeviceAddress;
    }

    public String getAlsaCardDeviceString() {
        if (this.mCardNum < 0 || this.mDeviceNum < 0) {
            Slog.e(TAG, "Invalid alsa card or device alsaCard: " + this.mCardNum + " alsaDevice: " + this.mDeviceNum);
            return null;
        }
        return AudioService.makeAlsaAddressString(this.mCardNum, this.mDeviceNum);
    }

    public boolean hasOutput() {
        return this.mHasOutput;
    }

    public boolean hasInput() {
        return this.mHasInput;
    }

    public boolean isInputHeadset() {
        return this.mIsInputHeadset;
    }

    public boolean isOutputHeadset() {
        return this.mIsOutputHeadset;
    }

    private synchronized boolean isInputJackConnected() {
        if (this.mJackDetector == null) {
            return true;
        }
        return this.mJackDetector.isInputJackConnected();
    }

    private synchronized boolean isOutputJackConnected() {
        if (this.mJackDetector == null) {
            return true;
        }
        return this.mJackDetector.isOutputJackConnected();
    }

    private synchronized void startJackDetect() {
        this.mJackDetector = UsbAlsaJackDetector.startJackDetect(this);
    }

    private synchronized void stopJackDetect() {
        if (this.mJackDetector != null) {
            this.mJackDetector.pleaseStop();
        }
        this.mJackDetector = null;
    }

    public synchronized void start() {
        this.mSelected = true;
        this.mInputState = 0;
        this.mOutputState = 0;
        this.startJackDetect();
        this.updateWiredDeviceConnectionState(true);
    }

    public synchronized void stop() {
        this.stopJackDetect();
        this.updateWiredDeviceConnectionState(false);
        this.mSelected = false;
    }

    public synchronized void updateWiredDeviceConnectionState(boolean enable) {
        if (!this.mSelected) {
            Slog.e(TAG, "updateWiredDeviceConnectionState on unselected AlsaDevice!");
            return;
        }
        String alsaCardDeviceString = this.getAlsaCardDeviceString();
        if (alsaCardDeviceString == null) {
            return;
        }
        try {
            boolean connected;
            int device;
            if (this.mHasOutput) {
                int outputState;
                device = this.mIsOutputHeadset ? 0x4000000 : 16384;
                connected = this.isOutputJackConnected();
                Slog.i(TAG, "OUTPUT JACK connected: " + connected);
                int n = outputState = enable && connected ? 1 : 0;
                if (outputState != this.mOutputState) {
                    this.mOutputState = outputState;
                    this.mAudioService.setWiredDeviceConnectionState(device, outputState, alsaCardDeviceString, this.mDeviceName, TAG);
                }
            }
            if (this.mHasInput) {
                int inputState;
                device = this.mIsInputHeadset ? -2113929216 : -2147479552;
                connected = this.isInputJackConnected();
                Slog.i(TAG, "INPUT JACK connected: " + connected);
                int n = inputState = enable && connected ? 1 : 0;
                if (inputState != this.mInputState) {
                    this.mInputState = inputState;
                    this.mAudioService.setWiredDeviceConnectionState(device, inputState, alsaCardDeviceString, this.mDeviceName, TAG);
                }
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "RemoteException in setWiredDeviceConnectionState");
        }
    }

    public synchronized String toString() {
        return "UsbAlsaDevice: [card: " + this.mCardNum + ", device: " + this.mDeviceNum + ", name: " + this.mDeviceName + ", hasOutput: " + this.mHasOutput + ", hasInput: " + this.mHasInput + "]";
    }

    public synchronized void dump(DualDumpOutputStream dump, String idName, long id2) {
        long token = dump.start(idName, id2);
        dump.write("card", 0x10500000001L, this.mCardNum);
        dump.write("device", 1120986464258L, this.mDeviceNum);
        dump.write("name", 1138166333443L, this.mDeviceName);
        dump.write("has_output", 1133871366148L, this.mHasOutput);
        dump.write("has_input", 1133871366149L, this.mHasInput);
        dump.write("address", 1138166333446L, this.mDeviceAddress);
        dump.end(token);
    }

    synchronized String toShortString() {
        return "[card:" + this.mCardNum + " device:" + this.mDeviceNum + " " + this.mDeviceName + "]";
    }

    synchronized String getDeviceName() {
        return this.mDeviceName;
    }

    synchronized void setDeviceNameAndDescription(String deviceName, String deviceDescription) {
        this.mDeviceName = deviceName;
        this.mDeviceDescription = deviceDescription;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UsbAlsaDevice)) {
            return false;
        }
        UsbAlsaDevice other = (UsbAlsaDevice)obj;
        return this.mCardNum == other.mCardNum && this.mDeviceNum == other.mDeviceNum && this.mHasOutput == other.mHasOutput && this.mHasInput == other.mHasInput && this.mIsInputHeadset == other.mIsInputHeadset && this.mIsOutputHeadset == other.mIsOutputHeadset;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mCardNum;
        result = 31 * result + this.mDeviceNum;
        result = 31 * result + (this.mHasOutput ? 0 : 1);
        result = 31 * result + (this.mHasInput ? 0 : 1);
        result = 31 * result + (this.mIsInputHeadset ? 0 : 1);
        result = 31 * result + (this.mIsOutputHeadset ? 0 : 1);
        return result;
    }
}

