/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

public final class ByteStream {
    private static final String TAG = "ByteStream";
    private final byte[] mBytes;
    private int mIndex;
    private int mReadCount;

    public ByteStream(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.mBytes = bytes;
    }

    public void resetReadCount() {
        this.mReadCount = 0;
    }

    public int getReadCount() {
        return this.mReadCount;
    }

    public byte peekByte() {
        if (this.available() > 0) {
            return this.mBytes[this.mIndex + 1];
        }
        throw new IndexOutOfBoundsException();
    }

    public byte getByte() {
        if (this.available() > 0) {
            ++this.mReadCount;
            return this.mBytes[this.mIndex++];
        }
        throw new IndexOutOfBoundsException();
    }

    public int getUnsignedByte() {
        if (this.available() > 0) {
            ++this.mReadCount;
            return this.mBytes[this.mIndex++] & 0xFF;
        }
        throw new IndexOutOfBoundsException();
    }

    public int unpackUsbShort() {
        if (this.available() >= 2) {
            int b0 = this.getUnsignedByte();
            int b1 = this.getUnsignedByte();
            return b1 << 8 | b0;
        }
        throw new IndexOutOfBoundsException();
    }

    public int unpackUsbTriple() {
        if (this.available() >= 3) {
            int b0 = this.getUnsignedByte();
            int b1 = this.getUnsignedByte();
            int b2 = this.getUnsignedByte();
            return b2 << 16 | b1 << 8 | b0;
        }
        throw new IndexOutOfBoundsException();
    }

    public int unpackUsbInt() {
        if (this.available() >= 4) {
            int b0 = this.getUnsignedByte();
            int b1 = this.getUnsignedByte();
            int b2 = this.getUnsignedByte();
            int b3 = this.getUnsignedByte();
            return b3 << 24 | b2 << 16 | b1 << 8 | b0;
        }
        throw new IndexOutOfBoundsException();
    }

    public void advance(int numBytes) {
        if (numBytes < 0) {
            throw new IllegalArgumentException();
        }
        long longNewIndex = (long)this.mIndex + (long)numBytes;
        if (longNewIndex < (long)this.mBytes.length) {
            this.mReadCount += numBytes;
            this.mIndex += numBytes;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    public void reverse(int numBytes) {
        if (numBytes < 0) {
            throw new IllegalArgumentException();
        }
        if (this.mIndex >= numBytes) {
            this.mReadCount -= numBytes;
            this.mIndex -= numBytes;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    public int available() {
        return this.mBytes.length - this.mIndex;
    }
}

