/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.Slog;
import android.view.IApplicationToken;
import android.view.RemoteAnimationDefinition;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.AttributeCache;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.wm.AppWindowContainerListener;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.SnapshotStartingData;
import com.android.server.wm.SplashScreenStartingData;
import com.android.server.wm.StartingData;
import com.android.server.wm.Task;
import com.android.server.wm.TaskWindowContainerController;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken;

public class AppWindowContainerController
extends WindowContainerController<AppWindowToken, AppWindowContainerListener> {
    private static final int STARTING_WINDOW_TYPE_NONE = 0;
    private static final int STARTING_WINDOW_TYPE_SNAPSHOT = 1;
    private static final int STARTING_WINDOW_TYPE_SPLASH_SCREEN = 2;
    private final IApplicationToken mToken;
    private final Handler mHandler;
    private final Runnable mOnWindowsVisible;
    private final Runnable mOnWindowsGone;
    private final Runnable mAddStartingWindow;

    public AppWindowContainerController(TaskWindowContainerController taskController, IApplicationToken token, AppWindowContainerListener listener, int index, int requestedOrientation, boolean fullscreen, boolean showForAllUsers, int configChanges, boolean voiceInteraction, boolean launchTaskBehind, boolean alwaysFocusable, int targetSdkVersion, int rotationAnimationHint, long inputDispatchingTimeoutNanos) {
        this(taskController, token, listener, index, requestedOrientation, fullscreen, showForAllUsers, configChanges, voiceInteraction, launchTaskBehind, alwaysFocusable, targetSdkVersion, rotationAnimationHint, inputDispatchingTimeoutNanos, WindowManagerService.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public AppWindowContainerController(TaskWindowContainerController taskController, IApplicationToken token, AppWindowContainerListener listener, int index, int requestedOrientation, boolean fullscreen, boolean showForAllUsers, int configChanges, boolean voiceInteraction, boolean launchTaskBehind, boolean alwaysFocusable, int targetSdkVersion, int rotationAnimationHint, long inputDispatchingTimeoutNanos, WindowManagerService service) {
        AppWindowToken atoken;
        block5: {
            super(listener, service);
            this.mOnWindowsVisible = () -> {
                if (this.mListener == null) {
                    return;
                }
                ((AppWindowContainerListener)this.mListener).onWindowsVisible();
            };
            this.mOnWindowsGone = () -> {
                if (this.mListener == null) {
                    return;
                }
                ((AppWindowContainerListener)this.mListener).onWindowsGone();
            };
            this.mAddStartingWindow = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    block12: {
                        WindowHashMap windowHashMap = AppWindowContainerController.this.mWindowMap;
                        // MONITORENTER : windowHashMap
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            if (AppWindowContainerController.this.mContainer != null) break block12;
                            // MONITOREXIT : windowHashMap
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT : windowHashMap
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                        WindowManagerService.resetPriorityAfterLockedSection();
                        return;
                    }
                    AppWindowContainerController.this.mService.mAnimationHandler.removeCallbacks(this);
                    StartingData startingData = ((AppWindowToken)AppWindowContainerController.this.mContainer).startingData;
                    AppWindowToken container = (AppWindowToken)AppWindowContainerController.this.mContainer;
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    if (startingData == null) {
                        return;
                    }
                    WindowManagerPolicy.StartingSurface surface = null;
                    try {
                        surface = startingData.createStartingSurface(container);
                    }
                    catch (Exception e) {
                        Slog.w("WindowManager", "Exception when adding starting window", e);
                    }
                    if (surface == null) return;
                    boolean abort = false;
                    WindowHashMap windowHashMap = AppWindowContainerController.this.mWindowMap;
                    // MONITORENTER : windowHashMap
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (container.removed || container.startingData == null) {
                            container.startingWindow = null;
                            container.startingData = null;
                            abort = true;
                        } else {
                            container.startingSurface = surface;
                        }
                        // MONITOREXIT : windowHashMap
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : windowHashMap
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    if (!abort) return;
                    surface.remove();
                }
            };
            this.mHandler = new H(service.mH.getLooper());
            this.mToken = token;
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                atoken = this.mRoot.getAppWindowToken(this.mToken.asBinder());
                if (atoken == null) break block5;
                Slog.w("WindowManager", "Attempted to add existing app token: " + this.mToken);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        Task task = (Task)taskController.mContainer;
        if (task == null) {
            throw new IllegalArgumentException("AppWindowContainerController: invalid  controller=" + taskController);
        }
        atoken = this.createAppWindow(this.mService, token, voiceInteraction, task.getDisplayContent(), inputDispatchingTimeoutNanos, fullscreen, showForAllUsers, targetSdkVersion, requestedOrientation, rotationAnimationHint, configChanges, launchTaskBehind, alwaysFocusable, this);
        task.addChild(atoken, index);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @VisibleForTesting
    AppWindowToken createAppWindow(WindowManagerService service, IApplicationToken token, boolean voiceInteraction, DisplayContent dc, long inputDispatchingTimeoutNanos, boolean fullscreen, boolean showForAllUsers, int targetSdk, int orientation, int rotationAnimationHint, int configChanges, boolean launchTaskBehind, boolean alwaysFocusable, AppWindowContainerController controller) {
        return new AppWindowToken(service, token, voiceInteraction, dc, inputDispatchingTimeoutNanos, fullscreen, showForAllUsers, targetSdk, orientation, rotationAnimationHint, configChanges, launchTaskBehind, alwaysFocusable, controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeContainer(int displayId) {
        DisplayContent dc;
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                dc = this.mRoot.getDisplayContent(displayId);
                if (dc != null) break block4;
                Slog.w("WindowManager", "removeAppToken: Attempted to remove binder token: " + this.mToken + " from non-existing displayId=" + displayId);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        dc.removeAppToken(this.mToken.asBinder());
        super.removeContainer();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void removeContainer() {
        throw new UnsupportedOperationException("Use removeContainer(displayId) instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void reparent(TaskWindowContainerController taskController, int position) {
        block5: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block5;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        Task task = (Task)taskController.mContainer;
        if (task == null) {
            throw new IllegalArgumentException("reparent: could not find task=" + taskController);
        }
        ((AppWindowToken)this.mContainer).reparent(task, position);
        ((AppWindowToken)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Configuration setOrientation(int requestedOrientation, int displayId, Configuration displayConfig, boolean freezeScreenIfNeeded) {
        block4: {
            Configuration configuration;
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                Slog.w("WindowManager", "Attempted to set orientation of non-existing app token: " + this.mToken);
                configuration = null;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return configuration;
        }
        ((AppWindowToken)this.mContainer).setOrientation(requestedOrientation);
        IBinder binder = freezeScreenIfNeeded ? this.mToken.asBinder() : null;
        Configuration configuration = this.mService.updateOrientationFromAppTokens(displayConfig, binder, displayId);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int getOrientation() {
        block4: {
            int n;
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                n = -1;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return n;
        }
        int n = ((AppWindowToken)this.mContainer).getOrientationIgnoreVisibility();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setDisablePreviewScreenshots(boolean disable) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                Slog.w("WindowManager", "Attempted to set disable screenshots of non-existing app token: " + this.mToken);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((AppWindowToken)this.mContainer).setDisablePreviewScreenshots(disable);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setVisibility(boolean visible, boolean deferHidingClient) {
        AppWindowToken wtoken;
        block17: {
            AppWindowToken focusedToken;
            WindowState win;
            block16: {
                block15: {
                    WindowHashMap windowHashMap = this.mWindowMap;
                    // MONITORENTER : windowHashMap
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (this.mContainer != null) break block15;
                        Slog.w("WindowManager", "Attempted to set visibility of non-existing app token: " + this.mToken);
                        // MONITOREXIT : windowHashMap
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : windowHashMap
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                wtoken = (AppWindowToken)this.mContainer;
                if (visible || !wtoken.hiddenRequested) break block16;
                if (!deferHidingClient && wtoken.mDeferHidingClient) {
                    wtoken.mDeferHidingClient = deferHidingClient;
                    wtoken.setClientHidden(true);
                }
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            this.mService.mOpeningApps.remove(wtoken);
            this.mService.mClosingApps.remove(wtoken);
            wtoken.waitingToShow = false;
            wtoken.hiddenRequested = !visible;
            wtoken.mDeferHidingClient = deferHidingClient;
            if (!visible) {
                wtoken.removeDeadWindows();
            } else {
                if (!this.mService.mAppTransition.isTransitionSet() && this.mService.mAppTransition.isReady()) {
                    this.mService.mOpeningApps.add(wtoken);
                }
                wtoken.startingMoved = false;
                if (wtoken.isHidden() || wtoken.mAppStopped) {
                    wtoken.clearAllDrawn();
                    if (wtoken.isHidden()) {
                        wtoken.waitingToShow = true;
                    }
                }
                wtoken.setClientHidden(false);
                wtoken.requestUpdateWallpaperIfNeeded();
                wtoken.mAppStopped = false;
                ((AppWindowToken)this.mContainer).transferStartingWindowFromHiddenAboveTokenIfNeeded();
            }
            if (!wtoken.okToAnimate() || !this.mService.mAppTransition.isTransitionSet()) break block17;
            wtoken.inPendingTransaction = true;
            if (visible) {
                this.mService.mOpeningApps.add(wtoken);
                wtoken.mEnteringAnimation = true;
            } else {
                this.mService.mClosingApps.add(wtoken);
                wtoken.mEnteringAnimation = false;
            }
            if (this.mService.mAppTransition.getAppTransition() == 16 && (win = this.mService.getDefaultDisplayContentLocked().findFocusedWindow()) != null && (focusedToken = win.mAppToken) != null) {
                focusedToken.setHidden(true);
                this.mService.mOpeningApps.add(focusedToken);
            }
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        wtoken.setVisibility(null, visible, -1, true, wtoken.mVoiceInteraction);
        wtoken.updateReportedVisibilityLocked();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUnknownVisibilityLaunched() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) {
                    this.mService.mUnknownAppVisibilityController.notifyLaunched((AppWindowToken)this.mContainer);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean addStartingWindow(String pkg, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int logo, int windowFlags, IBinder transferFrom, boolean newTask, boolean taskSwitch, boolean processRunning, boolean allowTaskSnapshot, boolean activityCreated, boolean fromRecents) {
        block25: {
            int type;
            block24: {
                block20: {
                    boolean windowShowWallpaper;
                    block23: {
                        boolean windowDisableStarting;
                        boolean windowIsFloating;
                        block22: {
                            AttributeCache.Entry ent;
                            block21: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    boolean bl;
                                                    WindowHashMap windowHashMap = this.mWindowMap;
                                                    // MONITORENTER : windowHashMap
                                                    try {
                                                        WindowManagerService.boostPriorityForLockedSection();
                                                        if (this.mContainer != null) break block15;
                                                        Slog.w("WindowManager", "Attempted to set icon of non-existing app token: " + this.mToken);
                                                        bl = false;
                                                        // MONITOREXIT : windowHashMap
                                                    }
                                                    catch (Throwable throwable) {
                                                        // MONITOREXIT : windowHashMap
                                                        WindowManagerService.resetPriorityAfterLockedSection();
                                                        throw throwable;
                                                    }
                                                    WindowManagerService.resetPriorityAfterLockedSection();
                                                    return bl;
                                                }
                                                if (((AppWindowToken)this.mContainer).okToDisplay()) break block16;
                                                boolean bl = false;
                                                // MONITOREXIT : windowHashMap
                                                WindowManagerService.resetPriorityAfterLockedSection();
                                                return bl;
                                            }
                                            if (((AppWindowToken)this.mContainer).startingData == null) break block17;
                                            boolean bl = false;
                                            // MONITOREXIT : windowHashMap
                                            WindowManagerService.resetPriorityAfterLockedSection();
                                            return bl;
                                        }
                                        WindowState mainWin = ((AppWindowToken)this.mContainer).findMainWindow();
                                        if (mainWin == null || !mainWin.mWinAnimator.getShown()) break block18;
                                        boolean bl = false;
                                        // MONITOREXIT : windowHashMap
                                        WindowManagerService.resetPriorityAfterLockedSection();
                                        return bl;
                                    }
                                    ActivityManager.TaskSnapshot snapshot = this.mService.mTaskSnapshotController.getSnapshot(((AppWindowToken)this.mContainer).getTask().mTaskId, ((AppWindowToken)this.mContainer).getTask().mUserId, false, false);
                                    type = this.getStartingWindowType(newTask, taskSwitch, processRunning, allowTaskSnapshot, activityCreated, fromRecents, snapshot);
                                    if (type != 1) break block19;
                                    boolean bl = this.createSnapshot(snapshot);
                                    // MONITOREXIT : windowHashMap
                                    WindowManagerService.resetPriorityAfterLockedSection();
                                    return bl;
                                }
                                if (theme == 0) break block20;
                                ent = AttributeCache.instance().get(pkg, theme, R.styleable.Window, this.mService.mCurrentUserId);
                                if (ent != null) break block21;
                                boolean bl = false;
                                // MONITOREXIT : windowHashMap
                                WindowManagerService.resetPriorityAfterLockedSection();
                                return bl;
                            }
                            boolean windowIsTranslucent = ent.array.getBoolean(5, false);
                            windowIsFloating = ent.array.getBoolean(4, false);
                            windowShowWallpaper = ent.array.getBoolean(14, false);
                            windowDisableStarting = ent.array.getBoolean(12, false);
                            if (!windowIsTranslucent) break block22;
                            boolean bl = false;
                            // MONITOREXIT : windowHashMap
                            WindowManagerService.resetPriorityAfterLockedSection();
                            return bl;
                        }
                        if (!windowIsFloating && !windowDisableStarting) break block23;
                        boolean bl = false;
                        // MONITOREXIT : windowHashMap
                        WindowManagerService.resetPriorityAfterLockedSection();
                        return bl;
                    }
                    if (!windowShowWallpaper) break block20;
                    if (((AppWindowToken)this.mContainer).getDisplayContent().mWallpaperController.getWallpaperTarget() == null) {
                        windowFlags |= 0x100000;
                        break block20;
                    }
                    boolean bl = false;
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return bl;
                }
                if (!((AppWindowToken)this.mContainer).transferStartingWindow(transferFrom)) break block24;
                boolean bl = true;
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                return bl;
            }
            if (type == 2) break block25;
            boolean bl = false;
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return bl;
        }
        ((AppWindowToken)this.mContainer).startingData = new SplashScreenStartingData(this.mService, pkg, theme, compatInfo, nonLocalizedLabel, labelRes, icon, logo, windowFlags, ((AppWindowToken)this.mContainer).getMergedOverrideConfiguration());
        this.scheduleAddStartingWindow();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
        return true;
    }

    private int getStartingWindowType(boolean newTask, boolean taskSwitch, boolean processRunning, boolean allowTaskSnapshot, boolean activityCreated, boolean fromRecents, ActivityManager.TaskSnapshot snapshot) {
        if (this.mService.mAppTransition.getAppTransition() == 19) {
            return 0;
        }
        if (newTask || !processRunning || taskSwitch && !activityCreated) {
            return 2;
        }
        if (taskSwitch && allowTaskSnapshot) {
            return snapshot == null ? 0 : (this.snapshotOrientationSameAsTask(snapshot) || fromRecents ? 1 : 2);
        }
        return 0;
    }

    void scheduleAddStartingWindow() {
        if (!this.mService.mAnimationHandler.hasCallbacks(this.mAddStartingWindow)) {
            this.mService.mAnimationHandler.postAtFrontOfQueue(this.mAddStartingWindow);
        }
    }

    private boolean createSnapshot(ActivityManager.TaskSnapshot snapshot) {
        if (snapshot == null) {
            return false;
        }
        ((AppWindowToken)this.mContainer).startingData = new SnapshotStartingData(this.mService, snapshot);
        this.scheduleAddStartingWindow();
        return true;
    }

    private boolean snapshotOrientationSameAsTask(ActivityManager.TaskSnapshot snapshot) {
        if (snapshot == null) {
            return false;
        }
        return ((AppWindowToken)this.mContainer).getTask().getConfiguration().orientation == snapshot.getOrientation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeStartingWindow() {
        WindowManagerPolicy.StartingSurface surface;
        block9: {
            block8: {
                block7: {
                    WindowHashMap windowHashMap = this.mWindowMap;
                    // MONITORENTER : windowHashMap
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (((AppWindowToken)this.mContainer).startingWindow != null) break block7;
                        if (((AppWindowToken)this.mContainer).startingData != null) {
                            ((AppWindowToken)this.mContainer).startingData = null;
                        }
                        // MONITOREXIT : windowHashMap
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : windowHashMap
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                if (((AppWindowToken)this.mContainer).startingData == null) break block8;
                surface = ((AppWindowToken)this.mContainer).startingSurface;
                ((AppWindowToken)this.mContainer).startingData = null;
                ((AppWindowToken)this.mContainer).startingSurface = null;
                ((AppWindowToken)this.mContainer).startingWindow = null;
                ((AppWindowToken)this.mContainer).startingDisplayed = false;
                if (surface != null) break block9;
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        this.mService.mAnimationHandler.post(() -> {
            try {
                surface.remove();
            }
            catch (Exception e) {
                Slog.w("WindowManager", "Exception when removing starting window", e);
            }
        });
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseKeyDispatching() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) {
                    this.mService.mInputMonitor.pauseDispatchingLw((WindowToken)this.mContainer);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeKeyDispatching() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) {
                    this.mService.mInputMonitor.resumeDispatchingLw((WindowToken)this.mContainer);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void notifyAppResumed(boolean wasStopped) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                Slog.w("WindowManager", "Attempted to notify resumed of non-existing app token: " + this.mToken);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((AppWindowToken)this.mContainer).notifyAppResumed(wasStopped);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void notifyAppStopping() {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                Slog.w("WindowManager", "Attempted to notify stopping on non-existing app token: " + this.mToken);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((AppWindowToken)this.mContainer).detachChildren();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void notifyAppStopped() {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                Slog.w("WindowManager", "Attempted to notify stopped of non-existing app token: " + this.mToken);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((AppWindowToken)this.mContainer).notifyAppStopped();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void startFreezingScreen(int configChanges) {
        block6: {
            block5: {
                WindowHashMap windowHashMap = this.mWindowMap;
                // MONITORENTER : windowHashMap
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (this.mContainer != null) break block5;
                    Slog.w("WindowManager", "Attempted to freeze screen with non-existing app token: " + this.mContainer);
                    // MONITOREXIT : windowHashMap
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            if (configChanges != 0 || !((AppWindowToken)this.mContainer).okToDisplay()) break block6;
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((AppWindowToken)this.mContainer).startFreezingScreen();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stopFreezingScreen(boolean force) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((AppWindowToken)this.mContainer).stopFreezingScreen(true, force);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void registerRemoteAnimations(RemoteAnimationDefinition definition) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                Slog.w("WindowManager", "Attempted to register remote animations with non-existing app token: " + this.mToken);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((AppWindowToken)this.mContainer).registerRemoteAnimations(definition);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void reportStartingWindowDrawn() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    void reportWindowsDrawn() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
    }

    void reportWindowsVisible() {
        this.mHandler.post(this.mOnWindowsVisible);
    }

    void reportWindowsGone() {
        this.mHandler.post(this.mOnWindowsGone);
    }

    boolean keyDispatchingTimedOut(String reason, int windowPid) {
        return this.mListener != null && ((AppWindowContainerListener)this.mListener).keyDispatchingTimedOut(reason, windowPid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setWillCloseOrEnterPip(boolean willCloseOrEnterPip) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((AppWindowToken)this.mContainer).setWillCloseOrEnterPip(willCloseOrEnterPip);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    public String toString() {
        return "AppWindowContainerController{ token=" + this.mToken + " mContainer=" + this.mContainer + " mListener=" + this.mListener + "}";
    }

    private final class H
    extends Handler {
        public static final int NOTIFY_WINDOWS_DRAWN = 1;
        public static final int NOTIFY_STARTING_WINDOW_DRAWN = 2;

        public H(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (AppWindowContainerController.this.mListener == null) {
                        return;
                    }
                    ((AppWindowContainerListener)AppWindowContainerController.this.mListener).onWindowsDrawn(msg.getWhen());
                    break;
                }
                case 2: {
                    if (AppWindowContainerController.this.mListener == null) {
                        return;
                    }
                    ((AppWindowContainerListener)AppWindowContainerController.this.mListener).onStartingWindowDrawn(msg.getWhen());
                    break;
                }
            }
        }
    }
}

