/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.hardware.display.DisplayManagerInternal;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.InputDevice;
import android.view.MagnificationSpec;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ToBooleanFunction;
import com.android.internal.view.IInputMethodClient;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppTransition;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.Dimmer;
import com.android.server.wm.DisplayFrames;
import com.android.server.wm.DisplayWindowController;
import com.android.server.wm.DockedStackDividerController;
import com.android.server.wm.PinnedStackController;
import com.android.server.wm.RootWindowContainer;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.StackWindowController;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TaskTapPointerEventListener;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowSurfacePlacer;
import com.android.server.wm.WindowToken;
import com.android.server.wm.utils.CoordinateTransforms;
import com.android.server.wm.utils.RotationCache;
import com.android.server.wm.utils.WmDisplayCutout;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

class DisplayContent
extends WindowContainer<DisplayChildWindowContainer> {
    private static final String TAG = "WindowManager";
    private final int mDisplayId;
    private final TaskStackContainers mTaskStackContainers;
    private final AboveAppWindowContainers mAboveAppWindowsContainers;
    private final NonAppWindowContainers mBelowAppWindowsContainers;
    private final NonMagnifiableWindowContainers mImeWindowsContainers;
    private WindowState mTmpWindow;
    private WindowState mTmpWindow2;
    private WindowAnimator mTmpWindowAnimator;
    private boolean mTmpRecoveringMemory;
    private boolean mUpdateImeTarget;
    private boolean mTmpInitial;
    private int mMaxUiWidth;
    private final HashMap<IBinder, WindowToken> mTokenMap;
    int mInitialDisplayWidth;
    int mInitialDisplayHeight;
    int mInitialDisplayDensity;
    DisplayCutout mInitialDisplayCutout;
    private final RotationCache<DisplayCutout, WmDisplayCutout> mDisplayCutoutCache;
    int mBaseDisplayWidth;
    int mBaseDisplayHeight;
    int mBaseDisplayDensity;
    boolean mDisplayScalingDisabled;
    private final DisplayInfo mDisplayInfo;
    private final Display mDisplay;
    private final DisplayMetrics mDisplayMetrics;
    DisplayFrames mDisplayFrames;
    final DisplayMetrics mRealDisplayMetrics;
    private final DisplayMetrics mTmpDisplayMetrics;
    private final DisplayMetrics mCompatDisplayMetrics;
    float mCompatibleScreenScale;
    private int mRotation;
    private int mLastOrientation;
    private boolean mAltOrientation;
    private int mLastWindowForcedOrientation;
    private int mLastKeyguardForcedOrientation;
    private boolean mLastWallpaperVisible;
    private Rect mBaseDisplayRect;
    private boolean mLayoutNeeded;
    int pendingLayoutChanges;
    boolean isDefaultDisplay;
    boolean mShouldOverrideDisplayConfiguration;
    final ArrayList<WindowToken> mExitingTokens;
    TaskTapPointerEventListener mTapDetector;
    private Region mTouchExcludeRegion;
    private final Rect mTmpRect;
    private final Rect mTmpRect2;
    private final RectF mTmpRectF;
    private final Matrix mTmpMatrix;
    private final Region mTmpRegion;
    private final Rect mTmpBounds;
    private boolean mDeferredRemoval;
    final DockedStackDividerController mDividerControllerLocked;
    final PinnedStackController mPinnedStackControllerLocked;
    final ArrayList<WindowState> mTapExcludedWindows;
    final ArraySet<WindowState> mTapExcludeProvidingWindows;
    private boolean mHaveBootMsg;
    private boolean mHaveApp;
    private boolean mHaveWallpaper;
    private boolean mHaveKeyguard;
    private final LinkedList<AppWindowToken> mTmpUpdateAllDrawn;
    private final TaskForResizePointSearchResult mTmpTaskForResizePointSearchResult;
    private final ApplySurfaceChangesTransactionState mTmpApplySurfaceChangesTransactionState;
    private boolean mRemovingDisplay;
    private boolean mDisplayReady;
    WallpaperController mWallpaperController;
    private final SurfaceSession mSession;
    private SurfaceControl mOverlayLayer;
    private SurfaceControl mWindowingLayer;
    private int mSurfaceSize;
    int mLayoutSeq;
    private int mDeferUpdateImeTargetCount;
    private final float[] mTmpFloats;
    private MagnificationSpec mMagnificationSpec;
    private final Consumer<WindowState> mUpdateWindowsForAnimator;
    private final Consumer<WindowState> mUpdateWallpaperForAnimator;
    private final Consumer<WindowState> mScheduleToastTimeout;
    private final ToBooleanFunction<WindowState> mFindFocusedWindow;
    private final Consumer<WindowState> mPerformLayout;
    private final Consumer<WindowState> mPerformLayoutAttached;
    private final Predicate<WindowState> mComputeImeTargetPredicate;
    private final Consumer<WindowState> mApplyPostLayoutPolicy;
    private final Consumer<WindowState> mApplySurfaceChangesTransaction;

    DisplayContent(Display display, WindowManagerService service, WallpaperController wallpaperController, DisplayWindowController controller) {
        super(service);
        this.mTaskStackContainers = new TaskStackContainers(this.mService);
        this.mAboveAppWindowsContainers = new AboveAppWindowContainers("mAboveAppWindowsContainers", this.mService);
        this.mBelowAppWindowsContainers = new NonAppWindowContainers("mBelowAppWindowsContainers", this.mService);
        this.mImeWindowsContainers = new NonMagnifiableWindowContainers("mImeWindowsContainers", this.mService);
        this.mTokenMap = new HashMap();
        this.mInitialDisplayWidth = 0;
        this.mInitialDisplayHeight = 0;
        this.mInitialDisplayDensity = 0;
        this.mDisplayCutoutCache = new RotationCache<DisplayCutout, WmDisplayCutout>(this::calculateDisplayCutoutForRotationUncached);
        this.mBaseDisplayWidth = 0;
        this.mBaseDisplayHeight = 0;
        this.mBaseDisplayDensity = 0;
        this.mDisplayInfo = new DisplayInfo();
        this.mDisplayMetrics = new DisplayMetrics();
        this.mRealDisplayMetrics = new DisplayMetrics();
        this.mTmpDisplayMetrics = new DisplayMetrics();
        this.mCompatDisplayMetrics = new DisplayMetrics();
        this.mRotation = 0;
        this.mLastOrientation = -1;
        this.mAltOrientation = false;
        this.mLastWindowForcedOrientation = -1;
        this.mLastKeyguardForcedOrientation = -1;
        this.mLastWallpaperVisible = false;
        this.mBaseDisplayRect = new Rect();
        this.mShouldOverrideDisplayConfiguration = true;
        this.mExitingTokens = new ArrayList();
        this.mTouchExcludeRegion = new Region();
        this.mTmpRect = new Rect();
        this.mTmpRect2 = new Rect();
        this.mTmpRectF = new RectF();
        this.mTmpMatrix = new Matrix();
        this.mTmpRegion = new Region();
        this.mTmpBounds = new Rect();
        this.mTapExcludedWindows = new ArrayList();
        this.mTapExcludeProvidingWindows = new ArraySet();
        this.mHaveBootMsg = false;
        this.mHaveApp = false;
        this.mHaveWallpaper = false;
        this.mHaveKeyguard = true;
        this.mTmpUpdateAllDrawn = new LinkedList();
        this.mTmpTaskForResizePointSearchResult = new TaskForResizePointSearchResult();
        this.mTmpApplySurfaceChangesTransactionState = new ApplySurfaceChangesTransactionState();
        this.mRemovingDisplay = false;
        this.mDisplayReady = false;
        this.mSession = new SurfaceSession();
        this.mLayoutSeq = 0;
        this.mTmpFloats = new float[9];
        this.mUpdateWindowsForAnimator = w -> {
            WindowStateAnimator winAnimator = w.mWinAnimator;
            AppWindowToken atoken = w.mAppToken;
            if (winAnimator.mDrawState == 3 && (atoken == null || atoken.canShowWindows()) && w.performShowLocked()) {
                this.pendingLayoutChanges |= 8;
            }
        };
        this.mUpdateWallpaperForAnimator = w -> {
            AppWindowToken atoken;
            AnimationAdapter animation;
            AnimationAdapter anim2;
            WindowStateAnimator winAnimator = w.mWinAnimator;
            if (winAnimator.mSurfaceController == null || !winAnimator.hasSurface()) {
                return;
            }
            int flags = w.mAttrs.flags;
            if (winAnimator.isAnimationSet() && (anim2 = w.getAnimation()) != null) {
                TaskStack stack;
                int color2;
                if ((flags & 0x100000) != 0 && anim2.getDetachWallpaper()) {
                    this.mTmpWindow = w;
                }
                if ((color2 = anim2.getBackgroundColor()) != 0 && (stack = w.getStack()) != null) {
                    stack.setAnimationBackground(winAnimator, color2);
                }
            }
            AnimationAdapter animationAdapter = animation = (atoken = winAnimator.mWin.mAppToken) != null ? atoken.getAnimation() : null;
            if (animation != null) {
                TaskStack stack;
                int color3;
                if ((flags & 0x100000) != 0 && animation.getDetachWallpaper()) {
                    this.mTmpWindow = w;
                }
                if ((color3 = animation.getBackgroundColor()) != 0 && (stack = w.getStack()) != null) {
                    stack.setAnimationBackground(winAnimator, color3);
                }
            }
        };
        this.mScheduleToastTimeout = w -> {
            int lostFocusUid = this.mTmpWindow.mOwnerUid;
            WindowManagerService.H handler = this.mService.mH;
            if (w.mAttrs.type == 2005 && w.mOwnerUid == lostFocusUid && !handler.hasMessages(52, w)) {
                handler.sendMessageDelayed(handler.obtainMessage(52, w), w.mAttrs.hideTimeoutMilliseconds);
            }
        };
        this.mFindFocusedWindow = w -> {
            AppWindowToken focusedApp = this.mService.mFocusedApp;
            if (!w.canReceiveKeys()) {
                return false;
            }
            AppWindowToken wtoken = w.mAppToken;
            if (wtoken != null && (wtoken.removed || wtoken.sendingToBottom)) {
                return false;
            }
            if (focusedApp == null) {
                this.mTmpWindow = w;
                return true;
            }
            if (!focusedApp.windowsAreFocusable()) {
                this.mTmpWindow = w;
                return true;
            }
            if (wtoken != null && w.mAttrs.type != 3 && focusedApp.compareTo(wtoken) > 0) {
                this.mTmpWindow = null;
                return true;
            }
            this.mTmpWindow = w;
            return true;
        };
        this.mPerformLayout = w -> {
            boolean gone;
            boolean bl = gone = this.mTmpWindow != null && this.mService.mPolicy.canBeHiddenByKeyguardLw((WindowManagerPolicy.WindowState)w) || w.isGoneForLayoutLw();
            if ((!gone || !w.mHaveFrame || w.mLayoutNeeded || (w.isConfigChanged() || w.setReportResizeHints()) && !w.isGoneForLayoutLw() && ((w.mAttrs.privateFlags & 0x400) != 0 || w.mHasSurface && w.mAppToken != null && w.mAppToken.layoutConfigChanges)) && !w.mLayoutAttached) {
                if (this.mTmpInitial) {
                    w.mContentChanged = false;
                }
                if (w.mAttrs.type == 2023) {
                    this.mTmpWindow = w;
                }
                w.mLayoutNeeded = false;
                w.prelayout();
                boolean firstLayout = !w.isLaidOut();
                this.mService.mPolicy.layoutWindowLw((WindowManagerPolicy.WindowState)w, null, this.mDisplayFrames);
                w.mLayoutSeq = this.mLayoutSeq;
                if (firstLayout) {
                    w.updateLastInsetValues();
                }
                if (w.mAppToken != null) {
                    w.mAppToken.layoutLetterbox((WindowState)w);
                }
            }
        };
        this.mPerformLayoutAttached = w -> {
            if (w.mLayoutAttached) {
                if (this.mTmpWindow != null && this.mService.mPolicy.canBeHiddenByKeyguardLw((WindowManagerPolicy.WindowState)w)) {
                    return;
                }
                if (w.mViewVisibility != 8 && w.mRelayoutCalled || !w.mHaveFrame || w.mLayoutNeeded) {
                    if (this.mTmpInitial) {
                        w.mContentChanged = false;
                    }
                    w.mLayoutNeeded = false;
                    w.prelayout();
                    this.mService.mPolicy.layoutWindowLw((WindowManagerPolicy.WindowState)w, w.getParentWindow(), this.mDisplayFrames);
                    w.mLayoutSeq = this.mLayoutSeq;
                }
            } else if (w.mAttrs.type == 2023) {
                this.mTmpWindow = this.mTmpWindow2;
            }
        };
        this.mComputeImeTargetPredicate = w -> w.canBeImeTarget();
        this.mApplyPostLayoutPolicy = w -> this.mService.mPolicy.applyPostLayoutPolicyLw((WindowManagerPolicy.WindowState)w, w.mAttrs, w.getParentWindow(), this.mService.mInputMethodTarget);
        this.mApplySurfaceChangesTransaction = w -> {
            AppWindowToken atoken;
            WindowSurfacePlacer surfacePlacer = this.mService.mWindowPlacerLocked;
            boolean obscuredChanged = w.mObscured != this.mTmpApplySurfaceChangesTransactionState.obscured;
            RootWindowContainer root = this.mService.mRoot;
            boolean someoneLosingFocus = !this.mService.mLosingFocus.isEmpty();
            w.mObscured = this.mTmpApplySurfaceChangesTransactionState.obscured;
            if (!this.mTmpApplySurfaceChangesTransactionState.obscured) {
                boolean isDisplayed = w.isDisplayedLw();
                if (isDisplayed && w.isObscuringDisplay()) {
                    root.mObscuringWindow = w;
                    this.mTmpApplySurfaceChangesTransactionState.obscured = true;
                }
                this.mTmpApplySurfaceChangesTransactionState.displayHasContent |= root.handleNotObscuredLocked((WindowState)w, this.mTmpApplySurfaceChangesTransactionState.obscured, this.mTmpApplySurfaceChangesTransactionState.syswin);
                if (w.mHasSurface && isDisplayed) {
                    int type = w.mAttrs.type;
                    if (type == 2008 || type == 2010 || (w.mAttrs.privateFlags & 0x400) != 0) {
                        this.mTmpApplySurfaceChangesTransactionState.syswin = true;
                    }
                    if (this.mTmpApplySurfaceChangesTransactionState.preferredRefreshRate == 0.0f && w.mAttrs.preferredRefreshRate != 0.0f) {
                        this.mTmpApplySurfaceChangesTransactionState.preferredRefreshRate = w.mAttrs.preferredRefreshRate;
                    }
                    if (this.mTmpApplySurfaceChangesTransactionState.preferredModeId == 0 && w.mAttrs.preferredDisplayModeId != 0) {
                        this.mTmpApplySurfaceChangesTransactionState.preferredModeId = w.mAttrs.preferredDisplayModeId;
                    }
                }
            }
            if (this.isDefaultDisplay && obscuredChanged && w.isVisibleLw() && this.mWallpaperController.isWallpaperTarget((WindowState)w)) {
                this.mWallpaperController.updateWallpaperVisibility();
            }
            w.handleWindowMovedIfNeeded();
            WindowStateAnimator winAnimator = w.mWinAnimator;
            w.mContentChanged = false;
            if (w.mHasSurface) {
                boolean committed = winAnimator.commitFinishDrawingLocked();
                if (this.isDefaultDisplay && committed) {
                    if (w.mAttrs.type == 2023) {
                        this.pendingLayoutChanges |= 1;
                    }
                    if ((w.mAttrs.flags & 0x100000) != 0) {
                        root.mWallpaperMayChange = true;
                        this.pendingLayoutChanges |= 4;
                    }
                }
            }
            if ((atoken = w.mAppToken) != null) {
                atoken.updateLetterboxSurface((WindowState)w);
                boolean updateAllDrawn = atoken.updateDrawnWindowStates((WindowState)w);
                if (updateAllDrawn && !this.mTmpUpdateAllDrawn.contains(atoken)) {
                    this.mTmpUpdateAllDrawn.add(atoken);
                }
            }
            if (this.isDefaultDisplay && someoneLosingFocus && w == this.mService.mCurrentFocus && w.isDisplayedLw()) {
                this.mTmpApplySurfaceChangesTransactionState.focusDisplayed = true;
            }
            w.updateResizingWindowIfNeeded();
        };
        this.setController(controller);
        if (service.mRoot.getDisplayContent(display.getDisplayId()) != null) {
            throw new IllegalArgumentException("Display with ID=" + display.getDisplayId() + " already exists=" + service.mRoot.getDisplayContent(display.getDisplayId()) + " new=" + display);
        }
        this.mDisplay = display;
        this.mDisplayId = display.getDisplayId();
        this.mWallpaperController = wallpaperController;
        display.getDisplayInfo(this.mDisplayInfo);
        display.getMetrics(this.mDisplayMetrics);
        this.isDefaultDisplay = this.mDisplayId == 0;
        this.mDisplayFrames = new DisplayFrames(this.mDisplayId, this.mDisplayInfo, this.calculateDisplayCutoutForRotation(this.mDisplayInfo.rotation));
        this.initializeDisplayBaseInfo();
        this.mDividerControllerLocked = new DockedStackDividerController(service, this);
        this.mPinnedStackControllerLocked = new PinnedStackController(service, this);
        this.mSurfaceSize = Math.max(this.mBaseDisplayHeight, this.mBaseDisplayWidth) * 2;
        SurfaceControl.Builder b = this.mService.makeSurfaceBuilder(this.mSession).setSize(this.mSurfaceSize, this.mSurfaceSize).setOpaque(true);
        this.mWindowingLayer = b.setName("Display Root").build();
        this.mOverlayLayer = b.setName("Display Overlays").build();
        this.getPendingTransaction().setLayer(this.mWindowingLayer, 0).setLayerStack(this.mWindowingLayer, this.mDisplayId).show(this.mWindowingLayer).setLayer(this.mOverlayLayer, 1).setLayerStack(this.mOverlayLayer, this.mDisplayId).show(this.mOverlayLayer);
        this.getPendingTransaction().apply();
        super.addChild(this.mBelowAppWindowsContainers, null);
        super.addChild(this.mTaskStackContainers, null);
        super.addChild(this.mAboveAppWindowsContainers, null);
        super.addChild(this.mImeWindowsContainers, null);
        this.mService.mRoot.addChild(this, null);
        this.mDisplayReady = true;
    }

    boolean isReady() {
        return this.mService.mDisplayReady && this.mDisplayReady;
    }

    int getDisplayId() {
        return this.mDisplayId;
    }

    WindowToken getWindowToken(IBinder binder) {
        return this.mTokenMap.get(binder);
    }

    AppWindowToken getAppWindowToken(IBinder binder) {
        WindowToken token = this.getWindowToken(binder);
        if (token == null) {
            return null;
        }
        return token.asAppWindowToken();
    }

    private void addWindowToken(IBinder binder, WindowToken token) {
        DisplayContent dc = this.mService.mRoot.getWindowTokenDisplay(token);
        if (dc != null) {
            throw new IllegalArgumentException("Can't map token=" + token + " to display=" + this.getName() + " already mapped to display=" + dc + " tokens=" + dc.mTokenMap);
        }
        if (binder == null) {
            throw new IllegalArgumentException("Can't map token=" + token + " to display=" + this.getName() + " binder is null");
        }
        if (token == null) {
            throw new IllegalArgumentException("Can't map null token to display=" + this.getName() + " binder=" + binder);
        }
        this.mTokenMap.put(binder, token);
        if (token.asAppWindowToken() == null) {
            switch (token.windowType) {
                case 2013: {
                    this.mBelowAppWindowsContainers.addChild(token);
                    break;
                }
                case 2011: 
                case 2012: {
                    this.mImeWindowsContainers.addChild(token);
                    break;
                }
                default: {
                    this.mAboveAppWindowsContainers.addChild(token);
                }
            }
        }
    }

    WindowToken removeWindowToken(IBinder binder) {
        WindowToken token = this.mTokenMap.remove(binder);
        if (token != null && token.asAppWindowToken() == null) {
            token.setExiting();
        }
        return token;
    }

    void reParentWindowToken(WindowToken token) {
        DisplayContent prevDc = token.getDisplayContent();
        if (prevDc == this) {
            return;
        }
        if (prevDc != null && prevDc.mTokenMap.remove(token.token) != null && token.asAppWindowToken() == null) {
            token.getParent().removeChild(token);
        }
        this.addWindowToken(token.token, token);
    }

    void removeAppToken(IBinder binder) {
        WindowToken token = this.removeWindowToken(binder);
        if (token == null) {
            Slog.w(TAG, "removeAppToken: Attempted to remove non-existing token: " + binder);
            return;
        }
        AppWindowToken appToken = token.asAppWindowToken();
        if (appToken == null) {
            Slog.w(TAG, "Attempted to remove non-App token: " + binder + " token=" + token);
            return;
        }
        appToken.onRemovedFromDisplay();
    }

    Display getDisplay() {
        return this.mDisplay;
    }

    DisplayInfo getDisplayInfo() {
        return this.mDisplayInfo;
    }

    DisplayMetrics getDisplayMetrics() {
        return this.mDisplayMetrics;
    }

    int getRotation() {
        return this.mRotation;
    }

    @VisibleForTesting
    void setRotation(int newRotation) {
        this.mRotation = newRotation;
    }

    int getLastOrientation() {
        return this.mLastOrientation;
    }

    void setLastOrientation(int orientation) {
        this.mLastOrientation = orientation;
    }

    boolean getAltOrientation() {
        return this.mAltOrientation;
    }

    void setAltOrientation(boolean altOrientation) {
        this.mAltOrientation = altOrientation;
    }

    int getLastWindowForcedOrientation() {
        return this.mLastWindowForcedOrientation;
    }

    boolean updateRotationUnchecked() {
        return this.updateRotationUnchecked(false);
    }

    boolean updateRotationUnchecked(boolean forceUpdate) {
        boolean altOrientation;
        ScreenRotationAnimation screenRotationAnimation;
        if (!forceUpdate) {
            if (this.mService.mDeferredRotationPauseCount > 0) {
                return false;
            }
            screenRotationAnimation = this.mService.mAnimator.getScreenRotationAnimationLocked(this.mDisplayId);
            if (screenRotationAnimation != null && screenRotationAnimation.isAnimating()) {
                return false;
            }
            if (this.mService.mDisplayFrozen) {
                return false;
            }
        }
        if (!this.mService.mDisplayEnabled) {
            return false;
        }
        int oldRotation = this.mRotation;
        int lastOrientation = this.mLastOrientation;
        boolean oldAltOrientation = this.mAltOrientation;
        int rotation = this.mService.mPolicy.rotationForOrientationLw(lastOrientation, oldRotation, this.isDefaultDisplay);
        boolean mayRotateSeamlessly = this.mService.mPolicy.shouldRotateSeamlessly(oldRotation, rotation);
        if (mayRotateSeamlessly) {
            WindowState seamlessRotated = this.getWindow(w -> w.mSeamlesslyRotated);
            if (seamlessRotated != null && !forceUpdate) {
                return false;
            }
            if (this.hasPinnedStack()) {
                mayRotateSeamlessly = false;
            }
            for (int i = 0; i < this.mService.mSessions.size(); ++i) {
                if (!this.mService.mSessions.valueAt(i).hasAlertWindowSurfaces()) continue;
                mayRotateSeamlessly = false;
                break;
            }
        }
        boolean rotateSeamlessly = mayRotateSeamlessly;
        boolean bl = altOrientation = !this.mService.mPolicy.rotationHasCompatibleMetricsLw(lastOrientation, rotation);
        if (oldRotation == rotation && oldAltOrientation == altOrientation) {
            return false;
        }
        if (DisplayContent.deltaRotation(rotation, oldRotation) != 2) {
            this.mService.mWaitingForConfig = true;
        }
        this.mRotation = rotation;
        this.mAltOrientation = altOrientation;
        if (this.isDefaultDisplay) {
            this.mService.mPolicy.setRotationLw(rotation);
        }
        this.mService.mWindowsFreezingScreen = 1;
        this.mService.mH.removeMessages(11);
        this.mService.mH.sendEmptyMessageDelayed(11, 2000L);
        this.setLayoutNeeded();
        int[] anim2 = new int[2];
        this.mService.mPolicy.selectRotationAnimationLw(anim2);
        if (!rotateSeamlessly) {
            this.mService.startFreezingDisplayLocked(anim2[0], anim2[1], this);
            screenRotationAnimation = this.mService.mAnimator.getScreenRotationAnimationLocked(this.mDisplayId);
        } else {
            screenRotationAnimation = null;
            this.mService.startSeamlessRotation();
        }
        this.updateDisplayAndOrientation(this.getConfiguration().uiMode);
        if (screenRotationAnimation != null && screenRotationAnimation.hasScreenshot() && screenRotationAnimation.setRotation(this.getPendingTransaction(), rotation, 10000L, this.mService.getTransitionAnimationScaleLocked(), this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight)) {
            this.mService.scheduleAnimationLocked();
        }
        this.forAllWindows((WindowState w) -> w.forceSeamlesslyRotateIfAllowed(oldRotation, rotation), true);
        if (rotateSeamlessly) {
            this.seamlesslyRotate(this.getPendingTransaction(), oldRotation, rotation);
        }
        this.mService.mDisplayManagerInternal.performTraversal(this.getPendingTransaction());
        this.scheduleAnimation();
        this.forAllWindows((WindowState w) -> {
            if (w.mHasSurface && !rotateSeamlessly) {
                w.setOrientationChanging(true);
                this.mService.mRoot.mOrientationChangeComplete = false;
                w.mLastFreezeDuration = 0;
            }
            w.mReportOrientationChanged = true;
        }, true);
        if (rotateSeamlessly) {
            this.mService.mH.removeMessages(54);
            this.mService.mH.sendEmptyMessageDelayed(54, 2000L);
        }
        for (int i = this.mService.mRotationWatchers.size() - 1; i >= 0; --i) {
            WindowManagerService.RotationWatcher rotationWatcher = this.mService.mRotationWatchers.get(i);
            if (rotationWatcher.mDisplayId != this.mDisplayId) continue;
            try {
                rotationWatcher.mWatcher.onRotationChanged(rotation);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (screenRotationAnimation == null && this.mService.mAccessibilityController != null && this.isDefaultDisplay) {
            this.mService.mAccessibilityController.onRotationChangedLocked(this);
        }
        return true;
    }

    void configureDisplayPolicy() {
        this.mService.mPolicy.setInitialDisplaySize(this.getDisplay(), this.mBaseDisplayWidth, this.mBaseDisplayHeight, this.mBaseDisplayDensity);
        this.mDisplayFrames.onDisplayInfoUpdated(this.mDisplayInfo, this.calculateDisplayCutoutForRotation(this.mDisplayInfo.rotation));
    }

    private DisplayInfo updateDisplayAndOrientation(int uiMode) {
        boolean rotated = this.mRotation == 1 || this.mRotation == 3;
        int realdw = rotated ? this.mBaseDisplayHeight : this.mBaseDisplayWidth;
        int realdh = rotated ? this.mBaseDisplayWidth : this.mBaseDisplayHeight;
        int dw = realdw;
        int dh = realdh;
        if (this.mAltOrientation) {
            if (realdw > realdh) {
                int maxw = (int)((float)realdh / 1.3f);
                if (maxw < realdw) {
                    dw = maxw;
                }
            } else {
                int maxh = (int)((float)realdw / 1.3f);
                if (maxh < realdh) {
                    dh = maxh;
                }
            }
        }
        WmDisplayCutout wmDisplayCutout = this.calculateDisplayCutoutForRotation(this.mRotation);
        DisplayCutout displayCutout = wmDisplayCutout.getDisplayCutout();
        int appWidth = this.mService.mPolicy.getNonDecorDisplayWidth(dw, dh, this.mRotation, uiMode, this.mDisplayId, displayCutout);
        int appHeight = this.mService.mPolicy.getNonDecorDisplayHeight(dw, dh, this.mRotation, uiMode, this.mDisplayId, displayCutout);
        this.mDisplayInfo.rotation = this.mRotation;
        this.mDisplayInfo.logicalWidth = dw;
        this.mDisplayInfo.logicalHeight = dh;
        this.mDisplayInfo.logicalDensityDpi = this.mBaseDisplayDensity;
        this.mDisplayInfo.appWidth = appWidth;
        this.mDisplayInfo.appHeight = appHeight;
        if (this.isDefaultDisplay) {
            this.mDisplayInfo.getLogicalMetrics(this.mRealDisplayMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
        }
        this.mDisplayInfo.displayCutout = displayCutout.isEmpty() ? null : displayCutout;
        this.mDisplayInfo.getAppMetrics(this.mDisplayMetrics);
        this.mDisplayInfo.flags = this.mDisplayScalingDisabled ? (this.mDisplayInfo.flags |= 0x40000000) : (this.mDisplayInfo.flags &= 0xBFFFFFFF);
        DisplayInfo overrideDisplayInfo = this.mShouldOverrideDisplayConfiguration ? this.mDisplayInfo : null;
        this.mService.mDisplayManagerInternal.setDisplayInfoOverrideFromWindowManager(this.mDisplayId, overrideDisplayInfo);
        this.mBaseDisplayRect.set(0, 0, dw, dh);
        if (this.isDefaultDisplay) {
            this.mCompatibleScreenScale = CompatibilityInfo.computeCompatibleScaling(this.mDisplayMetrics, this.mCompatDisplayMetrics);
        }
        this.updateBounds();
        return this.mDisplayInfo;
    }

    WmDisplayCutout calculateDisplayCutoutForRotation(int rotation) {
        return this.mDisplayCutoutCache.getOrCompute(this.mInitialDisplayCutout, rotation);
    }

    private WmDisplayCutout calculateDisplayCutoutForRotationUncached(DisplayCutout cutout, int rotation) {
        if (cutout == null || cutout == DisplayCutout.NO_CUTOUT) {
            return WmDisplayCutout.NO_CUTOUT;
        }
        if (rotation == 0) {
            return WmDisplayCutout.computeSafeInsets(cutout, this.mInitialDisplayWidth, this.mInitialDisplayHeight);
        }
        boolean rotated = rotation == 1 || rotation == 3;
        List<Rect> bounds = WmDisplayCutout.computeSafeInsets(cutout, this.mInitialDisplayWidth, this.mInitialDisplayHeight).getDisplayCutout().getBoundingRects();
        CoordinateTransforms.transformPhysicalToLogicalCoordinates(rotation, this.mInitialDisplayWidth, this.mInitialDisplayHeight, this.mTmpMatrix);
        Region region = Region.obtain();
        for (int i = 0; i < bounds.size(); ++i) {
            Rect rect = bounds.get(i);
            RectF rectF = new RectF(bounds.get(i));
            this.mTmpMatrix.mapRect(rectF);
            rectF.round(rect);
            region.op(rect, Region.Op.UNION);
        }
        return WmDisplayCutout.computeSafeInsets(DisplayCutout.fromBounds(region), rotated ? this.mInitialDisplayHeight : this.mInitialDisplayWidth, rotated ? this.mInitialDisplayWidth : this.mInitialDisplayHeight);
    }

    void computeScreenConfiguration(Configuration config) {
        boolean hardKeyboardAvailable;
        DisplayInfo displayInfo = this.updateDisplayAndOrientation(config.uiMode);
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        config.orientation = dw <= dh ? 1 : 2;
        config.windowConfiguration.setWindowingMode(1);
        float density = this.mDisplayMetrics.density;
        config.screenWidthDp = (int)((float)this.mService.mPolicy.getConfigDisplayWidth(dw, dh, displayInfo.rotation, config.uiMode, this.mDisplayId, displayInfo.displayCutout) / density);
        config.screenHeightDp = (int)((float)this.mService.mPolicy.getConfigDisplayHeight(dw, dh, displayInfo.rotation, config.uiMode, this.mDisplayId, displayInfo.displayCutout) / density);
        this.mService.mPolicy.getNonDecorInsetsLw(displayInfo.rotation, dw, dh, displayInfo.displayCutout, this.mTmpRect);
        int leftInset = this.mTmpRect.left;
        int topInset = this.mTmpRect.top;
        config.windowConfiguration.setAppBounds(leftInset, topInset, leftInset + displayInfo.appWidth, topInset + displayInfo.appHeight);
        boolean rotated = displayInfo.rotation == 1 || displayInfo.rotation == 3;
        this.computeSizeRangesAndScreenLayout(displayInfo, this.mDisplayId, rotated, config.uiMode, dw, dh, density, config);
        config.screenLayout = config.screenLayout & 0xFFFFFCFF | ((displayInfo.flags & 0x10) != 0 ? 512 : 256);
        config.compatScreenWidthDp = (int)((float)config.screenWidthDp / this.mCompatibleScreenScale);
        config.compatScreenHeightDp = (int)((float)config.screenHeightDp / this.mCompatibleScreenScale);
        config.compatSmallestScreenWidthDp = this.computeCompatSmallestWidth(rotated, config.uiMode, dw, dh, this.mDisplayId);
        config.densityDpi = displayInfo.logicalDensityDpi;
        config.colorMode = (displayInfo.isHdr() ? 8 : 4) | (displayInfo.isWideColorGamut() && this.mService.hasWideColorGamutSupport() ? 2 : 1);
        config.touchscreen = 1;
        config.keyboard = 1;
        config.navigation = 1;
        int keyboardPresence = 0;
        int navigationPresence = 0;
        InputDevice[] devices = this.mService.mInputManager.getInputDevices();
        int len = devices != null ? devices.length : 0;
        for (int i = 0; i < len; ++i) {
            int presenceFlag;
            InputDevice device = devices[i];
            if (device.isVirtual()) continue;
            int sources = device.getSources();
            int n = presenceFlag = device.isExternal() ? 2 : 1;
            if (this.mService.mIsTouchDevice) {
                if ((sources & 0x1002) == 4098) {
                    config.touchscreen = 3;
                }
            } else {
                config.touchscreen = 1;
            }
            if ((sources & 0x10004) == 65540) {
                config.navigation = 3;
                navigationPresence |= presenceFlag;
            } else if ((sources & 0x201) == 513 && config.navigation == 1) {
                config.navigation = 2;
                navigationPresence |= presenceFlag;
            }
            if (device.getKeyboardType() != 2) continue;
            config.keyboard = 2;
            keyboardPresence |= presenceFlag;
        }
        if (config.navigation == 1 && this.mService.mHasPermanentDpad) {
            config.navigation = 2;
            navigationPresence |= 1;
        }
        boolean bl = hardKeyboardAvailable = config.keyboard != 1;
        if (hardKeyboardAvailable != this.mService.mHardKeyboardAvailable) {
            this.mService.mHardKeyboardAvailable = hardKeyboardAvailable;
            this.mService.mH.removeMessages(22);
            this.mService.mH.sendEmptyMessage(22);
        }
        config.keyboardHidden = 1;
        config.hardKeyboardHidden = 1;
        config.navigationHidden = 1;
        this.mService.mPolicy.adjustConfigurationLw(config, keyboardPresence, navigationPresence);
    }

    private int computeCompatSmallestWidth(boolean rotated, int uiMode, int dw, int dh, int displayId) {
        int unrotDh;
        int unrotDw;
        this.mTmpDisplayMetrics.setTo(this.mDisplayMetrics);
        DisplayMetrics tmpDm = this.mTmpDisplayMetrics;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        int sw = this.reduceCompatConfigWidthSize(0, 0, uiMode, tmpDm, unrotDw, unrotDh, displayId);
        sw = this.reduceCompatConfigWidthSize(sw, 1, uiMode, tmpDm, unrotDh, unrotDw, displayId);
        sw = this.reduceCompatConfigWidthSize(sw, 2, uiMode, tmpDm, unrotDw, unrotDh, displayId);
        sw = this.reduceCompatConfigWidthSize(sw, 3, uiMode, tmpDm, unrotDh, unrotDw, displayId);
        return sw;
    }

    private int reduceCompatConfigWidthSize(int curSize, int rotation, int uiMode, DisplayMetrics dm, int dw, int dh, int displayId) {
        dm.noncompatWidthPixels = this.mService.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation, uiMode, displayId, this.mDisplayInfo.displayCutout);
        dm.noncompatHeightPixels = this.mService.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation, uiMode, displayId, this.mDisplayInfo.displayCutout);
        float scale = CompatibilityInfo.computeCompatibleScaling(dm, null);
        int size = (int)((float)dm.noncompatWidthPixels / scale / dm.density + 0.5f);
        if (curSize == 0 || size < curSize) {
            curSize = size;
        }
        return curSize;
    }

    private void computeSizeRangesAndScreenLayout(DisplayInfo displayInfo, int displayId, boolean rotated, int uiMode, int dw, int dh, float density, Configuration outConfig) {
        int unrotDh;
        int unrotDw;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        displayInfo.smallestNominalAppWidth = 0x40000000;
        displayInfo.smallestNominalAppHeight = 0x40000000;
        displayInfo.largestNominalAppWidth = 0;
        displayInfo.largestNominalAppHeight = 0;
        this.adjustDisplaySizeRanges(displayInfo, displayId, 0, uiMode, unrotDw, unrotDh);
        this.adjustDisplaySizeRanges(displayInfo, displayId, 1, uiMode, unrotDh, unrotDw);
        this.adjustDisplaySizeRanges(displayInfo, displayId, 2, uiMode, unrotDw, unrotDh);
        this.adjustDisplaySizeRanges(displayInfo, displayId, 3, uiMode, unrotDh, unrotDw);
        int sl = Configuration.resetScreenLayout(outConfig.screenLayout);
        sl = this.reduceConfigLayout(sl, 0, density, unrotDw, unrotDh, uiMode, displayId);
        sl = this.reduceConfigLayout(sl, 1, density, unrotDh, unrotDw, uiMode, displayId);
        sl = this.reduceConfigLayout(sl, 2, density, unrotDw, unrotDh, uiMode, displayId);
        sl = this.reduceConfigLayout(sl, 3, density, unrotDh, unrotDw, uiMode, displayId);
        outConfig.smallestScreenWidthDp = (int)((float)displayInfo.smallestNominalAppWidth / density);
        outConfig.screenLayout = sl;
    }

    private int reduceConfigLayout(int curLayout, int rotation, float density, int dw, int dh, int uiMode, int displayId) {
        int h;
        int shortSize;
        int w = this.mService.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation, uiMode, displayId, this.mDisplayInfo.displayCutout);
        int longSize = w;
        if (longSize < (shortSize = (h = this.mService.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation, uiMode, displayId, this.mDisplayInfo.displayCutout)))) {
            int tmp = longSize;
            longSize = shortSize;
            shortSize = tmp;
        }
        longSize = (int)((float)longSize / density);
        shortSize = (int)((float)shortSize / density);
        return Configuration.reduceScreenLayout(curLayout, longSize, shortSize);
    }

    private void adjustDisplaySizeRanges(DisplayInfo displayInfo, int displayId, int rotation, int uiMode, int dw, int dh) {
        int height;
        DisplayCutout displayCutout = this.calculateDisplayCutoutForRotation(rotation).getDisplayCutout();
        int width = this.mService.mPolicy.getConfigDisplayWidth(dw, dh, rotation, uiMode, displayId, displayCutout);
        if (width < displayInfo.smallestNominalAppWidth) {
            displayInfo.smallestNominalAppWidth = width;
        }
        if (width > displayInfo.largestNominalAppWidth) {
            displayInfo.largestNominalAppWidth = width;
        }
        if ((height = this.mService.mPolicy.getConfigDisplayHeight(dw, dh, rotation, uiMode, displayId, displayCutout)) < displayInfo.smallestNominalAppHeight) {
            displayInfo.smallestNominalAppHeight = height;
        }
        if (height > displayInfo.largestNominalAppHeight) {
            displayInfo.largestNominalAppHeight = height;
        }
    }

    DockedStackDividerController getDockedDividerController() {
        return this.mDividerControllerLocked;
    }

    PinnedStackController getPinnedStackController() {
        return this.mPinnedStackControllerLocked;
    }

    boolean hasAccess(int uid) {
        return this.mDisplay.hasAccess(uid);
    }

    boolean isPrivate() {
        return (this.mDisplay.getFlags() & 4) != 0;
    }

    TaskStack getHomeStack() {
        return this.mTaskStackContainers.getHomeStack();
    }

    TaskStack getSplitScreenPrimaryStack() {
        TaskStack stack = this.mTaskStackContainers.getSplitScreenPrimaryStack();
        return stack != null && stack.isVisible() ? stack : null;
    }

    boolean hasSplitScreenPrimaryStack() {
        return this.getSplitScreenPrimaryStack() != null;
    }

    TaskStack getSplitScreenPrimaryStackIgnoringVisibility() {
        return this.mTaskStackContainers.getSplitScreenPrimaryStack();
    }

    TaskStack getPinnedStack() {
        return this.mTaskStackContainers.getPinnedStack();
    }

    private boolean hasPinnedStack() {
        return this.mTaskStackContainers.getPinnedStack() != null;
    }

    TaskStack getTopStackInWindowingMode(int windowingMode) {
        return this.getStack(windowingMode, 0);
    }

    TaskStack getStack(int windowingMode, int activityType) {
        return this.mTaskStackContainers.getStack(windowingMode, activityType);
    }

    @VisibleForTesting
    TaskStack getTopStack() {
        return this.mTaskStackContainers.getTopStack();
    }

    ArrayList<Task> getVisibleTasks() {
        return this.mTaskStackContainers.getVisibleTasks();
    }

    void onStackWindowingModeChanged(TaskStack stack) {
        this.mTaskStackContainers.onStackWindowingModeChanged(stack);
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        PinnedStackController pinnedStackController;
        super.onConfigurationChanged(newParentConfig);
        this.mService.reconfigureDisplayLocked(this);
        DockedStackDividerController dividerController = this.getDockedDividerController();
        if (dividerController != null) {
            this.getDockedDividerController().onConfigurationChanged();
        }
        if ((pinnedStackController = this.getPinnedStackController()) != null) {
            this.getPinnedStackController().onConfigurationChanged();
        }
    }

    void updateStackBoundsAfterConfigChange(List<TaskStack> changedStackList) {
        for (int i = this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(i);
            if (!stack.updateBoundsAfterConfigChange()) continue;
            changedStackList.add(stack);
        }
        if (!this.hasPinnedStack()) {
            this.mPinnedStackControllerLocked.onDisplayInfoChanged();
        }
    }

    @Override
    boolean fillsParent() {
        return true;
    }

    @Override
    boolean isVisible() {
        return true;
    }

    @Override
    void onAppTransitionDone() {
        super.onAppTransitionDone();
        this.mService.mWindowsChanged = true;
    }

    private boolean skipTraverseChild(WindowContainer child) {
        return child == this.mImeWindowsContainers && this.mService.mInputMethodTarget != null && !this.hasSplitScreenPrimaryStack();
    }

    @Override
    boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        if (traverseTopToBottom) {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                DisplayChildWindowContainer child = (DisplayChildWindowContainer)this.mChildren.get(i);
                if (this.skipTraverseChild(child) || !child.forAllWindows(callback, traverseTopToBottom)) continue;
                return true;
            }
        } else {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                DisplayChildWindowContainer child = (DisplayChildWindowContainer)this.mChildren.get(i);
                if (this.skipTraverseChild(child) || !child.forAllWindows(callback, traverseTopToBottom)) continue;
                return true;
            }
        }
        return false;
    }

    boolean forAllImeWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        return this.mImeWindowsContainers.forAllWindows(callback, traverseTopToBottom);
    }

    @Override
    int getOrientation() {
        WindowManagerPolicy policy = this.mService.mPolicy;
        if (this.mService.mDisplayFrozen) {
            if (this.mLastWindowForcedOrientation != -1) {
                return this.mLastWindowForcedOrientation;
            }
            if (policy.isKeyguardLocked()) {
                return this.mLastOrientation;
            }
        } else {
            int orientation = this.mAboveAppWindowsContainers.getOrientation();
            if (orientation != -2) {
                return orientation;
            }
        }
        return this.mTaskStackContainers.getOrientation();
    }

    void updateDisplayInfo() {
        this.updateBaseDisplayMetricsIfNeeded();
        this.mDisplay.getDisplayInfo(this.mDisplayInfo);
        this.mDisplay.getMetrics(this.mDisplayMetrics);
        for (int i = this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
            ((TaskStack)this.mTaskStackContainers.getChildAt(i)).updateDisplayInfo(null);
        }
    }

    void initializeDisplayBaseInfo() {
        DisplayInfo newDisplayInfo;
        DisplayManagerInternal displayManagerInternal = this.mService.mDisplayManagerInternal;
        if (displayManagerInternal != null && (newDisplayInfo = displayManagerInternal.getDisplayInfo(this.mDisplayId)) != null) {
            this.mDisplayInfo.copyFrom(newDisplayInfo);
        }
        this.updateBaseDisplayMetrics(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight, this.mDisplayInfo.logicalDensityDpi);
        this.mInitialDisplayWidth = this.mDisplayInfo.logicalWidth;
        this.mInitialDisplayHeight = this.mDisplayInfo.logicalHeight;
        this.mInitialDisplayDensity = this.mDisplayInfo.logicalDensityDpi;
        this.mInitialDisplayCutout = this.mDisplayInfo.displayCutout;
    }

    private void updateBaseDisplayMetricsIfNeeded() {
        boolean displayMetricsChanged;
        this.mService.mDisplayManagerInternal.getNonOverrideDisplayInfo(this.mDisplayId, this.mDisplayInfo);
        int orientation = this.mDisplayInfo.rotation;
        boolean rotated = orientation == 1 || orientation == 3;
        int newWidth = rotated ? this.mDisplayInfo.logicalHeight : this.mDisplayInfo.logicalWidth;
        int newHeight = rotated ? this.mDisplayInfo.logicalWidth : this.mDisplayInfo.logicalHeight;
        int newDensity = this.mDisplayInfo.logicalDensityDpi;
        DisplayCutout newCutout = this.mDisplayInfo.displayCutout;
        boolean bl = displayMetricsChanged = this.mInitialDisplayWidth != newWidth || this.mInitialDisplayHeight != newHeight || this.mInitialDisplayDensity != this.mDisplayInfo.logicalDensityDpi || !Objects.equals(this.mInitialDisplayCutout, newCutout);
        if (displayMetricsChanged) {
            boolean isDisplaySizeForced = this.mBaseDisplayWidth != this.mInitialDisplayWidth || this.mBaseDisplayHeight != this.mInitialDisplayHeight;
            boolean isDisplayDensityForced = this.mBaseDisplayDensity != this.mInitialDisplayDensity;
            this.updateBaseDisplayMetrics(isDisplaySizeForced ? this.mBaseDisplayWidth : newWidth, isDisplaySizeForced ? this.mBaseDisplayHeight : newHeight, isDisplayDensityForced ? this.mBaseDisplayDensity : newDensity);
            this.mInitialDisplayWidth = newWidth;
            this.mInitialDisplayHeight = newHeight;
            this.mInitialDisplayDensity = newDensity;
            this.mInitialDisplayCutout = newCutout;
            this.mService.reconfigureDisplayLocked(this);
        }
    }

    void setMaxUiWidth(int width) {
        this.mMaxUiWidth = width;
        this.updateBaseDisplayMetrics(this.mBaseDisplayWidth, this.mBaseDisplayHeight, this.mBaseDisplayDensity);
    }

    void updateBaseDisplayMetrics(int baseWidth, int baseHeight, int baseDensity) {
        this.mBaseDisplayWidth = baseWidth;
        this.mBaseDisplayHeight = baseHeight;
        this.mBaseDisplayDensity = baseDensity;
        if (this.mMaxUiWidth > 0 && this.mBaseDisplayWidth > this.mMaxUiWidth) {
            this.mBaseDisplayHeight = this.mMaxUiWidth * this.mBaseDisplayHeight / this.mBaseDisplayWidth;
            this.mBaseDisplayDensity = this.mMaxUiWidth * this.mBaseDisplayDensity / this.mBaseDisplayWidth;
            this.mBaseDisplayWidth = this.mMaxUiWidth;
        }
        this.mBaseDisplayRect.set(0, 0, this.mBaseDisplayWidth, this.mBaseDisplayHeight);
        this.updateBounds();
    }

    void getStableRect(Rect out) {
        out.set(this.mDisplayFrames.mStable);
    }

    TaskStack createStack(int stackId, boolean onTop, StackWindowController controller) {
        TaskStack stack = new TaskStack(this.mService, stackId, controller);
        this.mTaskStackContainers.addStackToDisplay(stack, onTop);
        return stack;
    }

    void moveStackToDisplay(TaskStack stack, boolean onTop) {
        DisplayContent prevDc = stack.getDisplayContent();
        if (prevDc == null) {
            throw new IllegalStateException("Trying to move stackId=" + stack.mStackId + " which is not currently attached to any display");
        }
        if (prevDc.getDisplayId() == this.mDisplayId) {
            throw new IllegalArgumentException("Trying to move stackId=" + stack.mStackId + " to its current displayId=" + this.mDisplayId);
        }
        prevDc.mTaskStackContainers.removeChild(stack);
        this.mTaskStackContainers.addStackToDisplay(stack, onTop);
    }

    @Override
    protected void addChild(DisplayChildWindowContainer child, Comparator<DisplayChildWindowContainer> comparator) {
        throw new UnsupportedOperationException("See DisplayChildWindowContainer");
    }

    @Override
    protected void addChild(DisplayChildWindowContainer child, int index) {
        throw new UnsupportedOperationException("See DisplayChildWindowContainer");
    }

    @Override
    protected void removeChild(DisplayChildWindowContainer child) {
        if (this.mRemovingDisplay) {
            super.removeChild(child);
            return;
        }
        throw new UnsupportedOperationException("See DisplayChildWindowContainer");
    }

    @Override
    void positionChildAt(int position, DisplayChildWindowContainer child, boolean includingParents) {
        this.getParent().positionChildAt(position, this, includingParents);
    }

    void positionStackAt(int position, TaskStack child) {
        this.mTaskStackContainers.positionChildAt(position, child, false);
        this.layoutAndAssignWindowLayersIfNeeded();
    }

    int taskIdFromPoint(int x, int y) {
        for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(stackNdx);
            int taskId = stack.taskIdFromPoint(x, y);
            if (taskId == -1) continue;
            return taskId;
        }
        return -1;
    }

    Task findTaskForResizePoint(int x, int y) {
        int delta = WindowManagerService.dipToPixel(30, this.mDisplayMetrics);
        this.mTmpTaskForResizePointSearchResult.reset();
        for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(stackNdx);
            if (!stack.getWindowConfiguration().canResizeTask()) {
                return null;
            }
            stack.findTaskForResizePoint(x, y, delta, this.mTmpTaskForResizePointSearchResult);
            if (!this.mTmpTaskForResizePointSearchResult.searchDone) continue;
            return this.mTmpTaskForResizePointSearchResult.taskForResize;
        }
        return null;
    }

    void setTouchExcludeRegion(Task focusedTask) {
        WindowState win;
        int i;
        if (focusedTask == null) {
            this.mTouchExcludeRegion.setEmpty();
        } else {
            this.mTouchExcludeRegion.set(this.mBaseDisplayRect);
            int delta = WindowManagerService.dipToPixel(30, this.mDisplayMetrics);
            this.mTmpRect2.setEmpty();
            for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
                TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(stackNdx);
                stack.setTouchExcludeRegion(focusedTask, delta, this.mTouchExcludeRegion, this.mDisplayFrames.mContent, this.mTmpRect2);
            }
            if (!this.mTmpRect2.isEmpty()) {
                this.mTouchExcludeRegion.op(this.mTmpRect2, Region.Op.UNION);
            }
        }
        WindowState inputMethod = this.mService.mInputMethodWindow;
        if (inputMethod != null && inputMethod.isVisibleLw()) {
            inputMethod.getTouchableRegion(this.mTmpRegion);
            if (inputMethod.getDisplayId() == this.mDisplayId) {
                this.mTouchExcludeRegion.op(this.mTmpRegion, Region.Op.UNION);
            } else {
                inputMethod.getDisplayContent().setTouchExcludeRegion(null);
            }
        }
        for (i = this.mTapExcludedWindows.size() - 1; i >= 0; --i) {
            win = this.mTapExcludedWindows.get(i);
            win.getTouchableRegion(this.mTmpRegion);
            this.mTouchExcludeRegion.op(this.mTmpRegion, Region.Op.UNION);
        }
        for (i = this.mTapExcludeProvidingWindows.size() - 1; i >= 0; --i) {
            win = this.mTapExcludeProvidingWindows.valueAt(i);
            win.amendTapExcludeRegion(this.mTouchExcludeRegion);
        }
        if (this.mDisplayId == 0 && this.getSplitScreenPrimaryStack() != null) {
            this.mDividerControllerLocked.getTouchRegion(this.mTmpRect);
            this.mTmpRegion.set(this.mTmpRect);
            this.mTouchExcludeRegion.op(this.mTmpRegion, Region.Op.UNION);
        }
        if (this.mTapDetector != null) {
            this.mTapDetector.setTouchExcludeRegion(this.mTouchExcludeRegion);
        }
    }

    @Override
    void switchUser() {
        super.switchUser();
        this.mService.mWindowsChanged = true;
    }

    private void resetAnimationBackgroundAnimator() {
        for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            ((TaskStack)this.mTaskStackContainers.getChildAt(stackNdx)).resetAnimationBackgroundAnimator();
        }
    }

    @Override
    void removeIfPossible() {
        if (this.isAnimating()) {
            this.mDeferredRemoval = true;
            return;
        }
        this.removeImmediately();
    }

    @Override
    void removeImmediately() {
        this.mRemovingDisplay = true;
        try {
            super.removeImmediately();
            if (this.mService.canDispatchPointerEvents()) {
                if (this.mTapDetector != null) {
                    this.mService.unregisterPointerEventListener(this.mTapDetector);
                }
                if (this.mDisplayId == 0 && this.mService.mMousePositionTracker != null) {
                    this.mService.unregisterPointerEventListener(this.mService.mMousePositionTracker);
                }
            }
            this.mService.mAnimator.removeDisplayLocked(this.mDisplayId);
        }
        finally {
            this.mRemovingDisplay = false;
        }
        this.mService.onDisplayRemoved(this.mDisplayId);
    }

    @Override
    boolean checkCompleteDeferredRemoval() {
        boolean stillDeferringRemoval = super.checkCompleteDeferredRemoval();
        if (!stillDeferringRemoval && this.mDeferredRemoval) {
            this.removeImmediately();
            return false;
        }
        return true;
    }

    boolean isRemovalDeferred() {
        return this.mDeferredRemoval;
    }

    boolean animateForIme(float interpolatedValue, float animationTarget, float dividerAnimationTarget) {
        boolean updated = false;
        for (int i = this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(i);
            if (stack == null || !stack.isAdjustedForIme()) continue;
            if (interpolatedValue >= 1.0f && animationTarget == 0.0f && dividerAnimationTarget == 0.0f) {
                stack.resetAdjustedForIme(true);
                updated = true;
            } else {
                this.mDividerControllerLocked.mLastAnimationProgress = this.mDividerControllerLocked.getInterpolatedAnimationValue(interpolatedValue);
                this.mDividerControllerLocked.mLastDividerProgress = this.mDividerControllerLocked.getInterpolatedDividerValue(interpolatedValue);
                updated |= stack.updateAdjustForIme(this.mDividerControllerLocked.mLastAnimationProgress, this.mDividerControllerLocked.mLastDividerProgress, false);
            }
            if (!(interpolatedValue >= 1.0f)) continue;
            stack.endImeAdjustAnimation();
        }
        return updated;
    }

    boolean clearImeAdjustAnimation() {
        boolean changed = false;
        for (int i = this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(i);
            if (stack == null || !stack.isAdjustedForIme()) continue;
            stack.resetAdjustedForIme(true);
            changed = true;
        }
        return changed;
    }

    void beginImeAdjustAnimation() {
        for (int i = this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(i);
            if (!stack.isVisible() || !stack.isAdjustedForIme()) continue;
            stack.beginImeAdjustAnimation();
        }
    }

    void adjustForImeIfNeeded() {
        boolean imeHeightChanged;
        WindowState imeWin = this.mService.mInputMethodWindow;
        boolean imeVisible = imeWin != null && imeWin.isVisibleLw() && imeWin.isDisplayedLw() && !this.mDividerControllerLocked.isImeHideRequested();
        boolean dockVisible = this.isStackVisible(3);
        TaskStack imeTargetStack = this.mService.getImeFocusStackLocked();
        int imeDockSide = dockVisible && imeTargetStack != null ? imeTargetStack.getDockSide() : -1;
        boolean imeOnTop = imeDockSide == 2;
        boolean imeOnBottom = imeDockSide == 4;
        boolean dockMinimized = this.mDividerControllerLocked.isMinimizedDock();
        int imeHeight = this.mDisplayFrames.getInputMethodWindowVisibleHeight();
        boolean bl = imeHeightChanged = imeVisible && imeHeight != this.mDividerControllerLocked.getImeHeightAdjustedFor();
        if (imeVisible && dockVisible && (imeOnTop || imeOnBottom) && !dockMinimized) {
            for (int i = this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
                boolean isDockedOnBottom;
                TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(i);
                boolean bl2 = isDockedOnBottom = stack.getDockSide() == 4;
                if (stack.isVisible() && (imeOnBottom || isDockedOnBottom) && stack.inSplitScreenWindowingMode()) {
                    stack.setAdjustedForIme(imeWin, imeOnBottom && imeHeightChanged);
                    continue;
                }
                stack.resetAdjustedForIme(false);
            }
            this.mDividerControllerLocked.setAdjustedForIme(imeOnBottom, true, true, imeWin, imeHeight);
        } else {
            for (int i = this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
                TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(i);
                stack.resetAdjustedForIme(!dockVisible);
            }
            this.mDividerControllerLocked.setAdjustedForIme(false, false, dockVisible, imeWin, imeHeight);
        }
        this.mPinnedStackControllerLocked.setAdjustedForIme(imeVisible, imeHeight);
    }

    int getLayerForAnimationBackground(WindowStateAnimator winAnimator) {
        WindowState visibleWallpaper = this.mBelowAppWindowsContainers.getWindow(w -> w.mIsWallpaper && w.isVisibleNow());
        if (visibleWallpaper != null) {
            return visibleWallpaper.mWinAnimator.mAnimLayer;
        }
        return winAnimator.mAnimLayer;
    }

    void prepareFreezingTaskBounds() {
        for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(stackNdx);
            stack.prepareFreezingTaskBounds();
        }
    }

    void rotateBounds(int oldRotation, int newRotation, Rect bounds) {
        this.getBounds(this.mTmpRect, newRotation);
        int deltaRotation = DisplayContent.deltaRotation(newRotation, oldRotation);
        DisplayContent.createRotationMatrix(deltaRotation, this.mTmpRect.width(), this.mTmpRect.height(), this.mTmpMatrix);
        this.mTmpRectF.set(bounds);
        this.mTmpMatrix.mapRect(this.mTmpRectF);
        this.mTmpRectF.round(bounds);
    }

    static int deltaRotation(int oldRotation, int newRotation) {
        int delta = newRotation - oldRotation;
        if (delta < 0) {
            delta += 4;
        }
        return delta;
    }

    private static void createRotationMatrix(int rotation, float displayWidth, float displayHeight, Matrix outMatrix) {
        DisplayContent.createRotationMatrix(rotation, 0.0f, 0.0f, displayWidth, displayHeight, outMatrix);
    }

    static void createRotationMatrix(int rotation, float rectLeft, float rectTop, float displayWidth, float displayHeight, Matrix outMatrix) {
        switch (rotation) {
            case 0: {
                outMatrix.reset();
                break;
            }
            case 3: {
                outMatrix.setRotate(270.0f, 0.0f, 0.0f);
                outMatrix.postTranslate(0.0f, displayHeight);
                outMatrix.postTranslate(rectTop, 0.0f);
                break;
            }
            case 2: {
                outMatrix.reset();
                break;
            }
            case 1: {
                outMatrix.setRotate(90.0f, 0.0f, 0.0f);
                outMatrix.postTranslate(displayWidth, 0.0f);
                outMatrix.postTranslate(-rectTop, rectLeft);
            }
        }
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, boolean trim) {
        WindowToken windowToken;
        int i;
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, trim);
        proto.write(1120986464258L, this.mDisplayId);
        for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(stackNdx);
            stack.writeToProto(proto, 2246267895811L, trim);
        }
        this.mDividerControllerLocked.writeToProto(proto, 1146756268036L);
        this.mPinnedStackControllerLocked.writeToProto(proto, 1146756268037L);
        for (i = this.mAboveAppWindowsContainers.getChildCount() - 1; i >= 0; --i) {
            windowToken = (WindowToken)this.mAboveAppWindowsContainers.getChildAt(i);
            windowToken.writeToProto(proto, 2246267895814L, trim);
        }
        for (i = this.mBelowAppWindowsContainers.getChildCount() - 1; i >= 0; --i) {
            windowToken = (WindowToken)this.mBelowAppWindowsContainers.getChildAt(i);
            windowToken.writeToProto(proto, 2246267895815L, trim);
        }
        for (i = this.mImeWindowsContainers.getChildCount() - 1; i >= 0; --i) {
            windowToken = (WindowToken)this.mImeWindowsContainers.getChildAt(i);
            windowToken.writeToProto(proto, 2246267895816L, trim);
        }
        proto.write(1120986464265L, this.mBaseDisplayDensity);
        this.mDisplayInfo.writeToProto(proto, 1146756268042L);
        proto.write(1120986464267L, this.mRotation);
        ScreenRotationAnimation screenRotationAnimation = this.mService.mAnimator.getScreenRotationAnimationLocked(this.mDisplayId);
        if (screenRotationAnimation != null) {
            screenRotationAnimation.writeToProto(proto, 1146756268044L);
        }
        this.mDisplayFrames.writeToProto(proto, 1146756268045L);
        proto.end(token);
    }

    @Override
    public void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        TaskStack splitScreenPrimaryStack;
        TaskStack pinnedStack;
        super.dump(pw, prefix, dumpAll);
        pw.print(prefix);
        pw.print("Display: mDisplayId=");
        pw.println(this.mDisplayId);
        String subPrefix = "  " + prefix;
        pw.print(subPrefix);
        pw.print("init=");
        pw.print(this.mInitialDisplayWidth);
        pw.print("x");
        pw.print(this.mInitialDisplayHeight);
        pw.print(" ");
        pw.print(this.mInitialDisplayDensity);
        pw.print("dpi");
        if (this.mInitialDisplayWidth != this.mBaseDisplayWidth || this.mInitialDisplayHeight != this.mBaseDisplayHeight || this.mInitialDisplayDensity != this.mBaseDisplayDensity) {
            pw.print(" base=");
            pw.print(this.mBaseDisplayWidth);
            pw.print("x");
            pw.print(this.mBaseDisplayHeight);
            pw.print(" ");
            pw.print(this.mBaseDisplayDensity);
            pw.print("dpi");
        }
        if (this.mDisplayScalingDisabled) {
            pw.println(" noscale");
        }
        pw.print(" cur=");
        pw.print(this.mDisplayInfo.logicalWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.logicalHeight);
        pw.print(" app=");
        pw.print(this.mDisplayInfo.appWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.appHeight);
        pw.print(" rng=");
        pw.print(this.mDisplayInfo.smallestNominalAppWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.smallestNominalAppHeight);
        pw.print("-");
        pw.print(this.mDisplayInfo.largestNominalAppWidth);
        pw.print("x");
        pw.println(this.mDisplayInfo.largestNominalAppHeight);
        pw.print(subPrefix + "deferred=" + this.mDeferredRemoval + " mLayoutNeeded=" + this.mLayoutNeeded);
        pw.println(" mTouchExcludeRegion=" + this.mTouchExcludeRegion);
        pw.println();
        pw.print(prefix);
        pw.print("mLayoutSeq=");
        pw.println(this.mLayoutSeq);
        pw.println();
        pw.println(prefix + "Application tokens in top down Z order:");
        for (int stackNdx = this.mTaskStackContainers.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.getChildAt(stackNdx);
            stack.dump(pw, prefix + "  ", dumpAll);
        }
        pw.println();
        if (!this.mExitingTokens.isEmpty()) {
            pw.println();
            pw.println("  Exiting tokens:");
            for (int i = this.mExitingTokens.size() - 1; i >= 0; --i) {
                WindowToken token = this.mExitingTokens.get(i);
                pw.print("  Exiting #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                pw.println(':');
                token.dump(pw, "    ", dumpAll);
            }
        }
        pw.println();
        TaskStack homeStack = this.getHomeStack();
        if (homeStack != null) {
            pw.println(prefix + "homeStack=" + homeStack.getName());
        }
        if ((pinnedStack = this.getPinnedStack()) != null) {
            pw.println(prefix + "pinnedStack=" + pinnedStack.getName());
        }
        if ((splitScreenPrimaryStack = this.getSplitScreenPrimaryStack()) != null) {
            pw.println(prefix + "splitScreenPrimaryStack=" + splitScreenPrimaryStack.getName());
        }
        pw.println();
        this.mDividerControllerLocked.dump(prefix, pw);
        pw.println();
        this.mPinnedStackControllerLocked.dump(prefix, pw);
        pw.println();
        this.mDisplayFrames.dump(prefix, pw);
    }

    public String toString() {
        return "Display " + this.mDisplayId + " info=" + this.mDisplayInfo + " stacks=" + this.mChildren;
    }

    @Override
    String getName() {
        return "Display " + this.mDisplayId + " name=\"" + this.mDisplayInfo.name + "\"";
    }

    boolean isStackVisible(int windowingMode) {
        TaskStack stack = this.getTopStackInWindowingMode(windowingMode);
        return stack != null && stack.isVisible();
    }

    WindowState getTouchableWinAtPointLocked(float xf, float yf) {
        int x = (int)xf;
        int y = (int)yf;
        WindowState touchedWin = this.getWindow(w -> {
            int flags = w.mAttrs.flags;
            if (!w.isVisibleLw()) {
                return false;
            }
            if ((flags & 0x10) != 0) {
                return false;
            }
            w.getVisibleBounds(this.mTmpRect);
            if (!this.mTmpRect.contains(x, y)) {
                return false;
            }
            w.getTouchableRegion(this.mTmpRegion);
            int touchFlags = flags & 0x28;
            return this.mTmpRegion.contains(x, y) || touchFlags == 0;
        });
        return touchedWin;
    }

    boolean canAddToastWindowForUid(int uid) {
        WindowState focusedWindowForUid = this.getWindow(w -> w.mOwnerUid == uid && w.isFocused());
        if (focusedWindowForUid != null) {
            return true;
        }
        WindowState win = this.getWindow(w -> w.mAttrs.type == 2005 && w.mOwnerUid == uid && !w.mPermanentlyHidden && !w.mWindowRemovalAllowed);
        return win == null;
    }

    void scheduleToastWindowsTimeoutIfNeededLocked(WindowState oldFocus, WindowState newFocus) {
        if (oldFocus == null || newFocus != null && newFocus.mOwnerUid == oldFocus.mOwnerUid) {
            return;
        }
        this.mTmpWindow = oldFocus;
        this.forAllWindows(this.mScheduleToastTimeout, false);
    }

    WindowState findFocusedWindow() {
        this.mTmpWindow = null;
        this.forAllWindows(this.mFindFocusedWindow, true);
        if (this.mTmpWindow == null) {
            return null;
        }
        return this.mTmpWindow;
    }

    void assignWindowLayers(boolean setLayoutNeeded) {
        Trace.traceBegin(32L, "assignWindowLayers");
        this.assignChildLayers(this.getPendingTransaction());
        if (setLayoutNeeded) {
            this.setLayoutNeeded();
        }
        this.scheduleAnimation();
        Trace.traceEnd(32L);
    }

    void layoutAndAssignWindowLayersIfNeeded() {
        this.mService.mWindowsChanged = true;
        this.setLayoutNeeded();
        if (!this.mService.updateFocusedWindowLocked(3, false)) {
            this.assignWindowLayers(false);
        }
        this.mService.mInputMonitor.setUpdateInputWindowsNeededLw();
        this.mService.mWindowPlacerLocked.performSurfacePlacement();
        this.mService.mInputMonitor.updateInputWindowsLw(false);
    }

    boolean destroyLeakedSurfaces() {
        this.mTmpWindow = null;
        this.forAllWindows((WindowState w) -> {
            WindowStateAnimator wsa = w.mWinAnimator;
            if (wsa.mSurfaceController == null) {
                return;
            }
            if (!this.mService.mSessions.contains(wsa.mSession)) {
                Slog.w(TAG, "LEAKED SURFACE (session doesn't exist): " + w + " surface=" + wsa.mSurfaceController + " token=" + w.mToken + " pid=" + w.mSession.mPid + " uid=" + w.mSession.mUid);
                wsa.destroySurface();
                this.mService.mForceRemoves.add((WindowState)w);
                this.mTmpWindow = w;
            } else if (w.mAppToken != null && w.mAppToken.isClientHidden()) {
                Slog.w(TAG, "LEAKED SURFACE (app token hidden): " + w + " surface=" + wsa.mSurfaceController + " token=" + w.mAppToken);
                wsa.destroySurface();
                this.mTmpWindow = w;
            }
        }, false);
        return this.mTmpWindow != null;
    }

    WindowState computeImeTarget(boolean updateImeTarget) {
        WindowState betterTarget;
        AppWindowToken token;
        if (this.mService.mInputMethodWindow == null) {
            if (updateImeTarget) {
                this.setInputMethodTarget(null, this.mService.mInputMethodTargetWaitingAnim);
            }
            return null;
        }
        WindowState curTarget = this.mService.mInputMethodTarget;
        if (!this.canUpdateImeTarget()) {
            return curTarget;
        }
        this.mUpdateImeTarget = updateImeTarget;
        WindowState target = this.getWindow(this.mComputeImeTargetPredicate);
        if (target != null && target.mAttrs.type == 3 && (token = target.mAppToken) != null && (betterTarget = token.getImeTargetBelowWindow(target)) != null) {
            target = betterTarget;
        }
        if (curTarget != null && curTarget.isDisplayedLw() && curTarget.isClosing() && (target == null || target.isActivityTypeHome())) {
            return curTarget;
        }
        if (target == null) {
            if (updateImeTarget) {
                this.setInputMethodTarget(null, this.mService.mInputMethodTargetWaitingAnim);
            }
            return null;
        }
        if (updateImeTarget) {
            AppWindowToken appWindowToken = token = curTarget == null ? null : curTarget.mAppToken;
            if (token != null) {
                WindowState highestTarget = null;
                if (token.isSelfAnimating()) {
                    highestTarget = token.getHighestAnimLayerWindow(curTarget);
                }
                if (highestTarget != null) {
                    AppTransition appTransition = this.mService.mAppTransition;
                    if (appTransition.isTransitionSet()) {
                        this.setInputMethodTarget(highestTarget, true);
                        return highestTarget;
                    }
                    if (highestTarget.mWinAnimator.isAnimationSet() && highestTarget.mWinAnimator.mAnimLayer > target.mWinAnimator.mAnimLayer) {
                        this.setInputMethodTarget(highestTarget, true);
                        return highestTarget;
                    }
                }
            }
            this.setInputMethodTarget(target, false);
        }
        return target;
    }

    private void setInputMethodTarget(WindowState target, boolean targetWaitingAnim) {
        if (target == this.mService.mInputMethodTarget && this.mService.mInputMethodTargetWaitingAnim == targetWaitingAnim) {
            return;
        }
        this.mService.mInputMethodTarget = target;
        this.mService.mInputMethodTargetWaitingAnim = targetWaitingAnim;
        this.assignWindowLayers(false);
    }

    boolean getNeedsMenu(WindowState top, WindowManagerPolicy.WindowState bottom) {
        if (top.mAttrs.needsMenuKey != 0) {
            return top.mAttrs.needsMenuKey == 1;
        }
        this.mTmpWindow = null;
        WindowState candidate = this.getWindow(w -> {
            if (w == top) {
                this.mTmpWindow = w;
            }
            if (this.mTmpWindow == null) {
                return false;
            }
            if (w.mAttrs.needsMenuKey != 0) {
                return true;
            }
            return w == bottom;
        });
        return candidate != null && candidate.mAttrs.needsMenuKey == 1;
    }

    void setLayoutNeeded() {
        this.mLayoutNeeded = true;
    }

    private void clearLayoutNeeded() {
        this.mLayoutNeeded = false;
    }

    boolean isLayoutNeeded() {
        return this.mLayoutNeeded;
    }

    void dumpTokens(PrintWriter pw, boolean dumpAll) {
        if (this.mTokenMap.isEmpty()) {
            return;
        }
        pw.println("  Display #" + this.mDisplayId);
        for (WindowToken token : this.mTokenMap.values()) {
            pw.print("  ");
            pw.print(token);
            if (dumpAll) {
                pw.println(':');
                token.dump(pw, "    ", dumpAll);
                continue;
            }
            pw.println();
        }
    }

    void dumpWindowAnimators(PrintWriter pw, String subPrefix) {
        int[] index = new int[1];
        this.forAllWindows((WindowState w) -> {
            WindowStateAnimator wAnim = w.mWinAnimator;
            pw.println(subPrefix + "Window #" + index[0] + ": " + wAnim);
            index[0] = index[0] + 1;
        }, false);
    }

    void startKeyguardExitOnNonAppWindows(boolean onWallpaper, boolean goingToShade) {
        WindowManagerPolicy policy = this.mService.mPolicy;
        this.forAllWindows((WindowState w) -> {
            if (w.mAppToken == null && policy.canBeHiddenByKeyguardLw((WindowManagerPolicy.WindowState)w) && w.wouldBeVisibleIfPolicyIgnored() && !w.isVisible()) {
                w.startAnimation(policy.createHiddenByKeyguardExit(onWallpaper, goingToShade));
            }
        }, true);
    }

    boolean checkWaitingForWindows() {
        boolean wallpaperEnabled;
        this.mHaveBootMsg = false;
        this.mHaveApp = false;
        this.mHaveWallpaper = false;
        this.mHaveKeyguard = true;
        WindowState visibleWindow = this.getWindow(w -> {
            if (w.isVisibleLw() && !w.mObscured && !w.isDrawnLw()) {
                return true;
            }
            if (w.isDrawnLw()) {
                if (w.mAttrs.type == 2021) {
                    this.mHaveBootMsg = true;
                } else if (w.mAttrs.type == 2 || w.mAttrs.type == 4) {
                    this.mHaveApp = true;
                } else if (w.mAttrs.type == 2013) {
                    this.mHaveWallpaper = true;
                } else if (w.mAttrs.type == 2000) {
                    this.mHaveKeyguard = this.mService.mPolicy.isKeyguardDrawnLw();
                }
            }
            return false;
        });
        if (visibleWindow != null) {
            return true;
        }
        boolean bl = wallpaperEnabled = this.mService.mContext.getResources().getBoolean(17956970) && this.mService.mContext.getResources().getBoolean(17956917) && !this.mService.mOnlyCore;
        if (!this.mService.mSystemBooted && !this.mHaveBootMsg) {
            return true;
        }
        return this.mService.mSystemBooted && (!this.mHaveApp && !this.mHaveKeyguard || wallpaperEnabled && !this.mHaveWallpaper);
    }

    void updateWindowsForAnimator(WindowAnimator animator2) {
        this.mTmpWindowAnimator = animator2;
        this.forAllWindows(this.mUpdateWindowsForAnimator, true);
    }

    void updateWallpaperForAnimator(WindowAnimator animator2) {
        this.resetAnimationBackgroundAnimator();
        this.mTmpWindow = null;
        this.mTmpWindowAnimator = animator2;
        this.forAllWindows(this.mUpdateWallpaperForAnimator, true);
        if (animator2.mWindowDetachedWallpaper != this.mTmpWindow) {
            animator2.mWindowDetachedWallpaper = this.mTmpWindow;
            animator2.mBulkUpdateParams |= 2;
        }
    }

    boolean inputMethodClientHasFocus(IInputMethodClient client) {
        WindowState imFocus = this.computeImeTarget(false);
        if (imFocus == null) {
            return false;
        }
        IInputMethodClient imeClient = imFocus.mSession.mClient;
        return imeClient != null && imeClient.asBinder() == client.asBinder();
    }

    boolean hasSecureWindowOnScreen() {
        WindowState win = this.getWindow(w -> w.isOnScreen() && (w.mAttrs.flags & 0x2000) != 0);
        return win != null;
    }

    void updateSystemUiVisibility(int visibility, int globalDiff) {
        this.forAllWindows((WindowState w) -> {
            try {
                int curValue = w.mSystemUiVisibility;
                int diff = (curValue ^ visibility) & globalDiff;
                int newValue = curValue & ~diff | visibility & diff;
                if (newValue != curValue) {
                    ++w.mSeq;
                    w.mSystemUiVisibility = newValue;
                }
                if (newValue != curValue || w.mAttrs.hasSystemUiListeners) {
                    w.mClient.dispatchSystemUiVisibilityChanged(w.mSeq, visibility, newValue, diff);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }, true);
    }

    void onWindowFreezeTimeout() {
        Slog.w(TAG, "Window freeze timeout expired.");
        this.mService.mWindowsFreezingScreen = 2;
        this.forAllWindows((WindowState w) -> {
            if (!w.getOrientationChanging()) {
                return;
            }
            w.orientationChangeTimedOut();
            w.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mService.mDisplayFreezeTime);
            Slog.w(TAG, "Force clearing orientation change: " + w);
        }, true);
        this.mService.mWindowPlacerLocked.performSurfacePlacement();
    }

    void waitForAllWindowsDrawn() {
        WindowManagerPolicy policy = this.mService.mPolicy;
        this.forAllWindows((WindowState w) -> {
            boolean keyguard = policy.isKeyguardHostWindow(w.mAttrs);
            if (w.isVisibleLw() && (w.mAppToken != null || keyguard)) {
                w.mWinAnimator.mDrawState = 1;
                w.mLastContentInsets.set(-1, -1, -1, -1);
                this.mService.mWaitingForDrawn.add((WindowState)w);
            }
        }, true);
    }

    boolean applySurfaceChangesTransaction(boolean recoveringMemory) {
        int dw = this.mDisplayInfo.logicalWidth;
        int dh = this.mDisplayInfo.logicalHeight;
        WindowSurfacePlacer surfacePlacer = this.mService.mWindowPlacerLocked;
        this.mTmpUpdateAllDrawn.clear();
        int repeats = 0;
        do {
            if (++repeats > 6) {
                Slog.w(TAG, "Animation repeat aborted after too many iterations");
                this.clearLayoutNeeded();
                break;
            }
            if (this.isDefaultDisplay && (this.pendingLayoutChanges & 4) != 0) {
                this.mWallpaperController.adjustWallpaperWindows(this);
            }
            if (this.isDefaultDisplay && (this.pendingLayoutChanges & 2) != 0 && this.mService.updateOrientationFromAppTokensLocked(this.mDisplayId)) {
                this.setLayoutNeeded();
                this.mService.mH.obtainMessage(18, this.mDisplayId).sendToTarget();
            }
            if ((this.pendingLayoutChanges & 1) != 0) {
                this.setLayoutNeeded();
            }
            if (repeats < 4) {
                this.performLayout(repeats == 1, false);
            } else {
                Slog.w(TAG, "Layout repeat skipped after too many iterations");
            }
            this.pendingLayoutChanges = 0;
            if (!this.isDefaultDisplay) continue;
            this.mService.mPolicy.beginPostLayoutPolicyLw(dw, dh);
            this.forAllWindows(this.mApplyPostLayoutPolicy, true);
            this.pendingLayoutChanges |= this.mService.mPolicy.finishPostLayoutPolicyLw();
        } while (this.pendingLayoutChanges != 0);
        this.mTmpApplySurfaceChangesTransactionState.reset();
        this.mTmpRecoveringMemory = recoveringMemory;
        this.forAllWindows(this.mApplySurfaceChangesTransaction, true);
        this.prepareSurfaces();
        this.mService.mDisplayManagerInternal.setDisplayProperties(this.mDisplayId, this.mTmpApplySurfaceChangesTransactionState.displayHasContent, this.mTmpApplySurfaceChangesTransactionState.preferredRefreshRate, this.mTmpApplySurfaceChangesTransactionState.preferredModeId, true);
        boolean wallpaperVisible = this.mWallpaperController.isWallpaperVisible();
        if (wallpaperVisible != this.mLastWallpaperVisible) {
            this.mLastWallpaperVisible = wallpaperVisible;
            this.mService.mWallpaperVisibilityListeners.notifyWallpaperVisibilityChanged(this);
        }
        while (!this.mTmpUpdateAllDrawn.isEmpty()) {
            AppWindowToken atoken = this.mTmpUpdateAllDrawn.removeLast();
            atoken.updateAllDrawn();
        }
        return this.mTmpApplySurfaceChangesTransactionState.focusDisplayed;
    }

    private void updateBounds() {
        this.calculateBounds(this.mTmpBounds);
        this.setBounds(this.mTmpBounds);
    }

    private void calculateBounds(Rect out) {
        int orientation = this.mDisplayInfo.rotation;
        boolean rotated = orientation == 1 || orientation == 3;
        int physWidth = rotated ? this.mBaseDisplayHeight : this.mBaseDisplayWidth;
        int physHeight = rotated ? this.mBaseDisplayWidth : this.mBaseDisplayHeight;
        int width = this.mDisplayInfo.logicalWidth;
        int left = (physWidth - width) / 2;
        int height = this.mDisplayInfo.logicalHeight;
        int top = (physHeight - height) / 2;
        out.set(left, top, left + width, top + height);
    }

    @Override
    public void getBounds(Rect out) {
        this.calculateBounds(out);
    }

    private void getBounds(Rect out, int orientation) {
        this.getBounds(out);
        int currentRotation = this.mDisplayInfo.rotation;
        int rotationDelta = DisplayContent.deltaRotation(currentRotation, orientation);
        if (rotationDelta == 1 || rotationDelta == 3) {
            DisplayContent.createRotationMatrix(rotationDelta, this.mBaseDisplayWidth, this.mBaseDisplayHeight, this.mTmpMatrix);
            this.mTmpRectF.set(out);
            this.mTmpMatrix.mapRect(this.mTmpRectF);
            this.mTmpRectF.round(out);
        }
    }

    void performLayout(boolean initial, boolean updateInputWindows) {
        int seq;
        if (!this.isLayoutNeeded()) {
            return;
        }
        this.clearLayoutNeeded();
        int dw = this.mDisplayInfo.logicalWidth;
        int dh = this.mDisplayInfo.logicalHeight;
        this.mDisplayFrames.onDisplayInfoUpdated(this.mDisplayInfo, this.calculateDisplayCutoutForRotation(this.mDisplayInfo.rotation));
        this.mDisplayFrames.mRotation = this.mRotation;
        this.mService.mPolicy.beginLayoutLw(this.mDisplayFrames, this.getConfiguration().uiMode);
        if (this.isDefaultDisplay) {
            this.mService.mSystemDecorLayer = this.mService.mPolicy.getSystemDecorLayerLw();
            this.mService.mScreenRect.set(0, 0, dw, dh);
        }
        if ((seq = this.mLayoutSeq + 1) < 0) {
            seq = 0;
        }
        this.mLayoutSeq = seq;
        this.mTmpWindow = null;
        this.mTmpInitial = initial;
        this.forAllWindows(this.mPerformLayout, true);
        this.mTmpWindow2 = this.mTmpWindow;
        this.mTmpWindow = null;
        this.forAllWindows(this.mPerformLayoutAttached, true);
        this.mService.mInputMonitor.layoutInputConsumers(dw, dh);
        this.mService.mInputMonitor.setUpdateInputWindowsNeededLw();
        if (updateInputWindows) {
            this.mService.mInputMonitor.updateInputWindowsLw(false);
        }
        this.mService.mH.sendEmptyMessage(41);
    }

    Bitmap screenshotDisplayLocked(Bitmap.Config config) {
        if (!this.mService.mPolicy.isScreenOn()) {
            return null;
        }
        int dw = this.mDisplayInfo.logicalWidth;
        int dh = this.mDisplayInfo.logicalHeight;
        if (dw <= 0 || dh <= 0) {
            return null;
        }
        Rect frame = new Rect(0, 0, dw, dh);
        int rot = this.mDisplay.getRotation();
        if (rot == 1 || rot == 3) {
            rot = rot == 1 ? 3 : 1;
        }
        DisplayContent.convertCropForSurfaceFlinger(frame, rot, dw, dh);
        ScreenRotationAnimation screenRotationAnimation = this.mService.mAnimator.getScreenRotationAnimationLocked(0);
        boolean inRotation = screenRotationAnimation != null && screenRotationAnimation.isAnimating();
        Bitmap bitmap = SurfaceControl.screenshot(frame, dw, dh, 0, 1, inRotation, rot);
        if (bitmap == null) {
            Slog.w(TAG, "Failed to take screenshot");
            return null;
        }
        Bitmap ret = bitmap.createAshmemBitmap(config);
        bitmap.recycle();
        return ret;
    }

    private static void convertCropForSurfaceFlinger(Rect crop, int rot, int dw, int dh) {
        if (rot == 1) {
            int tmp = crop.top;
            crop.top = dw - crop.right;
            crop.right = crop.bottom;
            crop.bottom = dw - crop.left;
            crop.left = tmp;
        } else if (rot == 2) {
            int tmp = crop.top;
            crop.top = dh - crop.bottom;
            crop.bottom = dh - tmp;
            tmp = crop.right;
            crop.right = dw - crop.left;
            crop.left = dw - tmp;
        } else if (rot == 3) {
            int tmp = crop.top;
            crop.top = crop.left;
            crop.left = dh - crop.bottom;
            crop.bottom = crop.right;
            crop.right = dh - tmp;
        }
    }

    void onSeamlessRotationTimeout() {
        this.mTmpWindow = null;
        this.forAllWindows((WindowState w) -> {
            if (!w.mSeamlesslyRotated) {
                return;
            }
            this.mTmpWindow = w;
            w.setDisplayLayoutNeeded();
            this.mService.markForSeamlessRotation((WindowState)w, false);
        }, true);
        if (this.mTmpWindow != null) {
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
        }
    }

    void setExitingTokensHasVisible(boolean hasVisible) {
        for (int i = this.mExitingTokens.size() - 1; i >= 0; --i) {
            this.mExitingTokens.get((int)i).hasVisible = hasVisible;
        }
        this.mTaskStackContainers.setExitingTokensHasVisible(hasVisible);
    }

    void removeExistingTokensIfPossible() {
        for (int i = this.mExitingTokens.size() - 1; i >= 0; --i) {
            WindowToken token = this.mExitingTokens.get(i);
            if (token.hasVisible) continue;
            this.mExitingTokens.remove(i);
        }
        this.mTaskStackContainers.removeExistingAppTokensIfPossible();
    }

    @Override
    void onDescendantOverrideConfigurationChanged() {
        this.setLayoutNeeded();
        this.mService.requestTraversal();
    }

    boolean okToDisplay() {
        if (this.mDisplayId == 0) {
            return !this.mService.mDisplayFrozen && this.mService.mDisplayEnabled && this.mService.mPolicy.isScreenOn();
        }
        return this.mDisplayInfo.state == 2;
    }

    boolean okToAnimate() {
        return this.okToDisplay() && (this.mDisplayId != 0 || this.mService.mPolicy.okToAnimate());
    }

    SurfaceControl.Builder makeSurface(SurfaceSession s) {
        return this.mService.makeSurfaceBuilder(s).setParent(this.mWindowingLayer);
    }

    @Override
    SurfaceSession getSession() {
        return this.mSession;
    }

    @Override
    SurfaceControl.Builder makeChildSurface(WindowContainer child) {
        SurfaceSession s = child != null ? child.getSession() : this.getSession();
        SurfaceControl.Builder b = this.mService.makeSurfaceBuilder(s);
        b.setSize(this.mSurfaceSize, this.mSurfaceSize);
        if (child == null) {
            return b;
        }
        return b.setName(child.getName()).setParent(this.mWindowingLayer);
    }

    SurfaceControl.Builder makeOverlay() {
        return this.mService.makeSurfaceBuilder(this.mSession).setParent(this.mOverlayLayer);
    }

    void reparentToOverlay(SurfaceControl.Transaction transaction, SurfaceControl surface) {
        transaction.reparent(surface, this.mOverlayLayer.getHandle());
    }

    void applyMagnificationSpec(MagnificationSpec spec) {
        this.mMagnificationSpec = (double)spec.scale != 1.0 ? spec : null;
        this.applyMagnificationSpec(this.getPendingTransaction(), spec);
        this.getPendingTransaction().apply();
    }

    void reapplyMagnificationSpec() {
        if (this.mMagnificationSpec != null) {
            this.applyMagnificationSpec(this.getPendingTransaction(), this.mMagnificationSpec);
        }
    }

    @Override
    void onParentSet() {
    }

    @Override
    void assignChildLayers(SurfaceControl.Transaction t) {
        this.mBelowAppWindowsContainers.assignLayer(t, 0);
        this.mTaskStackContainers.assignLayer(t, 1);
        this.mAboveAppWindowsContainers.assignLayer(t, 2);
        WindowState imeTarget = this.mService.mInputMethodTarget;
        boolean needAssignIme = true;
        if (imeTarget != null && !imeTarget.inSplitScreenWindowingMode() && !imeTarget.mToken.isAppAnimating() && imeTarget.getSurfaceControl() != null) {
            this.mImeWindowsContainers.assignRelativeLayer(t, imeTarget.getSurfaceControl(), 1);
            needAssignIme = false;
        }
        this.mBelowAppWindowsContainers.assignChildLayers(t);
        this.mTaskStackContainers.assignChildLayers(t);
        this.mAboveAppWindowsContainers.assignChildLayers(t, needAssignIme ? this.mImeWindowsContainers : null);
        this.mImeWindowsContainers.assignChildLayers(t);
    }

    void assignRelativeLayerForImeTargetChild(SurfaceControl.Transaction t, WindowContainer child) {
        child.assignRelativeLayer(t, this.mImeWindowsContainers.getSurfaceControl(), 1);
    }

    @Override
    void prepareSurfaces() {
        ScreenRotationAnimation screenRotationAnimation = this.mService.mAnimator.getScreenRotationAnimationLocked(this.mDisplayId);
        if (screenRotationAnimation != null && screenRotationAnimation.isAnimating()) {
            screenRotationAnimation.getEnterTransformation().getMatrix().getValues(this.mTmpFloats);
            this.mPendingTransaction.setMatrix(this.mWindowingLayer, this.mTmpFloats[0], this.mTmpFloats[3], this.mTmpFloats[1], this.mTmpFloats[4]);
            this.mPendingTransaction.setPosition(this.mWindowingLayer, this.mTmpFloats[2], this.mTmpFloats[5]);
            this.mPendingTransaction.setAlpha(this.mWindowingLayer, screenRotationAnimation.getEnterTransformation().getAlpha());
        }
        super.prepareSurfaces();
    }

    void assignStackOrdering() {
        this.mTaskStackContainers.assignStackOrdering(this.getPendingTransaction());
    }

    void deferUpdateImeTarget() {
        ++this.mDeferUpdateImeTargetCount;
    }

    void continueUpdateImeTarget() {
        if (this.mDeferUpdateImeTargetCount == 0) {
            return;
        }
        --this.mDeferUpdateImeTargetCount;
        if (this.mDeferUpdateImeTargetCount == 0) {
            this.computeImeTarget(true);
        }
    }

    private boolean canUpdateImeTarget() {
        return this.mDeferUpdateImeTargetCount == 0;
    }

    private class NonMagnifiableWindowContainers
    extends NonAppWindowContainers {
        NonMagnifiableWindowContainers(String name, WindowManagerService service) {
            super(name, service);
        }

        @Override
        void applyMagnificationSpec(SurfaceControl.Transaction t, MagnificationSpec spec) {
        }
    }

    private class NonAppWindowContainers
    extends DisplayChildWindowContainer<WindowToken> {
        private final Comparator<WindowToken> mWindowComparator;
        private final Predicate<WindowState> mGetOrientingWindow;
        private final String mName;
        private final Dimmer mDimmer;
        private final Rect mTmpDimBoundsRect;

        NonAppWindowContainers(String name, WindowManagerService service) {
            super(service);
            this.mWindowComparator = (token1, token2) -> this.mService.mPolicy.getWindowLayerFromTypeLw(token1.windowType, token1.mOwnerCanManageAppTokens) < this.mService.mPolicy.getWindowLayerFromTypeLw(token2.windowType, token2.mOwnerCanManageAppTokens) ? -1 : 1;
            this.mGetOrientingWindow = w -> {
                if (!w.isVisibleLw() || !w.mPolicyVisibilityAfterAnim) {
                    return false;
                }
                int req = w.mAttrs.screenOrientation;
                return req != -1 && req != 3 && req != -2;
            };
            this.mDimmer = new Dimmer(this);
            this.mTmpDimBoundsRect = new Rect();
            this.mName = name;
        }

        void addChild(WindowToken token) {
            this.addChild(token, this.mWindowComparator);
        }

        @Override
        int getOrientation() {
            boolean isUnoccluding;
            WindowManagerPolicy policy = this.mService.mPolicy;
            WindowState win = this.getWindow(this.mGetOrientingWindow);
            if (win != null) {
                int req = win.mAttrs.screenOrientation;
                if (policy.isKeyguardHostWindow(win.mAttrs)) {
                    DisplayContent.this.mLastKeyguardForcedOrientation = req;
                    if (this.mService.mKeyguardGoingAway) {
                        DisplayContent.this.mLastWindowForcedOrientation = -1;
                        return -2;
                    }
                }
                return DisplayContent.this.mLastWindowForcedOrientation = req;
            }
            DisplayContent.this.mLastWindowForcedOrientation = -1;
            boolean bl = isUnoccluding = this.mService.mAppTransition.getAppTransition() == 23 && this.mService.mUnknownAppVisibilityController.allResolved();
            if (policy.isKeyguardShowingAndNotOccluded() || isUnoccluding) {
                return DisplayContent.this.mLastKeyguardForcedOrientation;
            }
            return -2;
        }

        @Override
        String getName() {
            return this.mName;
        }

        @Override
        Dimmer getDimmer() {
            return this.mDimmer;
        }

        @Override
        void prepareSurfaces() {
            this.mDimmer.resetDimStates();
            super.prepareSurfaces();
            this.getBounds(this.mTmpDimBoundsRect);
            if (this.mDimmer.updateDims(this.getPendingTransaction(), this.mTmpDimBoundsRect)) {
                this.scheduleAnimation();
            }
        }
    }

    private final class AboveAppWindowContainers
    extends NonAppWindowContainers {
        AboveAppWindowContainers(String name, WindowManagerService service) {
            super(name, service);
        }

        @Override
        SurfaceControl.Builder makeChildSurface(WindowContainer child) {
            SurfaceControl.Builder builder = super.makeChildSurface(child);
            if (child instanceof WindowToken && ((WindowToken)child).mRoundedCornerOverlay) {
                builder.setParent(null);
            }
            return builder;
        }

        @Override
        void assignChildLayers(SurfaceControl.Transaction t) {
            this.assignChildLayers(t, null);
        }

        void assignChildLayers(SurfaceControl.Transaction t, WindowContainer imeContainer) {
            boolean needAssignIme = imeContainer != null && imeContainer.getSurfaceControl() != null;
            for (int j = 0; j < this.mChildren.size(); ++j) {
                WindowToken wt = (WindowToken)this.mChildren.get(j);
                if (wt.windowType == 2034) {
                    wt.assignRelativeLayer(t, DisplayContent.this.mTaskStackContainers.getSplitScreenDividerAnchor(), 1);
                    continue;
                }
                if (wt.mRoundedCornerOverlay) {
                    wt.assignLayer(t, 0x40000002);
                    continue;
                }
                wt.assignLayer(t, j);
                wt.assignChildLayers(t);
                int layer = this.mService.mPolicy.getWindowLayerFromTypeLw(wt.windowType, wt.mOwnerCanManageAppTokens);
                if (!needAssignIme || layer < this.mService.mPolicy.getWindowLayerFromTypeLw(2012, true)) continue;
                imeContainer.assignRelativeLayer(t, wt.getSurfaceControl(), -1);
                needAssignIme = false;
            }
            if (needAssignIme) {
                imeContainer.assignRelativeLayer(t, this.getSurfaceControl(), Integer.MAX_VALUE);
            }
        }
    }

    private final class TaskStackContainers
    extends DisplayChildWindowContainer<TaskStack> {
        SurfaceControl mAppAnimationLayer;
        SurfaceControl mBoostedAppAnimationLayer;
        SurfaceControl mHomeAppAnimationLayer;
        SurfaceControl mSplitScreenDividerAnchor;
        private TaskStack mHomeStack;
        private TaskStack mPinnedStack;
        private TaskStack mSplitScreenPrimaryStack;

        TaskStackContainers(WindowManagerService service) {
            super(service);
            this.mAppAnimationLayer = null;
            this.mBoostedAppAnimationLayer = null;
            this.mHomeAppAnimationLayer = null;
            this.mSplitScreenDividerAnchor = null;
            this.mHomeStack = null;
            this.mPinnedStack = null;
            this.mSplitScreenPrimaryStack = null;
        }

        TaskStack getStack(int windowingMode, int activityType) {
            if (activityType == 2) {
                return this.mHomeStack;
            }
            if (windowingMode == 2) {
                return this.mPinnedStack;
            }
            if (windowingMode == 3) {
                return this.mSplitScreenPrimaryStack;
            }
            for (int i = DisplayContent.this.mTaskStackContainers.getChildCount() - 1; i >= 0; --i) {
                TaskStack stack = (TaskStack)DisplayContent.this.mTaskStackContainers.getChildAt(i);
                if (activityType == 0 && windowingMode == stack.getWindowingMode()) {
                    return stack;
                }
                if (!stack.isCompatible(windowingMode, activityType)) continue;
                return stack;
            }
            return null;
        }

        @VisibleForTesting
        TaskStack getTopStack() {
            return DisplayContent.this.mTaskStackContainers.getChildCount() > 0 ? (TaskStack)DisplayContent.this.mTaskStackContainers.getChildAt(DisplayContent.this.mTaskStackContainers.getChildCount() - 1) : null;
        }

        TaskStack getHomeStack() {
            if (this.mHomeStack == null && DisplayContent.this.mDisplayId == 0) {
                Slog.e(DisplayContent.TAG, "getHomeStack: Returning null from this=" + this);
            }
            return this.mHomeStack;
        }

        TaskStack getPinnedStack() {
            return this.mPinnedStack;
        }

        TaskStack getSplitScreenPrimaryStack() {
            return this.mSplitScreenPrimaryStack;
        }

        ArrayList<Task> getVisibleTasks() {
            ArrayList<Task> visibleTasks = new ArrayList<Task>();
            this.forAllTasks(task -> {
                if (task.isVisible()) {
                    visibleTasks.add((Task)task);
                }
            });
            return visibleTasks;
        }

        void addStackToDisplay(TaskStack stack, boolean onTop) {
            this.addStackReferenceIfNeeded(stack);
            this.addChild(stack, onTop);
            stack.onDisplayChanged(DisplayContent.this);
        }

        void onStackWindowingModeChanged(TaskStack stack) {
            this.removeStackReferenceIfNeeded(stack);
            this.addStackReferenceIfNeeded(stack);
            if (stack == this.mPinnedStack && this.getTopStack() != stack) {
                this.positionChildAt(Integer.MAX_VALUE, stack, false);
            }
        }

        private void addStackReferenceIfNeeded(TaskStack stack) {
            int windowingMode;
            if (stack.isActivityTypeHome()) {
                if (this.mHomeStack != null) {
                    throw new IllegalArgumentException("addStackReferenceIfNeeded: home stack=" + this.mHomeStack + " already exist on display=" + this + " stack=" + stack);
                }
                this.mHomeStack = stack;
            }
            if ((windowingMode = stack.getWindowingMode()) == 2) {
                if (this.mPinnedStack != null) {
                    throw new IllegalArgumentException("addStackReferenceIfNeeded: pinned stack=" + this.mPinnedStack + " already exist on display=" + this + " stack=" + stack);
                }
                this.mPinnedStack = stack;
            } else if (windowingMode == 3) {
                if (this.mSplitScreenPrimaryStack != null) {
                    throw new IllegalArgumentException("addStackReferenceIfNeeded: split-screen-primary stack=" + this.mSplitScreenPrimaryStack + " already exist on display=" + this + " stack=" + stack);
                }
                this.mSplitScreenPrimaryStack = stack;
                DisplayContent.this.mDividerControllerLocked.notifyDockedStackExistsChanged(true);
            }
        }

        private void removeStackReferenceIfNeeded(TaskStack stack) {
            if (stack == this.mHomeStack) {
                this.mHomeStack = null;
            } else if (stack == this.mPinnedStack) {
                this.mPinnedStack = null;
            } else if (stack == this.mSplitScreenPrimaryStack) {
                this.mSplitScreenPrimaryStack = null;
                this.mService.setDockedStackCreateStateLocked(0, null);
                DisplayContent.this.mDividerControllerLocked.notifyDockedStackExistsChanged(false);
            }
        }

        private void addChild(TaskStack stack, boolean toTop) {
            int addIndex = this.findPositionForStack(toTop ? this.mChildren.size() : 0, stack, true);
            this.addChild(stack, addIndex);
            DisplayContent.this.setLayoutNeeded();
        }

        @Override
        protected void removeChild(TaskStack stack) {
            super.removeChild(stack);
            this.removeStackReferenceIfNeeded(stack);
        }

        @Override
        boolean isOnTop() {
            return true;
        }

        @Override
        void positionChildAt(int position, TaskStack child, boolean includingParents) {
            if (child.getWindowConfiguration().isAlwaysOnTop() && position != Integer.MAX_VALUE) {
                Slog.w(DisplayContent.TAG, "Ignoring move of always-on-top stack=" + this + " to bottom");
                int currentPosition = this.mChildren.indexOf(child);
                super.positionChildAt(currentPosition, child, false);
                return;
            }
            int targetPosition = this.findPositionForStack(position, child, false);
            super.positionChildAt(targetPosition, child, includingParents);
            DisplayContent.this.setLayoutNeeded();
        }

        private int findPositionForStack(int requestedPosition, TaskStack stack, boolean adding) {
            boolean toTop;
            int topChildPosition = this.mChildren.size() - 1;
            boolean bl = toTop = requestedPosition == Integer.MAX_VALUE;
            boolean bl2 = adding ? requestedPosition >= topChildPosition + 1 : requestedPosition >= topChildPosition;
            int targetPosition = requestedPosition;
            if ((toTop |= bl2) && stack.getWindowingMode() != 2 && DisplayContent.this.hasPinnedStack()) {
                TaskStack topStack = (TaskStack)this.mChildren.get(topChildPosition);
                if (topStack.getWindowingMode() != 2) {
                    throw new IllegalStateException("Pinned stack isn't top stack??? " + this.mChildren);
                }
                targetPosition = adding ? topChildPosition : topChildPosition - 1;
            }
            return targetPosition;
        }

        @Override
        boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
            if (traverseTopToBottom) {
                if (super.forAllWindows(callback, traverseTopToBottom)) {
                    return true;
                }
                if (this.forAllExitingAppTokenWindows(callback, traverseTopToBottom)) {
                    return true;
                }
            } else {
                if (this.forAllExitingAppTokenWindows(callback, traverseTopToBottom)) {
                    return true;
                }
                if (super.forAllWindows(callback, traverseTopToBottom)) {
                    return true;
                }
            }
            return false;
        }

        private boolean forAllExitingAppTokenWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
            if (traverseTopToBottom) {
                for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                    AppTokenList appTokens = ((TaskStack)this.mChildren.get((int)i)).mExitingAppTokens;
                    for (int j = appTokens.size() - 1; j >= 0; --j) {
                        if (!((AppWindowToken)appTokens.get(j)).forAllWindowsUnchecked(callback, traverseTopToBottom)) continue;
                        return true;
                    }
                }
            } else {
                int count = this.mChildren.size();
                for (int i = 0; i < count; ++i) {
                    AppTokenList appTokens = ((TaskStack)this.mChildren.get((int)i)).mExitingAppTokens;
                    int appTokensCount = appTokens.size();
                    for (int j = 0; j < appTokensCount; ++j) {
                        if (!((AppWindowToken)appTokens.get(j)).forAllWindowsUnchecked(callback, traverseTopToBottom)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        void setExitingTokensHasVisible(boolean hasVisible) {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                AppTokenList appTokens = ((TaskStack)this.mChildren.get((int)i)).mExitingAppTokens;
                for (int j = appTokens.size() - 1; j >= 0; --j) {
                    ((AppWindowToken)appTokens.get((int)j)).hasVisible = hasVisible;
                }
            }
        }

        void removeExistingAppTokensIfPossible() {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                AppTokenList appTokens = ((TaskStack)this.mChildren.get((int)i)).mExitingAppTokens;
                for (int j = appTokens.size() - 1; j >= 0; --j) {
                    AppWindowToken token = (AppWindowToken)appTokens.get(j);
                    if (token.hasVisible || this.mService.mClosingApps.contains(token) || token.mIsExiting && !token.isEmpty()) continue;
                    this.cancelAnimation();
                    token.removeIfPossible();
                }
            }
        }

        @Override
        int getOrientation() {
            if (DisplayContent.this.isStackVisible(3) || DisplayContent.this.isStackVisible(5)) {
                int orientation;
                if (this.mHomeStack != null && this.mHomeStack.isVisible() && DisplayContent.this.mDividerControllerLocked.isMinimizedDock() && (!DisplayContent.this.mDividerControllerLocked.isHomeStackResizable() || !this.mHomeStack.matchParentBounds()) && (orientation = this.mHomeStack.getOrientation()) != -2) {
                    return orientation;
                }
                return -1;
            }
            int orientation = super.getOrientation();
            boolean isCar = this.mService.mContext.getPackageManager().hasSystemFeature("android.hardware.type.automotive");
            if (isCar) {
                return -1;
            }
            if (orientation != -2 && orientation != 3) {
                return orientation;
            }
            return DisplayContent.this.mLastOrientation;
        }

        @Override
        void assignChildLayers(SurfaceControl.Transaction t) {
            this.assignStackOrdering(t);
            for (int i = 0; i < this.mChildren.size(); ++i) {
                TaskStack s = (TaskStack)this.mChildren.get(i);
                s.assignChildLayers(t);
            }
        }

        void assignStackOrdering(SurfaceControl.Transaction t) {
            boolean HOME_STACK_STATE = false;
            boolean NORMAL_STACK_STATE = true;
            int ALWAYS_ON_TOP_STATE = 2;
            int layer = 0;
            int layerForAnimationLayer = 0;
            int layerForBoostedAnimationLayer = 0;
            int layerForHomeAnimationLayer = 0;
            for (int state = 0; state <= 2; ++state) {
                for (int i = 0; i < this.mChildren.size(); ++i) {
                    TaskStack s = (TaskStack)this.mChildren.get(i);
                    if (state == 0 && !s.isActivityTypeHome() || state == 1 && (s.isActivityTypeHome() || s.isAlwaysOnTop()) || state == 2 && !s.isAlwaysOnTop()) continue;
                    s.assignLayer(t, layer++);
                    if (s.inSplitScreenWindowingMode() && this.mSplitScreenDividerAnchor != null) {
                        t.setLayer(this.mSplitScreenDividerAnchor, layer++);
                    }
                    if ((s.isTaskAnimating() || s.isAppAnimating()) && state != 2) {
                        layerForAnimationLayer = layer++;
                    }
                    if (state == 2) continue;
                    layerForBoostedAnimationLayer = layer++;
                }
                if (state != 0) continue;
                layerForHomeAnimationLayer = layer++;
            }
            if (this.mAppAnimationLayer != null) {
                t.setLayer(this.mAppAnimationLayer, layerForAnimationLayer);
            }
            if (this.mBoostedAppAnimationLayer != null) {
                t.setLayer(this.mBoostedAppAnimationLayer, layerForBoostedAnimationLayer);
            }
            if (this.mHomeAppAnimationLayer != null) {
                t.setLayer(this.mHomeAppAnimationLayer, layerForHomeAnimationLayer);
            }
        }

        @Override
        SurfaceControl getAppAnimationLayer(@WindowContainer.AnimationLayer int animationLayer) {
            switch (animationLayer) {
                case 1: {
                    return this.mBoostedAppAnimationLayer;
                }
                case 2: {
                    return this.mHomeAppAnimationLayer;
                }
            }
            return this.mAppAnimationLayer;
        }

        SurfaceControl getSplitScreenDividerAnchor() {
            return this.mSplitScreenDividerAnchor;
        }

        @Override
        void onParentSet() {
            super.onParentSet();
            if (this.getParent() != null) {
                this.mAppAnimationLayer = this.makeChildSurface(null).setName("animationLayer").build();
                this.mBoostedAppAnimationLayer = this.makeChildSurface(null).setName("boostedAnimationLayer").build();
                this.mHomeAppAnimationLayer = this.makeChildSurface(null).setName("homeAnimationLayer").build();
                this.mSplitScreenDividerAnchor = this.makeChildSurface(null).setName("splitScreenDividerAnchor").build();
                this.getPendingTransaction().show(this.mAppAnimationLayer).show(this.mBoostedAppAnimationLayer).show(this.mHomeAppAnimationLayer).show(this.mSplitScreenDividerAnchor);
                this.scheduleAnimation();
            } else {
                this.mAppAnimationLayer.destroy();
                this.mAppAnimationLayer = null;
                this.mBoostedAppAnimationLayer.destroy();
                this.mBoostedAppAnimationLayer = null;
                this.mHomeAppAnimationLayer.destroy();
                this.mHomeAppAnimationLayer = null;
                this.mSplitScreenDividerAnchor.destroy();
                this.mSplitScreenDividerAnchor = null;
            }
        }
    }

    static class DisplayChildWindowContainer<E extends WindowContainer>
    extends WindowContainer<E> {
        DisplayChildWindowContainer(WindowManagerService service) {
            super(service);
        }

        @Override
        boolean fillsParent() {
            return true;
        }

        @Override
        boolean isVisible() {
            return true;
        }
    }

    private static final class ScreenshotApplicationState {
        WindowState appWin;
        int maxLayer;
        int minLayer;
        boolean screenshotReady;

        private ScreenshotApplicationState() {
        }

        void reset(boolean screenshotReady) {
            this.appWin = null;
            this.maxLayer = 0;
            this.minLayer = 0;
            this.screenshotReady = screenshotReady;
            this.minLayer = screenshotReady ? 0 : Integer.MAX_VALUE;
        }
    }

    private static final class ApplySurfaceChangesTransactionState {
        boolean displayHasContent;
        boolean obscured;
        boolean syswin;
        boolean focusDisplayed;
        float preferredRefreshRate;
        int preferredModeId;

        private ApplySurfaceChangesTransactionState() {
        }

        void reset() {
            this.displayHasContent = false;
            this.obscured = false;
            this.syswin = false;
            this.focusDisplayed = false;
            this.preferredRefreshRate = 0.0f;
            this.preferredModeId = 0;
        }
    }

    static final class TaskForResizePointSearchResult {
        boolean searchDone;
        Task taskForResize;

        TaskForResizePointSearchResult() {
        }

        void reset() {
            this.searchDone = false;
            this.taskForResize = null;
        }
    }
}

