/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.Configuration;
import android.os.Binder;
import android.view.Display;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.StackWindowController;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowContainerListener;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;

public class DisplayWindowController
extends WindowContainerController<DisplayContent, WindowContainerListener> {
    private final int mDisplayId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayWindowController(Display display, WindowContainerListener listener) {
        super(listener, WindowManagerService.getInstance());
        this.mDisplayId = display.getDisplayId();
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                long callingIdentity = Binder.clearCallingIdentity();
                try {
                    this.mRoot.createDisplayContent(display, this);
                }
                finally {
                    Binder.restoreCallingIdentity(callingIdentity);
                }
                if (this.mContainer == null) {
                    throw new IllegalArgumentException("Trying to add display=" + display + " dc=" + this.mRoot.getDisplayContent(this.mDisplayId));
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl20 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void removeContainer() {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((DisplayContent)this.mContainer).removeIfPossible();
        super.removeContainer();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @Override
    public void onOverrideConfigurationChanged(Configuration overrideConfiguration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void positionChildAt(StackWindowController child, int position) {
        block6: {
            block5: {
                WindowHashMap windowHashMap = this.mWindowMap;
                // MONITORENTER : windowHashMap
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (this.mContainer != null) break block5;
                    // MONITOREXIT : windowHashMap
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            if (child.mContainer != null) break block6;
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((DisplayContent)this.mContainer).positionStackAt(position, (TaskStack)child.mContainer);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferUpdateImeTarget() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent dc = this.mRoot.getDisplayContent(this.mDisplayId);
                if (dc != null) {
                    dc.deferUpdateImeTarget();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueUpdateImeTarget() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                DisplayContent dc = this.mRoot.getDisplayContent(this.mDisplayId);
                if (dc != null) {
                    dc.continueUpdateImeTarget();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    public String toString() {
        return "{DisplayWindowController displayId=" + this.mDisplayId + "}";
    }
}

