/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.ArraySet;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.IDockedStackListener;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import android.view.inputmethod.InputMethodManagerInternal;
import com.android.internal.policy.DividerSnapAlgorithm;
import com.android.internal.policy.DockedDividerUtils;
import com.android.server.LocalServices;
import com.android.server.wm.AppTransition;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.RecentsAnimationController;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;

public class DockedStackDividerController {
    private static final String TAG = "WindowManager";
    private static final float CLIP_REVEAL_MEET_EARLIEST = 0.6f;
    private static final float CLIP_REVEAL_MEET_LAST = 1.0f;
    private static final float CLIP_REVEAL_MEET_FRACTION_MIN = 0.4f;
    private static final float CLIP_REVEAL_MEET_FRACTION_MAX = 0.8f;
    private static final Interpolator IME_ADJUST_ENTRY_INTERPOLATOR = new PathInterpolator(0.2f, 0.0f, 0.1f, 1.0f);
    private static final long IME_ADJUST_ANIM_DURATION = 280L;
    private static final long IME_ADJUST_DRAWN_TIMEOUT = 200L;
    private static final int DIVIDER_WIDTH_INACTIVE_DP = 4;
    private final WindowManagerService mService;
    private final DisplayContent mDisplayContent;
    private int mDividerWindowWidth;
    private int mDividerWindowWidthInactive;
    private int mDividerInsets;
    private int mTaskHeightInMinimizedMode;
    private boolean mResizing;
    private WindowState mWindow;
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpRect2 = new Rect();
    private final Rect mTmpRect3 = new Rect();
    private final Rect mLastRect = new Rect();
    private boolean mLastVisibility = false;
    private final RemoteCallbackList<IDockedStackListener> mDockedStackListeners = new RemoteCallbackList();
    private boolean mMinimizedDock;
    private int mOriginalDockedSide = -1;
    private boolean mAnimatingForMinimizedDockedStack;
    private boolean mAnimationStarted;
    private long mAnimationStartTime;
    private float mAnimationStart;
    private float mAnimationTarget;
    private long mAnimationDuration;
    private boolean mAnimationStartDelayed;
    private final Interpolator mMinimizedDockInterpolator;
    private float mMaximizeMeetFraction;
    private final Rect mTouchRegion = new Rect();
    private boolean mAnimatingForIme;
    private boolean mAdjustedForIme;
    private int mImeHeight;
    private WindowState mDelayedImeWin;
    private boolean mAdjustedForDivider;
    private float mDividerAnimationStart;
    private float mDividerAnimationTarget;
    float mLastAnimationProgress;
    float mLastDividerProgress;
    private final DividerSnapAlgorithm[] mSnapAlgorithmForRotation = new DividerSnapAlgorithm[4];
    private boolean mImeHideRequested;
    private final Rect mLastDimLayerRect = new Rect();
    private float mLastDimLayerAlpha;
    private TaskStack mDimmedStack;

    DockedStackDividerController(WindowManagerService service, DisplayContent displayContent) {
        this.mService = service;
        this.mDisplayContent = displayContent;
        Context context = service.mContext;
        this.mMinimizedDockInterpolator = AnimationUtils.loadInterpolator(context, 17563661);
        this.loadDimens();
    }

    int getSmallestWidthDpForBounds(Rect bounds) {
        DisplayInfo di = this.mDisplayContent.getDisplayInfo();
        int baseDisplayWidth = this.mDisplayContent.mBaseDisplayWidth;
        int baseDisplayHeight = this.mDisplayContent.mBaseDisplayHeight;
        int minWidth = Integer.MAX_VALUE;
        for (int rotation = 0; rotation < 4; ++rotation) {
            this.mTmpRect.set(bounds);
            this.mDisplayContent.rotateBounds(di.rotation, rotation, this.mTmpRect);
            boolean rotated = rotation == 1 || rotation == 3;
            this.mTmpRect2.set(0, 0, rotated ? baseDisplayHeight : baseDisplayWidth, rotated ? baseDisplayWidth : baseDisplayHeight);
            int orientation = this.mTmpRect2.width() <= this.mTmpRect2.height() ? 1 : 2;
            int dockSide = this.getDockSide(this.mTmpRect, this.mTmpRect2, orientation);
            int position = DockedDividerUtils.calculatePositionForBounds(this.mTmpRect, dockSide, this.getContentWidth());
            DisplayCutout displayCutout = this.mDisplayContent.calculateDisplayCutoutForRotation(rotation).getDisplayCutout();
            int snappedPosition = this.mSnapAlgorithmForRotation[rotation].calculateNonDismissingSnapTarget((int)position).position;
            DockedDividerUtils.calculateBoundsForPosition(snappedPosition, dockSide, this.mTmpRect, this.mTmpRect2.width(), this.mTmpRect2.height(), this.getContentWidth());
            this.mService.mPolicy.getStableInsetsLw(rotation, this.mTmpRect2.width(), this.mTmpRect2.height(), displayCutout, this.mTmpRect3);
            this.mService.intersectDisplayInsetBounds(this.mTmpRect2, this.mTmpRect3, this.mTmpRect);
            minWidth = Math.min(this.mTmpRect.width(), minWidth);
        }
        return (int)((float)minWidth / this.mDisplayContent.getDisplayMetrics().density);
    }

    int getDockSide(Rect bounds, Rect displayRect, int orientation) {
        if (orientation == 1) {
            int diff = displayRect.bottom - bounds.bottom - (bounds.top - displayRect.top);
            if (diff > 0) {
                return 2;
            }
            if (diff < 0) {
                return 4;
            }
            return this.canPrimaryStackDockTo(2) ? 2 : 4;
        }
        if (orientation == 2) {
            int diff = displayRect.right - bounds.right - (bounds.left - displayRect.left);
            if (diff > 0) {
                return 1;
            }
            if (diff < 0) {
                return 3;
            }
            return this.canPrimaryStackDockTo(1) ? 1 : 3;
        }
        return -1;
    }

    void getHomeStackBoundsInDockedMode(Rect outBounds) {
        DisplayInfo di = this.mDisplayContent.getDisplayInfo();
        this.mService.mPolicy.getStableInsetsLw(di.rotation, di.logicalWidth, di.logicalHeight, di.displayCutout, this.mTmpRect);
        int dividerSize = this.mDividerWindowWidth - 2 * this.mDividerInsets;
        Configuration configuration = this.mDisplayContent.getConfiguration();
        if (configuration.orientation == 1) {
            outBounds.set(0, this.mTaskHeightInMinimizedMode + dividerSize + this.mTmpRect.top, di.logicalWidth, di.logicalHeight);
        } else {
            TaskStack stack = this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility();
            int primaryTaskWidth = this.mTaskHeightInMinimizedMode + dividerSize + this.mTmpRect.top;
            int left = this.mTmpRect.left;
            int right = di.logicalWidth - this.mTmpRect.right;
            if (stack != null) {
                if (stack.getDockSide() == 1) {
                    left += primaryTaskWidth;
                } else if (stack.getDockSide() == 3) {
                    right -= primaryTaskWidth;
                }
            }
            outBounds.set(left, 0, right, di.logicalHeight);
        }
    }

    boolean isHomeStackResizable() {
        TaskStack homeStack = this.mDisplayContent.getHomeStack();
        if (homeStack == null) {
            return false;
        }
        Task homeTask = homeStack.findHomeTask();
        return homeTask != null && homeTask.isResizeable();
    }

    private void initSnapAlgorithmForRotations() {
        Configuration baseConfig = this.mDisplayContent.getConfiguration();
        Configuration config = new Configuration();
        for (int rotation = 0; rotation < 4; ++rotation) {
            boolean rotated = rotation == 1 || rotation == 3;
            int dw = rotated ? this.mDisplayContent.mBaseDisplayHeight : this.mDisplayContent.mBaseDisplayWidth;
            int dh = rotated ? this.mDisplayContent.mBaseDisplayWidth : this.mDisplayContent.mBaseDisplayHeight;
            DisplayCutout displayCutout = this.mDisplayContent.calculateDisplayCutoutForRotation(rotation).getDisplayCutout();
            this.mService.mPolicy.getStableInsetsLw(rotation, dw, dh, displayCutout, this.mTmpRect);
            config.unset();
            config.orientation = dw <= dh ? 1 : 2;
            int displayId = this.mDisplayContent.getDisplayId();
            int appWidth = this.mService.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation, baseConfig.uiMode, displayId, displayCutout);
            int appHeight = this.mService.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation, baseConfig.uiMode, displayId, displayCutout);
            this.mService.mPolicy.getNonDecorInsetsLw(rotation, dw, dh, displayCutout, this.mTmpRect);
            int leftInset = this.mTmpRect.left;
            int topInset = this.mTmpRect.top;
            config.windowConfiguration.setAppBounds(leftInset, topInset, leftInset + appWidth, topInset + appHeight);
            float density = this.mDisplayContent.getDisplayMetrics().density;
            config.screenWidthDp = (int)((float)this.mService.mPolicy.getConfigDisplayWidth(dw, dh, rotation, baseConfig.uiMode, displayId, displayCutout) / density);
            config.screenHeightDp = (int)((float)this.mService.mPolicy.getConfigDisplayHeight(dw, dh, rotation, baseConfig.uiMode, displayId, displayCutout) / density);
            Context rotationContext = this.mService.mContext.createConfigurationContext(config);
            this.mSnapAlgorithmForRotation[rotation] = new DividerSnapAlgorithm(rotationContext.getResources(), dw, dh, this.getContentWidth(), config.orientation == 1, this.mTmpRect);
        }
    }

    private void loadDimens() {
        Context context = this.mService.mContext;
        this.mDividerWindowWidth = context.getResources().getDimensionPixelSize(17105034);
        this.mDividerInsets = context.getResources().getDimensionPixelSize(17105033);
        this.mDividerWindowWidthInactive = WindowManagerService.dipToPixel(4, this.mDisplayContent.getDisplayMetrics());
        this.mTaskHeightInMinimizedMode = context.getResources().getDimensionPixelSize(17105317);
        this.initSnapAlgorithmForRotations();
    }

    void onConfigurationChanged() {
        this.loadDimens();
    }

    boolean isResizing() {
        return this.mResizing;
    }

    int getContentWidth() {
        return this.mDividerWindowWidth - 2 * this.mDividerInsets;
    }

    int getContentInsets() {
        return this.mDividerInsets;
    }

    int getContentWidthInactive() {
        return this.mDividerWindowWidthInactive;
    }

    void setResizing(boolean resizing) {
        if (this.mResizing != resizing) {
            this.mResizing = resizing;
            this.resetDragResizingChangeReported();
        }
    }

    void setTouchRegion(Rect touchRegion) {
        this.mTouchRegion.set(touchRegion);
    }

    void getTouchRegion(Rect outRegion) {
        outRegion.set(this.mTouchRegion);
        outRegion.offset(this.mWindow.getFrameLw().left, this.mWindow.getFrameLw().top);
    }

    private void resetDragResizingChangeReported() {
        this.mDisplayContent.forAllWindows(WindowState::resetDragResizingChangeReported, true);
    }

    void setWindow(WindowState window) {
        this.mWindow = window;
        this.reevaluateVisibility(false);
    }

    void reevaluateVisibility(boolean force) {
        boolean visible;
        if (this.mWindow == null) {
            return;
        }
        TaskStack stack = this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility();
        boolean bl = visible = stack != null;
        if (this.mLastVisibility == visible && !force) {
            return;
        }
        this.mLastVisibility = visible;
        this.notifyDockedDividerVisibilityChanged(visible);
        if (!visible) {
            this.setResizeDimLayer(false, 0, 0.0f);
        }
    }

    private boolean wasVisible() {
        return this.mLastVisibility;
    }

    void setAdjustedForIme(boolean adjustedForIme, boolean adjustedForDivider, boolean animate, WindowState imeWin, int imeHeight) {
        if (this.mAdjustedForIme != adjustedForIme || adjustedForIme && this.mImeHeight != imeHeight || this.mAdjustedForDivider != adjustedForDivider) {
            if (animate && !this.mAnimatingForMinimizedDockedStack) {
                this.startImeAdjustAnimation(adjustedForIme, adjustedForDivider, imeWin);
            } else {
                this.notifyAdjustedForImeChanged(adjustedForIme || adjustedForDivider, 0L);
            }
            this.mAdjustedForIme = adjustedForIme;
            this.mImeHeight = imeHeight;
            this.mAdjustedForDivider = adjustedForDivider;
        }
    }

    int getImeHeightAdjustedFor() {
        return this.mImeHeight;
    }

    void positionDockedStackedDivider(Rect frame) {
        TaskStack stack = this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility();
        if (stack == null) {
            frame.set(this.mLastRect);
            return;
        }
        stack.getDimBounds(this.mTmpRect);
        int side = stack.getDockSide();
        switch (side) {
            case 1: {
                frame.set(this.mTmpRect.right - this.mDividerInsets, frame.top, this.mTmpRect.right + frame.width() - this.mDividerInsets, frame.bottom);
                break;
            }
            case 2: {
                frame.set(frame.left, this.mTmpRect.bottom - this.mDividerInsets, this.mTmpRect.right, this.mTmpRect.bottom + frame.height() - this.mDividerInsets);
                break;
            }
            case 3: {
                frame.set(this.mTmpRect.left - frame.width() + this.mDividerInsets, frame.top, this.mTmpRect.left + this.mDividerInsets, frame.bottom);
                break;
            }
            case 4: {
                frame.set(frame.left, this.mTmpRect.top - frame.height() + this.mDividerInsets, frame.right, this.mTmpRect.top + this.mDividerInsets);
            }
        }
        this.mLastRect.set(frame);
    }

    private void notifyDockedDividerVisibilityChanged(boolean visible) {
        int size = this.mDockedStackListeners.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IDockedStackListener listener = this.mDockedStackListeners.getBroadcastItem(i);
            try {
                listener.onDividerVisibilityChanged(visible);
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering divider visibility changed event.", e);
            }
        }
        this.mDockedStackListeners.finishBroadcast();
    }

    boolean canPrimaryStackDockTo(int dockSide) {
        DisplayInfo di = this.mDisplayContent.getDisplayInfo();
        return this.mService.mPolicy.isDockSideAllowed(dockSide, this.mOriginalDockedSide, di.logicalWidth, di.logicalHeight, di.rotation);
    }

    void notifyDockedStackExistsChanged(boolean exists) {
        int size = this.mDockedStackListeners.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IDockedStackListener listener = this.mDockedStackListeners.getBroadcastItem(i);
            try {
                listener.onDockedStackExistsChanged(exists);
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering docked stack exists changed event.", e);
            }
        }
        this.mDockedStackListeners.finishBroadcast();
        if (exists) {
            InputMethodManagerInternal inputMethodManagerInternal = LocalServices.getService(InputMethodManagerInternal.class);
            if (inputMethodManagerInternal != null) {
                inputMethodManagerInternal.hideCurrentInputMethod();
                this.mImeHideRequested = true;
            }
            TaskStack stack = this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility();
            this.mOriginalDockedSide = stack.getDockSideForDisplay(this.mDisplayContent);
            return;
        }
        this.mOriginalDockedSide = -1;
        this.setMinimizedDockedStack(false, false);
        if (this.mDimmedStack != null) {
            this.mDimmedStack.stopDimming();
            this.mDimmedStack = null;
        }
    }

    void resetImeHideRequested() {
        this.mImeHideRequested = false;
    }

    boolean isImeHideRequested() {
        return this.mImeHideRequested;
    }

    private void notifyDockedStackMinimizedChanged(boolean minimizedDock, boolean animate, boolean isHomeStackResizable) {
        long animDuration = 0L;
        if (animate) {
            TaskStack stack = this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility();
            long transitionDuration = this.isAnimationMaximizing() ? this.mService.mAppTransition.getLastClipRevealTransitionDuration() : 336L;
            this.mAnimationDuration = (long)((float)transitionDuration * this.mService.getTransitionAnimationScaleLocked());
            this.mMaximizeMeetFraction = this.getClipRevealMeetFraction(stack);
            animDuration = (long)((float)this.mAnimationDuration * this.mMaximizeMeetFraction);
        }
        this.mService.mH.removeMessages(53);
        this.mService.mH.obtainMessage(53, minimizedDock ? 1 : 0, 0).sendToTarget();
        int size = this.mDockedStackListeners.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IDockedStackListener listener = this.mDockedStackListeners.getBroadcastItem(i);
            try {
                listener.onDockedStackMinimizedChanged(minimizedDock, animDuration, isHomeStackResizable);
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering minimized dock changed event.", e);
            }
        }
        this.mDockedStackListeners.finishBroadcast();
    }

    void notifyDockSideChanged(int newDockSide) {
        int size = this.mDockedStackListeners.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IDockedStackListener listener = this.mDockedStackListeners.getBroadcastItem(i);
            try {
                listener.onDockSideChanged(newDockSide);
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering dock side changed event.", e);
            }
        }
        this.mDockedStackListeners.finishBroadcast();
    }

    private void notifyAdjustedForImeChanged(boolean adjustedForIme, long animDuration) {
        int size = this.mDockedStackListeners.beginBroadcast();
        for (int i = 0; i < size; ++i) {
            IDockedStackListener listener = this.mDockedStackListeners.getBroadcastItem(i);
            try {
                listener.onAdjustedForImeChanged(adjustedForIme, animDuration);
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering adjusted for ime changed event.", e);
            }
        }
        this.mDockedStackListeners.finishBroadcast();
    }

    void registerDockedStackListener(IDockedStackListener listener) {
        this.mDockedStackListeners.register(listener);
        this.notifyDockedDividerVisibilityChanged(this.wasVisible());
        this.notifyDockedStackExistsChanged(this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility() != null);
        this.notifyDockedStackMinimizedChanged(this.mMinimizedDock, false, this.isHomeStackResizable());
        this.notifyAdjustedForImeChanged(this.mAdjustedForIme, 0L);
    }

    void setResizeDimLayer(boolean visible, int targetWindowingMode, float alpha) {
        boolean visibleAndValid;
        TaskStack stack = targetWindowingMode != 0 ? this.mDisplayContent.getTopStackInWindowingMode(targetWindowingMode) : null;
        TaskStack dockedStack = this.mDisplayContent.getSplitScreenPrimaryStack();
        boolean bl = visibleAndValid = visible && stack != null && dockedStack != null;
        if (this.mDimmedStack != null && this.mDimmedStack != stack) {
            this.mDimmedStack.stopDimming();
            this.mDimmedStack = null;
        }
        if (visibleAndValid) {
            this.mDimmedStack = stack;
            stack.dim(alpha);
        }
        if (!visibleAndValid && stack != null) {
            this.mDimmedStack = null;
            stack.stopDimming();
        }
    }

    private int getResizeDimLayer() {
        return this.mWindow != null ? this.mWindow.mLayer - 1 : 1;
    }

    void notifyAppVisibilityChanged() {
        this.checkMinimizeChanged(false);
    }

    void notifyAppTransitionStarting(ArraySet<AppWindowToken> openingApps, int appTransition) {
        boolean wasMinimized = this.mMinimizedDock;
        this.checkMinimizeChanged(true);
        if (wasMinimized && this.mMinimizedDock && this.containsAppInDockedStack(openingApps) && appTransition != 0 && !AppTransition.isKeyguardGoingAwayTransit(appTransition) && !this.mService.mAmInternal.isRecentsComponentHomeActivity(this.mService.mCurrentUserId)) {
            this.mService.showRecentApps();
        }
    }

    private boolean containsAppInDockedStack(ArraySet<AppWindowToken> apps) {
        for (int i = apps.size() - 1; i >= 0; --i) {
            AppWindowToken token = apps.valueAt(i);
            if (token.getTask() == null || !token.inSplitScreenPrimaryWindowingMode()) continue;
            return true;
        }
        return false;
    }

    boolean isMinimizedDock() {
        return this.mMinimizedDock;
    }

    void checkMinimizeChanged(boolean animate) {
        boolean homeVisible;
        if (this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility() == null) {
            return;
        }
        TaskStack homeStack = this.mDisplayContent.getHomeStack();
        if (homeStack == null) {
            return;
        }
        Task homeTask = homeStack.findHomeTask();
        if (homeTask == null || !this.isWithinDisplay(homeTask)) {
            return;
        }
        if (this.mMinimizedDock && this.mService.mKeyguardOrAodShowingOnDefaultDisplay) {
            return;
        }
        TaskStack topSecondaryStack = this.mDisplayContent.getTopStackInWindowingMode(4);
        RecentsAnimationController recentsAnim = this.mService.getRecentsAnimationController();
        boolean minimizedForRecentsAnimation = recentsAnim != null && recentsAnim.isSplitScreenMinimized();
        boolean bl = homeVisible = homeTask.getTopVisibleAppToken() != null;
        if (homeVisible && topSecondaryStack != null) {
            homeVisible = homeStack.compareTo(topSecondaryStack) >= 0;
        }
        this.setMinimizedDockedStack(homeVisible || minimizedForRecentsAnimation, animate);
    }

    private boolean isWithinDisplay(Task task) {
        task.getBounds(this.mTmpRect);
        this.mDisplayContent.getBounds(this.mTmpRect2);
        return this.mTmpRect.intersect(this.mTmpRect2);
    }

    private void setMinimizedDockedStack(boolean minimizedDock, boolean animate) {
        boolean wasMinimized = this.mMinimizedDock;
        this.mMinimizedDock = minimizedDock;
        if (minimizedDock == wasMinimized) {
            return;
        }
        boolean imeChanged = this.clearImeAdjustAnimation();
        boolean minimizedChange = false;
        if (this.isHomeStackResizable()) {
            this.notifyDockedStackMinimizedChanged(minimizedDock, animate, true);
            minimizedChange = true;
        } else if (minimizedDock) {
            if (animate) {
                this.startAdjustAnimation(0.0f, 1.0f);
            } else {
                minimizedChange |= this.setMinimizedDockedStack(true);
            }
        } else if (animate) {
            this.startAdjustAnimation(1.0f, 0.0f);
        } else {
            minimizedChange |= this.setMinimizedDockedStack(false);
        }
        if (imeChanged || minimizedChange) {
            if (imeChanged && !minimizedChange) {
                Slog.d(TAG, "setMinimizedDockedStack: IME adjust changed due to minimizing, minimizedDock=" + minimizedDock + " minimizedChange=" + minimizedChange);
            }
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
        }
    }

    private boolean clearImeAdjustAnimation() {
        boolean changed = this.mDisplayContent.clearImeAdjustAnimation();
        this.mAnimatingForIme = false;
        return changed;
    }

    private void startAdjustAnimation(float from, float to) {
        this.mAnimatingForMinimizedDockedStack = true;
        this.mAnimationStarted = false;
        this.mAnimationStart = from;
        this.mAnimationTarget = to;
    }

    private void startImeAdjustAnimation(boolean adjustedForIme, boolean adjustedForDivider, WindowState imeWin) {
        if (!this.mAnimatingForIme) {
            this.mAnimationStart = this.mAdjustedForIme ? 1.0f : 0.0f;
            this.mDividerAnimationStart = this.mAdjustedForDivider ? 1.0f : 0.0f;
            this.mLastAnimationProgress = this.mAnimationStart;
            this.mLastDividerProgress = this.mDividerAnimationStart;
        } else {
            this.mAnimationStart = this.mLastAnimationProgress;
            this.mDividerAnimationStart = this.mLastDividerProgress;
        }
        this.mAnimatingForIme = true;
        this.mAnimationStarted = false;
        this.mAnimationTarget = adjustedForIme ? 1.0f : 0.0f;
        this.mDividerAnimationTarget = adjustedForDivider ? 1.0f : 0.0f;
        this.mDisplayContent.beginImeAdjustAnimation();
        if (!this.mService.mWaitingForDrawn.isEmpty()) {
            this.mService.mH.removeMessages(24);
            this.mService.mH.sendEmptyMessageDelayed(24, 200L);
            this.mAnimationStartDelayed = true;
            if (imeWin != null) {
                if (this.mDelayedImeWin != null) {
                    this.mDelayedImeWin.endDelayingAnimationStart();
                }
                this.mDelayedImeWin = imeWin;
                imeWin.startDelayingAnimationStart();
            }
            if (this.mService.mWaitingForDrawnCallback != null) {
                this.mService.mWaitingForDrawnCallback.run();
            }
            this.mService.mWaitingForDrawnCallback = () -> {
                WindowHashMap windowHashMap = this.mService.mWindowMap;
                synchronized (windowHashMap) {
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        this.mAnimationStartDelayed = false;
                        if (this.mDelayedImeWin != null) {
                            this.mDelayedImeWin.endDelayingAnimationStart();
                        }
                        long duration = 0L;
                        if (this.mAdjustedForIme == adjustedForIme && this.mAdjustedForDivider == adjustedForDivider) {
                            duration = 280L;
                        } else {
                            Slog.w(TAG, "IME adjust changed while waiting for drawn: adjustedForIme=" + adjustedForIme + " adjustedForDivider=" + adjustedForDivider + " mAdjustedForIme=" + this.mAdjustedForIme + " mAdjustedForDivider=" + this.mAdjustedForDivider);
                        }
                        this.notifyAdjustedForImeChanged(this.mAdjustedForIme || this.mAdjustedForDivider, duration);
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[1, 2] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                }
                WindowManagerService.resetPriorityAfterLockedSection();
            };
        } else {
            this.notifyAdjustedForImeChanged(adjustedForIme || adjustedForDivider, 280L);
        }
    }

    private boolean setMinimizedDockedStack(boolean minimized) {
        TaskStack stack = this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility();
        this.notifyDockedStackMinimizedChanged(minimized, false, this.isHomeStackResizable());
        return stack != null && stack.setAdjustedForMinimizedDock(minimized ? 1.0f : 0.0f);
    }

    private boolean isAnimationMaximizing() {
        return this.mAnimationTarget == 0.0f;
    }

    public boolean animate(long now) {
        if (this.mWindow == null) {
            return false;
        }
        if (this.mAnimatingForMinimizedDockedStack) {
            return this.animateForMinimizedDockedStack(now);
        }
        if (this.mAnimatingForIme) {
            return this.animateForIme(now);
        }
        return false;
    }

    private boolean animateForIme(long now) {
        if (!this.mAnimationStarted || this.mAnimationStartDelayed) {
            this.mAnimationStarted = true;
            this.mAnimationStartTime = now;
            this.mAnimationDuration = (long)(280.0f * this.mService.getWindowAnimationScaleLocked());
        }
        float t = Math.min(1.0f, (float)(now - this.mAnimationStartTime) / (float)this.mAnimationDuration);
        t = (this.mAnimationTarget == 1.0f ? IME_ADJUST_ENTRY_INTERPOLATOR : AppTransition.TOUCH_RESPONSE_INTERPOLATOR).getInterpolation(t);
        boolean updated = this.mDisplayContent.animateForIme(t, this.mAnimationTarget, this.mDividerAnimationTarget);
        if (updated) {
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
        }
        if (t >= 1.0f) {
            this.mLastAnimationProgress = this.mAnimationTarget;
            this.mLastDividerProgress = this.mDividerAnimationTarget;
            this.mAnimatingForIme = false;
            return false;
        }
        return true;
    }

    private boolean animateForMinimizedDockedStack(long now) {
        TaskStack stack = this.mDisplayContent.getSplitScreenPrimaryStackIgnoringVisibility();
        if (!this.mAnimationStarted) {
            this.mAnimationStarted = true;
            this.mAnimationStartTime = now;
            this.notifyDockedStackMinimizedChanged(this.mMinimizedDock, true, this.isHomeStackResizable());
        }
        float t = Math.min(1.0f, (float)(now - this.mAnimationStartTime) / (float)this.mAnimationDuration);
        t = (this.isAnimationMaximizing() ? AppTransition.TOUCH_RESPONSE_INTERPOLATOR : this.mMinimizedDockInterpolator).getInterpolation(t);
        if (stack != null && stack.setAdjustedForMinimizedDock(this.getMinimizeAmount(stack, t))) {
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
        }
        if (t >= 1.0f) {
            this.mAnimatingForMinimizedDockedStack = false;
            return false;
        }
        return true;
    }

    float getInterpolatedAnimationValue(float t) {
        return t * this.mAnimationTarget + (1.0f - t) * this.mAnimationStart;
    }

    float getInterpolatedDividerValue(float t) {
        return t * this.mDividerAnimationTarget + (1.0f - t) * this.mDividerAnimationStart;
    }

    private float getMinimizeAmount(TaskStack stack, float t) {
        float naturalAmount = this.getInterpolatedAnimationValue(t);
        if (this.isAnimationMaximizing()) {
            return this.adjustMaximizeAmount(stack, t, naturalAmount);
        }
        return naturalAmount;
    }

    private float adjustMaximizeAmount(TaskStack stack, float t, float naturalAmount) {
        if (this.mMaximizeMeetFraction == 1.0f) {
            return naturalAmount;
        }
        int minimizeDistance = stack.getMinimizeDistance();
        float startPrime = (float)this.mService.mAppTransition.getLastClipRevealMaxTranslation() / (float)minimizeDistance;
        float amountPrime = t * this.mAnimationTarget + (1.0f - t) * startPrime;
        float t2 = Math.min(t / this.mMaximizeMeetFraction, 1.0f);
        return amountPrime * t2 + naturalAmount * (1.0f - t2);
    }

    private float getClipRevealMeetFraction(TaskStack stack) {
        if (!this.isAnimationMaximizing() || stack == null || !this.mService.mAppTransition.hadClipRevealAnimation()) {
            return 1.0f;
        }
        int minimizeDistance = stack.getMinimizeDistance();
        float fraction2 = (float)Math.abs(this.mService.mAppTransition.getLastClipRevealMaxTranslation()) / (float)minimizeDistance;
        float t = Math.max(0.0f, Math.min(1.0f, (fraction2 - 0.4f) / 0.4f));
        return 0.6f + (1.0f - t) * 0.39999998f;
    }

    public String toShortString() {
        return TAG;
    }

    WindowState getWindow() {
        return this.mWindow;
    }

    void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + "DockedStackDividerController");
        pw.println(prefix + "  mLastVisibility=" + this.mLastVisibility);
        pw.println(prefix + "  mMinimizedDock=" + this.mMinimizedDock);
        pw.println(prefix + "  mAdjustedForIme=" + this.mAdjustedForIme);
        pw.println(prefix + "  mAdjustedForDivider=" + this.mAdjustedForDivider);
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10800000001L, this.mMinimizedDock);
        proto.end(token);
    }
}

