/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.WindowConfiguration;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import android.view.IRecentsAnimationController;
import android.view.IRecentsAnimationRunner;
import android.view.RemoteAnimationTarget;
import android.view.SurfaceControl;
import android.view.inputmethod.InputMethodManagerInternal;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.LocalServices;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.InputConsumerImpl;
import com.android.server.wm.SurfaceAnimator;
import com.android.server.wm.Task;
import com.android.server.wm.TaskSnapshotController;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.utils.InsetUtils;
import com.google.android.collect.Sets;
import java.io.PrintWriter;
import java.util.ArrayList;

public class RecentsAnimationController
implements IBinder.DeathRecipient {
    private static final String TAG = RecentsAnimationController.class.getSimpleName();
    private static final long FAILSAFE_DELAY = 1000L;
    public static final int REORDER_KEEP_IN_PLACE = 0;
    public static final int REORDER_MOVE_TO_TOP = 1;
    public static final int REORDER_MOVE_TO_ORIGINAL_POSITION = 2;
    private final WindowManagerService mService;
    private IRecentsAnimationRunner mRunner;
    private final RecentsAnimationCallbacks mCallbacks;
    private final ArrayList<TaskAnimationAdapter> mPendingAnimations = new ArrayList();
    private final int mDisplayId;
    private final Runnable mFailsafeRunnable = () -> this.cancelAnimation(2, "failSafeRunnable");
    private AppWindowToken mTargetAppToken;
    private Rect mMinimizedHomeBounds = new Rect();
    private boolean mPendingStart = true;
    private boolean mCanceled;
    private boolean mInputConsumerEnabled;
    private boolean mSplitScreenMinimized;
    private final Rect mTmpRect = new Rect();
    private boolean mLinkedToDeathOfRunner;
    private final IRecentsAnimationController mController = new IRecentsAnimationController.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public ActivityManager.TaskSnapshot screenshotTask(int taskId) {
            long token;
            block10: {
                ActivityManager.TaskSnapshot taskSnapshot;
                token = Binder.clearCallingIdentity();
                try {
                    Object object = RecentsAnimationController.this.mService.getWindowManagerLock();
                    // MONITORENTER : object
                    if (!RecentsAnimationController.this.mCanceled) break block10;
                    taskSnapshot = null;
                    // MONITOREXIT : object
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(token);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(token);
                return taskSnapshot;
            }
            int i = RecentsAnimationController.this.mPendingAnimations.size() - 1;
            while (true) {
                if (i < 0) {
                    ActivityManager.TaskSnapshot taskSnapshot = null;
                    // MONITOREXIT : object
                    Binder.restoreCallingIdentity(token);
                    return taskSnapshot;
                }
                TaskAnimationAdapter adapter = (TaskAnimationAdapter)RecentsAnimationController.this.mPendingAnimations.get(i);
                Task task = adapter.mTask;
                if (task.mTaskId == taskId) {
                    TaskSnapshotController snapshotController = ((RecentsAnimationController)RecentsAnimationController.this).mService.mTaskSnapshotController;
                    ArraySet<Task> tasks = Sets.newArraySet(task);
                    snapshotController.snapshotTasks(tasks);
                    snapshotController.addSkipClosingAppSnapshotTasks(tasks);
                    ActivityManager.TaskSnapshot taskSnapshot = snapshotController.getSnapshot(taskId, 0, false, false);
                    // MONITOREXIT : object
                    Binder.restoreCallingIdentity(token);
                    return taskSnapshot;
                }
                --i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void finish(boolean moveHomeToTop) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = RecentsAnimationController.this.mService.getWindowManagerLock();
                synchronized (object) {
                    if (RecentsAnimationController.this.mCanceled) {
                        return;
                    }
                }
                RecentsAnimationController.this.mCallbacks.onAnimationFinished(moveHomeToTop ? 1 : 2, true);
                return;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAnimationTargetsBehindSystemBars(boolean behindSystemBars) throws RemoteException {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = RecentsAnimationController.this.mService.getWindowManagerLock();
                synchronized (object) {
                    for (int i = RecentsAnimationController.this.mPendingAnimations.size() - 1; i >= 0; --i) {
                        ((TaskAnimationAdapter)RecentsAnimationController.this.mPendingAnimations.get(i)).mTask.setCanAffectSystemUiFlags(behindSystemBars);
                    }
                    ((RecentsAnimationController)RecentsAnimationController.this).mService.mWindowPlacerLocked.requestTraversal();
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setInputConsumerEnabled(boolean enabled) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = RecentsAnimationController.this.mService.getWindowManagerLock();
                synchronized (object) {
                    block8: {
                        if (!RecentsAnimationController.this.mCanceled) break block8;
                        return;
                    }
                    RecentsAnimationController.this.mInputConsumerEnabled = enabled;
                    ((RecentsAnimationController)RecentsAnimationController.this).mService.mInputMonitor.updateInputWindowsLw(true);
                    RecentsAnimationController.this.mService.scheduleAnimationLocked();
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSplitScreenMinimized(boolean minimized) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = RecentsAnimationController.this.mService.getWindowManagerLock();
                synchronized (object) {
                    block8: {
                        if (!RecentsAnimationController.this.mCanceled) break block8;
                        return;
                    }
                    RecentsAnimationController.this.mSplitScreenMinimized = minimized;
                    RecentsAnimationController.this.mService.checkSplitScreenMinimizedChanged(true);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hideCurrentInputMethod() {
            long token = Binder.clearCallingIdentity();
            try {
                InputMethodManagerInternal inputMethodManagerInternal = LocalServices.getService(InputMethodManagerInternal.class);
                if (inputMethodManagerInternal != null) {
                    inputMethodManagerInternal.hideCurrentInputMethod();
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    };

    RecentsAnimationController(WindowManagerService service, IRecentsAnimationRunner remoteAnimationRunner, RecentsAnimationCallbacks callbacks, int displayId) {
        this.mService = service;
        this.mRunner = remoteAnimationRunner;
        this.mCallbacks = callbacks;
        this.mDisplayId = displayId;
    }

    public void initialize(int targetActivityType, SparseBooleanArray recentTaskIds) {
        DisplayContent dc = this.mService.mRoot.getDisplayContent(this.mDisplayId);
        ArrayList<Task> visibleTasks = dc.getVisibleTasks();
        int taskCount = visibleTasks.size();
        for (int i = 0; i < taskCount; ++i) {
            Task task = visibleTasks.get(i);
            WindowConfiguration config = task.getWindowConfiguration();
            if (config.tasksAreFloating() || config.getWindowingMode() == 3 || config.getActivityType() == targetActivityType) continue;
            this.addAnimation(task, !recentTaskIds.get(task.mTaskId));
        }
        if (this.mPendingAnimations.isEmpty()) {
            this.cancelAnimation(2, "initialize-noVisibleTasks");
            return;
        }
        try {
            this.linkToDeathOfRunner();
        }
        catch (RemoteException e) {
            this.cancelAnimation(2, "initialize-failedToLinkToDeath");
            return;
        }
        AppWindowToken recentsComponentAppToken = ((Task)dc.getStack(0, targetActivityType).getTopChild()).getTopFullscreenAppToken();
        if (recentsComponentAppToken != null) {
            this.mTargetAppToken = recentsComponentAppToken;
            if (recentsComponentAppToken.windowsCanBeWallpaperTarget()) {
                dc.pendingLayoutChanges |= 4;
                dc.setLayoutNeeded();
            }
        }
        dc.getDockedDividerController().getHomeStackBoundsInDockedMode(this.mMinimizedHomeBounds);
        this.mService.mWindowPlacerLocked.performSurfacePlacement();
    }

    @VisibleForTesting
    AnimationAdapter addAnimation(Task task, boolean isRecentTaskInvisible) {
        SurfaceAnimator anim2 = new SurfaceAnimator(task, null, this.mService);
        TaskAnimationAdapter taskAdapter = new TaskAnimationAdapter(task, isRecentTaskInvisible);
        anim2.startAnimation(task.getPendingTransaction(), taskAdapter, false);
        task.commitPendingTransaction();
        this.mPendingAnimations.add(taskAdapter);
        return taskAdapter;
    }

    @VisibleForTesting
    void removeAnimation(TaskAnimationAdapter taskAdapter) {
        taskAdapter.mTask.setCanAffectSystemUiFlags(true);
        taskAdapter.mCapturedFinishCallback.onAnimationFinished(taskAdapter);
        this.mPendingAnimations.remove(taskAdapter);
    }

    void startAnimation() {
        if (!this.mPendingStart || this.mCanceled) {
            return;
        }
        try {
            ArrayList<RemoteAnimationTarget> appAnimations = new ArrayList<RemoteAnimationTarget>();
            for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
                TaskAnimationAdapter taskAdapter = this.mPendingAnimations.get(i);
                RemoteAnimationTarget target = taskAdapter.createRemoteAnimationApp();
                if (target != null) {
                    appAnimations.add(target);
                    continue;
                }
                this.removeAnimation(taskAdapter);
            }
            if (appAnimations.isEmpty()) {
                this.cancelAnimation(2, "startAnimation-noAppWindows");
                return;
            }
            RemoteAnimationTarget[] appTargets = appAnimations.toArray(new RemoteAnimationTarget[appAnimations.size()]);
            this.mPendingStart = false;
            Rect minimizedHomeBounds = this.mTargetAppToken != null && this.mTargetAppToken.inSplitScreenSecondaryWindowingMode() ? this.mMinimizedHomeBounds : null;
            Rect contentInsets = this.mTargetAppToken != null && this.mTargetAppToken.findMainWindow() != null ? this.mTargetAppToken.findMainWindow().mContentInsets : null;
            this.mRunner.onAnimationStart(this.mController, appTargets, contentInsets, minimizedHomeBounds);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to start recents animation", e);
        }
        SparseIntArray reasons = new SparseIntArray();
        reasons.put(1, 5);
        this.mService.mH.obtainMessage(47, reasons).sendToTarget();
    }

    void cancelAnimation(@ReorderMode int reorderMode, String reason) {
        this.cancelAnimation(reorderMode, false, reason);
    }

    void cancelAnimationSynchronously(@ReorderMode int reorderMode, String reason) {
        this.cancelAnimation(reorderMode, true, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAnimation(@ReorderMode int reorderMode, boolean runSynchronously, String reason) {
        Object object = this.mService.getWindowManagerLock();
        synchronized (object) {
            if (this.mCanceled) {
                return;
            }
            this.mService.mH.removeCallbacks(this.mFailsafeRunnable);
            this.mCanceled = true;
            try {
                this.mRunner.onAnimationCanceled();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to cancel recents animation", e);
            }
        }
        this.mCallbacks.onAnimationFinished(reorderMode, runSynchronously);
    }

    void cleanupAnimation(@ReorderMode int reorderMode) {
        for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
            TaskAnimationAdapter taskAdapter = this.mPendingAnimations.get(i);
            if (reorderMode == 1 || reorderMode == 0) {
                taskAdapter.mTask.dontAnimateDimExit();
            }
            this.removeAnimation(taskAdapter);
        }
        this.mService.mH.removeCallbacks(this.mFailsafeRunnable);
        this.unlinkToDeathOfRunner();
        this.mRunner = null;
        this.mCanceled = true;
        this.mService.mInputMonitor.updateInputWindowsLw(true);
        this.mService.destroyInputConsumer("recents_animation_input_consumer");
        if (this.mTargetAppToken != null && (reorderMode == 1 || reorderMode == 0)) {
            this.mService.mAppTransition.notifyAppTransitionFinishedLocked(this.mTargetAppToken.token);
        }
    }

    void scheduleFailsafe() {
        this.mService.mH.postDelayed(this.mFailsafeRunnable, 1000L);
    }

    private void linkToDeathOfRunner() throws RemoteException {
        if (!this.mLinkedToDeathOfRunner) {
            this.mRunner.asBinder().linkToDeath(this, 0);
            this.mLinkedToDeathOfRunner = true;
        }
    }

    private void unlinkToDeathOfRunner() {
        if (this.mLinkedToDeathOfRunner) {
            this.mRunner.asBinder().unlinkToDeath(this, 0);
            this.mLinkedToDeathOfRunner = false;
        }
    }

    @Override
    public void binderDied() {
        this.cancelAnimation(2, "binderDied");
    }

    void checkAnimationReady(WallpaperController wallpaperController) {
        if (this.mPendingStart) {
            boolean wallpaperReady;
            boolean bl = wallpaperReady = !this.isTargetOverWallpaper() || wallpaperController.getWallpaperTarget() != null && wallpaperController.wallpaperTransitionReady();
            if (wallpaperReady) {
                this.mService.getRecentsAnimationController().startAnimation();
            }
        }
    }

    boolean isSplitScreenMinimized() {
        return this.mSplitScreenMinimized;
    }

    boolean isWallpaperVisible(WindowState w) {
        return w != null && w.mAppToken != null && this.mTargetAppToken == w.mAppToken && this.isTargetOverWallpaper();
    }

    boolean hasInputConsumerForApp(AppWindowToken appToken) {
        return this.mInputConsumerEnabled && this.isAnimatingApp(appToken);
    }

    boolean updateInputConsumerForApp(InputConsumerImpl recentsAnimationInputConsumer, boolean hasFocus) {
        WindowState targetAppMainWindow;
        WindowState windowState = targetAppMainWindow = this.mTargetAppToken != null ? this.mTargetAppToken.findMainWindow() : null;
        if (targetAppMainWindow != null) {
            targetAppMainWindow.getBounds(this.mTmpRect);
            recentsAnimationInputConsumer.mWindowHandle.hasFocus = hasFocus;
            recentsAnimationInputConsumer.mWindowHandle.touchableRegion.set(this.mTmpRect);
            return true;
        }
        return false;
    }

    boolean isTargetApp(AppWindowToken token) {
        return this.mTargetAppToken != null && token == this.mTargetAppToken;
    }

    private boolean isTargetOverWallpaper() {
        if (this.mTargetAppToken == null) {
            return false;
        }
        return this.mTargetAppToken.windowsCanBeWallpaperTarget();
    }

    boolean isAnimatingTask(Task task) {
        for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
            if (task != this.mPendingAnimations.get(i).mTask) continue;
            return true;
        }
        return false;
    }

    private boolean isAnimatingApp(AppWindowToken appToken) {
        for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
            Task task = this.mPendingAnimations.get(i).mTask;
            for (int j = task.getChildCount() - 1; j >= 0; --j) {
                AppWindowToken app = (AppWindowToken)task.getChildAt(j);
                if (app != appToken) continue;
                return true;
            }
        }
        return false;
    }

    public void dump(PrintWriter pw, String prefix) {
        String innerPrefix = prefix + "  ";
        pw.print(prefix);
        pw.println(RecentsAnimationController.class.getSimpleName() + ":");
        pw.print(innerPrefix);
        pw.println("mPendingStart=" + this.mPendingStart);
        pw.print(innerPrefix);
        pw.println("mCanceled=" + this.mCanceled);
        pw.print(innerPrefix);
        pw.println("mInputConsumerEnabled=" + this.mInputConsumerEnabled);
        pw.print(innerPrefix);
        pw.println("mSplitScreenMinimized=" + this.mSplitScreenMinimized);
        pw.print(innerPrefix);
        pw.println("mTargetAppToken=" + this.mTargetAppToken);
        pw.print(innerPrefix);
        pw.println("isTargetOverWallpaper=" + this.isTargetOverWallpaper());
    }

    @VisibleForTesting
    class TaskAnimationAdapter
    implements AnimationAdapter {
        private final Task mTask;
        private SurfaceControl mCapturedLeash;
        private SurfaceAnimator.OnAnimationFinishedCallback mCapturedFinishCallback;
        private final boolean mIsRecentTaskInvisible;
        private RemoteAnimationTarget mTarget;
        private final Point mPosition = new Point();
        private final Rect mBounds = new Rect();

        TaskAnimationAdapter(Task task, boolean isRecentTaskInvisible) {
            this.mTask = task;
            this.mIsRecentTaskInvisible = isRecentTaskInvisible;
            WindowContainer container = this.mTask.getParent();
            container.getRelativePosition(this.mPosition);
            container.getBounds(this.mBounds);
        }

        RemoteAnimationTarget createRemoteAnimationApp() {
            WindowState mainWindow;
            AppWindowToken topApp = this.mTask.getTopVisibleAppToken();
            WindowState windowState = mainWindow = topApp != null ? topApp.findMainWindow() : null;
            if (mainWindow == null) {
                return null;
            }
            Rect insets = new Rect(mainWindow.mContentInsets);
            InsetUtils.addInsets(insets, mainWindow.mAppToken.getLetterboxInsets());
            this.mTarget = new RemoteAnimationTarget(this.mTask.mTaskId, 1, this.mCapturedLeash, !topApp.fillsParent(), mainWindow.mWinAnimator.mLastClipRect, insets, this.mTask.getPrefixOrderIndex(), this.mPosition, this.mBounds, this.mTask.getWindowConfiguration(), this.mIsRecentTaskInvisible);
            return this.mTarget;
        }

        @Override
        public boolean getDetachWallpaper() {
            return false;
        }

        @Override
        public boolean getShowWallpaper() {
            return false;
        }

        @Override
        public int getBackgroundColor() {
            return 0;
        }

        @Override
        public void startAnimation(SurfaceControl animationLeash, SurfaceControl.Transaction t, SurfaceAnimator.OnAnimationFinishedCallback finishCallback) {
            t.setLayer(animationLeash, this.mTask.getPrefixOrderIndex());
            t.setPosition(animationLeash, this.mPosition.x, this.mPosition.y);
            RecentsAnimationController.this.mTmpRect.set(this.mBounds);
            RecentsAnimationController.this.mTmpRect.offsetTo(0, 0);
            t.setWindowCrop(animationLeash, RecentsAnimationController.this.mTmpRect);
            this.mCapturedLeash = animationLeash;
            this.mCapturedFinishCallback = finishCallback;
        }

        @Override
        public void onAnimationCancelled(SurfaceControl animationLeash) {
            RecentsAnimationController.this.cancelAnimation(2, "taskAnimationAdapterCanceled");
        }

        @Override
        public long getDurationHint() {
            return 0L;
        }

        @Override
        public long getStatusBarTransitionsStartTime() {
            return SystemClock.uptimeMillis();
        }

        @Override
        public void dump(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("task=" + this.mTask);
            if (this.mTarget != null) {
                pw.print(prefix);
                pw.println("Target:");
                this.mTarget.dump(pw, prefix + "  ");
            } else {
                pw.print(prefix);
                pw.println("Target: null");
            }
            pw.println("mIsRecentTaskInvisible=" + this.mIsRecentTaskInvisible);
            pw.println("mPosition=" + this.mPosition);
            pw.println("mBounds=" + this.mBounds);
            pw.println("mIsRecentTaskInvisible=" + this.mIsRecentTaskInvisible);
        }

        @Override
        public void writeToProto(ProtoOutputStream proto) {
            long token = proto.start(1146756268034L);
            if (this.mTarget != null) {
                this.mTarget.writeToProto(proto, 0x10B00000001L);
            }
            proto.end(token);
        }
    }

    public static interface RecentsAnimationCallbacks {
        public void onAnimationFinished(@ReorderMode int var1, boolean var2);
    }

    public static @interface ReorderMode {
    }
}

