/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.SurfaceControl;
import android.view.WindowManager;
import com.android.internal.util.ArrayUtils;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplayWindowController;
import com.android.server.wm.RecentsAnimationController;
import com.android.server.wm.Session;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TaskTapPointerEventListener;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowSurfaceController;
import com.android.server.wm.WindowSurfacePlacer;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

class RootWindowContainer
extends WindowContainer<DisplayContent> {
    private static final String TAG = "WindowManager";
    private static final int SET_SCREEN_BRIGHTNESS_OVERRIDE = 1;
    private static final int SET_USER_ACTIVITY_TIMEOUT = 2;
    private boolean mWallpaperForceHidingChanged = false;
    private Object mLastWindowFreezeSource = null;
    private Session mHoldScreen = null;
    private float mScreenBrightness = -1.0f;
    private long mUserActivityTimeout = -1L;
    private boolean mUpdateRotation = false;
    WindowState mHoldScreenWindow = null;
    WindowState mObscuringWindow = null;
    private boolean mObscureApplicationContentOnSecondaryDisplays = false;
    private boolean mSustainedPerformanceModeEnabled = false;
    private boolean mSustainedPerformanceModeCurrent = false;
    boolean mWallpaperMayChange = false;
    boolean mOrientationChangeComplete = true;
    boolean mWallpaperActionPending = false;
    private final ArrayList<TaskStack> mTmpStackList = new ArrayList();
    private final ArrayList<Integer> mTmpStackIds = new ArrayList();
    final WallpaperController mWallpaperController;
    private final Handler mHandler;
    private String mCloseSystemDialogsReason;
    private final SurfaceControl.Transaction mDisplayTransaction = new SurfaceControl.Transaction();
    private final Consumer<WindowState> mCloseSystemDialogsConsumer = w -> {
        if (w.mHasSurface) {
            try {
                w.mClient.closeSystemDialogs(this.mCloseSystemDialogsReason);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    };
    private static final Consumer<WindowState> sRemoveReplacedWindowsConsumer = w -> {
        AppWindowToken aToken = w.mAppToken;
        if (aToken != null) {
            aToken.removeReplacedWindowIfNeeded((WindowState)w);
        }
    };

    RootWindowContainer(WindowManagerService service) {
        super(service);
        this.mHandler = new MyHandler(service.mH.getLooper());
        this.mWallpaperController = new WallpaperController(this.mService);
    }

    WindowState computeFocusedWindow() {
        boolean forceDefaultDisplay = this.mService.isKeyguardShowingAndNotOccluded();
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(i);
            WindowState win = dc.findFocusedWindow();
            if (win == null) continue;
            if (forceDefaultDisplay && !dc.isDefaultDisplay) {
                EventLog.writeEvent(1397638484, "71786287", win.mOwnerUid, "");
                continue;
            }
            return win;
        }
        return null;
    }

    void getDisplaysInFocusOrder(SparseIntArray displaysInFocusOrder) {
        displaysInFocusOrder.clear();
        int size = this.mChildren.size();
        for (int i = 0; i < size; ++i) {
            DisplayContent displayContent = (DisplayContent)this.mChildren.get(i);
            if (displayContent.isRemovalDeferred()) continue;
            displaysInFocusOrder.put(i, displayContent.getDisplayId());
        }
    }

    DisplayContent getDisplayContent(int displayId) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent current = (DisplayContent)this.mChildren.get(i);
            if (current.getDisplayId() != displayId) continue;
            return current;
        }
        return null;
    }

    DisplayContent createDisplayContent(Display display, DisplayWindowController controller) {
        int displayId = display.getDisplayId();
        DisplayContent existing = this.getDisplayContent(displayId);
        if (existing != null) {
            existing.setController(controller);
            return existing;
        }
        DisplayContent dc = new DisplayContent(display, this.mService, this.mWallpaperController, controller);
        DisplayInfo displayInfo = dc.getDisplayInfo();
        Rect rect = new Rect();
        this.mService.mDisplaySettings.getOverscanLocked(displayInfo.name, displayInfo.uniqueId, rect);
        displayInfo.overscanLeft = rect.left;
        displayInfo.overscanTop = rect.top;
        displayInfo.overscanRight = rect.right;
        displayInfo.overscanBottom = rect.bottom;
        if (this.mService.mDisplayManagerInternal != null) {
            this.mService.mDisplayManagerInternal.setDisplayInfoOverrideFromWindowManager(displayId, displayInfo);
            dc.configureDisplayPolicy();
            if (this.mService.canDispatchPointerEvents()) {
                dc.mTapDetector = new TaskTapPointerEventListener(this.mService, dc);
                this.mService.registerPointerEventListener(dc.mTapDetector);
                if (displayId == 0) {
                    this.mService.registerPointerEventListener(this.mService.mMousePositionTracker);
                }
            }
        }
        return dc;
    }

    boolean isLayoutNeeded() {
        int numDisplays = this.mChildren.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = (DisplayContent)this.mChildren.get(displayNdx);
            if (!displayContent.isLayoutNeeded()) continue;
            return true;
        }
        return false;
    }

    void getWindowsByName(ArrayList<WindowState> output, String name) {
        int objectId = 0;
        try {
            objectId = Integer.parseInt(name, 16);
            name = null;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.getWindowsByName(output, name, objectId);
    }

    private void getWindowsByName(ArrayList<WindowState> output, String name, int objectId) {
        this.forAllWindows((WindowState w) -> {
            if (name != null) {
                if (w.mAttrs.getTitle().toString().contains(name)) {
                    output.add((WindowState)w);
                }
            } else if (System.identityHashCode(w) == objectId) {
                output.add((WindowState)w);
            }
        }, true);
    }

    AppWindowToken getAppWindowToken(IBinder binder) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(i);
            AppWindowToken atoken = dc.getAppWindowToken(binder);
            if (atoken == null) continue;
            return atoken;
        }
        return null;
    }

    DisplayContent getWindowTokenDisplay(WindowToken token) {
        if (token == null) {
            return null;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(i);
            WindowToken current = dc.getWindowToken(token.token);
            if (current != token) continue;
            return dc;
        }
        return null;
    }

    int[] setDisplayOverrideConfigurationIfNeeded(Configuration newConfiguration, int displayId) {
        boolean configChanged;
        DisplayContent displayContent = this.getDisplayContent(displayId);
        if (displayContent == null) {
            throw new IllegalArgumentException("Display not found for id: " + displayId);
        }
        Configuration currentConfig = displayContent.getOverrideConfiguration();
        boolean bl = configChanged = currentConfig.diff(newConfiguration) != 0;
        if (!configChanged) {
            return null;
        }
        displayContent.onOverrideConfigurationChanged(newConfiguration);
        this.mTmpStackList.clear();
        if (displayId == 0) {
            this.setGlobalConfigurationIfNeeded(newConfiguration, this.mTmpStackList);
        } else {
            this.updateStackBoundsAfterConfigChange(displayId, this.mTmpStackList);
        }
        this.mTmpStackIds.clear();
        int stackCount = this.mTmpStackList.size();
        for (int i = 0; i < stackCount; ++i) {
            TaskStack stack = this.mTmpStackList.get(i);
            if (stack.mDeferRemoval) continue;
            this.mTmpStackIds.add(stack.mStackId);
        }
        return this.mTmpStackIds.isEmpty() ? null : ArrayUtils.convertToIntArray(this.mTmpStackIds);
    }

    private void setGlobalConfigurationIfNeeded(Configuration newConfiguration, List<TaskStack> changedStacks) {
        boolean configChanged;
        boolean bl = configChanged = this.getConfiguration().diff(newConfiguration) != 0;
        if (!configChanged) {
            return;
        }
        this.onConfigurationChanged(newConfiguration);
        this.updateStackBoundsAfterConfigChange(changedStacks);
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        this.prepareFreezingTaskBounds();
        super.onConfigurationChanged(newParentConfig);
        this.mService.mPolicy.onConfigurationChanged();
    }

    private void updateStackBoundsAfterConfigChange(List<TaskStack> changedStacks) {
        int numDisplays = this.mChildren.size();
        for (int i = 0; i < numDisplays; ++i) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(i);
            dc.updateStackBoundsAfterConfigChange(changedStacks);
        }
    }

    private void updateStackBoundsAfterConfigChange(int displayId, List<TaskStack> changedStacks) {
        DisplayContent dc = this.getDisplayContent(displayId);
        dc.updateStackBoundsAfterConfigChange(changedStacks);
    }

    private void prepareFreezingTaskBounds() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((DisplayContent)this.mChildren.get(i)).prepareFreezingTaskBounds();
        }
    }

    TaskStack getStack(int windowingMode, int activityType) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(i);
            TaskStack stack = dc.getStack(windowingMode, activityType);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    void setSecureSurfaceState(int userId, boolean disabled) {
        this.forAllWindows((WindowState w) -> {
            if (w.mHasSurface && userId == UserHandle.getUserId(w.mOwnerUid)) {
                w.mWinAnimator.setSecureLocked(disabled);
            }
        }, true);
    }

    void updateHiddenWhileSuspendedState(ArraySet<String> packages, boolean suspended) {
        this.forAllWindows((WindowState w) -> {
            if (packages.contains(w.getOwningPackage())) {
                w.setHiddenWhileSuspended(suspended);
            }
        }, false);
    }

    void updateAppOpsState() {
        this.forAllWindows((WindowState w) -> w.updateAppOpsState(), false);
    }

    boolean canShowStrictModeViolation(int pid) {
        WindowState win = this.getWindow(w -> w.mSession.mPid == pid && w.isVisibleLw());
        return win != null;
    }

    void closeSystemDialogs(String reason) {
        this.mCloseSystemDialogsReason = reason;
        this.forAllWindows(this.mCloseSystemDialogsConsumer, false);
    }

    void removeReplacedWindows() {
        this.mService.openSurfaceTransaction();
        try {
            this.forAllWindows(sRemoveReplacedWindowsConsumer, true);
        }
        finally {
            this.mService.closeSurfaceTransaction("removeReplacedWindows");
        }
    }

    boolean hasPendingLayoutChanges(WindowAnimator animator2) {
        boolean hasChanges = false;
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(i);
            int pendingChanges = animator2.getPendingLayoutChanges(dc.getDisplayId());
            if ((pendingChanges & 4) != 0) {
                animator2.mBulkUpdateParams |= 0x10;
            }
            if (pendingChanges == 0) continue;
            hasChanges = true;
        }
        return hasChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reclaimSomeSurfaceMemory(WindowStateAnimator winAnimator, String operation, boolean secure) {
        WindowSurfaceController surfaceController = winAnimator.mSurfaceController;
        boolean leakedSurface = false;
        boolean killedApps = false;
        EventLog.writeEvent(31000, winAnimator.mWin.toString(), winAnimator.mSession.mPid, operation);
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            Slog.i(TAG, "Out of memory for surface!  Looking for leaks...");
            int numDisplays = this.mChildren.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                leakedSurface |= ((DisplayContent)this.mChildren.get(displayNdx)).destroyLeakedSurfaces();
            }
            if (!leakedSurface) {
                Slog.w(TAG, "No leaked surfaces; killing applications!");
                SparseIntArray pidCandidates = new SparseIntArray();
                for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    ((DisplayContent)this.mChildren.get(displayNdx)).forAllWindows((WindowState w) -> {
                        if (this.mService.mForceRemoves.contains(w)) {
                            return;
                        }
                        WindowStateAnimator wsa = w.mWinAnimator;
                        if (wsa.mSurfaceController != null) {
                            pidCandidates.append(wsa.mSession.mPid, wsa.mSession.mPid);
                        }
                    }, false);
                    if (pidCandidates.size() <= 0) continue;
                    int[] pids = new int[pidCandidates.size()];
                    for (int i = 0; i < pids.length; ++i) {
                        pids[i] = pidCandidates.keyAt(i);
                    }
                    try {
                        if (!this.mService.mActivityManager.killPids(pids, "Free memory", secure)) continue;
                        killedApps = true;
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            if (leakedSurface || killedApps) {
                Slog.w(TAG, "Looks like we have reclaimed some memory, clearing surface for retry.");
                if (surfaceController != null) {
                    winAnimator.destroySurface();
                    if (winAnimator.mWin.mAppToken != null && winAnimator.mWin.mAppToken.getController() != null) {
                        winAnimator.mWin.mAppToken.getController().removeStartingWindow();
                    }
                }
                try {
                    winAnimator.mWin.mClient.dispatchGetNewSurface();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return leakedSurface || killedApps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performSurfacePlacement(boolean recoveringMemory) {
        int N;
        DisplayContent displayContent;
        int displayNdx;
        RecentsAnimationController recentsAnimationController;
        boolean updateInputWindowsNeeded = false;
        if (this.mService.mFocusMayChange) {
            this.mService.mFocusMayChange = false;
            updateInputWindowsNeeded = this.mService.updateFocusedWindowLocked(3, false);
        }
        int numDisplays = this.mChildren.size();
        for (int displayNdx2 = 0; displayNdx2 < numDisplays; ++displayNdx2) {
            DisplayContent displayContent2 = (DisplayContent)this.mChildren.get(displayNdx2);
            displayContent2.setExitingTokensHasVisible(false);
        }
        this.mHoldScreen = null;
        this.mScreenBrightness = -1.0f;
        this.mUserActivityTimeout = -1L;
        this.mObscureApplicationContentOnSecondaryDisplays = false;
        this.mSustainedPerformanceModeCurrent = false;
        ++this.mService.mTransactionSequence;
        DisplayContent defaultDisplay = this.mService.getDefaultDisplayContentLocked();
        DisplayInfo defaultInfo = defaultDisplay.getDisplayInfo();
        int defaultDw = defaultInfo.logicalWidth;
        int defaultDh = defaultInfo.logicalHeight;
        this.mService.openSurfaceTransaction();
        try {
            this.applySurfaceChangesTransaction(recoveringMemory, defaultDw, defaultDh);
        }
        catch (RuntimeException e) {
            Slog.wtf(TAG, "Unhandled exception in Window Manager", e);
        }
        finally {
            this.mService.closeSurfaceTransaction("performLayoutAndPlaceSurfaces");
        }
        this.mService.mAnimator.executeAfterPrepareSurfacesRunnables();
        WindowSurfacePlacer surfacePlacer = this.mService.mWindowPlacerLocked;
        if (this.mService.mAppTransition.isReady()) {
            int layoutChanges = surfacePlacer.handleAppTransitionReadyLocked();
            defaultDisplay.pendingLayoutChanges |= layoutChanges;
        }
        if (!this.isAppAnimating() && this.mService.mAppTransition.isRunning()) {
            defaultDisplay.pendingLayoutChanges |= this.mService.handleAnimatingStoppedAndTransitionLocked();
        }
        if ((recentsAnimationController = this.mService.getRecentsAnimationController()) != null) {
            recentsAnimationController.checkAnimationReady(this.mWallpaperController);
        }
        if (this.mWallpaperForceHidingChanged && defaultDisplay.pendingLayoutChanges == 0 && !this.mService.mAppTransition.isReady()) {
            defaultDisplay.pendingLayoutChanges |= 1;
        }
        this.mWallpaperForceHidingChanged = false;
        if (this.mWallpaperMayChange) {
            defaultDisplay.pendingLayoutChanges |= 4;
        }
        if (this.mService.mFocusMayChange) {
            this.mService.mFocusMayChange = false;
            if (this.mService.updateFocusedWindowLocked(2, false)) {
                updateInputWindowsNeeded = true;
                defaultDisplay.pendingLayoutChanges |= 8;
            }
        }
        if (this.isLayoutNeeded()) {
            defaultDisplay.pendingLayoutChanges |= 1;
        }
        ArraySet<DisplayContent> touchExcludeRegionUpdateDisplays = this.handleResizingWindows();
        if (this.mOrientationChangeComplete) {
            if (this.mService.mWindowsFreezingScreen != 0) {
                this.mService.mWindowsFreezingScreen = 0;
                this.mService.mLastFinishedFreezeSource = this.mLastWindowFreezeSource;
                this.mService.mH.removeMessages(11);
            }
            this.mService.stopFreezingDisplayLocked();
        }
        boolean wallpaperDestroyed = false;
        int i = this.mService.mDestroySurface.size();
        if (i > 0) {
            do {
                WindowState win = this.mService.mDestroySurface.get(--i);
                win.mDestroying = false;
                if (this.mService.mInputMethodWindow == win) {
                    this.mService.setInputMethodWindowLocked(null);
                }
                if (win.getDisplayContent().mWallpaperController.isWallpaperTarget(win)) {
                    wallpaperDestroyed = true;
                }
                win.destroySurfaceUnchecked();
                win.mWinAnimator.destroyPreservedSurfaceLocked();
            } while (i > 0);
            this.mService.mDestroySurface.clear();
        }
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            displayContent = (DisplayContent)this.mChildren.get(displayNdx);
            displayContent.removeExistingTokensIfPossible();
        }
        if (wallpaperDestroyed) {
            defaultDisplay.pendingLayoutChanges |= 4;
            defaultDisplay.setLayoutNeeded();
        }
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            displayContent = (DisplayContent)this.mChildren.get(displayNdx);
            if (displayContent.pendingLayoutChanges == 0) continue;
            displayContent.setLayoutNeeded();
        }
        this.mService.mInputMonitor.updateInputWindowsLw(true);
        this.mService.setHoldScreenLocked(this.mHoldScreen);
        if (!this.mService.mDisplayFrozen) {
            int brightness = this.mScreenBrightness < 0.0f || this.mScreenBrightness > 1.0f ? -1 : RootWindowContainer.toBrightnessOverride(this.mScreenBrightness);
            this.mHandler.obtainMessage(1, brightness, 0).sendToTarget();
            this.mHandler.obtainMessage(2, this.mUserActivityTimeout).sendToTarget();
        }
        if (this.mSustainedPerformanceModeCurrent != this.mSustainedPerformanceModeEnabled) {
            this.mSustainedPerformanceModeEnabled = this.mSustainedPerformanceModeCurrent;
            this.mService.mPowerManagerInternal.powerHint(6, this.mSustainedPerformanceModeEnabled ? 1 : 0);
        }
        if (this.mUpdateRotation) {
            DisplayContent vrDisplay;
            int displayId = defaultDisplay.getDisplayId();
            if (defaultDisplay.updateRotationUnchecked()) {
                this.mService.mH.obtainMessage(18, displayId).sendToTarget();
            } else {
                this.mUpdateRotation = false;
            }
            DisplayContent displayContent3 = vrDisplay = this.mService.mVr2dDisplayId != -1 ? this.getDisplayContent(this.mService.mVr2dDisplayId) : null;
            if (vrDisplay != null && vrDisplay.updateRotationUnchecked()) {
                this.mService.mH.obtainMessage(18, this.mService.mVr2dDisplayId).sendToTarget();
            }
        }
        if (this.mService.mWaitingForDrawnCallback != null || this.mOrientationChangeComplete && !defaultDisplay.isLayoutNeeded() && !this.mUpdateRotation) {
            this.mService.checkDrawnWindowsLocked();
        }
        if ((N = this.mService.mPendingRemove.size()) > 0) {
            if (this.mService.mPendingRemoveTmp.length < N) {
                this.mService.mPendingRemoveTmp = new WindowState[N + 10];
            }
            this.mService.mPendingRemove.toArray(this.mService.mPendingRemoveTmp);
            this.mService.mPendingRemove.clear();
            ArrayList<DisplayContent> displayList = new ArrayList<DisplayContent>();
            for (i = 0; i < N; ++i) {
                WindowState w = this.mService.mPendingRemoveTmp[i];
                w.removeImmediately();
                DisplayContent displayContent4 = w.getDisplayContent();
                if (displayContent4 == null || displayList.contains(displayContent4)) continue;
                displayList.add(displayContent4);
            }
            for (int j = displayList.size() - 1; j >= 0; --j) {
                DisplayContent dc = (DisplayContent)displayList.get(j);
                dc.assignWindowLayers(true);
            }
        }
        for (int displayNdx3 = this.mChildren.size() - 1; displayNdx3 >= 0; --displayNdx3) {
            ((DisplayContent)this.mChildren.get(displayNdx3)).checkCompleteDeferredRemoval();
        }
        if (updateInputWindowsNeeded) {
            this.mService.mInputMonitor.updateInputWindowsLw(false);
        }
        this.mService.setFocusTaskRegionLocked(null);
        if (touchExcludeRegionUpdateDisplays != null) {
            DisplayContent focusedDc = this.mService.mFocusedApp != null ? this.mService.mFocusedApp.getDisplayContent() : null;
            for (DisplayContent dc : touchExcludeRegionUpdateDisplays) {
                if (focusedDc == dc) continue;
                dc.setTouchExcludeRegion(null);
            }
        }
        this.mService.enableScreenIfNeededLocked();
        this.mService.scheduleAnimationLocked();
    }

    private void applySurfaceChangesTransaction(boolean recoveringMemory, int defaultDw, int defaultDh) {
        this.mHoldScreenWindow = null;
        this.mObscuringWindow = null;
        if (this.mService.mWatermark != null) {
            this.mService.mWatermark.positionSurface(defaultDw, defaultDh);
        }
        if (this.mService.mStrictModeFlash != null) {
            this.mService.mStrictModeFlash.positionSurface(defaultDw, defaultDh);
        }
        if (this.mService.mCircularDisplayMask != null) {
            this.mService.mCircularDisplayMask.positionSurface(defaultDw, defaultDh, this.mService.getDefaultDisplayRotation());
        }
        if (this.mService.mEmulatorDisplayOverlay != null) {
            this.mService.mEmulatorDisplayOverlay.positionSurface(defaultDw, defaultDh, this.mService.getDefaultDisplayRotation());
        }
        boolean focusDisplayed = false;
        int count = this.mChildren.size();
        for (int j = 0; j < count; ++j) {
            DisplayContent dc = (DisplayContent)this.mChildren.get(j);
            focusDisplayed |= dc.applySurfaceChangesTransaction(recoveringMemory);
        }
        if (focusDisplayed) {
            this.mService.mH.sendEmptyMessage(3);
        }
        this.mService.mDisplayManagerInternal.performTraversal(this.mDisplayTransaction);
        SurfaceControl.mergeToGlobalTransaction(this.mDisplayTransaction);
    }

    private ArraySet<DisplayContent> handleResizingWindows() {
        ArraySet<DisplayContent> touchExcludeRegionUpdateSet = null;
        for (int i = this.mService.mResizingWindows.size() - 1; i >= 0; --i) {
            WindowState win = this.mService.mResizingWindows.get(i);
            if (win.mAppFreezing) continue;
            win.reportResized();
            this.mService.mResizingWindows.remove(i);
            if (!WindowManagerService.excludeWindowTypeFromTapOutTask(win.mAttrs.type)) continue;
            DisplayContent dc = win.getDisplayContent();
            if (touchExcludeRegionUpdateSet == null) {
                touchExcludeRegionUpdateSet = new ArraySet<DisplayContent>();
            }
            touchExcludeRegionUpdateSet.add(dc);
        }
        return touchExcludeRegionUpdateSet;
    }

    boolean handleNotObscuredLocked(WindowState w, boolean obscured, boolean syswin) {
        WindowManager.LayoutParams attrs = w.mAttrs;
        int attrFlags = attrs.flags;
        boolean onScreen = w.isOnScreen();
        boolean canBeSeen = w.isDisplayedLw();
        int privateflags = attrs.privateFlags;
        boolean displayHasContent = false;
        if (w.mHasSurface && onScreen && !syswin && w.mAttrs.userActivityTimeout >= 0L && this.mUserActivityTimeout < 0L) {
            this.mUserActivityTimeout = w.mAttrs.userActivityTimeout;
        }
        if (w.mHasSurface && canBeSeen) {
            if ((attrFlags & 0x80) != 0) {
                this.mHoldScreen = w.mSession;
                this.mHoldScreenWindow = w;
            }
            if (!syswin && w.mAttrs.screenBrightness >= 0.0f && this.mScreenBrightness < 0.0f) {
                this.mScreenBrightness = w.mAttrs.screenBrightness;
            }
            int type = attrs.type;
            DisplayContent displayContent = w.getDisplayContent();
            if (displayContent != null && displayContent.isDefaultDisplay) {
                if (type == 2023 || (attrs.privateFlags & 0x400) != 0) {
                    this.mObscureApplicationContentOnSecondaryDisplays = true;
                }
                displayHasContent = true;
            } else if (displayContent != null && (!this.mObscureApplicationContentOnSecondaryDisplays || obscured && type == 2009)) {
                displayHasContent = true;
            }
            if ((privateflags & 0x40000) != 0) {
                this.mSustainedPerformanceModeCurrent = true;
            }
        }
        return displayHasContent;
    }

    boolean copyAnimToLayoutParams() {
        boolean doRequest = false;
        int bulkUpdateParams = this.mService.mAnimator.mBulkUpdateParams;
        if ((bulkUpdateParams & 1) != 0) {
            this.mUpdateRotation = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 2) != 0) {
            this.mWallpaperMayChange = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 4) != 0) {
            this.mWallpaperForceHidingChanged = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 8) == 0) {
            this.mOrientationChangeComplete = false;
        } else {
            this.mOrientationChangeComplete = true;
            this.mLastWindowFreezeSource = this.mService.mAnimator.mLastWindowFreezeSource;
            if (this.mService.mWindowsFreezingScreen != 0) {
                doRequest = true;
            }
        }
        if ((bulkUpdateParams & 0x10) != 0) {
            this.mWallpaperActionPending = true;
        }
        return doRequest;
    }

    private static int toBrightnessOverride(float value) {
        return (int)(value * 255.0f);
    }

    void dumpDisplayContents(PrintWriter pw) {
        pw.println("WINDOW MANAGER DISPLAY CONTENTS (dumpsys window displays)");
        if (this.mService.mDisplayReady) {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                DisplayContent displayContent = (DisplayContent)this.mChildren.get(i);
                displayContent.dump(pw, "  ", true);
            }
        } else {
            pw.println("  NO DISPLAY");
        }
    }

    void dumpLayoutNeededDisplayIds(PrintWriter pw) {
        if (!this.isLayoutNeeded()) {
            return;
        }
        pw.print("  mLayoutNeeded on displays=");
        int count = this.mChildren.size();
        for (int displayNdx = 0; displayNdx < count; ++displayNdx) {
            DisplayContent displayContent = (DisplayContent)this.mChildren.get(displayNdx);
            if (!displayContent.isLayoutNeeded()) continue;
            pw.print(displayContent.getDisplayId());
        }
        pw.println();
    }

    void dumpWindowsNoHeader(PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        int[] index = new int[1];
        this.forAllWindows((WindowState w) -> {
            if (windows == null || windows.contains(w)) {
                pw.println("  Window #" + index[0] + " " + w + ":");
                w.dump(pw, "    ", dumpAll || windows != null);
                index[0] = index[0] + 1;
            }
        }, true);
    }

    void dumpTokens(PrintWriter pw, boolean dumpAll) {
        pw.println("  All tokens:");
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((DisplayContent)this.mChildren.get(i)).dumpTokens(pw, dumpAll);
        }
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, boolean trim) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, trim);
        if (this.mService.mDisplayReady) {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                DisplayContent displayContent = (DisplayContent)this.mChildren.get(i);
                displayContent.writeToProto(proto, 0x20B00000002L, trim);
            }
        }
        if (!trim) {
            this.forAllWindows((WindowState w) -> w.writeIdentifierToProto(proto, 2246267895811L), true);
        }
        proto.end(token);
    }

    @Override
    String getName() {
        return "ROOT";
    }

    @Override
    void scheduleAnimation() {
        this.mService.scheduleAnimationLocked();
    }

    private final class MyHandler
    extends Handler {
        public MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    RootWindowContainer.this.mService.mPowerManagerInternal.setScreenBrightnessOverrideFromWindowManager(msg.arg1);
                    break;
                }
                case 2: {
                    RootWindowContainer.this.mService.mPowerManagerInternal.setUserActivityTimeoutOverrideFromWindowManager((Long)msg.obj);
                    break;
                }
            }
        }
    }
}

